# McStas configuration options
#
# In this file, you can set up configuration options
# used by the McStas perl tools.
#
# CFLAGS   - compiler flags (should not require changes)
# LDFLAGS  - linker flags (should not require changes)
# CC       - c compiler command (should not requrire changes)
# TERMINAL - (Unix only) Command to launch mcplot with (xterm/konsole/...)
# PGPLOT   - location of PGPLOT
# TCLTK    - location of TCLTK
# PLOTTER  - Choice of default plotting backend, possible values:
#            - PGPLOT (Unix only)
#            - Matlab (Unix / Win32)
#            - Matlab scriptfile (Unix / Win32)
#            - Scilab (Unix only)
#            - Scilab scriptfile (Unix / Win32)
# EDITOR   - Choice of default built-in editor
#            0 - McStas 1.7 editor (simple, no extra perl modules req'd)
#            1 - CodeText editor with highlighting of McStas instrument code
#            2 - Default to external editor
# EXTERNAL_EDITOR - default external editor, overriden by VISUAL or EDITOR variables
# BROWSER  - Default BROWSER, overriden by BROWSER variable
# VRMLVIEW - Default VRML BROWSER, overriden by VRMLVIEW variable
# PREFIX   - Prefix for commands (e.g. start or empty)
# SUFFIX   - Suffix for perl scripts (.pl)
# DATE     - date format
# MATLAB   - comand to launch matlab
# SCILAB   - comand to launch scilab
# EXE      - executable suffix (out or exe)
# HOSTFILE - MPI/grid hosts/machine list
# MATLAB_COMMAND - options to execute matlab
# SCILAB_COMMAND - options to execute scilab
# EXE      - executable extension
# CODETEXT - check for Tk::CodeText availability
# PROCSIMPLE - check for Proc::Simple availability
# TEMP - check for File::Temp availability
#
# NOTE: If you modify this file to change a SCILAB equal to 'no' to adjust an existing
# installation to a new install of scilab, enter the FULL PATH to the scilab binary, e.g.
# /usr/local/scilab-3.1.1/bin/scilab
#

use Config;

%MCSTAS::mcstas_config = (
     CFLAGS => '-g -O2',
     LDFLAGS => '',
     CC => 'gcc',
     TERMINAL => '/usr/bin/xterm',
     EXTERNAL_EDITOR => '/usr/bin/kate',
     BROWSER => '/usr/bin/konqueror',
     VRMLVIEW => '/usr/bin/freewrl',
     PGPLOT => '/usr/bin/pgxwin_server',
     TCLTK => '/usr/bin/wish',
     SSH => '/usr/bin/ssh',
     MPIRUN => 'no',
     MPICC => 'no',
     PREFIX => '',
     SUFFIX => '',
     PLOTTER => 'Scilab',
     EDITOR => 1,
     MATLAB => '/usr/local/bin/matlab',
     SCILAB => '/usr/local/bin/scilab',
     MATLAB_COMMAND => '-nojvm',
     SCILAB_COMMAND => '-nw',
     EXE => 'out',
     HOSTFILE => '',
     MODULES => '',
     CODETEXT => 'no',
     PROCSIMPLE => 'no',
     TEMP => 'no'
     );

# **** installed site perl modules availability

if ($MCSTAS::mcstas_config{'PGPLOT'} ne "no") {
  $MCSTAS::mcstas_config{'PGPLOT'} = "no";  # unset it and then search pgperl
  foreach $inc (@INC) {
    my $where="$inc/PGPLOT.pm";
    if (-e $where) {
      $MCSTAS::mcstas_config{'PGPLOT'}=$inc; # we got pgplot+pgperl
      require PGPLOT;
    }
  }
}

if ($MCSTAS::mcstas_config{'TCLTK'} ne "no") {
  $MCSTAS::mcstas_config{'TCLTK'} = "no";  # unset it and then search perl-tk
  foreach $inc (@INC) {
    my $where="$inc/Tk.pm";
    if (-e $where) {
      $MCSTAS::mcstas_config{'TCLTK'} = $inc; # we got tk+perltk
      require Tk;
    }
  }
}

# **** installed McStas perl modules availability

if (defined($MCSTAS::perl_modules) && -e $MCSTAS::perl_modules) {
  $MCSTAS::mcstas_config{'MODULES'} = "$MCSTAS::perl_modules";
}

my $textedit=0;
my $storable=0;

foreach $inc (@INC) {
  my $where="$inc/Tk/CodeText.pm";
  my $temp_avail="";
  if (-e "$where") {
    $MCSTAS::mcstas_config{'CODETEXT'} = $where; # we got Tk::CodeText
  }

  $where="$inc/Proc/Simple.pm";
  if (-e "$where") {
    $MCSTAS::mcstas_config{'PROCSIMPLE'} = $where; # we got Proc::Simple
  }

  $where="$inc/Temp.pm";
  if (-e $where) { $temp_avail=$where; }
  $where="$inc/File/Temp.pm";
  if (-e $where) { $temp_avail=$where; }
  if ($temp_avail ne "") {
    $MCSTAS::mcstas_config{'TEMP'} = $temp_avail;
  }

  $where="$inc/Tk/TextEdit.pm";
  if (-e "$where") {
    $textedit = $where; # we got CodeText+TextEdit
  }

  $where="$inc/Storable.pm";
  if (-e "$where") {
    $storable = $where; # we got CodeText+TextEdit
  }
}

if ($MCSTAS::mcstas_config{'CODETEXT'} ne "no") {
  if ($textedit eq 0 || $storable eq 0) {
    $MCSTAS::mcstas_config{'CODETEXT'} = "no";
  }
}

# check of editors availability
if ($MCSTAS::mcstas_config{'EDITOR'} == 1 && $MCSTAS::mcstas_config{'CODETEXT'} eq "no") {
  $MCSTAS::mcstas_config{'EDITOR'} = 0;
}

# **** update MCSTAS config from $ENV

if ($ENV{'BROWSER'}) {
  $MCSTAS::mcstas_config{'BROWSER'} = $ENV{'BROWSER'} ;
}

if ($ENV{'VRMLVIEW'}) {
  $MCSTAS::mcstas_config{'VRMLVIEW'} = $ENV{'VRMLVIEW'} ;
}

if ($ENV{'VISUAL'} || $ENV{'EDITOR'}) {
  $MCSTAS::mcstas_config{'EXTERNAL_EDITOR'} = $ENV{'VISUAL'} || $ENV{'EDITOR'};
}

if ($ENV{'MCSTAS_FORMAT'}) {
  $MCSTAS::mcstas_config{'PLOTTER'} = $ENV{'MCSTAS_FORMAT'};
}

# Check value of $MCSTAS::mcstas_config{'PLOTTER'} variable
if ($MCSTAS::mcstas_config{'PLOTTER'} =~ /PGPLOT|McStas/i) {
  if ($MCSTAS::mcstas_config{'PLOTTER'} =~ /binary|float|double/i) {
    $MCSTAS::mcstas_config{'PLOTTER'} =~ s/binary//; # PGPLOT binary format is invalid. solving.
    $MCSTAS::mcstas_config{'PLOTTER'} =~ s/float//;
    $MCSTAS::mcstas_config{'PLOTTER'} =~ s/double//;
  }
}

# Make sure that the current directory appears first in the path;
# contrary to normal use, this is what the user expects here.
$ENV{PATH} = $ENV{PATH} ? ".:$ENV{PATH}" : ".";

# Attempt to locate pgplot directory if unset.
$ENV{'PGPLOT_DIR'} = "/usr/local/pgplot" unless $ENV{'PGPLOT_DIR'};
$ENV{'PGPLOT_DEV'} = "/xserv" unless $ENV{'PGPLOT_DEV'};

# override default CC/CFLAGS if MCSTAS_CC/CFLAGS defined
$MCSTAS::mcstas_config{'CC'} = $ENV{'MCSTAS_CC'} if defined($ENV{'MCSTAS_CC'});
$MCSTAS::mcstas_config{'CFLAGS'} = $ENV{'MCSTAS_CFLAGS'} if defined($ENV{'MCSTAS_CFLAGS'});

# **** update fields depending on system specific configuration

if ($Config{'osname'} ne 'MSWin32') { # Unix systems
  my $HOME = $ENV{'HOME'} ? "$ENV{'HOME'}" : ".";
  my $hostfile = "";
  if ($ENV{'HOME'}) { $hostfile = "$HOME/.mcstas-hosts"; }
  else { $hostfile = ".mcstas-hosts"; }
  if (!-e $hostfile) {
    if ($ENV{'HOME'}) { $hostfile = "$HOME/mcstas-hosts"; }
    else { $hostfile = "mcstas-hosts"; }
    if (!-e $hostfile) {
      $hostfile = "$MCSTAS::sys_dir/tools/perl/mcstas-hosts";
      if (! -e $hostfile) { $hostfile = ""; }
    }
  }
  $MCSTAS::mcstas_config{'HOSTFILE'} = $hostfile;
}

1;  # return true for import/use/do

#
#   This file is part of the McStas neutron ray-trace simulation package
#   Copyright (C) 1997-2006, All rights reserved
#   Risoe National Laborartory, Roskilde, Denmark
#   Institut Laue Langevin, Grenoble, France
#
#   This program is free software; you can redistribute it and/or modify
#   it under the terms of the GNU General Public License as published by
#   the Free Software Foundation; either version 2 of the License, or
#   (at your option) any later version.
#
#   This program is distributed in the hope that it will be useful,
#   but WITHOUT ANY WARRANTY; without even the implied warranty of
#   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
#   GNU General Public License for more details.
#
#   You should have received a copy of the GNU General Public License
#   along with this program; if not, write to the Free Software
#   Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
#
