C////////////////////////////////////////////////////////////////////////////////
C////
C////  R E S T R A X   4.8.1    EXCI
C////
C//// Subroutine called by RESTRAX to get values of excitation energy (OMEXC)
C//// and scattering cross-section (SQOM) for given QHKL,E values stored in Q(i)
C//// Permits to define up to 6 different branches of S(Q,E)
C////
C//// You can use this file as a template
C//// Refer to DON'T CHANGE .. END blocks for the code to be preserved
C////
C//// J. Saroun (saroun@ujf.cas.cz) , March 2005
C//// Read attached documentation or visit RESTRAX home page for help: 
C//// http://omega.ujf.cas.cz/restrax
C////////////////////////////////////////////////////////////////////////////////
C
C                           ***  ARGUMENTS ***
C input:
C Q(1:4)   ... (H,K,L,E) values 
C ICOM<-10 ... initialization (called only once when loaded at runtime )
C ICOM=0   ... initialization (run usually before each  [M]FIT or INIT  commands)
C ICOM=-1  ... only excitation energies are used (e.g. for plotting disp. branches)
C ICOM=-2  ... only S(Q,E) values are used (e.g. for plotting S(Q,E) maps)
C ICOM>0   ... should return both excitation energies and S(Q,E). ICOM=index of supplied event
C
C output:
C OMEXC(1:6) ... excitation energies for 1..nbr branches for Qhkl = Q(1:3) 
C SQOM(1:6)  ... S(Q,E) values for 1..nbr branches
C
C                           *** SHARED DATA ***
C
C Following fileds are available via common variables declared in the *.inc files:
C
C Monte Carlo ray-tracing results:
C-----------------------------------
C REAL*4 QOM(1:4,j),PQOM(j) .... value of (Q,E) and weight for j-th event
C IQOM(j) .... the index of data set corresponding to given j-th event.
C NQOM(k) .... partitioning of the QOM, PQOM ... arrays, i.e. the number
C              of events stored for the k-th data set is NQOM(k)-NQOM(k-1).
C NDATQOM .... index of actual data set, for which the scan profile is accumulated
C              Use this index to define specific free parameters for different data sets 
C
C Instrument setting:
C-----------------------------------
C REAL*4 QOM0(1:4,k)   .... Spectrometer position (Q,E) for k-th data set
C
C Unit vectors in rec. lat. units:
C-----------------------------------
C REAL*8 PARAM(1:MPAR)         ... free model parameters
C INETEGR*4 FIXPARAM(1:MPAR)   ... fixed parameters. Set FIXPARAM(i)=0 to make  
C                                  the i-th parameter fixed)
C NTERM                        ... number of free model parameters (<=64)
C NBR                          ... number of branches defined by EXCI (<=6)
C REAL*8 WEN(1:6)              ... widths of the disp. branches. 
C CHARACTER*10 PARNAME(1:MPAR) ... names of free parameters
C                         
C Outside EXCI, WEN is used only as a flag to check, whether scattering 
C is difuse (WEN>0) or not (WEN=0). The convolution method is selected according 
C to this flag.  
C
C                           *** SHARED SUBROUTINES ***
C                        (see source files for details)
C   in this module:
C   SUBROUTINE READEXCIPAR     ... Read initial values of model variables 
C   in exci_io.f:
C   SUBROUTINE SETEXCIDEFAULT  ... Set default values to common EXCI variables 
C   in reclat.f:
C   SUBROUTINE POLVECT(Q,TAU,SIG1,SIG2,SIG3,ICOM) ... Get polarization unit vectors with 
C                                                     respect to q=TAU-Q 
C   REAL*8 FUNCTION QxQ(A,B)   ... Scalar product of vectors A,B in non-carthesian rec. lattice coordinates
C   SUBROUTINE QNORM(X,QRLU,QANG)   ... Norm of a vector X in non-carthesian rec. lattice coordinates
C///////////////////////////////////////////////////////////////////////////////////

C------------------------------------------------------------------------------
      SUBROUTINE EXCI(ICOM,Q,OMEXC,SQOM)
C Incommensurate satellites in horizontal plane, infinite in energy
C           and vertical direction
C free parameters:
C (1) Intensity (2) background (3) position (4) width
C------------------------------------------------------------------------------
      IMPLICIT NONE
      
C----------------------- *** DON'T CHANGE *** ------------------------------
      INCLUDE 'const.inc'
c      INCLUDE 'inout.inc'
      INCLUDE 'exci.inc'
      INTEGER*4 ICOM ,EXCINIT   
      REAL*8 Q(4),OMEXC(6),SQOM(6)
      
C-------------------------- *** END *** ------------------------------------

C **** Local user declarations ****

      integer*4 i,j,k
      real*8 qsat(3),V(3),DIRSQ,QSQ

C// TAU(3)  ... B.Z. center
C// POS(3,6)... satellite positions are POS*dist
C// DIR(3)  ... direction of "rods"
C// fqsq(6) ... scattering cross-sections of satellites
C// wq(6)   ... satellite widths
C// dist    ... width of satellites in r.l.u.
      REAL*8 tau(3),dir(3),pos(3,6),fqsq(6),wq(6),dist
      common /excipar/ tau,dir,pos,fqsq,wq,dist
     
C------------------ *** DATA section *** ----------------------

C **** DEFAULT values of internal model variables ****
      
      DATA fqsq/6*1./
      DATA tau/1.,0.,0./
      DATA dir/0.,0.,1./
      DATA pos/1.,1.,0.,1.,-1.,0,-1.,1.,0.,-1.,-1.,0,6*0./
      DATA wq/6*0.01/
      DATA dist/0.3/
      DATA EXCINIT/0/
      DATA DIRSQ/1.D0/    

C***********************************************************************************
C MODEL INITIALIZATION (ICOM<-10)
C***********************************************************************************
C-- called only once when loaded at runtime 
C-- set some values shared with RESTRAX if different from default

      IF (ICOM.LT.-10) THEN

        CALL SETEXCIDEFAULT  ! DONT CHANGE

C Set model identification string: 
        PHONTITLE='Incommensurate satellites' 

C// Define fixed parameters (=0), default: all free (=1)
c      FIXPARAM(1)=0  ! let Intensity fixed !!

C// Number of branches ****    
        NBR=4

C// Initial widths in energy, default=1meV 
C// Set wen(i)=0 for zero-width branches
c        WEN(1)=0.D0 
c        WEN(2)=2.D0

C**** How to read file with parameters (default=1):
C**** (0) never (1) at program start or on INIT command (2) each time MFIT is called   
c        EXCREAD=0 
      
C Set name of file with model parameters (if different from default exc.par)
        PHONNAME='sat.par'

C Define names of free parameters for i>2:
        PARNAME(3)='Position'
        PARNAME(4)='Width'       

C// Number of free model parameters
        NTERM=4
      
        return
      ENDIF


C----------------------- *** DON'T CHANGE *** ------------------------------  
      IF ((ICOM.NE.0).AND.(EXCINIT.NE.0)) GOTO 1      
C---------------------------- *** END *** ----------------------------------
      
C***********************************************************************************
C MODEL INITIALIZATION (ICOM=0)                    
C***********************************************************************************
C-- called before each [M]FIT or INIT command  
C
      
c calculate |DIR|^2      
      DIRSQ=DIR(1)**2+DIR(2)**2+DIR(3)**2           
      
C/// Assign initial values of free parameters to param(i) array    

      param(3)=dist              
      param(4)=wq(1)

C----------------------- *** DON'T CHANGE *** -------------------------

      EXCINIT=1
      RETURN
1     CONTINUE       
C---------------------------- *** END *** ----------------------------------
     
C********************************************************************************
C                                                                   
C                   EXECUTION PART (ICOM<>0)                        
C
C This part is called many times during the fitting procedure 
C =>  should be as fast as possible
C 
C// Do whatever you want in the following code. 
C// EXCI MUST RETURN: 
C// OMEXC(i) ... excitation energies for first NBR branches (i=1..6)
C// SQOM(i)  ... dS/dOmega/dE 

C (ICOM=-1 => only OMEXC(i) values are used by RESTRAX to plot the branches.
C Otherwise, ICOM refers to the event number in the QOM array
C   => ICOM can be used e.g. as an index to internal lookup tables of EXCI etc...                                
C********************************************************************************
      

C------------------!! OBLIGATORY !!-------------------------

C// Assign values in the PARAM array to the local model variables
C// if you don't work with the PARAM() array directly
C// REMEMBER: PARAM(1,2) are reserved for Scale and Background
      DO i=1,NBR
        wq(i)=param(4)
      ENDDO
      dist=param(3)
        
C----------------------!! END !! -------------------------

C Orthogonal lattice is supposed !
C get squares of distances from DIR axis for all satellites, calculate SQOM:
      do j=1,nbr
         do k=1,3
            qsat(k) = q(k)-tau(k)-dist*pos(k,j)  
         enddo
         V(1)=qsat(2)*dir(3)-qsat(3)*dir(2)
         V(2)=qsat(3)*dir(1)-qsat(1)*dir(3)
         V(3)=qsat(1)*dir(2)-qsat(2)*dir(1)
         QSQ=(V(1)**2+V(2)**2+V(3)**2)/DIRSQ
         sqom(j)=fqsq(j)/wq(j)*exp(-QSQ/wq(j)**2) ! gaussian profile       
         omexc(j) = q(4) ! any energy is allowed  
      enddo
c20    format(a,6(2x,G10.4))
c      write(*,20) 'EXCI, tau:  ',(tau(j),j=1,3)
c      write(*,20) 'EXCI, dir:  ',(dir(j),j=1,3)
c      write(*,20) 'EXCI, pos:  ',(pos(j,1),j=1,3)
c      write(*,20) 'EXCI, qsat: ',(qsat(j),j=1,3)
c      write(*,20) 'EXCI, wq:   ',(wq(j),j=1,nbr)
c      write(*,20) 'EXCI, fqsq: ',(fqsq(j),j=1,nbr),QSQ
c      write(*,20) 'EXCI, sqom: ',(sqom(j),j=1,nbr)
c      pause              
     
      END
      
C------------------------------------------------------------------------------
      SUBROUTINE REPEXCIPAR
C REPORT model ID and input parameters as needed
C------------------------------------------------------------------------------
      IMPLICIT NONE
      INCLUDE 'const.inc'
c      INCLUDE 'inout.inc'
      INCLUDE 'exci.inc'
      INTEGER*4 i
      REAL*8 tau(3),dir(3),pos(3,6),fqsq(6),wq(6),dist
      common /excipar/ tau,dir,pos,fqsq,wq,dist
      
      write(*,*) 'EXCI: '//PHONTITLE
C// Report some model values:     
10    format('Number of satellites: ',I2)
      write(*,10) NBR
11    format('Tau: ',3(1x,I3))
      write(*,11) (NINT(tau(i)),i=1,3)
13    format('Direction: ',3(1x,I3))
      write(*,13) (NINT(dir(i)),i=1,3) 
      END
     
      
C------------------------------------------------------------------------------
      SUBROUTINE READEXCIPAR
C Read values of model variables used by EXCI
C Call by RESTRAX when requiared
C File is opened and closed by RESTRAX, don't call OPEN/CLOSE here !!!
C------------------------------------------------------------------------------
      IMPLICIT NONE
      INCLUDE 'const.inc'
c      INCLUDE 'inout.inc'
      INCLUDE 'exci.inc'
           
      INTEGER*4 i,k
      REAL*8 width
      REAL*8 tau(3),dir(3),pos(3,6),fqsq(6),wq(6),dist
      common /excipar/ tau,dir,pos,fqsq,wq,dist

      rewind(EXCUNIT) ! call rewind for compatibility with g77
C read model parameters from file 
      read (EXCUNIT,FMT=*,err=998) nbr   ! number of satellites (1..6)
      if (nbr.GT.6) nbr=6
      if (nbr.LE.0) nbr=1
      read (EXCUNIT,*,err=998) width ! width (in r.l.u.)
      read (EXCUNIT,*,err=998) dist  ! distance from DIR axis (direction vectors are listed below)
      read (EXCUNIT,*,err=998) dir   ! direction of "rods" axes (=DIR)
      read (EXCUNIT,*,err=998) tau   ! B.Z. center (=TAU)
      do i=1,3
        tau(i)=1.D0*NINT(tau(i))
      enddo 
c read fqsq & direction -| to DIR axis for each satellite
      do i=1,nbr
         read (EXCUNIT,*,err=998) fqsq(i),(pos(k,i),k=1,3)
         wq(i)=width 
      enddo
      write(*,*) 'Parameters updated from '//PHONNAME
      RETURN

998   write(*,*) 'Format error?! Cannot read excitation parameters.'     
      RETURN
      END
