! *****  constants for RESTRAX  ******

! *** Units ***

      REAL*8 PI,deg,minute,sec,rad,SQRT8LN2,HBAR,HOVM,HSQOV2M,
     &       gammaL,GammaNi
      PARAMETER (
     *  PI       = 3.141592653589793239D0,
     *  deg      = PI/180,
     *  minute   = PI/180/60,
     *  sec      = PI/180/3600,
     *  rad      = 180/PI,
     *  SQRT8LN2 = 2.354820045,
     *  HBAR     = 6.58211889D-4, !  [meV*ns]
     *  HOVM     = 6.296E-1,      !  [m/ms*A]
     *  HSQOV2M  = 2.0721,        !  [meV*A^2]
     *  gammaL   = 1.83246D8,     !  [1/T/s]     gyromagnetic ratio
     *  GammaNi  = 0.00173)       !  [rad/A]
     
      REAL*8 EUNI,ZNORM
      CHARACTER*5 CUNIT
      COMMON /CNST/ ZNORM,EUNI,CUNIT

! EXCI version: used to check for compatibility with external EXCI libraries
      REAL*4 EXCI_NUMBER
      PARAMETER (EXCI_NUMBER=5.2) 

! *** Array dimensions ***
     
      INTEGER*4 MHIS,NHI,MDAT,MAXD,MPAR,MRES,RES_NVAR,RES_NCMD,
     *          MQOM,NXR,MIMAX
      
      PARAMETER( 
     *    MHIS=129	,	! Histogram & data dimensions
     *    NHI= 91	,	! Default histogram size
     *    MDAT=64	,	! Max. number of data files
     *    MAXD=NHI*MDAT	,	! Dimension of arrays SPX,RHIST,...
     *    MPAR=64	,	! Max. number of fitting parameters
     *    RES_NVAR=50	,	! Actual number of variables 
     *    RES_NCMD=44	,	! Actual number of commands 
     *    MRES=256	,	! Dimension of RES_DAT,... 
     *    MQOM=320000	,	! Dimension of QOM array 
     *    MIMAX=128	,	! Max. & default dimension of image arrays
     *    NXR=3000	)	! default number of (Q,w) points for gaussian R(Q,w) 
 
    
    
