C--------------------------------------------------
C//////////////////////////////////////////////////////////////////////
C////
C////  R E S T R A X   4.8.0
C////
C////  Operations in reciprocal lattice
C////  Linked both with EXCI library and RESTRAX
C////  
C//////////////////////////////////////////////////////////////////////

C-----------------------------------------------------------------------------
      SUBROUTINE POLVECT(Q,TAU,SIG1,SIG2,SIG3,ICOM)
C return polarization unit vectors for phonon q=Q-TAU in r.l.u.
C SIG1 .. L
C SIG2 .. T in plane
C SIG3 .. T off plane
C To speed-up the procedure, calculation is made only if Q or TAU has changed or ICOM<>0
C-----------------------------------------------------------------------------
      IMPLICIT NONE
      INCLUDE 'reclat.inc' 
      
      REAL*8 EPS
      PARAMETER (EPS=1.D-8)
      REAL*8 Q(3),TAU(3),SIG1(3),SIG2(3),SIG3(3)
      INTEGER*4 ICOM,i,j
      REAL*8 W1(3),W2(3),W3(3),V2(3),V3(3),qab(3),tab(3)
      REAL*8 LASTQ(3),LASTT(3)
      REAL*8 qnr1,qnr2,qnr3,dum
      SAVE W1,W2,W3  ! save last result for subsequent use
      DATA LASTQ /0.D0,0.D0,0.D0/
      DATA LASTT /0.D0,0.D0,0.D0/
      
      
      IF (ICOM.EQ.0) THEN
        DUM=ABS(LASTQ(1)-Q(1))+ABS(LASTQ(2)-Q(2))+ABS(LASTQ(3)-Q(3))
        DUM=DUM+
     &    ABS(LASTT(1)-TAU(1))+ABS(LASTT(2)-TAU(2))+ABS(LASTT(3)-TAU(3))
        IF (DUM.LT.EPS) GOTO 10
      ENDIF
      
      DO j=1,3
         W1(j)=Q(j)-TAU(j) ! phonon q
      END DO 
            
      DO i=1,3
         qab(i)=0.D0
         tab(i)=0.D0
         DO j=1,3
            qab(i)=qab(i)+SMAT(i,j)*W1(j)    ! convert qph to AB coordinates
            tab(i)=tab(i)+SMAT(i,j)*tau(j)   ! convert tau to AB coordinates
         ENDDO
      ENDDO

! vector parallel to (qab x tab)  
      V3(1)=qab(2)*tab(3)-qab(3)*tab(2)
      V3(2)=qab(3)*tab(1)-qab(1)*tab(3)
      V3(3)=qab(1)*tab(2)-qab(2)*tab(1)

! vector parallel to (V3 x qab)          
      V2(1)=V3(2)*qab(3)-V3(3)*qab(2)
      V2(2)=V3(3)*qab(1)-V3(1)*qab(3)
      V2(3)=V3(1)*qab(2)-V3(2)*qab(1)

! convert V2,V3 back to rec. lat. coordinates:
      DO i=1,3
         W2(i)=0.D0
         W3(i)=0.D0
         DO j=1,3
            W2(i)=W2(i)+SINV(i,j)*V2(j)      
            W3(i)=W3(i)+SINV(i,j)*V3(j)      
         ENDDO
      ENDDO
      
! normalize:            
      CALL QNORM(W1,qnr1,dum)
      CALL QNORM(W2,qnr2,dum)
      CALL QNORM(W3,qnr3,dum)
      DO I=1,3
        W1(I)=W1(I)/qnr1
        W2(I)=W2(I)/qnr2
        W3(I)=W3(I)/qnr3
        LASTQ(I)=Q(I)
        LASTT(I)=TAU(I)
      ENDDO
            
c20    format(3(2x,G12.6))
c      write(*,*) 'polarization unit vectors: '
c      do i=1,3
c        write(*,20) W1(i),W2(i),W3(i)
c      enddo      
      
10    DO I=1,3
        SIG1(I)=W1(I)
        SIG2(I)=W2(I)
        SIG3(I)=W3(I)
      ENDDO
      
      END      
      
 
C--------------------------------------------
      SUBROUTINE QNORM(X,QRLU,QANG)
C  input: X in r.l.u.
C  returns: norm of X in r.l.u and A^-1
C--------------------------------------------
      IMPLICIT NONE
      INCLUDE 'reclat.inc' 
      
      REAL*8 X(3),QRLU,QANG
      REAL*8 V3(3),Z  
      INTEGER*4 I        
      
      Z=0.D0
      DO I=1,3
        Z=Z+X(I)**2
      ENDDO        
              
      QRLU=SQRT(Z+2*X(1)*X(2)*COSB(3)+
     1   2*X(2)*X(3)*COSB(1)+ 2*X(1)*X(3)*COSB(2))      ! norm of X in r.l.u.
      
      DO I=1,3
         V3(I)=SMAT(I,1)*X(1)+SMAT(I,2)*X(2)+SMAT(I,3)*X(3)
      END DO  
      QANG= SQRT(V3(1)**2+V3(2)**2+V3(3)**2)   ! norm of X in [A-1]
      
      END  

C-----------------------------------------------------------
      REAL*8 FUNCTION QxQ(A,B)
C     returns dot-product of two vectors in r.l. coordinates
C-----------------------------------------------------------
      IMPLICIT NONE
      INCLUDE 'reclat.inc' 
           
      REAL*8 A(3),B(3),Z           
      INTEGER*4 I        
      
      Z=0.D0
      DO I=1,3
        Z=Z+A(I)*B(I)
      ENDDO        
      QxQ=Z+(A(1)*B(2)+A(2)*B(1))*COSB(3)
     1              +(A(1)*B(3)+A(3)*B(1))*COSB(2)
     2              +(A(2)*B(3)+A(3)*B(2))*COSB(1)  
      
      END  

C--------------------------------------------------------------------
      SUBROUTINE GET_ANGLE(Q1,Q2,ANGLE)
C returns angle between two rec. lattice vectors 
C Q1,Q2 must lay in scattering (horizontal) plane !!
C ANGLE is taken relative to Q1 in the interval (-PI,+PI)
C--------------------------------------------------------------------
      IMPLICIT NONE
      INCLUDE 'reclat.inc'      
      
      REAL*8 Q1(3),Q2(3),ANGLE
      REAL*8 VQ1(3),VQ2(3),QN1,QN2,CO,SI
      INTEGER*4 I,J        
      
      DO I=1,3
        VQ1(I)=0.D0
        VQ2(I)=0.D0
        DO J=1,3
          VQ1(I)=VQ1(I)+SMAT(I,J)*Q1(J)
          VQ2(I)=VQ2(I)+SMAT(I,J)*Q2(J)
        ENDDO
      ENDDO        
      QN1=SQRT(VQ1(1)**2+VQ1(2)**2)
      QN2=SQRT(VQ2(1)**2+VQ2(2)**2)
      IF(QN1*QN2.LT.1E-10) THEN
        ANGLE=0.D0
        RETURN
      ENDIF
      CO=(VQ1(1)*VQ2(1)+VQ1(2)*VQ2(2))/(QN1*QN2)
      SI=(VQ1(1)*VQ2(2)-VQ1(2)*VQ2(1))/(QN1*QN2)
      IF (ABS(SI).LT.1E-8) THEN
        ANGLE=0.D0
      ELSE  
        ANGLE=SIGN(1.D0,SI)*ABS(ACOS(CO))
      ENDIF  
      END

