C////////////////////////////////////////////////////////////////////////////////
C////
C////  R E S T R A X   4.8.1    EXCI
C////
C//// Subroutine called by RESTRAX to get values of excitation energy (OMEXC)
C//// and scattering cross-section (SQOM) for given QHKL,E values stored in Q(i)
C//// Permits to define up to 6 different branches of S(Q,E)
C////
C//// You can use this file as a template
C//// Refer to DON'T CHANGE .. END blocks for the code to be preserved
C////
C//// J. Saroun (saroun@ujf.cas.cz) , March 2005
C//// Read attached documentation or visit RESTRAX home page for help: 
C//// http://omega.ujf.cas.cz/restrax
C////////////////////////////////////////////////////////////////////////////////
C
C                           ***  ARGUMENTS ***
C input:
C Q(1:4)   ... (H,K,L,E) values 
C ICOM<-10 ... initialization (called only once when loaded at runtime )
C ICOM=0   ... initialization (run usually before each  [M]FIT or INIT  commands)
C ICOM=-1  ... only excitation energies are used (e.g. for plotting disp. branches)
C ICOM=-2  ... only S(Q,E) values are used (e.g. for plotting S(Q,E) maps)
C ICOM>0   ... should return both excitation energies and S(Q,E). ICOM=index of supplied event
C
C output:
C OMEXC(1:6) ... excitation energies for 1..nbr branches for Qhkl = Q(1:3) 
C SQOM(1:6)  ... S(Q,E) values for 1..nbr branches
C
C                           *** SHARED DATA ***
C
C Following fileds are available via common variables declared in the *.inc files:
C
C Monte Carlo ray-tracing results:
C-----------------------------------
C REAL*4 QOM(1:4,j),PQOM(j) .... value of (Q,E) and weight for j-th event
C IQOM(j) .... the index of data set corresponding to given j-th event.
C NQOM(k) .... partitioning of the QOM, PQOM ... arrays, i.e. the number
C              of events stored for the k-th data set is NQOM(k)-NQOM(k-1).
C NDATQOM .... index of actual data set, for which the scan profile is accumulated
C              Use this index to define specific free parameters for different data sets 
C
C Instrument setting:
C-----------------------------------
C REAL*4 QOM0(1:4,k)   .... Spectrometer position (Q,E) for k-th data set
C
C Unit vectors in rec. lat. units:
C-----------------------------------
C REAL*8 PARAM(1:MPAR)         ... free model parameters
C INETEGR*4 FIXPARAM(1:MPAR)   ... fixed parameters. Set FIXPARAM(i)=0 to make  
C                                  the i-th parameter fixed)
C NTERM                        ... number of free model parameters (<=64)
C NBR                          ... number of branches defined by EXCI (<=6)
C REAL*8 WEN(1:6)              ... widths of the disp. branches. 
C CHARACTER*10 PARNAME(1:MPAR) ... names of free parameters
C                         
C Outside EXCI, WEN is used only as a flag to check, whether scattering 
C is difuse (WEN>0) or not (WEN=0). The convolution method is selected according 
C to this flag.  
C
C                           *** SHARED SUBROUTINES ***
C                        (see source files for details)
C   in this module:
C   SUBROUTINE READEXCIPAR     ... Read initial values of model variables 
C   in exci_io.f:
C   SUBROUTINE SETEXCIDEFAULT  ... Set default values to common EXCI variables 
C   in reclat.f:
C   SUBROUTINE POLVECT(Q,TAU,SIG1,SIG2,SIG3,ICOM) ... Get polarization unit vectors with 
C                                                     respect to q=TAU-Q 
C   REAL*8 FUNCTION QxQ(A,B)   ... Scalar product of vectors A,B in non-carthesian rec. lattice coordinates
C   SUBROUTINE QNORM(X,QRLU,QANG)   ... Norm of a vector X in non-carthesian rec. lattice coordinates
C///////////////////////////////////////////////////////////////////////////////////

C------------------------------------------------------------------------------
      SUBROUTINE EXCI(ICOM,Q,OMEXC,SQOM)
C Damped oscillators (up to 6 branches) with free dispersion gradient
C Defines energy dispersion E(Q) as a quadratic form (in 3 dimensions)
C For wen(j)=0, zero intrinsic width is considered.
C------------------------------------------------------------------------------
      IMPLICIT NONE
      
C----------------------- *** DON'T CHANGE *** ------------------------------
      INCLUDE 'const.inc'
c      INCLUDE 'inout.inc'
      INCLUDE 'exci.inc'
      INTEGER*4 ICOM,EXCINIT   
      REAL*8 Q(4),OMEXC(6),SQOM(6)
      
C-------------------------- *** END *** ------------------------------------
     
C **** Local user declarations ****

      integer*4 j,i
      real*8 qphon(3),qphon0(3),sig1(3),sig2(3),sig3(3),dqphi(3)
      real*8 dq1,dq2,dq3,bf,kT,z
      character*1 CH(6) 

C// internal variables describing the model
C// This common is not shared with the rest of RESTRAX, only within this file. 
C// These variables are actually shared with the READEXCIPAR subroutine below.
      REAL*8 temp,tau(3),qnom(3)
      REAL*8 fqsq(6),omega0(6),domdq(6),b1(6),b2(6),b3(6)
      common /excipar/ temp,tau,qnom,fqsq,omega0,domdq,b1,b2,b3

C function defined in reclat.f, makes dot product of vectors in rec. lat. coordinates:
C REAL*8 QxQ(A,B) for REAL*8 A(3),B(3)
      REAL*8 QxQ      

C----------------------- *** DATA section *** ----------------------------     
      
C **** DEFAULT values of internal model variables ****
      DATA temp/1.5/
      DATA fqsq/6*1./
      DATA omega0/7.,15.,4*1.0/, domdq/0.,10.,4*0/
      DATA b1/-10,-10.,4*0/, b2/6*0/, b3/6*0/ 
      DATA CH/'1','2','3','4','5','6'/
      DATA tau/0.,0.,2/
      DATA qnom/0.1,0.1,2.0/       
      DATA EXCINIT/0/

C***********************************************************************************
C MODEL INITIALIZATION (ICOM<-10)
C***********************************************************************************
C-- called only once when loaded at runtime 
C-- set some values shared with RESTRAX if different from default

      IF (ICOM.LT.-10) THEN

        CALL SETEXCIDEFAULT  ! DONT CHANGE

C Set model identification string: 
        PHONTITLE='Damped oscillators with free gradient' 

C// Define fixed parameters (=0), default=1 (all free)
        FIXPARAM(1)=0  ! let Intensity fixed !!

C// Number of branches ****    
        NBR=2

C// Initial widths in energy (default=1meV), 
C// Set wen(i)=0 for zero-width branches
c        WEN(1)=0.D0 
c        WEN(2)=2.D0

C**** How to read file with parameters (default=1):
C**** (0) never (1) at program start or on INIT command (2) each time MFIT is called   
c        EXCREAD=0 
      
C Set name of file with model parameters (default=exc.par)
        PHONNAME='osc.par'
      
C Define names of free parameters for i>2:
c        PARNAME(3)='Position'
c        PARNAME(4)='Width'       

C// Number of free model parameters
c        NTERM=4
                
        return
      ENDIF

C----------------------- *** DON'T CHANGE *** ------------------------------  
      IF ((ICOM.NE.0).AND.(EXCINIT.NE.0)) GOTO 1      
C---------------------------- *** END *** ----------------------------------
      
C***********************************************************************************
C MODEL INITIALIZATION (ICOM=0)                    
C***********************************************************************************
C-- called before each [M]FIT or INIT command  
C
     
C// actual number of free model parameters
      NTERM=2+NBR*4
C// Assign free model parameters to param():

      DO i=1,NBR
        param(3+4*(i-1)) = fqsq(i)
        param(4+4*(i-1)) = omega0(i)
        param(5+4*(i-1)) = wen(i)
        param(6+4*(i-1)) = domdq(i)
      ENDDO
      
c// set parameter names for all branches
      DO i=1,NBR
        parname(3+4*(i-1))='Int'//CH(i)
        parname(4+4*(i-1))='Omega'//CH(i)
        parname(5+4*(i-1))='Gamma'//CH(i)
        parname(6+4*(i-1))='Grad'//CH(i)
      ENDDO
      DO i=NBR+1,6
        parname(3+4*(i-1))=' '
        parname(4+4*(i-1))=' '
        parname(5+4*(i-1))=' '
        parname(6+4*(i-1))=' '
      ENDDO
            
C----------------------- *** DON'T CHANGE *** -------------------------

      EXCINIT=1
      RETURN
1     CONTINUE      
C---------------------------- *** END *** ----------------------------------

C********************************************************************************
C                                                                   
C                   EXECUTION PART (ICOM<>0)                        
C
C This part is called many times during the fitting procedure 
C =>  should be as fast as possible
C 
C// Do whatever you want in the following code. 
C// EXCI MUST RETURN: 
C// OMEXC(i) ... excitation energies for first NBR branches (i=1..6)
C// SQOM(i)  ... dS/dOmega/dE 


C (ICOM=-1 => only OMEXC(i) values are used by RESTRAX to plot the branches.
C Otherwise, ICOM refers to the event number in the QOM array
C   => ICOM can be used e.g. as an index to internal lookup tables of EXCI etc...                                
C********************************************************************************
      

C------------------!! OBLIGATORY !!-------------------------

C// Assign values in the PARAM array to the local model variables
C// if you don't work with the PARAM() array directly
C// REMEMBER: PARAM(1,2) are reserved for Scale and Background
      DO i=1,NBR
        fqsq(i)=param(3+4*(i-1))
        omega0(i)=param(4+4*(i-1))
        wen(i)=param(5+4*(i-1))
        domdq(i)=param(6+4*(i-1))
      ENDDO

C// don't allow wen->0, if it is not a zero-width branch  !!      
      DO i=1,NBR
         wen(i)=abs(wen(i))
         if(wen(i).ne.0.D0.AND.wen(i).lt.1e-3) wen(i) = 1.e-3 
      ENDDO     
        
C----------------------!! END !! -------------------------

      do i=1,3
         qphon(i) = q(i)-tau(i)     ! actual phonon q
	 qphon0(i) = qnom(i)-tau(i) ! nominal phonon q
         dqphi(i) = q(i)-qnom(i)    ! difference from nominal phonon q
      enddo

C Use POLVECT to get polarization vectors:
C SIG1 ...  along qphon0
C SIG2 ...  perpendicular to qphon0, in plane
C SIG3 ...  perpendicular to qphon0, off plane (vertical)
      CALL POLVECT(qnom,tau,sig1,sig2,sig3,0) 

C* get projections of dqphi along qphon0, perpendicular to qphon0, and vertical
      dq1=QxQ(dqphi,sig1)
      dq2=QxQ(dqphi,sig2)
      dq3=QxQ(dqphi,sig3)

c// Define dispersion as a quadratic form:
C// domdq ... gradient along q
C// b1,b2,b3 ... curvartures along q, perpendicular and vertical, resp.
      do j=1,nbr
	omexc(j) = omega0(j)+dq1*domdq(j)+
     *	        dq1**2*b1(j)+dq2**2*b2(j)+dq3**2*b3(j)
      enddo

c// bf = Bose factor x omexc
      kT=temp/11.609 ! 11.609 ... conversion kT -> meV
      z=exp(-q(4)/kT)  
      if (abs(1.0-z).LT.1.D-6) then
        bf=kT
      else
        bf=q(4)/(1-z)
      endif

C// Define scattering cross-section: damped oscillator
      do j=1,nbr
        if(fqsq(j).eq.0) then
            sqom(j)=0.
        else
          if(wen(j).NE.0) then           
              sqom(j) = fqsq(j)*ABS(wen(j))*bf/
     &        ((q(4)**2-omexc(j)**2)**2+wen(j)**2*q(4)**2)
          else
              if(abs(omexc(j)).LT.0.0001) omexc(j)=0.0001
              sqom(j) = bf*fqsq(j)/omexc(j)**2
          endif  
        endif  
      enddo
      
      END
      
C------------------------------------------------------------------------------
      SUBROUTINE REPEXCIPAR
C REPORT model ID and input parameters as needed
C------------------------------------------------------------------------------
      IMPLICIT NONE
      INCLUDE 'const.inc'
c      INCLUDE 'inout.inc'
      INCLUDE 'exci.inc'
      
      INTEGER*4 i
      REAL*8 temp,tau(3),qnom(3)
      REAL*8 fqsq(6),omega0(6),domdq(6),b1(6),b2(6),b3(6)
      common /excipar/ temp,tau,qnom,fqsq,omega0,domdq,b1,b2,b3
      
      write(*,*) 'EXCI: '//PHONTITLE
C// Report some model values:  
10    format('Number of branches: ',I2)
      write(*,10) NBR
11    format('Tau: ',3(1x,I3))
      write(*,11) (NINT(tau(i)),i=1,3)
12    format('Temperature [K]: ',G10.4)
      write(*,12) temp
      END

C------------------------------------------------------------------------------
      SUBROUTINE READEXCIPAR
C Read values of model variables used by EXCI
C Call by RESTRAX when requiared
C File is opened and closed by RESTRAX, don't call OPEN/CLOSE here !!!
C------------------------------------------------------------------------------
      IMPLICIT NONE
      INCLUDE 'const.inc'
c      INCLUDE 'inout.inc'
      INCLUDE 'exci.inc'
          
      INTEGER*4 i
      REAL*8 temp,tau(3),qnom(3)
      REAL*8 fqsq(6),omega0(6),domdq(6),b1(6),b2(6),b3(6)
      common /excipar/ temp,tau,qnom,fqsq,omega0,domdq,b1,b2,b3

      rewind(EXCUNIT) ! call rewind for compatibility with g77
C read model parameters from file 
      read (EXCUNIT,*,err=998) nbr ! number of branches (1..6)
      if (nbr.GT.6) nbr=6
      if (nbr.LE.0) nbr=1
      read (EXCUNIT,*,err=998) temp  ! temperature
      read (EXCUNIT,*,err=998) tau   ! tau
      read (EXCUNIT,*,err=998) qnom  ! Q0, reference point for disp. branches
      do i=1,3
        tau(i)=1.D0*NINT(tau(i))
      enddo 
      do i=1,nbr                        ! F(Q)^2, Gamma, Omega0, Gradient, Curvatures
       read (EXCUNIT,*,err=998) fqsq(i),wen(i),omega0(i),
     &       domdq(i),b1(i),b2(i),b3(i)
      enddo      
      write(*,*) 'Parameters updated from '//PHONNAME
      RETURN

998   write(*,*) 'Format error?! Cannot read excitation parameters.'       
      RETURN
      END
       
