C--------------------------------------------------
C//////////////////////////////////////////////////////////////////////
C////
C////  R E S T R A X   4.8.0
C////
C////  Some subroutines for I/O operations in EXCI:
C////  Should be linked only with EXCI library, not with RESTRAX !
C////  
C//////////////////////////////////////////////////////////////////////


C--------------------------------------------------      
      REAL*4 FUNCTION EXCIVERSION()
C Return EXCI version number
C-------------------------------------------------- 
      IMPLICIT NONE 
      INCLUDE 'const.inc'
      INCLUDE 'exci.inc'
      EXCIVERSION=EXCI_NUMBER
      END


C--------------------------------------------------      
      SUBROUTINE SETEXCIDEFAULT
C Set default values to common EXCI variables
C-------------------------------------------------- 
      IMPLICIT NONE    
      INCLUDE 'const.inc'
      INCLUDE 'inout.inc'
      INCLUDE 'exci.inc'
      INTEGER*4 I,MRESPAR
      PARAMETER (MRESPAR=MPAR-2)
      DATA PHONTITLE,PHONNAME /'default','exc.par'/ 
      DATA EXCREAD /1/      
      DATA NBR,NTERM /0,2/  
      DATA WEN/6*1.D0/      
      DATA PARNAME /'Intensity','Background',MRESPAR*' '/ 
      DATA PARAM /1.D0,10.D0,MRESPAR*0.D0/ 
      DATA FIXPARAM /MPAR*1/ ! all free by default !!

      PHONTITLE='default'   ! identification string 
      PHONNAME='exc.par'    ! default name of input file
c read input file: never (0), when necessary (1), always (2)
      EXCREAD=1             
      NBR=0  ! number of dispersion branches
      NTERM=NBR+2   ! number of free parameters
      DO i=1,6      ! default energy widths in meV
         WEN(i)=1.D0 
      ENDDO  
c Default names of free parameters:
      PARNAME(1)='Intensity' 
      PARNAME(2)='Background'
      DO i=3,MPAR
        PARNAME(i)=' '
      ENDDO 
C Default FIXED tags (1 .. free, 0 .. fixed)       
      DO i=1,MPAR
         FIXPARAM(i)=1 
      ENDDO  
c      write(*,*) 'SETEXCIDEFAULT(): ',trim(phonname)
            
      END
      
C--------------------------------------------------
      SUBROUTINE OPENEXCIFILE(IUNIT,FN,IRES)
C Open file for input - to be linked with EXCI module
C if success, return IRES=0
C--------------------------------------------------      
      IMPLICIT NONE    
      INCLUDE 'const.inc'
c      INCLUDE 'inout.inc'
      INTEGER*4 IUNIT,IRES,IS,IL
      CHARACTER*(*) FN
      
      real*8 excar(10)
      integer*4 excn,excn1
      common /exctest/excn,excn1,excar
      data excn,excn1/6,7/
      data excar/1.D0,2.D0,3.D0,4.D0,5.D0,6.D0,7.D0,8.D0,9.D0,10.D0/
      
      IRES=-1      
      CALL GETBOUNDS(FN,IS,IL)
      OPEN(UNIT=IUNIT,FILE=FN(IS:IS+IL-1),STATUS='OLD',ERR=20,
     &     IOSTAT=IRES)
c      WRITE(*,*) 'param. file open: ',IUNIT,FN(IS:IS+IL-1) 
        
20    RETURN  
      END

C--------------------------------------------------
      SUBROUTINE CLOSEEXCIFILE(IUNIT)
C Close input file - to be linked with EXCI module
C--------------------------------------------------      
      IMPLICIT NONE    
      INCLUDE 'const.inc'
      INTEGER*4 IUNIT
c      WRITE(*,*) 'param. file closed: ',IUNIT
      CLOSE(UNIT=IUNIT)

      END
      
C     ---------------------------------------------------
      SUBROUTINE GETBOUNDS(line,ISTART,ILEN)
C     get position of string by stripping off the surrounding spaces
C     ---------------------------------------------------
      IMPLICIT NONE
      CHARACTER*(*) line
      INTEGER*4 L,I,ISTART,ILEN
      L=LEN(line)
      ISTART=1
      IF (L.EQ.0) THEN
         ILEN=0
         RETURN
      ENDIF   
      DO WHILE (L.GT.0.AND.(line(L:L).EQ.' '.OR.line(L:L).EQ.char(0)))
         L=L-1
      ENDDO
      I=1
      DO WHILE (I.LT.L.AND.(line(I:I).EQ.' '.OR.line(I:I).EQ.char(0)))
         I=I+1
      ENDDO
      IF (I.GT.L) THEN
         ILEN=0
      ELSE
         ISTART=I
         ILEN=L-I+1
      ENDIF 
      END  
