/* 
$Id: excihandle.c,v 1.2 2006/05/01 22:54:00 saroun Exp $

C-wrappers for dynamically linked procedures (EXCI module) of RESTRAX
(c) J. Saroun, 2005, saroun@ujf.cas.cz
*/

#include <stdio.h>
#include <string.h>
#include <windows.h>
#include "exci.h"

static char *lastname=NULL;
static float excinumber=0.0;
HINSTANCE excihandle=NULL;
void (*exc)();
void (*readexcpar)();
void (*repexcpar)();
void (*openexcifile)();
void (*closeexcifile)();
void (*setexcidefault)();
float (*exciver)();

static struct qomega *rqomega=NULL;
static struct model *rmodel=NULL;
static struct reclattice *rlat=NULL;


/* Simple replacement for dlerror() */
int dlerror() {
  int ie;
  ie=GetLastError();
//~ printf("dlerror: %d\n",ie);
  if (ie !=0 ) {
     SetLastError(0); // clear error info
     return ie;
  } else {
     SetLastError(0); // clear error info
     return 0;
  };
}


/* Copy string src to lastname, takes care about memory allocation
 returns number of copied characters */
int cpstring(const char *src) {
  char *cpt;
  if (lastname != NULL) {
    free(lastname);
    lastname=NULL;
  };
  if (src == NULL) {
    lastname=NULL;
    return 0;
  };
  
  lastname = (char *) malloc(strlen(src) + 1);
  if (lastname == NULL) return -1;
  cpt=strcpy(lastname,src);
  if (cpt == NULL) {
        printf("Error in strcpy: <%s> <%s>\n",lastname,src);
        return -2;        
  };
  return strlen(lastname);
};

/* Release EXCI library */
void RELEASEEXCI() {
    int error;
    if (excihandle != NULL) {
      dlerror();    /* Clear any existing error */
      FreeLibrary(excihandle);
      if ((error = dlerror()) != 0)  {
         fprintf (stderr, "Error in RELEASEEXCI_ :%d\n", error);
         return;
      };               
      printf("EXCI released: %s\n",lastname);        
      if (lastname != NULL) {
        free(lastname);
        lastname=NULL;
      };
      excihandle=NULL;
      exc=NULL;
      readexcpar=NULL;
      repexcpar=NULL;
      openexcifile=NULL;
      setexcidefault=NULL;
      exciver=NULL;
      /* allocate data locally, so that they can be used by RESTRAX */
      rqomega=NULL;
      rmodel=NULL;
      rlat=NULL;     
    };     
};

/* Load symbol from EXCI, type void 
name ... symbol name (input)
ires on input ... must be >0, otherwise loadsym returns NULL
ires on output ... <0 error, 1 OK 
*/
void *loadsym(const char *name, int *ires) {
  int error;
  int *sh=NULL;
  dlerror(0);    /* Clear any existing error */
  if (*ires >= 0 && excihandle != NULL ) {
    *(void **) (&sh) = GetProcAddress(excihandle, name);
    if ((error = dlerror()) != 0)  {
      fprintf (stderr, "Error: cannot read symbol %s from %s \n", name,lastname);
      RELEASEEXCI();
      *ires=-4;
    } else {
    *ires=1;
    //~ printf("Loaded symbol: %s %p\n",name,sh);
    };
  };
  //~ printf("symbol: %s, pointer: %p, result: %d, handle: %p \n",name,sh,ires,excihandle);
  return sh;
};

/* Load the EXCI library dynamically 
Return: 
<0 if error occured (EXCI released)
=0 if nothing changed
=1 if new EXCI was loaded

*/
int LOADEXCI(char *excilibname) {
    int ires=0;
    int icom;
    double *q[4],*omexc[6],*sqom[6];
    long ilen;

/* excilibname=="" => free previously loaded libraray and exit*/    
    if (excilibname=="") {
      RELEASEEXCI();
      return -1;      
    };
    
 /* compare new library name with the current one */ 
   if (lastname != NULL) {
      icom=strcmp(lastname,excilibname);
    } else { icom=-1; };
    
/* Load a new library named *excilibname if 
 (a) there is no library loaded, or  
 (b) the names of the current and requested libraries are different, or
 (c) excihandle == NULL 
*/ 
    if ((icom!=0) || (!excihandle)) {

/* release previously loaded libraray if necessary */    
      RELEASEEXCI();  
      dlerror(0); 
      excihandle = LoadLibrary(excilibname);
      ires=dlerror(); 
      if ((ires != 0) || !excihandle) {
        fprintf (stderr, "Cannot load library: %s, error=%d\n", excilibname,dlerror());       
        return -2;
      };     
      
      ilen=cpstring(excilibname);
      ires=0;        
/* load symbols for the fortran subroutines in EXCI */    
      *(void **) (&exciver)=loadsym("_EXCIVERSION",&ires);
      if (ires > 0) {
        excinumber=exciver();       
        printf("EXCI loaded: %s, version=%1.3f\n",lastname,excinumber);
      };
      
      *(void **) (&exc)=loadsym("_EXCI",&ires); 
      *(void **) (&readexcpar)=loadsym("_READEXCIPAR",&ires); 
      *(void **) (&openexcifile)=loadsym("_OPENEXCIFILE",&ires); 
      *(void **) (&closeexcifile)=loadsym("_CLOSEEXCIFILE",&ires); 
      *(void **) (&repexcpar)=loadsym("_REPEXCIPAR",&ires); 
      *(void **) (&setexcidefault)=loadsym("_SETEXCIDEFAULT",&ires);
/* load pointers to structures equivalent to the COMMON blocks in EXCI */   
      *(void **) (&rqomega)=loadsym("__CQOMEGA",&ires);
      *(void **) (&rmodel)=loadsym("__CMODEL",&ires);
      *(void **) (&rlat)=loadsym("__CRECLATTICE",&ires);

/* if everything is OK, set default values and initialize EXCI  */
      if (ires > 0) {
        (*setexcidefault)(); 
/* calling exci with icom<-10 will set user-defined defaults 
like parameter names, user data filenames, and other initializations
needed only once at library loading*/            
        icom=-999; 
        (*exc)(&icom,q,omexc,sqom); 
        return 1;
      } else return ires;      
    };
    return 0;

};


/* C wrapper for dynamically loaded fortran subroutines defined in shared library res_EXCI..*/

void EXCI(int *icom, double *q[],double *omexc[],double *sqom[])
{
  if (exc !=NULL ) (*exc)(icom,q,omexc,sqom);
  //~ printf("EXCI: icom=%d, omexc=%d, sqom=%d \n",*icom,*omexc[0],*sqom[0]);
};

void READEXCIPAR() 
{
 if (readexcpar !=NULL ) (*readexcpar)();
};

void REPEXCIPAR() 
{
 if (repexcpar !=NULL ) (*repexcpar)();
};

void OPENEXCIFILE(int *iunit,char *fnam,int *ires) 
{
 if (openexcifile !=NULL ) (*openexcifile)(iunit,fnam,ires,strlen(fnam));
}; 

void CLOSEEXCIFILE(int *iunit) 
{
 if (closeexcifile !=NULL ) (*closeexcifile)(iunit);
}; 

void SETEXCIDEFAULT() {
 if (setexcidefault !=NULL ) (*setexcidefault)();
};


float EXCIVERSION() 
{
 return excinumber;
};

void GETMODEL(struct model *arg) {
int ires=1;
*(void **) (&rmodel)=loadsym("__CMODEL",&ires);
if (rmodel !=NULL ) *arg=*rmodel;
};

void SETMODEL(struct model *arg) {
int ires=1;
*(void **) (&rmodel)=loadsym("__CMODEL",&ires);
 if (rmodel !=NULL ) *rmodel=*arg;
 //~ printf("Size of rmodel: %d\n",sizeof(*rmodel));   
};

void GETQOMEGA(struct qomega *arg) {
int ires=1;
*(void **) (&rqomega)=loadsym("__CQOMEGA",&ires);
 if (rqomega !=NULL ) *arg=*rqomega;
};

void SETQOMEGA(struct qomega *arg) {
int ires=1;
*(void **) (&rqomega)=loadsym("__CQOMEGA",&ires);
if (rqomega !=NULL ) *rqomega=*arg;
 //~ printf("Size of rqomega: %d\n",sizeof(*rqomega));
};

void GETRECLAT(struct reclattice *arg) {
int ires=1;
*(void **) (&rlat)=loadsym("__CRECLATTICE",&ires);
 if (rlat !=NULL ) *arg=*rlat;
};

void SETRECLAT(struct reclattice *arg) {
int ires=1;
 *(void **) (&rlat)=loadsym("__CRECLATTICE",&ires);
 
 if (rlat !=NULL ) *rlat=*arg;   
 //~ printf("Size of rlat: %d \n",sizeof(*rlat));
 //~ printf("arg.smat[1] : %f\n",(*arg).smat[1]);
 //~ printf("rlat.cosb[1]: %f\n",&(*rlat).cosb[1]);
};

/*  light version of getqomega ... does not pass arrays*/
void GETQOMEGAINF(int *ndatqom, double *chkqom) {
int ires=1;
*(void **) (&rqomega)=loadsym("__CQOMEGA",&ires);
 if (rqomega !=NULL ) {
   *ndatqom=(*rqomega).ndatqom;
   *chkqom=(*rqomega).chkqom;
 };
};

/*  light version of setqomega ... does not pass arrays*/
void SETQOMEGAINF(int *ndatqom, double *chkqom) {
int ires=1;
*(void **) (&rqomega)=loadsym("__CQOMEGA",&ires);
 if (rqomega !=NULL ) {
   (*rqomega).ndatqom=*ndatqom;
   (*rqomega).chkqom=*chkqom;
 };
};

