C//////////////////////////////////////////////////////////////////////
C////  $Id: exci_handle.f,v 1.9 2006/05/09 19:07:46 saroun Exp $
C////
C////  R E S T R A X   4.80
C////
C////  Subroutines for handling EXCI library: 
C////  initialization, selection dialog etc.
C////
C//////////////////////////////////////////////////////////////////////

C*****************************************************************************
      SUBROUTINE EXCTEST
C*****************************************************************************
      IMPLICIT NONE
      INCLUDE 'const.inc'
      INCLUDE 'exciimp.inc'
      RECORD /MODEL/ arg

      integer*4 i
      
      call getmodel(arg)
1     format('EXCTEST_GET :',10(1x,G8.3))
        write(*,1) arg.FIXPARAM(1),arg.FIXPARAM(2)
        write(*,1) arg.WEN

! change arg and send it to EXCI      
      arg.FIXPARAM(1)=1
      arg.FIXPARAM(2)=1
      do i=1,6
        arg.WEN(i)=i+10.D0
      enddo      
      call setmodel(arg)
      
! change arg locally
      arg.FIXPARAM(1)=0
      arg.FIXPARAM(2)=0
      do i=1,6
        arg.wen(i)=1.0D-1
      enddo
2     format('EXCTEST_CLR :',10(1x,G8.3))
        write(*,2) arg.FIXPARAM(1),arg.FIXPARAM(2)
        write(*,2) arg.WEN
      
! reload arg from EXCI:      
      call getmodel(arg)      
3     format('EXCTEST_SET :',10(1x,G8.3))
        write(*,3) arg.FIXPARAM(1),arg.FIXPARAM(2)
        write(*,3) arg.WEN

      END
      
C*****************************************************************************
      SUBROUTINE INITEXCI(IREAD,ISQOM)
C Read EXCI parameters and initialize EXCI
C if IREAD>0, read exci parameters even if they are normally not read (EXCREAD<2)  
C if ISQOM>0, call GETSQOM to fill QOM arrays with resol. functions    
C*****************************************************************************
      IMPLICIT NONE
      INCLUDE 'config.inc'
      INCLUDE 'const.inc'
      INCLUDE 'inout.inc'
      INCLUDE 'restrax.inc'
      INCLUDE 'exciimp.inc'
      RECORD /MODEL/ rm
     
      CHARACTER*128 fpath,fileph  
      INTEGER*4 IREAD,ISQOM,loadexci  
      INTEGER*4 i,IRES,IS,IL,IS1,IL1,IS2,IL2,IS3,IL3
      LOGICAL*4 LOG1
      REAL*8 DUM4(4),DUM6(6),dum61(6)
      REAL*8 CHKQOM,GETSQOM
      REAL*4 exciversion,e
      INTEGER*4 INIT,IU     
      DATA INIT,IU /0,13/

2     format('Read a file with EXCI parameters, type <Q> to quit:')
3     format(a)
4     format('Error when loading EXCI module: ',a,
     &       ' error ',I2)
6     format('EXCI module ',a,' has already been loaded ')
5     format('WARNING: Incompatible version of EXCI module ',/,
     &       ' loaded: ', G10.4, 'required: ', G10.4)


c      write(*,*) 'call INITEXCI ',IREAD,ISQOM
      
C Load EXCI module
      CALL BOUNDS(EXCILIB,IS,IL)
      ires= loadexci(EXCILIB(IS:IS+IL-1)//char(0))
C Message and return when loading failed
      IF(IRES.LT.0) THEN
        write(smes,4) EXCILIB(IS:IS+IL-1),ires
        return
      ENDIF
C Message when loading skipped - identical library name
      IF(IRES.EQ.0.AND.IREAD.GT.0) THEN
        write(smes,6) EXCILIB(IS:IS+IL-1)
      ENDIF
      
      CALL RECLAT ! calculate rec. lattice transformation matrices and send them to EXCI
C get model data from EXCI
      call getmodel(rm)      
      
C Check module version      
      e=exciversion()
      if (EXCI_NUMBER.NE.e) THEN
C Warning message if version is different      
        write(sout,5) e,EXCI_NUMBER
      endif
      

C Read parameters from a file if 
C a) required by EXCI author (EXCREAD>1)
C b) allowed by the author (EXCREAD=1)  AND 
C called for the first time or required by the argument (IREAD>0)  
      IF (rm.EXCREAD.GT.1.OR.
     &   (rm.EXCREAD.EQ.1.AND.(INIT.EQ.0.OR.IREAD.GT.0))) THEN
C create search path
        CALL BOUNDS(rm.phonname,IS,IL)
        CALL BOUNDS(RESPATH,IS1,IL1)
        CALL BOUNDS(CFGPATH,IS2,IL2)
        CALL BOUNDS(DATPATH,IS3,IL3)
        fpath=':'//DATPATH(IS3:IS3+IL3-1)//':'//RESPATH(IS1:IS1+IL1-1)//
     &      ':'//CFGPATH(IS2:IS2+IL2-1)
        IRES=-1 
        if (rm.phonname(1:3).eq.'idl') then ! files 'idl..' are read directly
          CALL OPENEXCIFILE(IU,fileph(1:i)//char(0),IRES)
          LOG1=.TRUE.
        else ! otherwise, ask for the filename
          write(smes,2)     
          CALL DLG_FILEOPEN(rm.phonname(IS:IS+IL-1),fpath,'par',1,1,ires,fileph)
          i=LEN_TRIM(fileph) 
          LOG1=(ires.gt.0.AND.i.GT.0)
C quit file loading by giving 'Q' as the filename
          LOG1=(LOG1.AND.fileph(1:i).ne.'Q'.AND.fileph(1:i).NE.'q')  
          IF (LOG1) CALL OPENEXCIFILE(IU,fileph(1:i)//char(0),IRES)
        endif
        IF (LOG1.AND.IRES.EQ.0) THEN 
            rm.phonname=fileph(1:i)
            rm.EXCUNIT=IU
            call setmodel(rm) ! pass phonname to EXCI
            CALL READEXCIPAR
            CALL CLOSEEXCIFILE(IU)
            call getmodel(rm) ! get updated model data from EXCI
        ELSE
            write(sout,*) 'No EXCI parameter file read ... '
        ENDIF
      ENDIF

C fill QOM arrays with simulated resolution functions
      IF (ISQOM.NE.0) CHKQOM=GETSQOM(1,mf_max) 

C report EXCI status
      IF (IREAD.NE.0) CALL REPEXCIPAR 
            
C initialize EXCI 
      CALL EXCI(0,DUM4,DUM6,DUM61)  
C get updated  model data from EXCI
      call getmodel(rm)
      INIT=1
C copy parameters for fitting from EXCI 
      do i=1,rm.nterm
            fpar(i) = rm.param(i)
            jfixed(i) = rm.fixparam(i)
      end do
      nfpar=rm.nterm

C clear histograms      
      CALL HISTINIT ! set bit1=0 => no RHIST ready
      JFIT=0 ! and make previous fit invalid
      WHATHIS=ior(WHATHIS,4) ! set bit3=1 => EXCI module can be used to produce RHIST
c test      
c      call EXCTEST
      END      

C*****************************************************************************
      SUBROUTINE SETEXCI(SARG,INITEX)
C Get the name of EXCI module, load it and call INITEXCI
C if SARG<>' ', then use SARG as the module name
C if INITEX>0, call INITEXCI
C*****************************************************************************
      IMPLICIT NONE
      INCLUDE 'const.inc'
      INCLUDE 'inout.inc'
      INCLUDE 'config.inc'  
      
      INTEGER*4 IS,IL,ires,loadexci,INITEX
      CHARACTER*(*) SARG
      CHARACTER*128 NAME 
      
C get module filename
      NAME=SARG
10    CALL BOUNDS(EXCILIB,IS,IL)
      IF (NAME.EQ.' ') THEN
        NAME=EXCILIB(IS:IS+IL-1)
        CALL DLG_STRING('EXCI library',NAME,1)
      ENDIF
      CALL BOUNDS(NAME,IS,IL) 

C load the module
!      write(*,*) 'SETEXCI: loadexci: ',NAME(IS:IS+IL-1)
      
      IF (INDEX(NAME(IS:IS+IL-1),'.').LE.0) THEN
        NAME=NAME(IS:IS+IL-1)//'.'//SHEXT
        CALL BOUNDS(NAME,IS,IL)
      ENDIF
      ires= loadexci(TRIM(NAME)//char(0))
            
C if not successful, try again interactively            
      IF(IRES.LT.0.AND.NAME.NE.' ') THEN
        NAME=' '   
        GOTO 10
      ENDIF 
      
C if successful, call INITEXCI         
      IF (ires.ge.0) THEN
        EXCILIB=NAME(IS:IS+IL-1)
        IF (INITEX.GT.0) CALL INITEXCI(1,1)
      ENDIF
      
      END

