C//////////////////////////////////////////////////////////////////////
C////                                                              //// 
C////  NEutron Scattering Simulation - v.2.0, (c) J.Saroun, 1999   ////
C////                                                              //// 
C//////////////////////////////////////////////////////////////////////
C////
C////  Subroutines describing objects - BENDER
C////  
C////  * LOGICAL*4 FUNCTION BENDER_PASS(OBJ,R,IH,IV,exit)
C////  * LOGICAL*4 FUNCTION CONTACT(X0,Z0,alpha,RO,kx,kz,T)
C////  * REAL*8 FUNCTION BENDER_REF(ID,OBJ,Q,S)
C////  * SUBROUTINE BENDER_INIT(OBJ)
C////  * LOGICAL*4 FUNCTION BENDER_GO(OBJ,NEUI,NEUF)
C////  
C//////////////////////////////////////////////////////////////////////



C	--------------------------------------------------
	LOGICAL*4 FUNCTION BENDER_PASS(OBJ,R,IH,IV,exit)
c	Checks, whether neutron fits within any slit and 
c       returns slit coordinates
C	--------------------------------------------------	
        IMPLICIT NONE
        INCLUDE 'nesobj_bender.inc'
        INTEGER*4 IH,IV,exit
        LOGICAL*4 LOG1
        REAL*8 R(3),jh,jv,W,H
        RECORD /BENDER/ OBJ

        if (exit.EQ.1) then 
           W=OBJ.W2
           H=OBJ.H2
        else
           W=OBJ.FRAME.SIZE(1)
           H=OBJ.FRAME.SIZE(2)
        endif 
        jh=(R(1)/W+0.5)*OBJ.NLH
        jv=(R(2)/H+0.5)*OBJ.NLV
        IH=NINT(jh-0.5)
        IV=NINT(jv-0.5)
        LOG1=((ABS(jh-NINT(jh))*W/OBJ.NLH.GE.OBJ.DLH/2.).AND.
     1        (ABS(jv-NINT(jv))*H/OBJ.NLV.GE.OBJ.DLV/2.).AND.
     1        (jh.GT.0.).AND.
     1        (jv.GT.0.).AND.
     1        (jh.LT.OBJ.NLH).AND.
     1        (jv.LT.OBJ.NLV))
              
        BENDER_PASS=LOG1
C	if (ABS(R(1)).LT.0.1) then	     
C           write(*,*) 'PASS : ',JH,IH,OBJ.FRAME.COUNT
C           write(*,*) 'PASS : ',OBJ.DLH,W	   
C	   write(*,*) 'PASS : ',OBJ.DLH/2./W,ABS(jh-ih)
C	   write(*,*)
C        endif
        END  

        
C	----------------------------------------------------------------------
	LOGICAL*4 FUNCTION CONTACT(X0,Z0,alpha,RO,kx,kz,T)
c	finds next contact with a lamella and returns time T needed 
C       to reach it
C       X0,Z0 ... initial coordinates of the neutron with respect
C                 to the lamella front end
C       alpha ... lamella inclination angle (without curvature)
C       R0    ... lamella curvature
C       kx,kz ... transversal and longitudinal components of neutron 
C                 k vector
C	-----------------------------------------------------------------------	
        IMPLICIT NONE
        LOGICAL*4 LOG1, QUADREQ
        REAL*8 X0,Z0,alpha,RO,kx,kz,T,A,B,C

        A=0.5*ro*kz**2
        B=alpha*kz-kx+ro*kz*z0
        C=alpha*z0+0.5*ro*z0**2-x0
        LOG1=QUADREQ(A,B,C,T)
        CONTACT=LOG1
        END



C	---------------------------------------------------
	REAL*8 FUNCTION BENDER_REF(ID,OBJ,Q,S)
c	returns reflectivity for given momentum transfer Q
C       ID identifies which surface is touched
C       ID=0  left 
C       ID=1  right 
C       ID=2  top 
C       ID=3  bottom 
C	---------------------------------------------------	
        IMPLICIT NONE
        INCLUDE 'const.inc'      
        INCLUDE 'nesobj_bender.inc'
        
        INTEGER*4 iz,ID,NR
        REAL*8 Q,S,z,dQ,Q1,gamma,R	
     
        RECORD /BENDER/ OBJ
           
        if (ID.EQ.0) then 
          if (S.ge.0) then
            gamma=OBJ.GHLU
            R=OBJ.RHLU
            NR=OBJ.NHLU
          else  
            gamma=OBJ.GHLD
            R=OBJ.RHLD
            NR=OBJ.NHLD
          endif 
        else if (ID.EQ.1) then 
          if (S.ge.0) then
            gamma=OBJ.GHRU
            R=OBJ.RHRU
            NR=OBJ.NHRU
          else  
            gamma=OBJ.GHRD
            R=OBJ.RHRD
            NR=OBJ.NHRD
          endif 
        else if (ID.EQ.2) then 
            gamma=OBJ.GVT
            R=OBJ.RVT
            NR=OBJ.NVT
        else if (ID.EQ.3) then 
            gamma=OBJ.GVB
            R=OBJ.RVB
            NR=OBJ.NVB
        else
            gamma=0.   
            R=0. 
        endif    
        
        if (gamma.le.0.OR.Q.LE.0) then
           BENDER_REF=0
           RETURN
        endif   
        
	if(NR.LE.0.OR.NR.GT.5) then
              if (Q.lt.2*PI*gamma) then	                         
                 BENDER_REF=R
              else
                 BENDER_REF=0                 
              endif 
        else
              Q1=Q/2/PI/GammaNi
              dQ=m_alpha(2,NR)-m_alpha(1,NR)
              z=(Q1-m_alpha(1,NR))/dQ
                             
              iz=INT(z)+1
              if(z.LT.0.OR.z.GE.m_n(NR).OR.iz.GE.m_n(NR)) then 
                 BENDER_REF=0                 
              else if (S.GE.0) then
               BENDER_REF=m_ref1(iz,NR)+(z-iz+1)*
     1                (m_ref1(iz+1,NR)-m_ref1(iz,NR))  
              else if (S.LT.0) then
               BENDER_REF=m_ref2(iz,NR)+(z-iz+1)*
     1                (m_ref2(iz+1,NR)-m_ref2(iz,NR))
              else     
                 BENDER_REF=0 
              endif 
        endif        
        
	END
	
C     -------------------------------
      SUBROUTINE BENDER_INIT(OBJ)
C     -------------------------------	
      IMPLICIT NONE
      INCLUDE 'nesobj_bender.inc'
      RECORD /BENDER/ OBJ
      
      CALL SLIT_INIT(OBJ.FRAME)
      OBJ.TYP=0
      IF (OBJ.CURV.NE.0) THEN 
         OBJ.TYP=OBJ.TYP+1
      ENDIF   
      IF (OBJ.GHLU.NE.0.OR.
     *     OBJ.GHLD.NE.0.OR.
     *     OBJ.GHRU.NE.0.OR.
     *     OBJ.GHRD.NE.0.OR.
     *     OBJ.GVT.NE.0.OR.
     *     OBJ.GVB.NE.0) THEN 
        OBJ.TYP=OBJ.TYP+2
      ENDIF
      END  
      

CxxxxxxxxxCxxxxxxxxxCxxxxxxxxxCxxxxxxxxxCxxxxxxxxxCxxxxxxxxxCxxxxxxxxxCx

C	--------------------------------------------
	LOGICAL*4 FUNCTION BENDER_GO(OBJ,NEUI,NEUF)
C	--------------------------------------------	
      IMPLICIT NONE

      INCLUDE 'const.inc'      
      INCLUDE 'nesobj_bender.inc'
      
      RECORD /BENDER/ OBJ
      RECORD /NEUTRON/ NEUI,NEUF
      LOGICAL*4 LOG1, BENDER_PASS,CONTACT
      REAL*8 BENDER_REF
      INTEGER*4 IH,IV,IH1,IV1,I
      REAL*8 V(3),K(3),R(3),R2(3)
      REAL*8 AL,AR,AT,AB,TL,TR,TT,TB,ZL,ZR,ZT,ZB,XL,XR,XT,XB
      REAL*8 KK,DUM,BETA0,DELTA0,P,PP,DT,T,Q,TINI,DPHI
C      LOGICAL*4 FLAG
C      CHARACTER*14 dname
C      CHARACTER*1 CH    
C 100    format('tra',I3,a4,'.dat')
  101    format(1x,7(G10.3,2x),a1)
C 102    format(1x,5(E10.3,2x),2x,a10)
C 103    format(1x,3(E10.3,2x),2x,I4,2x,a10)

      
      NEUF=NEUI			
      call SLIT_PRE(OBJ.FRAME,NEUI.R,NEUI.K,V,K)
      NEUF.T=NEUI.T-V(3)/HOVM/K(3)
      TINI=NEUF.T ! initial time
      PP=1.
      BETA0=0.
      LOG1=.TRUE.
      DO 10 I=1,2
10       R(I)=V(I)-V(3)/K(3)*K(I)
      R(3)=0.
      
      IF (OBJ.FRAME.SIZE(3).LE.0) GOTO 210  ! collimator ignored

C///  check the pass through the entry

C      FLAG=(OBJ.FRAME.NAME(1:4).EQ.'col4'.AND.
C     *      OBJ.FRAME.COUNT.GT.1000.AND.OBJ.FRAME.COUNT.LT.1011) 
C      FLAG=.FALSE.    
C      IF(FLAG) then
C        write(*,101) (NEUI.R(i),i=1,3),(NEUI.K(i),i=1,3)
C        write(*,101) (V(i),i=1,3),(K(i),i=1,3),NEUI.P 
C        write(*,101) (R(i),i=1,3)
C       write(*,*) BENDER_PASS(OBJ,R,IH,IV,0), IH,IV
C      ENDIF 

      IF (.NOT.BENDER_PASS(OBJ,R,IH,IV,0)) GOTO 300      
            
      BETA0=OBJ.CURV*OBJ.FRAME.SIZE(3)


C      CH='I'
C      write(*,103) (R(I),I=1,3),OBJ.FRAME.COUNT,
C    1 OBJ.FRAME.NAME 
C        write(dname,100) OBJ.FRAME.COUNT,OBJ.FRAME.NAME
C        if (dname(4:4).eq.' ') dname(4:4)='0'
C        if (dname(5:5).eq.' ') dname(5:5)='0'
C 	 Open(Unit=15,File=dname,Status='Unknown')
C        write(15,101) (R(i),i=1,3),(K(i),i=1,3),NEUI.P*PP,CH 



C **** normal collimator  ****
      IF (OBJ.TYP.EQ.0) then
        DT=OBJ.FRAME.SIZE(3)/K(3) ! time of flight
        DO I=1,2
	  R2(I)=R(I)+DT*K(I)
        ENDDO     
        R2(3)=OBJ.FRAME.SIZE(3)
        LOG1=(LOG1.AND.BENDER_PASS(OBJ,R2,IH1,IV1,1)) 
C        IF(FLAG) THEN
C          write(*,101) (R2(i),i=1,3),(K(i),i=1,3),NEUI.P 
C          IF (LOG1) write(*,*) BENDER_PASS(OBJ,R,IH,IV,0), IH,IV
C          CALL GETSTATE
C          pause
C        ENDIF  
        IF (LOG1.AND.(IH1.EQ.IH).AND.(IV1.EQ.IV)) then
C	  CH='E'
C         write(15,101) (R2(i),i=1,3),(K(i),i=1,3),NEUI.P*PP,CH 
C           write(*,*) dname 
C           pause          
          DO I=1,3
	    R(I)=R2(I)   ! move to colimator exit
          ENDDO 
          NEUF.T=NEUF.T+DT/hovm  
          GOTO 210     ! free passage 
        ELSE
C         CLOSE(15) 
          GOTO 300     ! no passage
        ENDIF 
      ENDIF

C ****  neutron guide  ****
      
      KK=SQRT(K(1)**2+K(2)**2+K(3)**2)

C  left      
      ZL=(IH+1)*1./OBJ.NLH-0.5
      XL=ZL*OBJ.FRAME.SIZE(1)-0.5*OBJ.DLH
      AL=(OBJ.W2-OBJ.FRAME.SIZE(1))/OBJ.FRAME.SIZE(3)*ZL
C  right      
      ZR=IH*1./OBJ.NLH-0.5
      XR=ZR*OBJ.FRAME.SIZE(1)+0.5*OBJ.DLH
      AR=(OBJ.W2-OBJ.FRAME.SIZE(1))/OBJ.FRAME.SIZE(3)*ZR
C  top      
      ZT=(IV+1)/OBJ.NLV-0.5
      XT=ZT*OBJ.FRAME.SIZE(2)-0.5*OBJ.DLV
      AT=(OBJ.H2-OBJ.FRAME.SIZE(2))/OBJ.FRAME.SIZE(3)*ZT
C  bottom      
      ZB=IV*1./OBJ.NLV-0.5
      XB=ZB*OBJ.FRAME.SIZE(2)+0.5*OBJ.DLV
      AB=(OBJ.H2-OBJ.FRAME.SIZE(2))/OBJ.FRAME.SIZE(3)*ZB
      

C***** beginning of the guide tracing cycle
50    CONTINUE
      
      IF (CONTACT(R(1)-XL,R(3),AL,OBJ.CURV,K(1),K(3),T)) then
         TL=T 
      ELSE
         TL=1.D35
      ENDIF     
      
      IF (CONTACT(R(1)-XR,R(3),AR,OBJ.CURV,K(1),K(3),T)) then
         TR=T 
      ELSE
         TR=1.D35
      ENDIF
           
      IF (CONTACT(R(2)-XT,R(3),AT,0.D0,K(2),K(3),T)) then
         TT=T 
      ELSE
         TT=1.D35
      ENDIF
      	 
      IF (CONTACT(R(2)-XB,R(3),AB,0.D0,K(2),K(3),T)) then
         TB=T 
      ELSE
         TB=1.D35
      ENDIF
	     	 
      DT=MIN(TL,TR,TT,TB)
      
      IF(DT.EQ.1.D35) THEN
         DT=0.
      ENDIF	 
	 
C go to a point of reflection             
      DO I=1,3
         R2(I)=R(I)  ! remember old position !
      ENDDO   

      DO I=1,3
           R(I)=R(I)+K(I)*DT  ! go to the contact point
      ENDDO 

      IF (R(3).GT.OBJ.FRAME.SIZE(3)) THEN  ! bender exit
         DT=(OBJ.FRAME.SIZE(3)-R2(3))/K(3)
	 DO I=1,3
               R(I)=R2(I)+DT*K(I)
         ENDDO 
	 NEUF.T=NEUF.T+DT/hovm  
C	 CH='E'
C        write(15,101) (R(i),i=1,3),(K(i),i=1,3),NEUI.P*PP,CH 
         GOTO 199  
      ENDIF 
      
      NEUF.T=NEUF.T+DT/hovm        
C     CH='X'       
      IF (DT.EQ.TL) THEN
	  Q=K(1)-(AL+R(3)*OBJ.CURV)*kk
          P=BENDER_REF(0,OBJ,Q,NEUI.S)
	  IF (P.GT.0) K(1)=K(1)-2*Q  
C	  CH='L'          
      ELSE IF (DT.EQ.TR) THEN
	  Q=-K(1)+(AR+R(3)*OBJ.CURV)*kk
          P=BENDER_REF(1,OBJ,Q,NEUI.S)
	  IF (P.GT.0) K(1)=K(1)+2*Q 
C	  CH='R'             
      ELSE IF (DT.EQ.TT) THEN
	  Q=K(2)-AT*kk
          P=BENDER_REF(2,OBJ,Q,NEUI.S)
	  IF (P.GT.0) K(2)=K(2)-2*Q 
C	  CH='T'             
      ELSE IF (DT.EQ.TB) THEN
	  Q=-K(2)+AB*kk
          P=BENDER_REF(3,OBJ,Q,NEUI.S)
	  IF (P.GT.0) K(2)=K(2)+2*Q 
C	  CH='B'             
      ENDIF
      PP=PP*P
      IF (PP.LT.1.D-4) PP=0
      IF (PP.GT.0) then
        DUM=SQRT(K(1)**2+K(2)**2+K(3)**2)
        DO I=1,3
          K(I)=K(I)*KK/DUM
        ENDDO
C       write(15,101) (R(i),i=1,3),(K(i),i=1,3),NEUI.P*PP,CH 
	GOTO 50
      ENDIF 


      
C      CLOSE(15)
C      if (PP.GT.0) then
C         write(*,*) dname, 'error' 
C         pause
C      endif

      GOTO 300
     
199   CONTINUE
C      CLOSE(15)
C      if (PP.GT.0) then
C         write(*,*) dname 
C         pause
C      endif

200   CONTINUE
      IF (BETA0.NE.0) THEN  !  correction for beam deflection
         DELTA0=0.5*OBJ.CURV*OBJ.FRAME.SIZE(3)**2        
         R2(1)=R(1)-R(3)*BETA0+DELTA0
         R2(3)=R(3)+R(1)*BETA0
         K(1)=K(1)-K(3)*BETA0
         K(3)=K(3)+K(1)*BETA0
         DUM=SQRT(K(1)**2+K(2)**2+K(3)**2)
         DO I=1,3                        ! renormalize k
              K(I)=K(I)*KK/DUM
              R(I)=R2(I)
         ENDDO                 
      ENDIF
210   CALL SLIT_POST(OBJ.FRAME,R,K,NEUF.R,NEUF.K)	   
      NEUF.P=NEUI.P*PP
      OBJ.FRAME.COUNT=OBJ.FRAME.COUNT+1 
      IF(ABS(OBJ.BINT).GT.0.) THEN
        DPHI=GAMMAL*OBJ.BINT/OBJ.FRAME.SIZE(3)*(NEUF.T-TINI)*1D-3
        NEUF.PHI=NEUF.PHI+DPHI  
      ENDIF
      BENDER_GO=.TRUE.
      RETURN

300   CONTINUE
      BENDER_GO=.FALSE.
      NEUF.P=0
 	
      RETURN
      END        

C---------------------------------------------------------------	
      INTEGER*4 FUNCTION READ_MIRROR(QC)
C read reflectivity data for supemirror (used in BENDER by NESS)
C *** J.S. 8/3/1999     
C---------------------------------------------------------------      
      IMPLICIT NONE
      INCLUDE 'const.inc'
      INCLUDE 'inout.inc'
      INCLUDE 'nesobj_bender.inc'
      INTEGER*4 ierr,INDX,i,j	
      REAL*8 mNi,Z,QC
      CHARACTER*3 SUFFIX
      CHARACTER*9 FNAME
      CHARACTER*128 MIRFILE


      mNi=QC/GammaNi 
      READ_MIRROR=0 
      IF(mNi.LT.0) GOTO 200   ! clear all
      IF(mNi.EQ.0) GOTO 100
      Z=LOG10(mNi)
      IF (Z.LT.-1.OR.Z.GE.1) GOTO 100  ! must be 0.1 <= mNi < 10
1     FORMAT(F3.1)
      WRITE(SUFFIX,1,err=2) mNi
2     FNAME='mirror'//SUFFIX      

      I=1
      DO WHILE(I.LE.m_nmax.AND.m_name(I).NE.SUFFIX.AND.m_n(I).GT.0)
         I=I+1
      ENDDO
      IF (I.GT.m_nmax) GOTO 99
      IF  (m_name(I).EQ.SUFFIX) THEN
         READ_MIRROR=I
         RETURN
      ENDIF
      INDX=I                       
c      OPEN(22,FILE=FNAME,STATUS='OLD',ERR=100)
      CALL OPENRESFILE(FNAME,' ',22,0,2,MIRFILE,IERR)
      IF(IERR.NE.0) GOTO 100
      Read(22,*,iostat=ierr,end=30,err=100)
      i=0
      do while(ierr.eq.0.and.(i.lt.128))
          Read(22,*,iostat=ierr,end=30,err=30)  
     *      m_alpha(i+1,indx), m_ref1(i+1,indx),m_ref2(i+1,indx)
          i=i+1          
      enddo 
30    CLOSE(22)
      m_n(indx)=i
      m_name(indx)=SUFFIX
3     FORMAT('reflectivity (',I1,') read: ',a9,' ,',I3,' lines.')   
      write(sout,3) INDX,FNAME,I
      READ_MIRROR=INDX
      return

99    write(SMES,*) 'Error: Lookup table for mirrors is full!'
      READ_MIRROR=-1
      RETURN

100   READ_MIRROR=0
      return

200   do j=1,m_nmax
        do i=1,128
            m_alpha(i,j)=i
            m_ref1(i,j)=0
            m_ref2(i,j)=0
        enddo
        m_n(j)=0
        m_name(j)=' '
      enddo
      READ_MIRROR=0
      end


      
C//////////////////  End of definition - BENDER  ///////////////////

C---------------------------------------------------
	SUBROUTINE BENDER_WRITE(IU,OBJ)
C     Writes parameters of OBJ to unit U
C--------------------------------------------------
      IMPLICIT NONE

      INCLUDE 'nesobj_bender.inc'
      INTEGER*4 IU
      RECORD /BENDER/ OBJ

2     FORMAT(' nlh,nlv : ',2(2x,I4))
3     FORMAT(' w2,h2 : ',2(2x,F8.1))
4     FORMAT(' crit. angles : ',6(2x,E12.3))
5     FORMAT(' 1/R  : ',E12.3)
6     FORMAT(' dlh,dlv : ',2(2x,F8.3))
7     FORMAT(' reflectivities : ',6(2x,F8.3))
8     FORMAT(' int(B) : ',G12.5)

      CALL SLIT_WRITE(OBJ.FRAME,IU)
      WRITE(IU,*)
      WRITE(IU,3) OBJ.w2, OBJ.h2
      WRITE(IU,2) OBJ.nlH,OBJ.nlV 
      WRITE(IU,6) OBJ.dlH,OBJ.dlV 
      WRITE(IU,4) OBJ.GHLU,OBJ.GHLD,OBJ.GHRU,OBJ.GHRD,
     1            OBJ.GVT,OBJ.GVB
      WRITE(IU,7) OBJ.RHLU,OBJ.RHLD,OBJ.RHRU,OBJ.RHRD,
     1            OBJ.RVT,OBJ.RVB   
      WRITE(IU,5) OBJ.CURV   
      WRITE(IU,8) OBJ.BINT   
      RETURN
      END  



