C-------------------------------------------------------------------
        LOGICAL*4 FUNCTION QUADREQ(A,B,C,X)
C*****  Solve quadratic equation and returns X=min. positive solution	
C-------------------------------------------------------------------
 	parameter (eps=1e-10)
	REAL*8 A,B,C,X,X1,X2,DET

        if (A.EQ.0) then          
          if (ABS(B).LT.EPS) then 
             GOTO 20
          else
             X=-C/B
             GOTO 30
          endif
        else          
          DET=B**2-4*A*C
          if  (DET.EQ.0.) then
             X=-B/2./A
             goto 30
          else if (DET.LT.0.) then
             goto 20
          else
             DET=SQRT(DET) 
             X1=(-B+DET)/2./A
             X2=(-B-DET)/2./A
             if (X1.GT.EPS.AND.X2.GT.EPS) then
                 X=MIN(X1,X2)
             else if (X1.GT.EPS) then
                 X=X1
             else if (X2.GT.EPS) then
                 X=X2
             else 
                 goto 20
             endif
             goto 30
          endif
        endif 
                  
20      QUADREQ=.FALSE.
        X=1.D30
        RETURN

30      if (X.GT.EPS) then
           QUADREQ=.TRUE.
        else
            goto 20
        endif
        RETURN  

	END
	
