C//////////////////////////////////////////////////////////////////////
C////                                                              //// 
C////  NEutron Scattering Simulation - v.2.0, (c) J.Saroun, 1999   ////
C////                                                              //// 
C//////////////////////////////////////////////////////////////////////
C////
C////  **** Subroutines for object: SLIT ****
C////  
C////  SLIT is parent type for all NESS components
C////  (i) routines must be defined in any descendant
C////  
C////    ** I/O routines **
C////i    SUBROUTINE SLIT_CMD(OBJ)
C////i    SUBROUTINE SLIT_WRITE(OBJ,IU)
C////i    INTEGER*4 FUNCTION SLIT_READ(OBJ,IU,IERR)
C////i    INTEGER*4 FUNCTION SLIT_SET(OBJ,source)
C////i    CHARACTER*(*) FUNCTION SLIT_GET(OBJ,iwhat)
C////  
C////    ** M.C. routines **
C////i    SUBROUTINE SLIT_INIT(OBJ)
C////i    LOGICAL*4 FUNCTION SLIT_GO(OBJ,NEUI,NEUF)
C////
C////    LOGICAL*4 FUNCTION INSIDE(OBJ,R)
C////    SUBROUTINE SLIT_PRE(OBJ,R0,K0,R,K)
C////    SUBROUTINE SLIT_POST(OBJ,R0,K0,R,K)
C////    SUBROUTINE SLIT_PRE1(OBJ,R0,K0,R,K)
C////    SUBROUTINE SLIT_POST1(OBJ,R0,K0,R,K)
C////  
C//////////////////////////////////////////////////////////////////////


C******************* I/O routines *********************
         

C     ------------------------------------------------
      SUBROUTINE SLIT_WRITE(OBJ,IU)
C     write all setup to IU      
C     ------------------------------------------------
      IMPLICIT NONE
      INCLUDE 'nesobj_slit.inc'
      RECORD /SLIT/ OBJ
      CHARACTER*128 SLIT_GET
      INTEGER*4 IU,I

1     FORMAT(a)
      WRITE(IU,1) '['//T_SLIT//']'
      DO I=1,NLIST
         CALL WRITELINE(SLITCOMM(I)//'  '//SLIT_GET(OBJ,I),IU)
      ENDDO 
      WRITE(IU,1) 'END '//OBJ.NAME 
      END
	
C     ----------------------------------------------------
      INTEGER*4 FUNCTION SLIT_READ(OBJ,IU,IERR)
C     read all setup from IU (input must end with 'END' command)
C     Returns number of read lines, error code is in IERR
C     ----------------------------------------------------
      IMPLICIT NONE
      INCLUDE 'nesobj_slit.inc'
      RECORD /SLIT/ OBJ
      CHARACTER*128 source
      INTEGER*4 SLIT_SET
      INTEGER*4 IU,ierr,iline

1     FORMAT(a)
      ierr=0
      iline=0
      source=' '
      do while (source(1:3).ne.'END'.AND.ierr.EQ.0)
        READ(IU,1,err=100,iostat=ierr) source
        ierr=SLIT_SET(OBJ,source)
        CALL MKUPCASE(source(1:3))
        if (ierr.eq.0) iline=iline+1
      enddo 
100   SLIT_READ=iline

      END
	

C     ------------------------------------------------
      INTEGER*4 FUNCTION SLIT_SET(OBJ,source)
C     ------------------------------------------------
      IMPLICIT NONE

      INCLUDE 'const.inc'      
      INCLUDE 'nesobj_slit.inc'
      
      RECORD /SLIT/ OBJ,DUM
      CHARACTER*(*) source
      CHARACTER*128 values
      INTEGER*4 I,J,ORDCOM,ierr,S,L
      IERR=0
C*** find first parameter as variable name
      S=1
1     FORMAT(a)
      CALL FINDPAR(source,1,S,L)
      SLIT_SET=0
      IF (L.LE.0) RETURN   ! ignore empty string      
      values=source(S+L:LEN(source))
      I=ORDCOM(source(S:S+L-1),slitcomm,nlist)
      IF(I.GT.0.AND.I.LE.6) THEN
        DUM=OBJ
        CALL BOUNDS(values,S,L)
        values=values(S:S+L-1)
        IF (i.eq.1) then          
          READ(values,1,err=100,iostat=ierr) OBJ.NAME      
        ELSE IF (i.eq.2) then
          READ(values,*,err=100,iostat=ierr) (OBJ.SIZE(j),j=1,3)
        ELSE IF (i.eq.3) then
          READ(values,*,err=100,iostat=ierr) OBJ.SHAPE
        ELSE IF (i.eq.4) then
          READ(values,*,err=100,iostat=ierr) OBJ.DIST,OBJ.AXI,
     *    OBJ.AXV
          OBJ.AXI=OBJ.AXI/rad
          OBJ.AXV=OBJ.AXV/rad 
        ELSE IF (i.eq.5) then
          READ(values,*,err=100,iostat=ierr) (OBJ.GON(j),j=1,3)
          DO J=1,3
             OBJ.GON(j)=OBJ.GON(j)/rad
          ENDDO   
        ELSE IF (i.eq.6) then
          READ(values,*,err=100,iostat=ierr) (OBJ.STA(j),j=1,3)
        ENDIF
      ENDIF    ! ignores any other string not recognized as variable 
      IF (IERR.NE.0) THEN
         OBJ=DUM
         IERR=-1     !  IO warning
      ENDIF   
      SLIT_SET=ierr
      RETURN
      
100   SLIT_SET=-2    !  IO error
      OBJ=DUM
      END
      

C     ------------------------------------------------
      CHARACTER*(*) FUNCTION SLIT_GET(OBJ,iwhat)
C     ------------------------------------------------
      IMPLICIT NONE
      INCLUDE 'const.inc'      
      INCLUDE 'nesobj_slit.inc'
      
      RECORD /SLIT/ OBJ
      CHARACTER*128 target
      INTEGER*4 j,iwhat

1      FORMAT(a)
2      FORMAT(3(G13.5,1x))
3      FORMAT(I5) 

      target=' '
      IF (iwhat.GT.0.AND.iwhat.LE.6) THEN
        IF (iwhat.eq.1) then
           WRITE(target,1) OBJ.NAME      
        ELSE IF (iwhat.eq.2) then
           WRITE(target,2) (OBJ.SIZE(j),j=1,3)
        ELSE IF (iwhat.eq.3) then
           WRITE(target,3) OBJ.SHAPE
        ELSE IF (iwhat.eq.4) then
           WRITE(target,2) OBJ.DIST, OBJ.AXI/deg,OBJ.AXV/deg
        ELSE IF (iwhat.eq.5) then
           WRITE(target,2) (OBJ.GON(j)/deg,j=1,3)
        ELSE IF (iwhat.eq.6) then
           WRITE(target,2) (OBJ.STA(j),j=1,3)
        ENDIF
      ELSE
           SLIT_GET=' '
      ENDIF         
      SLIT_GET=target
      END
	
C********************* M.C. routines **************************

C	-------------------------------------------
	LOGICAL*4 FUNCTION INSIDE(OBJ,R)
C       Returns .TRUE. if R(3) is inside the SLIT	
C	-------------------------------------------	
	implicit NONE

        INCLUDE 'nesobj_slit.inc'
      
	RECORD /SLIT/ OBJ
	REAL*8 R(3)
	LOGICAL*4 LOG1
	
	IF (OBJ.SHAPE.EQ.3) THEN                     ! rectangle
	   LOG1=(
     1     (ABS(R(1)).LE.OBJ.SIZE(1)/2.).AND.
     2     (ABS(R(2)).LE.OBJ.SIZE(2)/2.).AND.
     3     (ABS(R(3)).LE.OBJ.SIZE(3)/2.))		

        ELSE IF (OBJ.SHAPE.EQ.2) THEN                ! disc
           LOG1=(
     1 	 (((R(1)*2./OBJ.SIZE(1))**2+
     2     (R(2)*2./OBJ.SIZE(2))**2).LE.1).AND.
     3     (ABS(R(3)).LE.OBJ.SIZE(3)/2.)) 
     

        ELSE IF (OBJ.SHAPE.EQ.1) THEN                ! cylinder
           LOG1=(
     1 	 (((R(1)*2./OBJ.SIZE(1))**2+
     2     (R(3)*2./OBJ.SIZE(3))**2).LE.1).AND.
     3     (ABS(R(2)).LE.OBJ.SIZE(2)/2.))      
                 

        ELSE IF (OBJ.SHAPE.EQ.0) THEN                ! ellipsoid
	   LOG1=(
     1     ((R(1)*2./OBJ.SIZE(1))**2+
     2      (R(2)*2./OBJ.SIZE(2))**2+
     3      (R(3)*2./OBJ.SIZE(3))**2).LE.1)

        ELSE 
           LOG1=.FALSE.
        END IF
        
        INSIDE=LOG1
	
C shape = 0 ... ellipsoid
C         1 ... vertical cylinder (axis//y)
c         2 ... disc plate (axis//z)
c         3 ... rectangular     

        RETURN 
	END
	


C---------------------------------
	SUBROUTINE SLIT_INIT(OBJ)
C---------------------------------	
      implicit NONE

      INCLUDE 'nesobj_slit.inc'
	RECORD /SLIT/ OBJ
	REAL*8 STA(3),POS(3),R(3,3),R1(3,3),R2(3,3),R3(3,3),AUX(3,3)
        REAL*8 DUM  ! ,DETERM
        LOGICAL*4 MAP0(3)
        INTEGER*4 I,J
        DATA MAP0 /.TRUE.,.TRUE.,.TRUE./

C rot. matrix for AXI 
	DO 20 I=1,3
	DO 20 J=1,3
	 IF (I.EQ.J) THEN
	    R2(I,J)=1
	 ELSE
	    R2(I,J)=0   
	 ENDIF   
20      CONTINUE
        R2(1,1)=COS(OBJ.AXI)
        R2(3,3)=COS(OBJ.AXI)
        R2(1,3)=-SIN(OBJ.AXI)
        R2(3,1)=+SIN(OBJ.AXI)
        
C rot. matrix for AXV 
	DO 25 I=1,3
	DO 25 J=1,3
	 IF (I.EQ.J) THEN
	    R1(I,J)=1
	 ELSE
	    R1(I,J)=0   
	 ENDIF   
25      CONTINUE
        R1(2,2)=COS(OBJ.AXV)
        R1(3,3)=COS(OBJ.AXV)
        R1(2,3)=+SIN(OBJ.AXV)
        R1(3,2)=-SIN(OBJ.AXV)

C rotation matrix (R) for current axis with respect to the previous one        
        CALL M3XM3(1,R1,R2,R)    
        
C rot. matrix for GON(1)  around axis 2
	DO 30 I=1,3
	DO 30 J=1,3
	 IF (I.EQ.J) THEN
	    R1(I,J)=1
	 ELSE
	    R1(I,J)=0   
	 ENDIF   
30      CONTINUE
        R1(1,1)=COS(OBJ.GON(1))
        R1(3,3)=COS(OBJ.GON(1))
        R1(1,3)=-SIN(OBJ.GON(1))
        R1(3,1)=+SIN(OBJ.GON(1))
        
C rot. matrix for GON(2)  around axis 1 
	DO 40 I=1,3
	DO 40 J=1,3
	 IF (I.EQ.J) THEN
	    R2(I,J)=1
	 ELSE
	    R2(I,J)=0   
	 ENDIF   
40      CONTINUE
        R2(2,2)=COS(OBJ.GON(2))
        R2(3,3)=COS(OBJ.GON(2))
        R2(2,3)=+SIN(OBJ.GON(2))
        R2(3,2)=-SIN(OBJ.GON(2))        
        
C rot. matrix for GON(3)  around axis 2 again 
	DO 50 I=1,3
	DO 50 J=1,3
	 IF (I.EQ.J) THEN
	    R3(I,J)=1
	 ELSE
	    R3(I,J)=0   
	 ENDIF   
50      CONTINUE
        R3(1,1)=COS(OBJ.GON(3))
        R3(3,3)=COS(OBJ.GON(3))
        R3(1,3)=-SIN(OBJ.GON(3))
        R3(3,1)=+SIN(OBJ.GON(3))

C/// 3 transformaton matrices were created:
C/// axis vs. preceding axis (R)
C/// object vs. axis  (OBJ.ROT1=R3*R2*R1)
C/// object vs. preceding axis (OBJ.ROT=ROT1*R)
    
        CALL M3XM3(1,R2,R1,AUX)
        CALL M3XM3(1,R3,AUX,OBJ.ROT1)
        CALL M3XM3(1,OBJ.ROT1,R,OBJ.ROT)        
        
	DO 60 I=1,3
	  OBJ.MAP(I)=.TRUE.
	  IF (1-ABS(OBJ.ROT(I,I)).LT.1.0D-8) OBJ.MAP(I)=.FALSE.
	  OBJ.MAP1(I)=.TRUE.
	  IF (1-ABS(OBJ.ROT1(I,I)).LT.1.0D-8) OBJ.MAP1(I)=.FALSE.
60      CONTINUE

        
        DO I=1,3
          POS(I)=OBJ.STA(I)
          STA(I)=OBJ.STA(I)
        ENDDO
        POS(3)= OBJ.STA(3)+OBJ.DIST  


C /// transform POS and STA to the object coordinates:
 
	CALL M3xV3_M(1,OBJ.MAP1,OBJ.ROT1,POS,OBJ.POS)  
	CALL M3xV3_M(1,OBJ.MAP1,OBJ.ROT1,STA,OBJ.STA)                     

	
	OBJ.COUNT=0   ! counter reset to zero

        DUM=0
        OBJ.SIMPLE=.FALSE.
        DO I=1,3
          DUM=DUM+ABS(OBJ.STA(I))
          DUM=DUM+ABS(OBJ.GON(I))
        ENDDO  
        IF(DUM+ABS(OBJ.AXV).EQ.0) OBJ.SIMPLE=.TRUE. 

C        write(*,*) OBJ.NAME
C        write(*,*) POS
C        write(*,*) OBJ.POS
C        write(*,*) DETERM(R,3,AUX)
C        write(*,*) DETERM(OBJ.ROT,3,AUX),DETERM(OBJ.ROT1,3,AUX)
C        write(*,*) DETERM(R1,3,AUX),DETERM(R2,3,AUX),DETERM(R3,3,AUX)        
C        pause


	RETURN
	END	
	
	
C	------------------------------------------
	LOGICAL*4 FUNCTION SLIT_GO(OBJ,NEUI,NEUF)
C	------------------------------------------	
	implicit NONE

        INCLUDE 'const.inc'      
        INCLUDE 'nesobj_slit.inc'

	RECORD /SLIT/ OBJ
	RECORD /NEUTRON/ NEUI,NEUF
	INTEGER*4 I
	LOGICAL*4 LOG1,INSIDE
	REAL*8 v(3),K(3),R(3)
        			
	LOG1=.TRUE.

C/// At the begining, NEUI.R,K is in the axis coordinates of the
C/// preceding object.	

C/// NEUI.K and NEUI.R must be transformed to the object coordinates
C/// (including rotation and linear shift specified by GON(3) and STA(3):
        
        NEUF=NEUI			
        CALL SLIT_PRE(OBJ,NEUI.R,NEUI.K,V,K)

C/// move neutron to the centre of the SLIT:
	NEUF.T=NEUI.T-V(3)/HOVM/K(3)
	DO 10 I=1,2
10	R(I)=V(I)-V(3)/K(3)*K(I)
        R(3)=0.
    
	IF (INSIDE(OBJ,R)) THEN
	
C/// At the and, NEUF.K and NEUF.R must be in the axis coordinates 
C/// of the object (i.e. without rotation and shift by GON(3) and STA(3))
            CALL SLIT_POST(OBJ,R,K,NEUF.R,NEUF.K)
	    OBJ.COUNT=OBJ.COUNT+1
	ELSE 
	    LOG1=.FALSE.
	    NEUF.P=0
	END IF

	SLIT_GO=LOG1
		
	RETURN
	END 
	
C /////////////////  private subroutines for SLIT  /////////////////	

C	------------------------------------------
	SUBROUTINE SLIT_PRE(OBJ,R0,K0,R,K)
C	------------------------------------------	
	implicit NONE

       INCLUDE 'nesobj_slit.inc'
      
	RECORD /SLIT/ OBJ
	REAL*8 R0(3),K0(3),R(3),K(3),V(3)
C/// Neutron variables are originaly expressed in previous axis coordinates.
C/// Here they are transformed to local object coordinates.	

	IF (.NOT.OBJ.SIMPLE) THEN
C	  write(*,*) OBJ.NAME
       	  CALL M3xV3_M(1,OBJ.MAP,OBJ.ROT,R0,V)
	  CALL M3xV3_M(1,OBJ.MAP,OBJ.ROT,K0,K)
	  CALL V3AV3(-1,V,OBJ.POS,R)
	ELSE
          R(1)=OBJ.ROT(1,1)*R0(1)+OBJ.ROT(1,3)*R0(3)-OBJ.POS(1)
          R(2)=R0(2)
          R(3)=OBJ.ROT(3,1)*R0(1)+OBJ.ROT(3,3)*R0(3)-OBJ.POS(3)
          K(1)=OBJ.ROT(1,1)*K0(1)+OBJ.ROT(1,3)*K0(3)
          K(2)=K0(2)
          K(3)=OBJ.ROT(3,1)*K0(1)+OBJ.ROT(3,3)*K0(3)      	
	ENDIF

	RETURN
	END
	
C	------------------------------------------
	SUBROUTINE SLIT_POST(OBJ,R0,K0,R,K)
C	------------------------------------------	
	implicit NONE

        INCLUDE 'nesobj_slit.inc'
      
	RECORD /SLIT/ OBJ
	REAL*8 R0(3),K0(3),R(3),K(3),V(3)
	INTEGER*4 I
C/// Transform neutron variables back from local object to local axis coordinates	
	IF (.NOT.OBJ.SIMPLE) THEN
	  CALL V3AV3(1,R0,OBJ.STA,V)
          CALL M3xV3_M(-1,OBJ.MAP1,OBJ.ROT1,V,R)
          CALL M3xV3_M(-1,OBJ.MAP1,OBJ.ROT1,K0,K)
	ELSE
	  DO I=1,3
	    K(I)=K0(I)
	    R(I)=R0(I)
	  ENDDO
	ENDIF
	RETURN
	END	

