C//////////////////////////////////////////////////////////////////////
C////  $Id: ness_3ax.f,v 1.2 2005/07/16 16:46:06 saroun Exp $
C////                                                              //// 
C////  NEutron Scattering Simulation - v.1.2, (c) J.Saroun, 1997   ////
C//////////////////////////////////////////////////////////////////////
C////
C////  Subroutines specific to 3-axis spectrometers and conversion
C////  from the RESTRAX-parameter set.
C////
C////  * SUBROUTINE SET_3AX(ICOM)
C////  * LOGICAL*4 FUNCTION SPEC_GO(ICOM)
C////  * SUBROUTINE SPEC_INI(ICLR,IRES)
C////  * SUBROUTINE NESS_CONV 
C////  * SUBROUTINE CREATE_SOL(SOL1,ALPHA,NFM,VLSM,VLCANM,HDM1,HDM2,
C////                          VDM1,VDM2)
C////  * SUBROUTINE WRITE_SETUP(IC) 
C////  
C////  May 1998: 	SOLLERs replaced by BENDERs in all subroutines and commons 
C////  		SET_3AX(2) sets values of critical angles for BENDERs
C////              SET_3AX(3) sets values of BENDERs radii
C////              SET_3AX(4) switch on/off spin flippers
C////              SET_3AX(5) switch on/off magnetization of crystals
C//////////////////////////////////////////////////////////////////////
C***  bug fixed:  GUIDE=2*GAMACR   replaced by GUIDE=GAMACR*MON.LAMBDA
C***  (25/5/98 by J.S.)


C----------------------------------------------------------------
      SUBROUTINE SET_3AX(ICOM)
C     changes sample position (with a possibility to add
C     other parameters not included in RESTRAX3 parameter set.
C     Can be called by the RESTRAX main program as well as by
C     the NESS interactive command interpreter (NESS_LOOP)      
C----------------------------------------------------------------
      IMPLICIT NONE

      INCLUDE 'const.inc'      
      INCLUDE 'inout.inc'
      INCLUDE 'restrax.inc'
      INCLUDE 'restrax_cmd.inc'

      INTEGER*4 NDCOM,NDPAR
      PARAMETER(NDCOM=16,NDPAR=16)
      INTEGER*4 ICOM,NCOM,NPAR,I1,I2,I
      REAL*4   PARAM(NDPAR)          
      CHARACTER*5 COMMANDS(NDCOM)
      

      CHARACTER*4 S1,S2
      COMMON /COMMANDS/ NCOM,COMMANDS,NPAR,PARAM      
      
      IF(NOS.GT.0) THEN
          DO i=1,NOS
             PARAM(I)=RET(I)
          END DO
      ELSE
          DO i=1,NOS
             PARAM(I)=0.
          END DO      
      ENDIF       
      NPAR=NOS            
      
      IF(ICOM.EQ.1) THEN
1       FORMAT(' SPOS = ',3(2x,F7.2))
        IF(NPAR.GE.2) SAM.STA(1)=PARAM(2)
        IF(NPAR.GE.3) SAM.STA(2)=PARAM(3)
        IF(NPAR.GE.1) SAM.STA(3)=PARAM(1)
        PARAM(2)=SAM.STA(1)
        PARAM(3)=SAM.STA(2)
        PARAM(1)=SAM.STA(3)
        WRITE(SOUT,1) (PARAM(I),I=1,3)        
      ENDIF
     
      IF(ICOM.EQ.4) THEN
4       FORMAT(' FLIP = ',2(3x,a4))
        IF(NPAR.GE.1) FLIPM=NINT(PARAM(1))
        IF(NPAR.GE.2) FLIPA=NINT(PARAM(2))
        PARAM(1)=FLIPM
        PARAM(2)=FLIPA
        S1='off '
        S2='off '
        if (FLIPM.GT.0) S1='on  '        
        if (FLIPA.GT.0) S2='on  '
        WRITE(SOUT,4) S1,S2        
      ENDIF

      IF(ICOM.EQ.5) THEN
5       FORMAT(' MAG  = ',2(3x,a4))
        IF(NPAR.GE.1) MON.MAG=PARAM(1)
        IF(NPAR.GE.2) ANA.MAG=PARAM(2)
        PARAM(1)=MON.MAG
        PARAM(2)=ANA.MAG
        S1='off '
        S2='off '
        if (MON.MAG.GT.0) S1='on  '        
        if (ANA.MAG.GT.0) S2='on  '
        WRITE(SOUT,5) S1,S2        
      ENDIF

      IF(ICOM.EQ.6) THEN
6       FORMAT(' SPIN = ',a4,' -> ',a4)
61      FORMAT(' SPIN =    all')
        IF(NINT(SPINT).LT.0) I1=-1
        IF(NINT(SPINT).GT.0) I1=1
        IF(NINT(SPINT).EQ.0) I1=0
        I2=NINT(SPINT)-2*I1
        IF(NPAR.GE.1) I1=NINT(PARAM(1))            
        IF(NPAR.GE.2) I2=NINT(PARAM(2)) 
        SPINT=2*I1+I2 
        IF(I1.EQ.0.OR.I2.EQ.0) SPINT=0
        IF(SPINT.NE.0) THEN
           IF (I1.EQ.1) S1='up'
           IF (I2.EQ.1) S2='up'
           IF (I1.EQ.-1) S1='down'
           IF (I2.EQ.-1) S2='down'
           WRITE(SOUT,6) S1,S2   
        ELSE   
           WRITE(SOUT,61)
        ENDIF   
      ENDIF
            
      IF(ICOM.EQ.8) THEN
8       FORMAT(' TAUF = ',G12.4,' [ns]')
81      FORMAT(' phi(i)=',G12.4,' [T*m]',/,' phi(f)=',G12.4,' [T*m]')
        IF(NPAR.GE.1) THEN
           STP.TAUF=PARAM(1)
           SOL2.BINT=STP.TAUF*HOVM**2*STP.KI**3/2.D0/gammaL*1.D7
           SOL3.BINT=STP.TAUF*HOVM**2*STP.KF**3/2.D0/gammaL*1.D7
           WRITE(SOUT,81) SOL2.BINT,SOL3.BINT      
        ENDIF   
        PARAM(1)=STP.TAUF
        WRITE(SOUT,8) STP.TAUF        
      ENDIF
            
            
      RETURN
      END


C---------------------------------------------------------------        
      LOGICAL*4 FUNCTION SPEC_GO(ICOM)
C     traces neutron trajectories from the sample to the source
C     (ICOM=1) or from the sample to the detector (ICOM=2)
C---------------------------------------------------------------
 
      IMPLICIT NONE     
      INCLUDE 'ness_common.inc'
      
      INTEGER*4 IERR,ICOM
      REAL*8 DKKI,DKKF     
      RECORD /NEUTRON/ NEUI,NEUF,NEUI1,NEUF1,NEU,NEU1 
      LOGICAL*4 BENDER_GO,SLIT_GO,CRYST_GO,LOG           
      COMMON /ERRORS/ IERR
      COMMON /NEUIF/ NEUI,NEUF,NEUI1,NEUF1,DKKI,DKKF
10    format('NEU: ',7(2x,E10.3))      	                 
      LOG=.TRUE.
      IF(ICOM.EQ.1) THEN
        IF(FLIPM.GT.0) NEUI.S=-NEUI.S 
c        IF(LOG) write(*,*) 'I1', NEUI.PHI
        IF(LOG) LOG=(LOG.AND.BENDER_GO(SOL2,NEUI,NEU))
c        IF(LOG) write(*,*) 'I2', NEU.PHI
        IF(LOG) LOG=(LOG.AND.CRYST_GO(MON,NEU,NEU1,DKKI))
c        IF(LOG) write(*,*) 'I3', NEU1.PHI
        IF(LOG) LOG=(LOG.AND.BENDER_GO(SOL1,NEU1,NEU))
c        IF(LOG) write(*,*) 'I4', NEU.PHI
        IF(LOG) LOG=(LOG.AND.BENDER_GO(GUIDE,NEU,NEU1))
c        IF(LOG) write(*,*) 'I5', NEU1.PHI
        IF(LOG) LOG=(LOG.AND.SLIT_GO(SOU,NEU1,NEUI1))
c        IF(LOG) write(*,*) 'I6', NEUI1.PHI
      ELSE IF(ICOM.EQ.2) THEN
        IF(FLIPA.GT.0) NEUF.S=-NEUF.S 
c        IF(LOG) write(*,*) 'F1', NEUF.PHI
        IF(LOG) LOG=(LOG.AND.BENDER_GO(SOL3,NEUF,NEU))        
c        IF(LOG) write(*,*) 'F2', NEU.PHI
        IF(LOG) LOG=(LOG.AND.CRYST_GO(ANA,NEU,NEU1,DKKF))
c        IF(LOG) write(*,*) 'F3', NEU1.PHI
        IF(LOG) LOG=(LOG.AND.BENDER_GO(SOL4,NEU1,NEU))
c        IF(LOG) write(*,*) 'F4', NEU.PHI
        IF(LOG) LOG=(LOG.AND.SLIT_GO(DET,NEU,NEUF1))      
c        IF(LOG) write(*,*) 'F5', NEUF1.PHI
      ENDIF
      SPEC_GO=LOG
100   CONTINUE      
      RETURN      
      END

C---------------------------------------------------------------------  
      SUBROUTINE SPEC_CLEAR
C---------------------------------------------------------------------  
      IMPLICIT NONE
      INCLUDE 'ness_common.inc'
      SOU.COUNT=0
      GUIDE.FRAME.COUNT=0
      SOL1.FRAME.COUNT=0
      MON.FRAME.COUNT=0
      SOL2.FRAME.COUNT=0
      SAM.COUNT=0
      SOL3.FRAME.COUNT=0
      ANA.FRAME.COUNT=0
      SOL4.FRAME.COUNT=0
      DET.COUNT=0             
      END

C---------------------------------------------------------------------  
      SUBROUTINE SPEC_INITALL
C---------------------------------------------------------------------  
      IMPLICIT NONE
      INCLUDE 'ness_common.inc'
      CALL SLIT_INIT(SOU)
      CALL BENDER_INIT(GUIDE)
      CALL BENDER_INIT(SOL1)
      CALL CRYST_INIT(MON)
      CALL BENDER_INIT(SOL2)
      CALL SLIT_INIT(SAM)
      CALL BENDER_INIT(SOL3)
      CALL CRYST_INIT(ANA)
      CALL BENDER_INIT(SOL4)
      CALL SLIT_INIT(DET)
      END

C---------------------------------------------------------------------      
      SUBROUTINE SPEC_SETUP
C//  SPEC_MODIFIED(LOG) Check if the configuration was changed       
C//  SPEC_UPDATE Update values in XDEV,XSET   
C//  SPEC_SET(DEV,SET) fill instrument parameters from DEV,SET arrays
C//  SPEC_GET(DEV,SET) get instrument parameters to DEV,SET arrays  
C//
C// FDEV/FSET is equivalent to the current instrument setting
C// XDEV/XSET stores the setting after ray-tracing 
C---------------------------------------------------------------------      
      IMPLICIT NONE
      INCLUDE 'ness_common.inc'
      
      BYTE FDEV(LDEV),FSET(LSET),XDEV(LDEV),XSET(LSET)
      BYTE DEV(LDEV),SET(LSET) 
      LOGICAL*4 LOG      
      INTEGER*4 I,ILAST,CHKSUM,XcheckSUM
      
      SAVE XDEV,XSET,XcheckSUM
      
      EQUIVALENCE (FDEV(1),FLIPM)
      EQUIVALENCE (FSET(1),SMOS)

C----------------------------------------------------------          
      ENTRY SPEC_UNCHANGED(LOG)
C compare XDEV/XSET fields with the stored ones (FDEV/FSET)
C return .TRUE. if they are identical      
C----------------------------------------------------------                         
      CALL SPEC_INITALL 
      LOG=.TRUE.   	      
      DO I=1,LDEV
         IF(LOG) THEN
            LOG=(LOG.AND.(XDEV(I).EQ.FDEV(I)))
         ELSE
            GOTO 101            
         ENDIF   
      END DO
101   ILAST=LDEV     
      DO I=1,LSET
         IF(LOG) THEN
            LOG=(LOG.AND.(XSET(I).EQ.FSET(I)))
         ELSE            
            GOTO 201
         ENDIF
      END DO
201   RETURN
      
C------------------------------------------------------------          
      ENTRY SPEC_COMPARE(DEV,SET,LOG)
C compare DEV/SET fields with the stored ones (FDEV/FSET)
C return .TRUE. if they are identical      
C------------------------------------------------------------                            
      CALL SPEC_INITALL 
      LOG=.TRUE.
      ILAST=0  	      
      DO I=1,LDEV
c        IF (DEV(I).NE.FDEV(I)) write(*,*) 'DEV ',I+ILAST
         IF(LOG) THEN
            LOG=(LOG.AND.(DEV(I).EQ.FDEV(I)))
         ELSE
!            GOTO 200
         ENDIF   
      END DO
      ILAST=LDEV     
      DO I=1,LSET
c        IF (SET(I).NE.FSET(I)) write(*,*) 'SET ',I
         IF(LOG) THEN
            LOG=(LOG.AND.(SET(I).EQ.FSET(I)))
         ELSE            
!            GOTO 200
         ENDIF
      END DO
!200   IF(.NOT.LOG) THEN
!      write(*,*) 'BYTE ',I+ILAST
!      ENDIF
      RETURN
               
C-----------------------------------------------------------------------------          
      ENTRY SPEC_UPDATE      
C ensure that the setup is considered as updated, i.e. MC is already done, etc.
C Set XDEV/XSET = FDEV/FSET
C-----------------------------------------------------------------------------          
      CALL SPEC_CLEAR                
      checkSUM=0         
      DO I=1,LDEV
         XDEV(I)=FDEV(I)
         checkSUM=checkSUM+FDEV(I)
      END DO
      DO I=1,LSET
         XSET(I)=FSET(I)
         checkSUM=checkSUM+FSET(I)
      END DO
      isCHANGED=.false.
      XcheckSUM=checkSUM
          
      RETURN


C-------------------------------------------------------------------          
      ENTRY SPEC_ERASE
C Cleares XDEV/XSET fields. Causes the setting to be always
C considered as MODIFIED => new ray-tracing is required
C-------------------------------------------------------------------          
               
      DO I=1,LDEV
         XDEV(I)=0.
      END DO
      DO I=1,LSET
         XSET(I)=0.
      END DO    
      isCHANGED=.true.
      checkSUM=0     
      RETURN

C-----------------------------------------------          
      ENTRY SPEC_GETCHK(CHKSUM)
C calculate check sum of the FDEV/FSET fields      
C-----------------------------------------------          
      CHKSUM=0         
      DO I=1,LDEV
         CHKSUM=CHKSUM+FDEV(I)
      END DO
      DO I=1,LSET
         CHKSUM=CHKSUM+FSET(I)
      END DO    
      RETURN
     
C--------------------------------------------          
      ENTRY SPEC_GET(DEV,SET)
C Read instrument setting into DEV/SET fields      
C--------------------------------------------          
               
      DO I=1,LDEV
         DEV(I)=FDEV(I)
      END DO
      DO I=1,LSET
         SET(I)=FSET(I)
      END DO    
      RETURN
      
C----------------------------------------------------          
      ENTRY SPEC_SET(DEV,SET)
C Set instrument setting according to DEV/SET fields      
C----------------------------------------------------          
      DO I=1,LDEV
         FDEV(I)=DEV(I)
      END DO
      DO I=1,LSET
         FSET(I)=SET(I)
      END DO    
      RETURN
       
      END


   
C--------------------------------------------------------      
      SUBROUTINE SPEC_INI(ICLR)
C     Clears all necessary variables and, if ICLR<>1, 
C     initializes limits of random variables
C--------------------------------------------------------
      implicit NONE
      
      INCLUDE 'const.inc'      
      INCLUDE 'inout.inc'
!      INCLUDE 'ness_common.inc'
      INCLUDE 'restrax.inc'
      
      REAL*8 WM,HM,WA,HA,SIM,COM,PSM
      REAL*8 Z,Z1,Z2,Z3,ZLD,ZLM,ZLS,ZLA,SIM1,SIA1,SIA,COA
      REAL*8 DKI1,DKI2,DKF1,DKF2,TANPSM,TANPSA
      INTEGER*4 ICLR,IERR,I 
      REAL*4 secnds
      
      RECORD /STATI/ COV_QE    
      COMMON /ERRORS/ IERR
      COMMON /RESULT/ COV_QE
      CALL STAT_CLR(4,COV_QE)
       
c      CALL RESNORM1(0)      
c      CALL RESNORM2(0)      
      CALL RESINT(0)
      IF (ICLR.EQ.1) THEN
        CALL SPEC_CLEAR          
        RETURN                    
      ENDIF
      
c      CALL SPEC_MODIFIED(LOGIN)  ! SPEC_CLEAR and SPEC_INITALL are called inside
c      IF(.NOT.LOGIN) THEN
c         RETURN
c      ENDIF 
      
c      write(*,*) 'SPEC_INI'       
      CALL MAXV_UPD(0)

      T0=(SOU.DIST+SOL1.FRAME.DIST+MON.FRAME.DIST+SOL2.FRAME.DIST)/
     1    HOVM/STP.KI
      T0=T0+(SOL3.FRAME.DIST+ANA.FRAME.DIST+SOL4.FRAME.DIST+DET.DIST)/
     2    HOVM/STP.KF  
     
C///  calculates size and orientation of the volumes <dKi>,<dKf>:
     
      SIM=MON.STMCH
      COM=MON.CTMCH
      ZLM=MON.FRAME.DIST+SOL2.FRAME.DIST
      WM=ABS(MON.FRAME.SIZE(1)*SIM)+ABS(MON.FRAME.SIZE(3)*COM)
      HM=ABS(MON.FRAME.SIZE(2))
      IF (ABS(SIM-MON.RH*ZLM).GT.0.0001*TAN(MON.THB)*SIM) THEN         
         IF(STP.SM.LT.0) THEN
            TANPSM=TAN(MON.THB)*SIM/(SIM-MON.RH*ZLM)
         ELSE
            TANPSM=-TAN(MON.THB)*SIM/(SIM-MON.RH*ZLM)
         ENDIF            
      ELSE
         TANPSM=10000.
      ENDIF
      PSM=ATAN(TANPSM)


C/// just a filter:
      IF (STP.SM.EQ.0) THEN
        Z=SOL1.FRAME.DIST+SOU.DIST+MON.FRAME.DIST+SOL2.FRAME.DIST
        DKI1=STP.KI*(SAM.SIZE(1)+SOU.SIZE(1))/Z
        DKI2=STP.KI*(SAM.SIZE(2)+SOU.SIZE(2))/Z        
      ELSE
      
C//// Z1,Z2,Z3 are maximum divergences allowed by the monochromator, 
C//// Soller collimator 2 and source (including focusing), respectively
      
      SIM1=SIN(MON.THB+MON.CHI)
      ZLS=SOL1.FRAME.DIST+SOU.DIST                 
      Z1=ABS(WM/ZLM) 
      IF ( SOL2.FRAME.SIZE(3).GT.0) THEN  
      Z2=ABS((SOL2.W2+SOL2.FRAME.SIZE(1))/SOL2.FRAME.SIZE(3)/SOL2.NLH)
     1 +SOL3.GHLU*MON.LAMBDA
      ELSE
       Z2=1.D+10
      ENDIF
      Z=ABS((SOL2.W2+SAM.SIZE(1))/(SOL2.FRAME.DIST+SOL2.FRAME.SIZE(3)))
      Z2=MIN(Z,Z2)
      IF(STP.SM.NE.0) THEN
        Z3=ABS(ZLM*SIM1+ZLS*SIM-2.*MON.RH*ZLM)
        IF(Z3.LT.1.D-10) Z3=1.D-10
        Z3=(SOU.SIZE(1)*SIM+SAM.SIZE(1)*(SIM1-2.*MON.RH)
     *      +4.*MON.DETA*ZLS)/Z3
      ELSE
         Z3=1.D+10
      ENDIF   
      DKI1=STP.KI*MIN(Z1,Z2,Z3)
      

      Z1=ABS(HM/ZLM)
      Z2=ABS((SOL2.H2+SAM.SIZE(2))/(SOL2.FRAME.DIST+SOL2.FRAME.SIZE(3)))
      Z3=ABS(ZLM+ZLS-2.*MON.RV*ZLM*ZLS*COS(MON.CHI)*SIN(MON.THB))
      IF(Z3.LT.1.D-10) Z3=1.D-10
      Z3=(SOU.SIZE(2)+SAM.SIZE(2)+4.*ZLS*MON.DETA*SIN(MON.THB))/Z3
      DKI2=STP.KI*MIN(Z1,Z2,Z3)      
      
      
      Z1=ABS(WM/ZLM) 
      IF (SOL2.FRAME.SIZE(3).GT.0) THEN          
      Z2=ABS((SOL2.W2+SOL2.FRAME.SIZE(1))/SOL2.FRAME.SIZE(3))
      ELSE
        Z2=1.D+10
      ENDIF
      DKI1=STP.KI*MIN(Z1,Z2)

      Z1=ABS(HM/ZLM)
      Z2=ABS((SOL2.H2+SAM.SIZE(2))/(SOL2.FRAME.DIST+SOL2.FRAME.SIZE(3)))
      DKI2=STP.KI*MIN(Z1,Z2)

      ENDIF


C/// analyzer is just a filter
      IF (STP.SA.EQ.0) THEN
        Z=SOL3.FRAME.DIST+DET.DIST+ANA.FRAME.DIST+SOL4.FRAME.DIST
        DKF1=STP.KF*(SAM.SIZE(1)+DET.SIZE(1))/Z
        DKF2=STP.KF*(SAM.SIZE(2)+DET.SIZE(2))/Z        
      ELSE
                  
C/// normal analyzer
      SIA=ANA.STMCH
      COA=ANA.CTMCH
      ZLA=ANA.FRAME.DIST+SOL3.FRAME.DIST
      WA=ABS(ANA.FRAME.SIZE(1)*SIA)+ABS(ANA.FRAME.SIZE(3)*COA)
      HA=ABS(ANA.FRAME.SIZE(2))
      IF (ABS(SIA-ANA.RH*ZLA).GT.0.0001*TAN(ANA.THB)*SIA) THEN         
         IF(STP.SA.GT.0) THEN
            TANPSA=TAN(ANA.THB)*SIA/(SIA-ANA.RH*ZLA)
         ELSE
            TANPSA=-TAN(ANA.THB)*SIA/(SIA-ANA.RH*ZLA)
         ENDIF            
      ELSE
         TANPSA=10000.
      ENDIF

C//// Z1,Z2,Z3 are maximum divergences allowed by the analyzer, Soller 
C//// collimator 3 and detector (including focusing), respectively      

C// normal analyzer mode
      IF(CFGMODE.NE.1) THEN

      SIA1=SIN(ANA.THB+ANA.CHI)
      ZLD=SOL4.FRAME.DIST+DET.DIST                 
      Z1=ABS(WA/ZLA) 
      if ( SOL3.FRAME.SIZE(3).GT.0) THEN         
      Z2=ABS((SOL3.W2+SOL3.FRAME.SIZE(1))/SOL3.FRAME.SIZE(3)/SOL3.NLH)
     1 +SOL3.GHLU*ANA.LAMBDA
      ELSE
        Z2=1.D+10
      ENDIF  
      Z=ABS((SOL3.W2+SAM.SIZE(1))/(SOL3.FRAME.DIST+SOL3.FRAME.SIZE(3)))
      Z2=MIN(Z,Z2)
      IF (STP.SA.NE.0) THEN
         Z3=ABS(ZLA*SIA1+ZLD*SIA-2.*ANA.RH*ZLA)
         IF(Z3.LT.1.D-10) Z3=1.D-10
         Z3=(DET.SIZE(1)*SIA+SAM.SIZE(1)*(SIA1-2.*ANA.RH)+
     *   4.*ANA.DETA*ZLD)/Z3  
      ELSE
         Z3=1.D+10
      ENDIF   
      DKF1=STP.KF*MIN(Z1,Z2,Z3)

      Z1=ABS(HA/ZLA)
      Z2=ABS((SOL3.H2+SAM.SIZE(2))/(SOL3.FRAME.DIST+SOL3.FRAME.SIZE(3)))
      Z3=ABS(ZLA+ZLD-2.*ANA.RV*ZLA*ZLD*COS(ANA.CHI)*SIN(ANA.THB))
      IF(Z3.LT.1.D-10) Z3=1.D-10
      Z3=(DET.SIZE(2)+SAM.SIZE(2)+4.*ZLD*ANA.DETA*SIN(ANA.THB))/Z3
      DKF2=STP.KF*MIN(Z1,Z2,Z3)


C//// Z1,Z2,Z3 are maximum divergences allowed by the analyzer, Soller 
C//// collimator 3 and detector (including focusing), respectively      

C// flat_cone mode
      ELSE

      SIA1=SIN(ANA.THB+ANA.CHI)
      ZLD=SOL4.FRAME.DIST+DET.DIST                 
      Z1=ABS(HA/ZLA) 
      if ( SOL3.FRAME.SIZE(3).GT.0) THEN         
      Z2=ABS((SOL3.W2+SOL3.FRAME.SIZE(1))/SOL3.FRAME.SIZE(3)/SOL3.NLH)
     1 +SOL3.GHLU*ANA.LAMBDA
      ELSE
        Z2=1.D+10
      ENDIF  
      Z=ABS((SOL3.W2+SAM.SIZE(1))/(SOL3.FRAME.DIST+SOL3.FRAME.SIZE(3)))
      Z2=MIN(Z,Z2)
      Z3=ABS(ZLA+ZLD-2.*ANA.RV*ZLA*ZLD*COS(ANA.CHI)*SIN(ANA.THB))
      IF(Z3.LT.1.D-10) Z3=1.D-10
      Z3=(DET.SIZE(2)+SAM.SIZE(1)+4.*ZLD*ANA.DETA*SIN(ANA.THB))/Z3
      
      DKF1=STP.KF*MIN(Z1,Z2,Z3)
      Z1=ABS(WA/ZLA)
      Z2=ABS((SOL3.H2+SAM.SIZE(2))/(SOL3.FRAME.DIST+SOL3.FRAME.SIZE(3)))
      IF (STP.SA.NE.0) THEN
         Z3=ABS(ZLA*SIA1+ZLD*SIA-2.*ANA.RH*ZLA)
         IF(Z3.LT.1.D-10) Z3=1.D-10
         Z3=(DET.SIZE(1)*SIA+SAM.SIZE(2)*(SIA1-2.*ANA.RH)+
     *   4.*ANA.DETA*ZLD)/Z3  
      ELSE
         Z3=1.D+10
      ENDIF   
      DKF2=STP.KF*MIN(Z1,Z2,Z3)
      
      ENDIF

      
      ENDIF
      
C///  record RNDLIST is filled:   **************************************
C///  ensure, that LIMITS>=0 !!!
      
      RNDLIST.DIM=9
      
      NSEED=-2*abs(int(10*secnds(0.0)))+1
C     NSEED=-1001001
      DO 30 I=1,RNDLIST.DIM
        RNDLIST.MEAN(I)=0.
        RNDLIST.POOL(I)=1.1
        RNDLIST.ACTIVE(I)=1
30    CONTINUE

      RNDLIST.LIMITS(1)=SAM.SIZE(1)
      RNDLIST.LIMITS(2)=SAM.SIZE(2)
      RNDLIST.LIMITS(3)=2*PI      
      
      RNDLIST.LIMITS(4)=DKI1*RNDLIST.POOL(4)
      RNDLIST.LIMITS(5)=DKI2*RNDLIST.POOL(5)

      RNDLIST.LIMITS(6)=DKF1*RNDLIST.POOL(6)
      RNDLIST.LIMITS(7)=DKF2*RNDLIST.POOL(7)
      
      RNDLIST.LIMITS(8)=1.
      RNDLIST.LIMITS(9)=1.

      RNDLIST.ACTIVE(1)=0
      RNDLIST.ACTIVE(2)=0
      RNDLIST.ACTIVE(3)=0  
      RNDLIST.ACTIVE(8)=0
      RNDLIST.ACTIVE(9)=0  

c      IF (STP.SM.EQ.0) RNDLIST.ACTIVE(8)=0  
c      IF (STP.SA.EQ.0) RNDLIST.ACTIVE(9)=0  
            
      
101   format('Monte-Carlo variables initialized for data set ',I3)
      IF (SILENT.LT.1) WRITE(SOUT,101) mf_cur            

      call WRITE_SETUP(20) 

      RETURN
999   IERR=2
2     format('Warning for ki,kf,Q: ',3(G12.5,1x))
      WRITE(SOUT,2) STP.KI,STP.KF,STP.Q
      RETURN
      END


C-----------------------------
      SUBROUTINE GETSTATE
C-----------------------------
      implicit none
      
      INCLUDE 'ness_common.inc'
      
      write(*,*) 'mon:',sam.count,sol2.frame.count,mon.frame.count,
     1  sol1.frame.count,sou.count
      write(*,*) 'ana:',sol3.frame.count,ana.frame.count,
     1  sol4.frame.count,det.count
      write(*,*)
      
      RETURN
      END



C---------------------------------------------------
	SUBROUTINE CRYST_WRITE(IU,OBJECT)
C     Writes parameters of OBJECT to unit U
C--------------------------------------------------
      IMPLICIT NONE
      
      INCLUDE 'const.inc'
      INCLUDE 'structures.inc'
      INTEGER*4 IU,I

      RECORD /CRYSTAL/ OBJECT
1     FORMAT(' nh,nv: ',2(2x,I3))
2     FORMAT(' G0 : ',3(2x,F8.3))
3     FORMAT(' dG : ',3(2x,E12.3))
4     FORMAT(' POS : ',3(2x,E12.3))
7     FORMAT(' dhkl, thb, chi: ',3(2x,F8.3))
8     FORMAT(' roh,rov: ',2(2x,F8.4))
9     FORMAT(' hmos,vmos,etamax: ',3(2x,F7.2))
10    FORMAT(' lam,Qhkl,ref: ',3(2x,E12.3))
11    FORMAT(' typ: normal')
12    FORMAT(' typ: simple')

      CALL SLIT_WRITE(OBJECT.FRAME,IU)
      WRITE(IU,4) (OBJECT.FRAME.POS(I),I=1,3)
      WRITE(IU,1) OBJECT.NH,OBJECT.NV
      WRITE(IU,7) OBJECT.DHKL,OBJECT.THB*180/PI,OBJECT.CHI*180/PI
      WRITE(IU,8) OBJECT.RH*1000,OBJECT.RV*1000
      WRITE(IU,9) OBJECT.HMOS*180*60/PI,OBJECT.VMOS*180*60/PI,
     1              OBJECT.DETA*180*60/PI
      WRITE(IU,10) OBJECT.LAMBDA,OBJECT.QHKL,OBJECT.REF
      IF (OBJECT.TYP.EQ.0) THEN 
        WRITE(IU,11)
      ELSE
        WRITE(IU,12)      
      ENDIF  
      WRITE(IU,*)
      WRITE(IU,2) (OBJECT.G(I),I=1,3)
      WRITE(IU,*)
      WRITE(IU,3) (OBJECT.DG_DR(1,I),I=1,3)
      WRITE(IU,3) (OBJECT.DG_DR(2,I),I=1,3)
      WRITE(IU,3) (OBJECT.DG_DR(3,I),I=1,3)

      RETURN
      END  



C---------------------------------------------------
      SUBROUTINE WRITE_SETUP(IC) 
C     Writes actual parameters of the setup
C---------------------------------------------------
      IMPLICIT NONE

      INCLUDE 'const.inc'      
      INCLUDE 'inout.inc'      
      INCLUDE 'ness_common.inc'      
      INCLUDE 'rescal.inc'      
      INTEGER*4 IC

c      DATA THZMEV/0.24181/

5     FORMAT(' w2,h2: ',2(2x,F7.1))
6     FORMAT(' nl: ',I4)
10    FORMAT(' a',I1,': ',F8.3)
11    FORMAT(' KI,KF,Q,E: ',4(2x,F8.3))
12    FORMAT(' TEMP: ',F8.3)

      IF(IC.NE.6) Open(Unit=ic,File='res_setup.txt',err=999,
     1            Status='Unknown')
    
      WRITE(IC,*) '*************************************************'
      CALL SLIT_WRITE(SOU,IC) 
      WRITE(IC,12) STEMP
      WRITE(IC,*) '*************************************************'     
      CALL BENDER_WRITE(IC,GUIDE) 
      WRITE(IC,*) '*************************************************'     
      CALL BENDER_WRITE(IC,SOL1) 
       WRITE(IC,*)'*************************************************' 
      CALL CRYST_WRITE(IC,MON) 
       WRITE(IC,*)'*************************************************' 
      CALL BENDER_WRITE(IC,SOL2) 
       WRITE(IC,*)'*************************************************' 
      CALL SLIT_WRITE(SAM,IC) 
       WRITE(IC,*)'*************************************************' 
      CALL BENDER_WRITE(IC,SOL3) 
       WRITE(IC,*)'*************************************************' 
      CALL CRYST_WRITE(IC,ANA) 
       WRITE(IC,*)'*************************************************' 
      CALL BENDER_WRITE(IC,SOL4) 
       WRITE(IC,*)'*************************************************' 
      CALL SLIT_WRITE(DET,IC) 
       WRITE(IC,*)'*************************************************' 
  
      WRITE(IC,*) 'AXES:'
      WRITE(IC,10) 1,MON.FRAME.GON(1)*180/PI
      IF (SOL1.FRAME.AXI.NE.0) THEN
         WRITE(IC,10) 2,SOL1.FRAME.AXI*180/PI
      ELSE      
         WRITE(IC,10) 2,SOL2.FRAME.AXI*180/PI
      ENDIF   
      WRITE(IC,10) 4,ATAN(SOMEGA/COMEGA)*180/PI
      WRITE(IC,10) 5,ANA.FRAME.GON(1)*180/PI
      WRITE(IC,10) 6,SOL4.FRAME.AXI*180/PI
      WRITE(IC,*)       
      WRITE(IC,11) STP.KI,STP.KF,STP.Q,STP.E
      
C      write(IC,*) SOU.SIMPLE
C      write(IC,*) SOL1.FRAME.SIMPLE
C      write(IC,*) MON.FRAME.SIMPLE
C      write(IC,*) SOL2.FRAME.SIMPLE
C      write(IC,*) SOL3.FRAME.SIMPLE
C      write(IC,*) ANA.FRAME.SIMPLE
C      write(IC,*) SOL4.FRAME.SIMPLE
C      write(IC,*) DET.SIMPLE
      
      
      IF(IC.NE.6) close(ic)  
C      WRITE(*,*) 'Setup written'    
      RETURN
999   write(*,*) 'Cannot open file for output!'
      return
      END      
   


      
      
      
