C//////////////////////////////////////////////////////////////////////
C////  $Id: ness_dev.f,v 1.5 2006/05/12 10:16:14 saroun Exp $
C////                                                              //// 
C////  NEutron Scattering Simulation - v.1.2, (c) J.Saroun, 1997   ////
C////                                                              //// 
C//////////////////////////////////////////////////////////////////////
C////
C/////  Subroutines for handling events & simple command interpreter
C////                      
C////  *   SUBROUTINE NESSEND
C////  *   SUBROUTINE NESS_LOOP
C////  *   SUBROUTINE READCOM(ICOMM,IOE)
C////  *   SUBROUTINE NESS(ITASK)
C////  *   LOGICAL*4 FUNCTION SAFETY_POOL()
C////  *   SUBROUTINE SWPOOL
C////  *   SUBROUTINE MAXV_UPD(ITASK)
C////  *   SUBROUTINE RANDFILL
C////  *   SUBROUTINE RESINT(ICOM,VAL,KI,R,KF)
C////  *   SUBROUTINE NESS_RUN(ICOM,NCNT,NEVENT)
C////  *   SUBROUTINE VALID(ICOM,NCNT)
C////  *   BLOCK DATA
C////  
C//////////////////////////////////////////////////////////////////////


C-------------------------------
      SUBROUTINE NESSEND
C     NESS destructor      
C-------------------------------
      INCLUDE 'const.inc'
      INCLUDE 'inout.inc'
      INCLUDE 'restrax.inc'
!      CALL KSTACK_DESTROY
      CALL KSTACK_FREERANGE(1,mf_max)
      RETURN
      END


C------------------------------------------------------------
      SUBROUTINE IFNESS(ICOM,NEV)
C All calls of Monte Caro should be made through this subroutine !!
C NEV - requested number of events (no check of validity !)
C Call Monte Carlo only if ICOM<>0 or configuration has changed
C ICOM=1 call MC anyway
C ICOM=0 call MC only if the configuration has been changed
C------------------------------------------------------------
      IMPLICIT NONE

      INCLUDE 'const.inc'
      INCLUDE 'inout.inc'
      INCLUDE 'restrax.inc'

      INCLUDE 'rescal.inc'
      
      INTEGER*4 ICOM,NEV
      REAL*8 QE(4),P
      INTEGER*4 I,J,NJ,GETIDENT

2     FORMAT('Events for dataset ',I2,' already calculated.')
3     FORMAT('Events copied from set ',I2, ' to ',I2)          
   
      LASTNEV=NEV
      IF(ICOM.EQ.0) THEN  
      
c      J=mf_cur
c      write(*,*) 'ID: ',J,' done: ',mf_done(J),' mod: ',mf_changed(J) 
        J=GETIDENT()   ! index to identical setup, if any, with 'MC done'
        IF(J.GT.0) THEN
           CALL KSTACK_N(NJ,J)  
           IF (NJ.EQ.NEV) THEN     ! number of events accumulated in J agrees with the required one 
             IF (J.EQ.mf_cur) THEN ! Current setup has already 'MC done'
               if (SILENT.LT.1) write(sout,2) mf_cur
               RETURN
             ELSE                                ! There is another setup with 'MC done' which can be used
               CALL KSTACK_ALLOCATE(NEV,mf_cur)
               DO I=1,NEV                        ! copy events from J to mf_cur
                 CALL GETQE(I,J,QE,P)
                 CALL SETQE(I,mf_cur,QE,P)
               ENDDO
               CALL SPEC_UPDATE         ! mark current setup as updated (i.e. MC has been done)
               I=mf_cur                 ! remember index of the current setup
               CALL mfit_set(J)         ! set J as the current setup
               mf_cur=I                 ! restore the index of current setup
               CALL mfit_get(mf_cur)    ! copy back to the mf_cur (in order to copy resolution matrices etc.) 
               mf_done(mf_cur)=.TRUE.   ! .. an all si done
               if (SILENT.LT.1) write(sout,3) J,mf_cur
c      write(*,*) 'ID: ',mf_cur,' done: ',mf_done(mf_cur),' mod: ',
c     * isCHANGED,mf_changed(mf_cur),mf_changed(J) 
               RETURN
             ENDIF
           ENDIF  
        ENDIF
      ENDIF    
      CALL SPEC_INI(0)
      CALL NESS(2,NEV)
      CALL SPEC_UPDATE        ! update records with TAS setup for future comparisons
      CALL mfit_get(mf_cur)   ! copy records with current TAS setup to mf_ fields
      mf_done(mf_cur)=.TRUE.  ! mark current setup as 'MC done' 
      END 
       
C------------------------------------------------------------
      SUBROUTINE NESS(ITASK,NPRESET)
C  ITASK=0 ... writes covariance and resolution matrices
C  ITASK=2 ... makes pre-defined cycle (see comments bellow)
C/// (J.S. 1997) takes preset number of events from NPRESET
C------------------------------------------------------------
      IMPLICIT NONE
      
      INCLUDE 'const.inc'      
      INCLUDE 'inout.inc'
      INCLUDE 'restrax.inc'   ! contains already ness_common.inc
            
      integer*4 NDCOM,NDPAR
      PARAMETER(NDCOM=16,NDPAR=16)

      CHARACTER*5 COMMANDS(NDCOM)
                 
      REAL*4   PARAM(NDPAR),SECNDS
      RECORD /STATI/ COV_QE       
      
      INTEGER*4 HIT(CRND),NEVENT,NTOT,NOUT,NCNT,DOTCNT
      INTEGER*4 ITASK,NPRESET,NCOM,NPAR,ICOM,I,NEV,MESS
      REAL*8 t1,t2,t3,z
           
      COMMON /RESULT/ COV_QE
      COMMON /COMMANDS/ NCOM,COMMANDS,NPAR,PARAM
      COMMON /POOL/ HIT
       
      
      REAL*8 E4(4),E16(CRND)

      EQUIVALENCE(E16,E4)
      SAVE NCNT

1     FORMAT('.',$)            
3     FORMAT(' Wait please ',$)            
4     FORMAT(' Time to wait [s]: ',G8.3)           
5     FORMAT(' Timeout reached at ',F8.2,' s')      
7     FORMAT(4X,5(2X,E12.5)) 
8     FORMAT(' Time spent:  ',F8.2,' s ',I8,' events, ',I8,' counts')    
12    Format(' Safety pool hits: ',16(1X,I3))
 
      ICOM=0
      

C/////////////  command = ACCU  ////////////////////       
      
      IF(ITASK.EQ.2) THEN
      
      do 200 i=1,rndlist.dim
200       hit(i)=0
                    
      
      NEV=NPRESET
      NEVENT=0
      NCNT=0
      NTOT=0 
      DOTCNT=0 
      NOUT=NEV*10000
      DBG_TIME=0
            
      CALL KSTACK_ALLOCATE(NEV,mf_cur)   
            
      T1=SECNDS(0.0)

      IF(NEV.GE.2000) THEN
        MESS=0
      ELSE
        MESS=1
      ENDIF
C------------------   Main Cycle    -----------------------
      WRITE(SMES,3) 
      DO WHILE ((NCNT.LT.NEV).AND.(NTOT.LT.NOUT))
         CALL NESS_RUN(ICOM,NCNT,NEVENT)
         
         IF(NCNT.EQ.0) DOTCNT=0
         
         IF(NCNT.EQ.500) T2=SECNDS(0.0)

C/// When 1000 events were accumulated, total time is estimated:

         IF((MESS.EQ.0).AND.(NCNT.GE.1000)) THEN
            MESS=1
            T3=SECNDS(0.0)
            Z=(T2-T1)+(T3-T2)*(NEV-1000.)/500.
            IF (SILENT.LT.1) WRITE(SMES,4) Z
         ENDIF

C/// When 2000 events were accumulated, actual limits of random 
C/// variables are estimated.
         
         IF((NCNT.EQ.2000).and.(MESS.LT.2)) THEN
              CALL MAXV_UPD(2)
              MESS=2
         ENDIF

C/// When 5000 events were accumulated, safety pool is switched-off.
        
         IF((NCNT.EQ.5000).and.(MESS.LT.3)) THEN
              CALL SWPOOL
              MESS=3
         ENDIF         
         
C/// Write a dot for each 500 successful events
         I=(NCNT+1)/500
         IF(MOD(NCNT+1,500).EQ.0.AND.I.GT.DOTCNT) THEN
              DOTCNT=(NCNT+1)/500
              WRITE(SOUT,1)
         ENDIF         
            
         NTOT=NTOT+1 
         IF ((NEVENT.GT.10000000).AND.(NCNT.EQ.0)) NTOT=NOUT        
      END DO
      IF(NCNT.GE.5000) CALL SWPOOL
         
      WRITE(SOUT,*) 
      
C----------------------- End ------------------------------      
      
      T3=SECNDS(0.0)
      IF (SILENT.LT.1) CALL GETSTATE      
      IF (NTOT.GE.NOUT) THEN
         WRITE(SMES,5) T3-T1
         NCNT=0
      ELSE
         IF (SILENT.LT.1) WRITE(SMES,8) T3-T1,NEVENT,NCNT
      ENDIF
C      WRITE(SMES,12) (HIT(I),I=1,RNDLIST.DIM)
C      WRITE(SMES,*) 'DBG_TIME: ',DBG_TIME 

      CALL GETCOV_QE(NCNT)   ! resolution matrix
c      write(*,*) 'GETCOV_QE finished'
      CALL RESINT(2) ! get norm factors 
c      write(*,*) 'RESINT(2) finished'

c      write(*,*) 'NESS finished'

      ENDIF

      END 

C-------------------------------------------------------------------
      SUBROUTINE GETCOV_QE(NCNT)
      implicit none
      INCLUDE 'const.inc'      
      INCLUDE 'inout.inc'
      INCLUDE 'restrax.inc'   ! contains already ness_common.inc

      INTEGER*4 I,J,NCNT      
      RECORD /STATI/ COV_QE                  
      COMMON /RESULT/ COV_QE
      REAL*8 E4(4),E16(CRND),P
      EQUIVALENCE(E16,E4)


C/// calculates the covariance matrix and resolution matrix from
C/// the accumulated events:
c      write(*,*) 'GETCOV_QE'
      CALL STAT_CLR(4,COV_QE)
      
c      write(*,*) 'STAT_CLR'
      
      DO  I=1,NCNT
         CALL GETQE(I,mf_cur,E4,P) 
         CALL STAT_INP(4,COV_QE,E16,P)
      ENDDO

      IF(COV_QE.NC.GT.0) THEN
         CALL STAT_GET(4,COV_QE)
	 
         IF(COV_QE.C(4,4).LE.1.E-10) COV_QE.C(4,4)=1.
         CALL INVERT(4,COV_QE.C,CRND,ANESS,4)
                
         DO I=1,4
               AMEAN(I)=COV_QE.M(I) 
         ENDDO

      ELSE
         DO I=1,4
             DO J=1,4
                ANESS(I,J)=0.
             END DO
             AMEAN(I)=0.            
         ENDDO
         WRITE(SMES,*) 'No events accumulated !'              
c    CALL KSTACK_FREE(mf_cur)
      ENDIF         

      END
         
C-------------------------------------------------------------------
      LOGICAL*4 FUNCTION SAFETY_POOL()
C     Checks, if the value of any random variable X(I) is found
C     in the safety pool. If yes, corresponding limits are relaxed.
C-------------------------------------------------------------------
      
      INCLUDE 'ness_common.inc'
      
      REAL*8 Z
      INTEGER*4 HIT(CRND)    
      COMMON /POOL/ HIT
      LOGICAL*4 LOG1

5     format(A20,1x,I2,3(2x,F12.5))

      LOG1=.FALSE.
      DO 10 I=1,RNDLIST.DIM
      
      IF (RNDLIST.ACTIVE(I).GT.0) THEN
        Z=ABS(2*RNDLIST.POOL(I)*RNDX(I))-RNDLIST.LIMITS(I)   
        IF (Z.GT.0) THEN        
           RNDLIST.LIMITS(I)=RNDLIST.LIMITS(I)*RNDLIST.POOL(I)
           HIT(I)=HIT(I)+1
           LOG1=.TRUE.
        ENDIF
      ENDIF      
10    CONTINUE
      SAFETY_POOL=LOG1
      RETURN
      END        


C     --------------------------------------------------
      SUBROUTINE SWPOOL
C     switch safety pool off/on
C     --------------------------------------------------
     
      INCLUDE 'const.inc'
      INCLUDE 'inout.inc'
      INCLUDE 'ness_common.inc'

      BYTE MYPOOL(CRND)
      INTEGER*4 IPOOL_OFF      
      REAL*8 MYLIM(CRND)      
      SAVE IPOOL_OFF
      DATA IPOOL_OFF/0/
      
      
      IF(IPOOL_OFF.EQ.0) THEN
C         WRITE(SMES,*) 'Safety pool OFF'
         DO 10 I=1,RNDLIST.DIM
           MYLIM(I)=RNDLIST.LIMITS(I)
           MYPOOL(I)=RNDLIST.ACTIVE(I)
           RNDLIST.LIMITS(I)=RNDLIST.LIMITS(I)/RNDLIST.POOL(I)
           RNDLIST.ACTIVE(I)=0
10       CONTINUE
         IPOOL_OFF=1
      ELSE
C         WRITE(SMES,*) 'Safety pool ON'
         DO 20 I=1,RNDLIST.DIM
           RNDLIST.LIMITS(I)=MYLIM(I)
           RNDLIST.ACTIVE(I)=MYPOOL(I)           
20       CONTINUE
         IPOOL_OFF=0
      ENDIF
      
      RETURN
      END      
                               	                 
C-----------------------------------------------------------------------
      SUBROUTINE MAXV_UPD(ITASK)
C     ITASK=0 ... clears MAXV(I) array
C     ITASK=1 ... MAXV(I) is compared with X(I) and changed if necessary
C     ITASK=2 ... limits are changed according to MAXV(I)        
C-----------------------------------------------------------------------
      implicit REAL*8 (a-h,o-z)
      
      INCLUDE 'ness_common.inc'
      
      REAL*8 MAXV(CRND)
      
      SAVE MAXV
      
      IF(ITASK.EQ.0) THEN
      DO  5 I=1,RNDLIST.DIM                 
         MAXV(I)=0.
5     CONTINUE       
      
      ELSE IF(ITASK.EQ.1) THEN
      
      DO  10 I=1,RNDLIST.DIM
        IF (RNDLIST.ACTIVE(I).gt.0) THEN              
          IF(ABS(RNDX(I)).GT.MAXV(I)) MAXV(I)=ABS(RNDX(I))
        ENDIF  
10    CONTINUE        
      
      ELSE IF(ITASK.EQ.2) THEN
      
      DO  20 I=1,RNDLIST.DIM
        IF (RNDLIST.ACTIVE(I).gt.0) THEN
           RNDLIST.LIMITS(I) = 2.*MAXV(I)*RNDLIST.POOL(I)*1.001
        ENDIF              
20    CONTINUE

      ENDIF
      RETURN
      END          
          
      
C----------------------------------------------------------
      SUBROUTINE RANDFILL
C     filles X(I) by random numbers within specified limits	
C----------------------------------------------------------
      implicit none
      
      INCLUDE 'ness_common.inc'
      INTEGER*4 I
      REAL*4 RAN1
        
      DO  I=1,RNDLIST.DIM
         RNDX(I)=RNDLIST.LIMITS(I)*(RAN1()-0.5)
      END DO

      RETURN
      END


C------------------------------------------------------------
      SUBROUTINE NESS_RUN(ICOM,NCNT,NEVENT)
C     makes one event
C------------------------------------------------------------
      implicit none

      INCLUDE 'const.inc'
      INCLUDE 'inout.inc'
      INCLUDE 'rescal.inc'
      INCLUDE 'ness_common.inc'
      
      RECORD /NEUTRON/ NEUI,NEUF,NEUI1,NEUF1
      REAL*8 KFF,KI,KF,DKKI,DKKF,SI,CO,PP
      INTEGER*4 NEVENT,ICOM,NCNT,ierr,i
      LOGICAL*4 SPEC_GO,SAFETY_POOL,EMOD   
      COMMON /ERRORS/ IERR 
      COMMON /NEUIF/ NEUI,NEUF,NEUI1,NEUF1,DKKI,DKKF
      COMMON /MODE/ EMOD
      REAL*4 RAN1
      REAL*8 DFLUX,v3xv3
  
  
1     format(a20,4(2x,F12.5))
      
      
      NEVENT=NEVENT+1
      CALL RANDFILL

      SI=SIN(RNDX(3))
      CO=SQRT(1-SI**2) 
      NEUI.R(2)=RNDX(2)+SAM.STA(2)
      NEUI.R(1)=RNDX(1)*CO+SAM.STA(1)
      NEUI.R(3)=RNDX(1)*SI+SAM.STA(3)
     
      NEUI.P=1
      NEUI.T=0
      NEUI.PHI=0
      NEUI.S=2*NINT(RAN1())-1
      NEUF=NEUI
      NEUF.S=2*NINT(RAN1())-1               
      DO 20 I=1,2
         NEUI.K(I)=RNDX(I+3)
         NEUF.K(I)=RNDX(I+5)
20    CONTINUE

      NEUI.K(3)=STP.KI
      NEUF.K(3)=STP.KF
      

      NEUI.K(2)=-NEUI.K(2)
      SAM.COUNT=SAM.COUNT+1 
      IF(SPEC_GO(1)) THEN  
           IF(EMOD) THEN
              KI=SQRT(v3xv3(NEUI1.K,NEUI1.K))
              KF=SQRT(v3xv3(NEUF.K,NEUF.K))
              KFF=SQRT(KI**2-STP.E/HSQOV2M)
              DO i=1,3
                 NEUF.K(I)=NEUF.K(I)*KFF/KF
              END DO
           ENDIF 
	   IF (STP.SM.EQ.0) THEN
             KI=SQRT(v3xv3(NEUI1.K,NEUI1.K))
	     PP=DFLUX(1.D0,KI)*KI**2
	     NEUI1.P=NEUI1.P*PP
	     NEUI.P=NEUI.P*PP
	   ENDIF
		                            
           IF(SPEC_GO(2)) THEN
	       IF (STP.SA.EQ.0) THEN
	         NEUF1.P=NEUF1.P*(1.+DKKF)**2
		 NEUF.P=NEUF.P*(1.+DKKF)**2
	       ENDIF
               CALL MAXV_UPD(1)               
               IF (SAFETY_POOL()) THEN                   
                   CALL SPEC_INI(1)
                   NEVENT=0
                   NCNT=0
                   RETURN
               ENDIF
               NCNT=NCNT+1
               CALL VALID(ICOM,NCNT)               
           ENDIF
      ENDIF
       
      RETURN
      END         

C---------------------------------------------------------------
      SUBROUTINE VALID(ICOM,NCNT)
C     Makes all operations with a succesfull event      
C---------------------------------------------------------------
      implicit none     

      INCLUDE 'const.inc'      
      INCLUDE 'inout.inc'
      INCLUDE 'rescal.inc'
      INCLUDE 'restrax.inc'
      
      INTEGER*4 ICOM,NCNT,I
      REAL*8 PHI0,KI(3),KF(3),KKI,KKF  
      REAL*8 DKKI,DKKF
      RECORD /NEUTRON/ NEUI,NEUF,NEUI1,NEUF1
      COMMON /NEUIF/ NEUI,NEUF,NEUI1,NEUF1,DKKI,DKKF       

C/// correction on abs(ki,kf)                   
      KKI=0.D0
      KKF=0.D0
      NEUI.K(2)=-NEUI.K(2)
      DO I=1,3
         NEUI.K(I)=NEUI.K(I)*(1+DKKI)
         NEUF.K(I)=NEUF.K(I)*(1+DKKF)
         KI(I)=NEUI.K(I)
         KKI=KKI+NEUI.K(I)**2
         KKF=KKF+NEUF.K(I)**2
      END DO
      NEUI.PHI=NEUI1.PHI
      NEUF.PHI=NEUF1.PHI
1     format(6(G16.9,1x)) 
              
      PHI0=STP.TAUF/HBAR*HSQOV2M*(KKI-KKF)
 
c      write(*,*) 'VALID ', NCNT,mf_cur,MLC(1,1)
c      pause
     
      
      CALL KSTACK_WRITE(NCNT,mf_cur,NEUI.K,NEUF.K,NEUI.P,NEUF.P,
     *             NEUI.S,NEUF.S,NEUI.PHI-NEUF.PHI-PHI0)       
     

C// mean values are subtracted from NEUI.K and NEUF.K:      
      KI(3)=KI(3)-STP.KI 

C///  transform dKF to lab. coord.
      KF(3)=-NEUF.K(1)*SOMEGA+(NEUF.K(3)-STP.KF)*COMEGA
      KF(2)=NEUF.K(2)	
      KF(1)=+NEUF.K(1)*COMEGA+(NEUF.K(3)-STP.KF)*SOMEGA

C// covariance matrices of the (ki,r,kf) vector are accumulated:      
      CALL RESINT(1,NEUI1.P*NEUF1.P,KI,NEUI.R,KF)
     
      RETURN
      END          

C-------------------------------------------------------------------        
      SUBROUTINE RESINT(ICOM,VAL,KI,R,KF)
C     ICOM=0  clear data
c     ICOM=1  accumulates covariance matrices
C     ICOM=2  evaluates corresponding normalization factors
C  Vol(ki), Vol(kf), Vol(ki,r,kf)/Vol(ki)
C-------------------------------------------------------------------        
      implicit none 
      
      INCLUDE 'const.inc'
      INCLUDE 'inout.inc'
      INCLUDE 'restrax.inc'

      REAL*8 KI(3),R(3),KF(3),VAL,MEAN(9),RM(9),SC,D1,D2,D3
      REAL*8 COV(9,9),RC(9,9),V(9),AUX(9,9),R3(3,3),R3F(3,3),AUX3(3,3)
      REAL*8 R2F(2,2),AUX2(2,2),RC8(8,8),AUX8(8,8)
      INTEGER*4 ICOM,i,j
      REAL*8 DETERM
      LOGICAL*4 EMOD
      COMMON /MODE/ EMOD
      SAVE SC,COV,MEAN
      
      	
      IF(ICOM.EQ.1) THEN           !  add event
        DO 15 I=1,3
           V(I)=KI(I)
           V(I+3)=R(I)
           V(I+6)=KF(I)
15      CONTINUE
        SC=SC+VAL
        DO 20 I=1,9        
          MEAN(I)=MEAN(I)+VAL*V(I)
          DO 20 J=1,9
            COV(I,J)=COV(I,J)+VAL*V(I)*V(J)
20      CONTINUE      
      ENDIF          
      
      IF(ICOM.EQ.2) THEN          ! evaluate norm. factor
        IF(SC.LE.0.) GOTO 999     
C/ exclude KF(3) for elastic mode
        IF(EMOD) THEN
	  DO 31 I=1,8        
            RM(I)=MEAN(I)/SC
            DO 31 J=1,8	    
              RC8(I,J)=COV(I,J)/SC
              IF((I.LE.3).AND.(J.LE.3)) R3(I,J)=COV(I,J)/SC
              IF((I.GE.7).AND.(J.GE.7)) R2F(I-6,J-6)=COV(I,J)/SC
31          CONTINUE     
          DO 41 I=1,8        
            DO 41 J=1,8
              RC8(I,J)=RC8(I,J)-RM(I)*RM(J)
              IF((I.LE.3).AND.(J.LE.3)) R3(I,J)=R3(I,J)-RM(I)*RM(J)        
              IF((I.GE.7).AND.(J.GE.7)) R2F(I-6,J-6)=
     *                R2F(I-6,J-6)-RM(I)*RM(J)
41        CONTINUE 
          D1=DETERM(RC8,8,AUX8)
          D2=DETERM(R3,3,AUX3)        
          D3=DETERM(R2F,2,AUX2)        
          RELNESS=(2*PI)**3*SQRT(D1/D2)
          VKINESS=(2*PI)*SQRT(2*PI*D2)
          VKFNESS=(2*PI)*SQRT(D3)
	ELSE
C/ otherwise take full phase space	
	  DO 30 I=1,9        
            RM(I)=MEAN(I)/SC
            DO 30 J=1,9
              RC(I,J)=COV(I,J)/SC
              IF((I.LE.3).AND.(J.LE.3)) R3(I,J)=COV(I,J)/SC
              IF((I.GE.7).AND.(J.GE.7)) R3F(I-6,J-6)=COV(I,J)/SC
30        CONTINUE     
          DO 40 I=1,9        
            DO 40 J=1,9
              RC(I,J)=RC(I,J)-RM(I)*RM(J)
              IF((I.LE.3).AND.(J.LE.3)) R3(I,J)=R3(I,J)-RM(I)*RM(J)        
              IF((I.GE.7).AND.(J.GE.7)) R3F(I-6,J-6)=
     *                R3F(I-6,J-6)-RM(I)*RM(J)
40        CONTINUE 
          D1=DETERM(RC,9,AUX)
          D2=DETERM(R3,3,AUX3)        
          D3=DETERM(R3F,3,AUX3)        
          RELNESS=(2*PI)**3*SQRT(D1/D2)
          VKINESS=(2*PI)*SQRT(2*PI*D2)
          VKFNESS=(2*PI)*SQRT(2*PI*D3)
        ENDIF
                                        
      ELSE IF(ICOM.EQ.0) THEN     ! clear array
         SC=0.
         DO 10 I=1,9
           MEAN(I)=0.
           DO 10 J=1,9
             COV(I,J)=0
10       CONTINUE
      ENDIF
      
      RETURN
      
999   write(SMES,*) 'No events accumulated'
      VAL=0.
      RETURN      
      
      END          
           


C--------------------------------------------
      REAL*8 FUNCTION DFLUX(F0,K)
C--------------------------------------------
      IMPLICIT NONE
      INCLUDE 'const.inc'
      INCLUDE 'ness_common.inc'
      REAL*8 K,VKT2,F0,C0
      DATA STEMP /300/
      
      C0=0.5/PI/VKT2**2
      VKT2=12.187081*STEMP/293. 
      DFLUX=F0*C0*K*EXP(-K*K/VKT2)

      END
      



         

