C//////////////////////////////////////////////////////////////////////
C////                                                              //// 
C////  NEutron Scattering Simulation - v.1.2, (c) J.Saroun, 1997   ////
C////  update October 1998                                         //// 
C//////////////////////////////////////////////////////////////////////
C////
C////  Subroutines describing objects - SLIT, SOLLER,CRYSTAL
C////  
C////  * LOGICAL*4 FUNCTION INSIDE(SLIT,R)
C////  * LOGICAL*4 FUNCTION CR_INSIDE(CRYST,R)
C////  * SUBROUTINE SLIT_INIT(SLIT)
C////  * LOGICAL*4 FUNCTION SLIT_GO(SLIT,NEUI,NEUF)
C////  * LOGICAL*4 FUNCTION SOLLER_GO(SOLLER,NEUI,NEUF)
C////  * LOGICAL*4 FUNCTION BENDER_GO(BENDER,NEUI,NEUF) 
C////  * SUBROUTINE CRYST_INIT(OBJECT)
C////  * LOGICAL*4 FUNCTION CRYST_GO(CRYST,NEUI,NEUF,DKK)
C////  * SUBROUTINE SLIT_PRE(SLIT,R0,K0,R,K)
C////  * SUBROUTINE SLIT_POST(SLIT,R0,K0,R,K)
C////  * SUBROUTINE SLIT_PRE1(SLIT,R0,K0,R,K)
C////  * SUBROUTINE SLIT_POST1(SLIT,R0,K0,R,K)
C////  
C////                          
C//////////////////////////////////////////////////////////////////////



C	--------------------------------------------------
	LOGICAL*4 FUNCTION CR_INSIDE(CRYST,R)
C       INSIDE function for CRSYTAL object ... takes into
C       account curved surface of a bent crystal plate.	
C	--------------------------------------------------	
	implicit none

        INCLUDE 'structures.inc'
      
        RECORD /CRYSTAL/ CRYST
	REAL*8 R(3)
	LOGICAL*4 INSIDE
C	R0(3)=R(3)-R(1)*CRYST.RH-R(2)*CRYST.RV
C	R0(1)=R(1)
C	R0(2)=R(2)
	CR_INSIDE=INSIDE(CRYST.FRAME,R)
	
	RETURN
	END


C //////////////////  End of definition - SOLLER  ///////////////////

	
C---------------------------------------
      SUBROUTINE CRYST_INIT(CR)
C---------------------------------------
      implicit none

      INCLUDE 'const.inc'
      INCLUDE 'structures.inc'
      
      INTEGER*4 I,J
      RECORD /CRYSTAL/ CR

C///  THB and LAMBDA must be specified before !

      CALL SLIT_INIT(CR.FRAME)
        
      CR.GTOT=2*PI/ABS(CR.DHKL)
      CR.G(1)=CR.GTOT*SIN(CR.CHI)
      CR.G(2)=0
      CR.G(3)=CR.GTOT*COS(CR.CHI)
      CR.STMCH=SIN(CR.THB-CR.CHI)
      CR.CTMCH=COS(CR.THB-CR.CHI)
c G-gradient for elastically bent crystal      
      DO I=1,3
        CR.MAPG(I)=.TRUE.
        DO  J=1,3 
           CR.DG_DR(I,J)=0
        ENDDO   
      ENDDO
      IF(CR.HMOS.LT.sec.OR.CR.NH.EQ.1) THEN 
          CR.DG_DR(1,1)=-COS(CR.CHI)*CR.GTOT*CR.RH
          CR.DG_DR(1,3)=SIN(CR.CHI)*CR.GTOT*CR.RH
          CR.DG_DR(3,1)=SIN(CR.CHI)*CR.GTOT*CR.RH
          CR.DG_DR(2,2)=0    ! no vertical bending
          CR.DG_DR(3,3)=-CR.POI*COS(CR.CHI)*CR.GTOT*CR.RH
	  CR.MAPG(1)=.TRUE.        
	  CR.MAPG(3)=.TRUE.        
      ENDIF
C*  vertical bending considered only in the case of single segment
C*  and zero mosaicity
      IF(CR.HMOS.LE.SEC.AND.CR.NV.EQ.1) THEN 
        CR.DG_DR(2,2)=-COS(CR.CHI)*CR.GTOT*CR.RV
        CR.MAPG(2)=.TRUE.
      ENDIF  
      CR.QHKL=(CR.FHKL/CR.VOL*CR.LAMBDA)**2*
     1  ABS(CR.DHKL)*1E-5
      CR.DEXT=CR.VOL*COS(PI/2-CR.THB-CR.CHI)/
     1  CR.LAMBDA/CR.FHKL*0.1
      CR.REF=1              ! CRYST_REF(CR)
      CR.DETA=3.*CR.HMOS
      CR.gama(1)=COS(CR.CHI)
      CR.gama(3)=-SIN(CR.CHI)
      CR.gama(2)=0 
      CR.NB=1
      CR.RB=0.D0
      RETURN        
      END
        

C	--------------------------------------------------
	LOGICAL*4 FUNCTION CRYST_GO(CRYST,NEUI,NEUF,DKK)
C	--------------------------------------------------
        implicit none

        INCLUDE 'const.inc'
        INCLUDE 'ness_common.inc'
                     
        RECORD /CRYSTAL/ CRYST
	RECORD /NEUTRON/ NEUI,NEUF
	LOGICAL*4 INSIDE,EMOD,CRYST_SIMPLE
	REAL*8 V(3),K(3),R(3),V1(3)
	REAL*8 G0(3),G(3),DGR(3),TNORM
	REAL*8 DKK,C,ETA1,ETA2,DT,GG,alfv,alfh,dah,dav,KK,TIN,TOUT
	INTEGER*4 I,IH,IV
	REAL*4 GASDEV1,RN,RAN1,Z,Z1
	REAL*8 v3xv3
        COMMON /MODE/ EMOD

5       format(a10,5(G12.5))

C/// CRYST.DNRND must be specified elsewhere. X(..) is a random number  
C/// in the interval (-0.5,0.5)
        
        RN=RNDX(CRYST.DNRND+1)

C/// if thb=0 => special device:
   
        NEUF=NEUI			
        if (CRYST.THB.EQ.0) then
        
          CALL SLIT_PRE(CRYST.FRAME,NEUI.R,NEUI.K,V,K)
	  NEUF.T=NEUI.T-V(3)/HOVM/K(3)
	  DO  I=1,2
	      R(I)=V(I)-V(3)/K(3)*K(I)
          END DO
          R(3)=0.
          CALL SLIT_POST(CRYST.FRAME,R,K,NEUF.R,NEUF.K)          				     
	  CRYST.FRAME.COUNT=CRYST.FRAME.COUNT+1
          CRYST_GO=.TRUE.

C// primitive velocity selector (triangular distr.)        
	  if (CRYST.NV.EQ.0) then 
	    Z1=RAN1()-0.5
	    Z=(Z1+RN)*CRYST.POI ! triangular distribution, fwhm=CR.POI
	    KK=SQRT(v3xv3(NEUI.K,NEUI.K))
	    DKK=-1.+2*PI/CRYST.LAMBDA/KK*(1+Z)
            DO  I=1,3
              NEUF.K(I)=NEUF.K(I)*(1.+DKK)
            END DO
c            NEUF.P=NEUF.P*(1.+DKK)**2
            NEUF.T=NEUF.T/(1.+DKK)  
	    RETURN
C// just go through
          ELSE IF(EMOD) THEN
             DKK=0.
             RETURN
          ELSE  
C// crystalline filter                 
	    C=2*PI/SQRT(v3xv3(NEUI.K,NEUI.K))
            DKK=-1.+(RN+0.501)*C/CRYST.DHKL 	! -.5<RN<.5
            DO  I=1,3
              NEUF.K(I)=NEUF.K(I)*(1.+DKK)
            END DO
c          NEUF.P=NEUF.P*(1.+DKK)**2
            NEUF.T=NEUF.T/(1.+DKK)  
            RETURN
          ENDIF  
        ENDIF
		  
C/// no reflection if spin does not match magnetization 
        if (CRYST.MAG*NEUI.S.LT.0) GOTO 30       

C* for analyzer in elastic mode, use another version
        IF (CRYST.TYP.EQ.1) THEN
           CRYST_GO=CRYST_SIMPLE(CRYST,NEUI,NEUF)
           DKK=0.D0
           RETURN
        ENDIF

C*  V&H  mosaic block deviation is taken in random
C*  gaussian distribution of mosaic blocs is limitted to +-3*sigma        
        
        ETA1=CRYST.HMOS*GASDEV1(0.,3.)
        ETA2=CRYST.VMOS*GASDEV1(0.,3.)


C*  G vector is corrected for the mosaic block orientation
        G0(1)=CRYST.G(1)+CRYST.G(3)*ETA1
        G0(3)=CRYST.G(3)-CRYST.G(1)*ETA1
        G0(2)=CRYST.G(2)+CRYST.GTOT*ETA2            
        
        
C*  get nominal flight length through the crystal
        DO I=1,3
          K(I)=0.
          R(I)=0.
        ENDDO  
        K(3)=1.
        CALL SLIT_PRE(CRYST.FRAME,R,K,V,V1)
        CALL CR_BORDER(CRYST,V,V1,TIN,TOUT)
        TNORM=(TOUT-TIN)
        
        
C*  transform neutron coordinates to the local system
        CALL SLIT_PRE(CRYST.FRAME,NEUI.R,NEUI.K,V,K)              

C*  The depth in the crystal when the reflection takes place is chosen in random
        CALL CR_BORDER(CRYST,V,K,TIN,TOUT)
        IF(TIN.GE.TOUT) GOTO 30 ! no intersection with the crystal
        DT=TIN+(RN+5.E-1)*(TOUT-TIN)

C*  move neutron to the point of reflection
        NEUF.T=NEUI.T+DT/HOVM 
        DO I=1,3 
           R(I)=V(I)+DT*K(I)
        ENDDO

C* get the position and orientation of reflecting segment 
        ih=1
        IF(CRYST.HMOS.GT.SEC) THEN   ! mosaict crystal
             ih=int((0.5+R(1)/CRYST.FRAME.SIZE(1))*CRYST.nh)+1
             dah=CRYST.FRAME.SIZE(1)*CRYST.RH/CRYST.nh        
             alfh=(-(CRYST.nh-1)/2+ih-1)*dah
        ELSE  ! elastically bent crystal
             alfh=0
        ENDIF          

        iv=int((0.5+R(2)/CRYST.FRAME.SIZE(2))*CRYST.nv)+1
        dav=CRYST.FRAME.SIZE(2)*CRYST.RV/CRYST.nv
        alfv=(-(CRYST.nv-1)/2+iv-1)*dav
        
C* go out if the neutron doesn't hit the crystal        
        IF((iv.LT.1).OR.(iv.GT.CRYST.nv).
     *  or.(ih.LT.1).or.(ih.GT.CRYST.nh)) goto 30


C* get new orientation of G vector including segment orientation
        G(1)=G0(1)-G0(3)*alfh
        G(3)=G0(3)+G0(1)*alfh
        IF (ABS(G0(3)).LT.0.01*CRYST.GTOT) THEN              
           G(2)=G0(2)-G0(1)*alfv   ! only in Laue case
        ELSE
           G(2)=G0(2)-G0(3)*alfv
        ENDIF
        C=SQRT(V3xV3(G,G))
        GG=CRYST.GTOT/C
        DO i=1,3
          G(i)=G(i)*GG          ! renormalize
        ENDDO 
        GG=CRYST.GTOT**2 
        
C if elastically bent crystal, include deformation
        IF(CRYST.HMOS.LE.SEC) THEN                
           CALL M3xV3_M(1,CRYST.MAPG,CRYST.DG_DR,R,DGR)  
           CALL V3AV3(1,G,DGR,G)   ! G now includes elastic deformation                   
           GG=V3XV3(G,G)          
        ENDIF                           

C calculate scalar product 2*(K*G)
        C=2.*V3XV3(K,G)                

C* wavelength and time-of-flight are corrected in order to meet
C* the Bragg condition:                   
        DKK=-GG/C-1        
        DO 15 I=1,3
15          K(I)=K(I)*(1+DKK)   
        NEUF.T=NEUF.T/(1+DKK)   
        NEUF.PHI=NEUF.PHI/(1+DKK) 
        
c        if (CRYST.FRAME.NAME(1:1).EQ.'m') then
c        write(*,5) 'M:  ',RN,TOUT-TIN,TNORM,DKK
c        write(*,5) 'R:  ',(R(I),I=1,3)        
c        if (mod(cryst.frame.count,10).eq.0) pause
c        endif 
                
        IF (INSIDE(CRYST.FRAME,R)) THEN
           CALL v3av3(1,K,G,K)
           NEUF.P=NEUI.P*(TOUT-TIN)/TNORM
!           NEUF.P=NEUI.P
           IF (NEUF.P.NE.0) THEN
             CALL SLIT_POST(CRYST.FRAME,R,K,NEUF.R,NEUF.K)	     
             CRYST.FRAME.COUNT=CRYST.FRAME.COUNT+1
             CRYST_GO=.TRUE.
           ELSE
              CRYST_GO=.FALSE.
           ENDIF
        ELSE
c        write(*,*) CRYST.FRAME.NAME,' POZOR!'
c        pause
           NEUF.P=0
           CRYST_GO=.FALSE.
        ENDIF
        
        RETURN
        
30      NEUF.P=0
        CRYST_GO=.FALSE.
        RETURN         
        
        END        

C	--------------------------------------------------
	LOGICAL*4 FUNCTION CRYST_SIMPLE(CRYST,NEUI,NEUF)
C	--------------------------------------------------
        implicit none

        INCLUDE 'const.inc'
        INCLUDE 'ness_common.inc'
                     
        RECORD /CRYSTAL/ CRYST
	RECORD /NEUTRON/ NEUI,NEUF
	REAL*8 V(3),K(3),R(3)
	REAL*8 G0(3),DGK(3),KaG(3)
	REAL*8 B,C,ETA1,ETA2,DT,PP,G2,TIN,TOUT,TAU
	INTEGER*4 I
	REAL*4 GASDEV1,RN
	REAL*8 v3xv3,HMOS_DIST
C        LOGICAL*4 FLAG

C5       format(a10,5(2x,G12.5))

C/// CRYST.DNRND must be specified elsewhere. X(..) is a random number  
C/// in the interval (-0.5,0.5)
        
        RN=RNDX(CRYST.DNRND+1)

C/// if thb=0 => special device:
   
        IF(NEUF.P.EQ.0) GOTO 30

C        FLAG=(CRYST.FRAME.COUNT.GT.8000)
C        IF (FLAG) write(*,5) 'RND: ',CRYST.DNRND,RN
C        IF (FLAG) write(*,5) 'RND: ',(RNDX(I),I=1,5)
C        IF (FLAG) write(*,5) 'RND: ',(RNDX(I),I=6,10)
C*  transform neutron coordinates to the local system
        CALL SLIT_PRE(CRYST.FRAME,NEUI.R,NEUI.K,V,K)              

C*  V mosaic block deviation is taken in random
C*  gaussian distribution of mosaic blocs is limitted to +-3*sigma        
        
        ETA2=CRYST.VMOS*GASDEV1(0.,3.)

C*  Move neutron inside the crystal, depth is chosen in random
        CALL CR_BORDER(CRYST,V,K,TIN,TOUT)
C      IF (FLAG) THEN 
C      write(*,5) 'V',(V(I),I=1,3)
C      write(*,5) 'K',(K(I),I=1,3)
C      write(*,5) 'T1,T2',TIN,TOUT
C      ENDIF
        IF(TIN.GE.TOUT) GOTO 30 ! no intersection with the crystal
        DT=TIN+RN*(TOUT-TIN)
        DO I=1,3
           R(I)=V(I)+K(I)*DT
        ENDDO
C        IF (FLAG) write(*,5) 'R',(R(I),I=1,3),DT,RN
        TOUT=TOUT-TIN-RN*(TOUT-TIN)
        TIN=-RN*(TOUT-TIN)        
        
C* get local G vector, assume no horizontal mosaic spread
        CALL LOCALG(CRYST,R,0.D0,ETA2,G0)
        G2=V3xV3(G0,G0)
        C=G2+2*V3xV3(K,G0)
        
C elastically bent crystal
        IF(CRYST.HMOS.LE.SEC) THEN              
          CALL M3xV3_M(1,CRYST.MAPG,CRYST.DG_DR,K,DGK)  
          CALL V3AV3(1,K,G0,KaG)
          B=2*V3xV3(KaG,DGK)
          IF(ABS(B).LT.1D-30) B=1D-30
          TAU=-C/B
          IF(TAU.GT.TIN.AND.TAU.LT.TOUT) THEN
             DO I=1,3
                R(I)=R(I)+K(I)*TAU
                G0(I)=G0(I)+TAU*DGK(I)
             ENDDO
             DT=DT+TAU
          ENDIF
          PP=1.D0
        ELSE
C mosaic crystal
          ETA1=-C/G2
          PP=HMOS_DIST(CRYST,ETA1)
          IF(PP.LE.1.D-5) GOTO 30
          CALL LOCALG(CRYST,R,ETA1,ETA2,G0)
C      IF (FLAG) THEN 
C      write(*,5) 'ETA',ETA1,ETA2
C      write(*,5) 'R',(R(I),I=1,3)
C      write(*,5) 'K',(K(I),I=1,3)
C      write(*,5) 'G',(G0(I),I=1,3)
C      CALL V3AV3(1,K,G0,KaG)           
C      write(*,5) 'K+G',(KaG(I),I=1,3)
C      ENDIF 
        ENDIF
        
        CALL V3AV3(1,K,G0,KaG)           
        NEUF.P=NEUI.P*PP
        NEUF.T=NEUI.T+DT/HOVM
        CALL SLIT_POST(CRYST.FRAME,R,KaG,NEUF.R,NEUF.K)	     
C      IF (FLAG) THEN 
C      write(*,5) 'RF',(NEUF.R(I),I=1,3)
C      write(*,5) 'KF',(NEUF.K(I),I=1,3)
C      pause
C      ENDIF 
        CRYST.FRAME.COUNT=CRYST.FRAME.COUNT+1
        CRYST_SIMPLE=.TRUE.
c        write(*,*) 'CR OK '
c        pause
        
        RETURN
        
30      NEUF.P=0
        CRYST_SIMPLE=.FALSE.
c        write(*,*) 'CR false '
c        pause
        RETURN         
	          
        END        

C -------------------------------------------------------------
      SUBROUTINE CR_BORDER(CR,R,K,TIN,TOUT)
C     Returns times of intersection with the crystal assembly borders, 
C     started at current position R and measured along K.
C     All in crystal local coordinate.
C  !! Time is in units [sec*h/m]   i.e. length=time*K
C--------------------------------------------------------------
      implicit none
      INCLUDE 'const.inc'
      INCLUDE 'structures.inc'
      RECORD /CRYSTAL/ CR
        
      REAL*8 R(3),K(3),TIN,TOUT,T1(3),T2(3),DUM
      INTEGER*4 I
	
      DO I=1,3
      IF (ABS(K(I)).GT.1.0D-8) THEN
       	T2(I)=(CR.FRAME.SIZE(I)/2.D0 - R(I))/K(I)
	T1(I)=(-CR.FRAME.SIZE(I)/2.D0 - R(I))/K(I)
        IF (T1(I).GT.T2(I)) THEN
	  DUM=T1(I)
          T1(I)=T2(I)
	  T2(I)=DUM
        ENDIF   	 
      ELSE
	  T2(I)=1.0D30
	  T1(I)=-1.0D30
      ENDIF
      END DO
      TIN=MAX(T1(1),T1(2),T1(3))
      TOUT=MIN(T2(1),T2(2),T2(3))
      IF (TIN.GT.TOUT) THEN
	 TIN=1D30
	 TOUT=1D30
      ENDIF
      END            

C -------------------------------------------------------------
      SUBROUTINE LOCALG(CR,R,ETA,PHI,G)
C Calculate local G-vector at R
C I0(3) segment coordinates
C R0(3) segment center physical coordinates
C ETA .. horizontal tilt angle of mosaic domain
C PHI .. vertical tilt angle of mosaic domain
C -------------------------------------------------------------
      implicit none
      INCLUDE 'const.inc'
      INCLUDE 'structures.inc'
      RECORD /CRYSTAL/ CR
      INTEGER*4 I,I1,I0(3)
      REAL*8 R(3),R0(3),G(3),W(3),AT(3),G0(3)
      REAL*8 Z,ETA,PHI,GABS
      
      CALL SEGCOORD(CR,R,R0,I0)
      
C Calculate local G-vector (only G-gradient) 
      DO I=1,3
          G0(I)=CR.G(I) 
          IF (CR.MAPG(I)) THEN
              W(I)=0.D0
	    DO I1=1,3
	        W(I)=W(I)+CR.DG_DR(I,I1)*(R(I1)-R0(I1))
	    ENDDO
	    G0(I)=G0(I)+W(I)
	  ENDIF  
      END DO
      GABS=SQRT(G0(1)**2+G0(2)**2+G0(3)**2)

C Add segment tilt angle and vertical mosaic spread 
      CALL SEGTILT(CR,I0,AT)
      G(1)=G0(1)-G0(3)*(AT(1)+AT(3))  
      G(3)=G0(3)+G0(1)*(AT(1)+AT(3)) 
      G(2)=G0(2)-G0(3)*AT(2)+GABS*PHI

C Add the angle of the mosaic block
      DO I=1,3
         G(I)=G(I)+GABS*CR.GAMA(I)*ETA
      END DO
C Renormalize
      Z=GABS/SQRT(G(1)**2+G(2)**2+G(3)**2)
      DO i=1,3
         G(i)=G(i)*Z
      ENDDO
      END


C ---------------------------------------------------------------------------
      SUBROUTINE SEGCOORD(CR,R,R0,I0)
C     return coordinates of the segment R0, in which the particle at R resides
C ---------------------------------------------------------------------------
      implicit none
      INCLUDE 'const.inc'
      INCLUDE 'structures.inc'
      RECORD /CRYSTAL/ CR
      REAL*8 R(3),R0(3),HALF
      INTEGER*4 I0(3) 
      PARAMETER(HALF=0.5D0)

C ih,iv,ib are the integre-coordinates of the closest segment
      I0(1)=NINT((R(1)/CR.FRAME.SIZE(1)+HALF)*CR.NH+HALF)
      I0(2)=NINT((R(2)/CR.FRAME.SIZE(2)+HALF)*CR.NV+HALF)
      I0(3)=NINT((R(3)/CR.FRAME.SIZE(3)+HALF)*CR.NB+HALF)
C get physical coordinates of the segment center
      R0(1)=CR.FRAME.SIZE(1)*(1.D0*(I0(1)-HALF)/CR.NH-HALF)
      R0(2)=CR.FRAME.SIZE(2)*(1.D0*(I0(2)-HALF)/CR.NV-HALF)
      R0(3)=CR.FRAME.SIZE(3)*(1.D0*(I0(3)-HALF)/CR.NB-HALF)
      END

C ----------------------------------------------------------
      SUBROUTINE SEGTILT(CR,I0,AT)
C     return tilt angles
C ----------------------------------------------------------
      implicit none
      INCLUDE 'const.inc'
      INCLUDE 'structures.inc'
      RECORD /CRYSTAL/ CR
      REAL*8 AT(3),da
      INTEGER*4 I0(3)
      
      IF(I0(1).GT.0.AND.I0(1).LE.CR.NH) THEN
           da=CR.FRAME.SIZE(1)*CR.RH/CR.nh        
           AT(1)=(-(CR.nh-1)/2.D0+I0(1)-1.D0)*da
      ELSE 
           AT(1)=0.D0
      ENDIF
      IF(I0(2).GT.0.AND.I0(2).LE.CR.NV) THEN
           da=CR.FRAME.SIZE(2)*CR.RV/CR.nv        
           AT(2)=(-(CR.nv-1)/2.D0+I0(2)-1.D0)*da
      ELSE 
           AT(2)=0.D0
      ENDIF
      IF(I0(3).GT.0.AND.I0(3).LE.CR.NB) THEN
           da=CR.FRAME.SIZE(3)*CR.RB/CR.nb        
           AT(3)=(-(CR.nb-1)/2.D0+I0(3)-1.D0)*da
      ELSE 
           AT(3)=0.D0
      ENDIF
      
      END
      

C---------------------------------------------------------------
      REAL*8 FUNCTION HMOS_DIST(CR,X)
C Distribution of horizontal angular deviation of mosaic blocks
C --------------------------------------------------------------
      IMPLICIT NONE
      INCLUDE 'const.inc'
      INCLUDE 'structures.inc'
      RECORD /CRYSTAL/ CR
      REAL*8 X     
      
      IF (CR.HMOS.GT.SEC) THEN	
	  HMOS_DIST=EXP(-0.5*(X/CR.HMOS)**2)
      ELSE 
          IF(ABS(X).LE.SEC) THEN
            HMOS_DIST=1
          ELSE
            HMOS_DIST=0
          ENDIF
      ENDIF        
      END 
