

!--------------------------------------------------------
      LOGICAL*4 FUNCTION SPINMATCH(S)
!//// SPIN determines the combination of spin states required:
!//// -3  .... down --> down
!//// -1  .... down --> up
!////  0  .... all
!//// +1  .... up --> down
!//// +3  .... up --> up
!--------------------------------------------------------
      IMPLICIT NONE
      INCLUDE 'ness_common.inc'
      REAL*4 S
      IF(SPINT.EQ.0) THEN
          SPINMATCH=.TRUE.
      ELSE
          SPINMATCH=(NINT(S).EQ.NINT(SPINT))
      ENDIF
      END     



!--------------------------------------------------------
      SUBROUTINE EVENT_STACK
! Encapsulates procedures handling event stack:
!        entry    kstack_write:
!        entry    kstack_kf:
!        entry    kstack_n:
!        entry    kstack_allocate:
!        entry    kstack_free:
!        entry    kstack_destroy:
!        entry    getqe:
!        entry    setqe:
!        entry    kstack_phi:
!--------------------------------------------------------
      IMPLICIT NONE
      INCLUDE 'const.inc'
      INCLUDE 'inout.inc'
      INCLUDE 'rescal.inc'
      INCLUDE 'ness_common.inc'

      INTEGER*4 ND,NI,MPAGE
      PARAMETER(ND=MQOM)  ! max. number of records
      PARAMETER(NI=10)  ! number of values in a record
      PARAMETER(MPAGE=128*1024)  ! size of memory block for events (number of records)

      REAL*8  K2(3),VQ(3),WQ(3),VF0,VI0,deh,dev,Z,QQ
      REAL*4 GASDEV

      LOGICAL*4 MAP0(3)

      INTEGER*4 INDX0,ITEM,I,J,K,IERR,KM,N,IM,IT1,IT2,ITEM1,ITEM2
      REAL*8 QE(4),P,KF,P1,P2,SI,SF,VKI(3),VKF(3),PHI
      LOGICAL*4 SPINMATCH,NEEDCOPY
      INTEGER*4 KMAX(0:MDAT),KTOP,IMAX,MAXALOC
      REAL*4 XX
      REAL, ALLOCATABLE :: KSTORE(:,:) ! auxilliary array for rearranging KSTACK
      REAL, ALLOCATABLE :: KSTACK(:,:) ! stores events
      SAVE KSTACK,KMAX
      DATA MAP0/.TRUE.,.TRUE.,.TRUE./
      DATA KTOP,IMAX,MAXALOC/0,0,0/

! KSTACK stores events for multiple simulations at different configurations:
! first index denotes:
! 1..3  <-- KF(3)
! 4..6  <-- Q(3) in Cooper&Nathans coordinates
!    7  <-- Energy transfer
!    8  <-- PI*PF (probability of KI and KF events)
!    9  <-- Spin transfer (2*SI+SF)
!   10  <-- precession phase difference
 
! second index denotes record index
! KMAX(ITEM) ... number of records allocated for ITEM'th simulation
! KTOP ... total number of allocated records
! IMAX ... number of stored simulations

201   FORMAT('STACK: ',I7,' records in ',I3,' sets, ',G10.4,' MB')

      IERR=0

!//// Entry to write event


      ENTRY KSTACK_WRITE(INDX0,ITEM,VKI,VKF,P1,P2,SI,SF,PHI)
!-----------------------------------------------------------------------
! Entry to write Q,omega, which is calculated from input values of KI,KF,...

      IERR=0
      IF(ITEM.GT.IMAX.OR.ITEM.LE.0) GOTO 106
      IF(INDX0.GT.(KMAX(ITEM)-KMAX(ITEM-1))) GOTO 105
        VF0=VKF(1)**2+VKF(2)**2+VKF(3)**2
        VI0=VKI(1)**2+VKI(2)**2+VKI(3)**2
        VQ(1)=VKF(1)
        VQ(3)=VKF(3)-STP.KF
!* transform dKF (difference from nominal KF) to Lab coord.
        K2(3)=-VQ(1)*SOMEGA+VQ(3)*COMEGA
        K2(2)=VKF(2)	
        K2(1)=+VQ(1)*COMEGA+VQ(3)*SOMEGA
!* get VQ (total Q in lab. coordinates) 
        DO I=1,2
            VQ(I)=K2(I)-VKI(I)
        END DO
!* VQ is the difference from nominal Q value 
        VQ(3)=K2(3)-VKI(3)+STP.KI
	
!* transform Q to C&N coord.
        DO I=1,3
            WQ(I)=0
            DO J=1,3
              WQ(I)=WQ(I)+MLC(J,I)*VQ(J)
            ENDDO
        ENDDO
!* add sample mosaicity 
        IF(SMOS.NE.0) THEN
          QQ=SQRT(WQ(1)**2+WQ(2)**2+WQ(3)**2)
          DEH=STP.Q*SMOS*GASDEV()   
          DEV=STP.Q*SMOS*GASDEV()
!          write(*,*) WQ(2), DEH
!          write(*,*) WQ(3), DEV
!          pause
          WQ(2)=WQ(2)+DEH
          WQ(3)=WQ(3)+DEV
          Z=SQRT(WQ(1)**2+WQ(2)**2+WQ(3)**2)
          DO I=1,3
            WQ(I)=WQ(I)*QQ/Z  ! keep |Q| unchanged
          ENDDO
        ENDIF    
!* store in KSTACK
        DO I=1,3
          XX=VKF(I)
          KSTACK(I,INDX0+KMAX(ITEM-1))=XX
          XX=WQ(I)
          KSTACK(I+3,INDX0+KMAX(ITEM-1))=XX
        ENDDO

        XX=HSQOV2M*(VI0-VF0)-STP.E
        KSTACK(7,INDX0+KMAX(ITEM-1))=XX
        XX=P1*P2
        KSTACK(8,INDX0+KMAX(ITEM-1))=XX
        XX=2*NINT(SI)+NINT(SF)
        KSTACK(9,INDX0+KMAX(ITEM-1))=XX
        XX=PHI
        KSTACK(10,INDX0+KMAX(ITEM-1))=XX
      RETURN


      ENTRY KSTACK_KF(INDX0,ITEM,KF,P)
!--------------------------------------------------------------------------
! Entry to read Kf
      IERR=0
      IF(ITEM.GT.IMAX.OR.ITEM.LE.0) GOTO 106
      IF(INDX0.GT.(KMAX(ITEM)-KMAX(ITEM-1))) GOTO 105
         KF=0
         DO I=1,3
           KF=KF+KSTACK(I,INDX0+KMAX(ITEM-1))**2
         ENDDO
         KF=SQRT(KF)
         IF(SPINMATCH(KSTACK(9,INDX0+KMAX(ITEM-1)))) THEN
            P=KSTACK(8,INDX0+KMAX(ITEM-1))
         ELSE
            P=0
         ENDIF
      RETURN


      ENTRY KSTACK_N(INDX0,ITEM)
!--------------------------------------------------------------------------
! Entry to return number of allocated events
      INDX0=KMAX(ITEM)-KMAX(ITEM-1)
      RETURN


      ENTRY KSTACK_ALLOCATE(INDX0,ITEM)
!--------------------------------------------------------------------------
! Entry for memory allocation 
! INDX0=num. of records to be allocated for ITEM-th set
      IERR=0
      IF(ITEM.LT.1.OR.INDX0.EQ.(KMAX(ITEM)-KMAX(ITEM-1))) THEN   ! no reallocation necessary
         RETURN
      ENDIF

!* DEFINE NUMBER OF NEWLY ALLOCATED ROWS
      IF(ITEM.GT.MDAT) THEN
         WRITE(SMES,*) 'Maximum number of data sets is ',MDAT
         STOP
      ENDIF
      IM=IMAX ! new top item
      IF(ITEM.GT.IMAX) IM=ITEM ! a new item will be added on top
      IF((INDX0+KTOP).GT.ND) THEN
	  INDX0=ND-KTOP
	  WRITE(SMES,*) 'Maximum allowed number of events: ',INDX0
      ENDIF
      KM=KMAX(ITEM)-KMAX(ITEM-1)   ! old number of records in ITEM-th item
      N=KTOP-KM+INDX0              ! new total number of records (= new  KTOP)

!* ALLOCATE NEW MEMORY if necessary       
      IF (N.GT.MAXALOC) THEN
        NEEDCOPY=(KTOP.GE.1.AND.IM.GT.1.AND.(ITEM.NE.1.OR.IMAX.GT.1))           
        IF (NEEDCOPY) THEN  !* save current KSTACK in temporary array
	  ALLOCATE (KSTORE(1:NI,1:KTOP),STAT=IERR)
          IF (IERR.NE.0) THEN
            WRITE(SMES,*) 'Cannot allocate more memory'
            GOTO 99
          ENDIF
          DO I=1,KTOP
            DO J=1,NI
              KSTORE(J,I)=KSTACK(J,I)
            ENDDO
          ENDDO
        ENDIF
        IF (ALLOCATED(KSTACK)) DEALLOCATE(KSTACK,STAT=IERR)
        IF (IERR.NE.0) GOTO 98
	I=INT(N/MPAGE)+1
	MAXALOC=I*MPAGE
        ALLOCATE (KSTACK(1:NI,1:MAXALOC),STAT=IERR)
        write(smes,*) 'Allocated memory for ',MAXALOC,' records.'
	IF (IERR.NE.0) GOTO 99
        IF (NEEDCOPY) THEN  !* restore current KSTACK from temporary array
          DO I=1,KTOP
            DO J=1,NI
              KSTACK(J,I)=KSTORE(J,I)
            ENDDO
          ENDDO
          IF (ALLOCATED(KSTORE)) DEALLOCATE(KSTORE,STAT=IERR)
          IF (IERR.NE.0) GOTO 98
	ENDIF
      ENDIF
        	
!* RE-ARRANGE VALUES IN KSTACK 
      IF (ITEM.LT.IMAX.AND.KM.NE.INDX0) THEN
        IF (INDX0.LT.KM) THEN ! shift down
	   DO I=KMAX(ITEM+1)+1,KMAX(IMAX)
             DO J=1,NI
               KSTACK(J,I+INDX0-KM)=KSTACK(J,I)
             ENDDO
	   ENDDO  
        ELSE IF (INDX0.GT.KM) THEN ! shift up
	   DO I=KMAX(IMAX),KMAX(ITEM+1)+1,-1
             DO J=1,NI
                KSTACK(J,I+INDX0-KM)=KSTACK(J,I)
             ENDDO	   
	   ENDDO
        ENDIF
      ENDIF
!* UPDATE KMAX(I),IMAX AND KTOP 
      DO K=ITEM,MDAT
         KMAX(K)=KMAX(K)+INDX0-KM
      ENDDO
      IMAX=IM
      KTOP=N
!* set the new records in ITEM = 0       
      DO I=KMAX(ITEM-1)+1,KMAX(ITEM)  
         DO J=1,NI
           KSTACK(J,I)=0.
         ENDDO	   
      ENDDO	

      RETURN


      ENTRY KSTACK_FREERANGE(ITEM1,ITEM2)
!--------------------------------------------------------------------------
! deallocate range of ITEM1..ITEM2 data sets
      IERR=0
      IT1=ITEM1
      IT2=ITEM2
      IF (ITEM2.GT.IMAX) IT2=IMAX
      IF (ITEM1.LT.2) IT1=1
      
      IF (IT2.LT.IT1.OR.IT1.GT.IMAX.OR.IT2.LT.1) RETURN 
      
      KM=KMAX(IT2)-KMAX(IT1-1)   ! number of records in deleted items
      KTOP=KTOP-KM               ! new total number of records 

!* RE-ARRANGE VALUES IN KSTACK 
      IF (IT2.LT.IMAX) THEN
        DO I=KMAX(IT2+1)+1,KMAX(IMAX)
          DO J=1,NI
            KSTACK(J,I-KM)=KSTACK(J,I)
          ENDDO
	ENDDO  
      ENDIF

!* UPDATE KMAX(I),IMAX
      IMAX=IMAX-1-IT2+IT1
      DO K=IT1,IMAX
         KMAX(K)=KMAX(K+1+IT2-IT1)-KM
      ENDDO
      DO K=IMAX+1,MDAT
         KMAX(K)=KMAX(K-1)
      ENDDO
      RETURN



      ENTRY KSTACK_DESTROY
!--------------------------------------------------------------------------
! Entry for memory deallocation
      KMAX=0
      IERR=0
      IF (ALLOCATED(KSTACK)) DEALLOCATE (KSTACK,STAT=IERR)
      IF (IERR.NE.0) GOTO 98
      IF (ALLOCATED(KSTORE))  DEALLOCATE (KSTORE,STAT=IERR)
      IF (IERR.NE.0) GOTO 98
      KTOP=0
      IMAX=0
      MAXALOC=0
      RETURN


      ENTRY GETQE(INDX0,ITEM,QE,P)
!--------------------------------------------------------------------------
! Entry for receive QE(4) vectors with appropriate weight
      IF(ITEM.GT.IMAX) GOTO 106
      IF(INDX0.GT.(KMAX(ITEM)-KMAX(ITEM-1))) GOTO 105
      IF (SPINMATCH(KSTACK(9,INDX0+KMAX(ITEM-1)))) THEN
         DO I=1,4
           QE(I)=KSTACK(I+3,INDX0+KMAX(ITEM-1))
         ENDDO
         P=KSTACK(8,INDX0+KMAX(ITEM-1))         
      ELSE
         P=0.
      ENDIF
      RETURN


      ENTRY SETQE(INDX0,ITEM,QE,P)
!-----------------------------------------------------------------
! Entry for setting QE(4) vector with weight
      IF(ITEM.GT.IMAX) GOTO 106
      IF(INDX0.GT.(KMAX(ITEM)-KMAX(ITEM-1))) GOTO 105
      DO I=1,4
           KSTACK(I+3,INDX0+KMAX(ITEM-1))=QE(I)
      ENDDO
      KSTACK(8,INDX0+KMAX(ITEM-1))=P
      KSTACK(9,INDX0+KMAX(ITEM-1))=0.
      RETURN

      ENTRY KSTACK_PHI(INDX0,ITEM,PHI,P)
!-----------------------------------------------------------------
! Entry to receive precession phase difference with appropriate weight
      IF(ITEM.GT.IMAX) GOTO 106
      IF(INDX0.GT.(KMAX(ITEM)-KMAX(ITEM-1))) GOTO 105
      PHI=KSTACK(10,INDX0+KMAX(ITEM-1))
      P=KSTACK(8,INDX0+KMAX(ITEM-1))
      RETURN

!-----------------------------------------------------------------
! Error messages

98    WRITE(SMES,*)'Error: deallocating memory for event storage: ',
     *    IERR
      STOP
!      RETURN

99    WRITE(SMES,*) 'Error: allocating memory for event storage: ',
     *    IERR
      STOP
!      RETURN

102   WRITE(SMES,*)'Attempt to write to a nonallocated arrea !'
      STOP
!      RETURN
103   WRITE(SMES,*)'Attempt to read from a nonallocated arrea !'
      STOP
104   WRITE(SMES,*)'Max. 10 event sets are allowed !'
      STOP
105   WRITE(SMES,*)'Not allocated: INDX0=',INDX0,' ITEM=',ITEM,
     *  ' IMIN=',KMAX(ITEM-1),' IMAX=',KMAX(ITEM)
      STOP
106   WRITE(SMES,*)'Not allocated ITEM: ',ITEM
      STOP


!      RETURN



      END


