C//////////////////////////////////////////////////////////////////////
C////
C////  R E S T R A X   4.7
C////
C////  TAS configuration: read and convert parameters
C////   
C////  
C//////////////////////////////////////////////////////////////////////

C----------------------------------------------------
      SUBROUTINE TAS_READCFG(SARG)
C Read *.cfg file
C 1) try CFGNAME
C 2) try 'default.cfg'
C 3) create default 'default.cfg' and read it   
C----------------------------------------------------      
      IMPLICIT NONE

      INCLUDE 'const.inc'
      INCLUDE 'inout.inc'
      INCLUDE 'res_cfg.inc'
     
      CHARACTER*(*) SARG
      INTEGER*4 U,IRETRY,I,IERR,IL,N1,N2,II,LL,IRD
      PARAMETER (U=22)
      CHARACTER*128 LINE,NAME
      INTEGER*4 READ_MIRROR
      
100   FORMAT(A60) 
101   FORMAT(a) 
102   FORMAT('A new file default.cfg is created in current directory',
     &     ' with default values.')
103   FORMAT('Cannot find configuration file ',a,//,
     &     'trying default.cfg... ')

201   FORMAT(
     1 'title (max.60 characters) :'/
     2 'default setup '/
     3 'source (shape,diameter,width,height):'/ 
     4 '0   10.   8.     8.  '/
     5 'n-guide (present, distance,length,hor1,hor2,ver1,ver2,',
     * 'ro[m-1], gh, gv [Ni nat.], refh, refv):'/ 
     6 '0  10.  6300.   2.5   2.5   15.   15.  2.4E-4  1  1  1  1'/
     5 'monochromator (chi,aniz.,poiss.,thick.,height,length,',
     * 'segments hor. & vert.):'/
     7 '0.0   1   0.3   0.3   12.0  10.0    1   3 '/
     8 'analyzer (chi,aniz.,poiss.,thick.,height,length,',
     * 'segments hor. & vert.):'/
     9 '0.0   1   0.3   0.3   12.0  10.0    1   3 '/
     d 'detector (shape,diameter,width,height):'/
     1 '1    4.0    3.0   5.0'/
     2 'distances (l1,l2,l3,l4):'/
     3 '900.  210.  150.  70.'/
     6 '1st collimator (distance,length,hor1,hor2,ver1,ver2,',
     * 'ro[m-1], gh, gv [Ni nat.], refh, refv):'/ 
     7 '236.   534.   8.05    5.   9.05   11.  0.  0.  0.  1   1'/
     8 '2nd collimator (distance,length,hor1,hor2,ver1,ver2,',
     * 'ro[m-1], gh, gv [Ni nat.], refh, refv):'/ 
     9 '87.    35.   4.   4.   7.   7.   0.  0.  0.  1   1'/
     d '3nd collimator (distance,length,hor1,hor2,ver1,ver2,',
     * 'ro[m-1], gh, gv [Ni nat.], refh, refv):'/ 
     1 '60.    35.   4.   4.   7.    7.  0.  0.  0.  1   1'/
     2 '4th collimator (distance,length,hor1,hor2,ver1,ver2,',
     * 'ro[m-1], gh, gv [Ni nat.], refh, refv):'/ 
     3 '35.    20.   4.   4.  12.   12.  0.  0.  0.  1   1')         
      
      IRETRY=0
      
      CALL BOUNDS(SARG,II,LL) 
      IF (LL.GT.0) NAME=SARG(II:II+LL-1)
      SELECT CASE (LL)
      CASE(0) ! empty argument: offer the current file and ask user
        NAME=CFGNAME
        IRD=1
      CASE DEFAULT ! try argument as the filename
        NAME=SARG(II:II+LL-1)
        IRD=0  
      END SELECT
      
1     CALL OPENRESFILE(NAME,'cfg',U,IRD,0,NAME,IERR) 
2     IF(IERR.NE.0) THEN      
         IF (NAME.NE.' ') THEN ! try dialog      
           NAME=' '
           GOTO 1
         ELSE IF(NAME(1:11).ne.'default.cfg') THEN ! try default.cfg
           WRITE(sout,103)
           NAME='default.cfg'
           GOTO 1
         ELSE IF (IRETRY.EQ.0) THEN ! create new default.cfg
           write(sout,102)
           IRETRY=1
           GOTO 10
         ELSE
           GOTO 999
         ENDIF  
      ENDIF            
        
      IL=0
      READ(U,*,ERR=19)
      IL=IL+1
      READ(U,100,ERR=19) CFGTITLE
      IL=IL+1
      READ(U,*,ERR=19)
      IL=IL+1
      TSRC=300.D0
      READ(U,101) LINE
      READ(LINE,*,ERR=701) NSRC,DSRC,WSRC,HSRC,TSRC
      GOTO 702
701   READ(LINE,*,ERR=19) NSRC,DSRC,WSRC,HSRC
      TSRC=0
702   IL=IL+1
      READ(U,*,ERR=19)
      IL=IL+1
      READ(U,*,ERR=19) (TAS_COL(I,1),I=1,12)
      IL=IL+1
      READ(U,*,ERR=19)
      IL=IL+1
      READ(U,*,ERR=19) (TAS_CRY(I,1),I=1,8)
      IL=IL+1
      READ(U,*,ERR=19)
      IL=IL+1
      READ(U,*,ERR=19) (TAS_CRY(I,2),I=1,8)
      IL=IL+1
      READ(U,*,ERR=19)
      IL=IL+1
      READ(U,*,ERR=19) NDET,DDET,WDET,HDET
      IL=IL+1
      READ(U,*,ERR=19)
      IL=IL+1
      READ(U,*,ERR=19) (TAS_DIS(I),I=1,4)
      IL=IL+1
      READ(U,*,ERR=19)
      IL=IL+1
      READ(U,*,ERR=19) (TAS_COL(I,2),I=2,12)
      IL=IL+1
      READ(U,*,ERR=19)
      IL=IL+1
      READ(U,*,ERR=19) (TAS_COL(I,3),I=2,12)
      IL=IL+1
      READ(U,*,ERR=19)
      IL=IL+1
      READ(U,*,ERR=19) (TAS_COL(I,4),I=2,12)
      IL=IL+1
      READ(U,*,ERR=19)
      IL=IL+1
      READ(U,*,ERR=19) (TAS_COL(I,5),I=2,12)
      CLOSE(U)
      CALL BOUNDS(NAME,II,LL)
      CFGNAME=NAME(II:II+LL-1)
      GOTO 50
      
C retry with default.cfg   
19    WRITE(SOUT,*) 'Error in the configuration file, line ',IL+1 
      IERR=1
      GOTO 2            

C create new default.cfg
10    OPEN(U,FILE='default.cfg',STATUS='NEW',ERR=999)
      WRITE(U,201)
      CLOSE(U)
      GO TO 1
      
C file read, do some converisons      
50    CONTINUE
      CALL BOUNDS(CFGNAME,I,IL)
      write(sout,*) 'Configuration updated: ',CFGNAME(I:I+IL-1)
C     GAMA is in mrad/A
C     RO is in mm^-1
      IL=0
      DO I=1,5
        TAS_COL(c_GAMAH,I)=TAS_COL(c_GAMAH,I)*GammaNi
        TAS_COL(c_GAMAV,I)=TAS_COL(c_GAMAV,I)*GammaNi
        TAS_COL(c_ROH,I)=TAS_COL(c_ROH,I)/1000.
        N1=READ_MIRROR(TAS_COL(c_GAMAH,I)) ! try to read mirror lookup table
        N2=READ_MIRROR(TAS_COL(c_GAMAV,I))
        IF(N1.LT.0.OR.N2.LT.0) IL=-1        
      ENDDO
c if the mirror lookup table is full, clear the table and read CFG again
      IF(IL.LT.0) THEN
        N1=READ_MIRROR(-1.D0)
        GOTO 1
      ENDIF  

      RETURN

999   WRITE(SMES,998)    
998   FORMAT('Fatal error: cannot create configuration file',/,
     * 'Check privileges or disk space !')
      STOP 
      END
      
C--------------------------------------------------------------------------
      SUBROUTINE TAS_TO_NESS      
C     Conversion of parameters from CFG and RESCAL fields to NESS 
C TAS is defined with inverted primary spectrometer - tracing starts at the sample!
C--------------------------------------------------------------------------
      IMPLICIT NONE

      INCLUDE 'const.inc'      
      INCLUDE 'inout.inc'      
      INCLUDE 'rescal.inc'      
      INCLUDE 'res_cfg.inc'
!      INCLUDE 'ness_common.inc'
      INCLUDE 'restrax.inc'      
      
      LOGICAL*4 USEGUIDE
      LOGICAL*4 EMOD
      COMMON /MODE/ EMOD
      REAL*8 LD,DUM,ei0,ef0
      INTEGER*4 I
      
C///  general setting: scattering triangle, etc...
      IF (TSRC.GT.0) STEMP=TSRC
      STP.NFX=RES_DAT(i_FX)
      STP.SM=RES_DAT(i_SM)
      STP.SS=RES_DAT(i_SS)
      STP.SA=RES_DAT(i_SA)
      STP.KFIX=RES_DAT(i_KFIX)
      STP.E=RES_DAT(i_EN)
      CALL QNORM(RES_DAT(i_QH),DUM,STP.Q)        	
c                     write(*,*) 'TAS_TO_NESS  1'
      IF (RES_DAT(i_FX).EQ.1.) THEN
         EI0=HSQOV2M*RES_DAT(i_KFIX)**2
         EF0=EI0-STP.E
      ELSE
         EF0=HSQOV2M*RES_DAT(i_KFIX)**2
         EI0=EF0+STP.E
      END IF     	 	 	 
      IF (EI0.LE.0.OR.EF0.LE.0) GOTO 999
      STP.KI=SQRT(EI0/HSQOV2M)
      STP.KF=SQRT(EF0/HSQOV2M)      
      
C///  sample:
      SMOS=RES_DAT(i_ETAS)*minute/SQRT8LN2
c                      write(*,*) 'TAS_TO_NESS  2'
      SAM.NAME='sample'      
      SAM.SHAPE=1
      SAM.DIST=0.
      SAM.AXI=0.
      DO I=1,3
        SOU.STA(I)=0.
        SOU.GON(I)=0.
      ENDDO
      SAM.SIZE(1)=RES_DAT(i_SDI)*10.
      SAM.SIZE(3)=RES_DAT(i_SDI)*10.
      SAM.SIZE(2)=RES_DAT(i_SHI)*10.
      
C///  Soller collimators
      GUIDE.FRAME.NAME='guide' 
      SOL1.FRAME.NAME='col1'
      SOL2.FRAME.NAME='col2'   
      SOL3.FRAME.NAME='col3'
      SOL4.FRAME.NAME='col4'   
CxxxxxxxxxCxxxxxxxxxCxxxxxxxxxCxxxxxxxxxCxxxxxxxxxCxxxxxxxxxCxxxxxxxxxCx            
      
      
      LD=TAS_COL(c_DIST,2)+TAS_COL(c_LEN,2)
      CALL CREATE_COL(SOL1,2,TAS_DIS(1)-LD,-1,0)
      USEGUIDE=(TAS_COL(c_USE,1).GT.0.AND.TAS_COL(c_LEN,1).GT.0)
      IF (USEGUIDE) THEN
         CALL CREATE_COL(GUIDE,1,LD,-1,0)
      ELSE
         CALL CREATE_COL(GUIDE,1,1.D0,-1,0)
      ENDIF    
c                      write(*,*) 'TAS_TO_NESS  3'
      LD=TAS_DIS(2)-TAS_COL(c_DIST,3)-TAS_COL(c_LEN,3)
      CALL CREATE_COL(SOL2,3,LD,-1,0)
c                      write(*,*) 'TAS_TO_NESS  4'
      CALL CREATE_COL(SOL3,4,TAS_COL(c_DIST,4),1,0)
c                      write(*,*) 'TAS_TO_NESS  5'
      CALL CREATE_COL(SOL4,5,TAS_COL(c_DIST,5),1,0)
c                      write(*,*) 'TAS_TO_NESS  6'
      

C///  monochromator:
      MON.FRAME.NAME='monochromator' 
      CALL CREATE_CRY(MON,1,TAS_DIS(2)-SOL2.FRAME.DIST/10.,-1)  
c                      write(*,*) 'TAS_TO_NESS  7'
      IF (STP.SM.LT.0) THEN 
        MON.FRAME.GON(1)=MON.THB-MON.CHI+PI/2
        SOL1.FRAME.AXI=MON.THB*2.
      ELSE IF (STP.SM.GT.0) THEN 
        MON.FRAME.GON(1)=-MON.THB-MON.CHI-PI/2
        SOL1.FRAME.AXI=-MON.THB*2.
      ELSE 
        MON.FRAME.GON(1)=0.   ! if SM=0, then a filter is considered instead of the analyzer
        MON.THB=0.            ! CRYST_GO recognizes this case if THB=0
        SOL1.FRAME.AXI=0.     ! dhkl determines the edge position, kc=pi/dhkl
        MON.CHI=PI/2.  
        MON.RH=0. 
        MON.RV=0.
        MON.HMOS=0.
        MON.VMOS=0.
      ENDIF                                 
C set index where crystal takes random numbers from /RAND/ X array      
      MON.DNRND=7

C///  source:
      SOU.NAME='source'   
      IF(NSRC.EQ.0) THEN
        SOU.SHAPE=2
        SOU.SIZE(1)=DSRC*10.
        SOU.SIZE(2)=DSRC*10.
        SOU.SIZE(3)=0.1
      ELSE
        SOU.SHAPE=3
        SOU.SIZE(1)=WSRC*10.
        SOU.SIZE(2)=HSRC*10.
        SOU.SIZE(3)=0.1
      ENDIF
      SOU.AXI=0.
      IF (USEGUIDE) THEN
        SOU.DIST=(TAS_COL(c_DIST,1)+TAS_COL(c_LEN,1))*10.
      ELSE 
C SOU.DIST is measured between SOURCE and GUIDE exit  
C TAS_DIS(1) is measured between GUIDE exit and SOL1 entry
        SOU.DIST=(TAS_COL(c_DIST,2)+TAS_COL(c_LEN,2))*10.
        SOU.DIST=SOU.DIST-GUIDE.FRAME.DIST     
      ENDIF
      DO I=1,3
        SOU.STA(I)=0.
        SOU.GON(I)=0.
      ENDDO

      
C///  analyzer:
      ANA.FRAME.NAME='analyzer'   
c      write(*,*) 'TAS_TO_NESS ',(TAS_CRY(I,2),I=1,8)
      CALL CREATE_CRY(ANA,2,TAS_DIS(3)-SOL3.FRAME.DIST/10.,1)        
c                      write(*,*) 'TAS_TO_NESS  8'
      IF(STP.SA.EQ.0) THEN
          ANA.FRAME.GON(1)=0.   ! if SA=0, then a filter is considered instead of the analyzer
          ANA.THB=0.            ! CRYST_GO recognizes this case if THB=0
          SOL4.FRAME.AXI=0.     ! dhkl determines the edge position, kc=2*pi/dhkl
          ANA.CHI=PI/2.  
          ANA.RH=0. 
          ANA.RV=0. 
          ANA.HMOS=0
          ANA.VMOS=0
      ELSE IF(CFGMODE.EQ.1) THEN    ! Option with scondary spectrometer turned up   
        IF (STP.SA.GT.0) THEN 
          ANA.FRAME.GON(1)=PI/2
          ANA.FRAME.GON(2)=-PI/2
          ANA.FRAME.GON(3)=ANA.THB-ANA.CHI
          SOL4.FRAME.AXI=0
          SOL4.FRAME.AXV=-ANA.THB*2.
        ELSE IF (STP.SA.LT.0) THEN 
          ANA.FRAME.GON(1)=-PI/2
          ANA.FRAME.GON(2)=+PI/2
          ANA.FRAME.GON(3)=-ANA.THB+ANA.CHI
          SOL4.FRAME.AXI=0
          SOL4.FRAME.AXV=ANA.THB*2.
        ENDIF       
      ELSE
        ANA.FRAME.GON(2)=0
        ANA.FRAME.GON(3)=0
        IF (STP.SA.GT.0) THEN 
          ANA.FRAME.GON(1)=ANA.THB-ANA.CHI+PI/2.
          SOL4.FRAME.AXI=ANA.THB*2.
          SOL4.FRAME.AXV=0
        ELSE IF (STP.SA.LT.0) THEN 
          ANA.FRAME.GON(1)=-ANA.THB-ANA.CHI-PI/2.
          SOL4.FRAME.AXI=-ANA.THB*2.
          SOL4.FRAME.AXV=0
        ENDIF  
      ENDIF
C set index where crystal takes random numbers from /RAND/ X array      
      ANA.DNRND=8
            
C///  dector:
      DET.NAME='detector'   
      IF(NDET.EQ.0) THEN
        DET.SHAPE=2
        DET.SIZE(1)=DDET*10.
        DET.SIZE(2)=DDET*10.
        DET.SIZE(3)=0.1
      ELSE
        DET.SHAPE=3
        DET.SIZE(1)=WDET*10.
        DET.SIZE(2)=HDET*10.
        DET.SIZE(3)=0.1
      ENDIF
      DET.AXI=0.
      DET.DIST=TAS_DIS(4)*10.-SOL4.FRAME.DIST
      DO 30 I=1,3
        DET.STA(I)=0.
        DET.GON(I)=0.
30    CONTINUE
                                      
      IF((STP.SM.EQ.0).OR.(STP.SA.EQ.0)) THEN
         STP.E=HSQOV2M*(STP.KI**2-STP.KF**2)             
      ENDIF 
      SOL2.BINT=STP.TAUF*HOVM**2*STP.KI**3/2.D0/gammaL*1.D7
      SOL3.BINT=STP.TAUF*HOVM**2*STP.KF**3/2.D0/gammaL*1.D7
      MON.TYP=0
      IF(EMOD) THEN
        ANA.TYP=1      
      ELSE
        ANA.TYP=0
      ENDIF
c                      write(*,*) 'TAS_TO_NESS  9'
      CALL SPEC_INITALL    !   Initialize all TAS components  
c        write(*,*) 'TAS_TO_NESS'
c        CALL WRITE_SETUP(20)      
c                      write(*,*) 'TAS_TO_NESS  OK'
      RETURN
      
999   WRITE(SMES,*) 'CHECK SCATTERING TRIANGLE !!!'
      END

C---------------------------------------------------------        
      SUBROUTINE CREATE_CRY(CR,IC,CDIST,DIR)
C CR ... structure of CRYSTAL type
C IC  ... index of the component (1=mono, 2=anal)
C CDIST ... distance in [cm] !!
C DIR ... direction downstream >0 or up-stream <0
C---------------------------------------------------------        
      IMPLICIT NONE

      INCLUDE 'const.inc'      
      INCLUDE 'inout.inc'      
      INCLUDE 'rescal.inc'
      INCLUDE 'restrax.inc'
      INCLUDE 'res_cfg.inc'

      INTEGER*4 IC,DIR
      REAL*8 CDIST
      
      RECORD /CRYSTAL/ CR
      
C///  monochromator:
      CR.FRAME.SHAPE=3
      CR.FRAME.SIZE(1)=TAS_CRY(c_X,IC)*10.
      CR.FRAME.SIZE(2)=TAS_CRY(c_Y,IC)*10.
      CR.FRAME.SIZE(3)=TAS_CRY(c_Z,IC)*10.
      CR.FRAME.DIST=CDIST*10.
      CR.FRAME.AXI=0.
      CR.CHI=-DIR*TAS_CRY(c_CHI,IC)*deg
      CR.DHKL=RES_DAT(i_DM+IC-1)
c      write(*,*) 'CREATE ',CR.FRAME.NAME(1:6),CR.DHKL,STP.KI,STP.KF
      
      IF (IC.EQ.1) THEN          
        CR.THB=ASIN(PI/CR.DHKL/STP.KI)
        CR.LAMBDA=2*PI/STP.KI
      ELSE
        CR.THB=ASIN(PI/CR.DHKL/STP.KF)
        CR.LAMBDA=2*PI/STP.KF
      ENDIF
          
      CR.RH=RES_DAT(i_ROMH+(IC-1)*2)/1000.
      CR.RV=RES_DAT(i_ROMV+(IC-1)*2)/1000.
      CR.HMOS=RES_DAT(i_ETAM+IC-1)*minute/SQRT8LN2
      CR.VMOS=CR.HMOS*TAS_CRY(c_ANI,IC)
      CR.POI=TAS_CRY(c_POI,IC)
      CR.VOL=1.6016
      CR.FHKL=2.3527
      CR.MI=0.D0   ! absorption is neglected      
      CR.NH=NINT(TAS_CRY(c_NH,IC))
      CR.NV=NINT(TAS_CRY(c_NV,IC))  
      
      END

C---------------------------------------------------------        
      SUBROUTINE CREATE_COL(SOL,IC,CDIST,DIR,POL)
C SOL ... structure of BENDER type
C IC  ... index of the component (1=guide .. 5=SOL4)
C CDIST ... distance in [cm] !!
C DIR ... direction downstream >0 or up-stream <0
C POL ... polarization (0 means no polarization)    
C---------------------------------------------------------        
      IMPLICIT NONE

      INCLUDE 'const.inc'      
      INCLUDE 'inout.inc'      
      INCLUDE 'rescal.inc'
      INCLUDE 'restrax.inc'
      INCLUDE 'res_cfg.inc'
      
      INTEGER*4 I,IC,DIR,POL,READ_MIRROR,N1,N2
      RECORD /BENDER/ SOL
      REAL*8 Z,CDIST,LNG,A,B
      
      
      SOL.CURV=TAS_COL(c_ROH,IC)
      SOL.GHLU=TAS_COL(c_GAMAH,IC)
      SOL.GHRU=TAS_COL(c_GAMAH,IC)
      IF (POL.EQ.0) THEN 
         SOL.GHLD=TAS_COL(c_GAMAH,IC)
         SOL.GHRD=TAS_COL(c_GAMAH,IC)
      ELSE
         SOL.GHLD=0
         SOL.GHRD=0
      ENDIF     
      SOL.GVT=TAS_COL(c_GAMAV,IC)
      SOL.GVB=TAS_COL(c_GAMAV,IC)
      SOL.RHLU=TAS_COL(c_REFH,IC)
      SOL.RHLD=TAS_COL(c_REFH,IC)
      SOL.RHRU=TAS_COL(c_REFH,IC)
      SOL.RHRD=TAS_COL(c_REFH,IC)
      SOL.RVT=TAS_COL(c_REFV,IC)
      SOL.RVB=TAS_COL(c_REFV,IC)
      N1=READ_MIRROR(TAS_COL(c_GAMAH,IC))
      N2=READ_MIRROR(TAS_COL(c_GAMAV,IC))
      SOL.NHLU=N1
      SOL.NHLD=N1
      SOL.NHRU=N1
      SOL.NHRD=N1
      SOL.NVT=N2
      SOL.NVB=N2 
      SOL.FRAME.AXI=0.
      SOL.FRAME.AXV=0.
      DO 10 I=1,3
        SOL.FRAME.STA(I)=0.
        SOL.FRAME.GON(I)=0.
10    CONTINUE          
      SOL.FRAME.SHAPE=3
      SOL.FRAME.DIST=CDIST*10.
      IF (DIR.GT.0) THEN
        SOL.FRAME.SIZE(1)=TAS_COL(c_HOR1,IC)*10.
        SOL.FRAME.SIZE(2)=TAS_COL(c_VER1,IC)*10.
        SOL.W2=TAS_COL(c_HOR2,IC)*10.
        SOL.H2=TAS_COL(c_VER2,IC)*10.      
      ELSE
        SOL.FRAME.SIZE(1)=TAS_COL(c_HOR2,IC)*10.
        SOL.FRAME.SIZE(2)=TAS_COL(c_VER2,IC)*10.
        SOL.W2=TAS_COL(c_HOR1,IC)*10.
        SOL.H2=TAS_COL(c_VER1,IC)*10.      
      ENDIF
        
      SOL.FRAME.SIZE(3)=TAS_COL(c_LEN,IC)*10.
      SOL.NLV=1
      SOL.DLH=0.08
      SOL.DLV=0.08
      
      
      LNG=SOL.FRAME.SIZE(3)    
      IF (IC.EQ.1) THEN 
        IF (TAS_COL(c_USE,IC).LE.0) THEN
           A=0
           B=0
        ELSE
           A=1000.
           B=1000.
        ENDIF    
      ELSE
         A=RES_DAT(i_ALF1+IC-2)   
         B=RES_DAT(i_BET1+IC-2)   
      ENDIF   
      IF((A.GT.0).AND.(LNG.GT.0)) THEN      
         IF(A.LT.500.) THEN
             Z=LNG*2.0*(A*minute+SOL.DLH/LNG)
             SOL.NLH=NINT((SOL.FRAME.SIZE(1)+SOL.W2)/Z)
         ELSE
             SOL.NLH=1
         ENDIF        
         IF(SOL.NLH.LE.0) SOL.NLH=1
         IF (B.GT.0.AND.B.LT.500) THEN
             Z=LNG*2.0*(B*minute+SOL.DLV/LNG)
             SOL.NLV=NINT((SOL.FRAME.SIZE(2)+SOL.H2)/Z) 
         ENDIF
      ELSE
          SOL.FRAME.SIZE(1)=1000.
          SOL.FRAME.SIZE(2)=1000.
          SOL.FRAME.SIZE(3)=0.
          SOL.W2=SOL.FRAME.SIZE(1)
          SOL.H2=SOL.FRAME.SIZE(2)
          SOL.NLH=1
          SOL.NLV=1          
      ENDIF  
      
      RETURN
      END              

        
C----------------------------------------------------
      SUBROUTINE TAS_TO_TRAX
C Convert RESTRAX data to TRAX arrays
C----------------------------------------------------      
      IMPLICIT NONE

      INCLUDE 'const.inc'
      INCLUDE 'inout.inc'
      INCLUDE 'rescal.inc'
      INCLUDE 'restrax.inc'
      INCLUDE 'trax.inc'
      REAL*8 DUM
      INTEGER*4 I
      LOGICAL*4 USEGUIDE
 
C scattering triangle
      HOMEGA=RES_DAT(i_EN)
      IF (RES_DAT(i_FX).EQ.1.) THEN
         NEFIX=1
         EI0=RES_DAT(i_KFIX)**2*HSQOVM/2.
         EF0=EI0-HOMEGA
      ELSE
         NEFIX=2
         EF0=RES_DAT(i_KFIX)**2*HSQOVM/2.
         EI0=EF0+HOMEGA
      END IF     	 	 	 
      IF (EI0.LE.0.OR.EF0.LE.0) GOTO 999
      VKI=SQRT(EI0*2./HSQOVM)
      VKF=SQRT(EF0*2./HSQOVM)

      CALL QNORM(RES_DAT(i_QH),DUM,VQ0)        	
         
C  sample	 
      ETS=RES_DAT(i_ETAS)
      IF (ETS.EQ.0.) ETS=0.00833333	 
      HISAM=0.
      HIS=HISAM*TDR
      ISC=RES_DAT(i_SS)
      NSAM=0
      DIASAM=RES_DAT(i_SDI)
      WSAM=RES_DAT(i_SDI) 
      THSAM=RES_DAT(i_SDI) 
      HSAM=RES_DAT(i_SHI)
      IF (DIASAM.EQ.0) DIASAM=0.01
      IF (HSAM.EQ.0) HSAM=0.01
	 
C  monochromator	 
      ETM=RES_DAT(i_ETAM)
      IF (ETM.EQ.0.) ETM=0.00833333
      HIMON=MON.CHI/TDR
      if (MON.HMOS.GT.0) THEN
        ANRM=MON.VMOS/MON.HMOS
      else
        ANRM=1
      endif 
      WMON=MON.FRAME.SIZE(1)/10.
      HMON=MON.FRAME.SIZE(2)/10.
      THMON=MON.FRAME.SIZE(3)/10.         
      ROHM=RES_DAT(i_ROMH)/100.
      ROVM=RES_DAT(i_ROMV)/100.
      CRYD(1)=RES_DAT(i_DM)
      POISS(1)=MON.POI
      IM=NINT(RES_DAT(i_SM))

C  analyzer
      ETA=RES_DAT(i_ETAA)
      IF (ETA.EQ.0.) ETA=0.00833333 	 
      HIANA=-ANA.CHI/TDR
      if (ANA.HMOS.GT.0) THEN
        ANRA=ANA.VMOS/ANA.HMOS
      else
        ANRA=1
      endif    
      WANA=ANA.FRAME.SIZE(1)/10.
      HANA=ANA.FRAME.SIZE(2)/10.
      THANA=ANA.FRAME.SIZE(3)/10.         
      ROHA=RES_DAT(i_ROAH)/100.
      ROVA=RES_DAT(i_ROAV)/100.	 
      CRYD(2)=RES_DAT(i_DA)
      POISS(2)=ANA.POI
      IA=RES_DAT(i_SA)

C  source
      IF(SOU.SHAPE.EQ.2) THEN
        NSOU=0
        DIASOU=SOU.SIZE(1)/10.
      ELSE
        NSOU=1
        DIASOU=SOU.SIZE(1)/10.
        WSOU=SOU.SIZE(1)/10.
        HSOU=SOU.SIZE(2)/10.
      ENDIF  
      SRCTEMP=STEMP
C  detector
      IF(DET.SHAPE.EQ.2) THEN
        NDET=0
        DIADET=DET.SIZE(1)/10.
      ELSE
        NDET=1
        DIADET=DET.SIZE(1)/10.
        WDET=DET.SIZE(1)/10.
        HDET=DET.SIZE(2)/10.
      ENDIF  
      
C neutron guide:
      USEGUIDE=(GUIDE.GHLU.GT.0.AND.GUIDE.FRAME.SIZE(3).GT.0)
      IF (USEGUIDE) then 
         GAMACR=GUIDE.GHLU
         NGUIDE=1
      ELSE
         NGUIDE=0
         GAMACR=0
      ENDIF
      
C  Soller collimators
      DO I=1,4
        ALPHA(I)=RES_DAT(I+i_ALF1-1)
        BETA(I)=RES_DAT(I+i_BET1-1)
      ENDDO  
	 	 
c ////   if ALPHA(I)<500  then the coarse collimator is ignored
c ////   if ALPHA(I)>=500 then the Soller collimator is ignored 
c ////   if ALPHA(I)=0 then no collimation is considered

      NFM=-1
      NFS=-1
      NFA=-1
      NFD=-1
      IF (ALPHA(1).GE.500.) THEN
        ALPHA(1)=0.
        NFM=1
      END IF
      IF (ALPHA(2).GE.500.) THEN
        ALPHA(2)=0.
        NFS=1
      END IF
      IF (ALPHA(3).GE.500.) THEN
        ALPHA(3)=0.
        NFA=1
      END IF
      IF (ALPHA(4).GE.500.) THEN
        ALPHA(4)=0.
        NFD=1
      END IF

C distances
      IF (GUIDE.FRAME.SIZE(3).GT.0) THEN
         VL0=(SOL1.FRAME.DIST+GUIDE.FRAME.DIST)/10.
      ELSE
         VL0=(SOL1.FRAME.DIST+GUIDE.FRAME.DIST+SOU.DIST)/10.            
      ENDIF
      VL1=(SOL2.FRAME.DIST+MON.FRAME.DIST)/10.
      VL2=(SOL3.FRAME.DIST+ANA.FRAME.DIST)/10.
      VL3=(SOL4.FRAME.DIST+DET.DIST)/10.
C collimator 1
      IF (SOL1.FRAME.SIZE(3).LE.0) THEN
         NFM=-1
      ELSE
         NFM=1
         VLSM=SOL1.FRAME.SIZE(3)/10.
         HDM1=SOL1.W2/10.
         HDM2=SOL1.FRAME.SIZE(1)/10.
         VDM1=SOL1.H2/10.
         VDM2=SOL1.FRAME.SIZE(2)/10.
         VLCANM=VL0-(SOL1.FRAME.SIZE(3)+SOL1.FRAME.DIST)/10.
      ENDIF   

C collimator 2
      IF (SOL2.FRAME.SIZE(3).LE.0) THEN
         NFS=-1
      ELSE
         NFS=1
         VLMS=SOL2.FRAME.SIZE(3)/10.
         HDS1=SOL2.W2/10.
         HDS2=SOL2.FRAME.SIZE(1)/10.
         VDS1=SOL2.H2/10.
         VDS2=SOL2.FRAME.SIZE(2)/10.
         VLCANS=(MON.FRAME.DIST-SOL2.FRAME.SIZE(3))/10.
      ENDIF   
      
C collimator 3
      IF (SOL3.FRAME.SIZE(3).LE.0) THEN
         NFA=-1
      ELSE
         NFA=1
         VLSA=SOL3.FRAME.SIZE(3)/10.
         HDA1=SOL3.FRAME.SIZE(1)/10.
         HDA2=SOL3.W2/10.
         VDA1=SOL3.FRAME.SIZE(2)/10
         VDA2=SOL3.H2/10.
         VLCANA=SOL3.FRAME.DIST/10.
      ENDIF   
C collimator 4
      IF (SOL4.FRAME.SIZE(3).LE.0) THEN
         NFD=-1
      ELSE
         NFD=1
         VLAD=SOL4.FRAME.SIZE(3)/10.
         HDD1=SOL4.FRAME.SIZE(1)/10.
         HDD2=SOL4.W2/10.
         VDD1=SOL4.FRAME.SIZE(2)/10
         VDD2=SOL4.H2/10.
         VLCAND=SOL4.FRAME.DIST/10.
      ENDIF   
      
      IF (VLSM.LE.0) NFM=-1
      IF (VLMS.LE.0) NFS=-1
      IF (VLSA.LE.0) NFA=-1
      IF (VLAD.LE.0) NFD=-1
      
      RETURN
      
999   WRITE(SMES,*) 'CHECK SCATTERING TRIANGLE !!!'
     
      END

