C
C $Id: res_fit.f,v 1.4 2006/05/12 15:22:12 saroun Exp $  
C**************************************************************
      SUBROUTINE MATIN(ARRAY,NORDER,DT)
C**************************************************************
C  
C     ** INVERSION OF A SYMMETRIC MATRIX FROM BEVINGTON **
C   

      INCLUDE 'const.inc'


      DOUBLE PRECISION ARRAY,AMAX,SAVE
      DIMENSION ARRAY(MPAR,MPAR),IK(MPAR),JK(MPAR)
10    DT = 1.
11    DO 100 K=1,NORDER
      AMAX = .0
21    DO 30 I=K,NORDER
      DO 30 J=K,NORDER
23    IF(DABS(AMAX)-DABS(ARRAY(I,J))) 24,24,30
24    AMAX = ARRAY(I,J)
      IK(K) = I
      JK(K) = J
30    CONTINUE
31    IF(AMAX) 41,32,41
32    DT = .0
      GOTO 140
41    I = IK(K)
      IF(I-K) 21,51,43
43    DO 50 J=1,NORDER
      SAVE = ARRAY(K,J)
      ARRAY(K,J) = ARRAY(I,J)
50    ARRAY(I,J) = -SAVE
51    J = JK(K)
      IF(J-K) 21,61,53
53    DO 60 I=1,NORDER
      SAVE = ARRAY(I,K)
      ARRAY(I,K) = ARRAY(I,J)
60    ARRAY(I,J) = -SAVE
61    DO 70 I=1,NORDER
      IF(I-K) 63,70,63
63    ARRAY(I,K) = -ARRAY(I,K)/AMAX
70    CONTINUE
71    DO 80 I=1,NORDER
      IF(I-K) 74,80,74
74    DO 77 J = 1,NORDER
      IF(J-K) 75,77,75
75    ARRAY(I,J) = ARRAY(I,J)+ARRAY(I,K)*ARRAY(K,J)
77    CONTINUE
80    CONTINUE
81    DO 90 J=1,NORDER
      IF(J-K) 83,90,83
83    ARRAY(K,J) = ARRAY(K,J)/AMAX
90    CONTINUE
      ARRAY(K,K) = 1./AMAX
100   DT = DT*AMAX
101   DO 130 L=1,NORDER
      K = NORDER - L +1
      J = IK(K)
      IF(J-K) 111,111,105
105   DO 110 I=1,NORDER
      SAVE = ARRAY(I,K)
      ARRAY(I,K) = -ARRAY(I,J)
110   ARRAY(I,J) = SAVE
111   I = JK(K)
      IF(I-K) 130,130,113
113   DO 120 J=1,NORDER
      SAVE = ARRAY(K,J)
      ARRAY(K,J) = -ARRAY(I,J)
120   ARRAY(I,J) = SAVE
130   CONTINUE
140   RETURN
      END


C**************************************************************
!      SUBROUTINE FDERIV(FUNCTN,X,A,DELTAA,NPT,NPTS,NTERMS,DERIV)
      SUBROUTINE FDERIV(DELTAA,DERIV)
C 14/4/2006, J.S.    
c rewritten to deal with common arrays defined in restrax.inc  
C/// Modified on 20.4.99 by J. Saroun:
C/// NPT contains partition of X,Y array to individual spectra
C**************************************************************
      implicit none
      INCLUDE 'const.inc'
      INCLUDE 'restrax.inc'

      REAL*4 DELTAA(MPAR),DERIV(MAXD,MPAR)
      REAL*4 YFIT1(MAXD),YFIT2(MAXD),AJ,DELTA
      INTEGER*4 I,J    
      REAL*4 EVAL,HIST


      DO J=1,nfpar
      IF(DELTAA(J).NE.0) THEN
        AJ = FPAR(J)
        DELTA = DELTAA(J)
        fpar(J) = AJ+DELTA
        eval = hist(xhist,yfit1,npt,NPT(MDAT),fpar,nfpar)
        FPAR(J) = AJ-DELTA
        eval = hist(xhist,yfit2,npt,NPT(MDAT),fpar,nfpar)

        do i = 1,NPT(MDAT)
          DERIV(I,J) = (YFIT1(I)-YFIT2(I))/(2.*DELTA)
        enddo

        fpar(J) = AJ
      ELSE
        do i = 1,NPT(MDAT)
          DERIV(I,J) = .0
        enddo
      ENDIF
      ENDDO

      RETURN
      END



C------------------------------------------------------------
      SUBROUTINE CURF3T(DELTAA,FLAMDA,NFREE)
C 14/4/2006, J.S.    
c rewritten to deal with common arrays defined in restrax.inc  
C
c      SUBROUTINE CURF3T(FUNCTN,X,Y,SIGMAY,IPT,NPT,NPTS,NTERMS,MODE,
c     *         A,DELTAA,SIGMAA,COVAR,FLAMDA,YFIT,CHISQR,DCHISQ)
C
C  ****** CURF1T IS CURFIT MODIFIED TO ALLOW FOR COVARIANCE
C  ****** MATRIX OUTPUT
C  ****** CURF3T IS CURFIT evaluating FUNCTN in a single call
C
C/// Modified on 20.4.99 by J. Saroun:
C
C/// IPT contains indexes for data points, which are used as mask.
C/// NPT contains partition of X,Y array to individual spectra
C/// If IPT(i)<=0 , the point is excluded from fitting
C/// DCHISQ(i) now contains partial Chi^2 for individual spectra 
C------------------------------------------------------------

      implicit none
      
      INCLUDE 'const.inc'
      INCLUDE 'restrax.inc'
      
      REAL*4 DELTAA(MPAR),FLAMDA,DT
      INTEGER*4 NFREE
      REAL*4 WEIGHT(MAXD),ALPHA(MPAR,MPAR),BETA(MPAR),DERIV(MAXD,MPAR),B(MPAR)
      REAL*8 ARRAY(MPAR,MPAR)
      INTEGER*4 INS(MPAR),NP
      REAL*4 eval,hist,fchisq,DY,CHISQ1,CHI
      INTEGER*4 I,J,K
   
      NP=NPT(MDAT)
  
C///  set weigths:
  
      DO  I=1,NP
        IF (IPT(I).LE.0) THEN     ! weight=0 to ignore the point if IPT(i)=0
           WEIGHT(I)=0
        ELSE 
          SELECT CASE(MODE)  
          CASE(-1)
            IF(ABS(SPY(I)).LE.1.) THEN
              WEIGHT(I) = 1.
            ELSE
              WEIGHT(I) = 1./ABS(SPY(I))
            ENDIF
          CASE(0)
            WEIGHT(I) = 1.
          CASE DEFAULT
            WEIGHT(I) = 1./(SPZ(I)**2)
          END SELECT
        ENDIF
      ENDDO

C/// get derivatives:  
      eval = hist(XHIST,RHIST,nhist,nhist(MDAT),fpar,nfpar)
      CALL FDERIV(DELTAA,DERIV)

C// get initial Chisq

c      CHISQ1 = FCHISQ(SPY,SPZ,IPT,NPT(MDAT),NFREE,MODE,RHIST,DCHISQ)  
c modified J.S., 5/5/2006:
c this call is not needed, it is sure that CHISQR has been calculated before
      CHISQ1=CHISQR

C// construct the matrix
      DO J=1,nfpar
         BETA(J) = .0
         DO  K=1,J
           ALPHA(J,K) = .0
         END DO
      END DO   
      DO I=1,np
        DY = SPY(I)-RHIST(I)
        DO J=1,nfpar
          BETA(J) = BETA(J)+WEIGHT(I)*DY*DERIV(I,J)
          DO K=1,J
            ALPHA(J,K) = ALPHA(J,K)+WEIGHT(I)*DERIV(I,J)*DERIV(I,K)
          END DO
        END DO  
      END DO
C// make it symmetric
      DO J=2,nfpar
        DO K=1,J-1
          ALPHA(K,J) = ALPHA(J,K)
        END DO
      END DO

C// check if some diagonal element = 0, then keep it fixed 
      DO  J=1,nfpar
          INS(J) = 0
          IF(ABS(ALPHA(J,J)).LT.1.E-19) INS(J)=1
      END DO

C// start here the cycle with FLAMDA adjustment
      DO WHILE (FLAMDA.LE.1000.AND.CHISQ1.GT.0)

C// get the normalized matrix, ARRAY
        DO J=1,nfpar
          DO K=1,nfpar
            IF((INS(J)+INS(K)).EQ.0) THEN
              ARRAY(J,K) = ALPHA(J,K)/SQRT(ALPHA(J,J)*ALPHA(K,K))
              COVAR(J,K) = ARRAY(J,K)
            ELSE ! set COVAR = delta(i,j) for i or j fixed 
              ARRAY(J,K) = .0
              COVAR(J,K) = .0
              IF(J.EQ.K) COVAR(J,K)=1.
            ENDIF
          END DO 
          ARRAY(J,J) = 1.+FLAMDA
        END DO

C// invert ARRAY      
        CALL MATIN(ARRAY,nfpar,DT)

C// calculate increments, B(i) 
        DO J=1,nfpar
          B(J) = .0
          DO K=1,nfpar
            IF((INS(J)+INS(K)).EQ.0) THEN
              B(J) = B(J)+BETA(K)*ARRAY(J,K)/SQRT(ALPHA(J,J)*ALPHA(K,K))
            ENDIF
          END DO 
        END DO

C// set B(i)= new estimated values
        DO J=1,nfpar
          B(J) = B(J)+FPAR(J)
        END DO
      
C// check new ChiSq     
        eval = hist(XHIST,RHIST,nhist,nhist(MDAT),b,nfpar)
        CHISQR = FCHISQ(SPY,SPZ,IPT,NPT(MDAT),NFREE,MODE,RHIST,DCHISQ)

C// if ChiSq increases, try again with larger FLAMDA
        IF (CHISQ1-CHISQR.LT.0) THEN
           FLAMDA = 10.*FLAMDA 
        ELSE
           CHISQ1=-1. ! signal to stop cycle
        ENDIF       
      ENDDO
      
C// finalization of an iteration step:
C// update FPAR(i) values and error estimates
      DO J=1,nfpar
         FPAR(J) = B(J)
         IF(INS(J).EQ.0) THEN
           CHI = CHISQR
           IF(CHISQR.LT.1) CHI=1.
           SIGMAA(J) = SQRT(ABS(ARRAY(J,J))*CHI*(1.+FLAMDA)/ALPHA(J,J))
         ELSE
           SIGMAA(J) = .0
         ENDIF
      ENDDO

C// decrease FLAMDA for next iteration
      FLAMDA = FLAMDA/10.

      END



C------------------------------------------------------------
C
      REAL*4 FUNCTION FCHISQ(Y,SIGMAY,IPT,NPTS,NFREE,MODE,YFIT,DCHISQ)
C/// Modified on 20.4.99 by J. Saroun:
C
C/// IPT contains indexes for data points, which are used as mask.
C/// If IPT(i)<=0 , the point is excluded from fitting
C/// DCHISQ(i) now contains partial Chi^2 for individual spectra 
C------------------------------------------------------------
C  
C       EVALUATES REDUCED CHISQUARE FOR FIT TO DATA (BEVINGTON)
C  
      implicit none
      INCLUDE 'const.inc'

      INTEGER*4 NPTS,NFREE,MODE
      REAL*8 CHISQ, WEIGHT
      REAL*4 Y(NPTS),SIGMAY(NPTS),YFIT(NPTS)
      INTEGER*4 IPT(NPTS),NF(0:MDAT),NSUM,J,I
      REAL*4 DCHISQ(MDAT),Z,RES
      
      CHISQ=0.0
      RES=0.0
      NSUM=0
      DO J=1,MDAT
         DCHISQ(J)=0.0
         NF(J)=0.0
      ENDDO   
      IF (NFREE.LE.0) GOTO 50      
      DO I=1,NPTS
        J=IPT(I)
        IF (J.LE.0) THEN     ! weight=0 to ignore the point if IPT(i)=0
           WEIGHT=0.0
        ELSE
          SELECT CASE(MODE)
          CASE(-1)
            IF(ABS(Y(I)).GT.0.E0) THEN
              WEIGHT = 1./Y(I)
            ELSE
              WEIGHT = 1.
            ENDIF
          CASE(0)
            WEIGHT = 1.      
          CASE DEFAULT
            WEIGHT = 1./(SIGMAY(I)**2)
          END SELECT
c 1     format('FCHISQ: i,Y,FIT: ',I3,2x,2(1x,G12.6))
c        write(*,*) I,Y(I),YFIT(I)
          Z=WEIGHT*(Y(I)-YFIT(I))**2
          DCHISQ(J)=DCHISQ(J)+Z
          NF(J)=NF(J)+1
          NSUM=NSUM+1
          CHISQ = CHISQ+Z
        ENDIF   
      ENDDO
      
      RES = CHISQ/NFREE
      DO J=1,MDAT
         IF (NF(J).GT.0) DCHISQ(J)=DCHISQ(J)/NF(J)/NFREE*NSUM
      ENDDO   
50    FCHISQ=RES
      RETURN
      END
C
C
C------------------------------------------------------------
C
      SUBROUTINE GETPEAKPARAM(X,Y,N,suma,center,fwhm,wspread)
C get peak parameters
C------------------------------------------------------------
      IMPLICIT NONE
      INCLUDE 'const.inc'
      
      INTEGER*4 N,I
      REAL*4 X(*),Y(*)
      
      REAL*8 S0,S1,S2,suma,center,fwhm,wspread,z
      suma=0.
      S0=0
      S1=0
      S2=0
      DO I=1,N
        Z=X(I)
        S0=S0+Y(I)
        S1=S1+Y(I)*Z
        S2=S2+Y(I)*Z**2
      ENDDO
      suma=S0
      center=S1/S0
      wspread=SQRT8LN2*SQRT(S2/S0-center**2)
      CALL CALFWHM(X,Y,N,fwhm)
       
      END

     
C-------------------------------------------------------------------
      SUBROUTINE CALFWHM(X,Y,N,fwhm)
C Calculate fwhm      
C-------------------------------------------------------------------
      implicit none

      INTEGER*4 N,I,IMAX,I1,I2    
      REAL*4 X(*),Y(*)
      REAL*8 YMAX,X1,X2,fwhm
      YMAX=Y(1)
      IMAX=1
      DO I=1,N         
         IF(YMAX.LE.Y(I)) THEN
           IMAX=I
           YMAX=Y(I)
         ENDIF  
      ENDDO
      I1=1
      DO WHILE ((Y(I1).LT.YMAX/2.D0).AND.(I1.LT.N))
        I1=I1+1
      ENDDO
      I2=N
      DO WHILE ((Y(I2).LT.YMAX/2.D0).AND.(I2.GT.0))
        I2=I2-1
      ENDDO
      IF((I1.GT.1).AND.(I1.LT.N).AND.(I2.GT.1).AND.(I2.LT.N).AND.
     *   (I1.LE.I2)) then
         X1=X(I1-1)+(YMAX/2.D0-Y(I1-1))/(Y(I1)-Y(I1-1))*(X(I1)-X(I1-1))
         X2=X(I2)+(YMAX/2.D0-Y(I2))/(Y(I2+1)-Y(I2))*(X(I2+1)-X(I2))
         fwhm=x2-x1
      ELSE
         fwhm=0
      ENDIF
      END

C $Log: res_fit.f,v $
C Revision 1.4  2006/05/12 15:22:12  saroun
C bug fix: DET structure passed to MATIN as the last argument instead of a dummy real
C
