C//////////////////////////////////////////////////////////////////////
C////  $Id: res_grf.f,v 1.6 2006/05/06 13:54:58 saroun Exp $
C////  R E S T R A X   4.6
C////
C////  Graphics output subroutines (PGPlot library required)
C////  Top level subroutines
C////
C////
C//////////////////////////////////////////////////////////////////////

C-------------------------------------------------
      SUBROUTINE SELGRFDEV(SARG,IQUIET)
C  Select an existing graphics device
C  if SARG given, use it as requested device string,
C  otherwise start dialog
C  no info if IQUIET>0
C-------------------------------------------------
      IMPLICIT NONE

      INCLUDE 'const.inc'
      INCLUDE 'inout.inc'
      INCLUDE 'res_grf.inc'
      
      CHARACTER*(*) SARG
      INTEGER*4 ND,NF,IQUIET
      PARAMETER(ND=32)
      INTEGER*4 ISEL,I,IC,IQ,ISS,ILS,LLS,ISD,ILD,LLD,IPOS,ILA,LLA
      CHARACTER*128 S
      CHARACTER*8 DTYPE(ND),SD
      
1     FORMAT(a)
2     FORMAT('current graphics device: ',a,2x,'(',I3,')')      
3     FORMAT('selected graphics device: ',a,2x,'(',I3,')')      
      ISEL=0 ! selection index
      
      if (IQUIET.LE.0) write(sout,2) TRIM(DEVSTR),DEVID
      IF (SARG.NE.' ') THEN ! non-interactive mode
        IC=19 ! only one attempt
        IQ=1 ! quiet, non-interactive
        CALL BOUNDS(SARG,ISS,ILS)
        LLS=ISS+ILS-1
        S=SARG(ISS:LLS)
        ISS=1
        ILS=LLS
      ELSE  ! interactive mode
        S=DEVSTR
        CALL BOUNDS(S,ISS,ILS)
        LLS=ISS+ILS-1
        IQ=0 ! interactive
        IC=0 ! attempts counter
      ENDIF  
              
c// make up to 20 attempts to select a valid device      
      DO WHILE (ISEL.LE.0.AND.IC.LT.20)
        S=S(ISS:LLS)
        CALL LISTGRFDEV(DTYPE,ND,NF,IQUIET) ! list available drivers
        IF (IQ.LE.0) CALL DLG_STRING('select device: ',S,1)        
        CALL BOUNDS(S,ISS,ILS)
        LLS=ISS+ILS-1 ! last non-space character  
            
        CALL LASTSUBSTR(S,'/',IPOS) ! find device type substring
        IF (IPOS.GT.0) THEN
          ILA=MIN(LLS-IPOS+1,8) ! max. 8 characters for device type
          LLA=IPOS+ILA-1
          CALL MKUPCASE(S(IPOS:LLA))
C search for matching device
          ISEL=0
          I=1
          DO WHILE (ISEL.LE.0.AND.I.LE.NF)
            SD=DTYPE(I) ! get upper case version of the i-th device type
            CALL MKUPCASE(SD)
            CALL BOUNDS(SD,ISD,ILD) ! calculate SD string limits
            LLD=ISD+ILD-1
c       write(*,*) '<',S(IPOS:LLA),'><',SD(ISD:LLD),'>'
            IF (INDEX(SD(ISD:LLD),S(IPOS:LLA)).EQ.1) ISEL=I ! check match
c           IF (ILA.EQ.ILD.AND.S(IPOS:LLA).EQ.SD(ISD:LLD)) ISEL=I ! check match
            I=I+1
          ENDDO
        ELSE
          ISEL=0 ! not a valid device name
        ENDIF     
        IF (ISEL.LE.0) IC=IC+1
      ENDDO
      IF (ISEL.GT.0) THEN
         IF (IPOS.GT.ISS) THEN
           DEVSTR=S(ISS:IPOS-1)//SD(ISD:LLD)
         ELSE
           DEVSTR=SD(ISD:LLD)
         ENDIF
         DEVID=ISEL
      ELSE
         if (IQUIET.LE.0) write(smes,*) "device not available: ",TRIM(S)
      ENDIF       
      write(sout,3) TRIM(DEVSTR),DEVID
      END


C-------------------------------------------------
      SUBROUTINE LISTGRFDEV(DTYPE,ND,NF,IQ)
C  Print an indexed list of available devices on sout
C  return device types in DTYPE array
C  return number of found devoces in NF
C  IQ .. quiet if IQ>0
C-------------------------------------------------
      IMPLICIT NONE

      INCLUDE 'const.inc'
      INCLUDE 'inout.inc'
      INTEGER*4 ND,NF,IQ
      INTEGER*4 I,TLEN,DLEN,INTER,IS,IL
      CHARACTER*8 DTYPE(ND)
      CHARACTER*64 DESCR
      CHARACTER*3 CI(0:1)
      DATA CI /'no ','yes'/
1     FORMAT('    name    [int]  description ',/,79('-'))
2     FORMAT(a10,2x,'[',a3,']',2x,a)
      
      IF (IQ.LE.0) WRITE(SOUT,1)
      CALL PGQNDT(NF)
      DO I=1,NF
        CALL PGQDT(I, DTYPE(I), TLEN, DESCR, DLEN, INTER)
        CALL BOUNDS(DTYPE(I)(1:TLEN),IS,IL)
        IF (IQ.LE.0) THEN
           WRITE(SOUT,2) DTYPE(I)(IS:IS+IL-1),TRIM(CI(INTER)),DESCR(1:DLEN)
        ENDIF
      ENDDO
      END
      
C-------------------------------------------------
      SUBROUTINE INITGRF(IQ)
C  Initialization of the PGPlot graphics device.
C  IQ=0 ... output to the current device
C  IQ=1 ... output to the PostScript file "restrax.ps"
C  IQ=2 ... prompts for another output device
C-------------------------------------------------
      IMPLICIT NONE

      INCLUDE 'const.inc'
c      INCLUDE 'inout.inc'
      INCLUDE 'res_grf.inc'

      CHARACTER*60 DST,AUX
      INTEGER*4 IQ,IDEVSTR,PGOPEN,IFIRST
      SAVE IDEVSTR,IFIRST

      IF(IQ.EQ.2) CALL SELGRFDEV(' ',0)
      DST=DEVSTR
      IF(IQ.EQ.1) DST='"restrax.ps"/vps'
     
201   IDEVSTR=PGOPEN(TRIM(DST)) 
c      write(*,*) IDEVSTR
      IF (IDEVSTR.LE.0) THEN
          write(*,*) 'PGOPEN not succesful, set to /NULL'
          CALL SELGRFDEV('/NULL',1)
          CALL PGQINF('DEV/TYPE',DEVSTR,DEVID)
          RETURN
      END IF
      
c// set portrait window at the beginning
      IF (IFIRST.EQ.0) THEN
        AUX=DST
        CALL MKUPCASE(AUX)
        IF (INDEX(TRIM(AUX),'/XSERV').GT.0) THEN
          CALL PGPAP(4.0,1.4)
          IFIRST=1
        ENDIF
      ENDIF
C// open the page
      CALL PGPAGE
      IF(IQ.EQ.1) THEN
         CALL PGSLW(4) ! set wider lines for printing
      ELSE         
         CALL PGSLW(2)
      ENDIF 
C// keep device info up to date
      IF(IQ.NE.1) CALL PGQINF('DEV/TYPE',DEVSTR,DEVID)
      END

C----------------------------------------------------------------------
      SUBROUTINE PLOTOUT
C Top-level subroutine for handling graphics output in RESTRAX.
C Uses command line arguments stored in common RET,NOS array (inout.inc)
C TOPRINT>0  ... print the last output. Repeat the last command with the output 
C                device redirected to a PostScript file and prints. 
C                Plotting subroutines should use RET(11..40) to store interactively 
C                entered arguments for subsequent printing.
C GRFARG(0)=ICOM   ... command ID
C Calls appropriate subroutine accorrding to the ICOM value:
C   -3     ... RES_IMAGE           
C   -4     ... RES_IMAGEALL        
C   -5     ... AB_IMAGE(ig_FCRES)  
C   -6     ... AB_IMAGE(ig_SQMAP)
C   -1..3  ... PAGE1(ICOM)
C    4..8  ... PAGE2(ICOM-4) (single data) or  PLOT_MDATA (multiple data)     
C   14..18 ... PLOT_MRES(ICOM-14) 
C    9     ... VIEWSCAN(NINT(RET(3)))
C CALLED BY: PLOT command by RESTRAX
C----------------------------------------------------------------------
      IMPLICIT NONE

      INCLUDE 'const.inc'
      INCLUDE 'inout.inc'
      INCLUDE 'restrax.inc'
      INCLUDE 'res_grf.inc'

      INTEGER*4 ICOM

      
      IF (SWPLOT.EQ.0) THEN
        WRITE(SOUT,*) 'graphics output switched off'
        RETURN
      ENDIF
      
      ICOM=NINT(GRFARG(0))

C// open PGPLOT device
      CALL INITGRF(TOPRINT)

C// Dispatch plot jobs according to ICOM
      IF(ICOM.EQ.-3) THEN
          CALL RES_IMAGE(mf_cur)   ! R(Q,E) projection
      ELSE IF(ICOM.EQ.-4) THEN
          CALL RES_IMAGE(0)        ! R(Q,E) projection merged for all data sets
      ELSE IF(ICOM.EQ.-5) THEN
          CALL AB_IMAGE(ig_FCRES)  ! R(Q,E) for flat-cone
      ELSE IF(ICOM.EQ.-6) THEN
          CALL AB_IMAGE(ig_SQMAP)  ! S(Q) map in E=const.
      ELSE IF(ICOM.EQ.-7) THEN
          CALL AB_IMAGE(ig_FCDATA)  ! data for flat-cone
      ELSE IF(ICOM.LE.3) THEN
          CALL PAGE1(ICOM)        ! 4 projections in C&N space + parameters
      ELSE IF(ICOM.EQ.4) THEN
          CALL PAGE2(0) ! plot both res.function and scan profile       
      ELSE IF(ICOM.EQ.5) THEN
          CALL PLOT_MDATA ! plot scan profiles for multiple data 
      ENDIF      
      IF(ICOM.EQ.9) CALL VIEWSCAN  ! scan through R(Q,w)
      IF(ICOM.EQ.14.OR.ICOM.EQ.15) CALL PLOT_MRES(1) ! plot res. function ellipsoid
      IF(ICOM.EQ.16) CALL PLOT_MRES(0) ! plot res. function - image  
C// close PGPLOT device
      CALL PGCLOS
      IF (EXTPLOT.NE.' ') THEN
        CALL DOSHELL(EXTPLOT)
      ENDIF

C// Try to send restrax.ps on a printer defined as:
C// 1) 'PGPLOT_ILL_PRINT_CMD'  .... PGPLOT enviroment variable
C// 2) 'PRINTER'               .... system enviroment variable
C// 3)  lpr                    .... system standard printer 

      IF (TOPRINT.EQ.1) THEN
         CALL PRINTFILE('restrax.ps')
         TOPRINT=0
      ENDIF
      END


C----------------------------------------------------------------------
      SUBROUTINE PAGE1(ICOM)
C Creates the page 1: 4 projections of the resolution ellipsoid + param. list
C for current dataset
C   ICOM=0..1 ... plots only the resol. ellipsoid from TRAX
C   ICOM=2    ...  plots also external ellipsoid from M.C.
C   ICOM=3    ...  plots also 2D-image from M.C.
C   ICOM=-1   ...  plots also a direction of the scan made by a position-sensitive 
C                  detector if it is used instead of a conventional one.
C CALLS: FILARRAY, PSDSCAN
C CALLED BY: PLOTOUT(-1..3) 
C----------------------------------------------------------------------
      IMPLICIT NONE
      
      INCLUDE 'const.inc'
      INCLUDE 'inout.inc'
      INCLUDE 'rescal.inc'
      INCLUDE 'restrax.inc'
      INCLUDE 'res_grf.inc'

      INTEGER*4 NIMA,ICOM,K,IERR,IUSER,INOW
      PARAMETER(NIMA=64)

      REAL*8 ZERO(4),PSD(4,2)
      REAL*4 AIMA(NIMA,NIMA),RX(2),RY(2)
      CHARACTER*20 USER,NOW
      CHARACTER*12 fname
      COMMON /ERROR/IERR
      DATA ZERO/0.,0.,0.,0./

10    FORMAT('ness_2d',I1,'.mat')

      IF ((ICOM.EQ.2).OR.(ICOM.EQ.3)) THEN
        IF(ANESS(1,1).EQ.0) GOTO 998
      ELSE
        IF(ATRAX(1,1).EQ.0) RETURN
      ENDIF

      IF((ICOM.EQ.2.OR.ICOM.EQ.3).AND.(ANESS(1,1).EQ.0)) GOTO 998

      CALL MK_PORTS(ICOM)             ! prepares 4 viewports

C/// writes the headline:
      CALL PGVPORT(0.1,0.97,0.9,1.0)
      CALL PGWINDOW(0.0,1.0,0.0,1.0)
      CALL PGSCH(1.3)
      CALL PGSCF(2)
      CALL PGPTEXT(0.5,0.75,0.0,0.5,
     *'Projections of the Resolution Function')
      CALL PGSCH(1.0)
      CALL PGSCF(1)
      CALL PGQINF('USER',USER,IUSER)
      CALL PGQINF('NOW',NOW,INOW)
      CALL PGIDEN


C/// **** Begin of the cycle in which the 4 projections are plotted ***

      DO 200 K=1,4

      CALL PLOTFRAME(VPORT(K),1,1,0.75,1)
      IF (ICOM.EQ.3) THEN
        CALL FILARRAY(VPORT(K),0,0.D0,0.D0,AIMA,NIMA,NIMA,0)          
        IF (GRFSAVE.GE.2) THEN
          write(fname,10) K
          CALL WriteMap(fname,AIMA,NIMA,VPORT(K).XTIT,VPORT(K).YTIT,
     &        VPORT(K).WX1,VPORT(K).WX2,VPORT(K).WY1,VPORT(K).WY2,
     &        mf_par(i_QH,mf_cur),mf_par(i_EN,mf_cur))
        ENDIF

        CALL PLOT2D(VPORT(K),AIMA,NIMA,NIMA,NIMA,NIMA,0.)
        CALL PLOTFRAME(VPORT(K),1,1,0.75,0)
      ENDIF
      IF (ATRAX(1,1).NE.0) THEN
        CALL PLOTELL(VPORT(K),1,1,ATRAX,ZERO,0)
        CALL PLOTELL(VPORT(K),1,2,ATRAX,ZERO,1)
      ENDIF
      IF ((ICOM.EQ.2).AND.(ANESS(1,1).NE.0)) THEN
        CALL PLOTELL(VPORT(K),2,1,ANESS,AMEAN,0)
        CALL PLOTELL(VPORT(K),2,2,ANESS,AMEAN,1)
      ENDIF
200   CONTINUE

      IF (ICOM.EQ.-1) THEN
        CALL PSDSCAN(PSD(1,1),PSD(1,2),PSD(2,1),PSD(2,2),PSD(4,1),
     1               PSD(4,2))
        PSD(3,1)=0
        PSD(3,2)=0
        DO K=1,4
           RX(1)=PSD(VPORT(K).IX,1)
           RX(2)=PSD(VPORT(K).IX,2)
           RY(1)=PSD(VPORT(K).IY,1)
           RY(2)=PSD(VPORT(K).IY,2)
           CALL PLOTLINE(VPORT(K),2,1,RX,RY,2)
        END DO
      ENDIF

c      return

      CALL GRLIST  ! list of parameters

      RETURN

998   write(smes,*) 'No Monte Carlo events to plot!'
      RETURN
      END

C----------------------------------------------------------------------
      SUBROUTINE PAGE2(ICOM)
C Creates the page 2: R(Q,E) + dispersion branches in the upper part 
C and the scan curve bellow
C   ICOM  ... as in PlotResol and PlotResQE
C----------------------------------------------------------------------
      IMPLICIT NONE

      INCLUDE 'const.inc'
      INCLUDE 'inout.inc'
      INCLUDE 'restrax.inc'
      INCLUDE 'res_grf.inc'

      RECORD /VIEWSET/ PORT

      INTEGER*4 ICOM,IERR,NP,IB,I,IC
      REAL*4 XFX(101),FY(101)
      COMMON /ERROR/ IERR
      LOGICAL*4 EMOD
      COMMON /MODE/ EMOD

C/// upper part

      ierr=0

      PORT.DX1=0.15
      PORT.DX2=0.93
      PORT.DY1=0.63
      PORT.DY2=0.99

      if (EMOD) then
        call PlotResQE(PORT,mf_cur,ICOM,1)
      else
        call PlotResol(PORT,ICOM)
      endif
      

C/// lower part, plot whatever is in current histogram
      PORT.DY1=0.12
      PORT.DY2=0.52
      IF (iand(WHATHIS,1).EQ.1) THEN ! check that the histogram is available

        NP=NHIST(mf_cur)-NHIST(mf_cur-1)   ! number of points in current histogram
        IB=NHIST(mf_cur-1)+1               ! base index for current histogram
        do i=1,NP
           FY(I)=RHIST(I+IB-1)
           XFX(I)=XHIST(I+IB-1)
        end do
        IF (SWRAYTR.EQ.0) THEN  ! TRAX result
          IC=1
        ELSE           ! ray-tracing result
          IC=2
        ENDIF      
        call PlotScan(PORT,XFX,FY,NP,IC,4,2)
      ENDIF
      IF (IC.EQ.1) call PGSCI(2)
      IF (IC.EQ.2) call PGSCI(1)
      call LegFit(PORT,0.8,6.5)
      call LegFile(PORT)
      CALL PGIDEN

      RETURN
998    write(smes,*) 'No Monte Carlo events to plot !'
      RETURN
      END


C----------------------------------------------------------------------
      SUBROUTINE PLOT_MRES(ICOM)
C Plots multiple res. functions, each in one cell, starting with
C the current channel (mf_cur). Maximum is 20 cells.
c   ICOM  ... as in PlotResQE
C----------------------------------------------------------------------
      IMPLICIT NONE

      INCLUDE 'const.inc'
c      INCLUDE 'inout.inc'
      INCLUDE 'restrax.inc'
      INCLUDE 'res_grf.inc'

      RECORD /VIEWSET/ PORT
      INTEGER*4 ICOM,J,NROW,NCOL,NCELL
            
      NCELL=mf_max-mf_cur+1  ! Number of data sets to plot on page
      IF (NCELL.GT.16) NCELL=20 ! no more than 20 cells on a page
      
      NCOL=NINT(SQRT(NCELL*1.))
      NROW=INT((0.999*NCELL)/NCOL)+1            
      IF(NCOL.GT.2) THEN
         call PGSLW(2)
      ELSE
         call PGSLW(3)
      ENDIF         
      DO J=1,NCELL
          CALL SETPORTCELL(PORT,NROW,NCOL,J) 
          CALL PlotResQE(PORT,J+mf_cur-1,ICOM,0)
      ENDDO

      CALL PGIDEN

      RETURN
      END

C----------------------------------------------------------------------
      SUBROUTINE PLOT_MDATA
C Plots multiple data on one page (complementary to PLOT_MRES)
C   ICOM=0..3   ... used to set colors
C CALLS: PLOTCELL,AB_IMAGE(flatcone only)
C CALLED BY: PLOTOUT(4..8) if mf_max>1
C----------------------------------------------------------------------
      IMPLICIT NONE

      INCLUDE 'const.inc'
      INCLUDE 'inout.inc'
      INCLUDE 'restrax.inc'
      INCLUDE 'res_grf.inc'

      RECORD /VIEWSET/ PORT
      REAL*4 CHSIZE
      INTEGER*4 J,IC,IL,NROW,NCOL,NCELL
            
      NCELL=mf_max+1   ! number of plot cells  
      IF (NCELL.GT.20) NCELL=20  ! no more than 20 cells on a page   
      
      NCOL=NINT(SQRT(NCELL*1.))
      NROW=INT((0.999*NCELL)/NCOL)+1            
      IF(NCOL.GT.2) THEN
         call PGSLW(2)
      ELSE
         call PGSLW(3)
      ENDIF               
      IF (iand(WHATHIS,2).EQ.0) THEN  ! bit2=0 => TRAX resol.
         IC=1
         IL=2
      ELSE
         IC=2
         IL=1
      ENDIF      
      DO J=1,NCELL-1
          CALL SETPORTCELL(PORT,NROW,NCOL,J) 
          CALL PLOTCELL(PORT,J,IC,0,1)
      ENDDO
      CALL SETPORTCELL(PORT,NROW,NCOL,NCELL) 
      CALL CLRPORT(PORT)
      chsize=MAX(0.7,2.5*(PORT.DX2-PORT.DX1))
      chsize=MIN(chsize,1.2)
      CALL PGSCI(IL)
      call LegFit(PORT,CHSIZE,0.01)

      CALL PGIDEN

      RETURN

      END
      

