C//////////////////////////////////////////////////////////////////////
C////  $Id: res_hist.f,v 1.9 2006/05/08 21:39:57 saroun Exp $
C////
C////  R E S T R A X   4.73
C////
C////  Subroutines for handling histograms + encapsulating fitting routine
C////
C//////////////////////////////////////////////////////////////////////

C in filling histograms, WHATHIS flag is set to signal:
C bit 1 .. histogram ready
C bit 2 .. using ray-tracing
C bit 4 .. using EXCI module

C---------------------------------------------------------------------------
      SUBROUTINE HISTINIT
C///*****  Initialize histograms   *****
C/// this is the default partitioning of histogram arrays:
C/// space is made for current data (mf_cur) and all other active datasets
C-----------------------------------------------------------------
      IMPLICIT NONE
      
      INCLUDE 'const.inc'
      INCLUDE 'restrax.inc'
      INTEGER*4 I,J,NH0 
      
      DO I=1,MDAT
         IF ((mf_active(I).AND.I.LE.mf_max).or.(I.EQ.mf_cur)) THEN 
            NHIST(I)=NHIST(I-1) + NHI 
            NH0=(NHI+1)/2
            DO J=NHIST(I-1)+1,NHIST(I)
               XHIST(J)=(J-NH0-NHIST(I-1))
               RHIST(J)=0
               IHIST(J)=I
            END DO            
            SHIST(I)=0
         ELSE
            NHIST(I)=NHIST(I-1)          
            SHIST(I)=0
         ENDIF 
      END DO
      WHATHIS=iand(WHATHIS,254) ! set bit1=0 => no RHIST ready
c      write(*,*) 'HISTINIT ',WHATHIS

      END

C---------------------------------------------------------------------
      REAL*8 FUNCTION GETSQOM(IMIN,IMAX)
C Create the vector of all the (Q,E) events 
C Arguments:
C IMIN,IMAX ... min. and max. dataset number
C Return: CHKQOM
C
C arrays created:
C QOM(4,I) ... Q(3),E of the I-th event in r.l.u. coordinates
C PQOM(I)  ... weight of the I-th event
C NQOM(item)  ... NQOM(item)-NQOM(item-1) = number of events for item-th data set 
C IQOM(I) ... index of the data set the I-th event belongs to
C IMPORTANT !    QOM contains full values of Qhkl,E, while the events
C   returned by GETQE are only relative to the scan centre, Qhkl(0) E(0)     
C---------------------------------------------------------------------

      IMPLICIT NONE

      INCLUDE 'const.inc'
      INCLUDE 'inout.inc'
      INCLUDE 'rescal.inc'
      INCLUDE 'restrax.inc'
      INCLUDE 'exciimp.inc'
c      RECORD /QOMEGA/ rq


      REAL*8 one,eps
      PARAMETER (one=1.,eps=1e-20)
      INTEGER*4 I,J,K,NPH,ITEM,IMIN,IMAX
      REAL*8 X(4),XX(4),VAR(4),AUX(4),AUX4(4,4),P,CHKBASE
      REAL*8 AMAT(4,4),ARC(4,4),ADA(4,4),B(4,4)
      
      REAL*4  XR(4,NXR)            
      COMMON /RNUM/ XR
      
      REAL*4 GASDEV 

c1     format('GETSQOM, ',a,6(1x,G12.6))
C------------------------------------------------------------------------
C  HNORM is calculated integrated intensity
C  Integrated intensity is normalized to 10^6 counts per 1cm^2 of the monitor
C  supposing unit monitor efficiency at ki=1A^-1 
C  and unit value of S(Q,E) = 1 /cm/meV/ster   
C  RELTR=(2*PI)**3*SQRT(DET(ki,r,kf))/DET(ki)) ~ V*d(Omega)*d(E)
C  RELMC=the same, but calculated from M.C. events
C  ZNORM = 10^6*HSQOVM*SQRT(24/PI) is caclulated in  RT_CONVRT (factor kf/ki included)
C  SQRT(24/PI) is a correction for the gaussian approximation of the sample volume.
C  SUMAMC is the sum of events describing R(Q,omega)
C  SHIST is the sum of the histogram (events are weighted by S(Q,omega))
C  from EXCI and by 1/dE when accumulating RHIST!!!)
C------------------------------------------------------------------------
      
!      write(*,*) 'GETSQOM START: ' 

C/// for R(Q,E) from TRAX:
C/// Initialize random numbers corresponding to exp(-.5 x^2) 
      IF(SWRAYTR.EQ.0) THEN
        NPH=NXR
        IF(XR(1,1).EQ.0) THEN ! generate random numbers only once
        DO I=1,NXR
          XR(1,I)=GASDEV()
          XR(2,I)=GASDEV()
          XR(3,I)=GASDEV()
          XR(4,I)=GASDEV()
        ENDDO 
        ENDIF
        WHATHIS=iand(WHATHIS,253) ! set bit2=0 => resol. is from TRAX
      ELSE
        WHATHIS=ior(WHATHIS,2)    ! set bit2=1 => resol. is from ray-tracing
      ENDIF

C// set initial pointers NQOM(I)=0  ! NOTE: NQOM(0)=0 always
      rq.nqom(0)=0
      DO ITEM=1,IMIN-1
        rq.NQOM(ITEM)=rq.NQOM(ITEM-1)
      END DO
    

C/// Create the vector of all the (Q,w) events 
C/// QOM(4,I) is Q(3),E of an event in r.l.u. coordinates with weight PQOM(I)
C///-------------------------------------------------------------------------
      rq.CHKQOM=0.D0
      CHKBASE=exp(1.D0)
C// Start cycle through ITEM ... No. of a data set
      DO 30 ITEM=IMIN,IMAX
c fill arrays for all data   IF(.NOT.mf_active(ITEM)) goto 30   ! only active data sets
        SUMAMC(ITEM)=0
C// Fill HNORM array for all data sets
        IF(SWRAYTR.EQ.0) THEN
C// Elipsoid main axes are calculated and stored in  ADA(i,i) and B(i,j)                                           ***
C// !!! For each ITEM, take the resol. matrix from mf_A(J,K,ITEM) array !!!
          DO J=1,4
          DO K=1,4
             AMAT(J,K)=mf_A(J,K,ITEM) 
             ARC(J,K)=mf_MRC(J,K,ITEM) 
          END DO
          END DO
          CALL CN2RLU_MF(AMAT,AUX4,ITEM)
          CALL DIAG(AUX4,ADA,B)
          DO J=1,4
            VAR(J)= 1./SQRT(ABS(ADA(j,j)))
          END DO
          HNORM(ITEM)=RELTR(ITEM)*ZNORM
        ELSE
          CALL KSTACK_N(NPH,ITEM)   ! Get number of events from ray-tracing
          HNORM(ITEM)=RELMC(ITEM)*ZNORM/1000.
          DO J=1,4
            DO K=1,4
               ARC(J,K)=mf_MRC(J,K,ITEM) ! get conversion matrix C&N->RLU
            END DO
          END DO        
        ENDIF        
        DO j=1,4
         rq.QOM0(j,ITEM)=mf_par(i_QH-1+j,ITEM) ! store Qhkl,E to share with EXCI
        END DO 
        rq.NQOM(ITEM)=NPH+rq.NQOM(ITEM-1)  ! Increment NQOM by the number of events

C// Start cycle through all events of ITEM-th resol. function
        DO 29 I=rq.NQOM(ITEM-1)+1,rq.NQOM(ITEM)
C// !!! Take Q,E from mf_par(k,item) array, not from QH,QK,... !!!
          DO  K=1,4
            rq.QOM(K,I) = mf_par(i_QH+K-1,ITEM) 
          END DO          
          IF (SWRAYTR.EQ.0) THEN                    ! events generated by MC/Trax
            DO K=1,4
              XX(K) = XR(K,I-rq.NQOM(ITEM-1))*VAR(K)  ! Transform point in unit sphere to res. elipsoid
            END DO            
            DO K=1,4
              DO J=1,4
                rq.QOM(K,I) = rq.QOM(K,I)+ B(K,J)*XX(J)  !!!!! Attention: B(I,J) is transposed !!!!!!!!!!!!
              END DO
            END DO
            rq.PQOM(I)=1.D0
c            write(*,1) 'QOM: ',(rq.QOM(K,I),K=1,4)  
c            write(*,1) 'VAR : ',(XX(K),K=1,4)
c            write(*,1) 'XX : ',(XX(K),K=1,4)
c            pause
            
          ELSE                                     ! events are generated by NESS
            CALL GETQE(I-rq.NQOM(ITEM-1),ITEM,X,P)
            rq.PQOM(I)=P
            CALL M4XV4_3(ARC,X,AUX)  ! transform C&N to r.l.u.
            DO K=1,4
              rq.QOM(K,I) = rq.QOM(K,I)+AUX(K)
            END DO          
          ENDIF
          rq.CHKQOM=rq.CHKQOM+CHKBASE*I*(rq.QOM(1,I)+rq.QOM(2,I)**2+rq.QOM(3,I)**3)
          SUMAMC(ITEM)=SUMAMC(ITEM)+rq.PQOM(I)
          rq.IQOM(I)=ITEM
29      CONTINUE
30    CONTINUE

C// set other pointers NQOM
      DO ITEM=IMAX+1,MDAT
        rq.NQOM(ITEM)=rq.NQOM(ITEM-1)
      END DO
      
C pass QOMEGA data to EXCI
      call setqomega(rq)
c      write(*,*) 'GETSQOM END: ',rq.NQOM(MDAT),rq.CHKQOM 
C return rq.CHKQOM as the result            
      GETSQOM=rq.CHKQOM
      
      
c      qom0(1)=2.5
c      qom0(3)=3.5
c      call getqomarrays(qom0) 
c      write(*,1) 'qom0: ',qom0(1:4,1)
c      write(*,1) 'rq.qom0: ',rq.qom0(1:4,1)
      
      
      END            

C---------------------------------------------------------------------
      SUBROUTINE FILLQOMARRAY(PORT,INDX,NIMX,NIMY,TM)
C Fill QOM array with QHKL,E values from all branches of EXCI model
C QHKL,E values are defined by the 2-dim array according to the PORT 
C Fill PQOM with adequate S(Q,E) values returned by EXCI. 
C (QOM,PQOM are defined in exci.inc)
C    PORT      ... defines input QHKL array
C    INDX      ... dataset index
C    NIMX,NIMY ... number of pixels
C    TM        ... The transformation matrix TM must convert Q from the PORT 
C                  coordinates to rec. lat. units
C CALLS: EXCI, INITEXCI
C CALLED BY: FILLSQ
C---------------------------------------------------------------------

      IMPLICIT NONE
      
      INCLUDE 'const.inc'      
      INCLUDE 'inout.inc'      
      INCLUDE 'rescal.inc'
      INCLUDE 'restrax.inc'
      INCLUDE 'res_grf.inc'
      INCLUDE 'exciimp.inc'      
c      RECORD /QOMEGA/ rq
      RECORD /MODEL/ rm


      INTEGER*4 NIMX,NIMY,IX,IY,J,K,I,L,M
      INTEGER*4 INDX,IDATA
      REAL*8 TM(4,4),QE(4),QE1(4),DIMX,DIMY,V6(6),W6(6)
      RECORD /VIEWSET/ PORT
      REAL*8 CHKBASE

      CALL getmodel(rm)

      if (NIMX*NIMY*rm.nbr.gt.MQOM) then
        write(smes,*) 'FILLQOMARRAY: dimension of QOM array exceeded!'
        stop      
      endif

      DO j=1,4
         rq.QOM0(j,INDX)=mf_par(i_QH-1+j,INDX) ! store Qhkl,E to share with EXCI
      END DO 

      
      rq.CHKQOM=0.D0
      CHKBASE=exp(1.D0)
1     format('filling array ',$)
2     format('.',$)
      IDATA=INDX
      IF(IDATA.LE.0.OR.IDATA.GT.mf_max) IDATA=mf_cur
      rq.NDATQOM=IDATA ! inform EXCI about current data index 
      DIMX=(PORT.WX2-PORT.WX1)/NIMX
      DIMY=(PORT.WY2-PORT.WY1)/NIMY
      IX=PORT.IX
      IY=PORT.IY
      DO J=1,3
        QE(J)=0.
      ENDDO 
      QE(4)=mf_par(I_EN,IDATA)        
      
C! Partitioning of QOM array
      rq.NQOM(1)=NIMX*NIMY 
      DO i=2,MDAT
        rq.NQOM(i)=rq.NQOM(i-1)
      END DO
      
      
C// fill Q-values in QOM array first
      DO J=1,NIMX
      DO K=1,NIMY
           QE(IX)=(J-0.5)*DIMX+PORT.WX1
           QE(IY)=(K-0.5)*DIMY+PORT.WY1              
           CALL M4XV4_3(TM,QE,QE1)
           L=K+(J-1)*NIMY
           DO M=1,3 
              rq.QOM(M,L)=QE1(M)
           ENDDO   
C! don't forget to update CHKQOM - check sum for EXCI 
           rq.CHKQOM=rq.CHKQOM+CHKBASE*L*(rq.QOM(1,L)+rq.QOM(2,L)**2+rq.QOM(3,L)**3)
           rq.IQOM(L)=IDATA   
c         write(*,*) 'FILLQOMARRAY: ',IX,IY,QE(IX),QE(IY),rq.QOM(1:3,L)
c         pause
      ENDDO
      ENDDO

C// initialize EXCI with new QOM values
      CALL setqomega(rq)
      CALL INITEXCI(0,0) ! do not call GETSQOM inside INITEXCI (arg2=0)

C// then fill OMEXC and SQOM values into SQOM(4) and PQOM 
C// use array positions above i=NIMX*NIMY to store higher branches
      write(sout,1)
      DO J=1,NIMX
           IF (MOD(J,8).EQ.0) write(sout,2)
      DO K=1,NIMY
           L=K+(J-1)*NIMY
           DO M=1,3 
             QE1(M)=rq.QOM(M,L)
           ENDDO   
           CALL EXCI(L,QE1,V6,W6)
           do i=1,rm.nbr  ! cycle through branches
             M=L+(i-1)*NIMX*NIMY
             rq.QOM(4,M)=V6(i)   
             rq.PQOM(M)=W6(i)
           end do
      ENDDO
      ENDDO
      CALL setqomega(rq)      
      write(sout,*) ' done.'
      
      END    

C------------------------------------------------------------
      REAL*4 FUNCTION HIST_LIN(X,Y,NX,NMAX,ITEM)
C// creates histogram using planar disp. surface      
C// works with data set indexed as ITEM 
C// - called by PHON command
CC added in ver. 4.77: use event sweeping technique for a3 scans
C------------------------------------------------------------
      IMPLICIT NONE
      
      INCLUDE 'const.inc'
      INCLUDE 'inout.inc'
      INCLUDE 'rescal.inc'
      INCLUDE 'restrax.inc'
      INCLUDE 'exciimp.inc'
c      RECORD /QOMEGA/ rq
            
            
      INTEGER*4 I,J,K,NH,NX(0:MDAT),ITEM,IB,IBS,NP,NPS,NMAX
      REAL*8 DUM,GNORM,OMEXC,DEN,GRAD(3),QSTEP(3),ENN     
      REAL*4 X(NMAX),Y(NMAX),AMPL,BACKG
      REAL*8 OMD(3),QQ0(3),QOM3(3),ENSTEP,ZMEAN,Z,DA3,AUX(3)
      REAL*8 QxQ
      REAL*8 GAMA(3,0:MHIS),EPS(0:MHIS),EDIST,EDIST0,FLAG,FLAG0
      REAL*8 EPS0
      REAL*4 OMD4(3)

      CALL getqomega(rq)

C/// ATTENTION ! 
C/// if X,Y<>XHIST,RHIST => SHIST, DHIST will not contain up-to-date values

      SHIST(ITEM)=0 
      DO  I=NX(ITEM-1)+1,NX(ITEM)
         Y(I) = 0
         DO J=1,6
            DHIST(J,I) = 0
         END DO
      END DO
      ZMEAN=0.

C//// copy gradient, QE-step and QHKLE for ITEM-th channel     
      DO I=1,3
         GRAD(I)=mf_par(i_GH-1+I,ITEM) 
         QSTEP(I)=mf_par(i_DQH-1+I,ITEM) 
         QQ0(I)=mf_par(i_QH-1+I,ITEM) 
      ENDDO 
      DEN=mf_par(i_DEN,ITEM)        
      ENN=mf_par(i_EN,ITEM)        
      DA3=mf_par(i_DA3,ITEM) ! get step in a3
C//// Norm of G(3) in r.l.u. 
      CALL QNORM(GRAD,GNORM,DUM)
      
      IF(GNORM.EQ.0) GOTO 99 ! no direction => no scan .... 
      
C Dispersion sheet coefficients OMD are derived from G(3) and  
C GMOD of RESCAL, they are given in Energy/r.l.u.    
      DO I=1,3
        OMD(I)=GRAD(I)*mf_par(i_GMOD,ITEM)/GNORM
      END DO
      ENSTEP=-QxQ(OMD,QSTEP)+DEN ! energy step relative to the disp. sheet
      
      IB=NX(ITEM-1)+1              ! IB is the base index for ITEM-th histogram
      
C *** Do nothing if the scan is parallel to dispersion surface
      
c      write(*,*) 'DA3 = ',DA3,' OMD = ',(OMD(I),I=1,3)
c      pause
      IF (DA3.NE.0) THEN
         IF(mf_par(i_GMOD,ITEM).EQ.0) GOTO 99
      ELSE IF (ENSTEP.EQ.0) THEN
         GOTO 99
      ENDIF   
 
      if(IB.GT.NX(ITEM)) GOTO 99   ! No space allocated for ITEM-th histogram


C *** prepare fields for A3 scan:
C gama(i,k) .. gradient of disp. after rotation by (X(k)+0.5D0)*DA3
C EPS(k)    .. scalar product gama(i,k)*QHKL(k)-(X(k)+0.5D0)*DEN 
C dispersion plane (GHKL) is rotated at each step, thus we avoid rotations for each event
      IF(DA3.NE.0) THEN
         EPS0=QxQ(OMD,QQ0) ! scalar product GRAD*QHKL, used for a3 scans
         DO I=1,3
            OMD4(I)=OMD(I) ! copy to REAL*4 array
         ENDDO
! get OMD vectors rotated to each of a3 values corresponding to bin edges
         CALL ROTA3(OMD4(1),-(X(IB)-0.5D0)*DA3,GAMA(1,0))             
         EPS(0)=EPS0-ENN
         DO I=1,3
            EPS(0)=EPS(0)+(X(j)-0.5D0)*DEN
         ENDDO   
         DO j=IB,NX(ITEM)  
            K=j-IB+1
            CALL ROTA3(OMD4(1),-(X(j)+0.5D0)*DA3,GAMA(1,k))            
            EPS(k)=EPS0-ENN
            DO I=1,3
               EPS(k)=EPS(k)+(X(j)+0.5D0)*DEN
            ENDDO   
c        write(*,1) k,-(X(k+IB-1)-0.5D0)*DA3,GAMA(1,k),GAMA(3,k),EPS(k)
         ENDDO
      ENDIF
      
C *** Accumulate histogram in differences along the SCAN direction ***
      
      do i=rq.NQOM(ITEM-1)+1,rq.NQOM(ITEM)                
        
C *** A3 scan ***
C ignore steps in QHKL and do the scan in A3 (sample rotation) ...
C => scan is non-linear in QHKL, sweeping algorithm is applied  
        IF (DA3.NE.0) THEN 
c1     format(I,6(2x,G12.6))
c2     format(6(2x,G12.6))
c       write(*,2) (QOM(j,i),j=1,4)
c       write(*,*) 'k  DA3  GH  GL  ENDIST'
           k=0 ! go to the left edge of the bins range
           DO j=1,3
              AUX(j)=rq.QOM(j,i) ! have a copy in REAL*8 array
           ENDDO 
           EDIST0=QxQ(GAMA(1,k),AUX(1))-EPS(k)-rq.QOM(4,i)
           FLAG0 = SIGN(1.D0,EDIST0)
c        write(*,1) k,-(X(IB)-0.5D0)*DA3,GAMA(1,k),GAMA(3,k),EDIST0
           DO k=1,NX(ITEM)-IB+1 ! sweep through histogram bins
              EDIST=QxQ(GAMA(1,k),AUX(1))-EPS(k)-rq.QOM(4,i)
              FLAG = SIGN(1.D0,EDIST)            
              IF(FLAG.NE.FLAG0) THEN  ! crossed disp. branch
                 ENSTEP=ABS(EDIST-EDIST0)
                 FLAG0 = FLAG
                 NH=k+IB-1
                 Y(NH) = Y(NH)+rq.PQOM(i)/ENSTEP
                 SHIST(ITEM)=SHIST(ITEM)+rq.PQOM(i)/ENSTEP
c        write(*,*) 'BIN ',NH,PQOM(i)/ENSTEP,X(NH),Y(NH)
              ENDIF
              EDIST0=EDIST
c        write(*,1) k,-(X(k+IB-1)+0.5D0)*DA3,GAMA(1,k),GAMA(3,k),EDIST
           ENDDO 
c        pause    
        ELSE                
C QHKL,E scan
C or take linear scan in QHKLE ...        
           DO K=1,3
              QOM3(K)=rq.QOM(K,I)-mf_par(i_QH-1+K,ITEM)
           END DO  
           OMEXC=QxQ(OMD,QOM3)+ENN
           Z=rq.QOM(4,I)-OMEXC
           NH = (-Z/ENSTEP+0.5-X(IB))+IB
           
           IF(NH.GE.IB.AND.NH.LE.NX(ITEM)) THEN
              Y(NH) = Y(NH)+rq.PQOM(i)/abs(ENSTEP)
              SHIST(ITEM)=SHIST(ITEM)+rq.PQOM(i)/abs(ENSTEP)
           ENDIF
        ENDIF     
      END DO

      do j=IB,NX(ITEM)
           Y(j) =Y(J)*HNORM(ITEM)/sumamc(ITEM)
      end do
C *** Linear fit is used to determine scale factor and background automatically ***
C *** only for current spectrum mf_cur

      IF(NPT(ITEM).GT.NPT(ITEM-1)) THEN
        IBS=NPT(ITEM-1)+1   ! this is base index from which data are taken
        NPS=NPT(ITEM)-NPT(ITEM-1)
        NP=NX(ITEM)-NX(ITEM-1)  ! number of points for ITEM-th histogram
        CALL LINFIT(X(IB),Y(IB),NP,SPX(IBS),SPY(IBS),SPZ(IBS),NPS,
     *              AMPL,BACKG,CHISQR)
        FPAR(1)=AMPL
        FPAR(2)=BACKG
        NFPAR=2
c        parname(1)='Scale'
c        parname(2)='Background'
      ELSE
        FPAR(1)=1
        FPAR(2)=0          
        NFPAR=0
      ENDIF    
      do j=IB,NX(ITEM)
           Y(j) = FPAR(1)*Y(j)+FPAR(2)
      end do
      
      WHATHIS=iand(WHATHIS,251) ! set bit3=0 => planar disp. was used to produce RHIST
      WHATHIS=ior(WHATHIS,1)    ! set bit1=1 => RHIST is updated
c      write(*,*) 'HISTLIN ',WHATHIS
      
      HIST_LIN=1.
      RETURN
      
99    HIST_LIN=-1.

      RETURN

      END

C------------------------------------------------------------------------------------
      REAL*4 FUNCTION HIST(X,Y,NX,NMAX,FITPAR,NP)
      
c *** Creates simulated histograms ****
C   X,Y       ...  created histograms
C   NX        ...  pointers to last point number for each data set in X,Y arrays
C                  i.e. the partitioning of the X,Y arrays. 
C   NMAX      ...  dimension of X,Y
C   FITPAR    ...  model parameters
C   NP        ...  dimension of fitpar
C X(I) are supposed to be dimensionless steps in units of real scan steps
C i.e. X(I)=-5,-4,...+4,+5 for equidistant data centered at nominal QHKL,E setting
C Added in ver. 4.77: makes scan in A3 if DA3<>0 (step in QHKLE is ignored)
C-------------------------------------------------------------------------------------
      IMPLICIT NONE

      INCLUDE 'const.inc'
      INCLUDE 'inout.inc'
      INCLUDE 'rescal.inc'
      INCLUDE 'restrax.inc'
      INCLUDE 'exciimp.inc'
c      RECORD /QOMEGA/ rq
      RECORD /MODEL/ rm
      
      INTEGER*4 NX(0:MDAT),NP,NMAX
      REAL*4 X(NMAX),Y(NMAX),fitpar(MPAR)
      REAL*8 omexc(6),omexc1(6),sqom(6),qomsc(4),FLAG0(6),FLAG(6)
      REAL*8 EDIST(6),EDIST0(6)
      INTEGER*4 I,J,K,icom,is,IB,ITEM,ITEM0
      REAL*8 DEE,DD(3),DOMEXC,DA3
10    FORMAT('.',$)
910   FORMAT('wait ...',$)


c      write(*,*) 'HIST: before getqomega'
c      pause
      CALL getqomega(rq)
      CALL getmodel(rm)
c      write(*,*) 'HIST: after getqomega'

      IF (rq.NQOM(MDAT).GT.20000) write(sout,910) 

      HIST=0.E0
C *** Pass parameters to EXCI
      do j=1,NP
        rm.param(j) = fitpar(j) 
c        write(*,*) 'HIST, rm.PARAM: ',J,rm.PARAM(J)        
      enddo
      CALL setmodel(rm)
      
C *** Clear SCAN histogram ***

      DO I=1,MDAT
        SHIST(I)=0.D0 
      ENDDO  
      DO  I=1,NX(MDAT)
         Y(I) = 0
         DO J=1,rm.nbr
            DHIST(J,I) = 0.E0
         END DO
      END DO

      ICOM = 1
      ITEM0=0
      i=0
c       write (*,*) 'START NQOM: ',IQOM(1),NX(1),mf_active(1)
      
C *** Accumulate histogram in differences along the SCAN direction ***
C START MAIN CYCLE through all events
C------------------------------------------------------------------------------
c       write (*,*) 'NQOM(MDAT): ',rq.NQOM(MDAT),rm.nbr
      DO 39 WHILE (i.LT.rq.NQOM(MDAT))
        i=i+1        
        icom = i  ! passes event number into exci
        ITEM=rq.IQOM(i)            ! ITEM is index to histogram = index of the data set
        if(ITEM.le.0) GOTO 39   ! Exit if there are no data in QOM arrays     

C* step in QHKL,E must be determined for each new histogram:
C------------------------------------------------------------------------------
        IF(ITEM0.NE.ITEM) THEN  ! next histogram begins
          if (ITEM.GT.1) write(sout,10)  
          IB=NX(ITEM-1)+1       ! IB is the base index for ITEM-th histogram        
c      write (*,*) 'NEW ITEM: ',I,ITEM,IB,NX(ITEM),mf_active(ITEM)
          if(IB.GT.NX(ITEM).OR.
     &        (.NOT.(mf_active(ITEM)).AND.ITEM.NE.mf_cur)) THEN     
C* No space has been allocated for the ITEM-th histogram or the data 
C* are not active ==> go to the next spectrum
            i=rq.NQOM(ITEM) 
c      write (*,*) 'NO SPACE: ',IB,NX(ITEM),mf_active(ITEM)
                       
            GOTO 39
          endif   
          DO j=1,3
            DD(j)=mf_par(i_DQH-1+j,ITEM) 
          END DO 
          DEE=mf_par(i_DEN,ITEM)
          DA3=mf_par(i_DA3,ITEM)
          ITEM0=ITEM
        ENDIF  
c1     format(a,I5,4(2x,G12.5))
c      if (mod(icom,1000).EQ.0) 
c      if (icom.gt.0) write (*,1) 'DE: ',ICOM,(DD(j),j=1,3),DEE

C* Start filling the ITEM-th histograms
C--------------------------------------------------------------------------------                                         
        IF (DA3.NE.0) THEN ! ignore steps in QHKL and do the scan in A3 (sample rotation)
           CALL ROTA3(rq.qom(1,i),(X(IB)-0.5D0)*DA3,qomsc(1))
           qomsc(4) = rq.qom(4,i)+(X(IB)-.5D0)*DEE 
        ELSE        
          do k=1,3
            qomsc(k) = rq.qom(k,i)+(X(IB)-.5)*DD(k)
          enddo
          qomsc(4) = rq.qom(4,i)+(X(IB)-.5)*DEE 
        ENDIF    
        
        call exci(icom,qomsc,OMEXC,SQOM)
             
c1       format('HIST, ',a,I5,6(2x,G12.5))
c        write(*,1) 'Q:   ',NX(ITEM),qomsc,qomsc(4)-omexc(1),SQOM(1)

C// Set flag0=+1/-1 if the event lies ABOVE/BELOW the dispersion surface
        do 36 J=1,rm.nbr
        EDIST0(J)=qomsc(4)-omexc(j)
36      FLAG0(J) = SIGN(1.D0,EDIST0(J))
        
        do is=IB,NX(ITEM) ! cycle through histogram bins
          IF (DA3.NE.0) THEN ! ignore steps in QHKL and do the scan in A3 (sample rotation)
             CALL ROTA3(rq.qom(1,i),(X(is)+0.5D0)*DA3,qomsc(1))
             qomsc(4) = rq.qom(4,i)+(X(is)+.5D0)*DEE 
          ELSE        
            do k=1,3
              qomsc(k) = rq.qom(k,i)+(X(is)+.5)*DD(k)
            enddo
            qomsc(4) = rq.qom(4,i)+(X(is)+.5)*DEE 
          ENDIF
c      write (*,1) 'QOM: ',IS,(rq.qom(j,i),j=1,4)
                    
          call exci(icom,qomsc,OMEXC1,SQOM)
c      write (*,1) 'Q:   ',IS,(qomsc(j),j=1,4),qomsc(4)-omexc1(1),SQOM(1)
c11      format(a,6(2x,G12.6))          
c        write(*,11) 'qomsc,EDIST,SQ: ',
c     *              (qomsc(k),k=1,4),OMEXC1(1)-qomsc(4),SQOM(1)
                   
          do j=1,rm.nbr  ! cycle through branches
            EDIST(J)=qomsc(4)-omexc1(j)
            FLAG(J) = SIGN(1.D0,EDIST(J))            
            IF((FLAG(J).NE.FLAG0(J)).and.(rm.wen(j).le.0)) THEN  ! crossed disp. branch
              DOMEXC=ABS(EDIST(J)-EDIST0(J))
              FLAG0(J) = FLAG(J)
              DHIST(j,is) = DHIST(j,is)+SQOM(j)*rq.PQOM(I)/DOMEXC
              Y(is)   = Y(is)+SQOM(J)*rq.PQOM(I)/DOMEXC
              SHIST(ITEM)=SHIST(ITEM)+rq.PQOM(I)/DOMEXC
            else if (rm.wen(j).gt.0) then            ! finite disp. width
              DHIST(j,is) = DHIST(j,is)+SQOM(j)*rq.PQOM(I)
              Y(is)   = Y(is)+SQOM(J)*rq.PQOM(I)
              SHIST(ITEM)=SHIST(ITEM)+rq.PQOM(I)
            endif
            EDIST0(J)=EDIST(J)
          end do
c      write (*,1) 'Y:   ',IS,Y(is),rq.PQOM(I),rm.wen(1)
        end do      
c      pause
39    CONTINUE
c      write (*,*) 'HIST loop passed ',SUMAMC(1)

      DO I=1,MDAT
        IF(SUMAMC(I).GT.0.AND.NX(I).GT.NX(I-1)) THEN
c      write (*,1) 'HNORM,SUMAMC:   ',I,HNORM(I)/SUMAMC(I),FITPAR(1)
          DO J=NX(I-1)+1,NX(I)
c      write (*,1) 'Y:   ',J,Y(J)
             Y(J) = FITPAR(1)*Y(J)*HNORM(I)/SUMAMC(I)+FITPAR(2)
             IHIST(J)=I  
          END DO   
        ENDIF
      END DO  
c      pause
      
      WHATHIS=ior(WHATHIS,4) ! set bit3=1 => EXCI module was used to produce RHIST
      WHATHIS=ior(WHATHIS,1) ! set bit1=1 => RHIST is updated
c      write(*,*) 'HIST ',WHATHIS
      HIST = 1.   ! return 1 if the histogram has been filled
      IF (rq.NQOM(MDAT).GT.20000) write(sout,*) 
c      write (*,*) 'HIST END, WHATHIS= ',WHATHIS

      RETURN
      END

c
C*********************************************************************************
      SUBROUTINE RESFIT(NCMAX)
C Perform data fitting with EXCI model and all loaded (and active) data sets
C Result is stored in XHIST,RHIST,NHIST arrays
C Arguments:
C NCMAX ... max. number of iteration steps
C (for NCMAX=0, calculate only current model curve and exit)
C 
C Upgraded RESFIT version (28/4/2002)
C Internal dialogs have been removed, the routine is called from 
C command handler FIT_CMD, based on LINP library (structured command-line interpreter).      
C*********************************************************************************

      IMPLICIT NONE

      INCLUDE 'const.inc'
      INCLUDE 'inout.inc'
      INCLUDE 'res_grf.inc'
      INCLUDE 'restrax.inc'
            
      REAL*4 DELTAA(MPAR),DELMIN(MPAR)
      INTEGER*4 NCMAX,NH0
      INTEGER*4 i,j,nfree,nc,maxitem,IRUN
      REAL*4 eval,flamda,chiold,coef
      REAL*4 HIST,FCHISQ
!      EXTERNAL HIST
      
800   FORMAT('CHISQR = ',G12.5)
801   FORMAT('CHISQR(I) : ',10(1x,G11.4))
906   FORMAT('NC=',I4,' CHISQR=',G12.5,' LAMBDA=',G12.5)
908   FORMAT('A(I): ',10(1x,G10.4))
909   FORMAT('Fit not finished. Reached ',I3,' iterations.')

c      write(*,*) 'call RESFIT ',NCMAX

C*   initialize EXCI
      CALL INITEXCI(0,1) ! call GETSQOM inside INITEXCI (arg2=1) 

c      write(*,*) 'call RESFIT after INITEXCI'
C  ***** CONSTANTS ******
      
      JFIT=1  ! fit is running
      MODE=1  ! Weighting by 1/SPZ**2

C* No data loaded: only fill in the model histogram
      IF (NPT(MDAT).LE.0) THEN
        if (NCMAX.GT.0) write(sout,*) 'No data to fit ...'
        CALL HISTINIT
        eval = hist(XHIST,RHIST,nhist,nhist(MDAT),fpar,nfpar)              
        jfit=0
        RETURN      
      ENDIF

C* partitioning of histograms has to be compatible with data
      DO I=1,MDAT
         NHIST(I)=NPT(I) 
         NH0=(NHIST(I)-NHIST(I-1)+1)/2
         DO J=NHIST(I-1)+1,NHIST(I)
               XHIST(J)=SPX(J)
               RHIST(J)=0
               IHIST(J)=I
         ENDDO            
         SHIST(I)=0
      END DO
      WHATHIS=iand(WHATHIS,254) ! set bit1=0 => RHIST not ready
c      write(*,*) 'RESFIT ',WHATHIS
      
C* calculate number of fitted points and number of degrees of freedom
      nfree=0
      maxitem=0
      do i=1,NPT(MDAT) 
         if (IPT(I).GT.0) nfree=nfree+1
         if (maxitem.lt.IPT(I)) maxitem=IPT(I)
      enddo
      nfree=nfree-nfpar

C If NCMAX=0, only calculate histogram and/or CHISQ and exit  
      if (NCMAX.LE.0) THEN       
        eval = hist(XHIST,RHIST,nhist,nhist(MDAT),fpar,nfpar)              
        if (nfree.GT.0) THEN
          CHISQR=FCHISQ(SPY,SPZ,IPT,NPT(MDAT),NFREE,MODE,RHIST,DCHISQ)
        else
          CHISQR=0.D0 
        endif
        JFIT=2
        RETURN
      ENDIF 
       
C* Check the number of free parameters
      if(nfree.le.0) then
         write(smes,*) 'Not enough data points !'
         return
      else
         write(sout,*) 'Starting to fit ',nfree+nfpar,' data points...' 
      endif           

C* calculate initial histograms
      eval = hist(SPX,RHIST,NPT,NPT(MDAT),FPAR,nfpar)

C* calculate initial CHISQRs
      CHISQR = FCHISQ(SPY,SPZ,IPT,NPT(MDAT),NFREE,MODE,RHIST,DCHISQ)
      WRITE(SOUT,800) CHISQR
      WRITE(SOUT,801) (DCHISQ(I),I=1,MAXITEM)

C* set initial parameter values
      DO J=1,nfpar
        FPARI(J) = FPAR(J)
      ENDDO

C* set initial values of FLAMDA, etc..
      NC = 1
      FLAMDA = FITLAM0
      CHIOLD = 1.E12
      IRUN=1
      
c ** get  minimum increments        
      COEF=0.01
      DO  I=1,nfpar
        DELMIN(I) = ABS(FPAR(I))*COEF
      ENDDO  

c      write(*,*) 'RESFIT: start fitting cycle'
C   ************   FITTING CYCLE   ************      
      GRFARG(0)=5 ! use PLOT_MDAT on plot refresh
      DO WHILE(IRUN.GT.0.AND.NC.LE.NCMAX)
C* Adjust increments for the calculation of derivatives
        COEF = MIN(FLAMDA,0.01)
        DO  I=1,nfpar
          DELTAA(I) = ABS(FPAR(I))*COEF
          IF(DELTAA(I).LT.DELMIN(I)) DELTAA(I)=DELMIN(I) ! avoid floating overflows
          DELTAA(I) =DELTAA(I)*JFIXED(I)
        ENDDO  
C* make one iteration step
        CALL CURF3T(DELTAA,FLAMDA,NFREE)
C* inform about CHISQ and FPAR values
        WRITE(SOUT,906) NC,CHISQR,FLAMDA
        WRITE(SOUT,801) (DCHISQ(I),I=1,MAXITEM)
        WRITE(SOUT,908) (FPAR(I),I=1,nfpar)
        WRITE(SOUT,*)
C* show progress, except for flat-cone mode
        IF (CFGMODE.EQ.0) call PLOTOUT 

C* stop on too small change
        IF(ABS(CHIOLD-CHISQR)/ABS(CHIOLD).GT.FITTOL) THEN
           CHIOLD = CHISQR
           IF (ABS(CHIOLD).LT.1.E-10) IRUN=0 ! just for sure, it should not happen
        ELSE
           IRUN=0
        ENDIF
        NC = NC+1
C* stop on iteration limit
        IF(NC.GT.NCMAX.AND.IRUN.NE.0) THEN
          WRITE(SOUT,909) NC
          IRUN=0       
        ENDIF
      ENDDO
      JFIT=2      !  fit finished
      
C   ************   END OF FITTING CYCLE   ************
      
c* get final histogram
      CALL HISTINIT
      eval = hist(XHIST,RHIST,nhist,nhist(MDAT),fpar,nfpar)              
      END


C*****************************************************************************
      SUBROUTINE LISTFITPAR
C list fitting parameters in the format:
C number name value [fix]      
C*****************************************************************************
      IMPLICIT NONE

      INCLUDE 'const.inc'
      INCLUDE 'inout.inc'
      INCLUDE 'exciimp.inc'
      INCLUDE 'restrax.inc'
      RECORD /MODEL/ rm
      
      INTEGER*4 I
      CHARACTER*3 fix
      CHARACTER*4 CH
      CHARACTER*5 S,CONCAT
1     FORMAT(a,' ',a10,' ',G13.5,1x,a3,1x,G13.5)
2     FORMAT(I4)
      
      call getmodel(rm)
      DO I=1,rm.NTERM
        if (rm.FIXPARAM(I).EQ.0) THEN 
          fix='fix'
        else
          fix='   '
        endif    
        S=' '
        WRITE(CH,2) I
        S=CONCAT('a',CH)        
        write(sout,1) S,rm.PARNAME(I),rm.PARAM(I),fix !,FPAR(I)
      ENDDO
      END
      

C*********************************************************************************
      SUBROUTINE SIMDATA(SUMA,NEV,ICOM)
C Simulate spectra using EXCI, as if they were read from data file(s)
C SUMA   ... total counts, if SUMA=0 then use fpar(1) as amplitude
C NEV    ... number of events for simulation
C ICOM=0 ... only generate new histogram and calculate chi^2
C*********************************************************************************

      IMPLICIT NONE

      INCLUDE 'const.inc'
      INCLUDE 'inout.inc'
      INCLUDE 'rescal.inc'
      INCLUDE 'restrax.inc'
      INCLUDE 'res_grf.inc'
            
      INTEGER*4 ICOM,i,j,ITEM,IB,NEV
      REAL*4 eval
      REAL*4 HIST,BCG,FCHISQ
      REAL*8 SUMA,Z,AMPL

      if (ICOM.EQ.0) goto 10

      DO ITEM=1,mf_max
        DO I=1,4
          QE0(I,ITEM)=mf_par(i_QH+I-1,ITEM)
          DQE0(I,ITEM)=mf_par(i_DQH+I-1,ITEM)
        ENDDO
        DO I=5,6
          DQE0(I,ITEM)=mf_par(i_DQH+I-1,ITEM)
        ENDDO  
      ENDDO  
c* run MC 
      CALL RUNMC(1,NEV)

C*   fill QOM array 
c      Z=GETSQOM(1,mf_max,1)   

C*   initialize EXCI
      CALL INITEXCI(0,1) ! call GETSQOM inside INITEXCI (arg2=1) 
                  
C* partitioning of histograms has to be compatible with data
      DO I=1,MDAT
         NHIST(I)=NPT(I) 
c         NH0=(NHIST(I)-NHIST(I-1)+1)/2
         DO J=NHIST(I-1)+1,NHIST(I)
               XHIST(J)=SPX(J)
               RHIST(J)=0.
               IHIST(J)=I
         ENDDO            
         SHIST(I)=0
      END DO

C* create histogram for scale=1 and background=0      
      AMPL=FPAR(1)
      FPAR(1)=1. ! scale=1
      BCG=FPAR(2)
      FPAR(2)=0. ! background=0
      eval = hist(SPX,RHIST,NPT,NPT(MDAT),FPAR,nfpar)
      FPAR(2)=BCG 
      
c      write(*,*) 'suma=', suma
      
      DO ITEM=1,mf_max
        IB=NPT(ITEM-1)+1      
        if (ITEM.EQ.1) THEN
          Z=0.
          DO I=IB,NPT(ITEM)
            Z=Z+RHIST(I)
          ENDDO
        ENDIF
        IF (Z.GT.0) THEN
          IF (SUMA.NE.0.D0) THEN ! set FPAR(1)=AMPL or normalize on SUM
             FPAR(1)=SUMA/Z
          ELSE
             FPAR(1)=AMPL
          ENDIF   
          DO I=IB,NPT(ITEM)
             SPY(I)=RHIST(I)*FPAR(1)+FPAR(2)
             SPZ(I)=SQRT(ABS(SPY(I))+1.)
             SPY(I)=SPY(I)+ERHIST(I)*SPZ(I)
          ENDDO 
        ELSE
          DO I=IB,NPT(ITEM)
             SPY(I)=0.
             SPZ(I)=1.
          ENDDO
        ENDIF   
      END DO
      jfit=2

c* get Chi^2      
10    eval = hist(SPX,RHIST,NPT,NPT(MDAT),FPAR,nfpar)

c      GRFARG(0)=4
c      CALL PLOTOUT

      CHISQR = FCHISQ(SPY,SPZ,IPT,NPT(MDAT),NPT(MDAT),1,RHIST,DCHISQ)
      END

      
C***********************************************************************
      REAL*4 FUNCTION OPTTAS(P)
C   returns value to be minimized when optimizing TAS configuration
C***********************************************************************
      IMPLICIT NONE

      INCLUDE 'const.inc'
      INCLUDE 'inout.inc'
      INCLUDE 'restrax.inc'
      
      REAL*8 EPS
      PARAMETER(EPS=1.D-30)
      INTEGER*4 I
      REAL*4 P(1)
      REAL*8 B,C0,C1,C2,DER2,Z
      REAL*8 SUMA
      DATA SUMA/1.D4/        
      
      IF (OPTDPAR.LE.EPS) THEN
        OPTTAS=0.
        RETURN
      ENDIF
1     format(/,a,6(2x,G10.3))
c      write(*,1) 'OPTTAS: ',P(1),RES_DAT(OPTPAR)
                
c      A=RES_DAT(OPTPAR)
      CALL RAN1SEED(10001)
      RES_DAT(OPTPAR)=P(1)
      CALL BEFORE
      DO I=1,mf_max
        mf_par(OPTPAR,I)=P(1)
      ENDDO  
      CALL SIMDATA(SUMA,OPTEV,1)
      C0=CHISQR
            
      B=FPAR(OPTFPAR)
     
      FPAR(OPTFPAR)=B+OPTDPAR
      CALL RESFIT(0)
c      CALL SIMDATA(SUMA,OPTEV,0)  
      C2=CHISQR            

      FPAR(OPTFPAR)=B-OPTDPAR
      CALL RESFIT(0)
c      CALL SIMDATA(SUMA,OPTEV,0)  
      C1=CHISQR
      
      FPAR(OPTFPAR)=B
      CALL RESFIT(0)
c      CALL SIMDATA(SUMA,OPTEV,0)  
c      C0=CHISQR
      
c      RES_DAT(OPTPAR)=A

c* 2nd derivative from chi^2 along FPAR(OPTFPAR)
      DER2=ABS(C1+C2-2*C0)/(OPTDPAR**2)
      
      IF (OPTMERIT.EQ.1) THEN ! w^2
        Z=1./SQRT(DER2)
      ELSE IF (OPTMERIT.EQ.2) THEN  ! w^2/Intensity
        Z=FPAR(1)/SQRT(DER2)/VKINESS
      ENDIF  
      
c      write(*,1) 'OPTTAS: ',P(1),Z,DER2,C0,C1,C2
c      write(*,1) 'SWITCHES: ',WHATHIS,SWRAYTR,STP.KF
      
      OPTTAS=Z

      END
        
