C//////////////////////////////////////////////////////////////////////
C////
C////  R E S T R A X   4.4
C////
C////  Subroutines for simple matrix operations:
C////
C//// 
C//////////////////////////////////////////////////////////////////////

c------------------------------------------
      SUBROUTINE INVERT(N,A,NA,B,NB)
C     Inverts matrix A (A is not destroyed)
C------------------------------------------
      IMPLICIT NONE
      INTEGER*4 N,NA,NB,NMAX
      PARAMETER(NMAX=16)
      REAL*8 A(NA,NA),B(NB,NB),A1(NMAX,NMAX),WK(2*NMAX)
      INTEGER*4 I,J
      
      DO 5 I=1,N
      DO 5 J=1,N
5        A1(I,J)=A(I,J)  
!       write(*,*) 'res_mat.f, INVERT, N,NA,NB: ',N,NA,NB
      CALL KVERTD(A1,NMAX,N,WK)
      DO 10 I=1,N
      DO 10 J=1,N
10       B(I,J)=A1(I,J)      
      RETURN
      END
C

C--------------------------------------
      SUBROUTINE REDUCE42(A,B,IX,IY,IS)
C     reduces A(4,4) to B(2,2)      
C--------------------------------------
      IMPLICIT REAL*8 (A-H,O-Z)
      REAL*8 A(4,4),B(2,2),M(4,4,4)

      DO 3 I=1,4
      DO 3 J=1,4        
        M(I,J,4)=A(I,J)
3     CONTINUE

      DO 5 L=1,4
      Z=M(1,L,4)
      M(1,L,4)=M(IX,L,4)
      M(IX,L,4)=Z
5     CONTINUE

      DO 10 L=1,4
      Z=M(2,L,4)
      M(2,L,4)=M(IY,L,4)
      M(IY,L,4)=Z
10    CONTINUE

      DO 15 L=1,4
      Z=M(L,1,4)
      M(L,1,4)=M(L,IX,4)
      M(L,IX,4)=Z
15    CONTINUE

      DO 20 L=1,4
      Z=M(L,2,4)
      M(L,2,4)=M(L,IY,4)
      M(L,IY,4)=Z
20    CONTINUE

      L=4

      IF(IS.NE.1) THEN      
        DO 30 I=4,3,-1
        DO 30 J=1,I
        DO 30 K=1,I
         M(J,K,I-1)=M(J,K,I)-M(J,I,I)*M(K,I,I)/M(I,I,I)
30      CONTINUE
        L=2
      ENDIF            

      DO 40 I=1,2
      DO 40 J=1,2
40        B(I,J)=M(I,J,L)

      RETURN
      END
          
C----------------------------------------------------------------
      REAL*8 FUNCTION GETFWHM(A,IX)
C     cuts A(4,4) at X(4)=0 and makes projection through I,J<>IX 
C     S=remaining coeficient
C     returns SQRT(1/S*8*ln(2))      
C----------------------------------------------------------------
      IMPLICIT NONE
      
      REAL*8 A(4,4),M(3,3,3),C8LN2,Z
      INTEGER*4 I,J,K,IX,L
      PARAMETER (C8LN2=5.54517744)

      DO 3 I=1,3
      DO 3 J=1,3        
        M(I,J,3)=A(I,J)
3     CONTINUE

C/// exchange rows 1 and IX
      DO 5 L=1,3
      Z=M(1,L,3)
      M(1,L,3)=M(IX,L,3)
      M(IX,L,3)=Z
5     CONTINUE

C/// exchange columns 1 and IX      
      DO 15 L=1,3
      Z=M(L,1,3)
      M(L,1,3)=M(L,IX,3)
      M(L,IX,3)=Z
15    CONTINUE
      
      DO 30 I=3,2,-1
      DO 30 J=1,I
      DO 30 K=1,I
         M(J,K,I-1)=M(J,K,I)-M(J,I,I)*M(K,I,I)/M(I,I,I)
30    CONTINUE

      GETFWHM=SQRT(C8LN2/M(1,1,1)) 
      RETURN
      END
          
C--------------------------------------------------------------------    
      SUBROUTINE STAT_INP(ND,CV,X,P)
C     accumulates covariantes matrix of vector X wit probability P      
C--------------------------------------------------------------------      

      INCLUDE 'structures.inc'
      
      RECORD /STATI/ CV
      REAL*8 P,X(CRND)
      
      CV.SUMN=CV.SUMN+P
      CV.NC=CV.NC+1
      DO 10 I=1,ND
         CV.SUM1(I)=CV.SUM1(I)+X(I)*P
         DO 10 J=1,ND
         CV.SUM2(I,J)=CV.SUM2(I,J)+X(I)*X(J)*P
10    CONTINUE
      RETURN
      END
      
C--------------------------------------    
      SUBROUTINE STAT_CLR(ND,CV)
C     cleares covariance matrix
C--------------------------------------

      INCLUDE 'structures.inc'
      
      RECORD /STATI/ CV
            
      CV.SUMN=0
      CV.NC=0
      DO 10 I=1,ND
         CV.SUM1(I)=0
         CV.DM(I)=0         
         CV.M(I)=0         
         DO J=1,ND
            CV.C(I,J)=0
            CV.SUM2(I,J)=0
         ENDDO
10    CONTINUE
      RETURN
      END         
         
      
C--------------------------------------    
      SUBROUTINE STAT_GET(ND,CV)
C     calculates covariance matrix      
C--------------------------------------      

      INCLUDE 'structures.inc'
      
      RECORD /STATI/ CV
      
      IF((CV.NC.GT.0).AND.(CV.SUMN.GT.0)) THEN     
      CV.P=CV.SUMN/CV.NC
      DO 10 I=1,ND
         CV.M(I)=CV.SUM1(I)/CV.SUMN
         DO 10 J=1,ND
         CV.C(I,J)=CV.SUM2(I,J)/CV.SUMN
10    CONTINUE
      DO 20 I=1,ND
         DO 20 J=1,ND
         CV.C(I,J)=CV.C(I,J)-CV.M(I)*CV.M(J)
20    CONTINUE      
      DO I=1,ND   
         CV.DM(I)= SQRT(CV.C(I,I)/CV.NC)
      ENDDO       
      ENDIF
      RETURN
      END 

C
C----------------------------------------
      SUBROUTINE M3XV3_M(IT,MAP,M,B,C)
C Multiply M(3,3) matrix with V(3) vector 
C Use MAP(3) mask to skip dimensions which do not need to transform      
C Use transposed M if IT<0
C----------------------------------------
      LOGICAL*4 MAP(3)
      REAL*8 M(3,3),B(3),C(3)
      DO 10 J=1,3
      IF (MAP(J)) THEN
         C(J)=0.
         IF (IT.GT.0) THEN
           DO 20 I=1,3
20         C(J)=C(J)+M(J,I)*B(I)
         ELSE
           DO 30 I=1,3
30         C(J)=C(J)+M(I,J)*B(I)
         ENDIF
      ELSE
         C(J)=B(J)
      ENDIF
10    CONTINUE      
      RETURN
      END            
C
C---------------------------------------------------------------
      SUBROUTINE M4xV4_3(M,B,C)
C Multiply submatrix (3x3) with vector (3) 
C dimensions of M,B,C = 4 (ignore the 4-th dimensions )
C---------------------------------------------------------------
      REAL*8 M(4,4),B(4),C(4)
      DO J=1,3
         C(J)=0.
         DO I=1,3
           C(J)=C(J)+M(J,I)*B(I)
	 END DO
      END DO   
      C(4)=B(4)  
      END            

C---------------------------------------------------------------
      SUBROUTINE M4xV3(M,B,C)
C Multiply submatrix (4x4) with vector (3), ignore the 4-th dimension 
C dimensions of C = 3 
C---------------------------------------------------------------
      REAL*8 M(4,4),B(3),C(3)
      DO J=1,3
         C(J)=0.
         DO I=1,3
           C(J)=C(J)+M(J,I)*B(I)
	 END DO
      END DO   
      END            

C---------------------------------------------------------------
      SUBROUTINE M3xV4(M,B,C)
C Multiply submatrix (3x3) with vector (4), ignore the 4-th dimension 
C dimensions of C = 4 
C---------------------------------------------------------------
      REAL*8 M(3,3),B(4),C(4)
      DO J=1,3
         C(J)=0.
         DO I=1,3
           C(J)=C(J)+M(J,I)*B(I)
	 END DO
      END DO   
      C(4)=B(4)  
      END            

C---------------------------------------------------------------
      SUBROUTINE M3xV3(M,B,C)
C Multiply matrix (3x3) with vector (3)
C dimensions of M,B,C = 3
C---------------------------------------------------------------
      REAL*8 M(3,3),B(3),C(3)
      DO J=1,3
         C(J)=0.
         DO I=1,3
           C(J)=C(J)+M(J,I)*B(I)
	 END DO
      END DO   
      END            

C---------------------------------------------------------------
      SUBROUTINE M4xV4(M,B,C)
C Multiply matrix (4x4) with vector (4)
C dimensions of C = 4
C---------------------------------------------------------------
      REAL*8 M(4,4),B(4),C(4)
      DO J=1,4
         C(J)=0.
         DO I=1,4
           C(J)=C(J)+M(J,I)*B(I)
	 END DO
      END DO   
      END            

C----------------------------------
      SUBROUTINE MXV(IT,N,NP,A,B,C)
C Multiply matrix (NxN) with vector (N)
C dimensions of A,B,C = NP
C if IT<0, then use A transposed
C----------------------------------
      REAL*8 A(NP,NP),B(NP),C(NP)
      DO 10 J=1,N
         C(J)=0.
         IF (IT.GT.0) THEN
           DO 20 I=1,N
20         C(J)=C(J)+A(J,I)*B(I)
         ELSE
           DO 30 I=1,N
30         C(J)=C(J)+A(I,J)*B(I)
         ENDIF
10    CONTINUE      
      RETURN
      END 
      
C----------------------------------
      SUBROUTINE MXM(IT,N,NP,A,B,C)
C Multiply matrix (NxN) with matrix (NxN)
C dimensions of A,B,C = NP
C if IT<0, then use A transposed
C----------------------------------
      REAL*8 A(NP,NP),B(NP,NP),C(NP,NP)
      DO 10 J=1,N
      DO 10 K=1,N     
         C(J,K)=0.
         IF (IT.GT.0) THEN
           DO 20 I=1,N
20         C(J,K)=C(J,K)+A(J,I)*B(I,K)
         ELSE
           DO 30 I=1,N
30         C(J,K)=C(J,K)+A(I,J)*B(I,K)
         ENDIF
10    CONTINUE         
      RETURN
      END       

          
C-----------------------------------
      SUBROUTINE M3XM3(IT,A,B,C)
C Multiply matrix (3x3) with matrix (3x3)
C dimensions of C = 3
C if IT<0, then use A transposed
C-----------------------------------
      REAL*8 A(3,3),B(3,3),C(3,3)
      DO 10 J=1,3
      DO 10 K=1,3     
         C(J,K)=0.
         IF (IT.GT.0) THEN
           DO 20 I=1,3
20         C(J,K)=C(J,K)+A(J,I)*B(I,K)
         ELSE
           DO 30 I=1,3
30         C(J,K)=C(J,K)+A(I,J)*B(I,K)
         ENDIF
10    CONTINUE         
      RETURN
      END       
	
C------------------------------------
      SUBROUTINE M4XM4(IT,A,B,C)
C Multiply matrix (4x4) with matrix (4x4)
C dimensions of C = 4
C if IT<0, then use A transposed
C------------------------------------
      REAL*8 A(4,4),B(4,4),C(4,4)
      DO 10 J=1,4
      DO 10 K=1,4     
         C(J,K)=0.
         IF (IT.GT.0) THEN
           DO 20 I=1,4
20         C(J,K)=C(J,K)+A(J,I)*B(I,K)
         ELSE
           DO 30 I=1,4
30         C(J,K)=C(J,K)+A(I,J)*B(I,K)
         ENDIF
10    CONTINUE         
      RETURN
      END     
        
C----------------------------------------------
      SUBROUTINE M4XM4_3(A,B,C)
C multiplies submatrix (3,3) of matrices (4x4), the rest is delta(i,j)     
C----------------------------------------------
      REAL*8 A(4,4),B(4,4),C(4,4)
      DO  J=1,3
         C(J,4)=0.
	 C(4,J)=0. 
      DO  K=1,3     
         C(J,K)=0.
         DO I=1,3
           C(J,K)=C(J,K)+A(J,I)*B(I,K)
	 END DO
      END DO   
      END DO
      C(4,4)=1.
          
      END
      
C----------------------------------------------
      SUBROUTINE BTAB4(A,B,C)
C Computes the matrix product BT*A*B, dim=4
C Assumes B(4,i)=delta(4,i) etc...
C----------------------------------------------
      IMPLICIT NONE
      
      INTEGER*4 I,J,K,L
      REAL*8 A(4,4),B(4,4),C(4,4) 
      DO 5 I=1,4
      DO 5 J=1,4
         C(I,J)=0.
         DO 5 K=1,4 
         DO 5 L=1,4
         C(I,J)=C(I,J)+B(K,I)*A(K,L)*B(L,J)
5     CONTINUE
      END
       
C----------------------------------------------
      SUBROUTINE BTAB(A,B,N1,N2,C)
C Computes the matrix product BT*A*B
C----------------------------------------------
      IMPLICIT NONE
      
      INTEGER*4 I,J,K,L,N1,N2
      REAL*8 A(N1,N1),B(N1,N2),C(N2,N2) 
      DO 5 I=1,N2
      DO 5 J=1,N2
         C(I,J)=0.
         DO 5 K=1,N1 
         DO 5 L=1,N1
         C(I,J)=C(I,J)+B(K,I)*A(K,L)*B(L,J)
5     CONTINUE
      END

C----------------------------------------------
      SUBROUTINE BABT(A,B,N1,N2,C)
C Computes the matrix product B*A*BT
C----------------------------------------------
      IMPLICIT NONE
      
      INTEGER*4 I,J,K,L,N1,N2
      REAL*8 A(N1,N1),B(N2,N1),C(N2,N2) 
      DO 5 I=1,N2
      DO 5 J=1,N2
         C(I,J)=0.
         DO 5 K=1,N1 
         DO 5 L=1,N1
         C(I,J)=C(I,J)+B(I,K)*A(K,L)*B(J,L)
5     CONTINUE
      END




C     ------------------------------
      SUBROUTINE V3AV3(IT,A,B,C)
C     ------------------------------
      REAL*8 A(3),B(3),C(3)
 
      DO 10 I=1,3
10      C(I)=A(I)+IT*B(I)
      RETURN
      END 
      
C     ------------------------------
      REAL*8 FUNCTION ABSV3(A)
C     ------------------------------
      REAL*8 A(3)  
      ABSV3=SQRT(V3XV3(A,A))
      RETURN
      END       
      

         
C     ------------------------------
      REAL*8 FUNCTION V3XV3(A,B)
C     ------------------------------
      REAL*8 A(3),B(3),Z
      Z=0
      DO 10 I=1,3
10      Z=Z+A(I)*B(I)
      V3XV3=Z
      RETURN
      END  
 
C     ------------------------------
      SUBROUTINE GENROT(IAX,PHI,AUX)
C     ------------------------------
      REAL*8 PHI,CO,SI,AUX(3,3)
            
      SI=SIN(PHI)
      CO=SQRT(1-SI**2)               
      DO 20 I=1,3
      DO 20 J=1,3
      IF(I.EQ.J) THEN
         IF (I.EQ.IAX) THEN 
            AUX(I,J)=1.
         ELSE
            AUX(I,J)=CO
         ENDIF       
      ELSE
         IF((I.EQ.IAX).OR.(J.EQ.IAX)) THEN
           AUX(I,J)=0.
         ELSE IF (I.GT.J) THEN
           AUX(I,J)=SI
         ELSE
           AUX(I,J)=-SI
         ENDIF    
      ENDIF
20    CONTINUE
      RETURN
      END       


c**************************************************************
c
      SUBROUTINE SUM(X,Y,N,Z)
      implicit REAL*8 (a-h,o-z) 
      REAL*8 X(N,N),Y(N,N),Z(N,N)
      DO 2 I=1,N
      DO 2 J=1,N
    2 Z(I,J)=X(I,J)+Y(I,J)
      RETURN
      END 
C
c**************************************************************

c
      REAL*8 FUNCTION DETERM(B,N,A)
      implicit REAL*8 (a-h,o-z)
      PARAMETER(ZERO=1.D-20)
C     COMPUTES THE DETERMINANT OF THE MATRIX B
      REAL*8 A(N,N),B(N,N) 
      DIA=1.D0
      DO 55 I=1,N
      DIA=DIA*ABS(B(I,I))
      DO 55 J=1,N 
   55 A(I,J)=B(I,J) 
      N1=N-1
      DETERM=1.D0 
      DO 1 I=1,N1 
      J1=I
      K1=I
      DO 10 J2=I,N
      DO 10 K2=I,N
      IF(ABS(A(J1,K1)).GE.ABS(A(J2,K2)))GO TO 10
      J1=J2 
      K1=K2
10    CONTINUE
      IF(ABS(A(J1,K1)).GT.ZERO*DIA)GO TO 11
c      write(*,*) 'Bug... ',A(J1,K1),DIA
      DETERM=0. 
      RETURN
11    CONTINUE
      IF(J1.EQ.I)GO TO 12 
      DO 5 K=I,N
      X=A(I,K)
      A(I,K)=A(J1,K)
5     A(J1,K)=-X
12    IF(K1.EQ.I)GO TO 13 
      DO 6 J=1,N
      X=A(J,I)
      A(J,I)=A(J,K1)
6     A(J,K1)=-X
13    I1=I+1
      DO 30 J=I1,N 
      IF(A(J,I).EQ.0.D0) GO TO 30
      X=A(J,I)/A(I,I) 
      DO 7 K=I,N
7     A(J,K)=A(J,K)-X*A(I,K)
30    CONTINUE
1     DETERM=DETERM*A(I,I)
      DETERM=DETERM*A(N,N)
c      write(*,*) 'Ready... ',DETERM
      RETURN
      END 
C	 	 
C
C
	SUBROUTINE DIAG(A,ADA,B)
C***********************************************************************
C   diagonalizes matrix A(4,4), B(4,4) is corresponding rotation matrix
C***********************************************************************
	IMPLICIT REAL*8 (A-H,O-Z)
	DIMENSION A(16),ADA(16),B(16),ARMAX(16),JRMAX(16)
	DATA N,ND,E/4,4,1.E-24/
	NDN=ND*N
	DO 1 K=1,NDN
	ADA(K)=A(K)
	B(K)=0.
    1	CONTINUE
	DO 2 K=1,N
	KK=K*(ND+1)-ND
	ARMAX(K)=0.
	B(KK)=1.
	DO 3 L=K,N
	IF(L-K)4,3,4
    4	KL=K+ND*(L-1)
	Y=ABS(ADA(KL))
	IF(ARMAX(K)-Y)5,3,3
    5	ARMAX(K)=Y
	JRMAX(K)=L
    3	CONTINUE
    2	CONTINUE
   11	AMAX=0.
	DO 6 K=1,N
	Y=ABS(ARMAX(K))
	IF(AMAX-Y)7,6,6
    7	AMAX=Y
	I=K
    6	CONTINUE
	J=JRMAX(I)
	IF(E-AMAX)8,9,9
    8	NDI=ND*(I-1)
	NDJ=ND*(J-1)
	II=I+NDI
	JJ=J+NDJ
	IJ=I+NDJ
	JI=J+NDI
	AII=ADA(II)
	AJJ=ADA(JJ)
	AIJ=ADA(IJ)
	Y=2.*AIJ
	X=AII-AJJ
	T=DSIGN(1.D0,X)*Y/(ABS(X)+SQRT(X**2+Y**2))
	TSQ=T**2
	C=1./SQRT(ABS(1.+TSQ))
	TY=T*Y
	S=T*C
	CSQ=C**2
	ADA(II)=CSQ*(AII+TY+AJJ*TSQ)
	ADA(JJ)=CSQ*(AJJ-TY+AII*TSQ)
	ADA(IJ)=0.
	ADA(JI)=0.
	DO 10 K=1,N
	JTES=(K-I)*(K-J)
	NDK=ND*(K-1)
	KI=K+NDI
	KJ=K+NDJ
	IF(JTES)13,12,13
   13	JK=J+NDK
	IK=I+NDK
	ADA(KI)=C*ADA(IK)+S*ADA(JK)
	ADA(KJ)=-S*ADA(IK)+C*ADA(JK)
	ADA(JK)=ADA(KJ)
	ADA(IK)=ADA(KI)
   12	X=B(KI)
	B(KI)=C*X+S*B(KJ)
	B(KJ)=-S*X+C*B(KJ)
   10	CONTINUE
	ARMAX(I)=0.
	DO 14 K=1,N
	IF(K-I)15,14,15
   15	IK=I+ND*(K-1)
	Y=ABS(ADA(IK))
	IF(ARMAX(I)-Y)16,14,14
   16	ARMAX(I)=Y
	JRMAX(I)=K
   14	CONTINUE
	ARMAX(J)=0.
	DO 17 K=1,N
	IF(K-J)18,17,18
   18	JK=J+ND*(K-1)
	Y=ABS(ADA(JK))
	IF(ARMAX(J)-Y)19,17,17
   19	ARMAX(J)=Y
	JRMAX(J)=K
   17	CONTINUE
	DO 20 K=1,N
	ITES=(K-I)*(K-J)
	KI=K+NDI
	KJ=K+NDJ
	IF(ITES)21,20,21
   21	X=ABS(ADA(KI))
	Y=ABS(ADA(KJ))
	JR=J
	IF(X-Y)22,22,23
   23	Y=X
	JR=I
   22	IF(ARMAX(K)-Y)24,20,20
   24	ARMAX(K)=Y
	JRMAX(K)=JR

   20	CONTINUE
	GOTO 11
9	CONTINUE
	RETURN
	END

C-----------------------------------------------------------------    
      SUBROUTINE LINFIT(X,Y,N,DX,DY,DZ,ND,AMP,BCG,CHISQ)
C     Linear fit of the function (X,Y,N) to the data (DX,DY,DZ,ND)
C     Y = AMP*DY + BCG   
C----------------------------------------------------------------- 
      REAL*4 X(N),Y(N),DX(ND),DY(ND),DZ(ND)
      
      C1=0
      C2=0
      C3=0
      C4=0
      C5=0
      C6=0
      KK=0
      DDX=X(2)-X(1)
      DO I=1,ND
        Z=(DX(I)-X(1))/DDX
        IF(Z.GE.0) THEN
           K=INT(Z)+1
        ELSE
           K=INT(Z)
        ENDIF      
        IF((K.GT.0).AND.(K.LT.N)) THEN      
           KK=KK+1
           YY=Y(K)+(Y(K+1)-Y(K))*(DX(I)-X(K))/DDX  ! linear interpolation  
           SIG2=DZ(I)**2
           IF(SIG2.EQ.0) SIG2=1.
           W=1/SIG2

           C1=C1+DY(I)*W
           C2=C2+YY*W
           C3=C3+W
           C4=C4+DY(I)*YY*W
           C5=C5+YY*YY*W
           C6=C6+DY(I)*DY(I)*W
        ENDIF            
      END DO
      IF(KK.GT.0) THEN
         IF((C2*C2-C3*C5).EQ.0) THEN
            AMP=0
            BCG=0
            CHISQ=C6
         ELSE         
            AMP= (C1*C2-C3*C4)/(C2*C2-C3*C5)
            BCG=(C4*C2-C5*C1)/(C2*C2-C3*C5)
            CHISQ=(AMP**2)*C5+(BCG**2)*C3+C6+2*AMP*BCG*C2-2*AMP*C4-
     1         2*BCG*C1
            CHISQ=CHISQ/KK
         ENDIF   
      ELSE
         AMP=0.
         BCG=0.
         CHISQ=0.
      ENDIF
      RETURN
      END
                  
      
C-----------------------------------------------------------------    
      REAL*8 FUNCTION CHI2(X,Y,N,DX,DY,DZ,ND)
C     Returns Chi^2 for data DY and function Y
C----------------------------------------------------------------- 
      REAL*4 X(N),Y(N),DX(ND),DY(ND),DZ(ND)
      
      C4=0
      C5=0
      C6=0
      KK=0
      DDX=X(2)-X(1)
      DO I=1,ND
        Z=(DX(I)-X(1))/DDX
        IF(Z.GE.0) THEN
           K=INT(Z)+1
        ELSE
           K=INT(Z)
        ENDIF      
        IF((K.GT.0).AND.(K.LT.N)) THEN      
           KK=KK+1
           YY=Y(K)+(Y(K+1)-Y(K))*(DX(I)-X(K))/DDX  ! linear interpolation  
           SIG2=DZ(I)**2
           IF(SIG2.EQ.0) SIG2=1.
           W=1/SIG2
           C4=C4+DY(I)*YY*W
           C5=C5+YY*YY*W
           C6=C6+DY(I)*DY(I)*W
        ENDIF            
      END DO
      IF(KK.GT.0) THEN
         CHI2=(c6+c5-2*C4)/KK
      ELSE
         CHI2=0.
      ENDIF
      RETURN
      END
      
C------------------------------------------------
      REAL*8 FUNCTION ROUNDSCALE(X,ILIM,SC,NSC)
C  round number X to get scale limit
C  ILIM>0 ... upper limit
C  ILIM<0 ... lower limit
C  SC(NSC) contains limits (e.g. 2,4,6,8)
C------------------------------------------------
      IMPLICIT NONE
      
      INTEGER*4 NSC
      REAL*8 X,SC(NSC)
      INTEGER*4 ILIM,I,INC
      REAL*8 Z,D,EX,B

10    format('ROUNDSCALE ',a,4(1x,G10.4))      
c      write(*,10) 'X',X     
      Z=ABS(X)
      IF (Z.EQ.0) THEN
          ROUNDSCALE=0
          RETURN
      ENDIF
      EX=INT(LOG10(Z))
      IF (Z.LT.1) EX=EX-1
      
      B=10
      D=10**EX
c      write(*,10) 'D',D           
      
      IF (ILIM*SIGN(1.D0,X).GT.0) THEN
        I=1
        INC=1
      ELSE
        I=NSC
        INC=-1
      ENDIF    
      DO WHILE (I.GT.0.AND.I.LE.NSC.AND.B.EQ.10) 
c        WRITE(*,10) 'Z/D: ',Z/D,SC(I)
        IF ((Z/D-SC(I))*INC.LT.0.D0) B=SC(I)
        I=I+INC
      ENDDO  
c      WRITE(*,10) 'result=',SIGN(1.D0,X)*B*D
      ROUNDSCALE=SIGN(1.D0,X)*B*D
      
      END      
      
      
      
      
C------------------------------------------------
      SUBROUTINE KVERTD(V,LV,N,W)
C invert matrix, from http://www.netlib.org/napack
C rewritten from KVERT to real*8 by J.S.
C------------------------------------------------

C      ________________________________________________________
C     |                                                        |
C     |     INVERT A GENERAL MATRIX WITH COMPLETE PIVOTING     |
C     |                                                        |
C     |    INPUT:                                              |
C     |                                                        |
C     |         V     --ARRAY CONTAINING MATRIX                |
C     |                                                        |
C     |         LV    --LEADING (ROW) DIMENSION OF ARRAY V     |
C     |                                                        |
C     |         N     --DIMENSION OF MATRIX STORED IN ARRAY V  |
C     |                                                        |
C     |         W     --WORK ARRAY WITH AT LEAST 2N ELEMENTS   |
C     |                                                        |
C     |    OUTPUT:                                             |
C     |                                                        |
C     |         V     --INVERSE                                |
C     |                                                        |
C     |    BUILTIN FUNCTIONS: ABS                              |
C     |________________________________________________________|
C
      IMPLICIT NONE
      INTEGER*4 LV,N,H,I,J,K,L,M,O,P,Q
c      REAL*8 V(LV,1),W(1),S,T
      REAL*8 V(LV,N),W(2*N),S,T
      
      ! KVERTD(A1,NMAX,N,WK)
      
      IF ( N .EQ. 1 ) GOTO 120
      O = N + 1
      L = 0
      M = 1
10    IF ( L .EQ. N ) GOTO 90
      K = L
      L = M
      M = M + 1
C     ---------------------------------------
C     |*** FIND PIVOT AND START ROW SWAP ***|
C     ---------------------------------------
      P = L
      Q = L
      S = ABS(V(L,L))
      DO 20 H = L,N
           DO 20 I = L,N
                T = ABS(V(I,H))
                IF ( T .LE. S ) GOTO 20
                P = I
                Q = H
                S = T
20    CONTINUE
      W(N+L) = P
      W(O-L) = Q
      DO 30 I = 1,N
           T = V(I,L)
           V(I,L) = V(I,Q)
30         V(I,Q) = T
      S = V(P,L)
      V(P,L) = V(L,L)
      IF ( S .EQ. 0. ) GOTO 130
C     -----------------------------
C     |*** COMPUTE MULTIPLIERS ***|
C     -----------------------------
      V(L,L) = -1.
      S = 1./S
      DO 40 I = 1,N
40         V(I,L) = -S*V(I,L)
      J = L
50    J = J + 1
      IF ( J .GT. N ) J = 1
      IF ( J .EQ. L ) GOTO 10
      T = V(P,J)
      V(P,J) = V(L,J)
      V(L,J) = T
      IF ( T .EQ. 0. ) GOTO 50
C     ------------------------------
C     |*** ELIMINATE BY COLUMNS ***|
C     ------------------------------
      IF ( K .EQ. 0 ) GOTO 70
      DO 60 I = 1,K
60         V(I,J) = V(I,J) + T*V(I,L)
70    V(L,J) = S*T
      IF ( M .GT. N ) GOTO 50
      DO 80 I = M,N
80         V(I,J) = V(I,J) + T*V(I,L)
      GOTO 50
C     -----------------------
C     |*** PIVOT COLUMNS ***|
C     -----------------------
90    L = W(K+N)
      DO 100 I = 1,N
           T = V(I,L)
           V(I,L) = V(I,K)
100        V(I,K) = T
      K = K - 1
      IF ( K .GT. 0 ) GOTO 90
C     --------------------
C     |*** PIVOT ROWS ***|
C     --------------------
      DO 110 J = 1,N
           DO 110 I = 2,N
                P = W(I)
                H = O - I
                T = V(P,J)
                V(P,J) = V(H,J)
                V(H,J) = T
110   CONTINUE
      RETURN
120   IF ( V(1,1) .EQ. 0. ) GOTO 130
      V(1,1) = 1./V(1,1)
      RETURN
130   WRITE(6,*) 'MATRIX HAS NO INVERSE'
      STOP
      END
     


            
              
                           
                           
