C//////////////////////////////////////////////////////////////////////
C////  $Id: res_mc.f,v 1.2 2005/07/16 16:46:06 saroun Exp $
C////
C////  R E S T R A X   4.4
C////
C////  Monte Carlo 4D-integration routines
C////
C////  * SUBROUTINE MCRES1(ICOM)
C////  * SUBROUTINE MCPROFIL
C////  * FUNCTION GASDEV1(IDUM,centre,limits)
C////  * FUNCTION GASDEV(IDUM)
C////  * FUNCTION RAN1(IDUM)
C////  
C//////////////////////////////////////////////////////////////////////




C *** GASDEV with limits ***
      REAL*4 FUNCTION GASDEV1(centre,limits)
C ******************************************      
      IMPLICIT NONE  
      REAL*4  GASDEV
      REAL*4 limits,centre,Z      
      Z=2.*limits
      DO 10 WHILE (ABS(Z).GT.ABS(limits))
10       Z=GASDEV()
      GASDEV1=Z+centre    
      RETURN
      END

C *** Generation of Gaussian deviates by GASDEV from Numerical Recipes ***
      REAL*4 FUNCTION GASDEV()
C ************************************      
      IMPLICIT NONE  
      INTEGER*4 ISET
      REAL*4  GSET,V1,V2,FAC,R
      REAL*4  RAN1 
      SAVE ISET,GSET
      DATA ISET/0/
      IF (ISET.EQ.0) THEN
1       V1=2.*RAN1()-1.
        V2=2.*RAN1()-1.
        R=V1**2+V2**2
        IF(R.GE.1.)GO TO 1
        FAC=SQRT(-2.*LOG(R)/R)
        GSET=V1*FAC
        GASDEV=V2*FAC
        ISET=1
      ELSE
        GASDEV=GSET
        ISET=0
      ENDIF
      RETURN
      END
C
C
C ************************************      
      SUBROUTINE RAN1SEED(IDUM)
C Initialize random number generator
C ************************************      
      IMPLICIT NONE        
      INTEGER*4 IDUM
      REAL*4 DUM,Z
      REAL*4 RAN1NR,RAND,SECNDS
      INTEGER*4 ISEED,IRND
      COMMON /RNDGEN/ ISEED,IRND

C Generate ISEED from the system time on the first call 
      IF (IDUM.EQ.0)  then
         Z=SECNDS(0.0)
         ISEED=2*INT(10000.+Z)+1
      ENDIF
C If argument<>0, use it as a new seed
      IF (IDUM.NE.0) ISEED=ABS(IDUM)  
c      write(*,*) 'SEED = ',ISEED,' ',IRND
C Initialize required generator      
      IF (IRND.EQ.0) call sgrnd(iseed)  ! Mersenne Twister 
      IF (IRND.EQ.1) DUM=RAN1NR(-iseed) ! Numerical Recipes RAN1  
      IF (IRND.EQ.2) DUM=RAND(iseed)     ! System generator
      END


C *****************************************************************      
      REAL*4 FUNCTION RAN1()
C Call random number generator
C generate uniform random numbers in the interval [1e-6..1-1e-6]
C *****************************************************************       
      IMPLICIT NONE        
      REAL*4 EPS,EPS1,Z
      REAL*4 RAN1NR,RAND
      REAL*8 GRND
      INTEGER*4 ISEED,IRND
      PARAMETER(EPS=1E-6,EPS1=1-1E-6)
      COMMON /RNDGEN/ ISEED,IRND

10    IF (IRND.EQ.0) THEN ! Mersenne Twister 
        Z=GRND()
      ELSE IF (IRND.EQ.1) THEN  ! Numerical Recipes RAN1 
        Z=RAN1NR(ISEED)
      ELSE IF (IRND.EQ.2) THEN ! System generator
        Z=RAND(ISEED)
      ENDIF
      
c      write(*,*) ISEED,' ',Z
c      pause
      IF (Z.LT.EPS) GOTO 10
      IF (Z.GT.EPS1) GOTO 10
      RAN1=Z
      END


C **************************************************************     
C *** Random number generator from Numerical Recipes (RAN1): ***
C **************************************************************     
C
      REAL*4 FUNCTION RAN1NR(IDUM)
      implicit real*4 (a-h,o-z)         
      implicit integer*4 (i-n)         
      
      INTEGER*4 M1,M2,M3,IA1,IA2,IA3,IC1,IC2,IC3,IX1,IX2,IX3,J
      INTEGER*4 INI,ISEED,IRND 
      REAL*4 R(97)
      PARAMETER (M1=259200,IA1=7141,IC1=54773,RM1=3.8580247E-6)
      PARAMETER (M2=134456,IA2=8121,IC2=28411,RM2=7.4373773E-6)
      PARAMETER (M3=243000,IA3=4561,IC3=51349)
      COMMON /RNDGEN/ ISEED,IRND
      SAVE IX1,IX2,IX3,R      
      DATA INI/0/      
      
      IF (IDUM.LT.0.OR.INI.EQ.0) THEN
	ISEED=IDUM
        INI=-1
        IX1=MOD(IC1-ISEED,M1)
        IX1=MOD(IA1*IX1+IC1,M1)
        IX2=MOD(IX1,M2)
        IX1=MOD(IA1*IX1+IC1,M1)
        IX3=MOD(IX1,M3)
        DO 11 J=1,97
          IX1=MOD(IA1*IX1+IC1,M1)
          IX2=MOD(IA2*IX2+IC2,M2)
          R(J)=(FLOAT(IX1)+FLOAT(IX2)*RM2)*RM1
11      CONTINUE
        ISEED=1
      ENDIF
12    IX1=MOD(IA1*IX1+IC1,M1)
      IX2=MOD(IA2*IX2+IC2,M2)
      IX3=MOD(IA3*IX3+IC3,M3)

      J=1+(97*IX3)/M3
      IF(J.GT.97.OR.J.LT.1) THEN
        write(*,*) 'RAN1 error:'
        WRITE(*,*) J, 'IX = ',IX1, IX2, IX3, 'ISEED = ', ISEED
        PAUSE
      END IF 
      RAN1NR=R(J)
      R(J)=(FLOAT(IX1)+FLOAT(IX2)*RM2)*RM1
      RETURN
      END
C
C *******************************************     
C *** Test Random number covariances
C *******************************************      


      SUBROUTINE RAN1TEST(N,NEV)
      implicit none
      real*4 RAN1,SECNDS
      integer*4 i,j,N,NEV,M,nc,NMAX,IM,JM
      real*4 C(128,128),V(128),MEAN(128),RW,C0,MAX,DISP,S,S2,Z,T1,T2
      real*4 W,W2,Z0
      M=N
      if (M.LT.2) M=2
      if (M.GT.128) M=128
      DO i=1,M
        MEAN(i)=0
        DO j=1,M
          C(I,J)=0
        ENDDO  
      ENDDO  
      NMAX=NEV/M
      DO nc=1,NMAX
         DO I=1,M
   	    V(I)=RAN1()-0.5
	 END DO
         DO I=1,M
	 MEAN(I)=MEAN(I)+V(I)
	 DO J=1,M
	    C(I,J)=C(I,J)+V(I)*V(J)   
	 END DO
	 END DO
      END DO
1     format(E8.2,' ',$)        
      MAX=0.
      write(*,*)
      write(*,*) 'Covariances:'
      DO I=1,M
      DO J=1,M
         C0=MEAN(I)*MEAN(J)/NMAX/NMAX
         if (I.EQ.J) C0=C0+1./12
         write(*,1) (C(I,J)/NMAX-C0)*12.
	 if(ABS(C(I,J)/NMAX-C0).GT.MAX) THEN
	    MAX=ABS(C(I,J)/NMAX-C0)
	    IM=I
	    JM=J
	 endif   
      END DO
      write(*,*)
      END DO
      write(*,*)
      write(*,*) 'Mean:'
      DO I=1,M
        write(*,1) MEAN(I)/NMAX
      END DO
      write(*,*)
      S=0
      S2=0
      W=0
      W2=0
      T1=SECNDS(0.0)
      DO I=1,10000
        RW=0.
        Z0=0.                
        DO J=1,10000
          Z=RAN1()-0.5        
       	  IF (Z.GT.0) THEN
             RW=RW+1. 
          ELSE
             RW=RW-1.
          ENDIF
          Z0=Z0+Z
        ENDDO
        S=S+RW
        S2=S2+RW**2
        W=W+Z0/10000
        W2=W2+(Z0/10000)**2
      ENDDO       
      T2=SECNDS(0.0)
      DISP=W2/10000-(W/10000)**2
      write(*,*)
4     format('Variance of mean value: ',G12.6)
      write(*,4) SQRT(DISP)/SQRT(1./12/(10000-1))
2     format('Variance of discrete random walk : ',G12.6)
      write(*,2) (S2/10000-(S/10000)**2)/10000
3     format('Speed: ',G12.5,'/msec')
      write(*,3) 1.e8/(T2-T1)/1000
      END
      
      
      
      
      
      
