C  $Id: res_mfit.f,v 1.2 2005/07/16 16:46:06 saroun Exp $


C------------------------------------------------------------------------
      SUBROUTINE MFIT_SET(INDX)
C   Set fileds from INDX-th item of /MFIT/ fields as the current setting
C------------------------------------------------------------------------
      IMPLICIT NONE
      
      INCLUDE 'const.inc'
      INCLUDE 'inout.inc'
      INCLUDE 'restrax.inc'
      INCLUDE 'rescal.inc'
      INCLUDE 'trax.inc'

      INTEGER*4 INDX,I,J
     
      IF (INDX.LE.0.OR.INDX.GT.mf_max) RETURN
      
      DO I=1,4         
         DO J=1,4
           ATRAX(I,J)=mf_A(I,J,INDX)
           ANESS(I,J)=mf_AMC(I,J,INDX)
           MCR(I,J)=mf_MCR(I,J,INDX)
           MRC(I,J)=mf_MRC(I,J,INDX)
         ENDDO  
         AMEAN(I)=mf_AMEAN(I,INDX)
      END DO
      DO I=1,RES_NVAR 
        RES_DAT(I)=mf_par(I,INDX)
      ENDDO
      DATNAME=mf_name(INDX)
      RELTRAX=RELTR(INDX)
      RELNESS=RELMC(INDX)
      VOLCKI=mf_VKI(INDX)
      VOLCKF=mf_VKF(INDX)
      VKINESS=mf_MVKI(INDX)
      VKFNESS=mf_MVKF(INDX)
      IF(DATNAME.NE.' ') RESCAL_NAME=' '
      CALL SPEC_SET(mf_device(1,INDX),mf_setup(1,INDX))
      CFGMODE=mf_CFGMODE(INDX) 
      checkSUM=mf_chksum(INDX)
      isCHANGED=mf_changed(INDX)
      mf_cur=INDX     
      
      END

C-------------------------------------------------------------------
      SUBROUTINE MFIT_GET(INDX)
C   make mf_*(INDX) fileds equivalent to the current setting       
C   Get also mf_chksum and mf_done fields by calculation  
C equivalent to MFIT_SYNC in this version
C-------------------------------------------------------------------
      IMPLICIT NONE
      
      INCLUDE 'const.inc'
      INCLUDE 'inout.inc'
      INCLUDE 'restrax.inc'

      INTEGER*4 INDX
      
!      IF (INDX.LE.0.OR.INDX.GT.MDAT) RETURN      
      CALL MFIT_SYNC(INDX)
!      CALL SPEC_GETCHK(mf_chksum(INDX))    
            
      END  

C-------------------------------------------------------------------
      SUBROUTINE MFIT_SYNC(INDX)
C   copy current setup parameters to the INDX-th item fields     
C-------------------------------------------------------------------
      IMPLICIT NONE
      
      INCLUDE 'const.inc'
      INCLUDE 'inout.inc'
      INCLUDE 'restrax.inc'
      INCLUDE 'rescal.inc'
      INCLUDE 'trax.inc'

      INTEGER*4 INDX,I,J
      
      IF (INDX.LE.0.OR.INDX.GT.MDAT) RETURN
      DO I=1,4         
         DO J=1,4
           mf_A(I,J,INDX)=ATRAX(I,J)
           mf_AMC(I,J,INDX)=ANESS(I,J)
           mf_MCR(I,J,INDX)=MCR(I,J)
           mf_MRC(I,J,INDX)=MRC(I,J)
         END DO  
         mf_AMEAN(I,INDX)=AMEAN(I)
      END DO
      DO I=1,RES_NVAR
        mf_par(I,INDX)=RES_DAT(I)
      END DO
      mf_name(INDX)=DATNAME
      RELTR(INDX)=RELTRAX
      RELMC(INDX)=RELNESS
      mf_VKI(INDX)=VOLCKI
      mf_VKF(INDX)=VOLCKF
      mf_MVKI(INDX)=VKINESS
      mf_MVKF(INDX)=VKFNESS
      mf_CFGMODE(INDX)=CFGMODE
      mf_chksum(INDX)=checkSUM
      mf_changed(INDX)=isCHANGED
      CALL SPEC_GET(mf_device(1,INDX),mf_setup(1,INDX)) 
            
      END  


C--------------------------------------------------------
      SUBROUTINE MFIT_LIST
C--------------------------------------------------------
      IMPLICIT NONE
      
      INCLUDE 'const.inc'
      INCLUDE 'inout.inc'
      INCLUDE 'rescal.inc'
      INCLUDE 'restrax.inc'
      
      INTEGER*4 I,J,I1,I2
      CHARACTER*4 ARROW
      CHARACTER*3 MC
      CHARACTER*1 mark
      
      
100   FORMAT(a3,'[',I2,']',a1,4x,a3,4x,I3,2x ,
     *       ' [',F6.3,2(1x,F6.3,1x),F6.3,']  ',a)
101   FORMAT(a3,'[',I2,']',a1,2x,'no data')
102   FORMAT(' DATA   | MC valid | NP |',14x,'QE',14x'| filename ')  
      write(sout,102)
      DO I=1,mf_max
        IF(I.EQ.mf_cur) then
           ARROW='-->'
        ELSE
           ARROW='   '
        ENDIF      
        IF(mf_active(I)) then
           mark='*'
        ELSE
           mark=' '
        ENDIF
        IF (mf_done(I).AND.(.NOT.mf_changed(I))) THEN
          MC='Yes'
        ELSE
          MC='No'
        ENDIF       
                      
        IF (mf_loaded(I)) then 
           CALL BOUNDS(mf_name(I),I1,I2)    
           write(sout,100) arrow,I,mark,MC,NPT(I)-NPT(I-1),
     *          (QE0(J,I),J=1,4),mf_name(I)(I1:I1+I2-1) 
        ELSE
!           write(sout,101) arrow,I,mark
           write(sout,100) arrow,I,mark,MC,NPT(I)-NPT(I-1),
     *          (mf_par(i_QH+J-1,I),J=1,4),'no data' 
        ENDIF
      ENDDO
      END 
      
C------------------------------------------------------------------- 
      SUBROUTINE ADDDATA(LINE,NPAR,ISTART,ISIL)          
C Load a range of data starting at the ISTART-th position. 
C Input:
C LINE ... string describing data filename or data range (see below)
C NPAR ... number of parameters (= space separated strings) on LINE
C ISTART ... 1st position on data list to be used 
C ISIL  ... silence level (0..3) , influences the information output about data 
C 
C Range is passed through the LINE string as:
C 1) comma-separated minimum and maximum number (numbers=filenames)
C 2) space-separated list of strings (strings=filenames)
C 3) if LINE=' ', then one data set is loaded, program asks for a filename 
C----------------------------------------------------------------------       
      IMPLICIT NONE
      
      INCLUDE 'const.inc'
      INCLUDE 'inout.inc'
      INCLUDE 'restrax.inc'
      CHARACTER*(*) LINE
      INTEGER*4 NPAR,ISTART,ISIL
      CHARACTER*60 NAME
      LOGICAL*4 addnew,READMORE,CREATE
      INTEGER*4 I,J,cur0,IS,IL,IX,SIL,N1,N2,ID,NREAD,IRES
                 
c1     FORMAT(I)                 
3     FORMAT(a) 
c201   FORMAT('range: item: ',I3,' read: ',I3,' data: ',a20) 
c202   FORMAT('list item: ',I3,' of ,'I3,' read: ',I3,' data: ',a60) 
      
      
      SIL=SILENT
      SILENT=ISIL ! silent mode for adding data
      NREAD=0 ! clear counter of newly read data
      cur0=mf_cur ! backup current data index
      CREATE=.FALSE. ! if true then data is not read, but created from the current set
      
C interpret command line parameters:
      N1=0
      N2=0   
      IS=1   
      CALL FINDPAR(LINE,1,IS,IL)
      IX=INDEX(LINE(IS:IS+IL-1),',') ! check for comma-separated list      
      IF (IX.GT.0) THEN ! try range of numbers, separated by comma, e.g. 20056,20071
        READ(LINE(IS:IS+IX-2),*,ERR=100) N1
        READ(LINE(IS+IX:IS+IL-1),*,ERR=100) N2
        IF (N1.GT.N2.OR.N1.LE.0) GOTO 100 ! not a valid range of data numbers
        IF (NPAR.GT.1) THEN ! try to read second parameter
          IS=1
          CALL FINDPAR(LINE,2,IS,IL)
          IF (IL.GT.0.AND.LINE(IS:IS).EQ.'c') CREATE=.TRUE.
        ENDIF
      ENDIF  

C decide where to put new data:
      addnew=(ISTART.gt.mf_max)           
      if (addnew) THEN ! start above the allocated range, add new data
         mf_max=mf_max+1
         ID=mf_max
         mf_cur=ID
         mf_done(ID)=.false.
      else IF (ISTART.LE.0.OR.ISTART.EQ.mf_cur) THEN
         ID=mf_cur ! start at mf_cur      
      else 
         CALL mfit_set(ISTART) ! start at an item ISTART, update current RESTRAX fields
         ID=ISTART
      endif
      
      
      I=N1-1 ! integer=data filename
      J=1
      READMORE=.TRUE.
      DO WHILE (READMORE)
         IF (N2.GT.0.AND.I.LT.N2) THEN   ! take next data filename as integer      
             I=I+1
             WRITE(NAME,*) I
             CALL BOUNDS(NAME,IS,IL)
             IF (CREATE) NAME='channel'//NAME(IS:IS+IL-1)
         ELSE IF (J.LE.NPAR) THEN  ! take name from a list of filenames separated by spaces
             IS=1
             CALL FINDPAR(LINE,J,IS,IL) 
             NAME=LINE(IS:IS+IL-1)
             J=J+1
         ELSE
             NAME=' '    ! prompt for filename
         ENDIF 
c         write(*,*) 'ADDDATA: ',NAME
	 
         CALL OPENFILE(NAME,IRES) ! read data to mf_cur
         IF(IRES.GT.0) THEN 
            NREAD=NREAD+1
            ID=ID+1
         ELSE
c//            write(*,*) 'Cannot open: ',IRES,NAME
            CALL mfit_set(cur0) ! load back the former data set if open not successful
            if (addnew) mf_max=mf_max-1
         ENDIF
         READMORE=(IRES.NE.1.AND.     ! not a RESCAL file
     &             ID.lt.MDAT.AND.    ! doesn't exceed array dimensions
     &             NAME.NE.' '.AND.   ! didn't get the name interactively
     &             I.LT.N2.AND.J.LE.NPAR) ! didn't reach the end of given range
         IF (READMORE) THEN
           cur0=mf_cur
           addnew=(ID.gt.mf_max)           
           if (addnew) THEN
             mf_max=mf_max+1
             mf_cur=ID
             mf_done(ID)=.false.
           else
             IF (ID.NE.mf_cur) CALL mfit_set(ID)   
           endif
         ENDIF  
      ENDDO
      
100   SILENT=SIL
      RETURN   
      END      
          
C--------------------------------------------------------
      SUBROUTINE DELDATA(NMIN,NMAX)
C delete all data sets between NMIN and NMAX (incl.)      
C--------------------------------------------------------
      IMPLICIT NONE
      
      INCLUDE 'const.inc'
      INCLUDE 'restrax.inc'
      
      INTEGER*4 I,K,NP,NMIN,NMAX,N1,N2
      
      N1=NMIN
      N2=NMAX
      IF(N2.GT.mf_max) N2=mf_max
      IF(N1.LT.1) N1=1
      
      IF (N2.LT.N1.OR.N2.LT.1.OR.N1.GT.mf_max) RETURN
!      IF (N1.LE.1.AND.N2.GE.mf_max) RETURN ! can't delete all data
      
      NP=NPT(N2)-NPT(N1-1)  ! number of items to be deleted
      DO K=NPT(N1-1)+1,NPT(mf_max)-NP ! shift data above N2 by NP down
           SPX(K)=SPX(K+NP) 
           SPY(K)=SPY(K+NP) 
           SPZ(K)=SPZ(K+NP) 
           IPT(K)=IPT(K+NP)
      ENDDO 
      DO I=N1,mf_max-N2+N1-1  ! copy fields above ITEM to the position below the deleted range
        NPT(I)=NPT(I+1+N2-N1)-NP ! ... and decrease number-of-points values NP
        mf_loaded(I)=mf_loaded(I+1+N2-N1)
        mf_active(I)=mf_active(I+1+N2-N1)        
        mf_done(I)=mf_done(I+1+N2-N1)        
        DO K=1,4
          QE0(K,I)=QE0(K,I+1+N2-N1)
          dQE0(K,I)=dQE0(K,I+1+N2-N1)
        ENDDO  
        DO K=5,6
          dQE0(K,I)=dQE0(K,I+1+N2-N1)
        ENDDO  
        CALL mfit_set(I+1+N2-N1)
        CALL mfit_get(I)
        mf_cur=I
      ENDDO
      DO I=mf_max-N2+N1,MDAT  ! there are no data at and above mf_max
         NPT(I)=NPT(I-1)
         mf_loaded(I)=.false.
         mf_active(I)=.false.     
         mf_done(I)=.false.
         mf_changed(I)=.true.
         mf_chksum(I)=0        
      ENDDO
      mf_max=mf_max-1-N2+N1  ! update mf_max
      if (mf_max.LE.0) mf_max=1
      if (mf_cur.gt.mf_max) then  ! update mf_cur if necessary (should never happen!)
         mf_cur=mf_max
         CALL mfit_set(mf_cur)
      endif   
      CALL KSTACK_FREERANGE(N1,N2) ! free allocated memory for MC events
      END     
           
      
C--------------------------------------------------------------------------------- 
      INTEGER*4 FUNCTION GETIDENT()
C Search in the data sets for any one identical with the current settings
C Start with the current data set and test, whether it has been changed
C Then try the other ones.
C If such data set is found and MC has been run for it, return the data set index, 
C otherwise return 0
C---------------------------------------------------------------------------------       
      IMPLICIT NONE
      
      INCLUDE 'const.inc'
      INCLUDE 'inout.inc'
      INCLUDE 'restrax.inc'
      
      INTEGER*4 I
      LOGICAL*4 LOG1
1     FORMAT('Setup ',I3,' is identical to ',I3)            
      
      LOG1=.FALSE.          
      GETIDENT=0   ! no identical setup found
     
C* check first for the current data      
      LOG1=mf_done(mf_cur)                 ! Are there MC events already accumulated ?
c      IF (LOG1) CALL SPEC_UNCHANGED(LOG1)  ! Has the setup not changed since last MC tracing ?
      LOG1=(LOG1.AND.(.NOT.mf_changed(mf_cur)))  
      IF (LOG1) THEN                       ! => the current setup is up to date, no MC tracing is needed
          GETIDENT=mf_cur
          RETURN
      ENDIF
      I=0
C* try to find an equivalent setup with MC tracing already done     
      DO WHILE ((.NOT.LOG1).AND.(I.LT.mf_max)) 
        I=I+1
        IF (I.NE.mf_cur) THEN   ! skip the current setup
c      write(*,*) 'ID: ',I,' done: ',mf_done(I),' mod: ',mf_changed(I) 
          IF(mf_chksum(I).EQ.checkSUM) THEN      ! Do the check sums agree ?
            CALL SPEC_COMPARE(mf_device(1,I),mf_setup(1,I),LOG1) ! Are I and mf_cur identical ?
            LOG1=(LOG1.AND.mf_done(I).AND.(.NOT.mf_changed(I)))  ! Is I up to date ?
c	    if (LOG1) write(smes,1) I,mf_cur ! => you can just copy I to mf_cur, no MC tracing is needed
          ELSE
c      write(*,*) 'CHKSUM: ',I,mf_chksum(I),checkSUM
          ENDIF  
        ENDIF
      ENDDO
      IF (LOG1) GETIDENT=I   

      END      
      
      
