C//////////////////////////////////////////////////////////////////////
C////  $Id: res_opt.f,v 1.4 2006/05/10 14:36:26 saroun Exp $
C////
C////  R E S T R A X   (c) J. Saroun, J. Kulda, 1995-2005
C////
C////  Subroutines for TAS optimization
C////
C//////////////////////////////////////////////////////////////////////


C**************************************************************
      SUBROUTINE GETDERIV1(A,DELTA,FUNCTN,DER1,DER2)
C     1st and 2nd derivative for 1 parameter
C**************************************************************
      IMPLICIT NONE

      REAL*8 AJ,Y1,Y2,Y0,DER1,DER2
      REAL*4 A(1),DELTA
      REAL*4 FUNCTN
      external functn
      DER1=0
      DER2=0
      IF(DELTA.NE.0) THEN
         AJ = A(1)
10       A(1) = AJ+DELTA
         Y1 = functn(A(1))
         A(1) = AJ-DELTA
         Y2 = functn(A(1))
         IF(ABS(Y1+Y2).GT.1D-10.AND.ABS((Y1-Y2)/(Y1+Y2)).GT.0.4) THEN
            DELTA=DELTA/2.
            GOTO 10
         ENDIF
         A(1) = AJ            
         Y0 = functn(A(1))
         DER1=(Y1-Y2)/2/DELTA
         DER2=(Y1+Y2-2*Y0)/DELTA/DELTA
      ENDIF           
      END

C**************************************************************
      REAL*8 FUNCTION GETDERIV(IDER,J,K,A,DELTAA,N,FUNCTN)
C get derivatives of FUNCTN
c IDER=1,2 for 1st,2nd derivative
C J,K indexes of A(N) array pointing to the dependent variables
C DELTAA(N) ... increments for numerical calculation of derivatives
C**************************************************************
      IMPLICIT NONE

      INTEGER*4 IDER,J,K,N
      REAL*8 AJ,AK,Y1,Y2,Y0,W1,W2,DELTA,DELTB
      REAL*4 A(N),DELTAA(N)
      REAL*4 FUNCTN
      external functn

      IF (IDER.EQ.0) THEN
        GETDERIV=functn(A)
      ELSE IF (IDER.EQ.1) THEN
        IF(DELTAA(J).NE.0) THEN
          AJ = A(J)
10        DELTA = DELTAA(J)
          A(J) = AJ+DELTA
          Y1 = functn(A)
          A(J) = AJ-DELTA
          Y2 = functn(A)
          IF(ABS(Y1+Y2).GT.1D-10.AND.ABS((Y1-Y2)/(Y1+Y2)).GT.0.4) THEN
            DELTAA(J)=DELTAA(J)/2.
            GOTO 10
          ENDIF
          GETDERIV=(Y1-Y2)/2/DELTA
          A(J)=AJ          
        ELSE
          GETDERIV=0      
        ENDIF
      ELSE IF (IDER.EQ.2) THEN
        IF(DELTAA(J).NE.0.AND.DELTAA(K).NE.0) THEN
         AJ = A(J)
         AK = A(K)
         DELTA = DELTAA(J)
         DELTB = DELTAA(K)
         IF (J.EQ.K) THEN
           A(J) = AJ+DELTA
           Y1 = functn(A)
           A(J) = AJ-DELTA
           Y2 = functn(A)
           A(J) = AJ            
           Y0 = functn(A)
           GETDERIV=(Y1+Y2-2*Y0)/DELTA/DELTA
         ELSE
           A(K) = AK+DELTB
           A(J) = AJ+DELTA
           Y1 = functn(A)
           A(J) = AJ-DELTA
           Y2 = functn(A)
           W1=(Y1-Y2)/2/DELTA
           A(K) = AK-DELTB
           A(J) = AJ+DELTA
           Y1 = functn(A)
           A(J) = AJ-DELTA
           Y2 = functn(A)
           W2=(Y1-Y2)/2/DELTA
           GETDERIV=(W1-W2)/2/DELTB
         ENDIF
         A(K) = AK
         A(J) = AJ
        ELSE
         GETDERIV=0
        ENDIF 
      ENDIF     
      
C
      RETURN
      END
C
C------------------------------------------------------------
      SUBROUTINE LMOPT(FUNCTN,A,AMI,AMA,NP,TOL,ISIL)
C  find minimum of FUNCTN function by Levenberg-Marquardt algorithm
C------------------------------------------------------------
      IMPLICIT NONE
      
      INCLUDE 'const.inc'
      
      INTEGER*4 MAXIT,J,K,NP,INS(MPAR),IT,IERR,ISIL
      REAL*4 TOL,FLAMDA
      REAL*8 ARRAY(MPAR,MPAR),ALPHA(MPAR,MPAR),BETA(MPAR),AN(MPAR,MPAR)           
      REAL*4 A(NP),AMI(NP),AMA(NP),B(MPAR),DELTAA(MPAR)
      REAL*4 CHISQR,CHISQ1,DB,KSI
      REAL*8 GETDERIV
      REAL*4 FUNCTN
      COMMON /ERROR/IERR
      external functn
1     format('CHISQR: ',G12.5,2x,'PAR: ',6(G12.5,2x))
2     format('x',$)

C/// initializations
      IERR=0
      IT=0      ! iter. counter
      MAXIT=100 ! max. 100 iterations
      DO J=1,NP
        DELTAA(J)=ABS(A(J)*TOL) ! derive increments from TOL
      ENDDO  
      FLAMDA=0.1

C/// Get initial Chi^2
      CHISQR = FUNCTN(A)

C/// Start main cycle      
41    CHISQ1 = CHISQR  

      IF (ISIL.LE.0) write(*,1) CHISQR,(A(J),J=1,MIN(NP,6))
 
C/// Calculate derivatives: 
      IF(NP.EQ.1) THEN       
        CALL GETDERIV1(A(1),DELTAA(1),FUNCTN,BETA(1),ALPHA(1,1))
      ELSE
        DO J=1,NP
            BETA(J)=GETDERIV(1,J,J,A,DELTAA,NP,FUNCTN)
            DO K=1,J
              ALPHA(J,K)=GETDERIV(2,J,K,A,DELTAA,NP,FUNCTN)
            END DO
        END DO
      ENDIF  

C/// symetrize ALPHA
      DO J=1,NP
        DO K=1,J
          ALPHA(K,J) = ALPHA(J,K)
        END DO
      END DO

C/// check zeros on digonal
      DO  J=1,NP
          INS(J) = 0
          IF(ABS(ALPHA(J,J)).LT.1.E-19) INS(J)=1
      END DO

C/// create Hessian matrix
71    DO J=1,NP
        DO K=1,NP
          IF((INS(J)+INS(K)).EQ.0) THEN
            AN(J,K)=SQRT(ABS(ALPHA(J,J))*ABS(ALPHA(K,K)))
            ARRAY(J,K) = ALPHA(J,K)/AN(J,K)
          ELSE
            AN(J,K)=1.D0
            ARRAY(J,K) = 0.D0
          ENDIF
        END DO 
        ARRAY(J,J) = 1.D0+FLAMDA
      END DO
      
C/// invert Hessian matrix
      CALL INVERT(NP,ARRAY,MPAR,ARRAY,MPAR)

C/// increment with limits checking
      KSI=1.0 
10    DO J=1,NP
        DB = 0.0
        DO K=1,NP
          IF((INS(J)+INS(K)).EQ.0) THEN
            DB=DB-KSI*BETA(K)*ARRAY(J,K)/AN(J,K)
          ENDIF
        END DO
        IF (A(J)+DB.GT.AMA(J).OR.A(J)+DB.LT.AMI(J)) THEN
          KSI=KSI/2.0
c      write(*,1) KSI,A(J),A(J)+DB
          GOTO 10
        ENDIF  
        B(J)=A(J)+DB       
      END DO
      
C// get new CHISQR            
      CHISQR = FUNCTN(B)  

C// check stop conditions
      IF(CHISQR.LT.1E-20) GOTO 110 ! exact match ... speed-up linear fit
      IF ((CHISQ1-CHISQR).LE.0.D0) THEN 
        FLAMDA = 5.*FLAMDA
        IF(FLAMDA.LE.1000.) THEN ! try again with larger FLAMDA
           GOTO 71
        ELSE
           IERR=-1
           GOTO 111  ! exit if FLAMBDA is too large
        ENDIF      
      ENDIF

C//  accept new values and continue 
110   DO J=1,NP
         A(J) = B(J)
      END DO
      FLAMDA = FLAMDA/5.
      IT=IT+1

111   IF (CHISQR.LT.1E-20) IERR=1 ! exit on exact match
      IF (ABS(ABS(CHISQ1/CHISQR)-1.).LT.0.01) IERR=2 ! exit on < 1/100 change
      IF (IT.GE.MAXIT) IERR=-2 ! exit on maximum iteration number

      IF (IERR.EQ.0) GOTO 41

      END

C--------------------------------------------------------------------------------
C $Log: res_opt.f,v $
C Revision 1.4  2006/05/10 14:36:26  saroun
C Added ISIL argument to control printed output (ISIL=1 ... silent)
C
C Revision 1.3  2005/07/19 20:38:08  saroun
C *** empty log message ***
C
C Revision 1.2  2005/07/16 16:46:06  saroun
C Improved TAS optimization (LMOPT, OPINSTR, ...)
C Added limits of free parameters in LMOPT, etc
C Added demo with optimization in ./demo/opt
C

