C//////////////////////////////////////////////////////////////////////
C////
C////  R E S T R A X 
C////
C////  RESTRAX: Some subroutines for I/O operations
C////
C//////////////////////////////////////////////////////////////////////

C--------------------------------------------------------
      SUBROUTINE CHECKRESFILE(FNAME,FPATH,ISIL,IRES,FRES)
C Test existence of a file 
C INPUT:
C   fname  ... filename
C   fpath  ... colon delimited list of search directories
C   isil   ... silence level, if isil>0 => no message
C RETURN:
C   fres   ... resulting filename (incl. path)
C   IRES>0 ... ord. number of the path string from fpath
C   IRES=0 ... not found   
C--------------------------------------------------------      
      IMPLICIT NONE    
      INCLUDE 'const.inc'
      INCLUDE 'inout.inc'
      CHARACTER*(*) FNAME,FPATH,FRES
      INTEGER *4 IRES,ISIL
      INTEGER*4 IS,IL,ISF,ILF,LL,LRES,J,IP
      LOGICAL*4 LOG1
      CHARACTER*128 FFN
3     FORMAT(' File not found : ',a) 
5     FORMAT(' File "',a,'" found at "',a,'"')   
c11    FORMAT(' CHECKRESFILE: ',I4,' <',a,'>')

      CALL BOUNDS(FNAME,ISF,ILF)
c     write(*,11) ILF,TRIM(FNAME)
      LRES=LEN(FRES)
      LOG1=.FALSE.
      IL=1
      FFN=' '
      J=1
      IP=0
c            if (j.gt.is) write(*,11) IL,trim(fpath)
      DO WHILE (.NOT.LOG1.AND.IL.GE.0)
        IP=IP+1
        CALL FINDSTRPAR(fpath,':',IP,IS,IL)
c        write(*,*) 'CHECKRESFILE: after FINDSTRPAR', IP,IS,IL
        IF (IL.GE.0) THEN
          j=is+il-1
c        write(*,*) 'before path selection: ',IL,j
          IF (IL.LE.0) THEN
c        write(*,*) 'IL<=0: ',ISF,ILF,fname(ISF:ISF+ILF-1)
            FFN=fname(ISF:ISF+ILF-1)
            LL=ILF
          ELSE IF (J.GT.0.AND.fpath(j:j).NE.PATHDEL)  THEN 
c       write(*,*) 'IL>0 && path != PATHDEL: ',is,j
            FFN=fpath(is:j)//PATHDEL//fname(ISF:ISF+ILF-1)
            LL=j-is+2+ILF        
          ELSE
c      write(*,*) 'IL>0: ',is,j
            FFN=fpath(is:j)//fname(ISF:ISF+ILF-1)
            LL=j-is+1+ILF          
          ENDIF
        
        
c          IF (IL.GT.0.AND.J.GT.0.AND.fpath(j:j).NE.PATHDEL) THEN
c          write(*,*) 'IL>0 && path != PATHDEL: ',is,j
c            FFN=fpath(is:j)//PATHDEL//fname(ISF:ISF+ILF-1)
c            LL=j-is+2+ILF
c          ELSE IF (IL.GT.0) THEN
c          write(*,*) 'IL>0: ',is,j
c            FFN=fpath(is:j)//fname(ISF:ISF+ILF-1)
c            LL=j-is+1+ILF
c          ELSE
c          write(*,*) 'IL<=0: ',ISF,ILF,fname(ISF:ISF+ILF-1)
c            FFN=fname(ISF:ISF+ILF-1)
c            LL=ILF
c          ENDIF
c      write(*,11) IP,TRIM(FFN)
          INQUIRE(FILE=FFN,EXIST=LOG1)
        ENDIF
      ENDDO
      IF (LL.GT.LRES) LL=LRES      
      FRES=FFN(1:LL)
c     write(*,11) IP,FRES(1:LEN_TRIM(FRES))
      IF (LOG1) THEN
         IRES=IP
         if (isil.le.0) write(smes,5) fname(ISF:ISF+ILF-1),fpath(is:j)
      ELSE
         IRES=-1         
         if (isil.le.0) WRITE(SMES,3) fname(ISF:ISF+ILF-1)
      ENDIF
      END

      
C-------------------------------------------------------------------------
      SUBROUTINE OPENRESFILE(FNAME,FEXT,IUNIT,IRD,ISIL,FRES,IERR)
C Open file for input in RESTRAX, searching in following directories:
C current:DATPATH:RESPATH:CFGPATH
C INPUT:
C fname ... filename
C fext  ... default extension
C iuit  ... file unit number
C ird   ... force user input if ird>0, even if fname is not empty
C isil   ... silence level (no message if isil>0)
C OUTPUT:
C ierr  ... <>0 if cannot open file
C FRES  ... resulting filename without path
C-------------------------------------------------------------------------      
      IMPLICIT NONE    
      INCLUDE 'const.inc'
      INCLUDE 'inout.inc'
      
      CHARACTER*(*) FNAME,FEXT,FRES
      INTEGER*4 IUNIT,IRD,ISIL,IERR
      INTEGER*4 IRES,IS,IL,IS1,IL1,IS2,IL2,IS3,IL3
      CHARACTER*256 FPATH,FN,FFN
      CHARACTER*16 FE
c1     FORMAT(' OPENRESFILE: ',I4,' <',a,'>')
      IERR=-1
      CALL BOUNDS(FNAME,IS,IL)
      CALL BOUNDS(RESPATH,IS1,IL1)
      CALL BOUNDS(CFGPATH,IS2,IL2)
      CALL BOUNDS(DATPATH,IS3,IL3)
      fpath=':'//DATPATH(IS3:IS3+IL3-1)//':'//RESPATH(IS1:IS1+IL1-1)//
     &      ':'//CFGPATH(IS2:IS2+IL2-1)
      CALL DLG_FILEOPEN(fname(IS:IS+IL-1),fpath,FEXT,IRD,1,ires,ffn)
      IF (ires.gt.0) THEN
c       write(*,1) ires,ffn(1:LEN_TRIM(ffn))
        CALL FNSPLIT(FFN,PATHDEL,FPATH,FN,FE)
        CALL BOUNDS(FN,IS1,IL1)
        CALL BOUNDS(FE,IS2,IL2)
        IF (IL1.GT.0.AND.IL2.GT.0) THEN
           FRES=FN(IS1:IS1+IL1-1)//FE(IS2:IS2+IL2-1)
        ELSE IF (IL1.GT.0) THEN
           FRES=FN(IS1:IS1+IL1-1)
        ELSE
           FRES=' '
        ENDIF
        CALL OPENINPFILE(FFN,IUNIT,ISIL,IERR)
      ENDIF
      END

C-------------------------------------------------------------------------
      SUBROUTINE OPENINPFILE(FNAME,IUNIT,ISIL,IERR)
C Open file FNAME for input 
C INPUT:
C fname ... full filename (incl. path)
C iuit  ... file unit number
C isil   ... silence level (no message if isil>0)
C OUTPUT:
C ierr  ... <>0 if cannot open file
C FRES  ... resulting filename without path
C-------------------------------------------------------------------------      
      IMPLICIT NONE    
      INCLUDE 'const.inc'
      INCLUDE 'inout.inc'
      
      CHARACTER*(*) FNAME
      INTEGER*4 IUNIT,Ierr,ISIL
      INTEGER*4 IS,IL,IS1,IL1,IS2,IL2
      CHARACTER*256 FPATH,FN,FRES
      CHARACTER*32 FE
      
      CALL BOUNDS(FNAME,IS,IL)      

200   FORMAT(' Open file "',a,'"') 
201   FORMAT(' unexpected error in OPENINPFILE: "',a,'"') 
      OPEN(UNIT=IUNIT,FILE=FNAME(IS:IS+IL-1),STATUS='OLD',
     *       ERR=10,IOSTAT=IERR)
      
      IF(ISIL.LE.0) THEN
        CALL FNSPLIT(FNAME(IS:IS+IL-1),PATHDEL,FPATH,FN,FE)
        CALL BOUNDS(FN,IS1,IL1)
        CALL BOUNDS(FE,IS2,IL2)
        IF (IL1.GT.0.AND.IL2.GT.0) THEN
           FRES=FN(IS1:IS1+IL1-1)//FE(IS2:IS2+IL2-1)
           IF (ISIL.LE.0) WRITE(SOUT,200) FRES(IS1:IS1+IL1+IL2-1)
        ELSE IF (IL1.GT.0) THEN
           FRES=FN(IS1:IS1+IL1-1)
           IF (ISIL.LE.0) WRITE(SOUT,200) FRES(IS1:IS1+IL1-1)
        ELSE
           WRITE(SMES,201) fname(IS:IS+IL-1)
        ENDIF
      ENDIF 
10    RETURN      
      END


C-------------------------------------------------------------------------
      SUBROUTINE OPENOUTFILE(FNAME,IUNIT,IERR)
C Open file FNAME for output 
C INPUT:
C fname ... full filename
C iuit  ... file unit number
C OUTPUT:
C ierr  ... <>0 if cannot open file
C-------------------------------------------------------------------------      
      IMPLICIT NONE          
      CHARACTER*(*) FNAME
      INTEGER*4 IUNIT,Ierr
      IERR=-1
      Open(Unit=iunit,File=fname,err=10,IOSTAT=IERR,Status='Unknown')      
10    RETURN      
      END


C-------------------------------------------
      SUBROUTINE READ_RESCAL(IU,IERR)
C Read RESCAL parameters from unit IU (assume RESCAL format)
C IERR=2 ... error while reading file
C-------------------------------------------      
      IMPLICIT NONE    
      INCLUDE 'const.inc'
      INCLUDE 'inout.inc'
      INCLUDE 'restrax.inc'
      INCLUDE 'rescal.inc'
      
      INTEGER*4 IU,IERR
      CHARACTER*30 LINE
      INTEGER*4 I
      REAL*8 VER
102   FORMAT('Error ',I5,' in RESCAL file, line=',I5)
1      FORMAT(a)

      IERR=0
      I=1
      READ(IU,1,ERR=98,END=98,IOSTAT=IERR) LINE
      CALL READ_R8('version',LINE,VER,IERR)
      IF(IERR.EQ.0.AND.VER.GE.4.77) THEN    ! new version  
         DO I=1,RES_NVAR
	    READ(IU,*,ERR=98,END=98,IOSTAT=IERR) RES_DAT(I)
         ENDDO           
      ELSE   ! old version, skip da3  
         READ(LINE,*,ERR=98,END=98,IOSTAT=IERR)  RES_DAT(1)
         DO I=2,i_DA3-1
	    READ(IU,*,ERR=98,END=98,IOSTAT=IERR) RES_DAT(I)
         ENDDO 
         RES_DAT(i_DA3)=0.
         RES_DAT(i_DA4)=0.
         DO I=i_DA4+1,RES_NVAR
	    READ(IU,*,ERR=98,END=98,IOSTAT=IERR) RES_DAT(I)
         ENDDO 
      ENDIF            
      
97    IERR=0
      RETURN
      
98    IERR=2
      if (SILENT.LE.1) write(smes,102) IERR,I
      END


C---------------------------------------------------------------------------------
      SUBROUTINE OPENFILE(SARG,IRES)
C Procedure for loading an ILL data file or RESCAL parameters into "mf_cur" data set
C 1) Try loading RESCAL file (*.res) (ires=1 on success)
C 2) Try ILL data file (ires=2 on success)
C ires=0 if failed
C Added fo debug:  
c filename starting with "channel" causes just creating spectrum data 
c (with zero intensities), ires=3      
C---------------------------------------------------------------------------------
      IMPLICIT NONE
      INCLUDE 'const.inc'
      INCLUDE 'inout.inc'
      INCLUDE 'rescal.inc'
      INCLUDE 'restrax.inc'
      INTEGER*4 IU
      PARAMETER(IU=24)
      CHARACTER*(*) SARG
      CHARACTER*128 NAME
      INTEGER*4 I,IERR,IS,IL,IPOL,IRES,IRD
      LOGICAL*4 CREATEFILE
      REAL*8 DAT(MRES)
      
101   FORMAT('Error ',I4,': Can''t open file ',a)
102   FORMAT('Error ',I4,': Can''t read data in ',a,' ! ')
103   FORMAT('Can''t read data, header accepted ! ')
104   FORMAT('Info: MC events need to recalculate.')
201   FORMAT('RESCAL paramaters loaded - discards any data!')
      
      IRES=0
      
c      write(*,*) 'SILENT=',SILENT
C Get filename from the argument SARG or from the previous value
      IF (SARG.EQ.' ') THEN
         IF (RESCAL_NAME.NE.' ') THEN 
            NAME=RESCAL_NAME
         ELSE IF (DATNAME.NE.' ') THEN
            NAME=DATNAME
         ELSE
            NAME=' '
         ENDIF   
         IRD=1 ! interactive file-open dialog
      ELSE
        NAME=SARG
        IRD=0  ! use SARG as filename
      ENDIF
      CALL BOUNDS(NAME,IS,IL)

C special name: create empty dataset named 'channel'
      IF (IL.GE.7.AND.NAME(1:7).EQ.'channel') THEN
        IF (CREATEFILE(NAME)) IRES=3        
        RETURN        
      ENDIF  

C open the file
      CALL OPENRESFILE(NAME(IS:IS+IL-1),' ',IU,IRD,SILENT,NAME,IERR)
      IF (IERR.NE.0) GOTO 90
      CALL BOUNDS(NAME,IS,IL)
     
C make a copy of RESCAL parameters
      DO I=1,MRES
         DAT(I)=RES_DAT(I) 
      ENDDO   
      IS=1
      
C RESCAL file format
      IF (IL.GT.4.AND.NAME(IS+IL-4:IS+IL-1).EQ.'.res') THEN 
c      write(*,*) 'OPENRES: ',NAME(IS:IS+IL-1),IERR
        CALL READ_RESCAL(IU,IERR)
        CLOSE(IU)
        IF (IERR.EQ.0) THEN ! success
          IRES=1
          DATNAME=' '
          RESCAL_NAME=NAME(IS:IS+IL-1)
          CALL DELDATA(1,mf_max) ! delete all data
          mf_name(mf_cur)=' ' 
          call BEFORE
          IF (SILENT.LE.1) write(smes,201)
          RETURN
        ELSE
          GOTO 91
        ENDIF
      ELSE      
C ILL data file
        IPOL=0
        CALL READ_ILLDATA(IU,IPOL,ierr)  !  try ILL data format   
        close(IU)
        if (ierr.eq.0) THEN               !  data file, complete
          DATNAME=NAME(IS:IS+IL-1)
          RESCAL_NAME=' '
          IRES=2
          mf_active(mf_cur)=.true.
          mf_loaded(mf_cur)=.true. 
          mf_name(mf_cur)=DATNAME 
        else if (ierr.EQ.2) then               !  only header, no data values
          IF (SILENT.LT.2) write(smes,103)
          RESCAL_NAME=NAME(IS:IS+IL-1)//'.res'
          DATNAME=' '
          CALL DELDATA(1,mf_max) ! delete all data
          mf_name(mf_cur)=' ' 
          call BEFORE
          IRES=1
          return
        else                              !  another problem with data file
          GOTO 91        
        endif         
        CALL BEFORE
        IF (SILENT.LE.0.AND.mf_changed(mf_cur))  WRITE(smes,104)                 
      ENDIF  
      RETURN
      
C on error: restore RESCAL parameters and exit     
90    IF (SILENT.LE.1) write(smes,101) ierr,NAME(IS:IS+IL-1) 
      GOTO 95
91    IF (SILENT.LE.1) write(smes,102) ierr,NAME(IS:IS+IL-1) 
95    DO I=1,MRES
         RES_DAT(I)=DAT(I) 
      ENDDO
      END
      
C-----------------------------------------------------------------------
      LOGICAL*4 FUNCTION CREATEFILE(NAME)
C has the same effect as OPENFILE, but does not really read a file. 
C All data are just copied from the current data set.         
C-----------------------------------------------------------------------
      IMPLICIT NONE
      INCLUDE 'const.inc'
      INCLUDE 'inout.inc'
      INCLUDE 'restrax.inc'
      CHARACTER*60 NAME
       
C// copy data from current data set 
      call CopyDatFile 
      DATNAME=NAME
      RESCAL_NAME=' '
      mf_active(mf_cur)=.true.
      mf_loaded(mf_cur)=.true. 
      mf_name(mf_cur)=DATNAME 
      CREATEFILE=.TRUE.
      END
       
C-----------------------------------------------------------------------
      SUBROUTINE WRITE_RESCAL(SARG,IRES)
C Write RESCAL parameters to a *.res file
C IRES=0 ... not saved
C IRES=1 ... saved
C-----------------------------------------------------------------------
      IMPLICIT NONE
      INCLUDE 'const.inc'
      INCLUDE 'inout.inc'
      
      CHARACTER*(*) SARG
      INTEGER*4 IRES,IU
      PARAMETER(IU=24)
      CHARACTER*128 NAME
      INTEGER*4 I,L,IREAD,IOVER,IERR
2     FORMAT(a)
3     FORMAT(' Parameters saved in "',a,'"')
4     FORMAT(' Cannot open file for output: "',a,'"')

      IRES=0
      IREAD=0
      IOVER=0              
      IF (SINP.EQ.5) IOVER=1 ! overwrite prompt = on for standard input
      NAME=' '
      L=LEN_TRIM(SARG)
      IF (L.GT.0) THEN
        IF (L.EQ.2.AND.SARG(1:2).EQ.'as') THEN
          IREAD=1
          NAME=RESCAL_NAME
        ELSE
          NAME=SARG(1:L)  
        ENDIF
      ELSE
        IREAD=1
        NAME=RESCAL_NAME      
      ENDIF 
      CALL DLG_FILESAVE(NAME,' ','res',iread,iover,ires,NAME)
      IF (IRES.LE.0) RETURN
      
      L=LEN_TRIM(NAME)
      CALL OPENOUTFILE(NAME(1:L),IU,IERR)
      IF (IERR.NE.0) GOTO 99
      
      WRITE(IU,2) 'version=4.77'
      DO  I=1,RES_NVAR
         WRITE(IU,*) RES_DAT(I)
      ENDDO   
      CLOSE(UNIT=IU)
      IRES=1
      write(smes,3) NAME(1:L)
      RESCAL_NAME=NAME
      RETURN
      
99    write(smes,4) NAME(1:L)
      END
       

      
C-------------------------------------------------------------------
      SUBROUTINE WriteMap(outf,A,N,projx,projy,sx1,sx2,sy1,sy2,Q,E)
C writes matrix to a file    
C-------------------------------------------------------------------      
      IMPLICIT NONE    

      INCLUDE 'const.inc'
      INCLUDE 'inout.inc'
      INCLUDE 'rescal.inc'
      INCLUDE 'restrax.inc'

      INTEGER*4 N,I,J,ix,iy,lx,ly
      REAL*4 A(N,N)
      REAL*4 sx1,sx2,sy1,sy2
      REAL*8 Q(3),E 
      CHARACTER*60 outf
      CHARACTER*(*) projx,projy
      
1     FORMAT(a)
9     FORMAT(64(1x,G10.4))
13    format('scale (',G12.5,',',G12.5,',',G12.5,',',G12.5,')')
104   format('QE = [',4(G12.5,1x),']') 

      Open(Unit=22,File=outf,err=999,Status='Unknown')
      CALL BOUNDS(projx,ix,Lx)
      CALL BOUNDS(projy,iy,Ly)
      write(22,1,err=998) 
     &  'projection ('//projx(ix:ix+Lx-1)//','//projy(iy:iy+Ly-1)//')'
      write(22,13,err=998) sx1,sx2,sy1,sy2
      WRITE(22,104,err=998) (Q(i),i=1,3),E
      do j=1,n
        write(22,9,err=998) (A(i,j),i=1,n)
      enddo
            
998   Close(22)
999   continue
      end      
      
C-----------------------------------------
      SUBROUTINE WriteHist(outf)
C writes results to the file "outf"     
C-------------------------------------------      
      IMPLICIT NONE    

      INCLUDE 'const.inc'
      INCLUDE 'inout.inc'
      INCLUDE 'rescal.inc'
      INCLUDE 'restrax.inc'
      INCLUDE 'res_grf.inc'
      INCLUDE 'exciimp.inc'
            
      RECORD /MODEL/ rm

      INTEGER*4 nfit,i_io
      Parameter(i_IO=23)
      PARAMETER(NFIT=10)
      CHARACTER*80 CLine
      CHARACTER*(*) outf
      CHARACTER*128 rname 
      CHARACTER*5 FIX,FIX0,FIX1
      INTEGER*4 i,j,ierr,item0,item,ibs,ib,LR,ires
      REAL*8 QQ(4),DQQ(4),WQ(4),DA3
      REAL*4 VQ(3)
      
      integer*4 NIMA,NM
      PARAMETER(NIMA=128)
      REAL*4 AIMA(NIMA,NIMA)     
      REAL*8 XMAX,YMAX,XMIN,YMIN,A4ref,DUM  
      character*50 S
      RECORD /VIEWSET/ PORT      
            
      DATA FIX1,FIX0 /' ','fixed'/ 
 
1     format(' Results filename [restrax.dat] : ',$)
2     format(a)
5      format(2x,'Fit',I2,4x,' ',$)
7     format('AMP=',E10.3,5x,'BCG=',E10.3)
81    format('Nonlinear least squares & MC ray tracing: ',I9,' events')
82    format('Nonlinear least squares & TRAX : ',I9,' events')
9     format(2x,a10,'  a(',i2,') = ',E10.4,' +-',E8.2,
     1       ' initial = ',E10.4,2x,a5)
91    format(2x,a10,'  a(',i2,') = ',E10.4)
     
10    format(' Output file: ',a30,'   Data file: ',a30)
11    format(' QE  = [',4(1x,F8.3),']')
14    format(2x,E10.3,$)
15    format(2x,E10.3,$)

3     format('h',8x,'k',8x,'l',8x,'E',10x,'Fit',13x,$)
13    format(4(F8.3,1x),2x,E10.3,$)

33    format(2x,'a3        ',$)
133    format(F8.3,2x,$)

6     format(2x,'QH',8x,'QK',8x,'QL',8x,'EN',8x,'CNTS',6x,'Err',$)     
16    format(2x,4(F8.4,2x),F8.0,2x,F8.2,$)

66     format(7x,'A3      ',$)     
166    format(2x,F8.4,2x,$)

17    format(a80)
18    format(a)
19    format(a60)     
20    format($)
      
      LR=LEN_TRIM(outf)
      IF (LR.LE.0) THEN
        CALL DLG_FILESAVE(' ',' ','dat',1,1,ires,rname)
      ELSE      
        CALL DLG_FILESAVE(outf,' ','dat',0,1,ires,rname)
      ENDIF
      IF (IRES.LE.0) GOTO 998
      LR=MIN(LEN_TRIM(RNAME),128)
      CALL OPENOUTFILE(rname(1:LR),i_IO,IERR)  
      IF (IERR.NE.0) GOTO 999      
      RESNAME=rname(1:LR)
      
      CALL getmodel(rm)

C*    write names of dependent files:

      write(i_IO,10) rname, DATNAME

C*    list content of EXCI parameter file if EXCI is used 
      IF (iand(WHATHIS,4).EQ.4) THEN
        CALL OPENRESFILE(rm.phonname,'par',2,0,2,rm.phonname,ierr)
        if(ierr.eq.0) then
          write(i_IO,*) 'EXCI parameters from '//trim(rm.phonname)
	  do 30 while(ierr.eq.0)
            Read(2,18,iostat=ierr,err=30) CLine
            write(i_IO,17) CLine
30        continue
          close(2)   
        endif
      ENDIF

C* Parameter values:
      
101   format('CHISQR: ',G11.5)
      write(i_IO,101)  CHISQR
      
      if(jfit.eq.2) then  ! save fitting results if available 
         if(SWRAYTR.EQ.0) then
           write(i_IO,82) NXR
         else
	   call KSTACK_N(I,1)
           write(i_IO,81) I
         endif  
         do  i = 1,nfpar
           if (jfixed(i).eq.1) then
             fix = fix1
           else
             fix = fix0
           endif    
          write(i_IO,9) rm.parname(i),i,fpar(i),sigmaa(i),fpari(i),fix
        enddo
      else 
         do  i = 1,nfpar
           write(i_IO,91) rm.parname(i),i,fpar(i)
         enddo
      endif
      
C/// START TO WRITE RESULTS FOR ALL DATA IN RHIST ....

      ITEM0=0
      
      NM=NHIST(MDAT)
      IF (CFGMODE.EQ.1) NM=NHIST(1) ! only 1st channel for flat-cone
      DO I=1,NM
        ITEM=IHIST(I)
       
C* Write headers for each data set
        IF(ITEM.NE.ITEM0) THEN ! starts new dataset
          ITEM0=ITEM 
c* (Q,w) and scan step :       
          do j=1,4
            QQ(j)=mf_par(i_QH+J-1,ITEM)
            DQQ(j)=mf_par(i_DQH+J-1,ITEM)
          enddo
          DA3=mf_par(i_DA3,ITEM)
        
          write(i_IO,*)  
          write(i_IO,*) 'Resolution calculated at: ' 
          write(i_IO,11) (QQ(J),J=1,4)
          write(i_IO,*)  
          j=INDEX(mf_name(ITEM),' ')
102   format('CHISQR(I): ',G11.5,'  data: ',a)
          write(i_IO,102)  DCHISQ(ITEM), mf_name(ITEM)(1:j)
           
c* Table header :    
          if (DA3.GT.0) write(i_IO,33)
          write(i_IO,3)
          if (rm.nbr.gt.1) then
            DO j=1,rm.nbr 
               write(i_IO,5) j
	    END DO
	  endif     
          IF(NPT(ITEM).GT.NPT(ITEM-1)) then
            if (DA3.GT.0) write(i_IO,66)
            write(i_IO,6) 
          ENDIF
          IBS=NPT(ITEM-1)+1   ! base index for SPX etc..
          IB=NHIST(ITEM-1)+1  ! base index for RHIST etc..
          write(i_IO,*)  
        ENDIF     

C* Result table: 
        if (DA3.GT.0) then
          DO j=1,3
            VQ(j)=mf_par(i_QH+j-1,ITEM)
          ENDDO
          CALL ROTA3(VQ,XHIST(i)*DA3,WQ)
          WQ(4)= mf_par(i_EN,ITEM)+XHIST(i)*mf_par(i_DEN,ITEM)
        else
          DO j=1,4
            WQ(j)=mf_par(i_QH+J-1,ITEM)+XHIST(i)*mf_par(i_DQH+J-1,ITEM)
          ENDDO            
        endif     
        if (DA3.GT.0) write(i_IO,133) XHIST(i)*DA3      
        write(i_IO,13) (WQ(j),j=1,4),RHIST(I)
        if (rm.nbr.gt.1) then
          DO j=1,rm.nbr 
            write(i_IO,15) FPAR(1)*DHIST(j,i)*HNORM(ITEM)/SUMAMC(ITEM)
          END DO
        endif 
        if(npt(ITEM).gt.NPT(ITEM-1).and.I-IB.LE.NPT(ITEM)-IBS) then
          if (DA3.GT.0) then
             DO j=1,3
               VQ(j)=QQ(j)
             ENDDO
             CALL ROTA3(VQ,SPX(I-IB+IBS)*DA3,WQ)
             WQ(4)= SPX(I-IB+IBS)*DQQ(4)+QQ(4)
          else
            DO j=1,4
              WQ(j)=SPX(I-IB+IBS)*DQQ(J)+QQ(J)
            ENDDO            
          endif
          if (DA3.GT.0) write(i_IO,166) SPX(I-IB+IBS)*DA3    
          write(i_IO,16) (WQ(J),J=1,4),SPY(I-IB+IBS),SPZ(I-IB+IBS) 
        endif
        write(i_IO,*)    
      ENDDO 

c///  add matrix with flat-cone scan:
      IF (CFGMODE.EQ.1) THEN  
      
        CALL GET_A3A4(1,mf_par(i_QH,1),DUM,A4ref,I)
210     format(72('-'))
        write(i_io,210)      
211     format('FLAT_CONE scan: a4=',G12.6,'da3=',G12.6,'da4=',G12.6)        
        write(i_io,211) A4ref/deg,mf_par(i_DA3,1),mf_par(i_DA4,1)
        CALL FCONE_RANGE(xmin,xmax,ymin,ymax,.TRUE.)                  

        PORT.WX1=xmin
        PORT.WX2=xmax
        PORT.WY1=ymin
        PORT.WY2=ymax
        PORT.IX=1
        PORT.IY=2 
        CALL FILL_FCONE(PORT,AIMA,NIMA,NIMA,1) ! 1 .. from RHIST
        CALL FORMAT_HKL(mf_par(i_AX,1),S,50)
        write(i_io,*) 'X-axis :',S
        CALL FORMAT_HKL(mf_par(i_BX,1),S,50)
        write(i_io,*) 'Y-axis :',S
213   format('range (XxY) (',G10.4,',',G10.4,')x(',G10.4,',',G10.4,')')
214     FORMAT(128(1x,G10.4))
        write(i_io,213) xmin,xmax,ymin,ymax      
        do j=1,nima
          write(i_IO,214) (AIMA(i,j),i=1,nima)
        enddo
      ENDIF

      CLOSE(i_IO)

      RETURN
      
998   write(smes,*) 'Data not saved '
      Return      
999   write(smes,*) 'Cannot save to file '//rname(1:LR)
      Return      
      END
     

C-------------------------------------------------------------------------------------------------
      SUBROUTINE ReadHeader(io,ili,colhd,datline,ires)
C Read data file header 
C parameters are identified by their names (in capital letters) followed by = ,
C e.g. DM = 3.135
C The parameter names = those listed by the LIST command with an exception for step names
C 
C End of the header: 
C  (a) line starts with the 'DATA_:' string - ILL data format (IRES=1)
C  (b) line starts with three nummbers - three-column format (IRES=2)
C  (c) the end of file is reached - no data section found (IRES=0)
C  (d) error has occured while reading a line (IRES=-1)
C
C Returns:
C ires      ... result indicator (see above)
C ili    ... number of lineas read
C UsePar(i) ... bolean array to indicate which parameters where found
C ValPar(i) ... parameter values (only those for UsePar(i)=.true.)
C datahd    ... assumed string with header to data columns
C cun       ... energy unit=THz if cun='T', otherwise meV
C-------------------------------------------------------------------------------------------------
      implicit none 
      INCLUDE 'const.inc'
      INCLUDE 'inout.inc'
      INCLUDE 'rescal.inc'
      INCLUDE 'res_rdf.inc'
      
      INTEGER*4 io,ili,ires
      CHARACTER*256 colhd,datline
1     format(a)

c// local variables      
      CHARACTER*32 CPAR
      CHARACTER*256 CLINE
      INTEGER*4 i,ios,IS,IL,IERR
      LOGICAL*4 LOG1
      REAL*8 vals(3),Z
             
C//  define variables identificators, equal to the RES_NAM(i) array ....         
      DO I=1,RES_NVAR
         ResPar(I)=RES_NAM(I)         
      ENDDO            
C// with some exceptions ....
      ResPar(i_DQH)='QH'  
      ResPar(i_DQK)='QK' 
      ResPar(i_DQL)='QL' 
      ResPar(i_DEN)='EN'  
      ResPar(i_DA3)='A3' 
      ResPar(i_DA4)='A4' 

C// intialize variables, set default results
      cun='m'
      TITLE='not found'
      COMND='not found'
      ios=0  ! io-error status
      do i=1,RES_NVAR
        UsePar(i)=.false.
      end do
      ires=0   ! rILL format (1), 3-column format (2), not found(0), error (-1)
      ili=0 ! line counter
      colhd=' '
      datline=' '
      
C// start analyzing the file line by line
C// Set UsePar(i)=true if i-th parameter has been read
      do while ((ios.eq.0).AND.(ires.eq.0))
10        ili=ili+1
         read(IO,1,iostat=ios,err=110,end=100) CLine
c         write(*,*) 'line: ',ili,CLine(1:20)
         LOG1=.FALSE.
C// ignore certain lines         
         LOG1=(LOG1.OR.Cline(1:6).EQ.'VARIA:')
         LOG1=(LOG1.OR.Cline(1:6).EQ.'FORMT:')
         LOG1=(LOG1.OR.Cline(1:6).EQ.'ZEROS:')
         IF (LOG1) GOTO 10
C// identify title and command line , just echo the contents                
         CALL BOUNDS(CLINE,IS,IL)
         LOG1=(Cline(1:6).EQ.'TITLE:')
         IF (LOG1) TITLE=Cline(7:IL)
         IF (LOG1) GOTO 10
         LOG1=(Cline(1:6).EQ.'COMND:')
         IF (LOG1) COMND=Cline(7:IL)
         IF (LOG1) GOTO 10
         
C// check for the start of data section
         call SpaceDel(CLine)  ! replace delimiters with spaces     
C// ILL format?
         if (ires.eq.0) then  
            i=index(CLine,'DATA_:')
            if (i.eq.1) then   ! ILL format found  
              ires=1                         
              do while (index(CLine,'CNTS').EQ.0) ! continue up to a table header
                read(IO,1,iostat=ios,err=110,end=100) CLine
                ili=ili+1
                call SpaceDel(CLine)
              enddo
              colhd=CLine
              read(IO,1,iostat=ios,err=110,end=100) CLine ! read the first line with data values
              ili=ili+1
              call SpaceDel(CLine)
              datline=CLine
              return
            endif
         endif 
C// 3-column format?
         if (ires.eq.0) then        
           read(CLine,*,err=20) (vals(i),i=1,3)
           if (INDEX(CLine,'.').LE.0) goto 20 ! MUST CONTAIN AT LEAST ONE DOT !!!
           datline=CLine
           ires=2  ! 3-column format found
           return
         endif 
         
20       colhd=CLine ! this might have been the table header, save it for the next loop

C///  search for step values, only in STEPS: fields:
         LOG1=(CLine(1:6).EQ.'STEPS:')
         IF(LOG1) THEN
           do i=i_DQH,i_DA4  
           IF(.NOT.UsePar(i)) THEN    
             ValPar(i)=0.D0
             UsePar(i)=.true.                   
             CALL BOUNDS(ResPar(i),IS,IL)
             CALL READ_R8(ResPar(i)(IS:IS+IL-1),CLINE,Z,IERR)
             IF (IERR.EQ.0) THEN
               ValPar(i)=Z
             ELSE ! try also DQH,DQK ... old data format version
                CALL READ_R8('D'//ResPar(i)(IS:IS+IL-1),CLINE,Z,IERR)
                IF (IERR.EQ.0) ValPar(i)=Z
             ENDIF
           ENDIF
           enddo                         
         ENDIF
         
C///  search for position values, only in POSQE: fields:
         LOG1=(CLine(1:6).EQ.'POSQE:')
         IF(LOG1) THEN
           do i=i_QH,i_EN                          
           IF(.NOT.UsePar(i)) THEN                       
             CALL BOUNDS(ResPar(i),IS,IL)
             CALL READ_R8(ResPar(i)(IS:IS+IL-1),CLINE,Z,IERR)
             IF (IERR.EQ.0) THEN
               ValPar(i)=Z
               UsePar(i)=.true.
             ENDIF
           ENDIF
           enddo 
         ENDIF
         IF (LOG1) GOTO 10
          
C/// read unit name
         CALL READ_STR('UN',CLINE,CPAR,IERR)
         IF (IERR.EQ.0) THEN
            cun=CPAR(1:1)
         ENDIF
                               
C///  search for other parameters identified as RES_NAM(i)                                                         
         do i=1,RES_NVAR                          
           if(.not.UsePar(i)) then 
             CALL BOUNDS(res_nam(i),IS,IL)
             CALL READ_R8(res_nam(i)(IS:IS+IL),CLINE,Z,IERR)
             IF (IERR.EQ.0) THEN
c             write(*,*) CLINE(1:72)
               ValPar(i)=Z
               UsePar(i)=.true.
c      write(*,*) 'READHEADER: ',ili,' ',res_nam(i)(IS:IS+IL),
c     & '=',ValPar(i) 
             ENDIF
           endif
         enddo  
         
C// Set DH..DE zero for scans in A3  
         if (UsePar(i_DA3).AND.ValPar(i_DA3).NE.0) then
           do i=i_DQH,i_DEN
             UsePar(i)=.true.
             ValPar(i)=0.
           enddo
         endif
                  
100      continue                       
      enddo
      return
110   ires=-1      
      end


C-------------------------------------------------------------------------------------------------
      SUBROUTINE INDEXHEADER(LINE,ind,nind,ncol,maxcol)
C Index items in a table header using ColID identifiers from res_rdf.inc
C Consider only the columns range 1..CNTS
C LINE   ... table header
C IND(i) ... column number of the identifier ColID(i) (=0 if not present)
C ncol   ... number of indexed items in the header  
C maxcol ... max. column number = MAX(ind(i)) <=32
C-------------------------------------------------------------------------------------------------
      implicit none 
      INCLUDE 'const.inc'
      INCLUDE 'res_rdf.inc'
      CHARACTER*(*) LINE
      INTEGER*4 nind,ind(nind),ncol,maxcol,I1,L1,I2,L2,j,LL
      INTEGER*4 TRUELEN
      
      maxcol=0
      ncol=0
      do j=1,nind
         ind(j)=0
      end do
      L1=1
      LL=TRUELEN(LINE)
      IF (LL.LE.0) GOTO 99 ! empty line
      DO WHILE (L1.GT.0.AND.ind(c_CNTS).EQ.0)
        I1=1
        maxcol=maxcol+1
        call FINDPAR(LINE(1:LL),maxcol,I1,L1)
        if (L1.GT.0) then
          do j=1,nind
            if (ind(j).EQ.0) then
              CALL BOUNDS(ColID(j),I2,L2)
              if (LINE(I1:I1+L1-1).EQ.ColID(j)(I2:I2+L2-1)) then
                ind(j)=maxcol
                ncol=ncol+1
              endif
            endif
          enddo
        endif
      ENDDO

C// get maxcol = max. column number to be read (<=32)
      maxcol=ind(1)
      DO j=2,c_max
         maxcol=MAX(maxcol,ind(j))
      ENDDO   
      maxcol=MIN(maxcol,32)

99    CONTINUE
      END      
      

C-------------------------------------------------------------------------------------------------
      SUBROUTINE READ_ILLDATA(i_IO,IPOL,ierr)
C Subroutine for reading parameters from data files. New (UNIX) ILL format is accepted. 
C 
C IPOL ... polarization loop (MUST BE A WRITABLE PARAMETER !)
C if IPOL=0, procedure would ask for the No. of polarization loop and return its value in IPOL
C otherwise use this value. POL column is used to identify polarization loop index 
C 
C Actual format restrictions are rather relaxed. The rules are:
C 1) Data section must start with a line containing 'DATA_', followed by another
C    line with column names
C 2) Meaning of variables is taken from column names (e.g. EN for energy transfer, etc...)
C 3) The file must contain at least one monotonously varying variable (QH,QK,QL or EN) +
C    PNT (point index) and CNTS (counts) columns
C 4) OPTIONALLY, parameters of instrument setting can be read from the file header, 
C    if they are identified by their names (in capital letters) followed by = (e.g. DM = 3.135)
C---------------------------------------------------------------------------------------------
      implicit none 

      INCLUDE 'const.inc'
      INCLUDE 'inout.inc'
      INCLUDE 'rescal.inc'
      INCLUDE 'restrax.inc'
      INCLUDE 'res_rdf.inc'

      INTEGER*4 i_IO,i_mv,ilines,IPOL,IPMAX      
      REAL*4 SPEC(c_max,MHIS),X(0:32),SPX0
      character*256 CLine,ColHD
      REAL*4 DXX(NHI*MDAT),XX(NHI*MDAT),YY(NHI*MDAT),ZZ(NHI*MDAT),QI(3)
      INTEGER*4 NP,NPOLD,II(NHI*MDAT),ierr,i,ios
      INTEGER*4 i_col,j,ib,ihead,L,k,TRUELEN
      REAL*8 dd,x0
      LOGICAL*4 moves
      INTEGER*4 ind(c_max),ncol ! index to columns with QH,QK,... in the data section
      INTEGER*4 IDBG  
      DATA IDBG/0/ ! for debug purposes - set IDBG>0 to see debug messages
      SAVE X,ind

1     format(a)
202   FORMAT('     ',a,a)
203   FORMAT('     ',a,I6)
204   FORMAT(I3,2x,10(G10.4,1x))
205   FORMAT(a,2x,10(G10.4,1x))
c 206   FORMAT(a,2x,10(a,1x))
207   FORMAT('     ','3-column data format: ',a5, ' INT  STDEV ')
208   FORMAT('     ','ILL data format')
209   FORMAT('     ','STEP :',$)
210   FORMAT(1x,a3,G10.3,$)
211   FORMAT('     ','QHKLE:',4(1x,a3,G10.3))
c 215   FORMAT('     ',a)  
216   FORMAT('     ','POSQE:',$)  
217   FORMAT(a5,'       ',$)  
218   FORMAT(G10.4,'  ',$)  
      idbg=0
     
C some initializations
C make a local copy of RES_DAT array in ValPar      
      do i=1,RES_NVAR                          
        ValPar(i)=RES_DAT(i)
      enddo
      do j=1,MHIS
        do i=1,c_max
          spec(i,j)=0.D0
        enddo
      enddo
      ios=0
      np=0
      ncol=0
      i_mv=0

C///  ****   READ DATA HEADER   **** 

      ierr=1
      call ReadHeader(i_IO,ilines,colhd,CLine,ihead)
 
      if (idbg) write(*,*) 'header OK: ',ihead,ilines      
      if (idbg) write(*,*) colhd(1:60)
      if (idbg) write(*,*) CLine(1:60)
      if (idbg) then
        write(sout,209)
        DO i=i_DQH,i_DA4
            if (UsePar(i)) write(sout,210) RES_NAM(i),ValPar(i)
        ENDDO
        write(sout,*)
        write(sout,216)
        DO i=i_QH,i_EN
            if (UsePar(i)) write(sout,210) RES_NAM(i),ValPar(i)
        ENDDO
        write(sout,*)
      endif
 
C/// ReadHeader should have provided the table header (colhd) + the 1st row (CLine)

C/// analyze the result
      if (ihead.lt.0) goto 199    ! error in header => return with ierr=1
      ierr=2 ! at least the file header was found
      if (ihead.eq.0) goto 180 ! no data section => skip to the epilog      
            
C///  ****  INTERPRET TABLE HEADER ****   

      call INDEXHEADER(colhd,ind,c_max,ncol,i_col)
c      if (idbg) write(*,*) 'table header: ',(ind(i),i=1,c_max)

C// 3-column format
C// ===============
C// Use the 1-st column as x-variable.      
      if (ihead.eq.2) then
         j=0     
         if (i_col.le.0) then  ! no table header => use ValPar
           j=0
           do i=c_QH,c_A3
             if (ValPar(i-c_QH+i_DQH).NE.0.) then
               j=j+1
               i_mv=i
             endif
           enddo
         else                  ! identify the first column
           do i=c_QH,c_A3
             if (ind(i).EQ.1) i_mv=i
           enddo
         endif
         if (i_mv.le.0.or.j.gt.1) goto 198 ! cannot identify scan variable
         ind(i_mv)=1
         ind(c_CNTS)=2
         ind(c_ERR)=3
         i_col=3
         IPOL=0
         goto 200
      endif


C// ILL format
C// ===============
C// Data MUST contain 'PNT' and 'CNTS' columns and at least one column with a variable
      if ((ind(c_PNT).eq.0).OR.
     &    (ind(c_CNTS).eq.0).OR.
     &    (ncol.lt.3)) goto 170
       
C// Check for polarization analysis loop. 
C// This section ends with the 2nd data row in CLine.
C// 1) Find number of pol. loops, if any
C// 2) Select, which one to read
      j=1
      IF (ind(c_PAL).gt.0) THEN 
        ipmax=0
        DO WHILE( j.eq.1) 
          read(CLine,*,iostat=ios,err=170) (X(i),i=1,i_col)
          j=NINT(X(ind(c_PNT))) ! get actual PNT index             
          if (j.eq.1) then
            k=NINT(X(ind(c_PAL)))
            if (ipmax.LT.k) ipmax=k
            do i=1,c_max
              if(ind(i).gt.0) spec(i,k)=X(ind(i))
            end do
      if (idbg) write(*,204) j,(X(i),i=1,i_col)
140         read(i_IO,1,iostat=ios,err=170,end=170) CLine
            if (CLine(1:1).EQ.'#') goto 140
          endif
        ENDDO
        IF (IPOL.LE.0.OR.IPOL.GT.ipmax) THEN ! ask for the loop number to be read          
          CALL DLG_INTEGER('Polarization Analysis Loop',IPOL,0,1,ipmax)
        ENDIF
        do i=1,c_max
           if(ind(i).gt.0) spec(i,1)=spec(i,IPOL)
        end do        
      ELSE                             ! Suppose there are NO loops
        read(CLine,*,iostat=ios,err=170) (X(i),i=1,i_col)
        do i=1,c_max
          if(ind(i).gt.0) spec(i,j)=X(ind(i))
        end do
150     read(i_IO,1,iostat=ios,err=170,end=170) CLine ! read also the 2nd line !!
        if (CLine(1:1).EQ.'#') goto 150
      ENDIF
      NP=1 ! one row has been read
        
C//  Common to both formats:                       
C//  READ REMAINING LINES 
200   DO  WHILE((ios.eq.0).AND.(np.lt.NHI*4).AND.NP.LT.MHIS)        
        read(CLine,*,iostat=ios,err=170) (X(i),i=1,i_col)  ! read values from CLine
      if (idbg) write(*,204) np,(X(i),i=1,2)
        if (IPOL.LE.0.OR.NINT(X(ind(c_PAL))).EQ.IPOL) THEN ! select only required IPOL
          NP=NP+1
          do i=1,c_max
            if(ind(i).gt.0) spec(i,np)=X(ind(i))
          end do
      if (idbg) write(*,204) np,(X(i),i=1,i_col)
        endif
160     read(i_IO,1,iostat=ios,err=199,end=170) CLine      ! read another CLine from IO
        ilines=ilines+1
        if (CLine(1:1).EQ.'#') goto 160                    ! ignore comments
      ENDDO
      
170   continue
C------------------------------------------------------------------
C  *****   Data read finished, file closed. *****   
C------------------------------------------------------------------

      if (idbg) write(*,*) 'data OK: ',np


C// correct QH..QL, because POSQE gives the 1st point, not the middle !!
      DO i=c_QH,c_EN
      IF (UsePar(i-c_QH+i_DQH).AND.UsePar(i-c_QH+i_QH)) THEN      
        dd=ValPar(i-c_QH+i_DQH)            
        if (dd.NE.0) then 
          ValPar(i-c_QH+i_QH)=ValPar(i-c_QH+i_QH)+dd*(NP-1.D0)/2.D0
        endif
      ENDIF
      ENDDO


C Find the first monotonously varying parameter from QH..EN,A3
C Corresponding column must be on the left from CNTS!

      if (np.lt.2) GOTO 180 ! must have at least 2 data points      

C// Try steps in QHKL,E
      DO i=c_QH,c_EN
        if (ind(i).ne.0.AND.(ind(i).lt.ind(c_CNTS))) then
          dd=spec(i,2)-spec(i,1)
	  moves=.true.   ! test if the variable varies monotonously
	  j=2
          do while (moves.and.(j.lt.np))
            moves=(moves.AND.(spec(i,j+1)-spec(i,j))*dd.GT.0.D0)
            j=j+1 
	  end do
          if (moves) then 
            ValPar(i-c_QH+i_QH)= (spec(i,np)+spec(i,1))/2          ! scan center
	    ValPar(i-c_QH+i_DQH)=(spec(i,np)-spec(i,1))/(np-1)     ! average scan step
            if (.not.UsePar(i-c_QH+i_DQH)) UsePar(i-c_QH+i_DQH)=.true.
       if (idbg) write(*,*) 'moves along ',ColID(i),ValPar(i-c_QH+i_DQH)      
	    if (i_mv.eq.0) i_mv=i  ! get index for the first varying parameter
          endif    
	endif
      END DO
      
C// Try steps in A3 if there is no step in QHKLE
      i=c_A3 
      if (i_mv.eq.0.AND.ind(i).gt.0.AND.(ind(i).lt.ind(c_CNTS))) then
          dd=spec(i,2)-spec(i,1)
	  moves=.true.           ! test if the variable varies monotonously
	  j=2
          do while (moves.and.(j.lt.np))
            moves=(moves.AND.(spec(i,j+1)-spec(i,j))*dd.GT.0.D0)
            j=j+1 
	  end do  
          if (moves) then 
	      ValPar(i_DA3)=(spec(i,np)-spec(i,1))/(np-1)
       if (idbg) write(*,*) 'moves along ',ColID(i),ValPar(i-c_QH+i_DQH)      
              if (.not.UsePar(i_DA3)) UsePar(i_DA3)=.true.
              i_mv=c_A3
	  endif    
      endif
        
C set ierr=0 if everything is OK
      IF (i_mv.gt.0) ierr=0 ! there MUST be at least one varying parameter

C from now on, the data are correctly read and the RESCAL fields can be updated:
C-----------------------------------------------------------------------------             

C// convert energy to meV if needed
180   if (cun.eq.'T') then
         call UNITS(cun) ! set EUNI for conversion THz->meV
         if (UsePar(i_EN)) ValPar(i_EN)=ValPar(i_EN)/EUNI
         if (UsePar(i_DEN)) ValPar(i_DEN)=ValPar(i_DEN)/EUNI
         if (UsePar(i_GMOD)) ValPar(i_GMOD)=ValPar(i_GMOD)/EUNI
         if (i_mv.EQ.c_EN) then
           do i=1,np
             spec(i_mv,i)=spec(i_mv,i)/EUNI
           enddo
         endif
         call UNITS('m') ! set EUNI back to 1
      endif

C// copy modified parameters to the RES_DAT array
      DO i=1,RES_NVAR          
         IF (UsePar(I)) RES_DAT(I)=ValPar(I)
      ENDDO         

C// update dependent fields
      CALL RECLAT          !   compute reciprocal lattice parameters and matrices
      CALL SCATTRIANGLE    !   compute and check KI,KF,Q and tras. matrix Lab -> CN
      IF (ierr.EQ.2) goto 299  ! no data, but header was read

C for A3 scan: adjust QH,QK,QL, because POSQE gives the position at the 1st scan step !              
      if (i_mv.EQ.c_A3.and.np.gt.1) then
        if (UsePar(i_QH).AND.UsePar(i_QK).AND.UsePar(i_QL)) then
          do j=1,3
             QI(j)=RES_DAT(i_QH+j-1)
          enddo
       if (idbg) write(*,205) 'center from: ',QI
          call ROTA3(QI,RES_DAT(i_DA3)*(np-1.D0)/2.D0,RES_DAT(i_QH))
       if (idbg) write(*,205) 'center to:   ',(RES_DAT(i_QH+j-1),j=1,4)
        endif  
      endif


C/// ***  write new values to DSPX,SPX,SPY,SPZ arrays:  ****    
C///  DSPX(i) contains the missfits with respect to equidistant points.
C///  SPX(i) contains row numbers + DSPX(i), but is modified later to account for
C/// differences in the scan size and spectrometer position (QHKL, E) 
C-----------------------------------------------------------------------------      

C* first make a copy of the stack at and above the current data:
       
      IB=NPT(mf_cur-1)+1   ! base index
      do i=IB,NPT(MDAT)
         DXX(i)=DSPX(i)
	 XX(I)=SPX(I)
         YY(I)=SPY(I)
         ZZ(I)=SPZ(I)
         II(I)=IPT(I)
      end do
      NPOLD=NPT(mf_cur)-NPT(mf_cur-1)
      
c* write new data to SPX  
      if (i_mv.LE.c_EN) then   
        spx0=RES_DAT(i_QH+i_mv-c_QH)
      else
        spx0=(spec(i_mv,np)+spec(i_mv,1))/2.D0
      endif
      spx0=spx0/RES_DAT(i_DQH+i_mv-c_QH)  ! scan center in step units
      do i=1,np
        spx(i+IB-1)=spec(i_mv,i)/RES_DAT(i_DQH+i_mv-c_QH)-spx0
        dspx(i+IB-1)=spx(i+IB-1)-(i-1-(np-1)/2.)         
        spy(i+IB-1)=spec(c_CNTS,i) 
        if (ihead.eq.2) then ! 3-column format
           spz(i+IB-1)=spec(c_ERR,i)
        else if (spy(i+IB-1).LE.0) then
           spz(i+IB-1)=1.
        else   
           spz(i+IB-1)=SQRT(spy(i))
        endif
        ipt(I+IB-1)=mf_cur        
      end do

C* repartition the SPX,... arrays
      DO i=mf_cur,MDAT        
        NPT(I)=NPT(I)+NP-NPOLD
      END DO 

c* put the rest on top:
      do i=NPT(mf_cur)+1,NPT(MDAT)
         DSPX(I)=DXX(I-NP+NPOLD)
         SPX(I)=XX(I-NP+NPOLD)
         SPY(I)=YY(I-NP+NPOLD)
         SPZ(I)=ZZ(I-NP+NPOLD)
         IPT(I)=II(I-NP+NPOLD)	 	 	 
      end do
                                                   
      
C* store new reference values for the scan step and position
C* corrsponding to the current data set
      DO I=1,4
        QE0(I,mf_cur)=RES_DAT(i_QH+I-1)
        DQE0(I,mf_cur)=RES_DAT(i_DQH+I-1)
      ENDDO
      DO I=5,6  ! DQE0(5..6) are the steps in A3 and A4 
        DQE0(I,mf_cur)=RES_DAT(i_DQH+I-1)
      ENDDO


C/// set defaults if necessary
C-------------------------------------------------------------
299   CONTINUE
C set gradient of the dispersion surface
      IF(.NOT.(UsePar(i_GH).AND.UsePar(i_GK).AND.UsePar(i_GL))) THEN
        IF (ABS(DQE0(1,mf_cur))+ABS(DQE0(2,mf_cur))+
     *    ABS(DQE0(3,mf_cur)).GT.0) THEN ! scan is in Qhkl
          RES_DAT(i_GH)=RES_DAT(i_DQH)
          RES_DAT(i_GK)=RES_DAT(i_DQK)
          RES_DAT(i_GL)=RES_DAT(i_DQL)
        ELSE
          RES_DAT(i_GH)=RES_DAT(i_AX) ! scan Qhkl=const.
          RES_DAT(i_GK)=RES_DAT(i_AY)
          RES_DAT(i_GL)=RES_DAT(i_AZ)
        ENDIF
      ENDIF              

C set sample size
      IF(RES_DAT(i_SDI).LE.1.D-6) RES_DAT(i_SDI)=1.D0
      IF(RES_DAT(i_SHI).LE.1.D-6) RES_DAT(i_SHI)=1.D0
                
C set horizontal crystal curvature for perfect crystals
      IF(ABS(RES_DAT(i_ROMH)).LE.1.D-6.AND.RES_DAT(i_ETAM).LE.sec) THEN
         RES_DAT(i_ROMH)=1.D-1
      ENDIF     
      IF(ABS(RES_DAT(i_ROAH)).LE.1.D-6.AND.RES_DAT(i_ETAA).LE.sec) THEN
         RES_DAT(i_ROAH)=1.D-1
      ENDIF     

C/// print additional information about data
      if (SILENT.LE.1) THEN
c        write(smes,*)  ' OK'
        L=TRUELEN(TITLE)
        if (L.GT.0) write(sout,202) 'TITLE: ',TITLE(1:L)
        L=TRUELEN(COMND)
        if (L.GT.0) write(sout,202) 'COMND: ',COMND(1:L)
        write(sout,203) 'No. of data points : ',NP           
        if (ihead.eq.2) then
            write(sout,207) ColID(i_mv) 
        else
            write(sout,208)
        endif
        write(sout,211) ((RES_NAM(i),RES_DAT(i)),i=i_QH,i_EN)
        write(sout,209)
        if (RES_DAT(i_DA3).NE.0) THEN
           write(sout,210) RES_NAM(i_DA3),RES_DAT(i_DA3)
        else
          DO i=i_DQH,i_DA4
            if (RES_DAT(i).NE.0) write(sout,210) RES_NAM(i),RES_DAT(i)
          ENDDO
        endif
        write(sout,*)                
      endif  
      
c      idbg=1
      
      if (idbg) then  ! print the data table
        write(*,217) ColID(c_PNT)
        do i=c_QH,c_A3
          dd=DQE0(i-c_QH+1,mf_cur)
          if (dd.ne.0) write(*,217) ColID(i) 
        enddo
        write(*,217) ColID(c_CNTS)
        write(*,217) ColID(c_ERR)
        write(*,*) 
        do j=NPT(mf_cur-1)+1,NPT(mf_cur)
          write(*,218) SPX(j)
          do i=c_QH,c_A3
            dd=DQE0(i-c_QH+1,mf_cur)
            x0=0
            if (i.lt.c_A3) x0=QE0(i-c_QH+1,mf_cur)
            if (dd.ne.0) write(*,218) SPX(j)*dd+x0
          enddo
          write(*,218) SPY(j)
          write(*,218) SPZ(j)
          write(*,*)
        enddo      
      endif
      
      CALL ANGSCAN(RES_DAT(i_DA3),0.D0) ! scan in DA3 => adjust DH,DK,DL and set DE=0
      RETURN


198   ierr=1
      Close(i_IO)   ! No spectrum read
      if (SILENT.LE.2) write(sout,*) 'cannot determine scan step'      
      return

199   ierr=1
      Close(i_IO)   ! No spectrum read
      if (SILENT.LE.2) write(sout,*) 'not a regular data file'      
      return
           
      end     
      
C-----------------------------------------------------------------------
      SUBROUTINE CopyDatFile
C As ReadDatFile, but doesn't read the file, only inserts a new data set 
C before the current one with the same data
C QHKL and scan steps are taken from the RES_DAT() field
C-----------------------------------------------------------------------
      implicit none 

      INCLUDE 'const.inc'
      INCLUDE 'inout.inc'
      INCLUDE 'rescal.inc'
      INCLUDE 'restrax.inc'

      REAL*4 DXX(NHI*MDAT),XX(NHI*MDAT),YY(NHI*MDAT),ZZ(NHI*MDAT)
      INTEGER*4 NP,NPOLD,I,II(NHI*MDAT),IB               
       
c      NP=NPT(mf_cur)-NPT(mf_cur-1) ! get number of points from curret data set
c      IF (NP.EQ.0) NP=91   ! if there are no data, set NP=91
      NP=91
C* first make a copy of the stack at and above the current data:
      IB=NPT(mf_cur-1)+1   ! base index to current data
      do i=IB,NPT(MDAT)
         DXX(i)=DSPX(i)
	 XX(I)=SPX(I)
         YY(I)=SPY(I)
         ZZ(I)=SPZ(I)
         II(I)=IPT(I)
      end do
      
C* repartition the SPX,... arrays
      NPOLD=NPT(mf_cur)-NPT(mf_cur-1)
c      write(*,10) 'cur, NPOLD, NP',mf_cur,NPOLD,NP
      DO i=mf_cur,MDAT          
c      write(*,10) 'NP partition: ',i, NPT(I),NPT(I)+NP-NPOLD    
          NPT(I)=NPT(I)+NP-NPOLD          
      END DO
      
c* fill spectrum:
      IF (NP.NE.NPOLD) THEN
      do i=1,np
        spx(i+IB-1)=i-(np+1)/2
        dspx(i+IB-1)=0.         
        spy(i+IB-1)=0. 
        spz(i+IB-1)=1
        ipt(I+IB-1)=mf_cur        
      end do
      ENDIF                                      
      
c* put the rest on top:
      do i=NPT(mf_cur)+1,NPT(MDAT)
         DSPX(I)=DXX(I-NP+NPOLD)
         SPX(I)=XX(I-NP+NPOLD)
         SPY(I)=YY(I-NP+NPOLD)
         SPZ(I)=ZZ(I-NP+NPOLD)
         IPT(I)=II(I-NP+NPOLD)	 	 	 
      end do
C* store new reference values for the scan step and position
C* corresponding to the current data set
      DO I=1,4
        QE0(I,mf_cur)=RES_DAT(i_QH+I-1)
        DQE0(I,mf_cur)=RES_DAT(i_DQH+I-1)
      ENDDO
      DO I=5,6  ! DQE0(5..6) are the steps in A3 and A4 
        DQE0(I,mf_cur)=RES_DAT(i_DQH+I-1)
      ENDDO
c10    format(a,3(' ',I),4(1x,G12.6)) 
c      write(*,*) 'RDF: ',mf_cur,NP,NPT(mf_cur)-NPT(mf_cur-1),
c     &      (QE0(I,mf_cur),I=1,4) 
c      pause
      
      end     


C------------------------------------------------------------------     
      SUBROUTINE SpaceDel(CLine)
C     writes spaces instead of other delimiters (, ; TAB NULL)      
C------------------------------------------------------------------                 
      IMPLICIT NONE     
      INTEGER*4 ip,ip1,L      
      character*(*) CLine
      
      L=LEN(CLine)      
      ip1=1
      ip=1
      DO while (ip1.ne.0)
        ip1=index(CLine(ip:),';')
	if (ip1.eq.0) ip1=index(CLine(ip:),',')
	if (ip1.eq.0) ip1=index(CLine(ip:),'	')
	if (ip1.eq.0) ip1=index(CLine(ip:),CHAR(0))	
        if(ip1.ne.0) then
           CLine(ip1+ip-1:ip1+ip-1)=' '
           ip=ip+ip1
        endif
      enddo 
      end
                  
C------------------------------------------------------------------      
      SUBROUTINE ILLNameParse(NameFile,ICOM)
C if NameFile  is an integer, convert it to ILL data filename   
C------------------------------------------------------------------                
      IMPLICIT NONE
      
      INTEGER*4 i,n,ICOM,ios
      INTEGER*4 IS,IL
      character*(*) NameFile 
      character*128 cstr,nfile
1     format(I5)
3     format(I7)

      CALL BOUNDS(NameFile,IS,IL)
      
      if(IL.ge.1) then
         nfile=NameFile(IS:IS+IL-1)//' '         
         read(nfile,*,iostat=ios) n         
         if((ios.eq.0).and.(n.gt.0).and.(n.lt.100000))  then  ! name is a positive integer
c            write(*,*) n
            if(ICOM.EQ.0) THEN                ! ILL name - old VMS format
               write(cstr,1,iostat=ios) n
               if(n.lt.10) then
                  NameFile='sv000'//cstr(5:5)//'.scn '     
               else  if(n.lt.100)  then
                  NameFile='sv00'//cstr(4:5)//'.scn '
               else  if(n.lt.1000)  then
                  NameFile='sv0'//cstr(3:5)//'.scn '
               else  
                  NameFile='sv'//cstr(2:5)//'.scn '
               endif
            else if(ICOM.EQ.1) THEN           ! ILL name - Unix
               write(cstr,3,iostat=ios) n
               do i=1,7
                  if(cstr(i:i).eq.' ') cstr(i:i)='0'
               end do
               NameFile=cstr(2:7)//' '
            endif                  
         else
c           write(*,*) NameFile(IS:IS+IL-1)//'.'
         endif
      endif        
      end     
      
      
C----------------------------------------------------------------------
      SUBROUTINE GetXSpec
C     correct the spectrum x-scale if the scan parameters 
C     differ from the RESTRAX setting DH,DK,DL,DE
C  (Takes projection on the DH,DK,DL,DE direction)
C      J.S., June 1997,1999
c  SPX(I)*DE + EN must give correct data points (etc. for QH,QK,QL)
C     mod. by J.S., Sept 2002
C----------------------------------------------------------------------
      IMPLICIT NONE
      INCLUDE 'const.inc'
      INCLUDE 'inout.inc'
      INCLUDE 'rescal.inc'
      INCLUDE 'restrax.inc'
      
      INTEGER*4 I,NP,IBASE
      REAL*8  DQR(3),DQ0(3),Z,EN,DE
      REAL*8  DSTEP,FSTEP,FSTEP1,ZCTR,SNORM,SNORM0
      REAL*8  QxQ
1     FORMAT(a8,4(1x,G10.4))
      
      IF(RES_DAT(i_DA3).EQ.0) THEN ! only for a linear QHKLE scan
      IF(NPT(mf_cur).GT.NPT(mf_cur-1)) THEN	
         EN=RES_DAT(i_EN)
         DE=RES_DAT(i_DEN)
         DO I=1,3        
           DQ0(I)= DQE0(I,mf_cur)            
           DQR(I)=QE0(I,mf_cur)-QHKL(I)     	! relative shift btw. spectrum
         END DO                   		! and nominal setting is calculated
         SNORM=QxQ(DELQ,DELQ)+DE**2
         SNORM0=QxQ(DQ0,DQ0)+DQE0(4,mf_cur)**2
c scan centre missfit 
         DSTEP=(QxQ(DQR,DELQ)+(QE0(4,mf_cur)-EN)*DE)/SNORM
c scan step projected on DH,DK,DL,DE
         Z=QxQ(DQ0,DELQ)
         FSTEP=(Z+DQE0(4,mf_cur)*DE)/SNORM
         FSTEP1=(Z+DQE0(4,mf_cur)*DE)/SQRT(SNORM*SNORM0)
         NP=NPT(mf_cur)-NPT(mf_cur-1)
         IBASE=NPT(mf_cur-1)+1
         ZCTR=(NP-1)/2.
C// correct the spectrum x-scale if the scan parameters are different
         DO I=IBASE,NPT(mf_cur)
           SPX(I)=(I-IBASE-ZCTR+DSPX(I))*FSTEP+DSTEP	     
         ENDDO
       
C warning if scan directions in data and RESTRAX differ
c         IF (ABS(1.D0-FSTEP1).GT.0.01.AND.RES_DAT(i_DA3).EQ.0) THEN
         IF (ABS(1.D0-FSTEP1).GT.0.01) THEN
            write(smes,*) 
     *     'Warning! INCONSISTENT SCAN DIRECTIONS in data ',mf_cur
            write(smes,1) 'Data: ',(DQ0(I),I=1,3),DQE0(4,mf_cur)
            write(smes,1) 'Calc: ',(DELQ(I),I=1,3),DE
         ENDIF
      ENDIF
      ENDIF
      END
           
      
