C//////////////////////////////////////////////////////////////////////
C////
C////  R E S T R A X   4.4
C////
C////  Subroutines from the program TRAX 
C////
C////  * SUBROUTINE THRAX
C////  * SUBROUTINE SSTV
C////  * SUBROUTINE TRCAN(VL0,VLI,VLC,S10,S20,NF,XSHI)
C////  * SUBROUTINE TCR
C////  * SUBROUTINE HIRANG(OB,HII,HI)
C////  * SUBROUTINE VANAD(DVN,YVN)    J.S. 3/6/97
C////  * FUNCTION OPTV(N,RO)          J.S. 3/6/97
C////
C//////////////////////////////////////////////////////////////////////

C********************************
      SUBROUTINE THRAX
C********************************      
C     COMPUTES THE RESOLUTION MATRIX, THE NORMALIZATION FACTORS AND
C     DIFFERENT SCAN WIDTHS AND ABSOLUTE INTENSITIES AT DETECTOR
C     FOR A THREE-AXIS NEUTRON SPECTROMETER
c      implicit REAL*8 (a-h,o-z)
      
      implicit none
      INCLUDE 'const.inc'
      INCLUDE 'inout.inc'
!      INCLUDE 'rescal.inc'
      INCLUDE 'trax.inc'

      INTEGER*4 i,j 
      REAL*8 right,sim,vkfm,sia,vkim,two,cose,sine,ar,co,si,ttemp,
     *       am,bet,xaa,cot,com,v1h,v0h,rmh,v0v,v1v,rmv,volph1,erm,
     *       wdthef,zef,areaef,pathef,detas,fact,flu,ysam,ysam0

      REAL*8 EM(4,4),CM1V(5,5),X33(1,1),AUX3(3,3),AUX4(4,4),AU2(2,2),
     1       AHP(3,4),AUX6(6,6),CNH(6,6),CNV(3,3),AU23(2,3),AUX2(2,2),
     2       AH(4,6),AV(3,5),AV1(1,3),AU3(3,3),AH8(6,8),CKI0(3,3),
     3       AUX5(5,5),CNINI(5,5),DET1,DET2,DET3,DET4
               
      REAL*8 AAA(4,4)
      COMMON /MATRIX/ AAA
      INTEGER*4 IERR
      COMMON /ERROR/IERR            
      REAL*8 EMMIN1(4,4),VOLRES
      COMMON /EM/EMMIN1,VOLRES
      REAL*8 DV(5,5),BM,BA,AHS(3,4)
      COMMON /CTR/DV,BM,BA,AHS
      REAL*8 CMH(8,8),CMV(5,5),CMHP(4,4),CMVP(3,3)
      COMMON /COVAR/CMH,CMV,CMHP,CMVP
      REAL*8 SH(10,10),SH1(10,10),SV(5,5),SV1(5,5),SHP(5,5),SVP(3,3)
      COMMON /STV/SH,SH1,SV,SV1,SHP,SVP
      REAL*8 DETERM

C make local variables static in THRAX !!!
      SAVE right,sim,vkfm,sia,vkim,two,cose,sine,ar,co,si,ttemp,
     *     am,bet,xaa,cot,com,v1h,v0h,rmh,v0v,v1v,rmv,volph1,erm,
     *     wdthef,zef,areaef,pathef,detas,fact,flu,ysam,ysam0
      SAVE EM,CM1V,X33,AUX3,AUX4,AU2,AHP,AUX6,CNH,CNV,AU23,AUX2,
     *     AH,AV,AV1,AU3,AH8,CKI0, AUX5,CNINI,DET1,DET2,DET3,DET4
           
      DATA PII,TDR,TMR,R8LN2,HSQOVM/3.141592653589793239D0,.01745329,
     +2.9089E-4,2.3548,4.144219/     
	

c      write(*,*) 'THRAX', NEFIX
      IF ((IM*ISC*IA).EQ.0) THEN
        DO I=1,4
        DO J=1,4
           AAA(I,J)=0.
        END DO
        END DO
        RELTRAX=0. 
        
        write(*,*) 'IM,ISC,IA: ',IM,ISC,IA
        
        RETURN
      ENDIF  

c      WRITE(*,*) NGUIDE,GAMACR

      RIGHT=PII/2.

      IF(NEFIX.GT.1)GO TO 14
      VKI=SQRT(2./HSQOVM*EI0)
      SLAMDI=2.*PII/VKI
      OM=ASIN(SLAMDI/2./CRYD(1))*IM
      TETAM=OM/TDR
      SIM=SIN(OM)
      VKFM=PII/CRYD(2)
      VKF=VKI*VKI-HOMEGA*2./HSQOVM
      IF(VKF.LE.(VKFM*VKFM))GO TO 7
      VKF=SQRT(VKF)
      SLAMDF=2.*PII/VKF
      OA=ASIN(VKFM/VKF*IA)
      TETAA=OA/TDR
      EF0=0.5*HSQOVM*VKF*VKF
      GO TO 15

   14 VKF=SQRT(2./HSQOVM*EF0)
      SLAMDF=2.*PII/VKF
      OA=ASIN(SLAMDF/2./CRYD(2))*IA
      TETAA=OA/TDR
      SIA=SIN(OA)
      VKIM=PII/CRYD(1)
      VKI=VKF*VKF+HOMEGA*2./HSQOVM
      IF(VKI.LE.(VKIM*VKIM))GO TO 7
      VKI=SQRT(VKI)
      SLAMDI=2.*PII/VKI
      OM=ASIN(VKIM/VKI)*IM
      TETAM=OM/TDR
      EI0=.5*HSQOVM*VKI*VKI

   15 CONTINUE
!   VQ0=Q

C      write(*,*) 'THRAX_3 passed, TETAA=',TETAA     	 

     
   36 TWO=.5*(VKI/VKF+VKF/VKI-VQ0*VQ0/VKI/VKF)
      IF(ABS(TWO).GE.1.) GO TO 9
      TWO=ACOS(TWO)
      OS=ISC*TWO/2.
      TETAS=OS/TDR
      PHI=ATAN2(-VKF*SIN(2.*OS),VKI-VKF*COS(2.*OS))
      PHIM=PHI-2.*OS
      CALL HIRANG(OM,HIMON,HIM)
      CALL HIRANG(OA,HIANA,HIA)
C      DIRTAU=DIRTD*TDR
      IF(NSAM.EQ.0) GO TO 24

      IF(HIS.LE.(RIGHT-OS)) GO TO 29
      HIS=HIS-PII
C      DIRTAU=DIRTAU-PII
     
   29 IF(HIS.GE.(-RIGHT-OS)) GO TO 24
      HIS=HIS+PII
C      DIRTAU=DIRTAU+PII
      
   24 COSE=1.
      SINE=0.
      EPSLN=0.
C      write(*,*) 'THRAX_4 passed'     	 

    8 ETAMEF=ETM*TMR
      ETVMEF=ETM*ANRM*TMR
      AR=ABS(OM+HIM)/(OM+HIM)
      CO=COS(HIM)
      SI=SIN(HIM)
      IF(ROHM.EQ.0.) GO TO 18
      TTEMP=POISS(1)/(1-POISS(1))
      AM = 1 - (1+TTEMP)*CO*CO
      BM = (1+TTEMP)*SI*CO
	 
C      write(*,*) 'THRAX_5 passed'     	 
 
   18 ETAAEF=ETA*TMR
      ETVAEF=ETA*ANRA*TMR
      BET=ABS(OA+HIA)/(OA+HIA)
      CO=COS(HIA)
      SI=SIN(HIA)
      IF(ROHA.EQ.0.) GO TO 21
      TTEMP=POISS(2)/(1-POISS(2))
      XAA = 1 - (1+TTEMP)*CO*CO
            
      BA = (1+TTEMP)*SI*CO
C      write(*,*) 'THRAX_6 passed'     	 
      
   21 PM=1.                   ! peak reflectivity=1 is supposed
      PA=1. 
c      write(*,*) 'Indexes ',NFM,NFS,NFA,NFD,IM,IA,ISC   	 
c      write(*,*) 'ALPHA ',ALPHA   	 
c      write(*,*) 'distances: ', VL0,VL1,VL2,VL3  	 
   
      CALL SSTV
C      write(*,*) 'THRAX_SSTV passed'     	 
      CALL TCR
C      write(*,*) 'THRAX_TCR passed'     	 

      CALL BABT(CMV,DV,5,5,CM1V)
C     CM1V IS THE COVARIANCE MATRIX OF THE VERTICAL VARIABLES 
C     (DELTA0,DELTA1,DELTA2,DELTA3,ZS). 
      DO 1 I=1,6
      DO 1 J=1,8
    1 AH8(I,J)=0. 
      COT=1./TAN(OM)
      DO 30 I=1,3 
      DO 30 J=1,4 
   30 AHP(I,J)=0. 
      CO=COS(OM-HIM)/VL1*VKI
      SI=VKI*SIN(OM-HIM)/VL1
      AH8(1,1)=COT*(VKI*ROHM*AR-SI) 
      AH8(1,2)=-COT*CO+ROHM*AR*VKI*(-AM+COT*BM)
      AH8(2,2)=CO 
      AH8(2,1)=SI 
      CO=COS(OS+HIS)
      SI=SIN(OS+HIS)
      AH8(3,3)=CO 
      AH8(3,4)=SI 
      AH8(4,3)=-SI
      AH8(4,4)=CO 
      CO=VKI*CO/VL1 
      SI=VKI*SI/VL1 
      AH8(1,3)=-COT*CO
      AH8(1,4)=-COT*SI
      AH8(1,7)=VKI*COT
      AHP(1,3)=-AH8(1,7)/VL1
      IF(ETM.EQ.0.) AH8(1,7)=AH8(1,7)*SIN(OM+HIM)/ABS(SIN(OM-HIM)) 
      AHP(1,4)=AH8(1,7) 
      AHP(1,1)=AH8(1,1) 
      AHP(1,2)=AH8(1,2) 
      AHP(2,1)=AH8(2,1) 
      AHP(2,2)=AH8(2,2) 
      AHP(3,3)=1. 
      AHP(2,3)=VKI/VL1
      AH8(2,3)=CO 
      AH8(2,4)=SI 
      COT=1./TAN(OA)
      CO=VKF*COS(OS-HIS)/VL2
      SI=VKF*SIN(OS-HIS)/VL2
      AH8(5,3)=-CO*COT
      AH8(5,4)=SI*COT 
      AH8(6,3)=-CO
      AH8(6,4)=SI 
      CO=VKF*COS(OA+HIA)/VL2
      SI=VKF*SIN(OA+HIA)/VL2
      AH8(5,5)=COT*(SI-ROHA*VKF*BET)
      AH8(5,6)=-COT*CO-VKF*ROHA*BET*(XAA+COT*BA)
      AH8(5,8)=-VKF*COT 
      IF(ETA.EQ.0.) AH8(5,8)=AH8(5,8)*SIN(OA-HIA)/ABS(SIN(OA-HIA)) 
      AH8(6,5)=SI 
      AH8(6,6)=-CO
      CALL BABT(CMH,AH8,8,6,CNH)
C     THE COVARIANCE MATRIX OF THE VECTOR (DKI,KI*GAMAI,YS,XS,DKF,
C     KF*GAMAF) IS CNH(6,6) AND HAS BEEN COMPUTED 
      CALL BABT(CMHP,AHP,4,3,AUX3)
      DO 31 I=1,2 
      DO 31 J=1,2 
   31 CKI0(I,J)=AUX3(I,J) 
      COM=DETERM(AUX3,3,AU3)
c          write(*,*) 'GOTO 1 ', COM
      IF(COM.LT.0.) GO TO 10
      V1H=SQRT(COM) 
      DO 32 J=1,4 
   32 AHS(1,J)=AHP(1,J) 
      CALL BABT(CMHP,AHS,4,3,AUX3)
      COM=DETERM(AUX3,3,AU3)
c          write(*,*) 'GOTO 2 ', COM
      IF(COM.LT.0.) GO TO 10
      V0H=SQRT(COM) 
      RMH=V0H/V1H 
      DO 33 I=1,2 
      DO 33 J=1,3 
   33 AU23(I,J)=0.
      AU23(1,1)=-VKI/VL0
      AU23(1,2)=-AU23(1,1)
      AU23(2,1)=1.
      CALL BABT(CMVP,AU23,3,2,AU2)     
      COM=DETERM(AU2,2,AUX2)
c          write(*,*) 'GOTO 3 ', COM
      IF(COM.LT.0.) GO TO 10
      V0V=SQRT(COM) 
      AU23(1,1)=0.
      AU23(1,2)=-VKI/VL1
      AU23(1,3)=-AU23(1,2)
      AU23(2,1)=0.
      AU23(2,3)=1.
      CALL BABT(CMVP,AU23,3,2,AU2)
      COM=DETERM(AU2,2,AUX2)
c          write(*,*) 'GOTO 4 ', COM
      IF(COM.LT.0.) GO TO 10
      V1V=SQRT(COM) 
      CKI0(3,3)=AU2(1,1)
      RMV=V0V/V1V 
      VOLPH1=V1H*V1V*2.*PII*SQRT(2.*PII)
C     VOLPH1 IS THE PHASE VOLUME AFTER MONOCHROMATOR FOR AN INFINITELY
C     EXTENDED SAMPLE     
      ERM=RMH*RMV 
      DO 2 I=1,3
      DO 2 J=1,5
    2 AV(I,J)=0.
      AV(1,2)=VKI 
      AV(2,3)=VKF 
      AV(3,5)=1.
      CALL BABT(CM1V,AV,5,3,CNV)
C     THE COVARIANCE MATRIX OF THE VECTOR (KI*DELTAI,KF*DELTAF,ZS) IS 
C     CNV(3,3) AND HAS BEEN COMPUTED
      DO 11 I=1,2 
      DO 11 J=1,2 
   11 CKI(I,J)=CNH(I,J) 
      DO 12 I=1,2 
      CKI(I,3)=0. 
      CKF(I,3)=0. 
      CKF(3,I)=0. 
      CKI0(I,3)=0.
      CKI0(3,I)=0.
   12 CKI(3,I)=0. 
      CKI(3,3)=CNV(1,1) 
C     CKI(3,3) IS THE COVARIANCE MATRIX OF THE (DKI,KI*GAMAI,KI*DELTAI) 
C     VECTOR AND DESCRIBES THE EFFECTIVE MONOCHROMATOR ELLIPSOID
C     CKI0(3,3) IS THE SAME THING FOR AN INFINITELY EXTENDED SAMPLE 
      COM=DETERM(CKI,3,AUX3)
c          write(*,*) 'GOTO 5 ', COM
      IF(COM.LT.0.) GO TO 10
      VOLCKI=2.*PII*SQRT(2.*PII*COM)
      DO 34 I=1,2 
      DO 34 J=1,2 
      CKF(I,J)=CNH(I+4,J+4)
   34 CONTINUE
      CKF(3,3)=CNV(2,2)
C//added/////////////////////
      COM=DETERM(CKF,3,AUX3)
c          write(*,*) 'GOTO 6 ', COM
      IF(COM.LT.0.) GO TO 10
      VOLCKF=2.*PII*SQRT(2.*PII*COM)
C/////////////////////////////////
      WDTHEF=SQRT(12.*CNH(3,3)) 
      RADET=SQRT((SH(4,4)*SH(5,5)-SH(4,5)*SH(5,4))*SV(3,3)) 
      FRACV=(CMH(3,3)*CMH(4,4)-CMH(3,4)*CMH(4,3))*CMV(3,3)
c          write(*,*) 'GOTO 7 ', FRACV
      IF(FRACV.LT.0.) GO TO 10
      FRACV=RADET*SQRT(FRACV)
      IF(NSAM.GT.0) VOLSAM=WSAM*THSAM*HSAM
      IF(NSAM.EQ.0) VOLSAM=.25*PII*DIASAM*DIASAM*HSAM
      VOLEF=FRACV*VOLSAM
      ZEF=SQRT(12.*CNV(3,3))
      AREAEF=WDTHEF*ZEF 
      PATHEF=VOLEF/AREAEF 
      DO 3 I=1,4
      DO 3 J=1,6
    3 AH(I,J)=0.
      COM=COS(PHIM) 
      SIM=SIN(PHIM) 
      CO=COS(PHI) 
      SI=SIN(PHI) 
      AH(1,1)=CO
      AH(1,2)=SI
      AH(1,5)=-COM
      AH(1,6)=-SIM
      AH(2,1)=-SI 
      AH(2,2)=CO
      AH(2,5)=SIM 
      AH(2,6)=-COM
      AH(4,1)=HSQOVM*VKI
      AH(4,5)=-HSQOVM*VKF 
      CALL BABT(CNH,AH,6,4,EMMIN1)
      AV1(1,1)=1. 
      AV1(1,2)=-1.
      AV1(1,3)=0. 
      CALL BABT(CNV,AV1,3,1,X33)
      DETAS=ETS*TMR*VQ0/R8LN2
      DETAS=DETAS*DETAS
      EMMIN1(2,2)=EMMIN1(2,2)+DETAS
      EMMIN1(3,3)=X33(1,1)+DETAS
      CALL INVERT(4,EMMIN1,4,EM,4)
c      CALL INV1(EMMIN1,4,AUX4,EM) ! replaced by INVERT, J.S.
C     AT THIS MOMENT THE RESOLUTION MATRIX EM(4,4) AND ITS INVERSE, THE 
C     COVARIANCE MATRIX EMMIN1(4,4) HAVE BEEN COMPUTED. 

c      write(*,*) 'THRAX_Cov passed'     	 

      VOLRES=DETERM(EMMIN1,4,AUX4)
c          write(*,*) 'GOTO 8 ', VOLRES
      IF(VOLRES.LT.0.) GO TO 10
      VOLRES=4.*PII*PII*SQRT(VOLRES)
      DO 17 I=1,3
      DO 17 J=1,3
   17 AU3(I,J)=CNH(I,J)
      DET1=DETERM(AU3,3,AUX3) 
c          write(*,*) 'GOTO 9 ',DET1
      IF(DET1.LT.0.) GO TO 10
      DET2=CNV(1,1)*CNV(3,3)-CNV(1,3)*CNV(3,1)
      FACT=ERM
      CO=4.*PII*PII*PM*FACT 
      FLU=1.D+13     ! FLX(VKI)
      SI=SQRT(DET1)*SQRT(DET2*2.*PII)
      YSAM=FLU*CO*SI
      YSAM0=FLU*CO*VOLPH1/2./PII 
      DET1=DETERM(CNH,6,AUX6) 
c          write(*,*) 'GOTO 10 ',DET1
      IF(DET1.LE.0.D0) GO TO 10
      DET2=DETERM(CNV,3,AUX3) 
c          write(*,*) 'GOTO 11 ',DET2
      IF(DET2.LE.0.D0) GO TO 10
      R0TRAX=SQRT((2.*PII)**9)*SQRT(DET1)*SQRT(DET2)

      DET3=DETERM(CKI,3,AUX3)      
c          write(*,*) 'GOTO 12 ',DET3
      IF(DET3.LE.0.D0) GO TO 10
      
      DO I=1,5
      DO J=1,5
         IF (I.le.3.and.j.le.3) then
	    CNINI(i,j)=CNH(i,j)
	 else
	    CNINI(i,j)=0
	 endif
      END DO
      END DO
      CNINI(4,5)=CNV(1,3)
      CNINI(5,4)=CNV(3,1)
      CNINI(4,4)=CNV(1,1)
      CNINI(5,5)=CNV(3,3)
      DET4=DETERM(CNINI,5,AUX5) 
	      
      
      RELTRAX=(2*PII)**3*SQRT(DET1*DET2/DET3) 

c       write(*,*) 'THRAX_end passed ',RELTRAX,DET1,DET2,DET3     	 

c      RELTRAX=(2*PII)**2*SQRT(DET1*DET2/DET4)*10  ! cm -> mm
      DO 100 I=1,4
	  DO 100  J=1,4
  100 AAA(I,J)=EM(I,J)
      RETURN 

    7 write(smes,98)HOMEGA
   98 FORMAT(5X,'THE REQUIRED ENERGY TRANSFER,',F8.3,
     & ' MILLIEV, IS INACC ESIBLE')
      IERR=1
      return
    9 write(smes,99)VQ0
   99 FORMAT(5X,'THE REQUIRED WAVE-VECTOR TRANSFER,',F8.3,
     & ' 1/A, IS INACCESIBLE')
      IERR=1
      RETURN
   10 write(smes,95)
   95 FORMAT(5X,'ERROR IN INVERTING A MATRIX DUE TO A TOO SMALL'/5X,
     1'MOSAIC SPREAD OR COLLIMATOR DIVERGENCE')
      IERR=1
      RETURN
      END
C 

c**************************************************************
c
      SUBROUTINE SSTV
C     THIS SUBROUTINE COMPUTES THE INITIAL PROBABILITY MATRICES OF THE
C     HORIZONTAL AND VERTICAL SPATIAL VARIABLES (Y0,LM,GM,LS,GS,LA,GA,YD, 
C     CSIM,CSIA),AND (Z0,ZM,ZS,ZA,ZD)
      implicit REAL*8 (a-h,o-z) 

      INCLUDE 'trax.inc'

      COMMON/STV/SH(10,10),SH1(10,10),SV(5,5),SV1(5,5),SHP(5,5),SVP(3,3)
      DATA TWEL,SIXT/12.,16./
     
C initialization
      DO 1 I=1,10 
      DO 1 J=1,10 
    1 SH(I,J)=0.
      DO 2 I=1,5
      DO 2 J=1,5
      SHP(I,J)=0. 
    2 SV(I,J)=0.
      DO 3 I=1,3
      DO 3 J=1,3
    3 SVP(I,J)=0. 
      
C source dimensions      
      IF(NSOU.GT.0)GO TO 4
      SH(1,1)=SIXT/DIASOU/DIASOU
      SV(1,1)=SH(1,1) 
      GO TO 5 
    4 SH(1,1)=TWEL/WSOU/WSOU
      SV(1,1)=TWEL/HSOU/HSOU
      
      
C monochromator dimensions      
    5 SH(2,2)=TWEL/WMON/WMON
      SH(3,3)=TWEL/THMON/THMON
      SV(2,2)=TWEL/HMON/HMON
      DO 6 I=1,3
      DO 6 J=1,3
C copy to matrices for primary part
    6 SHP(I,J)=SH(I,J)
      SVP(1,1)=SV(1,1)
      SVP(2,2)=SV(2,2)

C sample dimensions         
      IF(NSAM.GT.0)GO TO 7
      W=SIXT/DIASAM/DIASAM
      SH(4,4)=W 
      SH(5,5)=W 
      GO TO 8 
    7 SH(4,4)=TWEL/WSAM/WSAM
      SH(5,5)=TWEL/THSAM/THSAM
    8 SV(3,3)=TWEL/HSAM/HSAM
    
C analyzer dimensions          
      SH(6,6)=TWEL/WANA/WANA
      SH(7,7)=TWEL/THANA/THANA
      SV(4,4)=TWEL/HANA/HANA
      
C mosaicities
      W=R8LN2*R8LN2 
      SH(9,9)=W/ETAMEF/ETAMEF 
      SHP(5,5)=SH(9,9)
      SH(10,10)=W/ETAAEF/ETAAEF
C detector      
      IF(NDET) 9,9,10 
    9 SH(8,8)=SIXT/DIADET/DIADET
      SV(5,5)=SH(8,8) 
      RETURN
   10 SH(8,8)=TWEL/WDET/WDET
      SV(5,5)=TWEL/HDET/HDET
      RETURN
      END 
C
c**************************************************************
c
      SUBROUTINE TRCAN(VL0,VLI,VLC,S10,S20,NF,XSHI)
      implicit REAL*8 (a-h,o-z)

       INCLUDE 'const.inc'
       INCLUDE 'inout.inc'
C      INCLUDE 'trax.inc'

C     THIS SUBROUTINE COMPUTES THE TRANSMISSION MATRIX FOR A COARSE COLL
C     IMATOR OF CIRCULAR (NF=0) OR RECTANGULAR (NF=1) CROSS SECTION 
      REAL*8 XSHI(2,2)
      DATA UN,CON1,CON2,CON3/1.D0,.866D0,1.3333D0,.6667D0/ 
      
      IF(VLC.EQ.0.) VLC=0.1
      DO 4 I=1,2
      DO 4 J=1,2
    4 XSHI(I,J)=0.D0 
      IF(VL0.LT.(VLI+VLC))GO TO 15
      ALFA=VLI/VL0
      BETA=VLC/VL0
      EPS=ALFA+BETA
      S1=S10
      S2=S20
      IF(NF)10,10,5 
    5 S1=CON1*S10 
      S2=CON1*S20 
   10 IF(VLC.EQ.0.)GO TO 30 
      Y0K=ABS(S1*EPS-S2*ALFA)/BETA
      Y0J=(EPS*S1+S2*ALFA)/BETA 
      AI0=2.*(S1/ALFA+S2/EPS)*(Y0J-Y0K)-(UN/ALFA-UN/EPS)*(Y0J**2-Y0K**2)
     1+4.*Y0K*S2/EPS
      A11=CON2*S2*Y0K**3/EPS+CON3*(S2/EPS+S1/ALFA)*(Y0J**3-Y0K**3)- 
     1.5*(UN/ALFA-UN/EPS)*(Y0J**4-Y0K**4) 
      A22=CON3*((S1/ALFA)**3+(S2/EPS)**3)*(Y0J-Y0K)-(S1**2*(UN-ALFA)/
     2ALFA**3-S2**2*(UN-EPS)/EPS**3)*(Y0J**2-Y0K**2)+CON3*(S1*(UN-ALFA
     3)**2/ALFA**3+S2*(UN-EPS)**2/EPS**3)*(Y0J**3-Y0K**3)-.1667*((UN/
     4ALFA-UN)**3-(UN/EPS-UN)**3)*(Y0J**4-Y0K**4)+CON2*Y0K*(S2/EPS)**
     53+CON2*S2*(UN-EPS)**2*(Y0K/EPS)**3
      A12=.5*((S1/ALFA)**2-(S2/EPS)**2)*(Y0J**2-Y0K**2)-CON3*(S1*(UN-
     1ALFA)/ALFA**2+S2*(UN-EPS)/EPS**2)*(Y0J**3-Y0K**3)+.25*((UN/ALFA-
     2UN)**2-(UN/EPS-UN)**2)*(Y0J**4-Y0K**4)-CON2*S2*(UN-EPS)/EPS**2*
     3Y0K**3
      X=A11/AI0
      Y=A22/AI0 
      Z=A12/AI0 
      D=X*Y-Z**2
      XSHI(1,1)=Y/D
      XSHI(2,2)=X/D
      XSHI(1,2)=-Z/D 
      XSHI(2,1)=XSHI(1,2) 
      
      GO TO 25
   30 XMO=S1*S1/12.
      XSHI(1,1)=(UN-ALFA)**2/XMO 
      XSHI(2,2)=ALFA**2/XMO
      XSHI(1,2)=ALFA*(UN-ALFA)/XMO 
      XSHI(2,1)=XSHI(1,2) 
      GO TO 25
   15 write(smes,20)
   20 FORMAT(2X,'WRONG INPUT DATA; THE PRESENCE OF THIS COLLIMATOR',
     &' IS IGNORED') 
   25 RETURN
      END 
C
                                                      
c**************************************************************

      SUBROUTINE TCR
C     COMPUTES THE PROBABILITY MATRICES OF THE SPATIAL VARIABLES AS 
C     MODIFIED BY THE BRAGG CONSTRAINTS, NEUTRON GUIDE, SOLLER
C     COLLIMATORS AND COARSE COLLIMATORS OR SLITS
      implicit REAL*8 (a-h,o-z) 

      INCLUDE 'trax.inc'

      REAL*8 XDH(4,10),XGH(10,8),TV(2,5),ACO(4,4),XF(2,2),
     & DV1(4,5),CAN(10,10),VCAN(5,5),XSHI(2,2),AH8(8,8),TV1(1,3),
     & CANP(5,5),VCANP(3,3),DHP(2,5),ACOP(2,2),DVP(2,3),GHP(5,4),XF1(1)
      COMMON/STV/SH(10,10),SH1(10,10),SV(5,5),SV1(5,5),SHP(5,5),SVP(3,3)
      COMMON /QEF/PATHEF,WDTHEF,AREAEF,ZEF
      COMMON /CTR/DV(5,5),BM,BA,AHS(3,4)
      COMMON /COVAR/CMH(8,8),CMV(5,5),CMHP(4,4),CMVP(3,3) 

C1    FORMAT(a,10(G10.4,2x))
 
      DO 111 I=1,10 
      DO 111 J=1,10 
      SH1(I,J)=SH(I,J)
  111 CAN(I,J)=0.
      DO 112 I=1,5
      DO 112 J=1,5
      CANP(I,J)=0.
      SV1(I,J)=SV(I,J)
  112 VCAN(I,J)=0.
      DO 110 I=1,2
      DO 110 J=1,5
  110 DHP(I,J)=0. 
      DO 113 I=1,3
      DO 113 J=1,3
  113 VCANP(I,J)=0. 
      DO 116 I=1,3
      DO 116 J=1,4
  116 AHS(I,J)=0. 


      IF(NFM.LT.0)GO TO 15
      CALL TRCAN(VL0,VLCANM,VLSM,HDM1,HDM2,NFM,XSHI) 
      CO=COS(OM+HIM)
      SI=SIN(OM+HIM)
      CAN(1,1)=XSHI(1,1)
      CAN(1,2)=XSHI(1,2)*SI
      CAN(1,3)=-XSHI(1,2)*CO 
      CAN(2,2)=XSHI(2,2)*SI*SI 
      CAN(2,3)=-XSHI(2,2)*CO*SI
      CAN(3,3)=XSHI(2,2)*CO*CO 
      CAN(2,1)=CAN(1,2)
      CAN(3,1)=CAN(1,3)
      CAN(3,2)=CAN(2,3)
      CALL TRCAN(VL0,VLCANM,VLSM,VDM1,VDM2,NFM,XSHI) 
c      write(*,1) 'VL0: ',VL0,VLCANM,VLSM,VDM1,VDM2,NFM,XSHI
      VCAN(1,1)=XSHI(1,1)
      VCAN(2,2)=XSHI(2,2)
      VCAN(1,2)=XSHI(1,2)
      VCAN(2,1)=VCAN(1,2)
      DO 114 I=1,3
      DO 114 J=1,3
      VCANP(I,J)=VCAN(I,J)
  114 CANP(I,J)=CAN(I,J)
   15 IF(NFS.LT.0)GO TO 20
      CO=COS(OM-HIM)
      SI=SIN(OM-HIM)
      A=COS(OS+HIS)
      B=SIN(OS+HIS)
      CALL TRCAN(VL1,VLCANS,VLMS,HDS1,HDS2,NFS,XSHI) 
      CAN(2,2)=CAN(2,2)+XSHI(1,1)*SI*SI
      CAN(3,3)=CAN(3,3)+XSHI(1,1)*CO*CO
      CAN(2,3)=CAN(2,3)+XSHI(1,1)*SI*CO
      CAN(3,2)=CAN(2,3)
      CANP(4,4)=XSHI(2,2)
      CAN(4,4)=XSHI(2,2)*A*A 
      CAN(5,5)=XSHI(2,2)*B*B 
      CAN(4,5)=XSHI(2,2)*A*B 
      CAN(5,4)=CAN(4,5)
      CAN(2,4)=CAN(2,4)-XSHI(1,2)*SI*A 
      CAN(4,2)=CAN(2,4)
      CAN(2,5)=CAN(2,5)-XSHI(1,2)*SI*B 
      CAN(5,2)=CAN(2,5)
      CAN(3,4)=CAN(3,4)-XSHI(1,2)*CO*A 
      CAN(4,3)=CAN(3,4)
      CAN(3,5)=CAN(3,5)-XSHI(1,2)*CO*B 
      CAN(5,3)=CAN(3,5)
      CALL TRCAN(VL1,VLCANS,VLMS,VDS1,VDS2,NFS,XSHI) 
c      write(*,1) 'VL1: ',VL1,VLCANS,VLMS,VDS1,VDS2,NFS,XSHI
      VCAN(2,2)=VCAN(2,2)+XSHI(1,1)
      VCAN(3,3)=XSHI(2,2)
      VCAN(2,3)=XSHI(1,2)
      VCAN(3,2)=VCAN(2,3)
      DO 115 I=1,3
      DO 115 J=1,3
      CANP(I,J)=CAN(I,J)
  115 VCANP(I,J)=VCAN(I,J)
   20 IF(NFA.LT.0)GO TO 25
      CO=COS(OA+HIA)
      SI=SIN(OA+HIA)
      A=COS(OS-HIS)
      B=SIN(OS-HIS)
      CALL TRCAN(VL2,VLCANA,VLSA,HDA1,HDA2,NFA,XSHI) 
      CAN(4,4)=CAN(4,4)+XSHI(1,1)*A*A
      CAN(5,5)=CAN(5,5)+XSHI(1,1)*B*B
      CAN(4,5)=CAN(4,5)-XSHI(1,1)*A*B
      CAN(5,4)=CAN(4,5)
      CAN(6,6)=XSHI(2,2)*SI*SI 
      CAN(7,7)=XSHI(2,2)*CO*CO 
      CAN(6,7)=-XSHI(2,2)*SI*CO
      CAN(7,6)=CAN(6,7)
      CAN(4,6)=CAN(4,6)+XSHI(1,2)*SI*A 
      CAN(6,4)=CAN(4,6)
      CAN(4,7)=CAN(4,7)-XSHI(1,2)*A*CO 
      CAN(7,4)=CAN(4,7)
      CAN(5,6)=CAN(5,6)-XSHI(1,2)*SI*B 
      CAN(6,5)=CAN(5,6) 
      CAN(5,7)=CAN(5,7)+XSHI(1,2)*CO*B 
      CAN(7,5)=CAN(5,7)
      CALL TRCAN(VL2,VLCANA,VLSA,VDA1,VDA2,NFA,XSHI) 
c      write(*,1) 'VL2: ',VL2,VLCANA,VLSA,VDA1,VDA2,NFA,XSHI
      VCAN(3,3)=VCAN(3,3)+XSHI(1,1)
      VCAN(4,4)=VCAN(4,4)+XSHI(2,2)
      VCAN(3,4)=XSHI(1,2)
      VCAN(4,3)=VCAN(3,4)
   25 IF(NFD.LT.0)GO TO 30
      CALL TRCAN(VL3,VLCAND,VLAD,HDD1,HDD2,NFD,XSHI)
      CO=COS(OA-HIA)
      SI=SIN(OA-HIA)
      CAN(6,6)=CAN(6,6)+XSHI(1,1)*SI*SI
      CAN(7,7)=CAN(7,7)+XSHI(1,1)*CO*CO
      CAN(6,7)=CAN(6,7)+XSHI(1,1)*SI*CO
      CAN(7,6)=CAN(6,7)
      CAN(8,8)=XSHI(2,2)
      CAN(6,8)=-XSHI(1,2)*SI 
      CAN(8,6)=CAN(6,8)
      CAN(7,8)=-XSHI(1,2)*CO 
      CAN(8,7)=CAN(7,8)
      CALL TRCAN(VL3,VLCAND,VLAD,VDD1,VDD2,NFD,XSHI)
c      write(*,1) 'VL3: ',VL3,VLCAND,VLAD,VDD1,VDD2,NFD,XSHI
      VCAN(4,4)=VCAN(4,4)+XSHI(1,1)
      VCAN(5,5)=XSHI(2,2)
      VCAN(4,5)=XSHI(1,2)
      VCAN(5,4)=VCAN(4,5)
   30 CALL SUM(SH,CAN,10,SH1) 
      CALL SUM(SV,VCAN,5,SV1) 
      CALL SUM(SHP,CANP,5,SHP)
      CALL SUM(SVP,VCANP,3,SVP) 
C     THE PRESENCE OF COARSE COLLIMATORS OR SLITS WAS ACCOUNTED FOR

      DO 1001 I=1,4
      DO 1001 J=1,10 
1001    XDH(I,J)=0.
      DO 2 I=1,5
      DO 2 J=1,5
    2 DV(I,J)=0.
      DO 3 I=1,10 
      DO 3 J=1,8
    3 XGH(I,J)=0.
      XGH(2,1)=1.
      XGH(3,2)=1.
      XGH(4,3)=1.
      XGH(5,4)=1.
      XGH(6,5)=1.
      XGH(7,6)=1.
      XGH(9,7)=1.
      XGH(10,8)=1. 
      CO=COS(OM+HIM)
      SI=SIN(OM+HIM)

      SSS=ABS(SI)/SI
      A=1./VL0
      XDH(1,1)=-A
      XDH(1,3)=-A*CO 
      XDH(1,2)=A*SI
      DV(1,1)=-A
      DV(1,2)=A 
      A=1./VL1
      XGH(1,1)=SI-2.*VL0*ROHM*SSS 
      XGH(1,2)=-CO-2.*VL0*BM*ROHM*SSS 
      CO=COS(OM-HIM)
      SI=SIN(OM-HIM)
      XDH(2,3)=A*CO
      XDH(2,2)=A*SI
      DV(2,2)=-A
      DV(2,3)=A 
      XGH(1,1)=XGH(1,1)+VL0*A*SI
      XGH(1,2)=XGH(1,2)+VL0*A*CO
      CO=COS(OS+HIS)
      SI=SIN(OS+HIS)
      XDH(2,5)=A*SI
      XDH(2,4)=A*CO
      DHP(2,4)=A
      A=VL0*A
      XGH(1,3)=A*CO
      XGH(1,4)=A*SI
      CO=COS(OS-HIS)
      SI=SIN(OS-HIS)
      A=1./VL2
      XDH(3,5)=A*SI
      XDH(3,4)=-A*CO 
      DV(3,3)=-A
      DV(3,4)=A 
      XGH(8,3)=A*VL3*CO
      XGH(8,4)=-A*VL3*SI
      CO=COS(OA+HIA)
      SI=SIN(OA+HIA)

      SSS=ABS(SI)/SI
      XDH(3,7)=-A*CO 
      XDH(3,6)=A*SI
      XGH(8,5)=-VL3*A*SI+2.*VL3*ROHA*SSS
      XGH(8,6)=VL3*A*CO+2.*VL3*BA*ROHA*SSS
      A=1./VL3
      CO=COS(OA-HIA)
      SI=SIN(OA-HIA)
      XDH(4,7)=A*CO
      XDH(4,6)=A*SI
      XDH(4,8)=A 
      DV(4,4)=-A
      DV(4,5)=A 
      DV(5,3)=1.
      XGH(8,5)=XGH(8,5)-SI
      XGH(8,6)=XGH(8,6)-CO
      XGH(1,7)=-2.*VL0 
      IF(ETM.EQ.0.) XGH(1,7)=XGH(1,7)*SIN(HIM)*COS(OM)/ABS(SIN(OM-HIM))
      XGH(8,8)=2.*VL3
      IF(ETA.EQ.0.) XGH(8,8)=XGH(8,8)*SIN(HIA)*COS(OA)/ABS(SIN(OA-HIA))
      DO 16 I=1,5 
      DO 16 J=1,4 
   16 GHP(I,J)=XGH(I,J)
      GHP(1,3)=VL0/VL1
      GHP(1,4)=XGH(1,7)
      A=R8LN2*R8LN2 

      IF(ETM.NE.0.)XF(1,1)=A/ETVMEF/ETVMEF
      IF(ETM.EQ.0.)XF(1,1)=A/ETAMEF/ETAMEF*ABS(SIN(OM-HIM)/SIN(OM+HIM)) 
      IF(ETA.NE.0.)XF(2,2)=A/ETVAEF/ETVAEF
      IF(ETA.EQ.0.)XF(2,2)=A/ETAAEF/ETAAEF*ABS(SIN(OA-HIA)/SIN(OA+HIA)) 
      XF(1,2)=0. 
      XF(2,1)=0. 
      DO 4 J=1,5
      TV(1,J)=.5*(DV(1,J)-DV(2,J))/SIN(OM)
    4 TV(2,J)=.5*(DV(3,J)-DV(4,J))/SIN(OA)

      TV(1,2)=TV(1,2)-ROVM*ABS(OM)/OM*ABS(COS(HIM)) 
      TV(2,4)=TV(2,4)-ROVA*ABS(OA)/OA*ABS(COS(HIA)) 
      CALL BTAB(XF,TV,2,5,VCAN)
      CALL SUM(SV1,VCAN,5,SV1)
      DO 18 J=1,3 
   18 TV1(1,J)=TV(1,J)
      XF1(1)=XF(1,1)
      CALL BTAB(XF1,TV1,1,3,VCANP) 
      CALL SUM(SVP,VCANP,3,SVP) 
      DO 5 I=1,4
      DO 5 J=1,4
    5 ACO(I,J)=0. 
      CO=0. 
      IF(NGUIDE.NE.0) SI=3./(GAMACR*SLAMDI)**2
      DO 6 I=1,4
      CO=CO+ALPHA(I)
    6 IF(ALPHA(I).NE.0.) ACO(I,I)=A/ALPHA(I)/ALPHA(I)/TMR/TMR 
      IF(NGUIDE.NE.0) ACO(1,1)=ACO(1,1)+SI
      CO=CO+NGUIDE
      IF(CO.EQ.0.) GO TO 7
      CALL BTAB(ACO,XDH,4,10,CAN)
      CALL SUM(SH1,CAN,10,SH1)
      CO=0. 
      ACOP(1,2)=0.
      ACOP(2,1)=0.
      DO 11 I=1,2 
      CO=CO+ALPHA(I)
   11 ACOP(I,I)=ACO(I,I)
      CO=CO+NGUIDE
      IF(CO.EQ.0.) GO TO 7
      DO 13 I=1,2 
      DO 13 J=1,3 
   13 DHP(I,J)=XDH(I,J)
      CALL BTAB(ACOP,DHP,2,5,VCAN)
      CALL SUM(SHP,VCAN,5,SHP)
    7 DO 9 I=1,4
      DO 9 J=1,4
    9 ACO(I,J)=0. 
      CO=0. 
      DO 10 I=1,4 
      CO=CO+BETA(I) 
   10 IF(BETA(I).NE.0.) ACO(I,I)=A/BETA(I)/BETA(I)/TMR/TMR
      IF(NGUIDE.NE.0) ACO(1,1)=ACO(1,1)+SI
      CO=CO+NGUIDE
      IF(CO.EQ.0.)GO TO 8 
      DO 12 I=1,4
      DO 12 J=1,5
   12 DV1(I,J)=DV(I,J)
      CALL BTAB(ACO,DV1,4,5,VCAN) 
      CALL SUM(SV1,VCAN,5,SV1)
      CO=0. 
      DO 14 I=1,2 
      CO=CO+BETA(I) 
   14 ACOP(I,I)=ACO(I,I)
      CO=CO+NGUIDE
      IF(CO.EQ.0.) GO TO 8
      DO 17 I=1,2 
      DO 17 J=1,3 
   17 DVP(I,J)=DV(I,J)
      CALL BTAB(ACOP,DVP,2,3,VCANP) 
      CALL SUM(SVP,VCANP,3,SVP) 
    8 CONTINUE
      DO 117 J=1,4
      AHS(3,J)=GHP(1,J) 
  117 AHS(2,J)=-VKI/VL0*GHP(1,J)
      AHS(2,1)=AHS(2,1)+VKI/VL0*SIN(OM+HIM) 
      AHS(2,2)=AHS(2,2)-VKI/VL0*COS(OM+HIM) 
      CALL BTAB(SHP,GHP,5,4,ACO)
      CALL INVERT(4,ACO,4,CMHP,4)
c      CALL INV1(ACO,4,AU4,CMHP) ! replaced by INVERT, J.S.
C     SOLLER COLLIMATORS AND NEUTRON GUIDE HAVE BEEN ACCOUNTED FOR
      CALL BTAB(SH1,XGH,10,8,AH8)
      CALL INVERT(8,AH8,8,CMH,8)
c      CALL INV1(AH8,8,AU8,CMH) ! ! replaced by INVERT, J.S.
      CALL INVERT(5,SV1,5,CMV,5)
c      CALL INV1(SV1,5,VCAN,CMV) ! ! replaced by INVERT, J.S.
      CALL INVERT(3,SVP,3,CMVP,3)
c      CALL INV1(SVP,3,VCANP,CMVP) ! ! replaced by INVERT, J.S.

c      write(*,1) 'SVP: ',SVP
c      write(*,1) 'VCANP: ',VCANP
c      write(*,1) 'CMVP: ',CMVP
C     BRAGG CONSTRAINTS HAVE BEEN ACCOUNTED FOR
C     CMH AND CMV ARE THE MODIFIED COVARIANCE MATRICES OF THE 
C     INDEPENDENT VARIABLES (HORIZONTAL AND VERTICAL, RESPECTIVELY) 
      RETURN
      END 
	 

c**************************************************************
c
      SUBROUTINE HIRANG(OB,HII,HI)
C     MAKES SURE THAT THE CRYSTAL INCLINATION ANGLE IS IN THE CORRECT
C     RANGE (MINUS TETA BRAGG TO PI MINUS TETA BRAGG FOR POSITIVE TETA,
C     MINUS PI MINUS TETA BRAGG TO MINUS TETA BRAGG FOR NEGATIVE TETA)
      
      implicit REAL*8 (a-h,o-z)

      INCLUDE 'trax.inc'

      HI=TDR*HII
      IF(OB.LT.0.) GO TO 1
      IF(HI.LT.(-OB)) HI=HI+PII
      IF(HI.GT.(PII-OB)) HI=HI-PII
      GO TO 2
    1 IF(HI.LT.(-PII-OB)) HI=HI+PII
      IF(HI.GT.(-OB)) HI=HI-PII
    2 HII=HI/TDR
      RETURN
      END    

C
	SUBROUTINE VANAD(A,DVN,YVN)
C***********************************************************************
C   returns Vanad scan width and intensity (in rel. units)
C   added by J.S. 3/6/1997
C***********************************************************************
	IMPLICIT NONE
      INCLUDE 'trax.inc'
	REAL*8 A(4,4),EMMIN1(4,4),VOLRES,AUX(4,4)
	REAL*8 DVN,YVN
	COMMON /EM/EMMIN1,VOLRES
       
        CALL INVERT(4,A,4,AUX,4)           
        DVN=R8LN2*SQRT(AUX(4,4))
        	
	YVN=R0TRAX/SQRT(EMMIN1(4,4))	! intensity in rel. units
	END
	
C
	REAL*4 FUNCTION OPTV(RO)
C***********************************************************************
C   returns value to be minimized when optimizing bending radii
C   added by J.S. 3/6/1997
C***********************************************************************
      IMPLICIT REAL*8 (A-H,O-Z)

      INCLUDE 'trax.inc'
      DIMENSION A(4,4)	
      COMMON /MATRIX/A

      PARAMETER(EPS=1.D-30)
      REAL*4 RO(4),B(4)	
		
	B(1)=ROHM
	B(2)=ROVM
	B(3)=ROHA
	B(4)=ROVA
        ROHM=RO(1)/100
	ROVM=RO(2)/100
	ROHA=RO(3)/100
	ROVA=RO(4)/100

	CALL THRAX
	CALL VANAD(A,DVN,YVN)
	IF (ABS(YVN).GE.EPS) THEN
	  OPTV=DVN*DVN/YVN
	ELSE
	   OPTV=0.
	ENDIF   
c        write(*,*) DVN*DVN/YVN,DVN,YVN

	ROHM=B(1)
	ROVM=B(2)
	ROHA=B(3)
	ROVA=B(4)	
      END
	
	
      

      
      
      
      
      

