C//////////////////////////////////////////////////////////////////////
C////
C////  R E S T R A X   4.8
C////
C////  Graphics output subroutines (PGPlot library required)
C////  LEVEL 1 subroutines:
C////  RESOLUTION FUNCTIONS, SCAN DATA 
C//////////////////////////////////////////////////////////////////////
        
C************************* RESOLUTION FUNCTIONS ********************************

C----------------------------------------------------------------------
      SUBROUTINE SAVEGRFDATA(PORT,X,Y,N,comment)
C     save data for the graph
C----------------------------------------------------------------------
      IMPLICIT NONE
      
      INCLUDE 'const.inc'
      INCLUDE 'inout.inc'
      INCLUDE 'res_grf.inc'
      
      INTEGER*4 N, I_IO,i,IRES    
!      REAL*4 X(*),Y(*)
      REAL*4 X(N),Y(N)
      character*72 fname
      character*(*) comment
      RECORD /VIEWSET/ PORT
      
1     FORMAT(a)
4     FORMAT(1x,4(2x,G13.5))
12    format(a50)
13    FORMAT(' output filename: ',$)
      
      IF (TOPRINT.EQ.1) RETURN  ! no file output when printing
      I_IO=22
      fname=' '
      CALL DLG_FILESAVE(fname,' ','dat',1,0,ires,fname)
      IF (IRES.GT.0) THEN
        Open(Unit=i_IO,File=fname,err=999,Status='Unknown')
        write(i_io,1,err=998) PORT.HEAD
        WRITE(i_io,*) trim(comment)
        write(i_io,1,err=998) PORT.XTIT//'  '//PORT.YTIT
        do i=1,N
          write(i_IO,4,err=998) X(I),Y(I)
        enddo  
998     close(i_io)
      ENDIF
      return
      
999   write(smes,*) 'Cannot open output  file as unit ',i_IO      
      return      
      END

C----------------------------------------------------------------------      
      SUBROUTINE VIEWSCAN
C Plot R(Q,w) in given direction (integrate over others)
C ITASK is taken from GRFARG(1) array item:
C   ITASK=1 ... QH
C   ITASK=2 ... QK
C   ITASK=3 ... QL
C   ITASK=4 ... EN
C   ITASK=5 ... KF
C   ITASK=6 ... Delta(Phi)=spin-echo phase shift
C----------------------------------------------------------------------      
      IMPLICIT NONE

      INCLUDE 'const.inc'
      INCLUDE 'inout.inc'
      INCLUDE 'restrax.inc'
      INCLUDE 'res_grf.inc'

      REAL*8 YMAX
      INTEGER*4  I,ITASK
      INTEGER*4 NN      
      REAL*4 XX(65),YY(65)
      REAL*8 suma,center,fwhm,wspread
      RECORD /VIEWSET/ PORT
      CHARACTER*20 IND(6)
      character*55 comment
      DATA IND/'Q\dX\u [\A\u-1\d] ','Q\dY\u [\A\u-1\d] ',
     *'Q\dZ\u [\A\u-1\d] ','\gDE  meV ','k\df\u [\A\u-1\d] ','\gD\gf'/

14    FORMAT('fwhm: ',G10.3,' spread: ',G10.3,' center: ',G10.3)
15    FORMAT('SE resolution: ',G10.4,' [ueV]')      

      ITASK=NINT(GRFARG(1))
      IF (ITASK.LE.0.OR.ITASK.GT.6) ITASK=4 ! do scan along kf as default

      NN=25
      CALL RES_SCAN(ITASK,XX,YY,NN,suma,center,fwhm,wspread)
      
      PORT.XTIT=IND(ITASK)
      PORT.YTIT=' counts '
      PORT.HEAD=' R(Q,\gw) profile '
      IF (ITASK.EQ.6) PORT.HEAD=' Precession phase distribution '
            
      YMAX=0
      DO I=1,NN
          YMAX=MAX(YMAX,1.D0*YY(I))
      ENDDO
      IF (YMAX.LT.1E-10) YMAX=1E-10
      comment=' '
      WRITE(sout,14) fwhm,wspread,center
      WRITE(comment,14) fwhm,wspread,center
      PORT.DX1=0.1
      PORT.DX2=0.9
      PORT.DY1=0.3
      PORT.DY2=0.8
      PORT.WX1=XX(1)
      PORT.WX2=XX(NN)
      PORT.WY1=0.
      PORT.WY2=YMAX*1.1
      CALL PlotCurve(PORT,XX,YY,NN,2,4,1)
      CALL PGSLW(2)
      CALL PGSCH(1.0)      
      CALL PGSCI(1) 
      CALL PGMTEXT('B',10.,-0.05,0.0,comment)
      CALL PGIDEN
c      CALL SAVEGRFDATA(PORT,XX,YY,NN,comment)
      IF (ITASK.EQ.6) THEN
        WRITE(sout,15) fwhm*HBAR/STP.TAUF*1000
      ENDIF
      END

C----------------------------------------------------------------------      
      SUBROUTINE RES_SCAN(ITASK,XX,YY,NN,suma,center,fwhm,wspread)
C Makes a scan through R(Q,w) in given direction (integrate over others)
C   ITASK=1 ... QH
C   ITASK=2 ... QK
C   ITASK=3 ... QL
C   ITASK=4 ... EN
C   ITASK=5 ... KF
C   ITASK=6 ... Delta(Phi)=spin-echo phase shift
C OUTPUT:
C   XX(NN),YY(NN) ... arrays with scan variable and intensity
C----------------------------------------------------------------------      
      IMPLICIT NONE

      INCLUDE 'const.inc'
      INCLUDE 'inout.inc'
      INCLUDE 'restrax.inc'
      
      INTEGER*4 NN      
      REAL*4 XX(NN),YY(NN)

      REAL*4 XMIN(4),XMAX(4)
      REAL*8 X(4),P,Z,DX,KF
      INTEGER*4  IX,I,J,NH0,NPH,ITASK
      REAL*8 suma,center,fwhm,wspread,PHI

14    FORMAT('fwhm: ',G10.3,' spread: ',G10.3,' center: ',G10.3)
15    FORMAT('SE resolution: ',G10.4,' [ueV]')


      CALL KSTACK_N(NPH,mf_cur)
      IF(NPH.LE.0) THEN
           write(smes,*) ' M.C. events not generated !'           
           RETURN
      ENDIF

      NH0=(NN+1)/2
      DO I=1,NN
          XX(I)=(I-NH0)
          YY(I)=0.
      END DO      
      
      IF (ITASK.GE.1.AND.ITASK.LE.4) THEN
         IX=ITASK
         CALL GETMSCALE(XMIN,XMAX)
         DX=(XMAX(IX)-XMIN(IX))/NN
         IF (DX.LE.1E-10) RETURN
         DO i=1,NPH
             CALL GETQE(I,mf_cur,X,P)
             Z=X(IX)-XMIN(IX)
             J=INT(Z/DX)+1
             IF((J.GE.1).AND.(J.LE.NN)) THEN
                YY(J)=YY(J)+P
             ENDIF
         END DO
      ELSE IF (ITASK.EQ.5) THEN
         IX=1
         XMIN(IX)=+1E+10
         XMAX(IX)=-1E+10
         DO I=1,NPH
             CALL KSTACK_KF(I,mf_cur,KF,P)
             XMIN(IX)=MIN(1.D0*XMIN(IX),KF)
             XMAX(IX)=MAX(1.D0*XMAX(IX),KF)
         END DO
         DX=(XMAX(IX)-XMIN(IX))/NN
         XMIN(IX)=XMIN(IX)-DX
         XMAX(IX)=XMAX(IX)+DX
         DX=(XMAX(IX)-XMIN(IX))/NN
         IF (DX.LE.1E-10) RETURN
         DO i=1,NPH
             CALL KSTACK_KF(I,mf_cur,KF,P)
             Z=KF-XMIN(IX)
             J=INT(Z/DX)+1
             IF((J.GE.1).AND.(J.LE.NN)) THEN
                YY(J)=YY(J)+P
             ENDIF
         END DO
      ELSE IF (ITASK.EQ.6) THEN
         IX=1
         XMIN(IX)=+1E+10
         XMAX(IX)=-1E+10
         DO I=1,NPH
             CALL KSTACK_PHI(I,mf_cur,PHI,P)
             XMIN(IX)=MIN(1.D0*XMIN(IX),PHI)
             XMAX(IX)=MAX(1.D0*XMAX(IX),PHI)
         END DO
         DX=(XMAX(IX)-XMIN(IX))/NN
         XMIN(IX)=XMIN(IX)-DX
         XMAX(IX)=XMAX(IX)+DX
         DX=(XMAX(IX)-XMIN(IX))/NN
         IF (DX.LE.1E-10) RETURN
         DO i=1,NPH
             CALL KSTACK_PHI(I,mf_cur,PHI,P)
             Z=PHI-XMIN(IX)
             J=INT(Z/DX)+1
             IF((J.GE.1).AND.(J.LE.NN)) THEN
                YY(J)=YY(J)+P
             ENDIF
         END DO
      ENDIF

      DO I=1,NN
          XX(I)=(I-1+0.5)*DX+XMIN(IX)
      ENDDO
      CALL GETPEAKPARAM(XX,YY,NN,suma,center,fwhm,wspread)

      END


C----------------------------------------------------------------------      
      SUBROUTINE RES_IMAGE(ID)
C Plot R(Q,E) for dataset(s) projected on a specified plane in 
C (h,k,l,E) space. Asks for the projection plane interactively.
C INPUT:
C   ID    ... dataset index, if=0 then merge all data sets
C----------------------------------------------------------------------            
      implicit none
      INCLUDE 'const.inc'
      INCLUDE 'inout.inc'
      INCLUDE 'res_grf.inc'
     
      integer*4 ID,NIMA
      PARAMETER(NIMA=128)
      REAL*4 AIMA(NIMA,NIMA)     
      character*16 labels
      character*50 comment
      integer*4 IX,IY,I,J,I_IO,IS,IL,IS1,IL1
      REAL*8 XMAX,YMAX,XMIN,YMIN
  
      DATA labels/'h:k:l:dE [meV]'/
      
9     FORMAT(128(1x,G10.4))
13    format('scale (',G12.5,',',G12.5,',',G12.5,',',G12.5,')')

C// graph attributes are taken from GRFARG array above index=40
      IX=NINT(GRFARG(1))
      IY=NINT(GRFARG(2))
      xmin=GRFARG(3)
      xmax=GRFARG(4)
      ymin=GRFARG(5)
      ymax=GRFARG(6)
      comment=GRFSTR
        
      CALL MRES_ALL(ID,IX,IY,XMIN,XMAX,YMIN,YMAX,comment,AIMA,NIMA)
           
      IF (TOPRINT.EQ.1) RETURN ! dont save ASCII data when printing
      if (grfsave.ge.2) then 
        I_IO=25
        close(i_io)
        Open(Unit=i_IO,File='res_2d.dat',err=999,Status='Unknown')
        CALL FINDSTRPAR(labels,':',IX,IS,IL)
        CALL FINDSTRPAR(labels,':',IY,IS1,IL1)
        write(i_io,*)'projection ('//labels(IS:IS+IL-1)//', '
     &  //labels(IS1:IS1+IL1-1)//')'
        write(i_io,13) xmin,xmax,ymin,ymax                  
        do i=1,nima
          write(i_IO,9) (AIMA(i,j),j=1,nima)
        enddo
        close(i_io) 
        return      
999     write(*,*) 'Cannot open file as unit ',i_IO      
        return
      endif           

      end

C--------------------------------------------------------------------     
      SUBROUTINE AB_IMAGE(ICOM)
C Plot projections on the scattering plane (for flatcone arrangement) 
C Asks for scale and comment string, calculates range and calls AB_MAP
C   ICOM  ... as in AB_MAP
C--------------------------------------------------------------------            
      implicit none
      INCLUDE 'const.inc'
      INCLUDE 'inout.inc'
      INCLUDE 'lattice.inc'
      INCLUDE 'rescal.inc'
      INCLUDE 'restrax.inc'
      INCLUDE 'res_grf.inc'
     
      
      integer*4 NIMA
      PARAMETER(NIMA=128)
      REAL*4 AIMA(NIMA,NIMA)     
      character*50 S,fname
      character*128 comment
      integer*4 I,J,I_IO,ICOM
      REAL*8 XMAX,YMAX,XMIN,YMIN,scale,AUX(4),dx,dy
      DATA scale /1.D0/

1     FORMAT(128(1x,G10.4))
2     format('scale (',G10.4,',',G10.4,'),(',G10.4,',',G10.4,')')

      comment=GRFSTR          
      scale=GRFARG(1)
      if (scale.LT.0.01.OR.scale.GT.100) scale=1.
      if (ICOM.EQ.ig_SQMAP) THEN 
        call M4xV4_3(MABR,RES_DAT(i_QH),AUX)
        xmin=AUX(1)-scale/2.
        xmax=AUX(1)+scale/2.
        ymin=AUX(2)-scale/2.
        ymax=AUX(2)+scale/2.
      else  
c      write(*,*) 'FCONE_RANGE'  
        CALL FCONE_RANGE(xmin,xmax,ymin,ymax,.TRUE.) 
        dx=(scale-1.0)*(xmax-xmin)/2.
        dy=(scale-1.0)*(ymax-ymin)/2.       
        xmin=xmin-dx
        xmax=xmax+dx
        ymin=ymin-dy
        ymax=ymax+dy
c      write(*,*) 'FCONE_RANGE done'  
      endif
      write(*,2)  xmin,xmax,ymin,ymax         
22    CALL AB_MAP(XMIN,XMAX,YMIN,YMAX,comment,AIMA,NIMA,ICOM)
      
      if (grfsave.ge.2) then 
C// write map to a default ASCII file
        if (ICOM.EQ.ig_FCRES) THEN
           FNAME='fcres_2d.dat'
        else  if (ICOM.EQ.ig_FCDATA) THEN 
           FNAME='fcdata_2d.dat'
        else  if (ICOM.EQ.ig_SQMAP) THEN 
           FNAME='sqmap_2d.dat'
        endif                  
        I_IO=25
        close(i_io)
        Open(Unit=i_IO,File=fname,err=999,Status='Unknown')
        CALL FORMAT_HKL(mf_par(i_AX,1),S,50)
        write(i_io,*) 'x-axis :',S
        CALL FORMAT_HKL(mf_par(i_BX,1),S,50)
        write(i_io,*) 'y-axis :',S
        write(i_io,2) xmin,xmax,ymin,ymax      
        write(i_io,*) comment      
        do j=1,nima
          write(i_IO,1) (AIMA(i,j),i=1,nima)
        enddo
        close(i_io)           
        return      
999     write(*,*) 'Cannot open file as unit ',i_IO      
        return
      endif
      end
      
C--------------------------------------------------------------------
      SUBROUTINE PlotResol(PORT,ICOM)
C Plot Resolution function + dispersion branches on the given viewport
C Resolution function is plotted with x-axis parallel to GH,GK,GL and 
C y-axis along energy transfer.      
C The kind of R(Q,E) representation depends on the  SWRAYTR and WHATHIS switches
C  PORT         ... plotting viewport
C  ICOM=1       ... show an ellipse instead of a cloud for ray-tracing resolution
C CALLS: GetProj,GETSCALE,FILARRAY,
C CALLED BY: PAGE2
C--------------------------------------------------------------------
      IMPLICIT NONE
      
      INCLUDE 'const.inc'
      INCLUDE 'inout.inc' 
      INCLUDE 'rescal.inc'
      INCLUDE 'restrax.inc'
      INCLUDE 'res_grf.inc'
      INCLUDE 'exciimp.inc'
      
      RECORD /MODEL/ rm
      
      INTEGER*4 NIMA,NLINE
      PARAMETER(NIMA=64,NLINE=31)
      
      RECORD /VIEWSET/ PORT
      CHARACTER*60 LEG1,LEG2,comment
      character*3 chind(3)
      REAL*8 EN,DE
      REAL*8  A(4,4),A1(4,4),MCN(4,4)
      REAL*8  AZERO(4),ZERO(4),RZERO(4),V6(6),W6(6),QEN(4),AUX(4)
      REAL*8 GNR,GNA,SHX,SHY
      REAL*4  AIMA(NIMA,NIMA)
      REAL*4  XFX(NLINE),FY(NLINE),XL(2),YL(2),X1,X2,Y1,Y2,rx
      INTEGER*4 ICOM,I,J,K,IB,NP, IERR,IBH,NH1
      REAL*8 CENTRE,RANGE,Z
      LOGICAL*4 ESCAN
      REAL*8 QxQ
      COMMON /ERROR/ IERR

      DATA ZERO/0.,0.,0.,0./
      EN=RES_DAT(i_EN)
      DE=RES_DAT(i_DEN)

3     format('GMOD = ',F10.2,' ',a3,'/r.l.u.')
101   format('[',F6.2,' ',F6.2,' ',F6.2,'] / r.l.u.')
102   format('Q = [',F7.3,' ',F7.3,' ',F7.3,']')
103   format('E = ',F7.2,' ',a3)
104   format('[ ',a3,' , ',a3,' , ',a3,' ] / r.l.u.') 

            
      IERR=0
C// Check, whether dQ=0  =>  E=const scan
      ESCAN=((ABS(DELQ(1))+ABS(DELQ(2))+ABS(DELQ(3))).EQ.0)


C// R(Q,E) from Monte Carlo
      IF (SWRAYTR.NE.0) THEN
         IF(ANESS(1,1).EQ.0) GOTO 998   ! no events 
         CALL GetProj(ANESS,AMEAN,A1,RZERO,MCN)  ! Get projection in r.l.u.
         CALL GETSCALE(A1,1,4,0,X1,X2,Y1,Y2)  ! Get extent
         RZERO(4)=RZERO(4)+EN
C// R(Q,E) from TRAX
      ELSE
         IF(ATRAX(1,1).EQ.0) RETURN
         CALL GetProj(ATRAX,ZERO,A,AZERO,MCN)
         CALL GETSCALE(A,1,4,0,X1,X2,Y1,Y2)
         AZERO(4)=AZERO(4)+EN
      ENDIF


C// Define limits from the extent of the resolution ellipsoid

      CALL CLRPORT(PORT)
      PORT.WX1=2.5*X1
      PORT.WX2=2.5*X2
      PORT.WY1=2.5*Y1+EN
      PORT.WY2=2.5*Y2+EN
      PORT.IX=1
      PORT.IY=4
      SHX=0.
      SHY=0.

      NP=NPT(mf_cur)-NPT(mf_cur-1)   ! number of points in current data set
      IB=NPT(mf_cur-1)+1             ! base index for the in current data set
      
      NH1=NHIST(mf_cur)-NHIST(mf_cur-1)
      IBH=NHIST(mf_cur-1)+1            
            
C// If a spectrum is loaded, define limits from the data range

      IF ((NP.GT.0)) THEN
         CENTRE=(SPX(IB)+SPX(NP+IB-1))/2.
         RANGE=ABS(SPX(NP+IB-1)-SPX(IB))
         IF(DE.NE.0) THEN
            CENTRE=CENTRE*DE+EN
            RANGE=RANGE*DE
            PORT.WY1=CENTRE-RANGE/2
            PORT.WY2=CENTRE+RANGE/2
            SHY=EN-CENTRE
         ELSE
            CALL QNORM(DELQ,GNR,GNA)
            CENTRE=CENTRE*GNR
            RANGE=RANGE*GNR
            PORT.WX1=CENTRE-RANGE/2
            PORT.WX2=CENTRE+RANGE/2
         ENDIF
C//  Calc. difference btw. data and R(Q,E) centre
         CALL QNORM(GRD,GNR,GNA)
         do i=1,3
            AUX(i)=QE0(i,mf_cur)
         end do   
c         SHX=(QxQ(QHKL,GRD)-QxQ(AUX,GRD))/GNR
         SHY=EN-QE0(4,mf_cur)
      ELSE
         RANGE=ABS(XHIST(NH1+IBH-1)-XHIST(IBH))
         IF(DE.NE.0) THEN
            RANGE=RANGE*DE
            PORT.WY1=-RANGE/2+EN
            PORT.WY2=+RANGE/2+EN
         ELSE
            CALL QNORM(DELQ,GNR,GNA)
            RANGE=RANGE*GNR
            PORT.WX1=-RANGE/2
            PORT.WX2=+RANGE/2
         ENDIF      
      ENDIF
      
      

C// format the x-label to write scan dir. in symbolic format if possible 
      J=0
      z=0
      do i=1,3
        if (GRD(i).ne.0.and.GRD(i).ne.z) then
          J=J+1
          if(z.eq.0) z=GRD(i)
        endif  
      end do
      if (J.eq.1) then
        do i=1,3
          if(GRD(i).ne.0) then 
            chind(i)='\gc'
          else
            chind(i)=' 0 '
          endif
        end do
        WRITE(PORT.XTIT,104) (chind(i),i=1,3)        
      else
        WRITE(PORT.XTIT,101) GRD
      endif      
      PORT.YTIT='E '//CUNIT
      PORT.HEAD=' '

      CALL PLOTFRAME(PORT,1,1,1.,0)

      XL(1)=PORT.WX1
      XL(2)=PORT.WX2
      YL(1)=RES_DAT(i_GMOD)*XL(1)+EN
      YL(2)=RES_DAT(i_GMOD)*XL(2)+EN

      IF(SWRAYTR.NE.0) THEN
        IF (ICOM.EQ.1) THEN
          CALL PLOTELL(PORT,2,1,A1,RZERO,0)          ! projection by M.C.
          CALL PLOTELL(PORT,2,2,A1,RZERO,1)          ! section    by M.C.
        ELSE
          CALL FILARRAY(PORT,0,SHX,SHY,AIMA,NIMA,NIMA,-1,MCN)
          CALL PLOT2D(PORT,AIMA,NIMA,NIMA,NIMA,NIMA,0.)  ! image by M.C.
          IF (GRFSAVE.GE.2) THEN
            CALL WriteMap('ness_2d.mat',AIMA,NIMA,PORT.XTIT,PORT.YTIT,
     &        PORT.WX1,PORT.WX2,PORT.WY1,PORT.WY2,QHKL,EN)
          ENDIF
          CALL PLOTFRAME(PORT,1,1,1.,0)
        ENDIF
      ELSE
        CALL PLOTELL(PORT,1,1,A,AZERO,0)             ! projection by TRAX
        CALL PLOTELL(PORT,1,2,A,AZERO,1)             ! section    by TRAX
      ENDIF

      XL(1)=PORT.WX1                                ! dispersion branches
      XL(2)=PORT.WX2
      YL(1)=RES_DAT(i_GMOD)*XL(1)+EN
      YL(2)=RES_DAT(i_GMOD)*XL(2)+EN
c      write(*,*) 'PlotResol: WHATHIS=',WHATHIS
      IF(iand(WHATHIS,4).EQ.4) THEN ! EXCI dispersion
         CALL getmodel(rm)
         CALL QNORM(GRD,GNR,GNA)
         DO I=1,NLINE
           XFX(I)=(I-(NLINE-1)/2-1)*(XL(2)-XL(1))/(NLINE-1)
         END DO
c         write(*,*) 'nbr = ',nbr
         DO J=1,rm.nbr
           DO I=1,NLINE
              DO K=1,3
                 QEN(K)=QHKL(K)+GRD(K)/GNR*XFX(I)
              END DO   
              QEN(4)=EN
              CALL  EXCI(-1,QEN,V6,W6)
c              IF(W6(J).EQ.0) GOTO 12
              FY(I)=V6(J)
c1        format(2(3x,G12.4))
c              write(*,1) XFX(I),FY(I)
           END DO
           IF(rm.wen(j).eq.0) then
              CALL PGSLS(1)
           ELSE
              CALL PGSLS(2)   ! dashed line if S(Q,E) <> S(Q)*delta(E)
           ENDIF      
           CALL PGLINE(NLINE,XFX,FY)
           IF (GRFSAVE.GE.1) THEN
             comment='dispersion curve'
             CALL SAVEGRFDATA(PORT,XFX,FY,NLINE,comment)
           ENDIF  
12         CONTINUE
         END DO
      ELSE
         CALL PGLINE(2,XL,YL)
      ENDIF
      CALL PGSLS(1)

C//   legend:
      CALL PGSCH(0.8)
      rx=0.05
      WRITE(LEG1,102) QHKL
      WRITE(LEG2,103) EN,CUNIT(2:4)
      CALL PGMTEXT('T',-1.6,rx,0.0,LEG1(1:29))
      CALL PGMTEXT('T',-3.2,rx,0.0,LEG2)
      IF(iand(WHATHIS,4).EQ.0) THEN ! planar dispersion
         WRITE(LEG2,3) RES_DAT(i_GMOD),CUNIT(2:4)
         CALL PGMTEXT('T',-4.8,rx,0.0,LEG2)
      ENDIF
      CALL PGSCH(1.0)


      RETURN
998   IERR=1
      END
      

C--------------------------------------------------------------------
      SUBROUTINE PlotResQE(PORT,N,ICOM,SMAP)
C Plot Resolution function for N-th dataset 
C Similar to PlotResol, but shows R(Q,E) projected on the scattering plane.
C The kind of R(Q,E) representation depends on the  SWRAYTR and WHATHIS switches
C  INPUUT:
C    PORT       ... plotting viewport
C    N          ... dataset index
C    ICOM=1     ... show an ellipse instead of a cloud for ray-tracing resolution
C    SMAP=1     ... plots also S(Q) contours
C CALLS: FILLARRAY, FILLSQ, GETSCALE
C CALLED BY: PLOT_MRES
C--------------------------------------------------------------------
      IMPLICIT NONE
      
      INCLUDE 'const.inc'
      INCLUDE 'inout.inc' 
      INCLUDE 'lattice.inc'
      INCLUDE 'rescal.inc'
      INCLUDE 'restrax.inc'
      INCLUDE 'res_grf.inc'
      
      INTEGER*4 N,NIMA,NLINE,IC
      PARAMETER(NIMA=64,NLINE=31)
      INTEGER*4 SMAP
      RECORD /VIEWSET/ PORT
      CHARACTER*60 LEG1
      CHARACTER*60 S
      REAL*8  RZERO(4)
      REAL*8  SHX,SHY
      REAL*4  AIMA(NIMA,NIMA)
      REAL*4  rx
      REAL*4  CHSIZE
      INTEGER*4 ICOM,I,J,IERR,LW,NF,IBH
      REAL*8 RANGE,QQ(4),MAT(4,4),AUX(4,4),DQ(4),MCN(4,4)
      REAL*8 Z1,Z2
      REAL*8 AMC(4,4),ATR(4,4),AMC0(4)
      REAL*4 X1,Y1,X2,Y2
      INTEGER*4 NLEVELS
      PARAMETER(NLEVELS=5)
      REAL*4 LEVELS(NLEVELS)      
      COMMON /ERROR/ IERR
      REAL*8 A(3),B(3)
      EQUIVALENCE (A(1),RES_DAT(i_AX))
      EQUIVALENCE (B(1),RES_DAT(i_BX))
      DATA LEVELS / .1,.3,.5,.7,.9/

3     format('GMOD = ',F10.2,' ',a3,'/r.l.u.')
101   format('[',F6.2,' ',F6.2,' ',F6.2,'] / r.l.u.')
102   format('E = ',F7.3,' ',a)
104   format('\gc [',F3.1,' ',F3.1,' ',F3.1,']')
105   format('\gc [',I2,' ',I2,' ',I2,']')

      IERR=0

c      NP=NPT(N)-NPT(N-1)   ! number of points in current data set

C Get res. matrices etc. for N-th dataset
      DO I=1,4
         RZERO(I)=0.
         AMC0(I)=mf_AMEAN(I,N)
         DO J=1,4
           AMC(I,J)=mf_AMC(I,J,N)
           ATR(I,J)=mf_A(I,J,N)
         ENDDO
      ENDDO
            
C// Get QHKL,E in A,B coordinates
      call M4xV4_3(MABR,mf_par(i_QH,N),QQ)

C// Get step size in A,B coordinates
      call M4xV4_3(MABR,mf_par(i_DQH,N),DQ)

C// Get matrix which transforms vectors from C&N to AB
      call M4XM4_3(MABR,mf_MRC(1,1,N),MCN)

C// R(Q,E) from Monte Carlo
      IF (SWRAYTR.NE.0) THEN
         IF(AMC(1,1).EQ.0) GOTO 998   ! no events 
         CALL CN2RLU_MF(AMC,AUX,N) ! convert from C&N to r.l.u.
         CALL RLU2AB(AUX,MAT)   ! convert from r.l.u. to A,B
         CALL M4xV4_3(MCN,AMC0,RZERO)
c        write(*,*) 'Plot MC'
      ELSE
C// R(Q,E) from TRAX
         IF(ATR(1,1).EQ.0) GOTO 998
         CALL CN2RLU_MF(ATR,AUX,N) ! convert from C&N to r.l.u.
         CALL RLU2AB(AUX,MAT)      ! convert from r.l.u. to A,B
c        write(*,*) 'Plot TRAX'
      ENDIF
      CALL GETSCALE(MAT,1,2,0,X1,X2,Y1,Y2)  ! Get extent
      
c10    format(a,5(2x,G12.6))
c      do i=1,4
c         write(*,10) 'MAT: ',(MAT(i,j),j=1,4)
c      enddo  
c      write(*,10) 'GETSCALE: ',N,X1,X2,Y1,Y2 
      
      NF=NHIST(N)-NHIST(N-1)   ! number of points in current histogram
      IBH=NHIST(N-1)+1          ! base index for current histogram
      
      IF (NF.GT.0.AND.(ABS(DQ(1))+ABS(DQ(2)).GT.1E-6)) THEN
C// Define limits from the step size
        Z1=XHIST(IBH)*DQ(1)
        Z2=XHIST(IBH+NF-1)*DQ(1)
        X1=MIN(Z1,Z2)  !MIN(Z1,Z2,X1)
        X2=MAX(Z1,Z2)  !MAX(Z1,Z2,X2)      
        Z1=XHIST(IBH)*DQ(2)
        Z2=XHIST(IBH+NF-1)*DQ(2)
        Y1=MIN(Z1,Z2)  !MIN(Z1,Z2,Y1)
        Y2=MAX(Z1,Z2)  !MAX(Z1,Z2,Y2)
        
        X2=MAX(X2,Y2)
        X1=MIN(X1,Y1)
        PORT.WX1=X1+RZERO(1)+QQ(1)
        PORT.WX2=X2+RZERO(1)+QQ(1)
        PORT.WY1=X1+RZERO(2)+QQ(2)
        PORT.WY2=X2+RZERO(2)+QQ(2)
      else
C// Define limits from the extent of the resolution ellipsoid
C/ set equal scale on x and y
        X2=MAX(X2,Y2)
        X1=MIN(X1,Y1)
        RANGE=2.
        IF(ICOM.NE.1.AND.SWRAYTR.NE.0) RANGE=3.    ! wider range for ray-tracing clouds
        PORT.WX1=RANGE*X1+RZERO(1)+QQ(1)
        PORT.WX2=RANGE*X2+RZERO(1)+QQ(1)
        PORT.WY1=RANGE*X1+RZERO(2)+QQ(2)
        PORT.WY2=RANGE*X2+RZERO(2)+QQ(2)
      endif  
      PORT.IX=1
      PORT.IY=2
      PORT.HEAD=' '
      CALL CLRPORT(PORT)
      SHX=0.
      SHY=0.            

C/ axes titles
      if (INT(A(1)+A(2)+A(3)).EQ.INT(A(1))+INT(A(2))+INT(A(3))) then
        WRITE(S,105) (INT(A(I)),I=1,3)
      else
        WRITE(S,104) (A(I),I=1,3)
      endif
      PORT.XTIT=S
      if (INT(B(1)+B(2)+B(3)).EQ.INT(B(1))+INT(B(2))+INT(B(3))) then
        WRITE(S,105) (INT(B(I)),I=1,3)
      else
        WRITE(S,104) (B(I),I=1,3)
      endif
      PORT.YTIT=S
      
      CALL PGQLW(LW)      

C// Set optimum character size

      chsize=MAX(0.7,2.3*(PORT.DX2-PORT.DX1))
      chsize=MIN(chsize,1.2)
      CALL PGSCH(chsize)
      
C// plot R(Q) as an ellipse or a gray-scale image      
      CALL PGSLW(LW)

      IF (ICOM.NE.1.AND.SWRAYTR.NE.0) THEN
         CALL FILARRAY(PORT,N,SHX,SHY,AIMA,NIMA,NIMA,1,MCN)
         CALL PLOT2D(PORT,AIMA,NIMA,NIMA,NIMA,NIMA,0.)  ! image by M.C.
         CALL PLOTFRAME(PORT,1,1,chsize,0)
      ELSE   ! ellipsoid   
        IC=1
        IF(SWRAYTR.NE.0) IC=2
        RZERO(1)=(PORT.WX1+PORT.WX2)/2.
        RZERO(2)=(PORT.Wy1+PORT.Wy2)/2.
        CALL PLOTELL(PORT,IC,1,MAT,RZERO,0)          ! projection 
        CALL PLOTELL(PORT,IC,2,MAT,RZERO,1)          ! section    
        CALL PLOTFRAME(PORT,1,1,chsize,0)
      ENDIF

      IF(SMAP.EQ.1) THEN
C// MRAB transforms vectors from AB to r.l.u. 
        call FILLSQ(PORT,AIMA,NIMA,NIMA,MRAB)
        CALL PGSLW(1)
        CALL PGSCI(4)
        CALL PLOTCMAP(PORT,AIMA,NIMA,NIMA,LEVELS,NLEVELS)
      ENDIF
      
      CALL PGSLW(LW)
      CALL PGSCI(1)      
      CALL PGSLS(1)

C//   legend:

50    CALL PGSCH(chsize)
      rx=0.05
      WRITE(LEG1,102) mf_par(I_EN,N),CUNIT
      CALL PGMTEXT('T',-1.6,rx,0.0,LEG1(1:25))
      CALL PGSCH(1.0)


      RETURN
998   IERR=1
      END
 


