C//////////////////////////////////////////////////////////////////////
C////  $Id: resgraph2.f,v 1.10 2006/05/12 11:45:29 saroun Exp $
C////  R E S T R A X   4.8
C////
C////  Graphics output subroutines (PGPlot library required)
C////  LEVEL 2 subroutines:
C////  FILL 2D-IMAGE ARRAY, PLOT 2D-IMAGE ARRAY , PLOT 1D-SCAN DATA  
C//////////////////////////////////////////////////////////////////////


C***********************  FILL 2D-IMAGE ARRAY ******************************

C----------------------------------------------------------------------
      SUBROUTINE FILARRAY(PORT,INDX,SHX,SHY,AIMA,NIMX,NIMY,NM,TM)
C Fills array AIMA by events stored in KSTACK
C  PORT       ... plotting viewport (IX,IY defines projection plane)
C  INDX       ... dataset index. If INDX=0, then take current dataset.
C  SHX,SHY    ... shift QE points in X,Y with respect to the image centre. 
C  AIMA(NIMA,NIMA) ... returned real*4 array with resulting map
C  NM<>0      ... events are transformed by matrix TM.
C  NM<0       ... transposed matrix TM is used.
C  TM         ... transformation matrix for Q,E events 
C                 (from C&N to plotting coordinates)                 
C CALLS: KSTACK routines
C CALLED BY: PlotResQE,PlotResol,PAGE1
C----------------------------------------------------------------------
      IMPLICIT NONE
      
      INCLUDE 'const.inc'      
      INCLUDE 'inout.inc'      
      INCLUDE 'rescal.inc'
      INCLUDE 'restrax.inc'
      INCLUDE 'res_grf.inc'

      INTEGER*4 NIMX,NIMY,NM,I4,NCNT,IX,IY,J,K,JX,JY
      INTEGER*4 INDX,IDATA
      REAL*4 AIMA(NIMX,NIMY)
      REAL*8 TM(4,4),E(4),E1(4),DIMX,DIMY,P,SHX,SHY

      RECORD /VIEWSET/ PORT

1     format(a20,4(2x,G17.5))

      IDATA=INDX
      IF(IDATA.LE.0.OR.IDATA.GT.mf_max) IDATA=mf_cur
      DIMX=(PORT.WX2-PORT.WX1)/NIMX
      DIMY=(PORT.WY2-PORT.WY1)/NIMY
      IX=PORT.IX
      IY=PORT.IY
      DO 131 J=1,NIMX
      DO 131 K=1,NIMY
           AIMA(J,K)=0
131   CONTINUE

      CALL KSTACK_N(NCNT,mf_cur)  ! get number of events NCNT

      IF (NCNT.GT.0) THEN
      DO 132 I4=1,NCNT
         IF (NM.NE.0) THEN
            CALL GETQE(I4,IDATA,E1,P)
            CALL MXV(NM,4,4,TM,E1,E)
         ELSE
            CALL GETQE(I4,IDATA,E,P)
         ENDIF
         JX=INT((E(IX)+SHX)/DIMX+NIMX/2.)+1
         JY=INT((E(IY)+SHY)/DIMY+NIMY/2.)+1
         IF((JX.GT.0).AND.(JX.LE.NIMX)) THEN
            IF((JY.GT.0).AND.(JY.LE.NIMY)) THEN
                AIMA(JX,JY)=AIMA(JX,JY)+P
            ENDIF
         ENDIF
132   CONTINUE
      ENDIF

      RETURN
      END

C--------------------------------------------------------------------
      SUBROUTINE FILL_FCONE(PORT,AIMA,NIMX,NIMY,ICOM)
C Fills array AIMA by events stored in KSTACK for flatcone arrangement
C  Assumes scan in A3,A4
C  PORT       ... plotting viewport (IX,IY defines projection plane)
C  AIMA(NIMA,NIMA) ... returned real*4 array with resulting map
C  ICOM=0     ... plot data (from data array SPX...)
C  ICOM>0     ... plot fit using EXCI  (from histogram array XHIST ...)
C CALLS: KSTACK routines
C CALLED BY: AB_MAP
C--------------------------------------------------------------------
      IMPLICIT NONE
      INCLUDE 'const.inc'      
      INCLUDE 'inout.inc'      
      INCLUDE 'rescal.inc'
      INCLUDE 'restrax.inc'
      INCLUDE 'res_grf.inc'
      
      RECORD /VIEWSET/ PORT
      INTEGER*4 NIMX,NIMY,IDAT,ICOM,I_IO
      REAL*4 AIMA(NIMX,NIMY)
      REAL*8 IMX0,IMY0,DIMX,DIMY,DA3,DA4,A3,A4,A30(MDAT),A40
      REAL*8 SCAN(MHIS,MDAT),VQ0(4),VQ(4)
      INTEGER*4 I,J,K,IDAT0,IER,IZ3,IZ4,NP      
      REAL*8 S00,S01,S10,S11,F0,F1,DUM,Z3,Z4
      REAL*8 AX(3),BX(3),XP,YP
      EQUIVALENCE (AX(1),mf_par(i_AX,1))
      EQUIVALENCE (BX(1),mf_par(i_BX,1))
      
9     FORMAT(128(1x,G10.4))      
13    format('scale (',G12.5,',',G12.5,',',G12.5,',',G12.5,')')
1     format('FCONE: check scattering triangle: ',I9)
2     format('FCONE: unequal number steps in channels: ',I9,' ID=',I9)


c      write(*,*) 'FCONE: start'                
      DIMX=(PORT.WX2-PORT.WX1)/NIMX
      DIMY=(PORT.WY2-PORT.WY1)/NIMY
      IMX0=(PORT.WX2+PORT.WX1)/2
      IMY0=(PORT.WY2+PORT.WY1)/2
      
      DO 10 J=1,NIMX
      DO 10 K=1,NIMY
           AIMA(J,K)=0
10    CONTINUE
 
C get scan parameters from the 1st channel      
C assume equidistant scan in A4 and A3
C assume equal number of steps for each channel
      NP=NHIST(1)
      IF (ICOM.EQ.0) THEN 
        DA3=DQE0(5,1)*deg 
        DA4=DQE0(6,1)*deg
        NP=NPT(1)
        DO I=1,4
          VQ0(I)=QE0(I,1)
        ENDDO
      ELSE
        DA3=mf_par(i_DA3,1)*deg 
        DA4=mf_par(i_DA4,1)*deg
        NP=NHIST(1)
        DO I=1,4
          VQ0(I)=mf_par(i_QH+I-1,1)
        ENDDO
      ENDIF
        
      CALL GET_A3A4(1,VQ0,DUM,A40,IER)
c      write(*,*) 'GETA3A4 ier=',IER
c20    format(a,4(1x,G10.4),2(1x,a,1x,G10.4))
c      write(*,20) 'VQ0: ',VQ0,' A3: ',DUM/deg,' A4',A40/deg
c      pause
      
      IF (IER.NE.0.OR.ABS(DUM).GT.1E-6) GOTO 98              

C fill SCAN array with data values
C SCAN is a matrix for "orthogonal" (A3,A4) grid      
      IDAT0=0
      K=0
      IF (ICOM.EQ.0) THEN
        DO I=1,NPT(mf_max)
          IDAT=IPT(I)
          IF(IDAT.NE.IDAT0) THEN  ! new channel
            IF (K.NE.0.AND.K.NE.NP) GOTO 99
            K=0
            A30(IDAT)=SPX(I)*DA3
            IDAT0=IDAT
          ENDIF   
          K=K+1
          IF (K.GT.NP) GOTO 99
          SCAN(K,IDAT)=SPY(I)
        ENDDO
      ELSE
        DO I=1,NHIST(mf_max)
          IDAT=IHIST(I)
          IF(IDAT.NE.IDAT0) THEN  ! new channel
            IF (K.NE.0.AND.K.NE.NP) GOTO 99
            K=0
            A30(IDAT)=XHIST(I)*DA3
            IDAT0=IDAT
          ENDIF   
          K=K+1
          IF (K.GT.NP) GOTO 99
          SCAN(K,IDAT)=RHIST(I)
        ENDDO
      ENDIF  
      
      
      I_IO=25
      close(i_io)
      Open(Unit=i_IO,File='fcone_channels.dat',Status='Unknown')
      write(i_io,13) XHIST(1)*DA3/deg,XHIST(NP)*DA3/deg,
     &      0,mf_par(i_DA4,1)*mf_max          
      do j=1,NP
        write(i_IO,9) (SCAN(j,i),i=1,mf_max)
      enddo
      close(i_io)                           
c11    format(a,6(1x,G12.6))
c        write(*,11) 'NP: ',NP      
c         write(*,11) 'x-scale: ',PORT.WX1,PORT.WX2,DIMX
c         write(*,11) 'y-scale: ',PORT.WY1,PORT.WY2,DIMY
c         write(*,11) 'A30,A40: ',A30(1)/deg,A40/deg
c         pause  
      
C fill AMAT array by linear interpolation in SCAN
      DO I=1,4
         VQ(I)=VQ0(I)
      ENDDO 
      DO I=1,NIMX
      DO J=1,NIMY
         XP=PORT.WX1+(I-0.5)*DIMX
         YP=PORT.WY1+(J-0.5)*DIMY
         VQ(1)=XP*AX(1)+YP*BX(1)
         VQ(2)=XP*AX(2)+YP*BX(2)
         VQ(3)=XP*AX(3)+YP*BX(3)
c       write(*,*) 'pixel: ',I,J,VQ(1),VQ(2),DA4
         CALL GET_A3A4(1,VQ,A3,A4,IER)
c       write(*,*) 'A3,A4: ',A3/deg,A4/deg
         Z4=(A4-A40)/DA4
         IZ4=NINT(Z4)+1
c       write(*,*) 'I3,I4: ',INT(Z3),INT(Z4)
         IF (IER.NE.0.OR.IZ4.LE.0.OR.IZ4.GT.mf_max) THEN
           AIMA(I,J)=0 ! out of data range
         ELSE
           Z3=(A3-A30(IZ4))/DA3
           IZ3=NINT(Z3)+1
           IF (IZ3.LE.0.OR.IZ3.GT.NP) THEN
             AIMA(I,J)=0 ! out of data range
           ELSE             
c         write(*,*) 'pixel: ',I,J,VQ(1),VQ(2)
c         write(*,*) 'A3,A4: ',INT(Z3),INT(Z4),A3/deg,A4/deg
c         pause  
             IF (IZ4.EQ.mf_max) IZ4=IZ4-1
             IF (IZ3.EQ.NP) IZ3=IZ3-1
             S00=SCAN(IZ3,IZ4)
             S01=SCAN(IZ3,IZ4+1)
             S10=SCAN(IZ3+1,IZ4)
             S11=SCAN(IZ3+1,IZ4+1)
             F0=S00+(Z4+1-IZ4)*(S01-S00)
             F1=S10+(Z4+1-IZ4)*(S11-S10)
             AIMA(I,J)=F0+(Z3+1-IZ3)*(F1-F0)
           ENDIF
         ENDIF
      ENDDO 
      ENDDO  
c       write(*,*) 'FCONE: OK'        
c       pause        
         
      RETURN
      
98    write(smes,1) IER
      RETURN
99    write(smes,2) K,IDAT
      RETURN
      END               


C-----------------------------------------------------------------------
      SUBROUTINE FILLQHKL(PORT,IDAT,IR,AIMA,NIMX,NIMY,CLR,DA3,NM,TM)
C Fills array AIMA by events stored in KSTACK
C  PORT       ... plotting viewport (IX,IY defines projection plane)
C  IDAT       ... dataset index. If IDAT=0, then take current dataset.
C  IR<>0      ... add nominal QHKL 
C  AIMA(NIMA,NIMA) ... returned real*4 array with resulting map
C  CLR=0      ... clear AIMA
C  DA3        ... events are rotated by DA3 [deg] (sample rotation)
C  NM<>0      ... events are transformed by matrix TM.
C  TM         ... transformation matrix for Q,E events 
C                 (from C&N to plotting coordinates)
C CALLS: KSTACK routines
C CALLED BY: RES_IMAGE,MRES_ALL,AB_MAP
C-----------------------------------------------------------------------
      IMPLICIT NONE
      INCLUDE 'const.inc'      
      INCLUDE 'inout.inc'      
      INCLUDE 'rescal.inc'
      INCLUDE 'lattice.inc'      
      INCLUDE 'restrax.inc'
      INCLUDE 'res_grf.inc'
      INTEGER*4 NIMX,NIMY,IDAT,IR,CLR,NM
      REAL*4 AIMA(NIMX,NIMY)
      REAL*8 IMX0,IMY0,TM(4,4)
      REAL*8 E(4),E1(4),E2(4),DA3
      RECORD /VIEWSET/ PORT
      INTEGER*4 I4,NCNT,ICNT
      INTEGER*4 IX,IY,I,J,K,JX,JY       
      REAL*8 DIMX,DIMY,EX,EY,PP
      REAL*8 AUX(3,3)

1     format(a20,4(2x,G12.6))
                        
      DIMX=(PORT.WX2-PORT.WX1)/NIMX
      DIMY=(PORT.WY2-PORT.WY1)/NIMY
      IMX0=(PORT.WX2+PORT.WX1)/2
      IMY0=(PORT.WY2+PORT.WY1)/2
      
      IX=PORT.IX
      IY=PORT.IY
      IF (CLR.EQ.0) THEN
      DO 131 J=1,NIMX
      DO 131 K=1,NIMY
           AIMA(J,K)=0
131   CONTINUE
      ENDIF
 
C prepare rotation matrix
      IF (DA3.NE.0) THEN
      DO I=1,3
          DO J=1,3
            AUX(I,J)=0.
          ENDDO
          AUX(I,I)=1.
        ENDDO
        AUX(1,1)=COS(DA3)  
        AUX(2,2)=AUX(1,1)
        AUX(1,2)=SIN(DA3)
        AUX(2,1)=-AUX(1,2) 
      ENDIF
      
      
      CALL KSTACK_N(NCNT,IDAT)  ! get number of events NCNT

C fill array AIMA with events      
      ICNT=0
      IF (NCNT.GT.0) THEN
      DO 132 I4=1,NCNT
         CALL GETQE(I4,IDAT,E1,PP)  
         CALL M4xV4_3(mf_MRC(1,1,IDAT),E1,E) ! convert to [hkl]
         IF (IR.NE.0) THEN
           DO I=1,4
             E(I)=E(I)+mf_par(i_QH+I-1,IDAT)
           ENDDO  
         ENDIF  
         IF (DA3.NE.0) THEN ! rotate by DA3
              CALL M4xV4_3(SMAT,E,E1) ! convert QHKL to AB 
              CALL M3xV4(AUX,E1,E2) ! rotate QHKL           
              CALL M4xV4_3(SINV,E2,E) ! convert QHKL to r.l.u         
         ENDIF
         IF (NM.NE.0) THEN 
c         do i=1,4 
c           write(*,1) 'TM: ',(TM(i,j),j=1,4)
c           enddo
c         write(*,1) 'FILLQHKL: ',(E1(j),j=1,4)
c          write(*,1) 'FILLQHKL: ',(E(j),j=1,4)
           CALL M4xV4(TM,E,E1)
c         write(*,1) 'FILLQHKL: ',(E1(j),j=1,4)
c         pause
            EX=E1(IX)
            EY=E1(IY)
         ELSE   
            EX=E(IX)
            EY=E(IY)
         ENDIF
         IF(EX.GT.PORT.WX1.AND.EX.LT.PORT.WX2.AND.
     *      EY.GT.PORT.WY1.AND.EY.LT.PORT.WY2) THEN             
           JX=INT((EX-PORT.WX1)/DIMX)+1
           JY=INT((EY-PORT.WY1)/DIMY)+1
           AIMA(JX,JY)=AIMA(JX,JY)+PP 
           ICNT=ICNT+1    
         ENDIF         
132   CONTINUE 

c      write(*,*) 'Integrated ',ICNT,' events in data ',IDAT
      ENDIF

      RETURN
      END               


C------------------------------------------------------------
      SUBROUTINE FILLSQ(PORT,AIMA,NIMX,NIMY,TM)
C Fills array AIMA by values of S(Q,E). 
C Takes sample parameters from current dataset.
C   PORT       ... plotting viewport (IX,IY defines projection plane)
C   AIMA(NIMA,NIMA) ... returned real*4 array with resulting map
C   TM         ... transformation matrix from plotting coordinates to r.l.u.                 
C CALLS: FILLQOMARRAY
C CALLED BY: PlotResQE,AB_MAP
C------------------------------------------------------------
      IMPLICIT NONE
      
      INCLUDE 'const.inc'      
      INCLUDE 'inout.inc'      
      INCLUDE 'rescal.inc'
      INCLUDE 'restrax.inc'
      INCLUDE 'res_grf.inc'
      INCLUDE 'exciimp.inc'      
      RECORD /MODEL/ rm

      INTEGER*4 NIMX,NIMY,J,K,I,L
      INTEGER*4 IDATA
      REAL*4 AIMA(NIMX,NIMY),AUX(MIMAX,MIMAX,6),ENORM
      REAL*8 TM(4,4),GM,PX,W,Z,CN

      RECORD /VIEWSET/ PORT


      IDATA=mf_cur ! take all parameters from the current data set
      
      
      ENORM=mf_par(I_EN,IDATA)
C// fill QOM array with values corresponding to viewport pixels       
      CALL FILLQOMARRAY(PORT,IDATA,NIMX,NIMY,TM)

      call getmodel(rm)
      call getqomega(rq)

      
C// clear AIMA
      DO K=1,NIMY
      DO J=1,NIMX
        AIMA(J,K)=0.
      ENDDO
      ENDDO
      
C// clear AUX
      DO i=1,rm.nbr  
      DO K=1,NIMY
      DO J=1,NIMX
        AUX(J,K,I)=0.
      ENDDO
      ENDDO
      ENDDO
        
C// loop through wen>0 branches
10    format(' finite width branches: ',$)
20    format(' zero width branches: ',$)
11    format(I2,1x,$)
      write(sout,10)
      DO i=1,rm.nbr  
      IF (rm.wen(i).gt.0) then
        write(sout,11) i
        DO K=1,NIMY
        DO J=1,NIMX
           L=K+(J-1)*NIMY+(I-1)*NIMX*NIMY
           AUX(J,K,I)=rq.PQOM(L)
        ENDDO
        ENDDO
      ENDIF
      ENDDO

C loop through wen=0 branches
      write(sout,20)
      DO i=1,rm.nbr  
      IF (rm.wen(i).le.0) then
        write(sout,11) i  
        GM=MAX(mf_par(I_GMOD,IDATA),5.D0) ! typical disp. gradient
        PX=(ABS((PORT.WX2-PORT.WX1)/NIMX)+ABS((PORT.WY2-PORT.WY1)/NIMY))/2.0 ! pixel size
        W=GM*PX ! default gaussian width for visualisation 
        CN=SQRT(2*PI)*W 
        DO K=1,NIMY
        DO J=1,NIMX
           L=K+(J-1)*NIMY+(I-1)*NIMX*NIMY
           Z=((ENORM-rq.QOM(4,L))/W)**2
           AUX(J,K,I)=rq.PQOM(L)*exp(-0.5*Z)/CN
        ENDDO
        ENDDO        
      ENDIF
      ENDDO
      
C// sum all branches      

      DO I=1,rm.nbr
      DO K=1,NIMY
      DO J=1,NIMX        
        AIMA(J,K)=AIMA(J,K)+AUX(J,K,I)
      ENDDO
      ENDDO
      ENDDO
      write(sout,*) 'FILLSQ OK'  
      END   
      
C***********************  PLOT 2D-IMAGE ARRAY ******************************

C--------------------------------------------------------------------      
      SUBROUTINE AB_MAP(XMIN,XMAX,YMIN,YMAX,COMMENT,AIMA,NIMA,ICOM)
C Plot projections on the scattering plane (for flatcone arrangement) 
C   XMIN..YMAX      ... defines viewport area in units of AX..AZ, BX..BZ vectors 
C   COMMENT         ... a string to appear on the plot 
C   AIMA(NIMA,NIMA) ... returned real*4 array with resulting map
C   ICOM=ig_FCRES   ... plot R(Q,E) for flatcone
C   ICOM=ig_FCDATA  ... plot 2D data for flatcone
C   ICOM=ig_SQMAP   ... map of S(Q) at E=const.
C CALLS: FILLQHKL,FILL_FCONE,FILLSQ
C CALLED BY: AB_IMAGE 
C--------------------------------------------------------------------            
      implicit none
      INCLUDE 'const.inc'
      INCLUDE 'inout.inc'
      INCLUDE 'lattice.inc'     
      INCLUDE 'rescal.inc'     
      INCLUDE 'restrax.inc' 
      INCLUDE 'res_grf.inc'
      
      integer*4 NIMA,NP,ICOM
      REAL*8 XMIN,XMAX,YMIN,YMAX,DA3
      REAL*4 AIMA(NIMA,NIMA)
      character*50 comment
      
      RECORD /VIEWSET/ PORT      
      character*32 namex,namey
      integer*4 I,J
      REAL*8 SUM,ZMAX      
      REAL*8 AX(3),BX(3)
      
      EQUIVALENCE (AX(1),mf_par(i_AX,1))
      EQUIVALENCE (BX(1),mf_par(i_BX,1))


C// prepare viewport
      IF (ICOM.EQ.ig_FCRES) THEN
        PORT.HEAD='Flat-cone resolution functions'
      ELSE IF (ICOM.EQ.ig_FCDATA) THEN
        PORT.HEAD='Flat-cone data map'
      ELSE IF (ICOM.EQ.ig_SQMAP) THEN
        PORT.HEAD='S(Q) map at E=const.'
      ENDIF
      
      PORT.WX1=xmin
      PORT.WX2=xmax
      PORT.WY1=ymin
      PORT.WY2=ymax
      
      PORT.DX1=0.15   
      PORT.DX2=0.93
      PORT.DY1=0.31
      PORT.DY2=0.89
      PORT.IX=1
      PORT.IY=2 
      
      CALL FORMAT_HKL(AX,namex,32)
      CALL FORMAT_HKL(BX,namey,32)
   
      PORT.XTIT='\gc '//namex
      PORT.YTIT='\gc '//namey
      CALL PGSLW(4)
      CALL PGSCH(1.5)      
      
C// fill AIMA array with R(Q,E) events (ICOM=0) 
C// or data from RHIST (ICOM=1)
      IF (ICOM.EQ.ig_FCRES) THEN      
        DO i=1,mf_max
          NP=NPT(i)-NPT(i-1)  
          CALL FILLQHKL(PORT,i,1,AIMA,NIMA,NIMA,i-1,0.D0,1,MABR)
          DA3=mf_par(i_DA3,i)
          IF(DA3.NE.0.AND.NP.GT.2) THEN ! add images at scan limits for A3 scans
            DA3=DA3*NINT((NP-1)/2.0)*deg
            CALL FILLQHKL(PORT,i,1,AIMA,NIMA,NIMA,1,-DA3,1,MABR)
            CALL FILLQHKL(PORT,i,1,AIMA,NIMA,NIMA,1,DA3,1,MABR)
          ENDIF 
        ENDDO  
      ELSE IF (ICOM.EQ.ig_FCDATA) THEN
        CALL FILL_FCONE(PORT,AIMA,NIMA,NIMA,1) ! 1 .. from RHIST
      ELSE IF (ICOM.EQ.ig_SQMAP) THEN
        CALL FILLSQ(PORT,AIMA,NIMA,NIMA,MRAB) ! 2 .. S(Q) map at E=EN
      ENDIF 
      sum=0.
      zmax=0
      do i=1,nima
      do j=1,nima
         sum=sum+aima(i,j)  
         if(aima(i,j).gt.zmax) zmax=aima(i,j)
      enddo
      enddo
      if (sum.le.0) then
        return
      endif
      do i=1,nima
      do j=1,nima
         aima(i,j)=aima(i,j)/sum*nima**2         
      enddo
      enddo
      IF (ICOM.EQ.ig_SQMAP) THEN
        CALL PLOT2D(PORT,AIMA,NIMA,NIMA,NIMA,NIMA,10.) ! log10 scale     
      ELSE
        CALL PLOT2D(PORT,AIMA,NIMA,NIMA,NIMA,NIMA,0.)     
      ENDIF  
      CALL PLOTFRAME(PORT,1,1,1.8,0)

      CALL PGSLW(2)
      CALL PGSCH(1.0)      
      CALL PGSCI(1) 
      CALL PGMTEXT('B',10.,-0.05,0.0,comment)
      CALL PGIDEN
             
      end

C----------------------------------------------------------------------      
      SUBROUTINE MRES_ALL(ID,IX,IY,XMI,XMA,YMI,YMA,COMMENT,AIMA,NIMA)
C Merge resolution functions for data set(s) into one matrix and plot
C INPUT
C   ID           ... dataset index, if=0 then merge all data sets
C   IX,IY        ... define axes in [hklE] (h=1 ...etc.)
C   XMIN..YMAX   ... define viewport area   
C   COMMENT      ... a string to appear on the plot 
C OUTPUT:
C   AIMA(NIMA,NIMA) ... returned real*4 array with resulting map
C----------------------------------------------------------------------          
      implicit none
      INCLUDE 'const.inc'
      INCLUDE 'inout.inc'
      INCLUDE 'rescal.inc'     
      INCLUDE 'restrax.inc' 
      INCLUDE 'res_grf.inc'
      
      integer*4 ID,IX,IY,NIMA,NP
      REAL*8 XMI,XMA,YMI,YMA,DA3
      CHARACTER*(*) COMMENT
      REAL*4 AIMA(NIMA,NIMA)
      CHARACTER*32 S1,S2,S3,S4
      character*128 leg1
      
      RECORD /VIEWSET/ PORT      
      character*32 name(4),name1(4)
      integer*4 I,J
      REAL*8 SUM,ZMAX,AUX(4,4)
  
      DATA name/'(\gc 0 0)','(0 \gc 0)','(0 0 \gc)','\gDE [meV]'/
      DATA name1/'h ','k ','k ','dE [meV]'/
                  
102   format('nominal Q\dhkl\u = [',a,',',a,',',a,'] E = ',a,' meV') 
      
C// format legend
      CALL FLOAT2STR(QHKL(1),S1)
      CALL FLOAT2STR(QHKL(2),S2)
      CALL FLOAT2STR(QHKL(3),S3)
      CALL FLOAT2STR(RES_DAT(i_EN),S4)
      WRITE(LEG1,102) S1(1:LEN_TRIM(S1)),S2(1:LEN_TRIM(S2)),
     &     S3(1:LEN_TRIM(S3)),S4(1:LEN_TRIM(S4))
      
C// set PORT attributes
      PORT.HEAD='Projection of R(Q,E) [r.l.u]'     
      PORT.WX1=xmi
      PORT.WX2=xma
      PORT.WY1=ymi
      PORT.WY2=yma
      
      PORT.DX1=0.15   
      PORT.DX2=0.93
      PORT.DY1=0.31
      PORT.DY2=0.89
      PORT.IX=IX
      PORT.IY=IY             
      PORT.XTIT=name(IX)
      PORT.YTIT=name(IY)
      
C// draw the graph      
      CALL PGSLW(4)
      CALL PGSCH(1.5)      
      IF (ID.EQ.0) THEN
        DO i=1,mf_max
          NP=NPT(i)-NPT(i-1)  
          CALL FILLQHKL(PORT,i,1,AIMA,NIMA,NIMA,i-1,0.D0,0,AUX)
          DA3=mf_par(i_DA3,i)
          IF(DA3.NE.0.AND.NP.GT.2) THEN ! add images at scan limits for A3 scans
            DA3=DA3*NINT((NP-1)/2.0)*deg
            CALL FILLQHKL(PORT,i,1,AIMA,NIMA,NIMA,1,-DA3,0,AUX)
            CALL FILLQHKL(PORT,i,1,AIMA,NIMA,NIMA,1,DA3,0,AUX)
          ENDIF 
        ENDDO
      ELSE
        CALL FILLQHKL(PORT,ID,1,AIMA,NIMA,NIMA,0,0.D0,0,AUX)
      ENDIF  
C// normalization of the array
      sum=0.
      zmax=0
      do i=1,nima
      do j=1,nima
         sum=sum+aima(i,j)  
         if(aima(i,j).gt.zmax) zmax=aima(i,j)
      enddo
      enddo
      if (sum.gt.0) then 
        do i=1,nima
        do j=1,nima
           aima(i,j)=aima(i,j)/sum*nima**2         
        enddo
        enddo
        CALL PLOT2D(PORT,AIMA,NIMA,NIMA,NIMA,NIMA,0.)
      endif     
      CALL PLOTFRAME(PORT,1,1,1.8,0)
      
      CALL PGSLW(2)
      CALL PGSCH(1.0)      
      CALL PGSCI(1) 
      CALL PGMTEXT('B',12.0,0.0,0.0,LEG1(1:LEN_TRIM(LEG1)))
      CALL PGMTEXT('B',10.0,0.0,0.0,comment(1:LEN_TRIM(comment)))
      CALL PGIDEN
             
      end


C***********************  PLOT 1D-SCAN DATA ******************************


C--------------------------------------------------------------------
      SUBROUTINE PLOTSCAN(PORT,XFX,FY,NF,IC,IP,ILINE)
C Plot function (FX,FY,NF). Plots also current dataset if there is one.
C   PORT       ... plotting viewport
C   XFX        ... x-values
C   FY         ... y-values
C   NF         ... number of points
C   IC         ... color
C   IP         ... point style
C   ILINE      ... line style
C CALLS:
C CALLED BY: PAGE2
C--------------------------------------------------------------------
      IMPLICIT NONE
      
      INCLUDE 'const.inc'
      INCLUDE 'inout.inc'
      INCLUDE 'rescal.inc'
      INCLUDE 'restrax.inc'
      INCLUDE 'res_grf.inc'

      RECORD /VIEWSET/ PORT
      CHARACTER*60 LEG1,LEG2
      LOGICAL*4 ESCAN
      INTEGER*4 NF,NP,IB
      REAL*4 XFX(NF),FY(NF)
      REAL*4 SPXD(NHI*4)
      REAL*8 PMAX,CENTRE,RANGE,EN,DE,Z
      INTEGER*4 I,IC,IP,ILINE,J1,J2,jr,IS1,IL1,IS2,IL2
      LOGICAL*4 PLOTDATA

102   format('Q = [',G10.4,' ',G10.4,' ',G10.4,']')
103   format('E = ',G10.4,' ',a3)
104   format('\gDq\dhkl\u = [',G10.4,' ',G10.4,' ',G10.4,']')
105   format('\gDE =',G10.4,' ',a3)

      EN=RES_DAT(i_EN)
      DE=RES_DAT(i_DEN)
C//   define viewport:

      ESCAN=((ABS(DELQ(1))+ABS(DELQ(2))+ABS(DELQ(3))).EQ.0)

      PORT.WY1=0

      PMAX=0
      
      NP=NPT(mf_cur)-NPT(mf_cur-1)   ! number of points incurrent data set
      IB=NPT(mf_cur-1)+1             ! base index for the incurrent data set
      
      IF(NP.GT.NHI*4) NP=NHI*4

C// decide whether to plot also measured data
C// yes, if  NP>0 and SPY(i)<>0
      Z=0.
      DO I=1,NP
        Z=Z+ABS(SPY(IB+I-1))
      ENDDO  
      PLOTDATA=(NP.GT.0.AND.Z.GT.0)
      
      IF (NF.LE.0.AND..NOT.(PLOTDATA)) RETURN ! nothing to plot
      
C// if spectrum is loaded, get x-axis points from it
      IF (PLOTDATA) THEN
        DO i=1,NP
          PMAX=MAX(PMAX,SPY(I)*1.D0)
          IF(ESCAN) THEN
            SPXD(I)=SPX(I+IB-1)*DE+EN        ! x-axis on energy scale
          ELSE
            SPXD(I)=SPX(I+IB-1)
          ENDIF
c1     FORMAT(3(3x,G13.5))             
c      write(*,1) SPXD(I),SPX(I),SPY(I)
        END DO
      ENDIF

      DO I=1,NF
         IF(ESCAN) XFX(I)=XFX(I)*DE + EN        ! x-axis on energy scale
         PMAX=MAX(PMAX,FY(I)*1.D0)
c1     FORMAT(3(3x,G13.5))             
c      write(*,1) XFX(I),(FY(I)-FPAR(2))/FPAR(1)
      END DO

C// if spectrum is loaded, get range from it
      IF(PLOTDATA) THEN                   !
         CENTRE=(SPXD(1)+SPXD(NP))/2.
c         RANGE=ABS(XFX(NF)-XFX(1))+4.*ABS(XFX(2)-XFX(1))
         RANGE=ABS(SPXD(NP)-SPXD(1))*2
C// otherwise - help yourself
      ELSE
         CENTRE=(XFX(1)+XFX(NF))/2.
         i=1
         do 41 while ((FY(i).eq.0).and.(i.lt.NF))
41          i=i+1
         if(i.gt.1) i=i-1
         j1=i
c         z1=MIN(-10,(i-2)XFX(i)-2*DX)
         i=NF
         do 42 while ((FY(i).eq.0).and.(i.gt.1))
42          i=i-1
         if(i.lt.NF) i=i+1
         j2=i
         jr=j2-j1+5
         jr=MAX(jr,20)
         j1=MAX(j1-jr/2,1)
         j2=MIN(j2+jr/2,NF)
         RANGE=ABS(XFX(J2)-XFX(J1))
      ENDIF
      PORT.WX1=CENTRE-RANGE/2.
      PORT.WX2=CENTRE+RANGE/2.
      PORT.WY2=PMAX*1.25

      IF(ESCAN) THEN
         PORT.XTIT='E '//CUNIT
      ELSE
         PORT.XTIT='steps '
      ENDIF
      PORT.YTIT='counts '
      PORT.HEAD=' '

      CALL CLRPORT(PORT)
      CALL PLOTFRAME(PORT,1,1,1.,0)


C//   spectrum:

      IF(ILINE.EQ.0) THEN
          CALL PGSLS(1)
      ELSE
          CALL PGSLS(ILINE)
      ENDIF
      CALL PGSCI(IC)


      IF (IP.NE.0) CALL PGPOINT(NF,XFX,FY,IP)
      IF (ILINE.NE.0) CALL PGLINE(NF,XFX,FY)
      IF(PLOTDATA) THEN
         CALL PGSCH(2.)
         CALL PGSCI(3)
         CALL PGPOINT(NP,SPXD,SPY(IB),17)      ! Plot SPY starting from IB
         CALL PGSCH(1.)
      ENDIF
      CALL PGSCI(1)
      CALL PGSLS(1)


C//   legend:

      CALL PGSCH(0.8)
      WRITE(LEG1,102) QHKL
      WRITE(LEG2,103) EN,CUNIT(2:4)
      CALL STRCOMPACT(LEG1,IS1,IL1)
      CALL STRCOMPACT(LEG2,IS2,IL2)
      CALL PGMTEXT('T',-1.5,0.05,0.0,LEG1(IS1:IS1+IL1-1)//'  '
     &    //LEG2(IS2:IS2+IL2-1))
      WRITE(LEG1,104) DELQ
      WRITE(LEG2,105) DE,CUNIT(2:4)
      CALL STRCOMPACT(LEG1,IS1,IL1)
      CALL STRCOMPACT(LEG2,IS2,IL2)
      CALL PGMTEXT('T',-3.0,0.05,0.0,LEG1(IS1:IS1+IL1-1)//'  '
     &    //LEG2(IS2:IS2+IL2-1))
      CALL PGSCH(1.0)

      END


C--------------------------------------------------------------------
      SUBROUTINE PLOTCELL(PORT,N,IC,IP,ILINE)
C Plot N-th dataset and corresponding histogram in PORT:
C Show filename and ChiSqr
C   PORT       ... plotting viewport
C   N          ... dataset index
C   IC         ... color
C   IP         ... point style
C   ILINE      ... line style
C CALLS: GETDATASCALE
C CALLED BY: PLOT_MDATA
C--------------------------------------------------------------------
      IMPLICIT NONE
      
      INCLUDE 'const.inc'
      INCLUDE 'inout.inc'
      INCLUDE 'rescal.inc'
      INCLUDE 'restrax.inc'
      INCLUDE 'res_grf.inc'

      RECORD /VIEWSET/ PORT
      CHARACTER*72 LEG1,LEG2,HEADER
      INTEGER*4 NF,NP,IB,N,IBH
      REAL*4 FX(128),FY(128)
      REAL*4 SPXD(NHI*4),SS,chsize
      REAL*8 PMAX,CENTRE,RANGE,XSTEP,X0,Z
      INTEGER*4 I,IC,IP,ILINE,K,IS1,IS2,IL1,IL2
      LOGICAL*4 PLOTDATA

      CHARACTER*5 XTIT(5)
      DATA XTIT /'QH','QK','QL','EN','A3'/

106   format('\gx\u2\d = ',G10.4)
102   format('Q= [',G10.4,' ',G10.4,' ',G10.4,']')
103   format('E= ',G10.4,' ',a3)
104   format('\gDQ=[',G10.4,' ',G10.4,' ',G10.4,']')
105   format('\gDE=',G10.4,' ',a3)
 


C// get N-th data and histogram

      NP=NPT(N)-NPT(N-1)   ! number of points incurrent data set
      IB=NPT(N-1)+1             ! base index for the incurrent data set
      NF=NHIST(N)-NHIST(N-1)   ! number of points in current histogram
      IBH=NHIST(N-1)+1          ! base index for current histogram
      do i=1,NF
         FY(I)=RHIST(I+IBH-1)
         FX(I)=XHIST(I+IBH-1)
      end do      
      IF(NP.GT.NHI*4) NP=NHI*4

C// decide whether to plot also measured data
C// yes, if  NP>0 and SPY(i)<>0
      Z=0.
      DO I=1,NP
        Z=Z+ABS(SPY(IB+I-1))
      ENDDO  
      PLOTDATA=(NP.GT.0.AND.Z.GT.0)

C// Find optimum x-scale
      CALL GETDATASCALE(N,CENTRE,RANGE,XSTEP,X0,K)
      
      IF (K.LE.0) RETURN
      
C// find maximum of Y and set X points
      PMAX=0
      IF (NP.GT.0) THEN
        DO i=1,NP
          PMAX=MAX(PMAX,SPY(I)*1.D0)
          SPXD(I)=SPX(I+IB-1)*XSTEP+X0  ! x-scale for data
        END DO
      ENDIF
      DO I=1,NF
        FX(I)=FX(I)*XSTEP + X0               ! x-scale for histogram
        PMAX=MAX(PMAX,FY(I)*1.D0)
      END DO
      IF (PMAX.LE.0) RETURN ! there is nothing to plot ...
C// Set Viewport
      PORT.WX1=CENTRE-RANGE/2.
      PORT.WX2=CENTRE+RANGE/2.
      PORT.WY1=0.
      PORT.WY2=PMAX*1.2      

      PORT.XTIT=XTIT(K)
      PORT.YTIT='counts '
      PORT.HEAD=' '

C// Set optimum character size

      chsize=MAX(0.7,2.3*(PORT.DX2-PORT.DX1))
      chsize=MIN(chsize,1.2)
      CALL PGSCH(chsize)
      
C// Plot main frame
      CALL CLRPORT(PORT)
      CALL PLOTFRAME(PORT,1,1,CHSIZE,0)


C set line style
      IF(ILINE.EQ.0) THEN
          CALL PGSLS(1)
      ELSE
          CALL PGSLS(ILINE)
      ENDIF
      
C set symbol size
      SS=MAX(0.3,3.*(PORT.DX2-PORT.DX1))
      SS=MIN(SS,2.)
      CALL PGSCH(SS)

C/ Plot curves

      IF(NF.GT.0) THEN
        CALL PGSCI(IC)
        IF (IP.NE.0) CALL PGPOINT(NF,FX,FY,IP)
        IF (ILINE.NE.0) CALL PGLINE(NF,FX,FY)
      ENDIF
      IF(PLOTDATA) THEN
        CALL PGSCI(3)
        CALL PGPOINT(NP,SPXD,SPY(IB),17)      ! Plot SPY starting from IB
      ENDIF
      CALL PGSCI(1)
      CALL PGSLS(1)
      HEADER=' '
      IF(NP.GT.0) HEADER=mf_name(N)
      
C Plot Legend      
      IF(PLOTDATA) THEN
         CALL PGSCH(CHSIZE*0.8)
         WRITE(LEG1,106) DCHISQ(N)
         IF(mf_cur.eq.N) CALL PGSCI(2)
         CALL PGMTEXT('T',-1.5,0.6,0.0,HEADER(1:16))
         CALL PGSCI(1)
         CALL PGMTEXT('T',-1.5,0.05,0.0,LEG1(1:20))
      ELSE
        CALL PGSCH(CHSIZE*0.8)
        WRITE(LEG1,102) (RES_DAT(i_QH+i-1),i=1,3)
        WRITE(LEG2,103) RES_DAT(i_EN),CUNIT(2:4)
        
        CALL STRCOMPACT(LEG1,IS1,IL1)
        CALL STRCOMPACT(LEG2,IS2,IL2)
        CALL PGMTEXT('T',-1.5,0.05,0.0,LEG1(IS1:IS1+IL1-1)//'  '
     &    //LEG2(IS2:IS2+IL2-1))
        WRITE(LEG1,104) (RES_DAT(i_DQH+i-1),i=1,3)
        WRITE(LEG2,105) RES_DAT(i_DEN),CUNIT(2:4)
        CALL STRCOMPACT(LEG1,IS1,IL1)
        CALL STRCOMPACT(LEG2,IS2,IL2)
        CALL PGMTEXT('T',-3.0,0.05,0.0,LEG1(IS1:IS1+IL1-1)//'  '
     &    //LEG2(IS2:IS2+IL2-1))
      ENDIF
      CALL PGSCH(1.)

      END

C $Log: resgraph2.f,v $
C Revision 1.10  2006/05/12 11:45:29  saroun
C problems with CR/LF conversions
C