C//////////////////////////////////////////////////////////////////////
C////
C////  R E S T R A X   4.8
C////
C////  Graphics output subroutines (PGPlot library required)
C////  LEVEL 3 subroutines (plotting primitives)
C////  PLOT ELEMENTS, SETTING VIEWPORTS, DEFINE PLOT SCALES, FORMAT LABELS,
C////  SAVE RESULTS 
C////
C//////////////////////////////////////////////////////////////////////

C*************************  PLOT ELEMENTS ********************************

C-------------------------------------------------------------
      SUBROUTINE PLOT2D(PORT,A,NX,NY,NDX,NDY,LOGSCALE)
C plots a gray-scale map of the array A to the viewport PORT
C assumes positive (>=0) values in A matrix, negative ones are ignored
C-------------------------------------------------------------
      IMPLICIT NONE

      INCLUDE 'const.inc'
      INCLUDE 'res_grf.inc'

      INTEGER*4 I,J,NX,NY,NDX,NDY 
      REAL*4 A(NDX,NDY),CX,DX,CY,DY,TR(6),AMIN,AMAX
      RECORD/VIEWSET/ PORT
      REAL*4 LOGSCALE ! base for logarithmic scale
      REAL*4 AUX(MIMAX,MIMAX),L0,RANGE

      DX=(PORT.WX2-PORT.WX1)/NX
      CX=(PORT.WX2+PORT.WX1)/NX

      DY=(PORT.WY2-PORT.WY1)/NY
      CY=(PORT.WY2+PORT.WY1)/NY

      TR(1)=-0.5*DX+PORT.WX1
      TR(2)=DX
      TR(3)=0.
      TR(4)=-0.5*DY+PORT.WY1
      TR(5)=0.
      TR(6)=DY
      AMIN=1.D20
      AMAX=-1.D20
      DO 20 I=1,NX
      DO 20 J=1,NY
          IF (A(I,J).GT.AMAX) AMAX=A(I,J)
          IF (A(I,J).LT.AMIN) AMIN=A(I,J)
20    CONTINUE
      IF (LOGSCALE.LE.0.0) THEN
        CALL PGVPORT(PORT.DX1,PORT.DX2,PORT.DY1,PORT.DY2)
        CALL PGWINDOW(PORT.WX1,PORT.WX2,PORT.WY1,PORT.WY2)
        CALL PGGRAY(A,NDX,NDY,1,NX,1,NY,AMAX*1.1,0.,TR)
      ELSE IF (AMAX.GT.0.AND.AMIN.LT.AMAX) THEN
        L0=LOG(10.)
        IF (AMIN.LE.0) AMIN=1.E-20
        RANGE=LOG(AMAX/AMIN)/L0
        IF (RANGE.GT.16.0) THEN
          AMIN=AMAX*exp(-16.0*L0) 
          RANGE=16.0
        ENDIF  
        IF (RANGE.LT.1.0) THEN
          AMIN=AMAX*exp(-1.0*L0) 
          RANGE=1.0
        ENDIF  
        DO I=1,NX
        DO J=1,NY
          IF (A(I,J).GT.0) THEN
            AUX(I,J)=LOG(A(I,J)/AMIN)/L0
          ELSE
            AUX(I,J)=0.D0
          ENDIF              
        ENDDO
        ENDDO        
        CALL PGVPORT(PORT.DX1,PORT.DX2,PORT.DY1,PORT.DY2)
        CALL PGWINDOW(PORT.WX1,PORT.WX2,PORT.WY1,PORT.WY2)
        CALL PGGRAY(AUX,MIMAX,MIMAX,1,NX,1,NY,RANGE*1.1,0.,TR)
      ENDIF  

      RETURN
      END
C-------------------------------------------------------------
      SUBROUTINE PLOTCMAP(PORT,A,NDX,NDY,C,NC)
C   plots a contour map of the array A to the viewport PORT
C-------------------------------------------------------------
      IMPLICIT NONE

      INCLUDE 'res_grf.inc'

      INTEGER*4 NX,NY,NDX,NDY,NC 
      REAL*4 A(NDX,NDY),CX,DX,CY,DY,TR(6),C(NC)
      RECORD/VIEWSET/ PORT

      NX=NDX
      NY=NDY

      DX=(PORT.WX2-PORT.WX1)/NX
      CX=(PORT.WX2+PORT.WX1)/NX

      DY=(PORT.WY2-PORT.WY1)/NY
      CY=(PORT.WY2+PORT.WY1)/NY

      TR(1)=-0.5*DX+PORT.WX1
      TR(2)=DX
      TR(3)=0.
      TR(4)=-0.5*DY+PORT.WY1
      TR(5)=0.
      TR(6)=DY
      CALL PGVPORT(PORT.DX1,PORT.DX2,PORT.DY1,PORT.DY2)
      CALL PGWINDOW(PORT.WX1,PORT.WX2,PORT.WY1,PORT.WY2)
      CALL PGCONT (A,NDX,NDY,1,NX,1,NY, C, NC, TR)

      RETURN
      END

C---------------------------------------------------------------
      SUBROUTINE PLOTFRAME(PORT,ICL,ILS,ZCH,IAX)
C  plots frame, axes and titles of the viewport PORT with given
C  collor index (ICL), line style (ILS) and character size (ZCH)
C  If IAX=0, axes at (0,0) are not plotted.
C---------------------------------------------------------------
      IMPLICIT NONE

      INCLUDE 'res_grf.inc'
      
      INTEGER*4 ICL,ILS,IAX
      REAL*4 ZCH

      RECORD/VIEWSET/ PORT

      CALL PGSCH(ZCH)
      CALL PGVPORT(PORT.DX1,PORT.DX2,PORT.DY1,PORT.DY2)
      CALL PGWINDOW(PORT.WX1,PORT.WX2,PORT.WY1,PORT.WY2)
      CALL PGSCI(ICL)
      CALL PGSLS(ILS)
      IF(IAX.EQ.0) THEN
         CALL PGBOX('BCNST',0.0,0,'BCNST',0.0,0)
      ELSE
         CALL PGBOX('ABCNST',0.0,0,'ABCNST',0.0,0)
      ENDIF
      CALL PGLAB(PORT.XTIT,PORT.YTIT,PORT.HEAD)
      CALL PGSCH(1.0)

      RETURN
      END
      
C------------------------------------------------------------------
      SUBROUTINE PLOTELL(PORT,ICL,ILS,A,U,IS)
C  plots projection (IS=0) or section (IS=1) of the 4-dim. ellipsoid
C  defined by the matrix A(4,4) and the centre position U(4).
C  The projection plane is specified by the IX and IY fields of
C  the PORT record.
C  color index (ICL), line style (ILS), character size (ZCH)
C-------------------------------------------------------------------
      IMPLICIT NONE
      
      INTEGER*4 ICL,ILS,IS,NP,I
      PARAMETER(NP=100)
      REAL*8 A(4,4),B(2,2),U(4)
      REAL*8 D,D1,DET,STEP,CF,Z
      REAL*4 X(NP),F(NP)


      INCLUDE 'res_grf.inc'

      RECORD/VIEWSET/ PORT

      CALL REDUCE42(A,B,PORT.IX,PORT.IY,IS)

      CALL PGVPORT(PORT.DX1,PORT.DX2,PORT.DY1,PORT.DY2)
      CALL PGWINDOW(PORT.WX1,PORT.WX2,PORT.WY1,PORT.WY2)
      CALL PGSCI(ICL)
      CALL PGSLS(ILS)


c      if(PORT.IX.EQ.1.AND.PORT.IY.EQ.2) then
c10     format('ELL: ',3(G12.5,1x))
c      write(*,10) B(1,1),B(1,2),B(2,2)
c      write(*,10) U(PORT.IX),U(PORT.IY)
c      endif

      CF=2.0D0*LOG(2.0D0)
      D1= SQRT(CF*B(2,2)/(B(2,2)*B(1,1)-B(1,2)**2))
      STEP=2.*D1/(NP-1)
      DO 1 I=1,NP
        D=I-1
        Z=-D1+D*STEP
        X(I)=Z+U(PORT.IX)
        DET=(B(1,2)*Z)**2-B(2,2)*(B(1,1)*Z**2-CF)
        F(I)=(-B(1,2)*Z+SQRT(ABS(DET)))/B(2,2)+U(PORT.IY)
1     CONTINUE
      CALL PGLINE(NP,X,F)
      DO 2 I=1,NP
        X(I)=-X(I)+2.*U(PORT.IX)
        F(I)=-F(I)+2.*U(PORT.IY)
2     CONTINUE
      CALL PGLINE(NP,X,F)
      CALL PGSCI(1)
      CALL PGSLS(1)
      RETURN
      END


C-----------------------------------------------------
      SUBROUTINE PLOTLINE(PORT,ICL,ILS,X,Y,NP)
C  plots line in physical coordinates given by vectors
C  X(NP) and Y(NP) to the PORT.
C  ICL .. collor,  ILS .. line style
C-----------------------------------------------------
      IMPLICIT NONE

      INCLUDE 'res_grf.inc'
      
      INTEGER*4 ICL,ILS,NP
      REAL*4 X(NP),Y(NP)
      RECORD/VIEWSET/ PORT

      CALL PGVPORT(PORT.DX1,PORT.DX2,PORT.DY1,PORT.DY2)
      CALL PGWINDOW(PORT.WX1,PORT.WX2,PORT.WY1,PORT.WY2)
      CALL PGSCI(ICL)
      CALL PGSLS(ILS)

      CALL PGLINE(NP,X,Y)

      RETURN
      END


C--------------------------------------------------------------------
      SUBROUTINE PlotCurve(PORT,XFX,FY,NF,IC,IP,ILINE)
C  Plot a curve on PORT.
C   PORT       ... plotting viewport
C   XFX        ... x-values
C   FY         ... y-values
C   NF         ... number of points
C   IC         ... color
C   IP         ... point style
C   ILINE      ... line style
C CALLS:
C CALLED BY: VIEWSCAN
C--------------------------------------------------------------------
      IMPLICIT NONE

      INCLUDE 'res_grf.inc'

      INTEGER*4 NF
      RECORD /VIEWSET/ PORT

      REAL*4 XFX(NF),FY(NF)
      REAL*8 CENTRE,RANGE
      INTEGER*4 I,IC,IP,ILINE,J1,J2,jr

C//   define viewport:

      IF (PORT.WX1.EQ.PORT.WX2) THEN
        CENTRE=(XFX(1)+XFX(NF))/2.
        i=1
        do 41 while ((FY(i).eq.0).and.(i.lt.NF))
41          i=i+1
        if(i.gt.1) i=i-1
        j1=i
        i=NF
        do 42 while ((FY(i).eq.0).and.(i.gt.1))
42         i=i-1
        if(i.lt.NF) i=i+1
        j2=i
        jr=j2-j1+5
        jr=MAX(jr,20)
        j1=MAX(j1-jr/2,1)
        j2=MIN(j2+jr/2,NF)
        RANGE=ABS(XFX(J2)-XFX(J1))
        PORT.WX1=CENTRE-RANGE/2.
        PORT.WX2=CENTRE+RANGE/2.
      ENDIF
      IF (PORT.WY1.EQ.PORT.WY2) THEN
         PORT.WY1=+1E+20
         PORT.WY2=-1E+20
         DO I=1,NF
           PORT.WY2=MAX(PORT.WY2,FY(I))
           PORT.WY1=MIN(PORT.WY1,FY(I))
         END DO
         PORT.WY1=PORT.WY1*1.1
         PORT.WY2=PORT.WY2*1.1
      ENDIF

      IF (PORT.WY1.EQ.PORT.WY2) RETURN
      IF (PORT.WX1.EQ.PORT.WX2) RETURN
      CALL CLRPORT(PORT)
      CALL PLOTFRAME(PORT,1,1,1.3,0)
      IF(ILINE.EQ.0) THEN
          CALL PGSLS(1)
      ELSE
          CALL PGSLS(ILINE)
      ENDIF
      CALL PGSCI(IC)
      IF (IP.NE.0) CALL PGPOINT(NF,XFX,FY,IP)
      IF (ILINE.NE.0) CALL PGLINE(NF,XFX,FY)
      CALL PGSCI(1)
      CALL PGSLS(1)

      END

C*************************  SETTING VIEWPORTS ********************************

C-------------------------------------------------------------
      SUBROUTINE CLRPORT(PORT)
C     clear viewport
C-------------------------------------------------------------
      IMPLICIT NONE 

      INCLUDE 'res_grf.inc'

      RECORD/VIEWSET/ PORT

      CALL PGVPORT(PORT.DX1,PORT.DX2,PORT.DY1,PORT.DY2)
      CALL PGWINDOW(0.,1.,0.,1.)
      CALL PGSCI(0)
      CALL PGRECT(0.,1.,0.,1.)
      CALL PGSCI(1)
      END


C---------------------------------------------------------
      SUBROUTINE MK_PORTS(ICOM)
C   Defines viewport parameters for the four projections
C   of the ellipsoid defined by the matrix in C&N system:
C   ICOM=2,3   ...  ANESS(4,4) from the common /NESSIF/
C   ICOM=1     ...  A(4,4) from the common /MATRIX/
C---------------------------------------------------------
      IMPLICIT NONE
      
      INCLUDE 'const.inc'
      INCLUDE 'restrax.inc'
      INCLUDE 'res_grf.inc'
      
      INTEGER*4 PLANE(2,4),I,ICOM
      CHARACTER*17 IND(4)
      REAL*4 XMIN(4),XMAX(4),QM

      DATA IND/'Q\dX\u [\A\u-1\d] ','Q\dY\u [\A\u-1\d] ',
     *'Q\dZ\u [\A\u-1\d] ','   '/

      IND(4)= '   \gDE '//CUNIT


C///  Specify the four planes for drawing projections

      PLANE(1,1)=1
      PLANE(2,1)=4

      PLANE(1,2)=1
      PLANE(2,2)=2

      PLANE(1,3)=2
      PLANE(2,3)=3

      PLANE(1,4)=2
      PLANE(2,4)=4


C///  Specify 4 viewports  :

      VPORT(4).DX1=0.1
      VPORT(4).DX2=0.47
      VPORT(4).DY1=0.33
      VPORT(4).DY2=0.58

      VPORT(3).DX1=VPORT(4).DX1+0.5
      VPORT(3).DX2=VPORT(4).DX2+0.5
      VPORT(3).DY1=VPORT(4).DY1
      VPORT(3).DY2=VPORT(4).DY2

      VPORT(2).DX1=VPORT(4).DX1+0.5
      VPORT(2).DX2=VPORT(4).DX2+0.5
      VPORT(2).DY1=VPORT(4).DY1+0.35
      VPORT(2).DY2=VPORT(4).DY2+0.35

      VPORT(1).DX1=VPORT(4).DX1
      VPORT(1).DX2=VPORT(4).DX2
      VPORT(1).DY1=VPORT(4).DY1+0.35
      VPORT(1).DY2=VPORT(4).DY2+0.35

C//// Set scales:


      IF(ICOM.EQ.3) THEN
         CALL GETMSCALE(XMIN,XMAX)
         DO I=1,4
            VPORT(I).WX1=XMIN(PLANE(1,I))
            VPORT(I).WX2=XMAX(PLANE(1,I))
            VPORT(I).WY1=XMIN(PLANE(2,I))
            VPORT(I).WY2=XMAX(PLANE(2,I))
         END DO
      ENDIF


      DO 10 I=1,4
       IF(ICOM.EQ.2) THEN
         CALL GETSCALE(ANESS,PLANE(1,I),PLANE(2,I),0,
     1   VPORT(I).WX1,VPORT(I).WX2,VPORT(I).WY1,VPORT(I).WY2)
       ELSE IF(ICOM.LE.1) THEN
         CALL GETSCALE(ATRAX,PLANE(1,I),PLANE(2,I),0,
     1   VPORT(I).WX1,VPORT(I).WX2,VPORT(I).WY1,VPORT(I).WY2)
       ENDIF
       VPORT(I).XTIT=IND(PLANE(1,I))
       VPORT(I).YTIT=IND(PLANE(2,I))
       VPORT(I).HEAD=' '
       VPORT(I).IX=PLANE(1,I)
       VPORT(I).IY=PLANE(2,I)
10    CONTINUE

      QM=VPORT(2).WX2
      QM=MAX(QM,VPORT(2).WY2)
C      QM=MAX(QM,VPORT(3).WY2)
      DO 12 I=1,4
       IF((PLANE(1,I).NE.4).AND.(PLANE(1,I).NE.3)) THEN
         VPORT(I).WX2=QM
         VPORT(I).WX1=-QM
       ENDIF
       IF((PLANE(2,I).NE.4).AND.(PLANE(2,I).NE.3)) THEN
         VPORT(I).WY2=QM
         VPORT(I).WY1=-QM
       ENDIF
12    CONTINUE

      RETURN
      END


C----------------------------------------------------------------------
      SUBROUTINE SETPORTCELL(PORT,NROW,NCOL,N)
C   Set viewport dimensions and position for given layout and cell index
C NCOL ... number of coulmns
C NROW ... number of rows
C N .. cell index (from top left to bottom right)
C----------------------------------------------------------------------
      IMPLICIT NONE
      INCLUDE 'res_grf.inc'
      
      RECORD /VIEWSET/ PORT
      INTEGER*4 NROW,NCOL,N
      REAL*4 ASPECT,HEIGHT,WIDTH,M1,Z
      INTEGER*4 ICOL,IROW
      REAL*4 MAR(6)   ! margins: left,right,top,bottom, H-spacing, V-spacing in page fraction
      DATA MAR /0.08,0.02,0.02,0.10,0.08,0.07/


      M1=MAR(1)
      IF(NCOL.EQ.1) M1=2.*MAR(1)
      ASPECT=(1.*NROW)/NCOL
      IROW=INT(0.999*N/NCOL)+1
      ICOL=N-(IROW-1)*NCOL
      WIDTH=(1.-M1-MAR(2)-MAR(5)*(NCOL-1))/NCOL
      PORT.DX1=M1+(ICOL-1)*(WIDTH+MAR(5))
      PORT.DX2=PORT.DX1+WIDTH
      Z=1.
      IF (NROW.LE.2) Z=1.5
      HEIGHT=(1.-MAR(3)-MAR(4)-Z*MAR(6)*(NROW-1))/NROW
      HEIGHT=MIN(HEIGHT,ASPECT*WIDTH)
      PORT.DY2=1-MAR(3)-(IROW-1)*(HEIGHT+MAR(6)*Z)
      PORT.DY1=PORT.DY2-HEIGHT
      END



C*************************  DEFINE PLOT SCALES ********************************


C----------------------------------------------------------
      SUBROUTINE GETSCALE(A,IX,IY,IS,X1,X2,Y1,Y2)
C Calculates physical scales of a graph for ellipsoid projections 
C   A       ... resolution matrix
C   IX,IY   ... defines projection plane
C   IS<>0   ... use ellipsoid section instead of projection
C   X1..Y2  ... output: plot scales
C CALLED BY: PlotResol,PlotResQE
C----------------------------------------------------------
      IMPLICIT NONE
      
      REAL*8 A(4,4),B(2,2),DD(2),CF,FACT1,FACT2
      INTEGER*4 CODE(2),EXPON(2),IX,IY,IS,I
      REAL*4 X1,X2,Y1,Y2

      CALL REDUCE42(A,B,IX,IY,IS)

C///  Scales of the axes are calculated from the ellipsoid limits:

      CF=2.0*LOG(2.0D0)
      DD(1)= SQRT(ABS(CF*B(2,2)/(B(2,2)*B(1,1)-B(1,2)**2)))
      DD(2)= SQRT(ABS(CF*B(1,1)/(B(1,1)*B(2,2)-B(1,2)**2)))
c      do i=1,2
c        write(*,*) (B(i,j),j=1,2)
c      enddo
c      write(*,*) DD(1),DD(2),IX,IY

      DO 10,I=1,2
        EXPON(I)=ABS(LOG10(DD(I)))
        IF (DD(I).LT.1) EXPON(I)=-EXPON(I)-1
        IF(DD(I)/10.**EXPON(I).LT.3) THEN
          CODE(I)=1
        ELSE IF(DD(I)/10.**EXPON(I).LT.6) THEN
          CODE(I)=2
        ELSE
          CODE(I)=5
        ENDIF
10    CONTINUE

      FACT1=CODE(1)*10.0**EXPON(1)
      FACT2=CODE(2)*10.0**EXPON(2)
      X1=-3.0*FACT1
      Y1=-3.0*FACT2
      X2=-X1
      Y2=-Y1
      IF (Y1.EQ.Y2) Y2=Y2+1E-15
      IF (X1.EQ.X2) X2=X2+1E-15

      RETURN
      END

C--------------------------------------------------------------------
      SUBROUTINE GETMSCALE(XMIN,XMAX)
C Calculates physical limits of a graph for the Monte Carlo events.
C Works with current dataset.
C   XMIN(4), XMAX(4)  ... plot limits in C&N coordinates
C CALLED BY: VIEWSCAN,MK_PORTS
C--------------------------------------------------------------------
      IMPLICIT NONE

      INCLUDE 'const.inc'      
      INCLUDE 'restrax.inc'
      
      REAL*8 DD(4)     !,dd1(4)
      INTEGER*4 CODE(4),EXPON(4),I,J,NCNT
      REAL*4 XMIN(4),XMAX(4)
      REAL*8 E1(4),FACT(4),P

      CALL KSTACK_N(NCNT,mf_cur)
      IF (NCNT.LE.0) RETURN

      DO I=1,4
        DD(I)=0
c        dd1(j)=0
      END DO
      DO I=1,NCNT
         CALL GETQE(I,mf_cur,E1,P)
         DO J=1,4
           DD(J)=MAX(ABS(E1(J)),DD(J))

c           dd1(j)=min(e1(j),dd1(j))
         END DO
      ENDDO

      DO 10,I=1,4
        EXPON(I)=ABS(LOG10(DD(I)))
        IF (DD(I).LT.1) EXPON(I)=-EXPON(I)-1
        IF(DD(I)/10.**EXPON(I).LT.2) THEN
          CODE(I)=2
        ELSE IF(DD(I)/10.**EXPON(I).LT.4) THEN
          CODE(I)=4
        ELSE IF(DD(I)/10.**EXPON(I).LT.6) THEN
          CODE(I)=6
        ELSE IF(DD(I)/10.**EXPON(I).LT.8) THEN
          CODE(I)=8
        ELSE
          CODE(I)=10
        ENDIF
        FACT(I)=CODE(I)*10.0**EXPON(I)
        XMIN(I)=-FACT(I)
        XMAX(I)=+FACT(I)
        IF (XMAX(I).EQ.XMIN(I)) XMAX(I)=XMAX(I)+1E-15
10    CONTINUE

      RETURN
      END

C----------------------------------------------------------------------
      SUBROUTINE GETDATASCALE(N,CENTRE,RANGE,XSTEP,X0,INDX)
C Get optimum scale for data X-axis of N-th dataset
C   N        ... Index of dataset
C   CENTRE  ... X-axis centre
C   RANGE   ... X-axis range
C   XSTEP   ... mean step (used to construct phys. values from XHIST etc..)
C   X0      ... scan centre
C   INDX    ... INDX = 1..4 for QH,QK,QL,E respectively
C               denotes the most rapidly varying coordinate
C CALLED BY: PLOTCELL
C----------------------------------------------------------------------
      IMPLICIT NONE
      
      INCLUDE 'const.inc'
      INCLUDE 'inout.inc'
      INCLUDE 'rescal.inc'
      INCLUDE 'restrax.inc'

      INTEGER*4 NF,NP,IB,N,IBH,INDX
      REAL*4 FX(NHI*4),FY(NHI*4)
      REAL*8 CENTRE,RANGE,XSTEP,X0
      INTEGER*4 I,J1,J2,jr,K
      
      NP=NPT(N)-NPT(N-1)   ! number of points incurrent data set
      IF(NP.GT.NHI*4) NP=NHI*4
      
C// get QHKL,E component which varies most rapidly            
C// if spectrum is loaded, get x-axis points from it
      IF (NP.GT.0) THEN
        IB=NPT(N-1)+1        ! base index for the incurrent data set
        XSTEP=0.
        DO I=1,5
          IF(ABS(DQE0(I,N)).GT.XSTEP) THEN
            K=I 
          ENDIF
          XSTEP=ABS(DQE0(I,N))
        ENDDO
c        XSTEP=DQE0(K,N)
c        X0=QE0(K,N)
        XSTEP=mf_par(i_DQH+K-1,N)
        X0=mf_par(i_QH+K-1,N)
        IF (K.EQ.5) X0=0
        
        CENTRE=(SPX(NP+IB-1)+SPX(IB))*XSTEP/2. +X0
        RANGE=ABS(SPX(NP+IB-1)-SPX(IB))*2*XSTEP
C// otherwise use step size and histogram content
      ELSE 
        NF=NHIST(N)-NHIST(N-1)   ! number of points in current histogram
        IF (NF.LE.0) GOTO 99     ! nothing to plot -> exit
        IBH=NHIST(N-1)+1         ! base index for current histogram
        do i=1,NF
          FX(I)=XHIST(I+IBH-1)
          FY(I)=RHIST(I+IBH-1)
        end do      
        XSTEP=0.
        DO I=1,4
          IF(ABS(mf_par(i_DQH+I-1,N)).GT.XSTEP) THEN
            K=I 
          ENDIF
          XSTEP=ABS(mf_par(i_DQH+I-1,N))
        ENDDO
        XSTEP=mf_par(i_DQH+K-1,N)     
        X0=mf_par(i_QH+K-1,N)      
        IF (K.EQ.5) X0=0
        DO I=1,NF
          FX(I)=FX(I)*XSTEP + X0
        ENDDO        
        CENTRE=(FX(1)+FX(NF))/2.
        i=1
        do 41 while ((FY(i).eq.0).and.(i.lt.NF))
41          i=i+1
        if(i.gt.1) i=i-1
        j1=i
        i=NF
        do 42 while ((FY(i).eq.0).and.(i.gt.1))
42          i=i-1
        if(i.lt.NF) i=i+1
        j2=i
        jr=j2-j1+5     ! number of non-zero points + 5
        jr=MAX(jr,20)  ! show at least 20 points
        j1=MAX(j1-jr/2,1)
        j2=MIN(j2+jr/2,NF)
        RANGE=ABS(FX(J2)-FX(J1))
      ENDIF
      
      INDX=K
      RETURN

99    CENTRE=0
      RANGE=1
      XSTEP=0.1
      X0=-0.5
      INDX=0
      END


C---------------------------------------------------------      
      SUBROUTINE FCONE_RANGE(xmin,xmax,ymin,ymax,EQSCALE)
C define automatically viewport scales for flat-cone scan
C if EQSCALE, then make aspect ratio=1
C---------------------------------------------------------            
      implicit none
      INCLUDE 'const.inc'
      INCLUDE 'inout.inc'
      INCLUDE 'rescal.inc'     
      INCLUDE 'restrax.inc' 
      INCLUDE 'res_grf.inc'
      
      REAL*8 xmin,xmax,ymin,ymax
      LOGICAL*4 EQSCALE
      REAL*4 QI(3) 
      REAL*8 QF1(3),QF2(3)
      REAL*8 X0,X1,X2,Y0,Y1,Y2,XMI,XMA,YMI,YMA,DA3,AXN,BXN
      INTEGER*4 ID,J,NP
      REAL*8 SC(17),DUM,DX,DY
      REAL*8 ROUNDSCALE
      REAL*8 AX(3),BX(3),QxQ 
      EQUIVALENCE (AX(1),mf_par(i_AX,1))
      EQUIVALENCE (BX(1),mf_par(i_BX,1))
      
10    format(a,6(1x,G10.4))

      DO J=1,17
        SC(J)=1+J*0.5 ! possible rounded scale limits
      ENDDO
      
      NP=NHIST(1)
      DA3=(NP-1)/2*mf_par(i_DA3,1)
      CALL QNORM(AX,AXN,DUM)
      CALL QNORM(BX,BXN,DUM)
      
      XMI=1D10
      XMA=-1D10       
      YMI=1D10       
      YMA=-1D10       
      DO ID=1,mf_max
        DO J=1,3
          QI(J)=mf_par(i_QH+J-1,ID)
        ENDDO  
        call ROTA3(QI,DA3,QF1)
        call ROTA3(QI,-DA3,QF2)
        X0=QxQ(mf_par(i_QH,ID),AX)/AXN
        X1=QxQ(QF1,AX)/AXN
        X2=QxQ(QF2,AX)/AXN
        Y0=QxQ(mf_par(i_QH,ID),BX)/BXN
        Y1=QxQ(QF1,BX)/BXN
        Y2=QxQ(QF2,BX)/BXN
        XMI=MIN(XMI,X0,X1,X2)
        YMI=MIN(YMI,Y0,Y1,Y2)
        XMA=MAX(XMA,X0,X1,X2)
        YMA=MAX(YMA,Y0,Y1,Y2)
      ENDDO
      DX=XMA-XMI
      DY=YMA-YMI
      
      XMIN=ROUNDSCALE(XMI-DX/20.,-1,SC,17)
      XMAX=ROUNDSCALE(XMA+DX/20.,1,SC,17)
      YMIN=ROUNDSCALE(YMI-DY/20.,-1,SC,17)
      YMAX=ROUNDSCALE(YMA+DY/20.,1,SC,17)
      IF (XMIN.GT.0.AND.XMIN.LT.0.1*DX) XMIN=0
      IF (YMIN.GT.0.AND.YMIN.LT.0.1*DY) YMIN=0
      IF (XMAX.LT.0.AND.XMAX.GT.-0.1*DX) XMAX=0
      IF (YMAX.LT.0.AND.YMAX.GT.-0.1*DY) YMAX=0
      IF (ABS(XMIN).LT.0.05*DX) XMIN=0
      IF (ABS(YMIN).LT.0.05*DX) YMIN=0
      IF (ABS(XMAX).LT.0.05*DX) XMAX=0
      IF (ABS(YMAX).LT.0.05*DX) YMAX=0
      IF (EQSCALE) THEN
        XMA=(XMAX-XMIN)
        YMA=(YMAX-YMIN)
        IF (XMA.GT.0) THEN        
          DA3=YMA/XMA
          IF (DA3.GT.1) THEN
             XMAX=XMIN+YMA          
          ELSE
             YMAX=YMIN+XMA
          ENDIF   
        ENDIF       
      ENDIF
c      write(*,10) 'rounded: ',XMIN,XMAX,YMIN,YMAX
      
      END
      
C*************************  FORMAT LABELS ********************************

C--------------------------------------------------------------------
      SUBROUTINE GetAxTitle(V,S)
C// format the a label to write dir. V in symbolic format, if possible 
C--------------------------------------------------------------------
      IMPLICIT NONE
      character*3 chind(3)
      CHARACTER*30 S
      REAL*8 V(3),Z
      INTEGER*4 J,i
101   format('[',F6.2,' ',F6.2,' ',F6.2,'] / rel.')
104   format('[ ',a3,'  ',a3,'  ',a3,' ] ') 

      J=0
      z=0
      do i=1,3
        if (V(i).ne.0.and.V(i).ne.z) then
          J=J+1
          if(z.eq.0) z=V(i)
        endif  
      end do
      if (J.eq.1) then
        do i=1,3
          if(V(i).ne.0) then 
            chind(i)='\gc'
          else
            chind(i)=' 0 '
          endif
        end do
        WRITE(S,104) (chind(i),i=1,3)        
      else
        WRITE(S,101) V
      endif      
    
      END


C----------------------------------------      
      SUBROUTINE FORMAT_HKL(V,S,NS)
C----------------------------------------            
      implicit none
      CHARACTER*(*) S
      CHARACTER*128 S1,S2
      REAL*8 V(3)
      INTEGER*4 I,IS,IL,NS
      LOGICAL*4 LOG
10    format('[',3(1x,I3),' ]')      
20    format('[',3(1x,F6.1),' ]')      
      
      
      LOG=.TRUE.
      DO I=1,3
        LOG=(LOG.AND.(ABS(V(I)-NINT(V(I))).LT.1E-2))
      ENDDO
      IF (LOG) THEN
c        write(*,10) (NINT(V(I)),I=1,3)
        WRITE(S1,10)  (NINT(V(I)),I=1,3)
      ELSE
c        WRITE(*,20) V
        WRITE(S1,20) V
      ENDIF    
      IS=1
      CALL BOUNDS(S1,IS,IL)
      I=1
      DO WHILE (I.GT.0) ! remove extra spaces
        I=INDEX(S1(IS:IS+IL-1),'  ')
        IF (I.GT.0) THEN
          S2=S1(IS:I)//S1(I+2:IS+IL-1)          
          S1=S2  
          CALL BOUNDS(S1,IS,IL)        
        ENDIF
      ENDDO  
      IF (IL.GT.NS) IL=NS
      S=S1(IS:IS+IL-1)
      END
      
C----------------------------------------------------------------------
      SUBROUTINE LEGFIT(PORT,SIZE,OFFSET)
C  Show fit parameters in the area defined by PORT
C  PORT     ... plotting viewport
C  SIZE     ... character size
C  OFFSET   ... left margin (in page width units)
C----------------------------------------------------------------------
      IMPLICIT NONE

      INCLUDE 'const.inc'
      INCLUDE 'inout.inc'
      INCLUDE 'restrax.inc'
      INCLUDE 'res_grf.inc'
      INCLUDE 'exciimp.inc'
            
      RECORD /MODEL/ rm
      
      REAL*8 eps
      REAL*4 SIZE,OFFSET
      PARAMETER (eps=1e-20) 

      RECORD /VIEWSET/ PORT

      CHARACTER*60 LEG1
      INTEGER*4 i,j,k
      REAL*4 rx

101   format('\gx\u2\d   =',G11.4)
102   format(a,'=',G11.4)

      CALL getmodel(rm)

      CALL PGSCH(SIZE)

      CALL PGVPORT(PORT.DX1,PORT.DX2,PORT.DY1,PORT.DY2)

      rx=0.04
      IF (JFIT.GT.0) THEN
         WRITE(LEG1,101) CHISQR
         CALL PGMTEXT('T',-OFFSET,rx,0.0,LEG1)
      ENDIF
      j=0
      DO I=1,nfpar
         k=INDEX(rm.parname(I),' ')
         if (k.le.0) k=10
         if (rm.FIXPARAM(i).GT.0) THEN
           j=j+1
           WRITE(LEG1,102) rm.parname(I)(1:k), fpar(I)
           CALL PGMTEXT('T',-OFFSET-1.5*j,rx,0.0,LEG1)
         endif  
      END DO
      CALL PGSCH(1.0)
      CALL PGSCI(1)

      END
      
C----------------------------------------------------------------------
      SUBROUTINE LEGFILE(PORT)
C Show filenames below the lower-left corner of the PORT
C CALLED BY: PAGE2
C----------------------------------------------------------------------
      IMPLICIT NONE

      INCLUDE 'const.inc'
      INCLUDE 'inout.inc'
      INCLUDE 'res_grf.inc'

      RECORD /VIEWSET/ PORT

      CHARACTER*60 LEG1,LEG2,LEG3

106   format('DAT: ',a20)
110   format('CFG: ',a20)
111   format('RES: ',a20)

      CALL PGSCH(0.8)

      CALL PGVPORT(PORT.DX1,PORT.DX2,0,PORT.DY2)
      WRITE(LEG1,110) cfgname
      if (datname.ne.' ') then 
         WRITE(LEG2,106) datname
      else
         WRITE(LEG2,106) rescal_name
      endif 
      WRITE(LEG3,111) resname
      CALL PGMTEXT('B',-0.5,0.,0.,LEG1(1:26))
      CALL PGMTEXT('B',-2.0,0.,0.,LEG2(1:26))
      CALL PGMTEXT('B',-3.5,0.,0.,LEG3(1:26))
      CALL PGVPORT(PORT.DX1,PORT.DX2,PORT.DY1,PORT.DY2)
      CALL PGSCH(1.0)
      CALL PGSCI(1)

      END
      
C*************************  SAVE RESULTS ********************************

C------------------------------------------------------------------
      SUBROUTINE SAVEELL(fname,PORT,A,U,IS)
C  plots projection (IS=0) or section (IS=1) of the 4-dim. ellipsoid
C  defined by the matrix A(4,4) and the centre position U(4).
C  The projection plane is specified by the IX and IY fields of
C  the PORT record.
C  collor index (ICL), line style (ILS) ,character size (ZCH)
C-------------------------------------------------------------------
      IMPLICIT NONE
      
      INTEGER*4 IS,NP,NP2,LL,i_IO,j,I
      PARAMETER(NP=128,NP2=2*NP)
      REAL*8 A(4,4),B(2,2),U(4)
      REAL*8 D,D1,DET,STEP,CF,Z
      REAL*4 X(NP2),F(NP2)
      CHARACTER*(*) fname

      INCLUDE 'res_grf.inc'

      RECORD/VIEWSET/ PORT

      CALL REDUCE42(A,B,PORT.IX,PORT.IY,IS)

      CF=2.0D0*LOG(2.0D0)
      D1= SQRT(CF*B(2,2)/(B(2,2)*B(1,1)-B(1,2)**2))
      STEP=2.*D1/(NP-1)
      DO 1 I=1,NP
        D=I-1
        Z=-D1+D*STEP
        X(I)=Z+U(PORT.IX)
        DET=(B(1,2)*Z)**2-B(2,2)*(B(1,1)*Z**2-CF)
        F(I)=(-B(1,2)*Z+SQRT(ABS(DET)))/B(2,2)+U(PORT.IY)
1     CONTINUE
      DO 2 I=1,NP
        X(I+NP)=-X(I)+2.*U(PORT.IX)
        F(I+NP)=-F(I)+2.*U(PORT.IY)
2     CONTINUE
      
      LL=LEN(fname)
      I_IO=25
      close(i_io)
       Open(Unit=i_IO,File=fname(1:LL),err=999,Status='Unknown')
      write(i_io,*) PORT.XTIT//' '//PORT.YTIT            
9     format(2(G12.5,2x))      
      do j=1,NP2
        write(i_IO,9) X(j),F(j)
      enddo
      close(i_io)

999      RETURN
      END



      
C----------------------------------------------------------------------
      SUBROUTINE GRLIST
C Plots the list of RESTRAX parameters on PAGE 1, below the R(Q,E) projections
C----------------------------------------------------------------------
      IMPLICIT NONE
      
      INCLUDE 'const.inc'
      INCLUDE 'inout.inc'

      INTEGER*4 J
      CHARACTER*120 LISTSTR(15)

1     FORMAT(2(A4,' = ',F10.5,7X))
2     FORMAT(3(A4,' = ',F10.2,7X))
3     FORMAT(3(A4,' = ',F10.0,7X))
4     FORMAT((A4,' = ',F10.5,7X, A4,' = ',F10.0,7X))
5     FORMAT(4(A4,' = ',F10.2,7X))
6     FORMAT(3(A4,' = ',F10.4,7X))
7     FORMAT(4(A4,' = ',F10.4,7X))
8     FORMAT(2(A4,' = ',F10.2,7X))



       WRITE(LISTSTR(1),1) (RES_NAM(J),RES_DAT(J),J=1,2)

       WRITE(LISTSTR(2),2) (RES_NAM(J),RES_DAT(J),J=3,5)

       WRITE(LISTSTR(3),3) (RES_NAM(J),RES_DAT(J),J=6,8)

       WRITE(LISTSTR(4),4) (RES_NAM(J),RES_DAT(J),J=9,10)

       WRITE(LISTSTR(5),5) (RES_NAM(J),RES_DAT(J),J=11,14)
       WRITE(LISTSTR(6),5) (RES_NAM(J),RES_DAT(J),J=15,18)

       WRITE(LISTSTR(7),6) (RES_NAM(J),RES_DAT(J),J=19,21)
       WRITE(LISTSTR(8),6) (RES_NAM(J),RES_DAT(J),J=22,24)
       WRITE(LISTSTR(9),6) (RES_NAM(J),RES_DAT(J),J=25,27)
       WRITE(LISTSTR(10),6) (RES_NAM(J),RES_DAT(J),J=28,30)

       WRITE(LISTSTR(11),7) (RES_NAM(J),RES_DAT(J),J=31,34)
       WRITE(LISTSTR(12),7) (RES_NAM(J),RES_DAT(J),J=35,38)
       WRITE(LISTSTR(13),7) (RES_NAM(J),RES_DAT(J),J=39,42)
       WRITE(LISTSTR(14),7) (RES_NAM(J),RES_DAT(J),J=43,46)
       WRITE(LISTSTR(15),8) (RES_NAM(J),RES_DAT(J),J=47,48)

      CALL PGSCI(1)
      CALL PGSCH(0.75)

      CALL PGVPORT(0.1,0.97,0.22,0.25)
      CALL PGWINDOW(0.0,1.0,0.0,1.0)
      CALL PGBOX('C',0.0,0,' ',0.0,0)
      CALL PGPTEXT(0.0,0.5,0.0,0.0,
     1 'Instrument Configuration: '//CFGNAME)

      CALL PGSCH(0.6)
      CALL PGVPORT(0.1,0.97,0.02,0.22)
      CALL PGWINDOW(0.0,1.0,0.0,1.0)
      CALL PGBOX('B',0.0,0,' ',0.0,0)

      DO 55 J=1,15
       CALL PGPTEXT(0.0,(1.05-J/15.),0.0,0.0,LISTSTR(J))
55    CONTINUE
      RETURN
      END

