      INCLUDE 'ness_common.inc'

C/// program switches
      INTEGER*4 SWPLOT,SWRAYTR
      COMMON /SWITCHES/ SWPLOT,SWRAYTR

C/// flow control
      LOGICAL*4 NEEDBEFORE
      COMMON /FLOWCTR/ NEEDBEFORE

C/// measured spectra
      REAL*4 DSPX(MAXD),SPX(MAXD),SPY(MAXD),SPZ(MAXD)
      REAL*4 QE0(4,MDAT),DQE0(6,MDAT)
      INTEGER*4 IPT(MAXD),NPT(0:MDAT)
      COMMON /SPECTRUM/ DSPX,SPX,SPY,SPZ,IPT,NPT,QE0,DQE0    

C/// Histograms and related variables
      REAL*4 RHIST(MAXD),XHIST(MAXD),DHIST(6,MAXD),ERHIST(MAXD)
      INTEGER*4 NHIST(0:MDAT), IHIST(MAXD),WHATHIS
      COMMON /HISTOGRAM/ XHIST,RHIST,ERHIST,DHIST,IHIST,NHIST,WHATHIS
C Note:
C WHATHIS is a flag with histogram status:
C bit1 ... RHIST has been updated
C bit2 ... resolution was taken from ray-tracing (otherwise from TRAX)
C bit4 ... S(Q,w) is from EXCI module (otherwise planar dispersion)

C/// Factors for normalizing data
      REAL*8 RELTR(MDAT),RELMC(MDAT),SUMAMC(MDAT),HNORM(MDAT)
      REAL*8 SHIST(MDAT) 
      COMMON /NORMS/ RELTR,RELMC,SUMAMC,HNORM,SHIST

C/// Variables for fitting      
      REAL*4 CHISQR,DCHISQ(MDAT),FITTOL,FITLAM0
      REAL*4 FPAR(MPAR),FPARI(MPAR),FPARMI(MPAR),FPARMA(MPAR)
      REAL*4 SIGMAA(MPAR),COVAR(MPAR,MPAR)
      INTEGER*4 JFIXED(MPAR),NFPAR,JFIT,MODE
      COMMON /FIT/ CHISQR,FITTOL,FITLAM0,DCHISQ,FPAR,FPARI,FPARMI,FPARMA,SIGMAA,COVAR,
     1             JFIXED,NFPAR,JFIT,MODE
     
C/// Variables for TAS optimisation      
      INTEGER*4 OPTPAR,OPTFPAR,OPTMERIT,OPTEV
      REAL*8 OPTDPAR
      COMMON /MCOPTIM/ OPTPAR,OPTFPAR,OPTMERIT,OPTEV,OPTDPAR

C***************************************
C				       *
C  arrays for managing multiple data   *
C				       *
C***************************************
      

C// RESCAL parameters for MDAT exp. data sets
            
      REAL*8 mf_par(RES_NVAR,MDAT)            

C// Arrays describing TAS setup for Monte Carlo 
      
      BYTE mf_device(LDEV,MDAT),mf_setup(LSET,MDAT) 
      INTEGER*4 mf_chksum(MDAT),mf_CFGMODE(MDAT)            

C// Storage of multiple exp. data

      CHARACTER*32 mf_name(MDAT) 

C// resloution matrices
      REAL*8 mf_A(4,4,MDAT),mf_AMC(4,4,MDAT),mf_AMEAN(4,MDAT)   
      REAL*8 mf_MRC(4,4,MDAT),mf_MCR(4,4,MDAT)
      REAL*8 ATRAX(4,4),ANESS(4,4),AMEAN(4)
      REAL*8 mf_VKI(MDAT),mf_VKF(MDAT),mf_VTOT(MDAT)
      REAL*8 mf_MVKI(MDAT),mf_MVKF(MDAT),mf_MVTOT(MDAT)
      REAL*8 RELNESS,VKINESS,VKFNESS
      COMMON/MATRIX/ATRAX
      COMMON/NESSIF/ANESS,AMEAN,RELNESS,VKINESS,VKFNESS

C// field pointers and tags
      INTEGER*4 mf_max,mf_cur  
      LOGICAL*4 mf_loaded(MDAT),mf_active(MDAT),mf_done(MDAT),
     *          mf_changed(MDAT)

       
      COMMON /MFIT/ mf_device,mf_setup,mf_par,
     *              mf_name,
     *              mf_A,mf_AMC,mf_AMEAN,mf_MRC,mf_MCR,
     *              mf_VKI,mf_VKF,mf_VTOT,mf_MVKI,mf_MVKF,mf_MVTOT,
     *              mf_max,mf_cur, mf_loaded,mf_active,mf_done,
     *              mf_changed, mf_chksum, mf_CFGMODE
 

