C***************************************************************
C $Id: restrax_cmd.f,v 1.11 2006/05/29 10:27:03 saroun Exp $
C
C IMENU ... actually active menu set in LINP
C LMENU ... submenu level (LMENU=1 for the main manu)
C CMENU(LMENU) ... actually selected submenu on the level LMENU
C comment:
C----------
C IMENU changes only if LINP_SET is called with new menu items
C CMENU is set when menu handler is called with empty argument (to stay there)
C or on QUIT (return to parent menu)  
C***************************************************************

C***************************************************************
      SUBROUTINE RESTRAX_HANDLE(SCOMM)
C  A wrapper to CMD_HANDLE for DLL export  
C***************************************************************
      IMPLICIT NONE      
      INCLUDE 'linp.inc'
      INCLUDE 'restrax_cmd.inc'
      CHARACTER*(*) SCOMM
      INTEGER*4 L   
         
2     FORMAT(a,$)
      CMDMODE=0 ! no command-line interaction
      L=LEN(SCOMM)      
      CALL CMD_HANDLE(SCOMM(1:L))
      WRITE(linp_out,2) linp_p(1:linp_np)//'> ' 
      END

C***************************************************************
      SUBROUTINE CMD_INIT
C  Initializes command interpreter
C  Sets appropriate prompt and menu contents according to CMENU(LMENU) value
C***************************************************************
      IMPLICIT NONE      
      
      INCLUDE 'const.inc'
      INCLUDE 'inout.inc'
      INCLUDE 'linp.inc'
      INCLUDE 'restrax.inc'
      INCLUDE 'restrax_cmd.inc'
      
      CHARACTER*10 prompt
      INTEGER*4 IQ
      
3     FORMAT('ResTrax_',I1)
4     FORMAT('ResTrax_',I2)

C// initialize menu if it has changed
      IF (IMENU.NE.CMENU(LMENU).OR.LMENU.LT.1) THEN      
C main menu
        IF (LMENU.LE.1.AND.IMENU.NE.MN_MAIN) THEN ! first entry => set LINP with menu items
          IF(mf_max.le.1) THEN ! set prompt according to the focused data set
            prompt='ResTrax'
          ELSE
            IF(mf_cur.lt.10) WRITE(prompt,3) mf_cur
            IF(mf_cur.GE.10) WRITE(prompt,4) mf_cur
          ENDIF    
          LMENU=1     
          IMENU=MN_MAIN
          CMENU(LMENU)=IMENU
          CALL LINPSET(RES_NVAR+RES_NCMD,prompt,RES_NAM,RES_HLP)
          CALL LINPSETIO(SINP,SOUT,SMES)
C submenu => initialize by a call with empty string
        ELSE IF (LMENU.GT.1.AND.IMENU.NE.CMENU(LMENU)) THEN
          SELECT CASE (CMENU(LMENU))      
            CASE (MN_DATA)          
              CALL DATA_CMD(' ',IQ)
            CASE (MN_FIT)
              CALL FIT_CMD(' ',IQ)
            CASE (MN_PLOT)
              CALL PLOT_CMD(' ',IQ)
          END SELECT      
        ENDIF
      ENDIF
      END

C***************************************************************
      SUBROUTINE CMD_HANDLE(SCOMM)
C Main menu handler for RESTRAX  
C All user entry should be dispatched here
C***************************************************************
      IMPLICIT NONE      
      
      INCLUDE 'const.inc'
      INCLUDE 'inout.inc'
      INCLUDE 'linp.inc'
      INCLUDE 'res_grf.inc'
      INCLUDE 'restrax.inc'
      INCLUDE 'restrax_cmd.inc'
      
      CHARACTER*(*) SCOMM
      INTEGER*4 IQ,ICOM,NPAR,LCOM,I,IERR
      CHARACTER*128 LINE,LINPEXECSTR
      LOGICAL*4 NOSAVE
      DATA  NOSAVE/.FALSE./   

1     FORMAT(a)
2     FORMAT(a5,' = ',G12.6)
5     FORMAT(a,$)
c6     FORMAT('ITEM=',I2,' MENU=',I2,' LEVEL=',I2)           
100   FORMAT(1X,70('-'))
200   FORMAT(1X,'RESTRAX Error: ',I4,/,1x,A)

C// initialize fields
      LCOM=LEN_TRIM(SCOMM)
      RETSTR=' '
      LINE=' '      
      RES_NMSG=0
      
c      write(*,6) IMENU,CMENU(LMENU),LMENU

C// call the focused submenu, if any
      IQ=0
      IF (IMENU.GT.0.AND.LMENU.GT.1) THEN
        SELECT CASE (CMENU(LMENU))      
          CASE (MN_DATA)          
            CALL DATA_CMD(SCOMM,IQ)
          CASE (MN_FIT)
            CALL FIT_CMD(SCOMM,IQ)
          CASE (MN_PLOT)
            CALL PLOT_CMD(SCOMM,IQ)
        END SELECT
      ENDIF
      
C// empty string or return from submenu => only set LINP and exit     
      IF (IQ.EQ.1.OR.LCOM.EQ.0.OR.LMENU.GT.1) GOTO 99 
      
C// process command string through LINP
      LINE=LINPEXECSTR(SCOMM(1:LCOM),ICOM,NPAR)
      IF (ICOM.LT.0) RETURN  ! command not recognised

C// get the whole line as a string argument      
      IF (NPAR.GT.0) RETSTR=LINE
C// get numeric arguments       
      CALL GETLINPARG(LINE,RET(1),40,NOS) 

C// standard commands (ICOM=0)
      IF(ICOM.EQ.0) THEN
          IF (LINE(1:4).EQ.'LIST') THEN
             CALL LIST
          ELSE IF (LINE(1:4).EQ.'QUIT') THEN
             GOEND=1
          ENDIF
C// process input parameters
      ELSE IF (ICOM.GT.0.AND.ICOM.LE.RES_NVAR) THEN          
          IF (NOS.GT.RES_NVAR-ICOM+1) NOS=RES_NVAR-ICOM+1  
          IF (NOS.GT.0) THEN
            DO I=1,NOS
               RES_DAT(ICOM+I-1)=RET(I)
            ENDDO
            NOSAVE=.TRUE.
            NEEDBEFORE=.TRUE.
          ELSE
            WRITE(SOUT,2) RES_NAM(ICOM),RES_DAT(ICOM) 
          ENDIF    
C// process commands
      ELSE IF (ICOM.GT.RES_NVAR.AND.ICOM.LE.RES_NVAR+RES_NCMD) THEN          
C do preliminary tasks (matrix update, call TRAX etc.) when needed
        IF (NEEDBEFORE) CALL BEFORE
      
C input-output commands
        IF (RES_NAM(ICOM).EQ.'LSCFG') THEN
          CALL LISTCFG
        ELSE IF (RES_NAM(ICOM).EQ.'SAVE') THEN
          CALL WRITE_RESCAL(RETSTR,IERR)
          NOSAVE=(IERR.NE.1)
        ELSE IF (RES_NAM(ICOM).EQ.'WRITE') THEN
          CALL WriteHist(RETSTR)
        ELSE IF (RES_NAM(ICOM).EQ.'PATH') THEN
          CALL SETPATH(RETSTR)
        ELSE IF (RES_NAM(ICOM).EQ.'CPATH') THEN
          CALL SETRESPATH(RETSTR)
        ELSE IF (RES_NAM(ICOM).EQ.'FILE') THEN
          CALL ADDDATA(RETSTR,NPAR,1,0)
        ELSE IF (RES_NAM(ICOM).EQ.'GRFDE') THEN
          CALL SELGRFDEV(RETSTR,0)
        ELSE IF (RES_NAM(ICOM).EQ.'BAT') THEN
          CALL REINP(RETSTR)
          CALL LINPSETIO(SINP,SOUT,SMES)
        ELSE IF (RES_NAM(ICOM).EQ.'OUT') THEN
          CALL REOUT(RETSTR)        
          CALL LINPSETIO(SINP,SOUT,SMES)
        ELSE IF (RES_NAM(ICOM).EQ.'CFG') THEN
          CALL SETCFG(RETSTR,1)        
        ELSE IF (RES_NAM(ICOM).EQ.'EXCI') THEN
          CALL SETEXCI(RETSTR,1)        
        ELSE IF (RES_NAM(ICOM).EQ.'OMEXC') THEN
          CALL REPORTOMEXC
        ELSE IF (RES_NAM(ICOM).EQ.'EXPR') THEN
          CALL EXPORT_RES(RETSTR)        
        ELSE IF (RES_NAM(ICOM).EQ.'IMPR') THEN
          CALL IMPORT_RES(RETSTR)        
        ELSE IF (RES_NAM(ICOM).EQ.'SHELL') THEN
          CALL DOSHELL(LINE)
        ELSE IF (LINE(1:4).EQ.'LIST') THEN
          CALL LIST
        ELSE IF (RES_NAM(ICOM).EQ.'EXIT') THEN
             GOEND=1           
        ELSE IF (RES_NAM(ICOM).EQ.'EXFF') THEN
             NOSAVE=.FALSE. ! no warning on unsaved data before exit
             GOEND=1           
C sumbmenu calls
        ELSE IF (RES_NAM(ICOM).EQ.'FIT') THEN
           SWRAYTR=0 ! ray-tracing=off
           CALL FIT_CMD(RETSTR,IQ)        
        ELSE IF (RES_NAM(ICOM).EQ.'MFIT') THEN
           CALL MAKEMC(RES_NAM(ICOM))   ! call Monte Carlo if necessary (call IFNESS)
           CALL FIT_CMD(RETSTR,IQ) 
        ELSE IF (RES_NAM(ICOM).EQ.'DATA') THEN
           CALL DATA_CMD(RETSTR,IQ) 
        ELSE IF (RES_NAM(ICOM).EQ.'PLOT') THEN
           CALL PLOT_CMD(RETSTR,IQ)       
        ELSE IF (RES_NAM(ICOM).EQ.'PRINT') THEN
           IF (NOS.GE.1.AND.RET(1).EQ.0) THEN
             CALL PRINTOUT ! print text report
           ELSE
             TOPRINT=1     ! print the last plotted graphics
             CALL PLOTOUT
           ENDIF

C execution commands:
C pass commands through CMD_PROCESS if
C a) want to apply CMDFILTER, or
C b) call ray-tracing when needed (MAKEMC), or
        ELSE     !  other commands are treated outside
           CALL CMD_PROCESS(ICOM)
           write(sout,100)
        ENDIF
      ENDIF 
          
C report messages          
      IF (RES_NMSG.NE.0) WRITE(smes,200) RES_NMSG,RES_MSG

C// check for unsaved parmeters before termination     
      IF (GOEND.NE.0) THEN
         IF(NOSAVE) THEN
            write(smes,*) 'Changed parameters are not saved !'
            write(smes,*) 'Repeat EXIT or QUIT to confirm.'
            NOSAVE=.FALSE.
            GOEND=0
         ENDIF
      ENDIF   
       
C// return from a submenu
99    IF (IQ.EQ.1) THEN
          CMENU(LMENU)=0
          LMENU=LMENU-1
      ENDIF

      CALL CMD_INIT ! call INIT to reset menu items for actual level
      
      END      

C***************************************************************
      SUBROUTINE CMD_PROCESS(ICMD)
C  Process RESTRAX  execution commands
C ICMD   ... command ID
C***************************************************************
      IMPLICIT NONE      
      INCLUDE 'const.inc'
      INCLUDE 'inout.inc'
      INCLUDE 'res_grf.inc'
      INCLUDE 'restrax.inc'
      INCLUDE 'restrax_cmd.inc'
      INTEGER*4 ICMD
      LOGICAL*4 CMDFILTER
      
!        write(*,*) 'Process ',ICMD
      IF (.NOT.CMDFILTER(ICMD)) RETURN  ! filter for commands       
      CALL MAKEMC(RES_NAM(ICMD))        ! call Monte Carlo if necessary (call IFNESS)
      
        IF (RES_NAM(ICMD).EQ.'BRAG')  CALL BRAG(0)
        IF (RES_NAM(ICMD).EQ.'RES')   CALL RESOL(1,NINT(RET(1)))
        IF (RES_NAM(ICMD).EQ.'MRES')  CALL RESOL(2,NINT(RET(1)))
        IF (RES_NAM(ICMD).EQ.'SIMFC') CALL FCONE_INI
        IF (RES_NAM(ICMD).EQ.'RO')    CALL GETRO(1)
        IF (RES_NAM(ICMD).EQ.'ROA')   CALL GETRO(0)
        IF (RES_NAM(ICMD).EQ.'SPOS')  CALL SET_3AX(1)
        IF (RES_NAM(ICMD).EQ.'PHON')  CALL MCPHON
        IF (RES_NAM(ICMD).EQ.'MPHON') CALL MCPHON
        IF (RES_NAM(ICMD).EQ.'GENDT') CALL GENDT
        IF (RES_NAM(ICMD).EQ.'PROF')  THEN
                                          ! obsolete, disabled
                                      ENDIF                                        
        IF (RES_NAM(ICMD).EQ.'EMOD')  CALL EMODE
        IF (RES_NAM(ICMD).EQ.'FLIP')  CALL SET_3AX(4)                 
        IF (RES_NAM(ICMD).EQ.'MAG')   CALL SET_3AX(5)                 
        IF (RES_NAM(ICMD).EQ.'SPIN')  CALL SET_3AX(6)                 
        IF (RES_NAM(ICMD).EQ.'TAUF')  CALL SET_3AX(8)                 
        IF (RES_NAM(ICMD).EQ.'FWHM')  CALL FWHM(1)
        IF (RES_NAM(ICMD).EQ.'MFWHM') CALL FWHM(2)
        IF (RES_NAM(ICMD).EQ.'AMOD')  CALL FCONE_INI
        IF (RES_NAM(ICMD).EQ.'MBRAG') CALL BRAG(1) 
        IF (RES_NAM(ICMD).EQ.'OPTAS') CALL OPTINSTR
C Setup might have changed 
C => call BEFORE which updates TRAX parameters and compares with previous configuration  
      IF ((RES_NAM(ICMD).EQ.'RO').OR.
     &     (RES_NAM(ICMD).EQ.'ROA').OR.
     &     (RES_NAM(ICMD).EQ.'SPOS').OR.
     &     (RES_NAM(ICMD).EQ.'EMOD').OR.
     &     (RES_NAM(ICMD).EQ.'MAG').OR.
     &     (RES_NAM(ICMD).EQ.'TAUF').OR.
     &     (RES_NAM(ICMD).EQ.'AMOD').OR.
     &     (RES_NAM(ICMD).EQ.'OPTAS'))  NEEDBEFORE=.TRUE. 
      END

C--------------------------------------------------------------
      SUBROUTINE FIT_CMD_INIT(rm,FITCOM,FITHINT,NLIST)
C
C  Command handler for modifying model parameters, fitting control etc.
C IQ=1 inidicates return to the parent menu (=QUIT) 
C---------------------------------------------------------------
      IMPLICIT NONE      
      INCLUDE 'const.inc'
      INCLUDE 'exciimp.inc'
      INCLUDE 'restrax.inc'
      
      INTEGER*4 I,NLIST
      RECORD /MODEL/ rm
      CHARACTER*4 CH
      CHARACTER*5 CONCAT
      CHARACTER*5 FITCOM(MPAR+6)
      CHARACTER*60 FITHINT(MPAR+5)
2     FORMAT(I4)

        DO I=1,rm.NTERM    ! items 1..NTERM are reserved for model parameters
          FITCOM(I)=' '
          WRITE(CH,2) I
          FITCOM(I)=CONCAT('a',CH)
          FITHINT(I)=rm.PARNAME(I)
        ENDDO
        FITCOM(rm.NTERM+1)='PLOT'
        FITCOM(rm.NTERM+2)='MAPSQ'
        FITCOM(rm.NTERM+3)='OMEXC'
        FITCOM(rm.NTERM+4)='INIT'
        FITCOM(rm.NTERM+5)='FIX'
        FITCOM(rm.NTERM+6)='RUN'
        FITHINT(rm.NTERM+1)='plot data & fit'
        FITHINT(rm.NTERM+2)='plot map of S(Q) at E=const.'
        FITHINT(rm.NTERM+3)='[qh qk ql] get omega for given qhkl'
        FITHINT(rm.NTERM+4)='initialization of the scattering model'
        FITHINT(rm.NTERM+5)='[n1 n2 ..] fix/free listed parameters'
        FITHINT(rm.NTERM+6)='[it] start fitting, max. it steps' 
        NLIST=rm.nterm+6
c        write(*,*) 'FIT_CMD',SWRAYTR
        IF (SWRAYTR.GT.0) THEN
          CALL LINPSET(NLIST,'MFIT',FITCOM,FITHINT)
        ELSE
          CALL LINPSET(NLIST,'FIT',FITCOM,FITHINT)
        ENDIF
        
      END
C--------------------------------------------------------------
      SUBROUTINE FIT_CMD(SCOMM,IQ)
C
C  Command handler for modifying model parameters, fitting control etc.
C IQ=1 inidicates return to the parent menu (=QUIT) 
C---------------------------------------------------------------
      IMPLICIT NONE      
      
      INCLUDE 'const.inc'
      INCLUDE 'inout.inc'
      INCLUDE 'res_grf.inc'
      INCLUDE 'rescal.inc'
      INCLUDE 'restrax.inc'
      INCLUDE 'restrax_cmd.inc'      
      INCLUDE 'linp.inc'
      INCLUDE 'exciimp.inc'
            
      RECORD /MODEL/ rm
      REAL*8 CHKQOM
      
      CHARACTER*(*) SCOMM
      INTEGER*4 IQ,ICOM,NPAR,NLIST,ITMAX,I,J,IFX,IS,IL,LCOM
      CHARACTER*128 LINE,LINPEXECSTR
      CHARACTER*5 FITCOM(MPAR+6)
      CHARACTER*60 FITHINT(MPAR+5),SLINE
c      REAL*8 OLDCHKQOM,GETSQOM
      REAL*8 DUM6(6),dum61(6)
      LOGICAL*4 LBACK ! indicates return from a submenu (PLOT calls ...)
      SAVE FITCOM,FITHINT
      DATA LBACK/.FALSE./

4     FORMAT(a,'=',G12.5)
c6     FORMAT('FIT_CMD ITEM=',I2,' MENU=',I2,' LEVEL=',I2)           

      CALL getmodel(rm) 
      CALL getqomegainf(I,CHKQOM) 
           
      LCOM=LEN_TRIM(SCOMM)
      IQ=0
C// initialization
      IF (IMENU.NE.MN_FIT) THEN ! first entry => set LINP with menu items
c      write(*,6) IMENU,CMENU(LMENU),LMENU
        IMENU=MN_FIT
        IF (LCOM.EQ.0) THEN ! empty argument => stay in the menu
          IF (.NOT.LBACK) LMENU=LMENU+1
          CMENU(LMENU)=IMENU
c      write(*,6) IMENU,CMENU(LMENU),LMENU
        ENDIF
        IF (.NOT.LBACK) THEN ! initialize EXCI except of return form a subcommand
          CALL HISTINIT            ! default histogram partitioning
          JFIT=0                   ! monitor fitting status (no fit)
        ENDIF
        LBACK=.FALSE.
        call FIT_CMD_INIT(rm,FITCOM,FITHINT,NLIST)        
        IF (LCOM.LE.0) CALL LISTFITPAR          ! list parameters at the begining        
      ENDIF
      
      
      IF (LCOM.EQ.0) RETURN ! ignore empty commands
     
C// process command through LINP      
      LINE=LINPEXECSTR(SCOMM(1:LCOM),ICOM,NPAR)      
      IF (ICOM.LT.0) RETURN  ! command not recognised

c        write(*,*) 'FIT_CMD: <'//SCOMM(1:LCOM)//'>',ICOM,NLIST
      
C// get numeric arguments       
      CALL GETLINPARG(LINE,RET(1),40,NOS) 
                   
C// standard commands (ICOM=0)
      IF(ICOM.EQ.0) THEN
C LIST
         IF (LINE(1:4).EQ.'LIST') THEN
            CALL LISTFITPAR 
C QUIT
         ELSE IF (LINE(1:4).EQ.'QUIT') THEN
            if (iand(WHATHIS,1).EQ.0) CALL RESFIT(0) ! update histogram  
            IF (CFGMODE.NE.1.AND.iand(WHATHIS,1).EQ.1) THEN ! replot result if mode <> flat-cone 
              CALL PLOT_CMD('SCAN',IQ)
            ENDIF
            CALL WriteHist(' ') ! write results in a file 
            IQ=1 ! return flag
        ENDIF 
C parameters
      ELSE IF (ICOM.GT.0.AND.ICOM.LE.rm.NTERM) THEN

c        write(*,*) '<'//FITCOM(ICOM)//'>',ICOM,rm.NTERM
          IF (NOS.GT.0) THEN
             I=ICOM 
             DO WHILE (I.LE.rm.NTERM.AND.I-ICOM+1.LE.NOS)
               FPAR(I)=RET(I-ICOM+1)
               rm.PARAM(I)=FPAR(I) ! share with EXCI
               I=I+1
             ENDDO  
             call setmodel(rm) ! update exci data
             
C call EXCI(-1): this is a trick how to apply changes
C so that EXCI can update internal fields from param(i), 
C otherwise, old values would go back to param(i) when calling EXCI(0) 
             CALL EXCI(-1,mf_par(i_QH,mf_cur),DUM6,DUM61) 
             
             CALL LISTFITPAR
          ELSE
             CALL BOUNDS(rm.PARNAME(ICOM),IS,IL)
             WRITE(SLINE,4) rm.PARNAME(ICOM)(IS:IS+IL-1),rm.PARAM(ICOM)
             CALL WRITELINE(SLINE,SOUT)
          ENDIF
C identified commands (ICOM>NTERM)
      ELSE IF (ICOM.GT.rm.NTERM.AND.ICOM.LE.NLIST) THEN
c        write(*,*) '<'//FITCOM(ICOM)//'>',ICOM,rm.NTERM
C FIX
        IF (FITCOM(ICOM).EQ.'FIX') THEN               
            IF (NOS.EQ.0.OR.(NOS.EQ.1.AND.NINT(RET(1)).EQ.-1)) THEN  ! fix all (default)         
              DO J=1,rm.NTERM
                    JFIXED(J)=0
                    rm.FIXPARAM(J)=JFIXED(J)
              ENDDO                
            ELSE IF (NOS.EQ.1.AND.NINT(RET(1)).EQ.0) THEN ! free all
              DO J=1,rm.NTERM
                    JFIXED(J)=1
                    rm.FIXPARAM(J)=JFIXED(J)
              ENDDO                            
            ELSE IF (NOS.GT.0) THEN 
              DO I=1,NOS
               IFX=NINT(RET(I))
                IF (IFX.GT.0.AND.IFX.LE.rm.NTERM) THEN
                  IF (JFIXED(IFX).EQ.0) THEN
                    JFIXED(IFX)=1
                  ELSE
                    JFIXED(IFX)=0
                  ENDIF
                  rm.FIXPARAM(IFX)=JFIXED(IFX)
                ENDIF
              ENDDO 
            ENDIF
            call setmodel(rm) ! update exci data
            CALL LISTFITPAR
C PLOT
        ELSE IF (FITCOM(ICOM).EQ.'PLOT') THEN   
c          IF (OLDCHKQOM.NE.CHKQOM) THEN ! QOM array might have chaned by MAPSQ
c             OLDCHKQOM=GETSQOM(1,mf_max,1)
c          ENDIF
          CALL RESFIT(0) ! calculate model curve, without fitting (arg=0)
          IF (CMENU(LMENU).EQ.IMENU) LBACK=.TRUE. ! indicate single call to a submenu
          CALL PLOT_CMD('SCAN',IQ) 
C MAPSQ
        ELSE IF (FITCOM(ICOM).EQ.'MAPSQ') THEN 
          I=SWRAYTR  ! remember SWRAYTR state, it is set to 0 by SQOM 
          IF (CMENU(LMENU).EQ.IMENU) LBACK=.TRUE. ! indicate single call to a submenu
          CALL PLOT_CMD('SQOM',IQ) 
          SWRAYTR=I
C OMEXC
        ELSE IF (FITCOM(ICOM).EQ.'OMEXC') THEN 
          CALL REPORTOMEXC 
C INIT
        ELSE IF (FITCOM(ICOM).EQ.'INIT') THEN   
          CALL INITEXCI(1,1)  ! arg=1 to force parameter file reading          
C RUN
        ELSE IF (FITCOM(ICOM).EQ.'RUN') THEN   
c          IF (OLDCHKQOM.NE.CHKQOM) THEN
c             OLDCHKQOM=GETSQOM(1,mf_max,1)   
c          ENDIF
          ITMAX=1 ! only one iteration by default
          IF (NOS.GT.0) ITMAX=NINT(RET(1)) 
          CALL RESFIT(ITMAX)
          CALL LISTFITPAR
        ENDIF
C// update menu: number of parameters may have changed !
        CALL getmodel(rm) 
        CALL FIT_CMD_INIT(rm,FITCOM,FITHINT,NLIST) 
      ENDIF

      END  


C--------------------------------------------------------
      SUBROUTINE DATA_CMD(SCOMM,IQ)
C Command interpreter for DATA dialog      
C IQ=1 inidicates return to the parent menu (=QUIT) 
C--------------------------------------------------------
      IMPLICIT NONE
      
      INCLUDE 'const.inc'
      INCLUDE 'inout.inc'
      INCLUDE 'restrax.inc'
      INCLUDE 'restrax_cmd.inc'
      
      CHARACTER*(*) SCOMM
      INTEGER*4 IQ,NLIST,ICOM,NPAR,I,I2,N,LCOM
      PARAMETER(NLIST=6)
      CHARACTER*5 COMMANDS(NLIST)
      CHARACTER*60 HINTS(NLIST)
      CHARACTER*128 LINE,LINPEXECSTR
      REAL*8 PNUM(10)
      INTEGER*4 NNUM,K
      LOGICAL*4 LBACK ! indicates return from a submenu (PLOT calls ...)
      DATA LBACK/.FALSE./
      DATA COMMANDS /'OPEN','ADD','DEL','n','TAG','MC'/ 
      DATA HINTS /
     1  '[n1[,n2]] OPEN specified range of data or a list of names',
     2  '[n1[,n2]] ADD new data ...',
     3  '[p1[ p2]] DELETE data from the position p1 to p2',
     5  'set pointer to n-th spectrum/channel ',
     6  '[n] tag/untag the data (n-th or current)',
     7  '[n] calculate R(Q,E) by M.C. for n*1000 events'/ 

      LCOM=LEN_TRIM(SCOMM)
      IQ=0
C// initialization
      IF (IMENU.NE.MN_DATA) THEN ! first entry => set LINP with menu items
        IMENU=MN_DATA
        IF (LCOM.EQ.0) THEN
          IF (.NOT.LBACK) LMENU=LMENU+1
          CMENU(LMENU)=IMENU
        ENDIF
        LBACK=.FALSE.
        CALL LINPSET(NLIST,'DATA',COMMANDS,HINTS)
C IPT update to mask data sets which are not active       
        DO K=1,mf_max
          mf_loaded(K)=((NPT(K)-NPT(K-1)).GT.0)
          if (mf_active(K)) then
             DO I=NPT(K-1)+1,NPT(K)
                IPT(I)=K
             ENDDO
          else
             DO I=NPT(K-1)+1,NPT(K)
                IPT(I)=0
             ENDDO
          endif     
        ENDDO
        IF (LCOM.LE.0) CALL MFIT_LIST
      ENDIF      
      IF (LCOM.EQ.0) RETURN ! ignore empty commands
     
C// process command through LINP      
      LINE=LINPEXECSTR(SCOMM(1:LCOM),ICOM,NPAR)      

C// Integer number (set pointer):        
      IF (ICOM.EQ.-5.AND.NPAR.NE.mf_cur) THEN
         IF (NPAR.GT.0.AND.NPAR.LE.mf_max) THEN ! change pointer to mf_cur
            CALL mfit_set(NPAR)  ! ensure that RESTRAX has all from new mf_cur dataset
         ENDIF 
      ENDIF

C// standard commands (ICOM=0)
      IF(ICOM.EQ.0) THEN       
C QUIT
           IF (LINE(1:4).EQ.'QUIT') THEN
             IQ=1
C LIST
           ELSE IF (LINE(1:4).EQ.'LIST') THEN ! must handle end of input file
             CALL MFIT_LIST
           ENDIF                
C// identified commands (ICOM>0)
      ELSE IF (ICOM.GT.0.AND.ICOM.LE.NLIST) THEN
C OPEN:      
        IF (COMMANDS(ICOM).EQ.'OPEN') THEN    
           CALL ADDDATA(LINE,NPAR,mf_cur,2)
C ADD:
        ELSE IF (COMMANDS(ICOM).EQ.'ADD') THEN    
           CALL ADDDATA(LINE,NPAR,mf_max+1,2)
C DELETE:
        ELSE IF (COMMANDS(ICOM).EQ.'DEL') THEN    
           CALL GETLINPARG(LINE,PNUM(1),10,NNUM)
           I=mf_cur
           if (NNUM.GT.0) I=NINT(PNUM(1))
           I2=I
           if (NNUM.GT.1) I2=NINT(PNUM(2))
           CALL DELDATA(I,I2)
C TAG:
        ELSE IF (COMMANDS(ICOM).EQ.'TAG') THEN                    
           K=mf_cur
           IF (NPAR.GT.0)  THEN
               CALL GETLINPARG(LINE,PNUM(1),10,NNUM)
               IF (NNUM.GT.0) THEN
                 K=NINT(PNUM(1))
                 IF (K.LT.1.OR.K.GT.mf_max) K=mf_cur
               ENDIF  
           ENDIF
           mf_active(K)=(.NOT.(mf_active(K)))
           if (mf_active(K)) then
                DO I=NPT(K-1)+1,NPT(K)
                   IPT(I)=K
                ENDDO
           else
                DO I=NPT(K-1)+1,NPT(K)
                  IPT(I)=0
                ENDDO
           endif     
C MC:
        ELSE IF (COMMANDS(ICOM).EQ.'MC') THEN 
           N=LASTNEV
           IF (NPAR.GT.0)  THEN
               CALL GETLINPARG(LINE,PNUM(1),10,NNUM)
               IF (NNUM.GT.0) THEN
                N=NINT(PNUM(1)*1000)
                IF (N*mf_max.GT.MQOM) N=(MQOM/mf_max)-1
               ENDIF  
           ENDIF
           CALL RUNMC(0,N)             
        ENDIF
      ENDIF         

      END

C--------------------------------------------------------
      SUBROUTINE PLOT_CMD(SCOMM,IQ)
C Command interpreter for plotting results  
C Response to the PLOT command: subcommands will pass through   
C IQ=1 inidicates return to the parent menu (=QUIT) 
C Dialog arguments:
C DLGARG(1)    ... various plot attributes
C DLGSTR(1)    ... plot caption
C--------------------------------------------------------
      IMPLICIT NONE
      
      INCLUDE 'const.inc'
      INCLUDE 'inout.inc'
      INCLUDE 'res_grf.inc'
      INCLUDE 'restrax.inc'
      INCLUDE 'restrax_cmd.inc'
      
      CHARACTER*(*) SCOMM
      INTEGER*4 IQ,NLIST,ICOM,NPAR
      PARAMETER(NLIST=8)
      CHARACTER*5 COMMANDS(NLIST)
      CHARACTER*60 HINTS(NLIST)
      CHARACTER*128 LINE,LINPEXECSTR
      INTEGER*4 LCOM,I,IC
      character*16 labels
      LOGICAL*4 LBACK ! indicates return from a submenu (PLOT calls ...)
      DATA LBACK/.FALSE./
      
      DATA labels/'h:k:l:dE [meV]'/
           
      DATA COMMANDS /'SCAN','ELL','RES','CRES','MRES','SQOM','PROF',
     &     'PRINT'/ 
      DATA HINTS /
     1  'R(Q,E), dispersion sheet, data & fit (if available)',
     3  'resolution ellipsoids in C&N cooordinates',
     4  'R(Q,E) in C&N cooordinates',
     5  'R(Q,E) in [hklE], CURRENT dataset',
     5  'R(Q,E) in [hklE], ALL datasets',
     6  'Map of S(Q,E) at E=const.',
     7  '[n] R(Q,E) profile along n=ord[h,k,l,E,kf]',
     7  'Print the last graph'/ 

c6     FORMAT('PLOT_CMD ITEM=',I2,' MENU=',I2,' LEVEL=',I2)           

      LCOM=LEN_TRIM(SCOMM)
      
      IF (SWPLOT.EQ.0) THEN
        WRITE(SOUT,*) 'graphics output switched off'
        RETURN
      ENDIF

c      write(*,*) 'PLOT_CMD: ',LCOM,SCOMM(1:LCOM)
      IQ=0
C// initialization
      IF (IMENU.NE.MN_PLOT) THEN ! first entry => set LINP with menu items
c      write(*,6) IMENU,CMENU(LMENU),LMENU
        IMENU=MN_PLOT
        IF (LCOM.EQ.0) THEN
          IF (.NOT.LBACK) LMENU=LMENU+1
          CMENU(LMENU)=IMENU
c      write(*,6) IMENU,CMENU(LMENU),LMENU
        ENDIF
        LBACK=.FALSE.
        CALL LINPSET(NLIST,'PLOT',COMMANDS,HINTS)
      ENDIF
      IF (LCOM.LE.0) RETURN ! ignore empty commands

C// process command through LINP      
      LINE=LINPEXECSTR(SCOMM(1:LCOM),ICOM,NPAR) 
C// get numeric arguments       
      CALL GETLINPARG(LINE,RET(1),10,NOS) ! accept up to 10 numerical arguments

c      write(*,*) 'PLOT_ICOM: ',ICOM,(RET(I),I=1,NOS)

C standard commands (ICOM=0)
      IF(ICOM.EQ.0) THEN       
C QUIT
        IF (LINE(1:4).EQ.'QUIT') THEN
          IQ=1
          RETURN
        ENDIF      
      ENDIF

C// If command is an integer => interpret it as command ID        
C// this preserves older behaviour of the PLOT command
      IF (ICOM.EQ.-5) THEN ! 1st argument is command ID
        DO I=1,NOS
          GRFARG(I-1)=RET(I)
        ENDDO
        NOS=NOS-1
        
      ELSE IF (ICOM.GT.0.AND.ICOM.LE.NLIST) THEN ! recognised command
C// copy argumments to GRFARG for all commands except PRINT        
        IF (ICOM.LT.NLIST) THEN
          GRFNARG=NOS
          DO I=1,NOS
            GRFARG(I)=RET(I)
          ENDDO
        ENDIF
      ELSE
        RETURN ! nothing to do
      ENDIF
            
      
C identified commands (ICOM>0)
      IF (ICOM.GT.0.AND.ICOM.LE.NLIST) THEN
c        write(*,*) '<'//COMMANDS(ICOM)//'>',(GRFARG(I),I=1,GRFNARG)
C* SCAN
        IF (COMMANDS(ICOM).EQ.'SCAN') THEN    

c comment out = allow empty histograms
c           IF (MOD(WHATHIS,2).EQ.0) THEN ! histogram not ready
c             write(smes,*) 'No data in the histogram. '//
c     &         'Try commands [M]PHON or [M]FIT first.'
c           ELSE IF (mf_max.eq.1) THEN ! single channel - show also R(Q,E)

           IF (mf_max.eq.1) THEN ! single channel - show also R(Q,E)
             GRFARG(0)=4              ! call PAGE2
           ELSE                       ! multiple channels
             if (CFGMODE.EQ.1) then   ! flat cone => call AB_IMAGE(ig_FCDATA)
               GRFARG(0)=-7
             else  
               GRFARG(0)=5            ! multiple cells => call PLOT_MDAT
             endif 
           ENDIF
C* SQOM
        ELSE IF (COMMANDS(ICOM).EQ.'SQOM') THEN    
           GRFARG(0)=-6               ! call AB_IMAGE(ig_SQOM)
c          write(*,*) 'command is SQOM: ',NINT(GRFARG(0))
C* PROF
        ELSE IF (COMMANDS(ICOM).EQ.'PROF') THEN    
            IF (GRFNARG.EQ.0) GRFARG(1)=4 ! scan E by default
c          write(*,*) 'command is PROF: ',NINT(GRFARG(0))
           GRFARG(0)=9      ! call VIEWSCAN
C* ELL
        ELSE IF (COMMANDS(ICOM).EQ.'ELL') THEN 
           GRFARG(0)=0   ! default = 0, call PAGE1
c          write(*,*) 'command is ELL: ',NINT(GRFARG(0))
           IF (GRFNARG.GT.0) GRFARG(0)=GRFARG(1) 
C* RES
        ELSE IF (COMMANDS(ICOM).EQ.'RES') THEN    
           GRFARG(0)=3   ! call PAGE1
c          write(*,*) 'command is RES: ',NINT(GRFARG(0))
C* CRES
        ELSE IF (COMMANDS(ICOM).EQ.'CRES') THEN    
          GRFARG(0)=-3   ! call RES_IMAGE (mf_cur)
c          write(*,*) 'command is CRES: ',NINT(GRFARG(0))
C* MRES
        ELSE IF (COMMANDS(ICOM).EQ.'MRES') THEN    
          GRFARG(0)=-4   ! call RES_IMAGE(0)
c          write(*,*) 'command is MRES: ',NINT(GRFARG(0))
          if (cfgmode.eq.1.and.mf_max.gt.1) GRFARG(0)=-5  ! call AB_IMAGE(ig_FCRES) for flat-cone 
C* PRINT
        ELSE IF (ICOM.EQ.NLIST) THEN    
           TOPRINT=1
        ENDIF 
      ENDIF  
      
C execute plotting dialogs before graph initialization
      IF (TOPRINT.NE.1) THEN
          IC=NINT(GRFARG(0))
c       write(*,*) 'PLOT_CMD, GRFARG: ',IC   
          SELECT CASE (IC)
            CASE (-3,-4)
              CALL DLG_RESPLOT(labels,GRFARG(1),10,GRFSTR)
            CASE (-5,-6,-7)
              IF (CMDMODE.EQ.1) THEN ! call elementary dialogs in interactive mode only 
                GRFSTR=' '
                CALL DLG_STRING('comment',GRFSTR,0)    
                CALL DLG_DOUBLE('scale',GRFARG(1),1,1.D-2,1.D2) 
              ELSE ! otherwise use the dialog arrays
                GRFSTR=DLGSTR(1)
                GRFARG(1)=DLGARG(1)
              ENDIF
          END SELECT           
      ENDIF

      CALL MAKEMC('PLOT')  ! call Monte Carlo if necessary 
                
c execute the main plotting subroutine        
      CALL PLOTOUT ! this is called for all recognized commands

      END


C     --------------------------------------------
      SUBROUTINE SLIT_CMD(OBJ,SCOMM,IQ)
C IQ=1 inidicates return to the parent menu (=QUIT) 
C     --------------------------------------------
      IMPLICIT NONE
      INCLUDE 'nesobj_slit.inc'
      INCLUDE 'restrax_cmd.inc'
      RECORD /SLIT/ OBJ
      CHARACTER*(*) SCOMM
      CHARACTER*128 LINE
      INTEGER*4 IQ,ICOM,NPAR,I,SLIT_SET,IERR,IN,OUT,ERR ,LCOM 
      CHARACTER*128 LINPEXECSTR,SLIT_GET
      LOGICAL*4 LBACK ! indicates return from a submenu (PLOT calls ...)
      DATA LBACK/.FALSE./
      DATA SLITCOMM /'NAME','SIZE','SHAPE','POS','ORI','SHIFT'/ 
      DATA SLITHINT /
     1  'component name',
     2  'dimensions (x,y,z) [mm]',
     3  '(0) sphere (1) cyllinder (2) disc (3) rectangle',
     4  'distance, take-off angle, sagital angle [mm,deg,deg]',
     5  'orientation along (x,y,z) [deg]',
     6  'linear stage shift (x,y,z) [mm]'/ 
      DATA NLIST /6/	

1     FORMAT(a)
      LCOM=LEN_TRIM(SCOMM)
      IQ=0
C// initialization
      IF (IMENU.NE.MN_PLOT) THEN ! first entry => set LINP with menu items
        IMENU=MN_PLOT
        IF (LCOM.EQ.0) THEN
          IF (.NOT.LBACK) LMENU=LMENU+1
          CMENU(LMENU)=IMENU
        ENDIF
        LBACK=.FALSE.
        CALL LINPSET(NLIST,'  '//OBJ.NAME,SLITCOMM,SLITHINT)
        CALL LINPGETIO(IN,OUT,ERR)
      ENDIF
      IF (LCOM.LE.0) RETURN ! ignore empty commands

C// process command through LINP      
      LINE=LINPEXECSTR(SCOMM(1:LCOM),ICOM,NPAR)

C standard commands (ICOM=0)
      IF(ICOM.EQ.0) THEN       
C QUIT
        IF (LINE(1:4).EQ.'QUIT') THEN
          IQ=1
C LIST
        ELSE IF (LINE(1:4).EQ.'LIST') THEN
          DO I=1,nlist
            CALL WRITELINE(SLITCOMM(I)//'  '//SLIT_GET(OBJ,I),OUT)
          ENDDO
          LINE=' '           
        ENDIF
C identified commands (ICOM>0)
      ELSE IF (ICOM.GT.0.AND.ICOM.LE.NLIST) THEN
        IF (NPAR.EQ.0) THEN
           CALL WRITELINE(SLITCOMM(ICOM)//'  '//SLIT_GET(OBJ,ICOM),OUT)
        ELSE
            IERR=SLIT_SET(OBJ,SLITCOMM(ICOM)//'  '//LINE)
            IF(IERR.EQ.-1) THEN
              WRITE(ERR,1) 'Incomplete data !'
            ELSE IF(IERR.EQ.-2) THEN  
              WRITE(ERR,1) 'Wrong data !'
            ENDIF
        ENDIF
      ENDIF      
      END
          
