C---------------------------------------------
C   RESTRAX console interface
C   $Author: saroun $
C   $Id: restraxcon.f,v 1.4 2006/05/06 13:54:58 saroun Exp $      
C----------------------------------------------
      PROGRAM RESTRAX
                 
      CALL RESTRAX_MAIN
      END

C-------------------------------------
      SUBROUTINE RESTRAX_MAIN
C Main unit for console application
C Should be called by the main procedure
C-------------------------------------
      IMPLICIT NONE
      INCLUDE 'const.inc'      
      INCLUDE 'inout.inc'
      INCLUDE 'linp.inc'
      INCLUDE 'restrax_cmd.inc'
      
      CHARACTER*128 LINE,S,UPCASE
      CHARACTER*1 CH
      INTEGER*4 IS,IL
      LOGICAL*4 ECHOMODE      
      DATA ECHOMODE /.FALSE./
      
1     FORMAT(a)
2     FORMAT(a,$)
3     FORMAT(' press ENTER ...',$)

C initialization
      CMDMODE=1 ! command-line mode
      CALL RESINIT    
      CALL CMD_INIT
C run
      DO WHILE (GOEND.EQ.0)
10      IF (linp_in.EQ.5) WRITE(linp_out,2) linp_p(1:linp_np)//'> ' 
        IF (linp_eof.GT.0) GOTO 20
        READ(SINP,1,END=20) LINE ! treat EOF
        CALL BOUNDS(LINE,IS,IL)
        S=UPCASE(LINE(IS:IS+IL-1))
c        write(*,*) S(IS:IS+IL-1)//'>',ECHOMODE      

C echo mode => copy input to output
        IF (ECHOMODE) THEN
           IF (S(IS:IS+IL-1).EQ.'END') THEN ! END ECHO
              ECHOMODE=.FALSE.
           ELSE
             WRITE(linp_out,1) LINE(IS:IS+IL-1)
c             WRITE(linp_out,*) S(IS:IS+IL-1)//'> ',ECHOMODE
           ENDIF
C ECHO
        ELSE IF (S(IS:IS+IL-1).EQ.'ECHO') THEN
           ECHOMODE=.TRUE.
C PAUSE
        ELSE IF (S(IS:IS+IL-1).EQ.'PAUSE') THEN
           WRITE(linp_out,3) 
           READ(*,1) CH
           WRITE(linp_out,*)       
           IF (CH.eq.'q'.OR.CH.EQ.'Q') GOTO 20
C handle input except empty lines and # comments                
        ELSE IF (IL.GT.0.AND.LINE(1:1).NE.'#') THEN 
           CALL CMD_HANDLE(LINE(IS:IS+IL-1))
        ENDIF
        IF (GOEND.EQ.0) GOTO 10        
C handle requests on I/O reset to STDIN/STDOUT
20      CALL REINP(' ')
        CALL LINPSETIO(SINP,SOUT,SMES)
      ENDDO

C finalization       
      CALL RESEND
      END
      
C-----------------------------------------------------------------------
      SUBROUTINE DLG_SETPATH(sarg,prompt,answer,iread,pname)
C Prompt for a valid pathname and store result in PNAME
C INPUT:
C   sarg    ... input string with the path name
C   prompt  ... input prompt text, results in: > prompt [default] : _
C   answer  ... answer text, results in: > answer <pname>
C   iread   ... if>1, read the pathname interactively
C RETURN:
C   pname   ... resulting pathname
C-----------------------------------------------------------------------
      IMPLICIT NONE
      INCLUDE 'const.inc'
      INCLUDE 'inout.inc'
      
      CHARACTER*(*) sarg,prompt,answer,pname
      INTEGER*4 iread
      CHARACTER*128 FN,SS
      INTEGER*4 IS,IL,ISF,ILF,II,LL
      LOGICAL*4 ASKNAME
      
1     FORMAT(a,' [',a,'] : ',$)
2     FORMAT(a,' [current directory] : ',$)
3     FORMAT(a,' ',a)
4     FORMAT(A)       
       
      CALL BOUNDS(sarg,ISF,ILF)                  
      CALL BOUNDS(pname,IS,IL) 
C ask for filename interactively ?
      ASKNAME=(ILF.LE.0.OR.iread.GT.0)
      
      FN=' '
      IF (ILF.GT.0) FN=SARG(ISF:ISF+ILF-1)
      IF (ASKNAME) THEN ! get filename interactively
         IF (IL.GT.0) THEN
            WRITE(SOUT,1) prompt(1:LEN_TRIM(prompt)),pname(IS:IS+IL-1)
         ELSE
            WRITE(SOUT,2) prompt(1:LEN_TRIM(prompt))
         ENDIF
         READ(SINP,4) SS
         CALL BOUNDS(SS,II,LL)
         IF (LL.GT.0) THEN ! use default
            FN=SS(II:II+LL-1)
         ELSE
            FN=pname(IS:IS+IL-1)            
         ENDIF
      ENDIF
      CALL BOUNDS(FN,IS,IL)
         
C Interpret input, ensure that ending delimiter is present       
      IF ((IL.LE.0).OR.
     *    (IL.EQ.1.AND.FN(IS:IS+IL-1).EQ.'.').OR.
     *    (IL.EQ.2.AND.FN(IS:IS+IL-1).EQ.'.'//PATHDEL)) THEN
         pname=' '
         write(sout,3) answer(1:LEN_TRIM(answer)),'current directory'
         RETURN
      ELSE IF(FN(IS+IL-1:IS+IL-1).NE.PATHDEL) THEN
         pname=FN(IS:IS+IL-1)//PATHDEL
      ELSE   
         pname=FN(IS:IS+IL-1)
      ENDIF
      write(sout,3) answer(1:LEN_TRIM(answer)),pname(1:IL)
      END  

C-------------------------------------------------------------------
      SUBROUTINE DLG_FILEOPEN(fname,fpath,fext,iread,isil,ires,fres)
C Get a fully qualified filename, test existence, etc.
C INPUT:
C   fname  ... filename
C   fext   ... default extension
C   fpath  ... colon delimited list of search directories
C   iread  ... if>1, read the filename interactively
C   isil   ... silence level, if isil>0 => no message
C RETURN:
C   fres   ... resulting filename (incl. path)
C   IRES>0 ... ord. number of the path string from fpath
C   IRES=0 ... not found   
C-------------------------------------------------------------------
      IMPLICIT NONE
      INCLUDE 'const.inc'
      INCLUDE 'inout.inc'
      CHARACTER*(*) FNAME,FEXT,FPATH,FRES
      INTEGER*4 iread,isil,ires
      CHARACTER*256 FN,S,SS
      INTEGER*4 ISF,ILF,IS,IL,II,LL,LEXT,TRUELEN
      LOGICAL*4 APEXT,ASKNAME
      
1     FORMAT(' Open file [',a,'] : ',$) 
2     FORMAT(' Open file : ',$) 
4     FORMAT(a)
c11    FORMAT(' DLG_OPEN: ',I4,' <',a,'>')

c      write(*,11) iread,FNAME(1:LEN_TRIM(FNAME))
      IRES=0
      LEXT=TRUELEN(FEXT)
      CALL BOUNDS(FNAME,ISF,ILF)
C append extension ? 
      APEXT=(LEXT.GT.0.AND.(INDEX(FNAME(ISF:ISF+ILF-1),'.').LE.0))
C ask for filename interactively ?
      ASKNAME=(ILF.LE.0.OR.iread.GT.0)
C format prompt
      S=' '
      IF (APEXT) THEN
         IF (ILF.GT.0) THEN
           S=FNAME(ISF:ISF+ILF-1)//'.'//FEXT(1:LEXT)
         ELSE
           S='*.'//FEXT(1:LEXT)
         ENDIF
      ELSE IF (ILF.GT.0) THEN
         S=FNAME(ISF:ISF+ILF-1)
      ENDIF
      CALL BOUNDS(S,IS,IL)

C format the file name
      FN=' '
      IF (ILF.GT.0) FN=FNAME(ISF:ISF+ILF-1)
      IF (ASKNAME) THEN ! get filename interactively
         IF (IL.GT.0) THEN
            WRITE(SOUT,1) S(IS:IS+IL-1)
         ELSE
            WRITE(SOUT,2)
         ENDIF
         READ(SINP,4) SS
         CALL ILLNameParse(SS,1)
         CALL BOUNDS(SS,II,LL)
         IF (LL.LE.0) THEN ! use default
            IF (IL.GT.0) THEN
              FN=S(IS:IS+IL-1)
            ELSE
              GOTO 99 ! no filename, exit
            ENDIF
         ELSE
            FN=SS(II:II+LL-1)
         ENDIF
      ELSE
         CALL ILLNameParse(FN,1)
      ENDIF
      IL=LEN_TRIM(FN)
      IF (IL.LE.0) GOTO 99
c append extension when required        
      APEXT=(LEXT.GT.0.AND.INDEX(FN,'.').LE.0)
      IF (APEXT) FN=FN(1:IL)//'.'//FEXT(1:LEXT) 
          
c      write(*,11) IL,FN(1:LEN_TRIM(FN))
C find the first file that exists in a directory listed in fpath
      CALL CHECKRESFILE(FN,FPATH,ISIL,IRES,FRES)
c      write(*,11) IRES,FRES(1:LEN_TRIM(FRES))
      RETURN
      
99    IRES=0      
      END
      
C--------------------------------------------------------------
      SUBROUTINE DLG_FILESAVE(fname,fpath,fext,iread,iover,ires,fres)
C Get a fully qualified filename for saving, test overwrite, etc.
C INPUT:
C   fname  ... filename
C   fpath  ... target directory
C   fext   ... default extension
C   iread  ... if>1, read the filename interactively
C   iover  ... if>1, dont ask for overwriting the file
C RETURN:
C   fres   ... resulting filename (incl. path)
C   IRES>0 ... open possible, fres is the full pathname
C   IRES=0 ... cancel
C--------------------------------------------------------------
      IMPLICIT NONE
      INCLUDE 'const.inc'
      INCLUDE 'inout.inc'
      CHARACTER*(*) FNAME,FEXT,FPATH,FRES
      INTEGER*4 iread,iover,ires
      CHARACTER*256 FFN,FN,SS,S
      CHARACTER*1 CH
      INTEGER*4 ISF,ILF,IS,IL,II,LL,LRES,LEXT,j
      LOGICAL*4 LOG1,APEXT,ASKNAME
      
1     FORMAT(' Save to file [',a,'] : ',$) 
2     FORMAT(' Save to file : ',$) 
4     FORMAT(a)
5     format('File ',a,' already exists. Overwrite ? [y|n] ',$)
      
      IRES=0
      LRES=LEN(FRES)
      LEXT=LEN_TRIM(FEXT)
      CALL BOUNDS(FNAME,ISF,ILF)
C append extension ? 
      APEXT=(LEXT.GT.0.AND.INDEX(FNAME(ISF:ISF+ILF-1),'.').LE.0)
C ask for filename interactively ?
      ASKNAME=(ILF.LE.0.OR.iread.GT.0)
C format prompt
      S=' '
      IF (APEXT) THEN
         IF (ILF.GT.0) THEN
           S=FNAME(ISF:ISF+ILF-1)//'.'//FEXT(1:LEXT)
         ELSE
           S='*.'//FEXT(1:LEXT)
         ENDIF
      ELSE IF (ILF.GT.0) THEN
         S=FNAME(ISF:ISF+ILF-1)
      ENDIF
      CALL BOUNDS(S,IS,IL)

C format the file name
      FN=' '
      IF (ILF.GT.0) FN=FNAME(ISF:ISF+ILF-1)
      IF (ASKNAME) THEN  ! get filename interactively
         IF (S.NE.' ') THEN
            WRITE(SOUT,1) S(IS:IS+IL-1)
         ELSE
            WRITE(SOUT,2)
         ENDIF
         READ(SINP,4) SS
         CALL BOUNDS(SS,II,LL)
         IF (LL.LE.0) THEN ! use default
            IF (ILF.GT.0) THEN
              FN=FNAME(ISF:ISF+ILF-1)
            ELSE
              GOTO 99 ! no filename, exit
            ENDIF
         ELSE
            FN=SS(II:II+LL-1)
         ENDIF
      ENDIF    
      IL=LEN_TRIM(FN)
      IF (IL.LE.0) GOTO 99
c append extension when required        
      APEXT=(LEXT.GT.0.AND.INDEX(FN,'.').LE.0)
      IF (APEXT) FN=FN(1:IL)//'.'//FEXT(1:LEXT) 
      
c prepend the path name        
      CALL BOUNDS(FPATH,IS,IL)
      j=is+il-1
      IF (IL.GT.0.AND.fpath(j:j).NE.PATHDEL) THEN
         FFN=fpath(is:j)//PATHDEL//fn(1:LEN_TRIM(FN))
      ELSE IF (IL.GT.0) THEN
         FFN=fpath(is:j)//fn(1:LEN_TRIM(FN))
      ELSE
         FFN=fn(1:LEN_TRIM(FN))
      ENDIF
      LL=LEN_TRIM(FFN)
      IF (LL.GT.LRES) LL=LRES
      fres=FFN(1:LL)
C check for overwrite
      CH='y'
      IF (IOVER.GT.0.AND.SINP.EQ.5) THEN ! automatic overwrite for non-std input
        INQUIRE(FILE=FFN(1:LL),EXIST=LOG1)
        IF (LOG1) THEN  ! ask before overwrite
20        write(sout,5) fn(1:LEN_TRIM(FN))
          read(sinp,4,err=20) ch        
          if (ch.EQ.'Y') ch='y'
        ENDIF
      ENDIF
      if (ch.ne.'y') goto 99
      ires=1
      RETURN
      
99    IRES=0    
      END
      
C--------------------------------------------------------------
      SUBROUTINE DLG_INPUT(labels,values,idef)
C Dialog for numerical input.
C INPUT:
C   labels  ... a string with value names, items are delimited by :
C   values  ... if idef>0, should contain default values 
C   idef    ... if >0, prompt inlcudes default values accepted by <enter>
C RETURN:
C   values  ... real*8 array with return values
C NOTE! No check is made on values array dimension
C--------------------------------------------------------------
      IMPLICIT NONE
      INCLUDE 'const.inc'
      INCLUDE 'inout.inc'
      CHARACTER*(*) labels
      REAL*8 values(*)
      INTEGER*4 idef
      CHARACTER*64 S,S1
      CHARACTER*128 prompt
      INTEGER*4 IS,IL,IS1,IL1,ILP,IP,itry,ios
      
      
1     format(a,' : ',$)
3     format(a)
4     format('invalid number format, ',$)
6     format('try again')
8     format('no input')

20    format(a)
21    format(a,' [',a,']')
22    format(G12.4)

      IL=1
      IP=0
      DO WHILE (IL.GE.0)
c// get next value name
        IP=IP+1
        CALL FINDSTRPAR(labels,':',IP,IS,IL)
c// format prompt
        IF (IL.GT.0) THEN 
          S=labels(IS:IS+IL-1)
          ILP=IL
        ELSE
          S='input number'
          ILP=12
        ENDIF
        IF (idef.gt.0) THEN
          write(S1,22) values(IP)
          CALL BOUNDS(S,IS1,IL1)
          write(prompt,21) S(1:ILP),S1(IS1:IS1+IL1-1)
        ELSE
          write(prompt,20) S(1:ILP)  
        ENDIF  
        ILP=LEN_TRIM(prompt)
        IF (ILP.GT.128) ILP=128
        IF (IL.GE.0) THEN
c// read data and check validity
           itry=0
10         itry=itry+1
           WRITE(SOUT,1) prompt(1:ILP)
           READ(SINP,3) S
           IL1=LEN_TRIM(S)
           IF (IL1.GT.0) READ(S,*,iostat=ios,err=11) values(IP)
c// validate input      
11         IF (ios.ne.0) THEN ! format error
             write(sout,4) 
           ENDIF
           IF (itry.lt.5.AND.ios.ne.0) then ! 5 attempts to enter a valid number
             write(sout,6) 
             goto 10
           ELSE IF (ios.ne.0) then
             write(sout,8)             
           ENDIF
        ENDIF   
      ENDDO     
      END      
      
      
C--------------------------------------------------------------
      SUBROUTINE DLG_INTEGER(label,ivalue,idef,imin,imax)
C Single integer number input, with range checking.
C INPUT:
C   label   ... a string with value name
C   ivalue  ... if idef>0, should contain default value 
C   idef    ... if >0, prompt inlcudes the default value accepted by <enter>
C   imin,imax  ... limits (inclusive)
C RETURN:
C   ivalue  ... integer*4 return value
C--------------------------------------------------------------
      IMPLICIT NONE
      INCLUDE 'const.inc'
      INCLUDE 'inout.inc'
      CHARACTER*(*) label
      INTEGER*4 ivalue,idef,imin,imax
      CHARACTER*64 S,S1,S2,S3
      CHARACTER*128 prompt
      INTEGER*4 IS1,IS2,IS3,IL,IL1,IL2,IL3,ILP,itry,ios
      
      
1     format(a,' : ',$)
3     format(a)
4     format('invalid number format, ',$)
5     format('value outside limits, ',$)
6     format('try again')
8     format('no input')

20    format(a,' (',a,' .. ',a,') ')
21    format(a,' (',a,' .. ',a,') [',a,']')
22    format(I8)

      prompt=' '
c// format prompt
      WRITE(S1,22) imin
      WRITE(S2,22) imax
      CALL BOUNDS(S1,IS1,IL1)
      CALL BOUNDS(S2,IS2,IL2)
      IL=LEN_TRIM(label)
      IF (IL.GT.0) THEN 
        S=label(1:IL)
      ELSE
        S='input number'
        IL=12
      ENDIF      
      IF (idef.gt.0) THEN
        write(S3,22) ivalue
        CALL BOUNDS(S3,IS3,IL3)
        write(prompt,21) S(1:IL),S1(IS1:IS1+IL1-1),
     &      S2(IS2:IS2+IL2-1),S3(IS3:IS3+IL3-1)
      ELSE
        write(prompt,20) S(1:IL),S1(IS1:IS1+IL1-1),
     &      S2(IS2:IS2+IL2-1)
      ENDIF      
      ILP=LEN_TRIM(prompt)
      IF (ILP.GT.128) ILP=128
c// read data and check validity
      itry=0
10    itry=itry+1
      WRITE(SOUT,1) prompt(1:ILP)
      READ(SINP,3) S
      IL1=LEN_TRIM(S)
      ios=0
      IF (IL1.GT.0) READ(S,*,iostat=ios,err=11) ivalue
c// validate input      
11    IF (ios.ne.0) THEN ! format error
          write(sout,4) 
      ELSE IF (ivalue.LT.imin.OR.ivalue.GT.imax) THEN   ! range error        
          ios=1
          write(sout,5) 
      ENDIF
      IF (itry.lt.5.AND.ios.ne.0) then ! 5 attempts to enter a valid number
          write(sout,6) 
          goto 10
      ELSE IF (ios.ne.0) then
          write(sout,8)             
      ENDIF
      END   

C--------------------------------------------------------------
      SUBROUTINE DLG_DOUBLE(label,value,idef,dmin,dmax)
C Single real*8 number input, with range checking.
C INPUT:
C   label   ... a string with value name
C   value   ... if idef>0, should contain default value 
C   idef    ... if >0, prompt inlcudes the default value accepted by <enter>
C   dmin,dmax  ... limits (inclusive)
C RETURN:
C   value  ... real*8 return value
C--------------------------------------------------------------
      IMPLICIT NONE
      INCLUDE 'const.inc'
      INCLUDE 'inout.inc'
      CHARACTER*(*) label
      INTEGER*4 idef
      REAL*8 value,dmin,dmax
      CHARACTER*64 S,S1,S2,S3
      CHARACTER*128 prompt
      INTEGER*4 IS1,IS2,IS3,IL,IL1,IL2,IL3,ILP,itry,ios
      
      
1     format(a,' : ',$)
3     format(a)
4     format('invalid number format, ',$)
5     format('value outside limits, ',$)
6     format('try again')
8     format('no input')

20    format(a,' (',a,' .. ',a,')')
21    format(a,' (',a,' .. ',a,') [',a,']')
c22    format(F10.4)

      prompt=' '
c// format prompt
      CALL FLOAT2STR(dmin,S1)
      CALL FLOAT2STR(dmax,S2)
c      WRITE(S1,22) dmin
c      WRITE(S2,22) dmax
      CALL BOUNDS(S1,IS1,IL1)
      CALL BOUNDS(S2,IS2,IL2)
      IL=LEN_TRIM(label)
      IF (IL.GT.0) THEN 
        S=label(1:IL)
      ELSE
        S='input number'
        IL=12
      ENDIF      
      IF (idef.gt.0) THEN
        CALL FLOAT2STR(value,S3)
c        write(S3,22) value
        CALL BOUNDS(S3,IS3,IL3)
        write(prompt,21) S(1:IL),S1(IS1:IS1+IL1-1),
     &      S2(IS2:IS2+IL2-1),S3(IS3:IS3+IL3-1)
      ELSE
        write(prompt,20) S(1:IL),S1(IS1:IS1+IL1-1),
     &      S2(IS2:IS2+IL2-1)
      ENDIF      
      ILP=LEN_TRIM(prompt)
      IF (ILP.GT.128) ILP=128
c// read data and check validity
      itry=0
10    itry=itry+1
      WRITE(SOUT,1) prompt(1:ILP)
      READ(SINP,3) S
      IL1=LEN_TRIM(S)
      IOS=0
      IF (IL1.GT.0) READ(S,*,iostat=ios,err=11) value
c// validate input      
11    IF (ios.ne.0) THEN ! format error
          write(sout,4) 
      ELSE IF (value.LT.dmin.OR.value.GT.dmax) THEN   ! range error        
          ios=1
          write(sout,5) 
      ENDIF
      IF (itry.lt.5.AND.ios.ne.0) then ! 5 attempts to enter a valid number
          write(sout,6) 
          goto 10
      ELSE IF (ios.ne.0) then
          write(sout,8)             
      ENDIF
      END   

C--------------------------------------------------------------
      SUBROUTINE DLG_STRING(label,value,idef)
C Single string input
C INPUT:
C   label   ... a string with value name
C   value   ... if idef>0, should contain default value 
C   idef    ... if >0, prompt inlcudes the default value accepted by <enter>
C RETURN:
C   value  ...  return string value
C NOTE: must not channge the value on default response (ENTER)
C--------------------------------------------------------------
      IMPLICIT NONE
      INCLUDE 'const.inc'
      INCLUDE 'inout.inc'
      CHARACTER*(*) label,value
      INTEGER*4 idef
      CHARACTER*128 S,prompt
      INTEGER*4 IS1,IL,IL1,ILP      
      
1     format(a,' : ',$)
2     format(a,' [',a,']')
3     format(a)

      prompt=' '
c// format prompt
      IL=LEN_TRIM(label)
      IF (IL.GT.0) THEN 
        S=label(1:IL)
      ELSE
        S='input string'
        IL=12
      ENDIF 
      if (idef.gt.0) then
        CALL BOUNDS(value,IS1,IL1)
        write(prompt,2) S(1:IL),value(IS1:IS1+IL1-1)        
      else
        prompt=S(1:IL)
      endif
      ILP=LEN_TRIM(prompt)
      IF (ILP.GT.128) ILP=128
c// read value
      WRITE(SOUT,1) prompt(1:ILP)
      READ(SINP,3) S
      IL1=LEN_TRIM(S)
      IL1=MIN(IL1,LEN(value)) ! check for value size
      IF (IL1.GT.0) value=S(1:IL1)
      END 

C--------------------------------------------------------------
      SUBROUTINE DLG_RESPLOT(labels,ARG,NARG,SARG)
C Dialog for 2D-plot settings: resoluton function projections
C By convention, output is stored in the ARG(11..) array and GRFSTR string
C INPUT:
C   labels     ... axes names, delimited by :
C RETURN:
C   ARG(1..2)    ... selected pair of axes
C   ARG(3..4)    ... limits for x-axis
C   ARG(5..6)    ... limits for y-axis
C   SARG         ... a plot caption
C Dialog arguments (in non-interactive mode):
C DLGARG(1..6) ... copied to ARG
C DLGSTR(1)    ... copied to SARG (plot caption)
C--------------------------------------------------------------
      IMPLICIT NONE
      INCLUDE 'const.inc'
      INCLUDE 'inout.inc'
      INCLUDE 'res_grf.inc'
      INCLUDE 'restrax_cmd.inc'
      
      CHARACTER*(*) labels,SARG
      INTEGER*4 NARG
      REAL*8 ARG(NARG)
      CHARACTER*128 comment
      INTEGER*4 IX,IY
      REAL*8 XMIN,XMAX,YMIN,YMAX
      INTEGER*4 I,IS,IL,IP

1     format(i2,') ',a)
2     FORMAT('select projection (X,Y): ',$)
3     FORMAT('limits for ',a,' [min max] : ',$)
4     FORMAT('comment: ',$)
5     FORMAT(a)
6     FORMAT('incorrect range, try again ...')

C// non-interactive case -> use the argument array
      IF (CMDMODE.EQ.0) THEN
         CALL BOUNDS(DLGSTR(1),IS,IL)
         IF (IL.GT.LEN(SARG)) IL=LEN(SARG)
         SARG=DLGSTR(1)(IS:IS+IL-1)
         DO I=1,6
           ARG(I)=DLGARG(I)
         ENDDO
         RETURN
      ENDIF      

C// interactive mode:

C// get number of axes available
      IL=1
      IP=0
      DO WHILE (IL.GT.0)
        CALL FINDSTRPAR(labels,':',IP+1,IS,IL)
        IF (IL.GT.0) THEN
          IP=IP+1
          WRITE(SMES,1) IP,labels(IS:IS+IL-1)
        ENDIF
      ENDDO
C// get projection axes
10    WRITE(SMES,2) 
      read(SINP,*,err=10) IX,IY
      if (IX.LT.0.OR.IX.GT.IP.OR.IY.LT.0.OR.IY.GT.IP) goto 10
C// get limits      
      CALL FINDSTRPAR(labels,':',IX,IS,IL)
20    write(SOUT,3) labels(IS:IS+IL-1)
      read(SINP,*,err=20) xmin,xmax
      if (xmin.ge.xmax) then
         WRITE(SMES,6)
         goto 20
      endif
      CALL FINDSTRPAR(labels,':',IY,IS,IL)
30    write(SOUT,3) labels(IS:IS+IL-1)
      read(SINP,*,err=30) ymin,ymax
      if (ymin.ge.ymax) then
         WRITE(SMES,6)
         goto 30
      endif
      WRITE(SMES,4)
      read(SINP,5) comment      
      
      CALL BOUNDS(comment,IS,IL)
      IF (IL.GT.LEN(SARG)) IL=LEN(SARG)
      SARG=comment(IS:IS+IL-1)
      ARG(1)=IX
      ARG(2)=IY
      ARG(3)=xmin
      ARG(4)=xmax
      ARG(5)=ymin
      ARG(6)=ymax      
      
      END

C $Log: restraxcon.f,v $
C Revision 1.4  2006/05/06 13:54:58  saroun
C some fixes for plotting: PLOT SCAN without histogram
C
C Revision 1.3  2005/07/13 15:17:35  saroun
C *** empty log message ***
C
C Revision 1.2  2005/07/13 15:15:55  saroun
C *** empty log message ***
C
C Revision 1.1.1.1  2005/07/13 14:20:33  saroun
C
C
C Revision 1.3  2005/07/12 19:24:13  saroun
C another test cvs
C
C Revision 1.2  2005/07/12 19:21:50  saroun
C testing cvs keywords
C

