C///////////////////////////////////////////////////////////////////////////
C////  C $Id: strings.f,v 1.4 2006/05/05 17:42:56 saroun Exp $                                                                
C////  strings.f - v.1.2, (c) J.Saroun, 1999-2001                      
C////                                                                
C////  String handling subroutines for RESTRAX                         
C////                                                              
C///////////////////////////////////////////////////////////////////////////
C////
C//// 
C////  CALL FINDPAR(LINE,IPAR,ISTART,ILEN)
C////   .... find possition of the IPAR-th parameter on the LINE
C//// 
C////  + other useful routines for handling strings
C////
C///////////////////////////////////////////////////////////////////////////

C     -----------------------------------------------------------------
      SUBROUTINE READ_R8(NAME, LINE, RESULT, IERR)
C     Read REAL*8 number from the LINE identified by NAME
C     suppose format "NAME=number " or "NAME number "
C     -----------------------------------------------------------------

      IMPLICIT NONE
      CHARACTER*(*) LINE,NAME
      INTEGER*4 L,ISTART,ILEN,I,INAME,LNAME,IERR,IS
      REAL*8 Z,RESULT
      CHARACTER*1 CH
      
      IERR=-1
      CALL BOUNDS(NAME,INAME,LNAME)
      IF (LNAME.LE.0) GOTO 99
      L=LEN_TRIM(LINE)
      IS=1
10    i=INDEX(LINE(IS:L),NAME(INAME:INAME+LNAME-1)) 
      IF (i.GT.1) THEN      
        if (LINE(is+i-2:is+i-2).NE.' ') THEN  ! space delimiter must precede the name
          IS=IS+i-1+LNAME ! try other occurences after this one
          GOTO 10
        ENDIF
      ENDIF
C// identifier NAME found
      IF (i.GT.0) THEN   
        i=i+IS-1+LNAME  ! i=1st character after NAME
C// name must be followed by = or space
        IF (LINE(i:i).NE.'='.AND.LINE(i:i).NE.' ') RETURN
        i=i+1
        ISTART=1
        CALL FINDPAR(LINE(i:L),1,ISTART,ILEN) ! find next substring
        ISTART=ISTART+i-1
        CH=LINE(ISTART:ISTART)
C// skip the '=' character
        IF(ILEN.GE.1.AND.CH.EQ.'=') ISTART=ISTART+1
C// exclude T and F, which might be interpreted as a valid number on some systems
        IF (CH.EQ.'T'.OR.CH.EQ.'F') RETURN
C// try to read number from the rest of the line
        READ(LINE(ISTART:L),*,ERR=99) Z   
        IERR=0      
        RESULT=Z 
c        write(*,*) LINE(ISTART:L)//'=',Z
c        pause
      ENDIF
      
      RETURN
99    IERR=-2   ! cannot read value
      END      
      
C     -----------------------------------------------------------------
      SUBROUTINE READ_I4(NAME,LINE,RESULT,IERR)
C     Read INTEGER*4 number from the LINE identified by NAME
C     suppose format "NAME=number " or "NAME number "
C     -----------------------------------------------------------------

      IMPLICIT NONE
      CHARACTER*(*) LINE,NAME
      INTEGER*4 L,ISTART,ILEN,I,INAME,LNAME,IERR,IS
      INTEGER*4 Z,RESULT
      CHARACTER*1 CH

      IERR=-1     
      CALL BOUNDS(NAME,INAME,LNAME)
      IF (LNAME.LE.0) GOTO 99
      L=LEN_TRIM(LINE)
      IS=1
10    i=INDEX(LINE,NAME(INAME:INAME+LNAME-1))      
      IF (i.GT.1) THEN      
        if (LINE(is+i-2:is+i-2).NE.' ') THEN  ! space delimiter must precede the name
          IS=IS+i-1+LNAME ! try other occurences after this one
          GOTO 10
        ENDIF
      ENDIF
C// identifier NAME found
      IF(i.GT.0) THEN   
        i=i+IS-1+LNAME  ! i=first character after NAME
C// name must be followed by = or space
        IF (LINE(i:i).NE.'='.AND.LINE(i:i).NE.' ') RETURN
        i=i+1
        ISTART=1
        CALL FINDPAR(LINE(i:L),1,ISTART,ILEN) ! find next substring
        ISTART=ISTART+i-1
        CH=LINE(ISTART:ISTART)
C// skip the '=' character
        IF(ILEN.GE.1.AND.CH.EQ.'=') ISTART=ISTART+1
C// try to read a number from the rest of the line
        READ(LINE(ISTART:L),*,ERR=99) Z 
        IERR=0
        RESULT=Z            
      ENDIF
      
      RETURN
99    IERR=-2   ! cannot read value
      END      
      
C     -----------------------------------------------------------------
      SUBROUTINE READ_STR(NAME,LINE,RESULT,IERR)
C     Read STRING from the LINE identified by NAME
C     suppose format "NAME=string"
C     -----------------------------------------------------------------

      IMPLICIT NONE
      CHARACTER*(*) LINE,NAME
      INTEGER*4 L,ISTART,ILEN,I,INAME,LNAME,IERR,LR,IS
      CHARACTER*(*) RESULT
      CHARACTER*1 CH
            
            
c      write(*,*) 'READ_STR: ',TRIM(LINE)
      IERR=-1     
      CALL BOUNDS(NAME,INAME,LNAME)
      
      IF (LNAME.LE.0) GOTO 99
      L=LEN_TRIM(LINE)
      LR=LEN(RESULT)
      IS=1
      
10    i=INDEX(LINE(IS:L),NAME(INAME:INAME+LNAME-1)//'=')
c       write(*,*) 'READ_STR: ',i
      if (i.GT.1) then       
        if (LINE(is+i-2:is+i-2).NE.' ') THEN  ! space delimiter must precede the name
          IS=IS+i-1+LNAME ! try other occurences after this one
          GOTO 10
        ENDIF
      ENDIF
      
c      write(*,*) 'READ_STR: ',IS,INAME,LNAME,TRIM(NAME)
C// identifier NAME found
      IF(i.GT.0) THEN   
        i=i+IS-1+LNAME  ! i=first character after NAME
C// name must be followed by = or space
c        write(*,*) LINE(i:i)//'>'
        IF (LINE(i:i).NE.'='.AND.LINE(i:i).NE.' ') RETURN
        i=i+1
        ISTART=1
c        write(*,*) LINE(1:i-1)//'='//LINE(i:L)
        CALL FINDPAR(LINE(i:L),1,ISTART,ILEN) ! find next substring
        ISTART=ISTART+i-1
        CH=LINE(ISTART:ISTART)
C// skip the '=' character
        IF(ILEN.GT.0.AND.CH.EQ.'=') ISTART=ISTART+1
        IF(ILEN.GT.LR) ILEN=LR
c        write(*,*) LINE(1:i-1)//'='//LINE(ISTART:ISTART+ILEN-1)
        IF(ILEN.GT.0) THEN
C// result is all after the delimiter (=)
          RESULT=LINE(ISTART:ISTART+ILEN-1) 
        ELSE
          RESULT=' '        
        ENDIF  
        IERR=0              
      ENDIF
      
      RETURN
99    IERR=-2   ! cannot read value      
      END      

C     -----------------------------------------------------------------
      SUBROUTINE FINDPAR(LINE,IPAR,ISTART,ILEN)
C     Finds IPAR-th parameter found on LINE, starting from 
C     ISTART-th character 
C     returns starting position in ISTART and length in ILEN 
C     -----------------------------------------------------------------
      IMPLICIT NONE
      CHARACTER*(*) LINE
      INTEGER*4 L,i1,i2,IPAR,ISTART,ILEN,K      
      LOGICAL*4 LOG1

1     FORMAT(A)

      ILEN=0
      
      L=LEN(LINE)
      i1=ISTART
      i2=0
      DO K=1,IPAR
        if (i1.lt.1) i1=1
        DO WHILE (i1.le.L.AND.LINE(i1:i1).EQ.' ')
         i1=i1+1
        END DO
        LOG1=(i1.GT.L)
        IF (.NOT.LOG1) LOG1=(i1.eq.L.AND.LINE(i1:i1).EQ.' ')
        IF (LOG1) THEN
          ISTART=0
          ILEN=0
          RETURN
        ENDIF    
        i2=i1
        DO WHILE (i2.le.L.AND.LINE(i2:i2).NE.' ')
         i2=i2+1
        END DO
        IF (K.LT.IPAR) I1=I2
      ENDDO  
      ILEN=I2-I1
      ISTART=I1
      END
      
C     ---------------------------------------------------
      CHARACTER*(*) FUNCTION STRIP(line)
C     removes initial and terminal spaces
C     ---------------------------------------------------
      IMPLICIT NONE
      CHARACTER*(*) line
      INTEGER*4 L,I
      L=LEN(line)
      IF (L.EQ.0) THEN
         STRIP=' '
         RETURN
      ENDIF   
      DO WHILE (line(L:L).EQ.' '.AND.L.GT.0)
         L=L-1
      ENDDO
      I=1
      DO WHILE (line(I:I).EQ.' '.AND.I.LT.L)
         I=I+1
      ENDDO
      IF (I.GT.L) THEN
         STRIP=' '
      ELSE
         STRIP=line(I:L) 
      ENDIF 
      END  

C     ---------------------------------------------------
      CHARACTER*(*) FUNCTION CONCAT(str1,str2)
C     connects 2 strings without spaces in between
C     ---------------------------------------------------
      IMPLICIT NONE
      CHARACTER*(*) str1,str2
      INTEGER*4 I1,I2,J1,J2
      CALL BOUNDS(str1,I1,J1)
      CALL BOUNDS(str2,I2,J2)
      CONCAT=str1(I1:I1+J1-1)//str2(I2:I2+J2-1)
      END
      
 
C     ---------------------------------------------------
      SUBROUTINE BOUNDS(line,ISTART,ILEN)
C     get position of string by stripping off the surrounding spaces
C     ---------------------------------------------------
      IMPLICIT NONE
      CHARACTER*(*) line
      INTEGER*4 L,I,ISTART,ILEN
      L=LEN_TRIM(line)
      ISTART=1
      IF (L.EQ.0) THEN
         ILEN=0
      ELSE
        I=1
        DO WHILE (I.LE.L.AND.(line(I:I).EQ.' '.OR.line(I:I).EQ.CHAR(0)))
           I=I+1
        ENDDO
        IF (I.GT.L) THEN
           ILEN=0
        ELSE
           ISTART=I
           ILEN=L-I+1
        ENDIF 
      ENDIF
      END  
     
c     ---------------------------------------------------
      SUBROUTINE STRCOMPACT(line,ISTART,ILEN)
C     remove multiplied spaces, return start (ISTART) and length (ILEN) of the resulting string
C     NOTE: line is modified !
C     ---------------------------------------------------
      IMPLICIT NONE
      CHARACTER*(*) line
      INTEGER*4 L,I,J,ISTART,ILEN
      L=LEN(line)
      I=1
      DO WHILE (I.LT.L)
        IF (LINE(I:I+1).EQ.'  ') THEN
           DO J=I+1,L-1 
             LINE(J:J)=LINE(J+1:J+1)
           ENDDO
           LINE(L:L)=' '
           L=L-1  
        ELSE
           I=I+1
        ENDIF
      ENDDO
      CALL BOUNDS(line,ISTART,ILEN)
      
      END  

C     -------------------------------------------------------------------
      INTEGER*4 FUNCTION TRUELEN(line)
C     return true length of the string 
C     (without trailing spaces or NULL characters)
C equivalent of LEN_TRIM
C     -------------------------------------------------------------------
      IMPLICIT NONE
      CHARACTER*(*) line
      INTEGER*4 L
      TRUELEN=0
      L=LEN(line)
      IF (L.EQ.0) THEN
         TRUELEN=0
         RETURN
      ENDIF   
      DO WHILE (L.GT.0. AND.(line(L:L).EQ.' '.OR.line(L:L).EQ.char(0)))
         L=L-1
      ENDDO
      TRUELEN=L
      END 

C     ---------------------------------------------------
      SUBROUTINE WRITELINE(LINE,IU)
C     writes LINE to IU without surrounding spaces 
C     ---------------------------------------------------
      IMPLICIT NONE
      CHARACTER*(*) LINE
      INTEGER*4 L,IS,IU
      CALL BOUNDS(LINE,IS,L)
1     FORMAT(a)
      WRITE(IU,1) LINE(IS:IS+L-1)
      END 
      

C     ---------------------------------------------------
      CHARACTER*(*) FUNCTION UPCASE(LINE)
C     converts LINE to uppercase     
C     ---------------------------------------------------
      IMPLICIT NONE
      CHARACTER*(*) LINE
      INTEGER*4 L,I
      L=LEN_TRIM(LINE)
      DO i=1,L
         IF((LINE(i:i).GE.'a').AND.(LINE(i:i).LE.'z')) THEN
            UPCASE(i:i)=CHAR(ICHAR(LINE(i:i))-32)
         ELSE
            UPCASE(i:i)=LINE(i:i)   
         ENDIF  
      ENDDO 
      END

C     ---------------------------------------------------
      SUBROUTINE MKUPCASE(LINE)
C     converts LINE to uppercase, subroutine version    
C     ---------------------------------------------------
      IMPLICIT NONE
      CHARACTER*(*) LINE
      INTEGER*4 L,I
      L=LEN(LINE)
      DO i=1,L
         IF((LINE(i:i).GE.'a').AND.(LINE(i:i).LE.'z')) THEN
            LINE(i:i)=CHAR(ICHAR(LINE(i:i))-32)
         ENDIF  
      ENDDO 
      END


C     ---------------------------------------------------
      LOGICAL*4 FUNCTION IsNumber(LINE) 
c     true if LINE is a number 
C     ---------------------------------------------------
      IMPLICIT NONE
      CHARACTER*(*) LINE
      INTEGER*4 L
      REAL*8 RNUM
      L=LEN(LINE)
      IF (L.LE.0.OR.(INDEX('tTfF',LINE(1:1)).GT.0)) GOTO 10
      READ(LINE(1:L),*,err=10)  RNUM
      IsNumber=.TRUE.
      return
10    IsNumber=.FALSE.      
      END
      
C     ---------------------------------------------------
      LOGICAL*4 FUNCTION IsInteger(LINE) 
c     true if LINE is an integer 
C     ---------------------------------------------------
      IMPLICIT NONE
      CHARACTER*(*) LINE
      INTEGER*4 L
      INTEGER*4 INUM
      L=LEN(LINE)
      IF (L.LE.0.OR.(INDEX('tTfF',LINE(1:1)).GT.0)) GOTO 10
      READ(LINE(1:L),*,err=10)  INUM
      IsInteger=.TRUE.
      return
10    IsInteger=.FALSE.
      END
      

C---------------------------------------------------
      SUBROUTINE GETLINPARG(LINE,ARG,N,NARG) 
C Get numerical arguments from the line and store them in ARG
C Takes only consecutive serie of space-delimited numbers,
C stops enumerating at a non-number parameter or EOL
C---------------------------------------------------
      IMPLICIT NONE
      CHARACTER*(*) LINE
      INTEGER*4 NARG,N,IERR,IS,L,I
      REAL*8 ARG(N)
      LOGICAL*4 IsNumber
      
      NARG=0
      DO I=1,N
         ARG(I)=0.D0
      ENDDO   
      IERR=0
      IS=1
      DO WHILE (IERR.EQ.0.AND.IS.LT.LEN(LINE).AND.NARG.LT.N)   ! read parameters
         CALL FINDPAR(LINE,1,IS,L)
         IF (L.GT.0) THEN
            IF (IsNumber(LINE(IS:IS+L-1))) THEN
              READ(LINE(IS:IS+L-1),*,IOSTAT=IERR,ERR=100) ARG(NARG+1)
              NARG=NARG+1 
              IS=IS+L 
            ELSE
              IERR=1 
            ENDIF  
         ELSE
            IERR=1
         ENDIF
100      CONTINUE
      ENDDO
      END

C-----------------------------------------------------------------
      SUBROUTINE FINDSTRPAR(LINE,DLM,IPAR,ISTART,ILEN)
C Finds IPAR-th string parameter found on LINE
C DLM ... delimiter character
C returns starting position in ISTART and length in ILEN 
C ILEN<0 ... not found
C ILEN=0 ... empty string (e.g. the 2nd item in  "abc::def:qwerty:")
C-----------------------------------------------------------------
      IMPLICIT NONE
      CHARACTER*(*) LINE
      CHARACTER*1 DLM
      INTEGER*4 L,i1,i2,IPAR,ISTART,ILEN,K
      INTEGER*4 TRUELEN   

1     FORMAT(A)

      L=TRUELEN(LINE)
      IF (L.LT.1) GOTO 99 ! no characters
      K=1
      i1=1
      i2=INDEX(LINE(i1:L),DLM)
      
      IF (i2.le.0) THEN ! no delimiter
        IF (IPAR.GT.1) GOTO 99
        ILEN=L-i1+1
        RETURN
      ENDIF
c               write(*,*) 'FINDSTRPAR: ',i1,L,i2,K,IPAR
      
      DO WHILE (i2.GT.0.AND.K.LT.IPAR.AND.i1+i2.LE.L)
        i1=i1+i2
        i2=INDEX(LINE(i1:L),DLM)
        K=K+1
      ENDDO
      IF (K.lt.IPAR) GOTO 99 ! no IPAR-th item on the list
      IF (i2.LE.0) THEN
         i2=L+1-i1 ! last string does not end with DLM
      ELSE
         i2=i2-1   ! item ends before next DLM
      ENDIF
c              write(*,*) 'FINDSTRPAR END: ',i1,i2     
      ISTART=i1
      ILEN=i2
      RETURN
      
99    ILEN=-1                 
      END

C-----------------------------------------------------------------
      SUBROUTINE FNSPLIT(LINE,DLM,FPATH,FNAME,FEXT)
C Split the full filename (LINE) to path, name and extension
C path includes terminal delimiter, extension includes initial dot  
C INPUT:
C line   ... full filename
C dlm    ... path delimiter
C OUTPUT:
C fpath   ... path
C fname   ... name
C fext    ... extension
C-----------------------------------------------------------------
      IMPLICIT NONE
      CHARACTER*(*) LINE,FPATH,FNAME,FEXT
      CHARACTER*1 DLM
      INTEGER*4 L,i1,i2,IL
      INTEGER*4 TRUELEN   
      
      i1=1
      L=TRUELEN(LINE)
      
      IF (L.LE.0) THEN
        FPATH=' '
        FNAME=' '
        FEXT=' '
        RETURN
      ENDIF
      
      i2=INDEX(LINE(i1:L),DLM)
      DO WHILE (i2.GT.0.AND.L.GT.i1)
        i1=i1+i2
        i2=INDEX(LINE(i1:L),DLM)
      ENDDO
      i1=i1-1
C// i1 points to the last path delimiter or =0
      i2=INDEX(LINE(i1+1:L),'.')
      if (i2.GT.0) i2=i1+i2
C// i2 points to the dot or =0

C// get FEXT
      if (i2.gt.0) THEN
         IL=L
         IL=MIN(IL,LEN(FEXT)+i2-1)
         FEXT=LINE(i2:IL)   
      else
         FEXT=' '
      endif

C// get FPATH
      if (i1.gt.0) then
         IL=i1
         IL=MIN(IL,LEN(FPATH))
         FPATH=LINE(1:IL)   
      else
         FPATH=' '
      endif
      
C// get FNAME
      IF (i2.LE.0) i2=L+1
      IL=i2-i1-1 
      IF (IL.GT.0) THEN      
         IL=MIN(IL,LEN(FNAME))     
         FNAME=LINE(i1+1:i1+IL)
      ELSE
         FNAME=' '
      ENDIF

      
      END
    
C-----------------------------------------------------------------
      SUBROUTINE FLOAT2STR(Z,STR)
C Converts real number into a string with as short format as possible 
C path includes terminal delimiter, extension includes initial dot  
C INPUT:
C Z     ... real*8 number
C OUTPUT:
C STR   ... output string
C-----------------------------------------------------------------
      IMPLICIT NONE
      REAL*8 Z
      CHARACTER*(*) STR
      CHARACTER*64 S
      INTEGER*4 IS,IL
      
      
1     format(G10.4)
2     format(I6)
3     format(F9.3)
      
      IF (Z.LT.0.001.OR.Z.GE.10000) THEN
        WRITE(S,1) Z      
      ELSE IF (1.D0*NINT(Z).EQ.Z) THEN
        WRITE(S,2) NINT(Z)      
      ELSE
        WRITE(S,3) Z     
      ENDIF
      CALL BOUNDS(S,IS,IL)
      
C// strip unsignificant zeros off
      IF (INDEX(S,'.').GT.0.AND.INDEX(S,'E').LE.0) THEN
        DO WHILE (S(IS+IL-1:IS+IL-1).EQ.'0')
c          write(*,*) S(IS+IL-1:IS+IL-1)
          IL=IL-1
        ENDDO
        IF (S(IS+IL-1:IS+IL-1).EQ.'.') IL=IL-1
      ENDIF
      STR=S(IS:IS+IL-1)
      END  
    
    
C-----------------------------------------------------------------
      SUBROUTINE LASTSUBSTR(STR,SUBSTR,IPOS)
C Find last occurence of the SUBSTR in STR
C Return position in IPOS (=0 if not found) 
C path includes terminal delimiter, extension includes initial dot  
C-----------------------------------------------------------------
      IMPLICIT NONE
      INTEGER*4 IPOS
      CHARACTER*(*) STR,SUBSTR
      INTEGER*4 IS,LS,ISS,LSS,LL,I
      
      CALL BOUNDS(STR,IS,LS)
      LL=IS+LS-1
      CALL BOUNDS(SUBSTR,ISS,LSS)
      I=1
      IPOS=0
      IF (LS.GT.0.AND.LSS.GT.0.AND.I.GT.0.AND.IS.LE.LL) THEN
        I=INDEX(STR(IS:LL),SUBSTR(ISS:ISS+LSS-1))
        IF (I.GT.0) THEN
          IPOS=IS+I-1
          IS=IPOS+LSS
        ENDIF
      ENDIF
      END
      
      
          
