! *******  STRUCTURES FOR RESTRAX   *********************

      INCLUDE 'ness_com.inc'

      INTEGER*4 SLIT_SIZE
      STRUCTURE  /SLIT/
	  CHARACTER*32  NAME
	  REAL*8 DIST,AXI,AXV
	  REAL*8 SIZE(3),STA(3),GON(3)
	  REAL*8 POS(3),ROT(3,3),ROT1(3,3)
	  LOGICAL*4 MAP(3),MAP1(3),SIMPLE
	  INTEGER*4 COUNT  
	  INTEGER*4 SHAPE
          INTEGER*4 NDUM ! dummy integer for data alignment
      END STRUCTURE    
      PARAMETER (SLIT_SIZE=336)

      INTEGER*4 BENDER_SIZE
      STRUCTURE  /BENDER/
	   RECORD /SLIT/ FRAME
           REAL*8 W2,H2           ! width & height at the exit
           REAL*8 GHLU,GHLD,GHRU,GHRD,GVT,GVB  ! horizontal & vertical (H&V) critical angles
           REAL*8 RHLU,RHLD,RHRU,RHRD,RVT,RVB  ! horizontal& vertical reflectivities
           REAL*8 DLH,DLV         ! thickness of H&V lamellae
           REAL*8 CURV            ! horizontal curvature            
           REAL*8 BINT ! integral Int(B)dz in [T*m]
           INTEGER*4 NLH,NLV      ! number of slits (H&V)
           INTEGER*4 TYP          ! 0.. normal, 1 .. curved , 2.. reflecting surfaces 
           INTEGER*4 NHLU,NHLD,NHRU,NHRD,NVT,NVB ! indexes pointing to the fieald containg reflectivity data
           INTEGER*4 NDUM ! dummy integer for data alignment
      END STRUCTURE    
      PARAMETER(BENDER_SIZE=SLIT_SIZE+184)   ! 520

      INTEGER*4 SOLER_SIZE
      STRUCTURE  /SOLLER/
	   RECORD /SLIT/ FRAME
           REAL*8 W2,H2
           INTEGER*4 NL
           INTEGER*4  VERTICAL
      END STRUCTURE   
      PARAMETER (SOLER_SIZE=SLIT_SIZE+24)  ! 360

      INTEGER*4 CRYST_SIZE
      STRUCTURE  /CRYSTAL/
           RECORD /SLIT/ FRAME
           REAL*8 DHKL,CHI,RH,RV,RB,POI,HMOS,VMOS,VOL,FHKL,MI,MAG
           REAL*8 THB,LAMBDA,STMCH,CTMCH,QHKL,DEXT,REF,DETA,TANVOL
           REAL*8 DG_DR(3,3),G(3),GAMA(3),GTOT
           LOGICAL*4 MAPG(3)
           INTEGER*4 DNRND,NH,NV,NB,TYP   
      END STRUCTURE       
      PARAMETER (CRYST_SIZE=SLIT_SIZE+328)  ! 664

!// added TAUF (Fourier time for TASSE mode in [ns])
      INTEGER*4 SETUP_SIZE
      STRUCTURE /SETUP/
         INTEGER*4 NFX,SM,SS,SA
         REAL*8 KFIX,E,Q,KI,KF,TAUF
      END STRUCTURE            
      PARAMETER (SETUP_SIZE=64)

      STRUCTURE  /RANDFIELD/
         REAL*8 MEAN(CRND),LIMITS(CRND),POOL(CRND)
         INTEGER*4  ACTIVE(CRND),DIM
      END STRUCTURE     

      STRUCTURE /STATI/
         REAL*8 SUM2(CRND,CRND),C(CRND,CRND),SUM1(CRND)
         REAL*8 M(CRND),DM(CRND),SUMN,P
         INTEGER*4 NC
      END STRUCTURE      

