#----------------------------------------------------
# System dependent part of makefile for RESTRAX 
# Absoft Fortran on Linux, ver. 9.0 
#----------------------------------------------------

# command calling Fortran compler 
FC= f90

# Fortran options:
FCFLAGS= -O2 -s -safefp -B108 -YEXT_NAMES=LCS -YCOM_NAMES=LCS -YCFRL=1 -YCOM_SFX=_ -YCOM_PFX=

# command calling C compler 
CC= gcc

# C options:
CCFLAGS= -O  

# other libraries to link with RESTRAX:
# restrax_LDADD= -L/usr/absoft/lib -lV77 -lU77  -L/usr/X11R6/lib -lX11 -lm -lg2c
restrax_LDADD= -lU77 -lf77math -L/usr/X11R6/lib -lX11 -ldl 

# Command for linking RESTRAX
restrax_LD= $(FC) -X--unresolved-symbols=report-all 

#  -X--cref -X-Map -Xmap.txt -lf77math -lf90math -lfio 

# option passed to the linker
restrax_LDFLAGS=  -X --export-dynamic  

# Compiler for EXCI library
exci_FC= $(FC)

# Compiler options for compiling EXCI subroutine
# EXCFLG= -O -f -B108 -N22 -N34  
exci_FCFLAGS= $(FCFLAGS) -fpic

# Command for linking shared library
exci_LD= $(FC) -X-shared 

# option passed to the linker
exci_LDFLAGS=  

# Define additional system-dependent object files to be linked with RESTRAX
# define file names including object extensions (*.o) 
# they will be created using implicit rules defined in the makefile
src_SYSDEP= 
