
C***********************************************************************
        BLOCK DATA
C***********************************************************************
      IMPLICIT NONE
      INCLUDE 'const.inc'
      INCLUDE 'inout.inc'
      INCLUDE 'rescal.inc'
      INCLUDE 'config.inc'
      INCLUDE 'structures.inc'
      INCLUDE 'ness_common.inc'
      INCLUDE 'randvars.inc'
      INCLUDE 'source.inc'
      
      INTEGER*4 IREST
      PARAMETER (IREST=MRES-RES_NVAR-RES_NCMD) 
             
      DATA DEVSTR/'/xserv  '/
      DATA ISEED,IRND /0,0/
      
      DATA DATPATH,RESPATH,CFGPATH
     *  / 3*' '/
      
      DATA DATNAME,CFGNAME,RESCAL_NAME,RESCAL_DEFNAME
     *  / ' ','simres00.cfg','default.res','default.res'/
     
      DATA SINP,SOUT,SMES /5,6,6/
      DATA PATHDEL /'/'/
      DATA CUNIT /'meV'/
      DATA SILENT/1/


C// names of variables and commands
      DATA RES_NAM/
C// RESCAL parameters (extended)
     &  'DM','DA','ETAM','ETAA','ETAS','SM','SS','SA','KFIX','FX',
     &  'ALF1','ALF2','ALF3','ALF4','BET1','BET2','BET3','BET4',
     &  'AS','BS','CS','AA','BB','CC','AX','AY','AZ','BX','BY','BZ',
     &  'QH','QK','QL','EN','DH','DK','DL','DE','DA3','DA4','GH','GK',
     &  'GL','GMOD','ROMH','ROMV','ROAH','ROAV','SDI','SHI',
C// I/O commands
     &  'SAVE','EXIT','EXFF','BAT','CFG','FILE','CRYST','GRFDE',
     &  'PLOT','PRINT','SETUP','SVOL','LPROF','DPROF','TPROF','MPROF',
C// Special settings  
     &  'RO','MRO','MONO','ANAL','THETA','POLAR','FLIP','MAG',
     &  'SPIN','FLX','TEMP','SRCX','SRCY','OSC','SPOS','EMOD','AMOD',   
C// Execution commands     
     &  'FLUX','NFLUX','MONIT','ROCK','AROCK','PWD','PWDS','TAS',
     &  'BENCH','SCHI','SCAN','SHELL',
     &  IREST*' '/

       
C// hints to commands 
       DATA RES_HLP / RES_NVAR*' ',
     2'saves parameters in the current *.res file', ! SAVE 
     4'exit with warning if data file not saved', ! EXIT
     5'exit without warning', ! EXFF 
     5'[jobname] execute a batch file', ! BAT 
     6'set new configuration file name', ! CFG 
     7'load data file or RESCAL parameter file             ', ! FILE
     8'n ... set monoch. (1) or anal. (2) names from "crystal.lib"', ! CRYST
     1'set output device name for PGPLOT                   ', ! GRFDEV
     2'plot 2D beam image at the monitor in given projection    ', ! PLOT
     3'repeat last plot and send it to printer           ', ! PRINT
     4'[n] print the parameters of the n-th component     ', ! SETUP
     9'plot 2D image of sample gauge volume              ', ! SVOL
     *'plot lambda distribution across the sample     ', ! LPROF
     1'plot beam profile along the detector           ', ! DPROF
     1'plot powder peak profile                       ', ! TPROF
     1'plot multidetector scan                            ', ! MPROF
     5'[n n n n ] sets "optimal" crystal curvatures, analytical', ! RO
     5'n [nev] num. opt. of the n-th curvature, Monte Carlo', ! MRO
     *'[dgrad angle dlam] set optional  parameters, monochromator', ! MONO
     *'[dgrad angle dlam] set optional  parameters, analyzer', ! ANAL
     4'am aa ... set rocking angles [min] for monoch. and analyzer', ! THETA
     4'(unsupported )', ! POLAR
     4'(unsupported )', ! FLIP
     4'(unsupported )', ! MAG
     4'(unsupported )', ! SPIN
     6'Integral flux [1E+14 n/s/cm2] at the channel nose ', ! FLX  
     6'Temperature of the moderator [K] ', ! TEMP
     6'[A B X0] source inhomogeneity along x, A(X-X0)+B(X-X0)^2', ! SRCX
     6'[A B Y0] source inhomogeneity along y, A(Y-Y0)+B(Y-Y0)^2', ! SRCY
     7'[n n n n] switch the oscilation of collimators on/off ', ! OSC
     8'x y z ... changes sample position, x//ki, z is vertical ', ! SPOS
     6'[0|1] - turn off|on E=const. mode                        ', ! EMOD
     6'[0|1] - turn off|on analyzer flat-cone mode              ', ! AMOD
     6'[n] flux at the sample (1) or detector (2), powder sample ', ! FLUX
     8'as FLUX, but traces sample->source (usually faster) ', ! NFLUX
     9'n ... run simulation from source -> monitor n  ', ! MONIT
     4'[nev np dth] simulate rocking curve of the monochromator  ', ! ROCK
     4'[nev np dth] simulate rocking curve of the analyzer       ', ! AROCK
     8'R(Q), diffraction resolution funciton               ', ! PWD 
     8'scan a powder peak by multidetector with step DA4   ', ! PWDS
     8'R(Q,E), TAS resolution funciton                     ', ! TAS
     2'[n] benchmark for n*1000 events (performance of components)', ! BENCH
     2'(unsupported )', ! SCHI
     8'np [nev mon bcg]  TAS scan simulation with bcg and errors ', ! SCAN
     5'executes a single shell command ', ! SHELL
     3 IREST*' '/  

     
      DATA HLPOPT/
Cxxxxxccccccccccccccccccccccccccccccccccccccccccccccccccccccccccccxxx
     1'RESTRAX options:                                              ',
     2'                                                              ',
     2'-d        debug mode (no sampling optimization)               ',
     3'-sx       randomize with x, Example: -s10001                  ',
     4'-tx       test random generator with dim=x, e.g. -t5          ', 
     5'-flxfile  read flux distribution dPhi/dLambda from file       ',
     6'            Example: -flxdist.dat                             ',
     7'-flhx     set horizontal source divergence limit to x [deg]   ',
     8'            Example: -flh1.5                                  ',
     9'-flvx     set vertical source divergence limit to x [deg]     ',
     *'            Example: -flv2.3                                  ',
     1'-Voigt    use pseudo-Voigt mosaic distribution                ',
     2'-ran1     use Numerical Recipes RAN1 generator                ',
     3'-rand     use system random number generator (RAN)            ',
     3'-noopt    no automatic sampling optimization                  ',
     3'-nmon     weight by monitor efficiency ~ 1/ki                 ',
     3'-help     show this help                                      ',
     4'                                                              '/


      DATA SPINT /0/      
      DATA SFLUX,STEMP /1.0,310./ 
      DATA FLXH,FLXV,FLXN / 0, 0, 0/
c dPhi/dLambda is in [1e12/s/cm^2/Ang]      
      
C default RESCAL parameters
      DATA RES_DEF/
     & 3.3480  ,  ! DM,DA
     & 3.3480  ,
     & 20.000  ,  ! ETAM..ETAS
     & 20.000  ,
     & 0.0  ,
     & 1.0  ,     ! SM .. SA
     & -1.0  ,    
     & 1.0  ,
     & 1.5500  ,  ! KFIX,FX
     & 2.0  ,
     & 0.0  ,     ! ALF1..4
     & 40.000  ,  
     & 500.00  ,
     & 500.00  ,
     & 0.0  ,     ! BET1..4
     & 500.00  ,
     & 500.00  ,
     & 500.00  ,
     & 6.2832  ,  ! AS..CS
     & 6.2832  ,
     & 6.2832  ,
     & 90.000  ,  ! AA..CC
     & 90.000  ,
     & 90.000  ,
     & -1.0  ,    ! AX..BZ
     & -1.0  ,
     & 0.0  ,
     & 0.0  ,
     & 0.0  ,
     & -1.0  ,
     &  0.0  ,    ! QH..EN
     & 0.0  ,
     & 1.0  ,
     & 0.0  ,
     & 0.0  ,     ! DQH..DEN
     & 0.0  ,
     & 0.0  ,
     & 1.0  ,
     & 0.0  ,     ! DA3..DA4 (=DTH)
     & 0.0  ,
     & 0.0  ,     ! GH..GMOD
     & 0.0  ,
     & 1.0  ,
     & 0.0  ,
     & 0.0  ,     ! ROMH..ROAV
     & 0.305895835161209  ,
     & 0.0  ,
     & 0.0  ,
     & 1.0  ,     ! SDI,SHI
     & 1.0  /
            
      END  
