C//////////////////////////////////////////////////////////////////////
C////                                                              ////
C////  NEutron Scattering Simulation - v.1.2, (c) J.Saroun, 1997   ////
C////   update May 1998 (J.S.)                                     ////
C//////////////////////////////////////////////////////////////////////
C////
C////  Subroutines specific to 3-axis spectrometers and conversion
C////  from the RESTRAX-parameter set.
C////
C////  * SUBROUTINE SET_3AX(ICOM)
C////  * LOGICAL*4 FUNCTION SPEC_GO(ICOM)
C////  * SUBROUTINE SPEC_INI(ICLR,IRES)
C////  * SUBROUTINE NESS_CONV
C////  * SUBROUTINE CREATE_SOL(SOL1,ALPHA,NFM,VLSM,VLCANM,HDM1,HDM2,
C////                          VDM1,VDM2)
C////  * SUBROUTINE WRITE_SETUP(IC)
C////
C////  May 1998:         SOLLERs replaced by BENDERs in all subroutines and commons
C////                  SET_3AX(2) sets values of critical angles for BENDERs
C////              SET_3AX(3) sets values of BENDERs radii
C////              SET_3AX(4) switch on/off spin flippers
C////              SET_3AX(5) switch on/off magnetization of crystals
C//////////////////////////////////////////////////////////////////////
C***  bug fixed:  GUIDE=2*GAMACR   replaced by GUIDE=GAMACR*MON.LAMBDA
C***  (25/5/98 by J.S.)


C----------------------------------------------------------------
      SUBROUTINE SET_3AX(ICOM)
C     changes sample position (with a possibility to add
C     other parameters not included in RESTRAX3 parameter set.
C     Can be called by the RESTRAX main program as well as by
C     the NESS interactive command interpreter (NESS_LOOP)
C----------------------------------------------------------------
      IMPLICIT NONE
      INCLUDE 'const.inc'
      INCLUDE 'inout.inc'
      INCLUDE 'structures.inc'
      INCLUDE 'ness_common.inc'
      INCLUDE 'collimators.inc'
      INCLUDE 'source.inc'
      INCLUDE 'rescal.inc'
c      INCLUDE 'trax.inc'

      INTEGER*4 ICOM,NPAR,NDPAR
      PARAMETER(NDPAR=16)
      REAL*4   PARAM(NDPAR)
      INTEGER*4 I,I1,I2
      CHARACTER*4 S1,S2
 


c      WRITE(*,*) 'SET_3AX: ',ICOM,NOS
      IF(NOS.GT.0.AND.NOS.LE.NDPAR) THEN
          DO i=1,NOS
             PARAM(I)=RET(I)
          END DO
      ENDIF
      NPAR=NOS
c      WRITE(*,*) 'SET_3AX: ',ICOM,NPAR,(PARAM(I),I=1,NPAR)


      IF(ICOM.EQ.1) THEN
1       FORMAT(' sample position [mm]:             ',3(2x,F7.2))
        IF(NPAR.GE.2) SAM.STA(1)=PARAM(2)
        IF(NPAR.GE.3) SAM.STA(2)=PARAM(3)
        IF(NPAR.GE.1) SAM.STA(3)=PARAM(1)
        PARAM(2)=SAM.STA(1)
        PARAM(3)=SAM.STA(2)
        PARAM(1)=SAM.STA(3)
        WRITE(SOUT,1) (PARAM(I),I=1,3)
      ENDIF

      IF(ICOM.EQ.3) THEN
3       FORMAT(' crystal rocking angles [min]:     ',2(2x,F10.4))
c        WRITE(SOUT,*) 'Command not available'
c       RETURN
        IF(NPAR.GE.1) DTHAX(1)=PARAM(1)
        IF(NPAR.GE.2)  DTHAX(5)=PARAM(2)
        PARAM(1)= DTHAX(1)
        PARAM(2)= DTHAX(5)
        WRITE(SOUT,3) (PARAM(I),I=1,2)
      ENDIF

      IF(ICOM.EQ.4) THEN
4       FORMAT(' Spin flippers :  ',2(3x,a4))
        IF(NPAR.GE.1) FLIPM=NINT(PARAM(1))
        IF(NPAR.GE.2) FLIPA=NINT(PARAM(2))
        PARAM(1)=FLIPM
        PARAM(2)=FLIPA
        S1='off '
        S2='off '
        if (FLIPM.GT.0) S1='on  '
        if (FLIPA.GT.0) S2='on  '
        WRITE(SOUT,4) S1,S2
      ENDIF

      IF(ICOM.EQ.5) THEN
5       FORMAT(' Magnetization :  ',2(3x,a4))
        IF(NPAR.GE.1) MON.MAG=PARAM(1)
        IF(NPAR.GE.2) ANA.MAG=PARAM(2)
        PARAM(1)=MON.MAG
        PARAM(2)=ANA.MAG
        S1='off '
        S2='off '
        if (MON.MAG.GT.0) S1='on  '
        if (ANA.MAG.GT.0) S2='on  '
        WRITE(SOUT,5) S1,S2
      ENDIF

      IF(ICOM.EQ.6) THEN
6       FORMAT(' Spin transfer :  ',a4,' -> ',a4)
61      FORMAT(' Spin transfer :   all')
        I1=MOD(NINT(SPINT),2)
        I2=INT(SPINT/2)
        IF(NPAR.GE.1) I1=NINT(PARAM(1))
        IF(NPAR.GE.2) I2=NINT(PARAM(2))
        IF((I1.EQ.0.OR.I1.EQ.1).AND.(I2.EQ.0.OR.I2.EQ.1)) THEN
           S1='up  '
           S2='up  '
           if (I1.EQ.0) S1='down'
           if (I2.EQ.0) S2='down'
           WRITE(SOUT,6) S1,S2
           SPINT=I1+2*I2
         ELSE
           SPINT=-1
           WRITE(SOUT,61)
        ENDIF
      ENDIF
      IF(ICOM.EQ.7) THEN
7       FORMAT(' POLARIZING BENDERS:   ',4(2x,I1))
        IF(NPAR.GE.1) POLAR(3)=PARAM(1)
        IF(NPAR.GE.2) POLAR(5)=PARAM(2)
        IF(NPAR.GE.3) POLAR(6)=PARAM(3)
        IF(NPAR.GE.4) POLAR(7)=PARAM(4)
        DO I=1,4
           PARAM(I)=0
        ENDDO
        IF (POLAR(3).NE.0) PARAM(1)=1
        IF (POLAR(5).NE.0) PARAM(2)=1
        IF (POLAR(6).NE.0) PARAM(3)=1
        IF (POLAR(7).NE.0) PARAM(4)=1
        WRITE(SOUT,7) (NINT(PARAM(I)),I=1,4)
      ENDIF

      IF(ICOM.EQ.8) THEN

81       FORMAT(' Crystal name: ',$)
82       FORMAT(a8)
        IF (NPAR.GT.0.AND.(PARAM(1).EQ.1).OR.(PARAM(1).EQ.2)) THEN
          IF (PARAM(1).EQ.1) THEN        
              WRITE(SOUT,81)
            READ(SINP,82)  MON.FRAME.NAME
          ELSE IF  (PARAM(1).EQ.2) THEN
              WRITE(SOUT,81)
            READ(SINP,82)  ANA.FRAME.NAME
          ENDIF
        ENDIF
        CALL SET_CRYST(MON.FRAME.NAME(1:8),ANA.FRAME.NAME(1:8))
      ENDIF        

      IF(ICOM.EQ.9) THEN
9       FORMAT(' Oscilating colimators:   ',4(2x,I1))
        IF(NPAR.GE.1) OSC(3)=(PARAM(1).NE.0)
        IF(NPAR.GE.2) OSC(5)=(PARAM(2).NE.0)
        IF(NPAR.GE.3) OSC(6)=(PARAM(3).NE.0)
        IF(NPAR.GE.4) OSC(7)=(PARAM(4).NE.0)
        DO I=1,4
           PARAM(I)=0
        ENDDO
        IF (OSC(3)) PARAM(1)=1
        IF (OSC(5)) PARAM(2)=1
        IF (OSC(6)) PARAM(3)=1
        IF (OSC(7)) PARAM(4)=1
        WRITE(SOUT,9) (NINT(PARAM(I)),I=1,4)
      ENDIF

      IF(ICOM.EQ.2) THEN
2       FORMAT('monochromator: '/,
     *         ' d-gradient  [0.001/cm]: ',G13.5,/,
     *         ' grad. angle  [deg]    : ',G13.5,/,
     *         ' lamella thickness [um]: ',G13.5)
        IF(NPAR.GE.1) MON.DGR=PARAM(1)
        IF(NPAR.GE.2) MON.DGA=PARAM(2)*PI/180
        IF(NPAR.GE.3) MON.DLAM=PARAM(3)
        WRITE(SOUT,2) MON.DGR,MON.DGA/PI*180,MON.DLAM
      ENDIF
      IF(ICOM.EQ.21) THEN
21       FORMAT('analyzer: '/,
     *          ' d-gradient  [0.001/cm]: ',G13.5,/,
     *          ' grad. angle  [deg]    : ',G13.5,/,
     *          ' lamella thickness [um]: ',G13.5)
        IF(NPAR.GE.1) ANA.DGR=PARAM(1)
        IF(NPAR.GE.2) ANA.DGA=PARAM(2)*PI/180
        IF(NPAR.GE.3) ANA.DLAM=PARAM(3)
        WRITE(SOUT,21) ANA.DGR,ANA.DGA/PI*180,ANA.DLAM
      ENDIF

      IF(ICOM.EQ.10) THEN
10      FORMAT(' dI/dx   [%/cm] : ',G13.5,/,
     *         ' d2I/dx2 [%/cm2]: ',G13.5,/,
     *         ' centre  [cm]   : ',G13.5)
        IF(NPAR.GE.1) FLXA=PARAM(1)/1000
        IF(NPAR.GE.2) FLXB=PARAM(2)/10000
        IF(NPAR.GE.3) FLX0=PARAM(3)*10
        WRITE(SOUT,10) FLXA*1000,FLXB*10000,FLX0/10
      ENDIF
      IF(ICOM.EQ.11) THEN
11      FORMAT(' dI/dy   [%/cm] : ',G13.5,/,
     *         ' d2I/dy2 [%/cm2]: ',G13.5,/,
     *         ' centre  [cm]   : ',G13.5)
        IF(NPAR.GE.1) FLYA=PARAM(1)/1000
        IF(NPAR.GE.2) FLYB=PARAM(2)/10000
        IF(NPAR.GE.3) FLY0=PARAM(3)*10
        WRITE(SOUT,10) FLYA*1000,FLYB*10000,FLY0/10
      ENDIF

      IF(ICOM.EQ.12) THEN
120       FORMAT(' Analyzer part is in normal position')
121      FORMAT(' Analyzer part is turned up')
122      FORMAT(' Analyzer part is turned down')
123      FORMAT(' Analyzer part is turned up/down')
        IF(NPAR.GE.1) THEN
           IF (PARAM(1).EQ.1) THEN
               CFGMODE=1
           ELSE
               CFGMODE=0
           ENDIF
        ENDIF
        IF (CFGMODE.EQ.0) WRITE(SOUT, 120)
        IF (CFGMODE.EQ.1.AND.RES_DAT(i_SA).GT.0) WRITE(SOUT,121) 
        IF (CFGMODE.EQ.1.AND.RES_DAT(i_SA).LT.0) WRITE(SOUT,122)
        IF (CFGMODE.EQ.1.AND.RES_DAT(i_SA).EQ.0) WRITE(SOUT,123)         
      ENDIF
      
      IF(ICOM.EQ.13) THEN
130      FORMAT(' Normal mode')
131       FORMAT(' Simulation in E=const. plane')
        IF (EMODE.NE.0) EMODE=1
        IF(NPAR.GE.1) THEN
           IF (PARAM(1).EQ.1) THEN
               EMODE=1
           ELSE
               EMODE=0
           ENDIF
        ENDIF
        IF (EMODE.EQ.0) WRITE(SOUT, 130)
        IF (EMODE.EQ.1) WRITE(SOUT,131) 
      ENDIF
      
      DO i=1,NOS
         RET(I)=PARAM(I)
      END DO
      NOS=0


      RETURN
      END
C---------------------------------------------------------------
      SUBROUTINE SET_CRYST(NAMEM,NAMEA)
C---------------------------------------------------------------
      IMPLICIT NONE
      INCLUDE 'inout.inc'
      INCLUDE 'structures.inc'
      INCLUDE 'ness_common.inc'
      INCLUDE 'rescal.inc'
      
      CHARACTER*8 NAMEM,NAMEA

83    FORMAT(' Monochromator: ',A8,'   Analyzer: ',A8)

      IF(NAMEM(1:1).NE.' ') MON.FRAME.NAME=NAMEM        
      IF(NAMEA(1:1).NE.' ') ANA.FRAME.NAME=NAMEA
      IF(NAMEM(1:1).NE.' '.OR.NAMEA(1:1).NE.' ') then
        WRITE(SOUT,83) MON.FRAME.NAME(1:8), ANA.FRAME.NAME(1:8)
      ENDIF        
        CALL READCRYST(MON,MON.FRAME.NAME(1:8))
        CALL READCRYST(ANA,ANA.FRAME.NAME(1:8))
        IF(MON.VOL.NE.0) RES_DAT(i_DM)=MON.DHKL
        IF(ANA.VOL.NE.0) RES_DAT(i_DA)=ANA.DHKL
      END

C----------------------------------------
      LOGICAL*4 FUNCTION CHECKPARAM()
C-----------------------------------------
      IMPLICIT NONE
      INCLUDE 'const.inc'
      INCLUDE 'inout.inc'
      INCLUDE 'rescal.inc'

      REAL*8 L1,L2,KFIX,FX,EN
      LOGICAL*4 LOG
      
      KFIX=RES_DAT(i_KFIX)
      FX=RES_DAT(i_FX)
      EN=RES_DAT(i_EN)
      
      LOG=.TRUE.
      IF (FX.EQ.1.) THEN
         L1=2.*PI/KFIX
         IF(KFIX**2-EN/HSQOV2M.GT.0.D0) THEN
           L2=2.*PI/SQRT(KFIX**2-EN/HSQOV2M)
         ELSE
           LOG=.FALSE.
           write(smes,*) 'Energy transfer too large'
           write(smes,*) 'KI=',KFIX,' E/hsqov2m=',EN/HSQOV2M
           goto 100         
         ENDIF
      ELSE
         L2=2.*PI/KFIX
         IF(KFIX**2+EN/HSQOV2M.GT.0.D0) THEN
           L1=2.*PI/SQRT(KFIX**2+EN/HSQOV2M)
         ELSE
           LOG=.FALSE.
           write(smes,*) 'Energy transfer too large'
           write(smes,*) 'KF=',KFIX,' E/hsqov2m=',EN/HSQOV2M
           goto 100         
         ENDIF
      ENDIF

      IF (L1.GE.2.*RES_DAT(i_DM)) THEN 
         write(smes,*) 'monochromator dhkl too large!'
         write(smes,*) 'lambda=',L1,' 2d=',2.*RES_DAT(i_DM)
         LOG=.FALSE.
         GOTO 100
      ENDIF
      IF (L2.GE.2.*RES_DAT(i_DA)) THEN 
         write(smes,*) 'analyzer dhkl too large!'
         write(smes,*) 'lambda=',L2,' 2d=',2.*RES_DAT(i_DA)
         LOG=.FALSE.
         GOTO 100
      ENDIF

      
100   CHECKPARAM=LOG      
      END 
      


C---------------------------------------------------------------
      SUBROUTINE LOG_EVENT(NEU)
C---------------------------------------------------------------
      IMPLICIT NONE
      INCLUDE 'structures.inc'
      RECORD /NEUTRON/ NEU
      END

C--------------------------------------------------------
      SUBROUTINE SPEC_INI(ICLR,ITASK)
C     Clears all necessary variables and, if ICLR<>1,
C     initializes objects and limits of random variables
C    
C  ITASK=1 ... inelastic scattering, TAS resolution
C  ITASK=2 ... sample -> source
C  ITASK=3 ... source -> sample
C  ITASK=4 ... sample -> source + sample(powder) -> detector (no analyser)
C  ITASK=5 ... source -> sample + sample(powder) -> detector (no analyser)
C  ITASK=6 ... sample -> source + sample (Vanad) -> monitor(IMONIT)
C  ITASK=7 ... source -> monitor(IMONIT)
C  ITASK=8 ... inelastic scattering, TAS resolution, splitted TAS1 and TAS2 
C  ITASK=9 ... elastic (powder) resolution function
C  ITASK=10 ... powder (ITASK=4), splitted TAS1 and TAS2  
C  ITASK=11 ... source -> detector, Bragg scattering (or double-crystal for Q=0)
C--------------------------------------------------------
      implicit NONE

      INCLUDE 'const.inc'
      INCLUDE 'inout.inc'
      INCLUDE 'structures.inc'
      INCLUDE 'ness_common.inc'
      INCLUDE 'rescal.inc'
      INCLUDE 'randvars.inc'

      INTEGER*4 i,j,ICLR,ITASK
      REAL*8 a1,a2,a3,ahmin,avmin,ctm,ah2,av2,c2ts
      REAL*8 lms,lsa,cta,z,z1,sgnm,sgna,stmch,stach
      REAL*8 B89
      REAL*8 WMAX,HMAX,BAND
c      REAL*8 AUX(CRND,CRND),DETERM
      RECORD /STATI/ COV_QE
 
      INTEGER*4 IERR,NEV

      COMMON /ERRORS/ IERR
      COMMON /RESULT/ COV_QE
      LOGICAL*4 VERBOSE
      COMMON /MCSETTING/ VERBOSE,NEV
      REAL*8 GETEFFMOS,THM

 
c      write(*,*) 'SPEC_INI(ICLR,ITASK)',ICLR,ITASK

      CALL STAT_CLR(4,COV_QE)

      SOU.COUNT=0
      GDEa.FRAME.COUNT=0
      GUIDE.FRAME.COUNT=0
      SOL1.FRAME.COUNT=0
      MON.FRAME.COUNT=0
      SOL2.FRAME.COUNT=0
      SOL2a.FRAME.COUNT=0
      SAM.COUNT=0
      SOL3.FRAME.COUNT=0
      ANA.FRAME.COUNT=0
      SOL4.FRAME.COUNT=0
      DET.FRAME.COUNT=0

      IF (ICLR.EQ.1) THEN
         RETURN
      ENDIF

C// Reconfigure setup in special cases:
C// Powder diffractometer -> skip analyzer and SOL4 
      IF (ITASK.EQ.4.OR.ITASK.EQ.5.OR.ITASK.EQ.9) 
     *    DET.FRAME.DIST=ANA.FRAME.DIST+SOL4.FRAME.DIST+DET.FRAME.DIST

C// set number of random values            
      IF(ITASK.EQ.1.OR.ITASK.EQ.8) THEN
         RNDLIST.DIM=9
         IF (EMODE.EQ.1) RNDLIST.DIM=8
      ENDIF   
      IF(ITASK.EQ.2.OR.ITASK.EQ.3.OR.ITASK.EQ.11) RNDLIST.DIM=6
      IF(ITASK.EQ.4.OR.ITASK.EQ.5) RNDLIST.DIM=7
      IF(ITASK.EQ.6.OR.ITASK.EQ.7.OR.ITASK.EQ.9) RNDLIST.DIM=8
      IF(ITASK.EQ.7.AND.IMONIT.LE.7) RNDLIST.DIM=6
      
      DO 30 I=1,RNDLIST.DIM
          RNDLIST.MEAN(I)=0.D0
          RNDLIST.POOL(I)=1.1D0
          RNDLIST.ACTIVE(I)=1
30    CONTINUE

C// set time variable inactive
      RNDLIST.ACTIVE(6)=0
      RNDLIST.LIMITS(6)=1.D0
      RNDLIST.POOL(6)=1D0

C// initialize transformation matrix
      DO 80 I=1,CRND
      DO 80 J=1,CRND
         IF (I.NE.J) THEN
            TMAT(I,J)=0.D0
         ELSE
            TMAT(I,J)=1.D0
         ENDIF
80    CONTINUE
      DO I=1,RNDLIST.DIM
            TMEAN(I)=0.D0
      ENDDO
      
C// Set mean ki value
      sgnm=-sign(1,stp.sm) ! "minus" because of the up-stream tracing
      THM=ABS(MON.FRAME.GON(1)-sgnm*PI/2.+MON.CHI)
      TMEAN(3)=PI/MON.DHKL/SIN(THM)
        
C ******************************************************
C                                                      *
C                  PRIMARY SPECTROMETER                *
C                                                      *
C ******************************************************

C// Call another initialization procedure for the simulation started 
C// from the source
      IF(ITASK.EQ.3.OR.ITASK.EQ.5.OR.ITASK.EQ.7.OR.FTAS.GT.0) THEN
         CALL FORW_INI(ITASK)         
      ELSE
      
C// Initialize components 
      CALL SLIT_INIT(SOU)
      CALL BENDER_INIT(GDEa)
      CALL BENDER_INIT(GUIDE)
      CALL BENDER_INIT(SOL1)
      CALL CRYST_INIT2(MON)
      CALL BENDER_INIT(SOL2)
      CALL BENDER_INIT(SOL2a)
      CALL SLIT_INIT(SAM)
      
C// calculate maximum angular deviations for the secondary spectrometer
c      CALL APERTURE1(ITASK,ahmin,avmin)
      CALL APERTURE1(ITASK,ahmin,avmin,wmax,hmax,band)

1     FORMAT(a,5(2x,G12.6))      
c      write(*,*) 'APERTURE1 ',ahmin,avmin,wmax,hmax,band

      lms=sol2.frame.dist+sol2a.frame.dist+mon.frame.dist
      ctm=sgnm/tan(THM)
      stmch=SIN(THM-sgnm*MON.CHI) 
      

C// common constraints for simulation started at the sample
      IF(MON.NH.GT.1.OR.MON.HMOS.LE.SEC) THEN 
        Z=1.D0 
      ELSE
        Z=0.D0
      ENDIF  
      RNDLIST.LIMITS(1)=ahmin*RNDLIST.POOL(1)
      RNDLIST.LIMITS(2)=avmin*RNDLIST.POOL(2)
c get contributions to Bragg angle spread 
c          a1=4*mon.hmos ! mosaicity
c          a2=GETEFFMOS(MON) 
c          a3=0.5*tan(mon.thb)*(avmin/2)**2 ! vertical divergence
c      RNDLIST.LIMITS(3)=SQRT(a1**2+a2**2+a3**2)*stp.ki*abs(ctm)*
c     *                  RNDLIST.POOL(3) 
c      RNDLIST.LIMITS(4)=sam.size(1)*RNDLIST.POOL(4)
c      RNDLIST.LIMITS(5)=sam.size(2)*RNDLIST.POOL(5)        
      RNDLIST.LIMITS(3)=band*stp.ki*abs(ctm)* RNDLIST.POOL(3) 
      RNDLIST.LIMITS(4)=WMAX*RNDLIST.POOL(4)
      RNDLIST.LIMITS(5)=HMAX*RNDLIST.POOL(5)        
      TMAT(5,2)=-1./lms
c Except fully asymmetric case      
      IF(MON.FRAME.SIZE(1)*ABS(STMCH).GT.MON.FRAME.SIZE(3)) THEN
        TMAT(1,3)=(1.D0-lms*Z*mon.rh/stmch)*ctm*stp.ki
        TMAT(4,3)=-Z*mon.rh*stp.ki/stmch*ctm
      ENDIF
C// no constraints in debug mode
      IF (IDBG.GE.1) THEN
          RNDLIST.LIMITS(1)=AHMIN
          RNDLIST.LIMITS(2)=AVMIN
          RNDLIST.LIMITS(3)=0.05*STP.KI
          RNDLIST.LIMITS(4)=SAM.SIZE(1)
          RNDLIST.LIMITS(5)=SAM.SIZE(2)
      ENDIF

      ENDIF

C ******************************************************
C                                                      *
C                  SECONDARY SPECTROMETER              *
C                                                      *
C ******************************************************

C// Initialize components 
      CALL BENDER_INIT(SOL3)
      CALL CRYST_INIT2(ANA)
      CALL BENDER_INIT(SOL4)
      CALL SLIT_INIT(DET.FRAME)

C// calculate maximum angular deviations for the secondary spectrometer
      CALL APERTURE2(ITASK,ah2,av2)
c      write(*,*) 'APERTURE2 ',ah2,av2

      IF (RNDLIST.DIM.GE.7) THEN
         RNDLIST.ACTIVE(7)=1
         RNDLIST.LIMITS(7)=av2
      ENDIF
      
      IF (RNDLIST.DIM.GE.8) THEN
         RNDLIST.ACTIVE(8)=1
         RNDLIST.LIMITS(8)=ah2
      ENDIF
 
      IF(ANA.NH.GT.1.OR.ANA.HMOS.LE.SEC) THEN 
        Z=1.D0 
      ELSE
        Z=0.D0
      ENDIF  
C/// for monitor after Vanad sample and analyzer
      IF(ITASK.EQ.6.AND.IMONIT.GE.9) THEN
        sgna=sign(1,stp.sa) 
        cta=sgna/tan(ana.thb)
        stach=SIN(ANA.THB-sgna*ANA.CHI) 
        lsa=SOL3.FRAME.DIST+ANA.FRAME.DIST
        Z1=1.D0-Z*ana.rh*lsa/stach        
c     get contributions to Bragg angle spread 
        a1=4*ana.hmos ! mosaicity
        a2=GETEFFMOS(ANA) 
        IF (ABS(Z1).GT.0.05) then
          IF(CFGMODE.EQ.1) THEN
            TMAT(3,7)=1.D0/cta/Z1/stp.kf
          ELSE  
            TMAT(3,8)=1.D0/cta/Z1/stp.kf
          ENDIF  
c          TMAT(4,8)=COMEGA*Z*ana.rh/stach/Z1
          RNDLIST.LIMITS(8)=SQRT((SAM.SIZE(1)/LSA)**2+a1**2+a2**2)
        endif
      ENDIF  
      
C/// for powder diffractometer, initial optimization of vertical scatt. angle 
      IF(ITASK.EQ.4) THEN
         c2ts=COMEGA/SOMEGA
         IF(ABS(c2ts).LT.5) TMAT(2,7)=c2ts/STP.KI
      ENDIF
      IF(ITASK.EQ.5) THEN
         c2ts=COMEGA/SOMEGA
         IF(ABS(c2ts).LT.5) TMAT(2,7)=-c2ts/STP.KI
      ENDIF

C/// for inelastic scattering (TAS resolution)
      IF(ITASK.EQ.1.OR.ITASK.EQ.8) THEN
          RNDLIST.ACTIVE(9)=1
          sgna=sign(1,stp.sa) 
          cta=sgna/tan(ana.thb)
          stach=SIN(ANA.THB-sgna*ANA.CHI) 
          lsa=SOL3.FRAME.DIST+ANA.FRAME.DIST
c get contributions to Bragg angle spread 
          a1=4*ana.hmos ! mosaicity
          a2=GETEFFMOS(ANA) 
          a3=0.5*tan(ana.thb)*(av2/2)**2 ! vertical divergence
          RNDLIST.LIMITS(9)=SQRT(a1**2+a2**2+a3**2)*stp.kf*abs(cta)      
          B89=(1.D0-lsa*Z*ana.rh/stach)*cta*stp.kf
          IF(CFGMODE.EQ.1) THEN
            TMAT(7,9)=B89
c            TMAT(7,9)=-B89/HSQOV2M/STP.KF
            TMAT(5,9)=COMEGA*Z*ana.rh/stach*cta*stp.kf
          ELSE
            TMAT(8,9)=(1.D0-lsa*Z*ana.rh/stach)*cta*stp.kf
            TMAT(4,9)=COMEGA*Z*ana.rh/stach*cta*stp.kf
          ENDIF  
      ENDIF


C/// for tracing through the secondary spectrometer only
      IF(ITASK.EQ.8.OR.ITASK.EQ.9) THEN
          DO I=1,6
            RNDLIST.ACTIVE(I)=0
            RNDLIST.LIMITS(I)=1
          ENDDO
          TMAT(4,9)=0.D0
      ENDIF
            
      
C// no constraints in debug mode
      IF (IDBG.GE.1) THEN
          RNDLIST.LIMITS(7)=AV2
          RNDLIST.LIMITS(8)=AH2
          RNDLIST.LIMITS(9)=0.05*STP.KF
          DO  I=1,RNDLIST.DIM
          DO  J=1,RNDLIST.DIM
            IF (I.NE.J) THEN
              TMAT(I,J)=0.D0
            ELSE
              TMAT(I,J)=1.D0
            ENDIF
          END DO
          END DO
          WRITE(SOUT,*) 'No initial correlations'        
      ENDIF

      IF (VERBOSE) THEN
          WRITE(SOUT,*) 'Monte-Carlo variables initialized.'
          CALL WRITE_SETUP(20,ITASK)
      ENDIF  
      
c      WRITE(SOUT,*) 'SPEC_INI done.'
c          CALL WRITE_SETUP(20,ITASK)

c100   FORMAT('TMAT: ',16(1X,G10.4))      
c101   FORMAT('TLIM: ',16(1X,G10.4))      
c      write(*,*)
c      DO I=1,RNDLIST.DIM
c        write(*,100) (TMAT(I,J),J=1,RNDLIST.DIM)
c      ENDDO
c      write(*,101) (RNDLIST.LIMITS(J),J=1,RNDLIST.DIM)
c      write(*,*)
c      write(*,*) 'DET(TMAT)= ',DETERM(TMAT,CRND,AUX)

      RETURN
999   IERR=2
      RETURN
      END

C---------------------------------------------------------------------
      LOGICAL FUNCTION SPEC_GO(ITASK)
C     traces neutron trajectories starting at the sample 
C  ITASK=1 ... inelastic scattering, TAS resolution
C  ITASK=2 ... sample -> source
C  ITASK=3 ... source -> sample
C  ITASK=4 ... sample -> source + sample(powder) -> detector (no analyser)
C  ITASK=5 ... source -> sample + sample(powder) -> detector (no analyser)
C  ITASK=6 ... sample -> source + sample (Vanad) -> monitor(IMONIT)
C  ITASK=7 ... source -> monitor(IMONIT)

C The neutron coordinates are stored in the following order
C NEUI1(source) -> NEUI(incident) -> NEUF(scattered) -> NEUF1(detector)
C----------------------------------------------------------------------
      implicit none
        
      INTEGER*4 ITASK     
      LOGICAL DIFF_GO,MONIT_GO,INELAST_GO,FLUX_GO, DIFF_GO2,
     *        MONIT_GO2,FLUX_GO2,TAS2_GO, DIFF2_GO, DIFF3_GO,DCRYST_GO  
      
      IF(ITASK.EQ.1) THEN
          SPEC_GO=INELAST_GO()
          RETURN
      ELSE IF(ITASK.EQ.2) THEN
          SPEC_GO=FLUX_GO()
          RETURN
      ELSE IF(ITASK.EQ.3) THEN
          SPEC_GO=FLUX_GO2()
          RETURN
      ELSE IF(ITASK.EQ.4) THEN
          SPEC_GO=DIFF_GO()
          RETURN
      ELSE IF(ITASK.EQ.5) THEN
          SPEC_GO=DIFF_GO2()
          RETURN
      ELSE IF(ITASK.EQ.6) THEN
          SPEC_GO=MONIT_GO()
          RETURN
      ELSE IF(ITASK.EQ.7) THEN
          SPEC_GO=MONIT_GO2()
          RETURN
      ELSE IF(ITASK.EQ.8) THEN
          SPEC_GO=TAS2_GO()
          RETURN
      ELSE IF(ITASK.EQ.9) THEN
          SPEC_GO=DIFF2_GO()
          RETURN
      ELSE IF(ITASK.EQ.10) THEN
          SPEC_GO=DIFF3_GO()
          RETURN
      ELSE IF(ITASK.EQ.11) THEN
          SPEC_GO=DCRYST_GO()
          RETURN
      ELSE
          SPEC_GO=.FALSE.
      ENDIF    
      END

C---------------------------------------------------------------
      LOGICAL FUNCTION FLUX_GO()
C     simulate incident flux, start at the sample
C---------------------------------------------------------------
      implicit none

      INCLUDE 'structures.inc'
      INCLUDE 'ness_common.inc'
        
      RECORD /NEUTRON/ NEUI,NEUF,NEUI1,NEUF1,NEU
      LOGICAL TAS1_GO,SLIT_GO
      LOGICAL*4 LOG
      COMMON /NEUIF/ NEUI,NEUF,NEUI1,NEUF1

c      LOG=SLIT_GO(SAM,NEUI,NEU)
c      NEUI=NEU      
c      IF (LOG) LOG=TAS1_GO()
      LOG=TAS1_GO()
      NEU=NEUI
      IF (LOG) LOG=(LOG.AND.SLIT_GO(SAM,NEU,NEUI))
      FLUX_GO=LOG
      END
      
      
C---------------------------------------------------------------
      LOGICAL FUNCTION TAS1_GO()
C     trace primary TAS spectrometer from the sample
C---------------------------------------------------------------
      implicit none

      INCLUDE 'structures.inc'
      INCLUDE 'ness_common.inc'
        
      RECORD /NEUTRON/ NEUI,NEUF,NEUI1,NEUF1,NEU,NEU1
      LOGICAL BENDER_GO,CRYST_GO2,SOURCE_GO
      LOGICAL LOG,SAM_BOARDER
      COMMON /NEUIF/ NEUI,NEUF,NEUI1,NEUF1
      REAL*8 T1,T2

c      LOG=.TRUE.
      
      LOG=SAM_BOARDER(SAM,NEUI.R,NEUI.K,T1,T2)
      LOG=(LOG.AND.NEUI.P.GT.0)
      NEU1=NEUI
      IF(FLIPM.EQ.1) NEU1.S=-NEU1.S
      IF(LOG) LOG=(LOG.AND.BENDER_GO(SOL2,NEU1,NEU))
      IF(LOG) LOG=(LOG.AND.BENDER_GO(SOL2a,NEU,NEU1))
      IF(LOG) LOG=(LOG.AND.CRYST_GO2(MON,NEU1,NEU))
      IF(LOG) LOG=(LOG.AND.BENDER_GO(SOL1,NEU,NEU1))
      IF(LOG) LOG=(LOG.AND.BENDER_GO(GUIDE,NEU1,NEU))
      IF(LOG) LOG=(LOG.AND.BENDER_GO(GDEa,NEU,NEU1))
      IF(LOG) THEN
          LOG=(LOG.AND.SOURCE_GO(SOU,NEU1,NEUI1))
          NEUI.P=NEUI1.P
          NEUI1=NEUI
          NEUI1.R(1)=-NEUI1.R(1)
           NEUI1.K(2)=-NEUI1.K(2)
          NEUI.R(1)=-NEUI.R(1)
           NEUI.K(2)=-NEUI.K(2)
      ENDIF
      TAS1_GO=LOG
      END


C---------------------------------------------------------------
      LOGICAL FUNCTION DIFF_GO()
C     trace from the source to the detector with pwd. sample
C---------------------------------------------------------------
      implicit none

      INCLUDE 'structures.inc'
      INCLUDE 'ness_common.inc'
        
      RECORD /NEUTRON/ NEUI,NEUF,NEUI1,NEUF1,NEU,NEU1
      LOGICAL BENDER_GO,PWD_GO,TAS1_GO,DETECT_GO
      LOGICAL*4 LOG
      COMMON /NEUIF/ NEUI,NEUF,NEUI1,NEUF1
      
      LOG=TAS1_GO()
      IF(LOG) LOG=(LOG.AND.PWD_GO(SAM,NEUI,NEUF,STP.Q*STP.SS))
      NEU=NEUF
      IF(FLIPA.EQ.1) NEU.S=-NEU.S
      IF(LOG) LOG=(LOG.AND.BENDER_GO(SOL3,NEU,NEU1))
      IF(LOG) LOG=(LOG.AND.DETECT_GO(DET,NEU1,NEUF1))
      DIFF_GO=LOG
      RETURN
      END

C---------------------------------------------------------------
      LOGICAL FUNCTION MONIT_GO()
C     trace from the source to the monitor at position IMONIT
C---------------------------------------------------------------
      implicit none

      INCLUDE 'structures.inc'
      INCLUDE 'ness_common.inc'
      INCLUDE 'randvars.inc'
        
      RECORD /NEUTRON/ NEUI,NEUF,NEUI1,NEUF1,NEU,NEU1
      LOGICAL BENDER_GO,SLIT_GO,CRYST_GO2,TAS1_GO,DETECT_GO
      LOGICAL VAN_GO,VAN_TRANS,LOG
      INTEGER*4 M
      COMMON /NEUIF/ NEUI,NEUF,NEUI1,NEUF1
      REAL*8 LL
      INTEGER*4 I
      
      M=IMONIT
      
      LOG=TAS1_GO()
      IF(.NOT.LOG) GOTO 999
      IF (M.EQ.7) THEN
        IF(LOG) LOG=(LOG.AND.VAN_TRANS(SAM,NEUI,NEUF))
        LL=(SOL3.FRAME.DIST-NEUF.R(3))
        DO i=1,2
          NEUF.R(I)=NEUF.R(I)+LL*NEUF.K(I)/NEUF.K(3)        
        ENDDO
        NEUF1=NEUF
        GOTO 100
      ENDIF
      IF (M.EQ.6) THEN
        IF(LOG) LOG=(LOG.AND.SLIT_GO(SAM,NEUI,NEUF))
        NEUF1=NEUF
        GOTO 100
      ENDIF
c      call WrtNeu(NEUI)
      IF(LOG) LOG=(LOG.AND.VAN_GO(SAM,NEUI,NEUF,STP.Q*STP.SS))
c      call WrtNeu(NEUF)
      NEU1=NEUF
      IF(FLIPA.EQ.1) NEU1.S=-NEU1.S
      IF(LOG) LOG=(LOG.AND.BENDER_GO(SOL3,NEU1,NEU))
c      call WrtNeu(NEU)
c      pause
      IF (M.EQ.8) GOTO 100
      IF(LOG) LOG=(LOG.AND.CRYST_GO2(ANA,NEU,NEU1))
      IF (M.EQ.9) GOTO 101
      IF (LOG) LOG=(LOG.AND.BENDER_GO(SOL4,NEU1,NEU))
      IF (M.EQ.10) GOTO 100
      IF(LOG) LOG=(LOG.AND.DETECT_GO(DET,NEU,NEUF1))
      MONIT_GO=LOG
      RETURN

100   NEUF1=NEU
      MONIT_GO=LOG
      RETURN

101   NEUF1=NEU1
      MONIT_GO=LOG
      RETURN

999   MONIT_GO=.FALSE.
      RETURN
      END

C---------------------------------------------------------------
      LOGICAL FUNCTION INELAST_GO()
C     trace 3-axis setup to get resolution function R(Q,E)
C---------------------------------------------------------------
      implicit none

      INCLUDE 'structures.inc'
      INCLUDE 'ness_common.inc'
        
      RECORD /NEUTRON/ NEUI,NEUF,NEUI1,NEUF1,NEU,NEU1
      LOGICAL SAM_GO,BENDER_GO,CRYST_GO2,TAS1_GO,DETECT_GO,TAS1_GO2
      LOGICAL LOG
      REAL*8 KI
      COMMON /NEUIF/ NEUI,NEUF,NEUI1,NEUF1
      
      IF(FTAS.EQ.0) THEN
        LOG=TAS1_GO()
      ELSE
        LOG=TAS1_GO2()
      ENDIF
      IF(.NOT.LOG) GOTO 10
      IF(LOG) LOG=(LOG.AND.SAM_GO(SAM,NEUI,NEUF))
      IF (NORMMON.NE.0) THEN  ! weight by monitor efficiency ~ 1/ki
          ki=SQRT(NEUI.K(1)**2+NEUI.K(2)**2+NEUI.K(3)**2)
          NEUF.P=NEUF.P*ki
      ENDIF      
      NEUF.P=NEUF.P/NEUI.P
      NEU1=NEUF
      IF(FLIPA.EQ.1) NEU1.S=-NEU1.S
      IF(LOG) LOG=(LOG.AND.BENDER_GO(SOL3,NEU1,NEU))
      IF(LOG) LOG=(LOG.AND.CRYST_GO2(ANA,NEU,NEU1))
      IF(LOG) LOG=(LOG.AND.BENDER_GO(SOL4,NEU1,NEU))
      IF(LOG) LOG=(LOG.AND.DETECT_GO(DET,NEU,NEUF1))
      NEUF.P=NEUF1.P
10    INELAST_GO=LOG

      END
      
C-----------------------------------------------------------------------------
      LOGICAL FUNCTION DCRYST_GO()
C     trace 3-axis setup without sample (incl. just nominal scatterinc angle)
C for Q=0, equivalent to the double-crystal setting
C-----------------------------------------------------------------------------
      implicit none

      INCLUDE 'structures.inc'
      INCLUDE 'ness_common.inc'
        
      RECORD /NEUTRON/ NEUI,NEUF,NEUI1,NEUF1,NEU,NEU1
      LOGICAL BRAGG_GO,BENDER_GO,CRYST_GO2,TAS1_GO,DETECT_GO,TAS1_GO2
      LOGICAL LOG
      COMMON /NEUIF/ NEUI,NEUF,NEUI1,NEUF1
      
      IF(FTAS.EQ.0) THEN
        LOG=TAS1_GO()
      ELSE
        LOG=TAS1_GO2()
      ENDIF
      IF(.NOT.LOG) GOTO 10
      IF(LOG) LOG=(LOG.AND.BRAGG_GO(SAM,NEUI,NEUF))
!      NEUF.P=1
      NEU1=NEUF
      IF(FLIPA.EQ.1) NEU1.S=-NEU1.S
      IF(LOG) LOG=(LOG.AND.BENDER_GO(SOL3,NEU1,NEU))
      IF(LOG) LOG=(LOG.AND.CRYST_GO2(ANA,NEU,NEU1))
      IF(LOG) LOG=(LOG.AND.BENDER_GO(SOL4,NEU1,NEU))
      IF(LOG) LOG=(LOG.AND.DETECT_GO(DET,NEU,NEUF1))
!      NEUF.P=NEUF1.P
10    DCRYST_GO=LOG

      END

C---------------------------------------------------------------
      LOGICAL FUNCTION TAS2_GO()
C     trace 3-axis setup, secondary part only
C as INELAST_GO, but without primary spectrometer
C---------------------------------------------------------------
      implicit none

      INCLUDE 'structures.inc'
      INCLUDE 'ness_common.inc'
        
      RECORD /NEUTRON/ NEUI,NEUF,NEUI1,NEUF1,NEU,NEU1
      LOGICAL SAM_GO,BENDER_GO,CRYST_GO2,DETECT_GO
      LOGICAL LOG
      REAL*8 KI
      COMMON /NEUIF/ NEUI,NEUF,NEUI1,NEUF1      
c      real*8 s(10)
c      integer*4 i
c      save s
c1     format('TRACE PROBABILITIES: ',a,I,6(2x,G10.4))
c      if(sam.count.eq.0) s(1)=0.
c      if(ana.frame.count.eq.0) s(3)=0.
      
      LOG=(NEUI.P.GT.0)
      IF(.NOT.LOG) GOTO 10
      IF(LOG) LOG=(LOG.AND.SAM_GO(SAM,NEUI,NEUF))
      IF (NORMMON.NE.0) THEN  ! weight by monitor efficiency ~ 1/ki
          ki=SQRT(NEUI.K(1)**2+NEUI.K(2)**2+NEUI.K(3)**2)
          NEUF.P=NEUF.P*ki
      ENDIF      
      NEUF.P=NEUF.P/NEUI.P
      
c      if(log) s(1)=s(1)+NEUF.P
c      if (sam.count.gt.0) then
c      if (s(1).gt.sam.count*sam.size(3)*1.57*1.2) then
c        write(*,1) 'WARNING!!! : ',sam.count,NEUI.R(1),NEUF.P              
c        write(*,1) 'sample: ',det.count,s(1)/sam.count  
c        pause      
c      endif
c      endif
      
      NEU1=NEUF
      IF(FLIPA.EQ.1) NEU1.S=-NEU1.S
      IF(LOG) LOG=(LOG.AND.BENDER_GO(SOL3,NEU1,NEU))
      IF(LOG) LOG=(LOG.AND.CRYST_GO2(ANA,NEU,NEU1))            
c      if(log) s(3)=s(3)+NEU1.P/NEU.P
      IF(LOG) LOG=(LOG.AND.BENDER_GO(SOL4,NEU1,NEU))
      IF(LOG) LOG=(LOG.AND.DETECT_GO(DET,NEU,NEUF1))
c      if (sam.count.gt.1000) then
c        write(*,1) 'sample: ',sam.count,s(1)/sam.count        
c        write(*,1) 'sample x,P: ',10000,NEUI.R(1),NEUF.P        
c      endif
c      if (ana.frame.count.gt.1000) then
c        write(*,1) 'analyzer: ',ana.frame.count,s(3)/ana.frame.count        
c      endif
             
      NEUF.P=NEUF1.P
10    TAS2_GO=LOG

      END
        
C---------------------------------------------------------------
      subroutine TestQE(KI,KF)
C---------------------------------------------------------------
      IMPLICIT NONE
      INCLUDE 'const.inc'
      INCLUDE 'structures.inc'
      INCLUDE 'ness_common.inc'
      INCLUDE 'rescal.inc'
      
      REAL*8  VQ(3),WQ(3),KF0,KI0,VKI(3),VKF(3),KI(3),KF(3)
      INTEGER*4 I,J
        
      DO I=1,3
        VKI(I)=KI(I) 
        VKF(I)=KF(I)
      ENDDO 
      KF0=VKF(1)**2+VKF(2)**2+VKF(3)**2
      KI0=VKI(1)**2+VKI(2)**2+VKI(3)**2
      VKF(1)=VKF(1)-STP.KF*SOMEGA
      VKF(3)=VKF(3)-STP.KF*COMEGA
      VKI(3)=VKI(3)-STP.KI
      DO I=1,3
        VQ(I)=VKF(I)-VKI(I)
      ENDDO
C*  transform to C&N coord.
      DO I=1,3
         WQ(I)=0
         DO J=1,3
            WQ(I)=WQ(I)+MLC(J,I)*VQ(J)
         ENDDO
      ENDDO
      IF(WQ(1).GT.0.06) then
80      format(a10,4(1x,G12.6))
        write (*,80) 'VKI: ',(VKI(I),I=1,3) 
        write (*,80) 'VKF: ',(VKF(I),I=1,3) 
        write (*,80) 'VQ: ',(VQ(I),I=1,3) 
        write (*,80) 'WQ: ',(WQ(I),I=1,3),HSQOV2M*(KI0-KF0)-STP.E 
        VKF(1)=KF(1)*COMEGA-KF(3)*SOMEGA
        VKF(3)=KF(1)*SOMEGA+KF(3)*COMEGA
        write (*,80) 'KF: ',(VKF(I),I=1,3) 
        write (*,80) 'ang: ',KI(1)/KI(3),VKF(1)/VKF(3) 
        pause
      endif
      end

C---------------------------------------------------------------
      LOGICAL FUNCTION DIFF2_GO()
C trace from a sample (diffuse elastic) to the detector
C without primary spectrometer
C---------------------------------------------------------------
      implicit none

      INCLUDE 'structures.inc'
      INCLUDE 'ness_common.inc'
        
      RECORD /NEUTRON/ NEUI,NEUF,NEUI1,NEUF1,NEU,NEU1
      LOGICAL BENDER_GO,ESAM_GO,DETECT_GO
      LOGICAL*4 LOG
      COMMON /NEUIF/ NEUI,NEUF,NEUI1,NEUF1
      
      LOG=(NEUI.P.GT.0)
      IF(.NOT.LOG) GOTO 10
      IF(LOG) LOG=(LOG.AND.ESAM_GO(SAM,NEUI,NEUF))
      NEUF.P=NEUF.P/NEUI.P
      NEU=NEUF
      IF(FLIPA.EQ.1) NEU.S=-NEU.S
      IF(LOG) LOG=(LOG.AND.BENDER_GO(SOL3,NEU,NEU1))
      IF(LOG) LOG=(LOG.AND.DETECT_GO(DET,NEU1,NEUF1))
      NEUF.P=NEUF1.P
10    DIFF2_GO=LOG
      RETURN
      END

C---------------------------------------------------------------
      LOGICAL FUNCTION DIFF3_GO()
C trace from a powder sample to the detector
C as DIFF_GO, but without primary spectrometer
C---------------------------------------------------------------
      implicit none

      INCLUDE 'structures.inc'
      INCLUDE 'ness_common.inc'
        
      RECORD /NEUTRON/ NEUI,NEUF,NEUI1,NEUF1,NEU,NEU1
      LOGICAL BENDER_GO,PWD_GO,DETECT_GO
      LOGICAL*4 LOG
      COMMON /NEUIF/ NEUI,NEUF,NEUI1,NEUF1
      
      LOG=(NEUI.P.GT.0)
      IF(.NOT.LOG) GOTO 10
      IF(LOG) LOG=(LOG.AND.PWD_GO(SAM,NEUI,NEUF,STP.Q*STP.SS))
c      NEUF.P=NEUF.P/NEUI.P
      NEU=NEUF
      IF(FLIPA.EQ.1) NEU.S=-NEU.S
      IF(LOG) LOG=(LOG.AND.BENDER_GO(SOL3,NEU,NEU1))
      IF(LOG) LOG=(LOG.AND.DETECT_GO(DET,NEU1,NEUF1))
10    DIFF3_GO=LOG

c         E(1)=NEU.R(1)               
c         E(2)=NEU.R(2)
c         E(3)=HSQOV2M*(KKI-STP.KI**2)
c         E(4)=NEU.T/1000   ! in [ms]             
c         DEI=DEI+NEU.P*E(3)**2
c         DEI0=DEI0+E(3)*NEU.P
c         CALL EVARRAY(1,1,NCNT,E,NEU.P) 
c         DO I=1,3
c               E(I)=NEU.K(I)
c         ENDDO
c         E(3)=E(3)-STP.KI
c         E(4)=NEU.S
c         CALL EVARRAY(1,0,NCNT,E,NEU.P)


      RETURN
      END

C---------------------------------------------------------------
      LOGICAL*4 FUNCTION BENCH_CR(ICOM,NEU)
C     traces neutron trajectories from the sample to the source
C     (ICOM=1) or from the sample to the detector (ICOM=2)
C---------------------------------------------------------------
      implicit none

      INCLUDE 'const.inc'
      INCLUDE 'inout.inc'
      INCLUDE 'structures.inc'
      INCLUDE 'ness_common.inc'
        
      RECORD /NEUTRON/ NEU,NEU1
      LOGICAL BENDER_GO,SLIT_GO,CRYST_GO2,LOG
      INTEGER*4 ICOM
101    format(1x,7(G13.6,2x),a1)
      LOG=.TRUE.
      LOG=(NEU.P.GT.0)
c      IF(LOG) write(*,101) (NEU.R(i),i=1,3),(NEU.K(i),i=1,3),NEU.p
      IF(LOG) LOG=(LOG.AND.SLIT_GO(SAM,NEU,NEU1))
c      IF(LOG) write(*,101) (NEU1.R(i),i=1,3),(NEU1.K(i),i=1,3),NEU1.p
      IF(FLIPM.EQ.1) NEU1.S=-NEU1.S
      IF(LOG) LOG=(LOG.AND.BENDER_GO(SOL2,NEU1,NEU))
c      IF(LOG) write(*,101) (NEU.R(i),i=1,3),(NEU.K(i),i=1,3),NEU.p
      IF(LOG) LOG=(LOG.AND.BENDER_GO(SOL2a,NEU,NEU1))
c      IF(LOG) write(*,101) (NEU1.R(i),i=1,3),(NEU1.K(i),i=1,3),NEU1.p
      BENCH_CR=LOG
      IF(LOG.AND.(ICOM.EQ.1)) LOG=(LOG.AND.CRYST_GO2(MON,NEU1,NEU))
      RETURN
      END

C---------------------------------------------------------------
      LOGICAL*4 FUNCTION BENCH_SOL2(ICOM,NEU)
C     traces neutron trajectories from the sample to the source
C     (ICOM=1) or from the sample to the detector (ICOM=2)
C---------------------------------------------------------------
      implicit none

      INCLUDE 'const.inc'
      INCLUDE 'inout.inc'
      INCLUDE 'structures.inc'
      INCLUDE 'ness_common.inc'
        
      RECORD /NEUTRON/ NEU,NEU1
      LOGICAL BENDER_GO,SLIT_GO,LOG
      INTEGER*4 ICOM
      LOG=.TRUE.
      LOG=(NEU.P.GT.0)
      IF(LOG) LOG=(LOG.AND.SLIT_GO(SAM,NEU,NEU1))
      IF(FLIPM.EQ.1) NEU1.S=-NEU1.S
      BENCH_SOL2=LOG
      IF(LOG.AND.(ICOM.EQ.1)) LOG=(LOG.AND.BENDER_GO(SOL2,NEU1,NEU))
      RETURN
      END

C---------------------------------------------------------------
      LOGICAL*4 FUNCTION BENCH_PWD(ICOM,NEU)
C     traces neutron trajectories from the sample to the source
C     (ICOM=1) or from the sample to the detector (ICOM=2)
C---------------------------------------------------------------
      implicit none

      INCLUDE 'const.inc'
      INCLUDE 'inout.inc'
      INCLUDE 'structures.inc'
      INCLUDE 'ness_common.inc'
        
      RECORD /NEUTRON/ NEU,NEU1,NEUI
      LOGICAL BENDER_GO,SLIT_GO,CRYST_GO2,LOG,SOURCE_GO,PWD_GO
      INTEGER*4 ICOM
      LOG=.TRUE.
      LOG=(NEU.P.GT.0)
      NEUI=NEU
      IF(LOG) LOG=(LOG.AND.SLIT_GO(SAM,NEU,NEU1))
      IF(FLIPM.EQ.1) NEU1.S=-NEU1.S
      IF(LOG) LOG=(LOG.AND.BENDER_GO(SOL2,NEU1,NEU))
      IF(LOG) LOG=(LOG.AND.BENDER_GO(SOL2a,NEU,NEU1))
      IF(LOG) LOG=(LOG.AND.CRYST_GO2(MON,NEU1,NEU))
      IF(LOG) LOG=(LOG.AND.BENDER_GO(SOL1,NEU,NEU1))
      IF(LOG) LOG=(LOG.AND.BENDER_GO(GUIDE,NEU1,NEU))
      IF(LOG) LOG=(LOG.AND.BENDER_GO(GDEa,NEU,NEU1))
      IF(LOG) THEN
          LOG=(LOG.AND.SOURCE_GO(SOU,NEU1,NEU))
          NEU1=NEUI
          NEU1.P=NEU.P
          NEU1.R(1)=-NEU1.R(1)
           NEU1.K(2)=-NEU1.K(2)
      ENDIF
      BENCH_PWD=LOG
      IF(LOG.AND.(ICOM.EQ.1))
     *      LOG=(LOG.AND.PWD_GO(SAM,NEU1,NEU,STP.Q*STP.SS))
      RETURN
      END

C---------------------------------------------------
      SUBROUTINE NESS_CONV(READCFG)
C     Conversion of parameters from TRAX & RESCAL to NESS
C---------------------------------------------------
      IMPLICIT NONE

      INCLUDE 'const.inc'
      INCLUDE 'inout.inc'
      INCLUDE 'structures.inc'
      INCLUDE 'ness_common.inc'
      INCLUDE 'collimators.inc'
      INCLUDE 'rescal.inc'
      INCLUDE 'trax.inc'

      INTEGER*4 READCFG
      INTEGER*4 IERR
      COMMON /ERRORS/ IERR
      INTEGER*4 I      
      
      IF (READCFG.GT.0) CALL SETCFG(CFGNAME)
      
c      write(*,*) 'Convert input data to NESS structures'

      SOL1.DLH=DLAMH(3)
      SOL1.DLV=DLAMV(3)
      SOL1.NLH=NLAM(3)
      SOL1.NLV=VLAM(3)
      SOL2.DLH=DLAMH(5)
      SOL2.DLV=DLAMV(5)
      SOL2.NLH=NLAM(5)
      SOL2.NLV=VLAM(5)
      SOL3.DLH=DLAMH(6)
      SOL3.DLV=DLAMV(6)
      SOL3.NLH=NLAM(6)
      SOL3.NLV=VLAM(6)
      SOL4.DLH=DLAMH(7)
      SOL4.DLV=DLAMV(7)
      SOL4.NLH=NLAM(7)
      SOL4.NLV=VLAM(7)
      SOL2A.DLH=DLAMH(4)
      SOL2A.DLV=DLAMV(4)
      SOL2A.NLH=NLAM(4)
      SOL2A.NLV=VLAM(4)
      GUIDE.DLH=DLAMH(2)
      GUIDE.DLV=DLAMV(2)
      GUIDE.NLH=NLAM(2)
      GUIDE.NLV=VLAM(2)
      GDEA.DLH=DLAMH(1)
      GDEA.DLV=DLAMV(1)
      GDEA.NLH=NLAM(1)
      GDEA.NLV=VLAM(1)

C///  sample:
      SMOS=RES_DAT(i_ETAS)*minute/R8LN2
      SAM.NAME='sample'
      SAM.SHAPE=1
      SAM.DIST=0.
      SAM.AXI=0.
      DO 10 I=1,3
        SOU.STA(I)=0.
        SOU.GON(I)=0.
10    CONTINUE
      SAM.SIZE(1)=RES_DAT(i_SDI)*10.
      SAM.SIZE(3)=RES_DAT(i_SDI)*10.
      SAM.SIZE(2)=RES_DAT(i_SHI)*10.

C///  Soller collimators
      SOL1.FRAME.NAME='col1'
      SOL2.FRAME.NAME='col2'
      SOL2a.FRAME.NAME='col2a'
      GUIDE.FRAME.NAME='guide'
      GDEa.FRAME.NAME='guide_a'
cxxxxxxxxxcxxxxxxxxxcxxxxxxxxxcxxxxxxxxxcxxxxxxxxxcxxxxxxxxxcxxxxxxxxxcx

      CALL CREATE_COL(SOL1,NFM,ALPHA(1),BETA(1),VLSM,VL0-VLCANM-VLSM,
     1     HDM1,HDM2,VDM1,VDM2,3,-1)
      
      if (NFG.GT.0) then
         CALL CREATE_COL(GUIDE,NFG,0.D0,0.D0,LGUIDE,
     1        VL0-SOL1.FRAME.DIST/10., HG1,HG2,VG1,VG2,2,-1)
         CALL CREATE_COL(GDEa,NFG,0.D0,0.D0,LGA,
     1        DGA+GUIDE.FRAME.SIZE(3)/10,HGA1,HGA2,VGA1,VGA2,1,-1)
      else
         CALL CREATE_COL(GUIDE,NFG,0.D0,0.D0,0.D0,
     1       VL0-SOL1.FRAME.DIST/10., HG1, HG2,VG1,VG2,2,-1)
         DGUIDE=0. ! important to set correctly source distance
         CALL CREATE_COL(GDEa,NFG,0.D0,0.D0,0.D0,
     1       0.D0,HGA2,HGA1,VGA2,VGA1,1,-1)
         DGA=0. ! important to set correctly source distance
      endif

      CALL CREATE_COL(SOL2,NFS,ALPHA(2),BETA(2),VLMS,VL1-VLCANS-VLMS,
     1    HDS1,HDS2,VDS1,VDS2,5,-1)
     
      IF(ALPHA(2).GT.0) THEN
        CALL CREATE_COL(SOL2A,NFS,500.D0,500.D0,LEN2A,VLMS+DIST2A,
     1    H2A1,H2A2,V2A1,V2A2,4,-1)
      else
        CALL CREATE_COL(SOL2A,NFS,0.D0,0.D0,LEN2A,VLMS+DIST2A,
     1    H2A1,H2A2,V2A1,V2A2,4,-1)
      endif


C///  monochromator:
      MON.FRAME.SHAPE=3
      MON.FRAME.SIZE(1)=WMON*10.
      MON.FRAME.SIZE(2)=HMON*10.
      MON.FRAME.SIZE(3)=THMON*10.
      MON.FRAME.DIST=VL1*10.-SOL2A.FRAME.DIST-SOL2.FRAME.DIST
      MON.FRAME.AXI=0.
      MON.CHI=HIMON*deg
      MON.DHKL=RES_DAT(i_DM)
      MON.THB=ASIN(PI/MON.DHKL/STP.KI)
      MON.RH=RES_DAT(i_ROMH)/1000.
      MON.RV=RES_DAT(i_ROMV)/1000.
      MON.HMOS=RES_DAT(i_ETAM)*minute/R8LN2
      MON.VMOS=MON.HMOS*ANRM
      IF (STP.SM.LT.0) THEN
        MON.FRAME.GON(1)=MON.THB-MON.CHI+PI/2.+
     &       (DTHAX(1)-DTHAX(2))*PI/180/60
        SOL1.FRAME.AXI=MON.THB*2.-DTHAX(2)*PI/180/60
      ELSE IF (STP.SM.GT.0) THEN
        MON.FRAME.GON(1)=-MON.THB-MON.CHI-PI/2.-
     &       (DTHAX(1)-DTHAX(2))*PI/180/60
        SOL1.FRAME.AXI=-MON.THB*2.+DTHAX(2)*PI/180/60
      ELSE
        MON.FRAME.GON(1)=0.   ! if SM=0, then a filter is considered instead of the analyzer
        MON.THB=0.            ! CRYST_GO recognizes this case if THB=0
        SOL1.FRAME.AXI=0.     ! dhkl determines the edge position, kc=pi/dhkl
        MON.CHI=PI/2.
        MON.RH=0.
        MON.RV=0.
        MON.HMOS=0.
        MON.VMOS=0.
        STP.KI=2*PI/MON.DHKL
      ENDIF
      MON.POI=POISSM
      MON.nh=nhm
      MON.nv=nvm
      MON.nb=nbm
      MON.DH=0.1D0
      MON.DV=0.1D0
      MON.DB=0.1D0
      MON.FRAME.AXV=0


C///  source:
      SOU.NAME='source'
      SOU.SIZE(1)=WSOU*10.
      SOU.SIZE(2)=HSOU*10.
      SOU.SIZE(3)=0.1
      IF(NSOU.EQ.0) THEN
        SOU.SHAPE=2
        SOU.SIZE(1)=DIASOU*10.
        SOU.SIZE(2)=DIASOU*10.
      ELSE IF (NSOU.EQ.2) THEN
        SOU.SHAPE=2
      ELSE IF (NSOU.EQ.3) THEN
        SOU.SHAPE=1
      ELSE
        SOU.SHAPE=3
      ENDIF

      SOU.AXI=0.
      SOU.DIST=DGUIDE*10.-DGA*10.
      DO 20 I=1,3
        SOU.STA(I)=0.
        SOU.GON(I)=0.
20    CONTINUE

C///  Soller collimators:
      SOL3.FRAME.NAME='col3'
      SOL4.FRAME.NAME='col4'
      CALL CREATE_COL(SOL3,NFA,ALPHA(3),BETA(3),VLSA,VLCANA,
     1     HDA1,HDA2,VDA1,VDA2,6,1)

      SOL3.FRAME.AXI=OMEGA+SIGN(1,STP.SS)*DTHAX(4)*minute
      SOL3.FRAME.GON(1)=SIGN(1,STP.SS)*DTHAX(3)*minute

      CALL CREATE_COL(SOL4,NFD,ALPHA(4),BETA(4),VLAD,VLCAND,
     1     HDD1,HDD2,VDD1,VDD2,7,1)

C///  analyzer:
C      ANA.FRAME.NAME='analyzer'
      ANA.FRAME.SHAPE=3
      ANA.FRAME.SIZE(1)=WANA*10.
      ANA.FRAME.SIZE(2)=HANA*10.
      ANA.FRAME.SIZE(3)=THANA*10.
      ANA.FRAME.DIST=VL2*10.-SOL3.FRAME.DIST
      ANA.FRAME.AXI=0.
      ANA.CHI=-HIANA*deg
      ANA.DHKL=RES_DAT(i_DA)
      ANA.THB=ASIN(PI/ANA.DHKL/STP.KF)
      ANA.RH=RES_DAT(i_ROAH)/1000.
      ANA.RV=RES_DAT(i_ROAV)/1000.
      ANA.HMOS=RES_DAT(i_ETAA)*minute/R8LN2
      ANA.VMOS=ANA.HMOS*ANRA


      IF(STP.SA.EQ.0) THEN
          ANA.FRAME.GON(1)=0.   ! if SA=0, then a filter is considered instead of the analyzer
          ANA.THB=0.            ! CRYST_GO recognizes this case if THB=0
          SOL4.FRAME.AXI=0.     ! dhkl determines the edge position, kc=2*pi/dhkl
          ANA.CHI=PI/2.  
          ANA.RH=0. 
          ANA.RV=0. 
          ANA.HMOS=0
          ANA.VMOS=0
          IF (STP.SM.EQ.0) STP.KF=2*PI/MON.DHKL             
      ELSE IF(CFGMODE.EQ.1) THEN    ! Option with scondary spectrometer turned up   
        IF (STP.SA.GT.0) THEN 
          ANA.FRAME.GON(1)=PI/2
          ANA.FRAME.GON(2)=-PI/2
          ANA.FRAME.GON(3)=ANA.THB-ANA.CHI+PI/2.+DTHAX(5)*PI/180/60
          SOL4.FRAME.AXI=0
          SOL4.FRAME.AXV=-ANA.THB*2.-DTHAX(6)*PI/180/60
        ELSE IF (STP.SA.LT.0) THEN 
          ANA.FRAME.GON(1)=-PI/2
          ANA.FRAME.GON(2)=+PI/2
          ANA.FRAME.GON(3)=-ANA.THB+ANA.CHI+PI/2.-DTHAX(5)*PI/180/60
          SOL4.FRAME.AXI=0
          SOL4.FRAME.AXV=ANA.THB*2.+DTHAX(6)*PI/180/60
        ENDIF       
      ELSE
        ANA.FRAME.GON(2)=0
        ANA.FRAME.GON(3)=0
        IF (STP.SA.GT.0) THEN 
          ANA.FRAME.GON(1)=ANA.THB-ANA.CHI+PI/2.+DTHAX(5)*PI/180/60
          SOL4.FRAME.AXI=ANA.THB*2.+DTHAX(6)*PI/180/60
          SOL4.FRAME.AXV=0
        ELSE IF (STP.SA.LT.0) THEN 
          ANA.FRAME.GON(1)=-ANA.THB-ANA.CHI-PI/2.-DTHAX(5)*PI/180/60
          SOL4.FRAME.AXI=-ANA.THB*2.-DTHAX(6)*PI/180/60
          SOL4.FRAME.AXV=0
        ENDIF  
      ENDIF

      ANA.POI=POISSA
      ANA.nh=nha
      ANA.nv=nva
      ANA.nb=nba
      ANA.DH=0.1D0
      ANA.DV=0.1D0
      ANA.DB=0.1D0


C///  dector:
      DET.FRAME.NAME='detector'
      IF(NDET.EQ.0) THEN
        DET.FRAME.SHAPE=2
        DET.FRAME.SIZE(1)=DIADET*10.
        DET.FRAME.SIZE(2)=DIADET*10.
        DET.FRAME.SIZE(3)=HDET*10.
      ELSE
        DET.FRAME.SHAPE=3
        DET.FRAME.SIZE(1)=WDET*10.
        DET.FRAME.SIZE(2)=HDET*10.
        DET.FRAME.SIZE(3)=WDET*10.
      ENDIF
      DET.FRAME.AXI=0.
      DET.FRAME.AXV=0.
      DET.FRAME.DIST=VL3*10.-SOL4.FRAME.DIST
      DO I=1,3
        DET.FRAME.STA(I)=0.
        DET.FRAME.GON(I)=0.
      ENDDO
      IF(ADET.GT.0.) THEN      
        DET.ALPHA=ADET/10.D0
        DET.ND=NSEGDET
        DET.SPACE=SPACEDET
        DET.FRAME.GON(2)=PHIDET*PI/180.      
        IF(DET.FRAME.SHAPE.EQ.2) THEN
          DET.FRAME.SIZE(1)=DIADET*10.
          DET.FRAME.SIZE(3)=DIADET*10.
          DET.FRAME.SIZE(2)=HDET*10.
        ELSE
          DET.FRAME.SIZE(1)=WDET*10.
          DET.FRAME.SIZE(2)=HDET*10.
          DET.FRAME.SIZE(3)=DIADET*10.
        ENDIF  
      ENDIF
      

      IF((STP.SM.EQ.0).AND.(STP.SA.EQ.0)) THEN
         STP.E=HSQOV2M*(STP.KI**2-STP.KF**2)
      ENDIF
      
c      write(*,*) 'GUIDE.NLH, NLAM2: ',GUIDE.NLH, NLAM2

C     call WRITE_SETUP(20)
C      write(*,*) 'Conversion done.'
C     pause

      RETURN
999   IERR=2
      RETURN
      END

C--------------------------------------------------------------
      SUBROUTINE CREATE_COL(OBJ,NFM,ALPHA,BETA,LCOL,DCOL,
     &       HW1,HW2,VW1,VW2,IC,IDIR)
C Fill OBJ structure with parameters of a collimator segment
C NFM   .. indicates presence
C ALPHA .. Soller divergence, horizontal
C BETA  .. Soller divergence, vertical
C LENG  .. collimator length
C DIST  .. distance of entry from the preceding component
C H1,H2 .. entry and exit widths
C V1,V2 .. entry and exit heights
C IC    .. index to other parameters in the common "collimators"
C IDIR  .. direction downstream (1) or upstream (-1) 
C if IDIR=-1, exchanges entry and exit and sets oposite sign of
C horiz. curvature for curved guides)
C Converts input sizes from [cm] to [mm]
C--------------------------------------------------------------
      IMPLICIT NONE
      include 'const.inc'
      include 'inout.inc'
      INCLUDE 'structures.inc'
      INCLUDE 'collimators.inc'
      
      RECORD /BENDER/ OBJ
      INTEGER*4 NFM,IC,IDIR,I
      REAL*8 ALPHA,BETA,LCOL,DCOL,HW1,HW2,VW1,VW2
      
      INTEGER*4 READ_MIRROR,IS
      REAL*8 H1,H2,V1,V2,LENG,DIST
1     format(a,3(2x,G12.6))
c      write(*,1) 'Create collimator '//OBJ.FRAME.NAME(1:10),NFM,
c     &  ALPHA,LCOL
      

      OBJ.TYP=CTYP(IC)      
      IS=SIGN(1,IDIR)
c unit conversion [cm]-> [mm] 
c if IDIR<0, exchange entry and exit
      IF (IS.GT.0) THEN
        H1=HW1*10.
        H2=HW2*10.
        V1=VW1*10.
        V2=VW2*10.
      ELSE
        H2=HW1*10.
        H1=HW2*10.
        V2=VW1*10.
        V1=VW2*10.
      ENDIF        
      LENG=LCOL*10.
      DIST=DCOL*10.
      
      OBJ.CH=ROH(IC)*IS
      OBJ.CV=ROV(IC)
      
      OBJ.GHLU=GAMH(IC)
      OBJ.GHRU=GAMH(IC)
      IF (POLAR(IC).EQ.0) THEN
         OBJ.GHLD=GAMH(IC)
         OBJ.GHRD=GAMH(IC)
      ELSE
         OBJ.GHLD=0
         OBJ.GHRD=0
      ENDIF
      OBJ.OSCILATE=OSC(IC)
      OBJ.GVT=GAMV(IC)
      OBJ.GVB=GAMV(IC)
      OBJ.RHLU=REFH(IC)
      OBJ.RHLD=REFH(IC)
      OBJ.RHRU=REFH(IC)
      OBJ.RHRD=REFH(IC)
      OBJ.RVT=REFV(IC)
      OBJ.RVB=REFV(IC)
      OBJ.NHLU=READ_MIRROR(OBJ.GHLU)
      OBJ.NHLD=READ_MIRROR(OBJ.GHLD)
      OBJ.NHRU=READ_MIRROR(OBJ.GHRU)
      OBJ.NHRD=READ_MIRROR(OBJ.GHRD)
      OBJ.NVT=READ_MIRROR(OBJ.GVT)
      OBJ.NVB=READ_MIRROR(OBJ.GVB)
      OBJ.FRAME.AXI=0.

      DO 10 I=1,3
        OBJ.FRAME.STA(I)=0.
        OBJ.FRAME.GON(I)=0.
10    CONTINUE
      OBJ.FRAME.SHAPE=3
      OBJ.FRAME.DIST=DIST
      OBJ.FRAME.SIZE(1)=H1
      OBJ.FRAME.SIZE(2)=V1
      OBJ.FRAME.SIZE(3)=LENG
      OBJ.W2=H2
      OBJ.H2=V2
      IF (OBJ.DLH.EQ.0) OBJ.DLH=0.08 
      IF (OBJ.DLV.EQ.0) OBJ.DLV=0.08
      
      IF((ALPHA.GT.0).OR.(NFM.GE.0)) THEN
          IF(ALPHA.GT.0.AND.ALPHA.LT.500.AND.OBJ.TYP.LT.2) THEN ! set NLH automatically
            IF (OBJ.NLH.LE.0) OBJ.NLH=
     *         NINT((H1+H2)/(2*LENG*(ALPHA*minute+OBJ.DLH/LENG/10.)))
          ELSE
            IF (OBJ.NLH.LE.0) OBJ.NLH=1
          ENDIF  
          IF (BETA.GT.0.AND.BETA.LT.500.AND.OBJ.TYP.LT.2) THEN ! set NLV automatically
            IF (OBJ.NLV.LE.0) OBJ.NLV=
     *         NINT((V1+V2)/(2*LENG*(BETA*minute+OBJ.DLV/LENG/10.))) 
          ELSE
            IF (OBJ.NLV.LE.0) OBJ.NLV=1
          ENDIF
      ELSE
          OBJ.FRAME.SIZE(1)=1000.
          OBJ.FRAME.SIZE(2)=1000.
          OBJ.FRAME.SIZE(3)=0.
          OBJ.W2=OBJ.FRAME.SIZE(1)
          OBJ.H2=OBJ.FRAME.SIZE(2)
          OBJ.NLH=1
          OBJ.NLV=1
          OBJ.TYP=-1
      ENDIF
      IF(OBJ.NLH.LE.1) OBJ.OSCILATE=0
100   FORMAT('WARNING! oscilating colimator ',a,' has only ',
     &  I2,' slits')
      IF (OBJ.OSCILATE.GT.0.AND.OBJ.NLH.LE.6) THEN
          WRITE(SOUT,100)  OBJ.FRAME.NAME,OBJ.NLH
      ENDIF
      END
      

C---------------------------------------------------------------        
      INTEGER*4 FUNCTION READ_MIRROR(QC)
C read reflectivity data for supemirror (used in BENDER by NESS)
C 1 line header + 3 columns: m, r(up), r(down)
C returns:
C if found ... the index to lookup table
C if QC=-1 ... 0, clears tables
C if QC not in (0.1,10) ... 0, no reflections
C if error ... 0, show adequate message
C---------------------------------------------------------------
      IMPLICIT NONE
      include 'const.inc'
      include 'inout.inc'
      
      INTEGER*4 IU
      PARAMETER(IU=22)      
      INTEGER*4 m_n(5),ires,INDX,i,j        
      REAL*8 mNi,Z,QC
      CHARACTER*3 SUFFIX,m_name(5)
      CHARACTER*9 FNAME
      REAL*8 m_alpha(128,5), m_ref1(128,5), m_ref2(128,5)
      COMMON /MIRROR/ m_alpha,m_ref1,m_ref2,m_n,m_name
      LOGICAL*4 VERBOSE
      INTEGER*4 NEV
      COMMON /MCSETTING/ VERBOSE,NEV

1     FORMAT(F3.1)
3     FORMAT('reflectivity (',I1,') ',a9,' , read ',I5,' lines.')      
4     FORMAT('Error ',I5,' while reading mirror table, line ',I5,' .')
5     FORMAT('found mirror table (',I1,') m=',a3,', ',I5,' lines.')      
6     FORMAT('no more space in mirror tables - clearing records')      


      mNi=QC/GammaNi
      READ_MIRROR=0
      IF(mNi.LT.0) GOTO 200   ! clear all
      IF(mNi.EQ.0) GOTO 100
      Z=LOG10(mNi)
      IF (Z.LT.-1.OR.Z.GE.1) GOTO 100  ! must be 0.1 <= mNi < 10

C get filename suffix
      SUFFIX='1.0'
      WRITE(SUFFIX,1,err=10) mNi
10    FNAME='mirror'//SUFFIX

C search for an existing table
      I=1
      DO WHILE(I.LE.5.AND.m_name(I).NE.SUFFIX.AND.m_n(I).GT.0)
         I=I+1
      ENDDO
      
C no table found, no more free space      
      IF (I.GT.5) THEN
        if (VERBOSE) write(SOUT,6)
        do j=1,5
          m_n(j)=0
          m_name(j)=' '
        enddo
        i=1
      ENDIF
      
C there is already corresponding table      
      IF  (m_name(I).EQ.SUFFIX) THEN
         if (DBGREF) write(SOUT,5) I,m_name(i),m_n(i)
         READ_MIRROR=I
         RETURN
      ENDIF
      
C load the lookup table to the first free position      
      INDX=I
      CALL OPENRESFILE(FNAME,IU,IRES,1) 
      IF(IRES.LE.0) GOTO 100 ! error while opening
      ires=0
      i=0
      Read(IU,*,iostat=ires,end=40,err=100) ! assume 1-line header
      do while(ires.eq.0.and.(i.lt.128))
          Read(IU,*,iostat=ires,end=30,err=40)
     *      m_alpha(i+1,indx), m_ref1(i+1,indx),m_ref2(i+1,indx)
          i=i+1
      enddo
      
      
C read OK      
30    CLOSE(IU)
      m_n(indx)=i
      m_name(indx)=SUFFIX
      if (VERBOSE) write(SOUT,3) INDX,FNAME,I
      READ_MIRROR=INDX
      return
      
C error while reading           
40    CLOSE(IU)
      write(SOUT,4) IRES,I
      READ_MIRROR=0
      return
      
C no reflections       
100   READ_MIRROR=0
      return

C clear tables:     
200   do j=1,5
        do i=1,128
            m_alpha(i,j)=i
            m_ref1(i,j)=0
            m_ref2(i,j)=0
        enddo
        m_n(j)=0
        m_name(j)=' '
      enddo
      READ_MIRROR=0
      return
      end


C---------------------------------------------------------------        
      SUBROUTINE READ_FLUX(FNAME)
C read flux distribution
C 1 line header + 2 columns: Lambda, dPhi/dLambda
C units are [Ang], [1e12/s/cm^2/Ang]      
C---------------------------------------------------------------
      IMPLICIT NONE
      include 'const.inc'
      include 'inout.inc'
      INCLUDE 'source.inc'
      INTEGER*4 IU
      PARAMETER(IU=22)
      INTEGER*4 ires,ilin,i,j,ic,TRUELEN       
      CHARACTER*30 FNAME,S
      CHARACTER*1024 LINE
1     FORMAT(a)              
2     FORMAT(4(2x,G10.4))              

      ires=0
      ilin=0
      flxn=0
      flxhnx=0
      flxvnx=0
      flxhna=0
      flxvna=0

C empty string => clear table and exit      
      IF (FNAME(1:1).EQ.' '.OR.FNAME(1:1).EQ.CHAR(0)) RETURN
      
      S=FNAME
      J=TRUELEN(S)
      CALL OPENRESFILE(S(1:J),IU,IRES,1) 
      IF(IRES.LE.0) GOTO 100
      Read(IU,1,iostat=ires,end=30,err=40) LINE ! assume 1-line header
      J=TRUELEN(LINE)
      FLXLOG=INDEX(LINE(1:J),'LOGSCALE')
c         if (FLXLOG.GT.0) write(*,*) 'LOGSCALE'
      ilin=ilin+1
      do while(ires.eq.0.and.(flxn.lt.256))
          Read(IU,1,iostat=ires,end=30,err=40) LINE
          ilin=ilin+1
          J=TRUELEN(LINE)
          Read(LINE(1:J),*,iostat=ires,err=20) 
     &                   flxlam(flxn+1), flxdist(flxn+1)
c       write(*,2) flxn+1,flxlam(flxn+1), flxdist(flxn+1)
          flxn=flxn+1
      enddo
      
      Read(IU,1,iostat=ires,end=30,err=40) LINE
      J=TRUELEN(LINE)
      ilin=ilin+1
c      write(*,*) '>'//LINE(1:10)//'<'
      
20    if (LINE(1:10).EQ.'HORIZONTAL') then
c       write(*,*) ' read HORIZONTAL'
         ic=0
         Read(LINE(11:J),*,iostat=ires,err=40) FLXHNX,FLXHNA,FLXHX,FLXHA
         FLXHX=FLXHX*10.D0
         if (FLXHNX.GT.64.OR.FLXHNA.GT.64)  goto 40   
         do i=1,FLXHNX
            Read(IU,1,iostat=ires,end=30,err=40) LINE
            ilin=ilin+1
            J=TRUELEN(LINE)
            Read(LINE(1:J),*,iostat=ires,err=25) (FLXHP(i,j),j=1,FLXHNA)
            ic=ic+1
         enddo
      else
         goto 30
      endif      
      Read(IU,1,iostat=ires,end=30,err=40) LINE
      J=TRUELEN(LINE)
      ilin=ilin+1
c      write(*,*) '>'//LINE(1:80)

25    if (ic.ne.FLXHNX) goto 40
      if (LINE(1:8).EQ.'VERTICAL') then
c       write(*,*) ' read VERTICAL'
         ic=0
         Read(LINE(9:J),*,iostat=ires,err=40) FLXVNX,FLXVNA,FLXVX,FLXVA
         FLXVX=FLXVX*10.D0
         if (FLXVNX.GT.64.OR.FLXVNA.GT.64)  goto 40   
         do i=1,FLXVNX
            Read(IU,1,iostat=ires,end=30,err=40) LINE
            ilin=ilin+1
            J=TRUELEN(LINE)
            Read(LINE(1:J),*,iostat=ires,err=30) (FLXVP(i,j),j=1,FLXVNA)
            ic=ic+1
        enddo
      endif      
      if (ic.ne.FLXVNX) goto 40

       
30    CLOSE(IU)
3     FORMAT('Flux table: ',I3,' lines.')
31    FORMAT('Flux table with 2D distributions: ',I3,' lines, dim=',
     &      4(1x,I3))
      if (FLXHNX.GT.0) then
        write(SOUT,31) flxn,FLXHNX,FLXHNA,FLXVNX,FLXVNA
      else
        write(SOUT,3) flxn
      endif
      
      IF (FLXLOG.GT.0) THEN
         FLXDLAM=LOG(FLXLAM(FLXN)/FLXLAM(1))/(FLXN-1)
      ELSE
         FLXDLAM=(FLXLAM(FLXN)-FLXLAM(1))/(FLXN-1)
      ENDIF
      
      return

40    CLOSE(IU)
      flxn=0
      flxhnx=0
      flxvnx=0
      flxhna=0
      flxvna=0
4     FORMAT('Error ',I5,' while reading flux table, line ',I5,' .')
      write(SOUT,4) IRES,ilin
      return
      
100   flxn=0
      write (SOUT,*) 'Cannot open flux table: <'//S(1:J)//'>'
      return
      end



C----------------------------------------
      SUBROUTINE GETSTATE(ITASK,NEVENT)
C----------------------------------------
      implicit none

      INCLUDE 'const.inc'
      INCLUDE 'inout.inc'
      INCLUDE 'structures.inc'
      INCLUDE 'ness_common.inc'
      
      integer*4 ITASK,NEVENT
            
5     format(1x,a8,$)
6     format(1x,I8,$)
7     format(1x,F8.6,$)
            
C// Write header      
      IF (ITASK.LE.2.OR.ITASK.EQ.4.OR.ITASK.EQ.6.OR.ITASK.EQ.11) THEN        
        write(*,5) SOL2.frame.NAME
        write(*,5) SOL2A.frame.NAME
        write(*,5) MON.frame.NAME
        write(*,5) SOL1.frame.NAME
        write(*,5) GUIDE.frame.NAME
        write(*,5) GDEA.frame.NAME
        write(*,5) SOU.NAME
        write(*,5) SAM.NAME
      ELSE IF (ITASK.EQ.3.OR.ITASK.EQ.5.OR.ITASK.EQ.7) THEN 
        write(*,5) SOU.NAME
        write(*,5) GDEA.frame.NAME
        write(*,5) GUIDE.frame.NAME
        write(*,5) SOL1.frame.NAME
        write(*,5) MON.frame.NAME
        write(*,5) SOL2A.frame.NAME
        write(*,5) SOL2.frame.NAME
        write(*,5) SAM.NAME
      ENDIF
      IF (ITASK.EQ.4.OR.ITASK.EQ.5.OR.ITASK.EQ.9) THEN        
        write(*,5) SOL3.frame.NAME
        write(*,5) DET.FRAME.NAME
      ELSE IF (ITASK.EQ.1.OR.ITASK.EQ.6.OR.ITASK.EQ.7.OR.
     &         ITASK.EQ.11) THEN 
        write(*,5) SOL3.frame.NAME
        write(*,5) ANA.frame.NAME
        write(*,5) SOL4.frame.NAME
        write(*,5) DET.FRAME.NAME
      ELSE IF (ITASK.EQ.8) THEN 
        write(*,5) SAM.NAME
        write(*,5) SOL3.frame.NAME
        write(*,5) ANA.frame.NAME
        write(*,5) SOL4.frame.NAME
        write(*,5) DET.FRAME.NAME
      ENDIF  
      WRITE(*,*)
C// Write counts     
      IF (ITASK.LE.2.OR.ITASK.EQ.4.OR.ITASK.EQ.6.OR.ITASK.EQ.11) THEN        
        write(*,6) SOL2.frame.COUNT
        write(*,6) SOL2A.frame.COUNT
        write(*,6) MON.frame.COUNT
        write(*,6) SOL1.frame.COUNT
        write(*,6) GUIDE.frame.COUNT
        write(*,6) GDEA.frame.COUNT
        write(*,6) SOU.COUNT
        write(*,6) SAM.COUNT
      ELSE IF (ITASK.EQ.3.OR.ITASK.EQ.5.OR.ITASK.EQ.7) THEN 
        write(*,6) SOU.COUNT
        write(*,6) GDEA.frame.COUNT
        write(*,6) GUIDE.frame.COUNT
        write(*,6) SOL1.frame.COUNT
        write(*,6) MON.frame.COUNT
        write(*,6) SOL2A.frame.COUNT
        write(*,6) SOL2.frame.COUNT
        write(*,6) SAM.COUNT
      ENDIF
      IF (ITASK.EQ.4.OR.ITASK.EQ.5.OR.ITASK.EQ.9) THEN        
        write(*,6) SOL3.frame.COUNT
        write(*,6) DET.FRAME.COUNT
      ELSE IF (ITASK.EQ.1.OR.ITASK.EQ.6.OR.ITASK.EQ.7.OR.
     &         ITASK.EQ.11) THEN 
        write(*,6) SOL3.frame.COUNT
        write(*,6) ANA.frame.COUNT
        write(*,6) SOL4.frame.COUNT
        write(*,6) DET.FRAME.COUNT
      ELSE IF (ITASK.EQ.8) THEN 
        write(*,6) SAM.COUNT
        write(*,6) SOL3.frame.COUNT
        write(*,6) ANA.frame.COUNT
        write(*,6) SOL4.frame.COUNT
        write(*,6) DET.FRAME.COUNT
      ENDIF  
      WRITE(*,*)
C// Write transmissions     
      IF (ITASK.LE.2.OR.ITASK.EQ.4.OR.ITASK.EQ.6.OR.ITASK.EQ.11) THEN        
        if (NEVENT.GT.0) write(*,7) 1.*SOL2.frame.COUNT/NEVENT
        if (SOL2.frame.COUNT.GT.0) 
     *      write(*,7) 1.*SOL2A.frame.COUNT/SOL2.frame.COUNT
        if (SOL2A.frame.COUNT.GT.0) 
     *      write(*,7) 1.*MON.frame.COUNT/SOL2A.frame.COUNT
        if (MON.frame.COUNT.GT.0) 
     *      write(*,7) 1.*SOL1.frame.COUNT/MON.frame.COUNT
        if (SOL1.frame.COUNT.GT.0) 
     *      write(*,7) 1.*GUIDE.frame.COUNT/SOL1.frame.COUNT
        if (GUIDE.frame.COUNT.GT.0) 
     *      write(*,7) 1.*GDEA.frame.COUNT/GUIDE.frame.COUNT
        if (GDEA.frame.COUNT.GT.0) 
     *      write(*,7) 1.*SOU.COUNT/GDEA.frame.COUNT
        if (SOU.COUNT.GT.0) write(*,7) 1.*SAM.COUNT/SOU.COUNT
      ELSE IF (ITASK.EQ.3.OR.ITASK.EQ.5.OR.ITASK.EQ.7) THEN
        if (NEVENT.GT.0) write(*,7) 1.*SOU.COUNT/NEVENT
        if (SOU.COUNT.GT.0) write(*,7) 1.*GDEA.frame.COUNT/SOU.COUNT
        if (GDEA.frame.COUNT.GT.0) 
     *      write(*,7) 1.*GUIDE.frame.COUNT/GDEA.frame.COUNT
        if (GUIDE.frame.COUNT.GT.0) 
     *      write(*,7) 1.*SOL1.frame.COUNT/GUIDE.frame.COUNT
        if (SOL1.frame.COUNT.GT.0) 
     *      write(*,7) 1.*MON.frame.COUNT/SOL1.frame.COUNT
        if (MON.frame.COUNT.GT.0) 
     *      write(*,7) 1.*SOL2A.frame.COUNT/MON.frame.COUNT
        if (SOL2A.frame.COUNT.GT.0) 
     *      write(*,7) SOL2.frame.COUNT/SOL2A.frame.COUNT
        if (SOL2.frame.COUNT.GT.0) 
     *      write(*,7) 1.*SAM.COUNT/SOL2.frame.COUNT
      ENDIF
      IF (ITASK.EQ.4.OR.ITASK.EQ.5) THEN        
        if (SAM.COUNT.GT.0) 
     *      write(*,7) 1.*SOL3.frame.COUNT/SAM.COUNT
        if (SOL3.frame.COUNT.GT.0) 
     *      write(*,7) 1.*DET.FRAME.COUNT/SOL3.frame.COUNT
      ELSE IF (ITASK.EQ.1.OR.ITASK.EQ.6.OR.ITASK.EQ.7.OR.
     &        ITASK.EQ.11) THEN 
        if (SAM.COUNT.GT.0) 
     *      write(*,7) 1.*SOL3.frame.COUNT/SAM.COUNT
        if (SOL3.frame.COUNT.GT.0) 
     *      write(*,7) 1.*ANA.frame.COUNT/SOL3.frame.COUNT
        if (ANA.frame.COUNT.GT.0) 
     *      write(*,7) 1.*SOL4.frame.COUNT/ANA.frame.COUNT
        if (SOL4.frame.COUNT.GT.0) 
     *      write(*,7) 1.*DET.FRAME.COUNT/SOL4.frame.COUNT
      ELSE IF (ITASK.EQ.8) THEN 
        if (NEVENT.GT.0) 
     *      write(*,7) 1.*SAM.COUNT/NEVENT
        if (SAM.COUNT.GT.0) 
     *      write(*,7) 1.*SOL3.frame.COUNT/SAM.COUNT
        if (SOL3.frame.COUNT.GT.0) 
     *      write(*,7) 1.*ANA.frame.COUNT/SOL3.frame.COUNT
        if (ANA.frame.COUNT.GT.0) 
     *      write(*,7) 1.*SOL4.frame.COUNT/ANA.frame.COUNT
        if (SOL4.frame.COUNT.GT.0) 
     *      write(*,7) 1.*DET.FRAME.COUNT/SOL4.frame.COUNT
      ELSE IF (ITASK.EQ.9) THEN 
        if (NEVENT.GT.0) 
     *      write(*,7) 1.*SOL3.frame.COUNT/NEVENT
        if (SOL3.frame.COUNT.GT.0) 
     *      write(*,7) 1.*DET.FRAME.COUNT/SOL3.frame.COUNT
      ENDIF  
      WRITE(*,*)
        
      END



C---------------------------------------------------
        SUBROUTINE SLIT_WRITE(IU,OBJECT)
C     Writes parameters of OBJECT to unit U
C--------------------------------------------------
      IMPLICIT NONE

      INCLUDE 'const.inc'
      INCLUDE 'structures.inc'
      INTEGER*4 IU,I
      RECORD /SLIT/ OBJECT

1     FORMAT(A30)
2     FORMAT(' size : ',3(2x,F9.3))
3     FORMAT(' pos  : ',3(2x,F9.1))
5     FORMAT(' gon  : ',3(2x,F9.1))
4     FORMAT(' distance, omega,phi,shape: ',3(2x,F9.1),5x,I1)

      WRITE(IU,*) '************************************'
      WRITE(IU,1) OBJECT.NAME
      WRITE(IU,*) '************************************'
      WRITE(IU,2) (OBJECT.SIZE(I),I=1,3)
      WRITE(IU,3) (OBJECT.POS(I),I=1,3)
      WRITE(IU,5) (OBJECT.GON(I)*180/PI,I=1,3)
      WRITE(IU,4) OBJECT.DIST,OBJECT.AXI*180/PI,OBJECT.AXV*180/PI,
     *  OBJECT.SHAPE

      RETURN
      END

C---------------------------------------------------
        SUBROUTINE CRYST_WRITE(IU,OBJECT)
C     Writes parameters of OBJECT to unit U
C--------------------------------------------------
      IMPLICIT NONE

      INCLUDE 'const.inc'
      INCLUDE 'structures.inc'
      INTEGER*4 IU,I
      REAL*8 GETEFFMOS, GETDTH

      RECORD /CRYSTAL/ OBJECT
1     FORMAT(' nh,nv,nb: ',3(2x,I3))
12    FORMAT(' spaces: ',3(2x,G10.4))
2     FORMAT(' G0 : ',3(2x,F8.3))
3     FORMAT(' dG : ',3(2x,E12.3))
7     FORMAT(' lambda,dhkl,thb,chi: ',4(2x,F8.3))
8     FORMAT(' curvatures (h,v,z): ',3(2x,G10.4))
9     FORMAT(' hmos,vmos,etamax,effmos,dthb: ',5(2x,F7.2))
10    FORMAT(' Qhkl,DW,mi,ref: ',4(2x,G12.4))
11    FORMAT(' dExt,dLam,Ext1: ',3(2x,G12.4))


      CALL SLIT_WRITE(IU,OBJECT.FRAME)
      WRITE(IU,*)
      WRITE(IU,1) OBJECT.NH,OBJECT.NV,OBJECT.NB
      WRITE(IU,12) OBJECT.DH,OBJECT.DV,OBJECT.DB
      WRITE(IU,7) OBJECT.LAMBDA,OBJECT.DHKL,OBJECT.THB*180/PI,
     1            OBJECT.CHI*180/PI
      WRITE(IU,8) OBJECT.RH*1000,OBJECT.RV*1000,OBJECT.RB*1000
      WRITE(IU,9) OBJECT.HMOS*180*60/PI,OBJECT.VMOS*180*60/PI,
     1              OBJECT.DETA*180*60/PI,GETEFFMOS(OBJECT)*180*60/PI,
     &              GETDTH(OBJECT)*180*60/PI
      WRITE(IU,10) OBJECT.QHKL,OBJECT.DW,OBJECT.MI,OBJECT.REF
      WRITE(IU,11) OBJECT.DEXT,OBJECT.DLAM,OBJECT.EXT1
      WRITE(IU,2) (OBJECT.G(I),I=1,3)
      WRITE(IU,3) (OBJECT.DG_DR(1,I),I=1,3)
      WRITE(IU,3) (OBJECT.DG_DR(2,I),I=1,3)
      WRITE(IU,3) (OBJECT.DG_DR(3,I),I=1,3)

      RETURN
      END

C---------------------------------------------------
        SUBROUTINE BENDER_WRITE(IU,OBJECT)
C     Writes parameters of OBJECT to unit U
C--------------------------------------------------
      IMPLICIT NONE

      INCLUDE 'const.inc'
      INCLUDE 'structures.inc'
      INTEGER*4 IU

      RECORD /BENDER/ OBJECT

2     FORMAT(' nlh,nlv : ',2(2x,I4),a11)
3     FORMAT(' w2,h2 : ',2(2x,F8.1))
4     FORMAT(' crit. angles : ',6(2x,E12.3))
5     FORMAT(' 1/RH, 1/RV  : ',2(E12.3,2x))
51    FORMAT(' focal distances (H,V)  : ',2(G10.4,2x))
6     FORMAT(' dlh,dlv : ',2(2x,F8.3))
7     FORMAT(' reflectivities : ',6(2x,F8.3))
8     FORMAT(' ref. indexes : ',6(2x,I2))

      CALL SLIT_WRITE(IU,OBJECT.FRAME)
      IF (OBJECT.TYP.LT.0) THEN 
        write(IU,*) 'ignored'
      ELSE IF (OBJECT.TYP.EQ.0) THEN 
        write(IU,*) 'collimator'
      ELSE IF (OBJECT.TYP.EQ.1) THEN 
        write(IU,*) 'guide'
      ELSE IF (OBJECT.TYP.EQ.2) THEN 
        write(IU,*) 'parabolic guide'
      ELSE IF (OBJECT.TYP.EQ.3) THEN 
        write(IU,*) 'parabolic guide with optimized slit lengths'
      ELSE IF (OBJECT.TYP.EQ.4) THEN 
        write(IU,*) 'elliptic guide'
      ENDIF
      
      WRITE(IU,*)
      WRITE(IU,3) OBJECT.w2, OBJECT.h2
      IF (OBJECT.OSCILATE.GT.0) THEN
          WRITE(IU,2) OBJECT.nlH,OBJECT.nlV,' oscilating'
      ELSE
          WRITE(IU,2) OBJECT.nlH,OBJECT.nlV
      ENDIF
      WRITE(IU,6) OBJECT.dlH,OBJECT.dlV
      WRITE(IU,4) OBJECT.GHLU,OBJECT.GHLD,OBJECT.GHRU,OBJECT.GHRD,
     1            OBJECT.GVT,OBJECT.GVB
      WRITE(IU,7) OBJECT.RHLU,OBJECT.RHLD,OBJECT.RHRU,OBJECT.RHRD,
     1            OBJECT.RVT,OBJECT.RVB
      WRITE(IU,8) OBJECT.NHLU,OBJECT.NHLD,OBJECT.NHRU,OBJECT.NHRD,
     1            OBJECT.NVT,OBJECT.NVB
      IF (OBJECT.TYP.GT.1) THEN 
         WRITE(IU,51) OBJECT.CH,OBJECT.CV
      ELSE
         WRITE(IU,5)  OBJECT.CH,OBJECT.CV
      ENDIF
      END

C---------------------------------------------------
        SUBROUTINE DETECT_WRITE(IU,OBJECT)
C     Writes parameters of OBJECT to unit U
C--------------------------------------------------
      IMPLICIT NONE

      INCLUDE 'const.inc'
      INCLUDE 'structures.inc'
      INTEGER*4 IU

      RECORD /DETECTOR/ OBJECT

2     FORMAT(' alpha [1/A/cm]: ',G12.4)
3     FORMAT(' No. of segments : ',I3)
4     FORMAT(' gap [mm] : ',G12.4)
5     FORMAT(' tilt [deg] : ',G12.4)

      CALL SLIT_WRITE(IU,OBJECT.FRAME)
      WRITE(IU,*)
      WRITE(IU,2) OBJECT.ALPHA*10.
      WRITE(IU,3) OBJECT.ND
      WRITE(IU,4) OBJECT.SPACE
      WRITE(IU,5) OBJECT.FRAME.GON(2)*180/PI
      RETURN
      END




C---------------------------------------------------
      SUBROUTINE WRITE_SETUP(IC,ITASK)
C     Writes actual parameters of the setup
C---------------------------------------------------
      IMPLICIT NONE

      INCLUDE 'const.inc'
      INCLUDE 'inout.inc'
      INCLUDE 'structures.inc'
      INCLUDE 'ness_common.inc'

      INTEGER*4 IC,ITASK

c      REAL*8 Z1,Z2,Z3,fwhm1,fwhm2

5     FORMAT(' w2,h2: ',2(2x,F7.1))
6     FORMAT(' nl: ',I4)
10    FORMAT(' a',I1,': ',F8.3)
11    FORMAT(' KI,KF,Q: ',4(2x,F8.3))

      IF(IC.NE.6) Open(Unit=ic,File='res_setup.txt',err=999,
     1            Status='Unknown')

      WRITE(IC,*) 'Configuration ',CFGNAME
      CALL SLIT_WRITE(IC,SOU)
       WRITE(IC,*)
      CALL BENDER_WRITE(IC,GDEa)
       WRITE(IC,*)
      CALL BENDER_WRITE(IC,GUIDE)
       WRITE(IC,*)
      CALL BENDER_WRITE(IC,SOL1)
       WRITE(IC,*)
      CALL CRYST_WRITE(IC,MON)
       WRITE(IC,*)
      CALL BENDER_WRITE(IC,SOL2a)
       WRITE(IC,*)
      CALL BENDER_WRITE(IC,SOL2)
       WRITE(IC,*)
      CALL SLIT_WRITE(IC,SAM)
       WRITE(IC,*)
      CALL BENDER_WRITE(IC,SOL3)
       WRITE(IC,*)
      IF (ITASK.NE.4.AND.ITASK.NE.5.AND.ITASK.NE.9) THEN
        CALL CRYST_WRITE(IC,ANA)
           WRITE(IC,*)
        CALL BENDER_WRITE(IC,SOL4)
           WRITE(IC,*)
      ENDIF  
      CALL DETECT_WRITE(IC,DET)
        WRITE(IC,*)
c12    FORMAT(' range etam: +-',E12.4,'   r: ',3(2x,E12.3))
c13    FORMAT(' range etaa: +-',E12.4,'   r: ',3(2x,E12.3))
c      WRITE(IC,13) ABS(X_CR(1,2)),Y_CR(1,2),Y_CR(N_CR/2,2),Y_CR(N_CR,2)
c      CALL GETREFPAR(MON,MON.lambda,MON.QHKL,MON.MI,Z1,Z2,Z3,fwhm1)
c      CALL GETREFPAR(ANA,ANA.lambda,ANA.QHKL,ANA.MI,Z1,Z2,Z3,fwhm2)
c14    FORMAT(' fwhm [min] mon: = ',G12.5,'  anal: ',G12.5)
c      WRITE(IC,14) fwhm1*60*180/PI,fwhm2*60*180/PI
      WRITE(IC,*)
      WRITE(IC,*) 'AXES:'
      WRITE(IC,10) 1,MON.FRAME.GON(1)*180/PI
      IF (SOL1.FRAME.AXI.NE.0) THEN
         WRITE(IC,10) 2,SOL1.FRAME.AXI*180/PI
      ELSE
         WRITE(IC,10) 2,SOL2.FRAME.AXI*180/PI
      ENDIF
      WRITE(IC,10) 4,SOL3.FRAME.AXI*180/PI
c      WRITE(IC,10) 5,ANA.FRAME.GON(1)*180/PI
c      WRITE(IC,10) 6,SOL4.FRAME.AXI*180/PI
      WRITE(IC,*)
      WRITE(IC,11) STP.KI,STP.KF,STP.Q ! ,STP.E
      IF(IC.NE.6) close(ic)
C      WRITE(*,*) 'Setup written'
      RETURN
999   write(*,*) 'Cannot open file for output!'
      return
      END


C------------------------------------------------------------------------
      SUBROUTINE APERTURE2(ITASK,AHMAX,avmax)
C  Calculate maximum angular deviations transmitted through the instrument
C  for the SECONDARY spectrometer (sample-detector) 
C--------------------------------------------------------
      implicit NONE

      INCLUDE 'const.inc'
      INCLUDE 'inout.inc'
      INCLUDE 'structures.inc'
      INCLUDE 'ness_common.inc'

      REAL*8  ahmax,avmax
      INTEGER*4 ITASK,I
      REAL*8 A(20),L1,D1,L2,D2,B1,B2,ksi,stmch,stpch,Z

c Horizontal, sample-detector      
c--------------------------------      
      
      DO I=1,20
        A(I)=1E30
      ENDDO  
      
C Colim. 3
      L1=SOL3.FRAME.DIST
      D1=SAM.SIZE(1)+SOL3.FRAME.SIZE(1)
      IF (L1.GT.1e-10) A(1)=D1/L1
      
      L1=SOL3.FRAME.DIST+SOL3.FRAME.SIZE(3)
      D1=SAM.SIZE(1)+SOL3.W2
      IF (L1.GT.1e-10) A(2)=D1/L1
      
      IF (SOL3.FRAME.SIZE(3).GT.1D-10) THEN
        B1=(SOL3.W2+SOL3.FRAME.SIZE(1))/SOL3.FRAME.SIZE(3)/SOL3.NLH
      ELSE
        B1=1.D30
      ENDIF    
      B2=SOL3.GHLU*4*PI/STP.KF
      IF (L1.GT.1e-10) A(3)=MAX(B1,B2)
      
      IF (IMONIT.EQ.8) GOTO 10
            
      IF (ITASK.EQ.4.OR.ITASK.EQ.5) THEN
C 2-axis diffractometer: only Colim.3 and detector
         L1=SOL3.FRAME.DIST+DET.FRAME.DIST
         D1=SAM.SIZE(1)+DET.FRAME.SIZE(1)  
         IF (L1.GT.1e-10) A(4)=D1/L1
         GOTO 10      
      ELSE      
C Analyzer
         L1=SOL3.FRAME.DIST+ANA.FRAME.DIST
         D1=SAM.SIZE(1)+ABS(ANA.FRAME.SIZE(1)*SIN(ANA.THB-ANA.CHI))+
     *      ABS(ANA.FRAME.SIZE(3)*COS(ANA.THB-ANA.CHI))  
         IF (L1.GT.1e-10) A(4)=D1/L1      
      ENDIF       
      
      IF (ANA.NH.GT.1.OR.ANA.HMOS.LE.SEC) THEN
         Z=1.D0
      ELSE
         Z=0.D0
      ENDIF       

      L1=SOL3.FRAME.DIST+ANA.FRAME.DIST
      D1=SAM.SIZE(1)+ ABS(ANA.FRAME.SIZE(3)*COS(ANA.THB-ANA.CHI))
      IF(ANA.NH.GT.1) THEN
        D1=D1+ABS(ANA.FRAME.SIZE(1)*SIN(ANA.THB-ANA.CHI))/ANA.NH
      ENDIF  
      stmch=sin(ANA.THB-ANA.CHI)      
      stpch=sin(ANA.THB+ANA.CHI)
      if (stmch.lt.1D-10) stmch=1D-10
            
C Colim. 4
      L2=SOL4.FRAME.DIST
      D2=SOL4.FRAME.SIZE(1)
      ksi=stmch/stpch-2*Z*ANA.RH*L2/stmch
      if (ABS(L2+L1*ksi).GT.1.D-10) THEN
        A(5)=(D2+ABS(D1*ksi))/(L2+L1*ksi)
      ENDIF

      IF (IMONIT.EQ.9) GOTO 10
      
      L2=SOL4.FRAME.DIST+SOL4.FRAME.SIZE(3)
      D2=SOL4.W2
      ksi=stmch/stpch-2*Z*ANA.RH*L2/stmch
      if (ABS(L2+L1*ksi).GT.1.D-10) THEN
        A(6)=(D2+ABS(D1*ksi))/(L2+L1*ksi)
      ENDIF
      
      IF (SOL4.FRAME.SIZE(3).GT.1D-10) THEN
        B1=(SOL4.W2+SOL4.FRAME.SIZE(1))/SOL4.FRAME.SIZE(3)/SOL4.NLH
      ELSE
        B1=1.D30
      ENDIF    
      B2=SOL4.GHLU*4*PI/STP.KF
      A(7)=MAX(B1,B2)
            
      IF (IMONIT.EQ.10) GOTO 10
      
C Detector
      L2=SOL4.FRAME.DIST+DET.FRAME.DIST
      D2=DET.FRAME.SIZE(1)
      ksi=stmch/stpch-2*Z*ANA.RH*L2/stmch
      if (ABS(L2+L1*ksi).GT.1.D-10) THEN
        A(8)=(D2+ABS(D1*ksi))/(L2+L1*ksi)
      ENDIF
      
10    ahmax=1D30
      DO I=1,20
        ahmax=MIN(ahmax,ABS(A(I)))
      ENDDO
      
c Vertical, sample-detector      
c--------------------------------      
      
      DO I=1,20
        A(I)=1E30
      ENDDO  
      
C Colim. 3
      L1=SOL3.FRAME.DIST
      D1=SAM.SIZE(2)+SOL3.FRAME.SIZE(2)
      IF (L1.GT.1e-10) A(1)=D1/L1
      
      L1=SOL3.FRAME.DIST+SOL3.FRAME.SIZE(3)
      D1=SAM.SIZE(2)+SOL3.H2
      IF (L1.GT.1e-10) A(2)=D1/L1
      
      IF (SOL3.FRAME.SIZE(3).GT.1D-10) THEN
        B1=(SOL3.H2+SOL3.FRAME.SIZE(2))/SOL3.FRAME.SIZE(3)/SOL3.NLV
      ELSE
        B1=1.D30
      ENDIF    
      B2=SOL3.GVT*4*PI/STP.KF
      A(3)=MAX(B1,B2)
      
      IF (IMONIT.EQ.8) GOTO 20
            
      IF (ITASK.EQ.4.OR.ITASK.EQ.5.OR.ITASK.EQ.9) THEN
C 2-axis diffractometer: only Colim.3 and detector
         L1=SOL3.FRAME.DIST+DET.FRAME.DIST
         D1=SAM.SIZE(2)+DET.FRAME.SIZE(2)  
         IF (L1.GT.1e-10) A(4)=D1/L1
         GOTO 20      
      ELSE
C Analyzer
         L1=SOL3.FRAME.DIST+ANA.FRAME.DIST
         D1=SAM.SIZE(2)+ANA.FRAME.SIZE(2) 
         IF (L1.GT.1e-10)  A(4)=D1/L1
      ENDIF       
      
      L1=SOL3.FRAME.DIST+ANA.FRAME.DIST
      D1=SAM.SIZE(2)
      IF(ANA.NV.GT.1) THEN
        D1=D1+ANA.FRAME.SIZE(2)/ANA.NV
      ENDIF  

      IF (ANA.NV.GT.1) THEN
         Z=1.D0
      ELSE
         Z=0.D0
      ENDIF       
            
C Colim. 4
      L2=SOL4.FRAME.DIST
      D2=SOL4.FRAME.SIZE(2)
      ksi=1-2*sin(ANA.THB)*cos(ANA.CHI)*Z*ANA.RV*L2
      if (ABS(L2+L1*ksi).GT.1.D-10) THEN
        A(5)=(D2+ABS(D1*ksi))/(L2+L1*ksi)
      ENDIF
      
      IF (IMONIT.EQ.9) GOTO 20

      L2=SOL4.FRAME.DIST+SOL4.FRAME.SIZE(3)
      D2=SOL4.H2
      ksi=1-2*sin(ANA.THB)*cos(ANA.CHI)*Z*ANA.RV*L2
      if (ABS(L2+L1*ksi).GT.1.D-10) THEN
        A(6)=(D2+ABS(D1*ksi))/(L2+L1*ksi)
      ENDIF
      
      IF (SOL4.FRAME.SIZE(3).GT.1D-10) THEN
        B1=(SOL4.H2+SOL4.FRAME.SIZE(2))/SOL4.FRAME.SIZE(3)/SOL4.NLV
      ELSE
        B1=1.D30
      ENDIF    
      B2=SOL4.GVT*4*PI/STP.KF
      A(7)=MAX(B1,B2)
            
      IF (IMONIT.EQ.10) GOTO 20
      
C Detector
      L2=SOL4.FRAME.DIST+DET.FRAME.DIST
      D2=DET.FRAME.SIZE(2)
      ksi=1-2*sin(ANA.THB)*cos(ANA.CHI)*Z*ANA.RV*L2
      if (ABS(L2+L1*ksi).GT.1.D-10) THEN
        A(8)=(D2+ABS(D1*ksi))/(L2+L1*ksi)
      ENDIF
      
20    avmax=1D30
      DO I=1,20
        avmax=MIN(avmax,ABS(A(I)))
      ENDDO
      
c      IF(ANA.NV.GT.1) THEN
c         D1=ANA.FRAME.SIZE(2)/ANA.NV
c         L1=SOL3.FRAME.DIST+ANA.FRAME.DIST
c         AVMAX=AVMAX+ABS(D1/L1)
c      ENDIF   
      
      END



C------------------------------------------------------------------------
      SUBROUTINE APERTURE1(ITASK,ahmax,avmax,wmax,hmax,band)
C  Calculate maximum angular deviations transmitted through the instrument
C  for the PRIMARY spectrometer (sample-source) 
C--------------------------------------------------------
      implicit NONE

      INCLUDE 'const.inc'
      INCLUDE 'inout.inc'
      INCLUDE 'structures.inc'
      INCLUDE 'ness_common.inc'

      REAL*8  ahmax,avmax,wmax,hmax,band
      INTEGER*4 ITASK,I
      REAL*8 A(20),B(30),C(30)
      REAL*8 L1,D1,L2,D2,ksi,stmch,stpch,ctmch,ctpch,sgnm,Z
      REAL*8 a1,a2,a3,W2,H2,F1,ETA
      REAL*8 ah1,ah2,ah3,av1,av2,av3
      REAL*8 G1,G2,G3,G4,G5
      REAL*8 GETEFFMOS

c      write(*,*) 'APERTURE1 entry'

c Horizontal, sample->source      
c--------------------------------      
      
      DO I=1,20
        A(I)=1E30
      ENDDO        
      DO I=1,30
        B(I)=1E30
      ENDDO        
      DO I=1,20
        C(I)=1E30
      ENDDO        

C Colim. 2
      G1=SOL2.GHLU*4*PI/STP.KI
      W2=SOL2.FRAME.SIZE(1)

      L1=SOL2.FRAME.DIST
      D1=SAM.SIZE(1)+W2
      IF (L1.GT.1e-10) A(1)=D1/L1
C----            
      W2=SOL2.W2
      L1=SOL2.FRAME.DIST+SOL2.FRAME.SIZE(3)
      D1=SAM.SIZE(1)+W2
      IF (L1.GT.1e-10) A(2)=MAX(D1/L1,G1)
      
      L1=SOL2.FRAME.SIZE(3)
      D1=(W2+SOL2.FRAME.SIZE(1))/SOL2.NLH
      IF (L1.GT.1e-10) A(3)=MAX(D1/L1,G1)
            
C Colim. 2A
      G2=SOL2a.GHLU*4*PI/STP.KI
      W2=SOL2a.FRAME.SIZE(1)
      
      L1=SOL2a.FRAME.DIST+SOL2.FRAME.DIST
      D1=SAM.SIZE(1)+W2  
      IF (L1.GT.1e-10) A(4)=MAX(D1/L1,G1)
      
      L1=L1-SOL2.FRAME.DIST
      D1=SOL2.FRAME.SIZE(1)+W2  
      IF (L1.GT.1e-10) A(5)=MAX(D1/L1,G1)
      
      L1=L1-SOL2.FRAME.SIZE(3)
      D1=SOL2.W2+W2  
      IF (L1.GT.1e-10) A(6)=MAX(D1/L1,G1)
C----      
      W2=SOL2a.W2
      
      L1=SOL2.FRAME.DIST+SOL2a.FRAME.DIST+SOL2a.FRAME.SIZE(3)
      D1=SAM.SIZE(1)+W2
      IF (L1.GT.1e-10) A(7)=MAX(D1/L1,G1,G2)

      L1=L1-SOL2.FRAME.DIST
      D1=SOL2.FRAME.SIZE(1)+W2
      IF (L1.GT.1e-10) A(8)=MAX(D1/L1,G1,G2)

      L1=L1-SOL2.FRAME.SIZE(3)
      D1=SOL2.W2+W2
      IF (L1.GT.1e-10) A(9)=MAX(D1/L1,G1,G2)

      L1=SOL2a.FRAME.SIZE(3)
      D1=(W2+SOL2a.FRAME.SIZE(1))/SOL2a.NLH
      IF (L1.GT.1e-10) A(10)=MAX(D1/L1,G2)

C Monochromator
      sgnm=-sign(1,stp.sm) ! "minus" because of the up-stream tracing
      stmch=SIN(MON.THB-sgnm*MON.CHI) 
      stpch=SIN(MON.THB+sgnm*MON.CHI) 
      ctmch=COS(MON.THB-sgnm*MON.CHI) 
      ctpch=COS(MON.THB+sgnm*MON.CHI) 
      if (ABS(stmch).lt.1D-10) stmch=1D-10
      if (ABS(stpch).lt.1D-10) stpch=1D-10
      W2=ABS(MON.FRAME.SIZE(1)*STMCH)+ABS(MON.FRAME.SIZE(3)*CTMCH)
      
      L1=SOL2.FRAME.DIST+SOL2a.FRAME.DIST+MON.FRAME.DIST
      D1=SAM.SIZE(1)+W2  
      IF (L1.GT.1e-10) A(11)=MAX(D1/L1,G1,G2)

      L1=L1-SOL2.FRAME.DIST
      D1=SOL2.FRAME.SIZE(1)+W2  
      IF (L1.GT.1e-10) A(12)=MAX(D1/L1,G1,G2)

      L1=L1-SOL2.FRAME.SIZE(3)
      D1=SOL2.W2+W2
      IF (L1.GT.1e-10) A(13)=MAX(D1/L1,G1,G2)

      L1=MON.FRAME.DIST
      D1=SOL2a.FRAME.SIZE(1)+W2
      IF (L1.GT.1e-10) A(14)=MAX(D1/L1,G1,G2)

      L1=L1-SOL2a.FRAME.SIZE(3)
      D1=SOL2a.W2+W2
      IF (L1.GT.1e-10) A(15)=MAX(D1/L1,G1,G2)
      
      ah1=1.D30
      DO I=1,20
        ah1=MIN(ah1,ABS(A(I)))
      ENDDO

c      do i=1,20
c        if(ah1.eq.abs(a(i))) write(*,*) 'a: ', i,a(i) 
c      enddo

C// End of primary part (before monochromator)

C Colim. 1
      W2=SOL1.FRAME.SIZE(1)
      G3=SOL1.GHLU*4*PI/STP.KI

      L1=SOL1.FRAME.DIST
      D1=ABS(MON.FRAME.SIZE(1)*STPCH)+ABS(MON.FRAME.SIZE(3)*CTPCH)+W2  
      IF (L1.GT.1e-10) B(1)=D1/L1
C---------
      W2=SOL1.W2

      L1=SOL1.FRAME.DIST+SOL1.FRAME.SIZE(3)
      D1=ABS(MON.FRAME.SIZE(1)*STPCH)+ABS(MON.FRAME.SIZE(3)*CTPCH)+W2  
      IF (L1.GT.1e-10) B(2)=MAX(D1/L1,G3)

      L1=SOL1.FRAME.SIZE(3)
      D1=(W2+SOL1.FRAME.SIZE(1))/SOL1.NLH
      IF (L1.GT.1e-10) B(3)=MAX(D1/L1,G3)

C Guide B
      W2=GUIDE.FRAME.SIZE(1)
      G4=GUIDE.GHLU*4*PI/STP.KI

      L1=SOL1.FRAME.DIST+GUIDE.FRAME.DIST
      D1=ABS(MON.FRAME.SIZE(1)*STPCH)+ABS(MON.FRAME.SIZE(3)*CTPCH)+W2  
      IF (L1.GT.1e-10) B(4)=MAX(D1/L1,G3)

      L1=GUIDE.FRAME.DIST
      D1=SOL1.FRAME.SIZE(1)+W2  
      IF (L1.GT.1e-10) B(5)=MAX(D1/L1,G3)

      L1=GUIDE.FRAME.DIST-SOL1.FRAME.SIZE(3)
      D1=SOL1.W2+W2  
      IF (L1.GT.1e-10) B(6)=MAX(D1/L1,G3)
C---------
      W2=GUIDE.W2

      L1=SOL1.FRAME.DIST+GUIDE.FRAME.DIST+GUIDE.FRAME.SIZE(3)
      D1=ABS(MON.FRAME.SIZE(1)*STPCH)+ABS(MON.FRAME.SIZE(3)*CTPCH)+W2  
      IF (L1.GT.1e-10) B(7)=MAX(D1/L1,G3,G4)

      L1=GUIDE.FRAME.DIST+GUIDE.FRAME.SIZE(3)
      D1=SOL1.FRAME.SIZE(1)+W2  
      IF (L1.GT.1e-10) B(8)=MAX(D1/L1,G3,G4)

      L1=GUIDE.FRAME.DIST+GUIDE.FRAME.SIZE(3)-SOL1.FRAME.SIZE(3)
      D1=SOL1.W2+W2  
      IF (L1.GT.1e-10) B(9)=MAX(D1/L1,G3,G4)

      L1=GUIDE.FRAME.SIZE(3)
      D1=(GUIDE.FRAME.SIZE(1)+W2)/GUIDE.NLH
      IF (L1.GT.1e-10) B(10)=MAX(D1/L1,G4)

C Guide A
      W2=GDEA.FRAME.SIZE(1)
      G5=GDEA.GHLU*4*PI/STP.KI

      L1=SOL1.FRAME.DIST+GUIDE.FRAME.DIST+GDEA.FRAME.DIST
      D1=ABS(MON.FRAME.SIZE(1)*STPCH)+ABS(MON.FRAME.SIZE(3)*CTPCH)+W2  
      IF (L1.GT.1e-10) B(11)=MAX(D1/L1,G3,G4)

      L1=GUIDE.FRAME.DIST+GDEA.FRAME.DIST
      D1=SOL1.FRAME.SIZE(1)+W2  
      IF (L1.GT.1e-10) B(12)=MAX(D1/L1,G3,G4)

      L1=GUIDE.FRAME.DIST+GDEA.FRAME.DIST-SOL1.FRAME.SIZE(3)
      D1=SOL1.W2+W2  
      IF (L1.GT.1e-10) B(13)=MAX(D1/L1,G3,G4)

      L1=GDEA.FRAME.DIST
      D1=GUIDE.FRAME.SIZE(1)+W2  
      IF (L1.GT.1e-10) B(14)=MAX(D1/L1,G3,G4)

      L1=GDEA.FRAME.DIST-GUIDE.FRAME.SIZE(3)
      D1=GUIDE.W2+W2  
      IF (L1.GT.1e-10) B(15)=MAX(D1/L1,G3,G4)
C---------
      W2=GDEA.W2


      L1=SOL1.FRAME.DIST+GUIDE.FRAME.DIST+GDEA.FRAME.DIST+
     *   GDEA.FRAME.SIZE(3)
      D1=ABS(MON.FRAME.SIZE(1)*STPCH)+ABS(MON.FRAME.SIZE(3)*CTPCH)+W2  
      IF (L1.GT.1e-10) B(16)=MAX(D1/L1,G3,G4,G5)

      L1=GUIDE.FRAME.DIST+GDEA.FRAME.DIST+GDEA.FRAME.SIZE(3)
      D1=SOL1.FRAME.SIZE(1)+W2  
      IF (L1.GT.1e-10) B(17)=MAX(D1/L1,G3,G4,G5)

      L1=GUIDE.FRAME.DIST+GDEA.FRAME.DIST+GDEA.FRAME.SIZE(3)-
     *   SOL1.FRAME.SIZE(3)
      D1=SOL1.W2+W2  
      IF (L1.GT.1e-10) B(18)=MAX(D1/L1,G3,G4,G5)

      L1=GDEA.FRAME.DIST+GDEA.FRAME.SIZE(3)
      D1=GUIDE.FRAME.SIZE(1)+W2  
      IF (L1.GT.1e-10) B(19)=MAX(D1/L1,G3,G4,G5)

      L1=GDEA.FRAME.DIST+GDEA.FRAME.SIZE(3)-GUIDE.FRAME.SIZE(3)
      D1=GUIDE.W2+W2  
      IF (L1.GT.1e-10) B(20)=MAX(D1/L1,G3,G4,G5)

      L1=GDEA.FRAME.SIZE(3)
      D1=(GDEA.FRAME.SIZE(1)+W2)/GDEA.NLH
      IF (L1.GT.1e-10) B(21)=MAX(D1/L1,G5)

C Source

      L1=SOL1.FRAME.DIST+GUIDE.FRAME.DIST+GDEA.FRAME.DIST+SOU.DIST
      D1=ABS(MON.FRAME.SIZE(1)*STPCH)+ABS(MON.FRAME.SIZE(3)*CTPCH)+W2  
      IF (L1.GT.1e-10) B(22)=MAX(D1/L1,G3,G4,G5)

      L1=GUIDE.FRAME.DIST+GDEA.FRAME.DIST+SOU.DIST
      D1=SOL1.FRAME.SIZE(1)+W2  
      IF (L1.GT.1e-10) B(23)=MAX(D1/L1,G3,G4,G5)

      L1=GUIDE.FRAME.DIST+GDEA.FRAME.DIST+SOU.DIST-SOL1.FRAME.SIZE(3)
      D1=SOL1.W2+W2  
      IF (L1.GT.1e-10) B(24)=MAX(D1/L1,G3,G4,G5)

      L1=GDEA.FRAME.DIST+SOU.DIST
      D1=GUIDE.FRAME.SIZE(1)+W2  
      IF (L1.GT.1e-10) B(25)=MAX(D1/L1,G3,G4,G5)

      L1=GDEA.FRAME.DIST+SOU.DIST-GUIDE.FRAME.SIZE(3)
      D1=GUIDE.W2+W2  
      IF (L1.GT.1e-10) B(26)=MAX(D1/L1,G3,G4,G5)

      L1=SOU.DIST
      D1=GDEA.FRAME.SIZE(1)+W2  
      IF (L1.GT.1e-10) B(27)=MAX(D1/L1,G3,G4,G5)

      L1=SOU.DIST-GDEA.FRAME.SIZE(3)
      D1=GDEA.W2+W2  
      IF (L1.GT.1e-10) B(28)=MAX(D1/L1,G3,G4,G5)

      ah2=1.D30
      DO I=1,30
        ah2=MIN(ah2,ABS(B(I)))
      ENDDO

c      do i=1,30
c        if(ah2.eq.abs(b(i))) write(*,*) 'b: ', i,b(i) 
c      enddo

C// End of secondary part (after monochromator)

C// find max. divergence
c      write(*,*) 'MON.RH,MON.NH  ',MON.RH,MON.NH,stmch

      Z=0.D0
      IF (MON.RH.NE.0.D0.AND.
     *    (MON.NH.GT.1.OR.MON.HMOS.LE.SEC)) THEN
c        write(*,*) '????'
        Z=1.D0
        F1=0.5*STMCH/MON.RH
      ELSE
        F1=1.D30
      ENDIF     
      L1=SOL2.FRAME.DIST+SOL2a.FRAME.DIST+MON.FRAME.DIST
      D1=SAM.SIZE(1)+ABS(MON.FRAME.SIZE(3)*CTMCH)
      IF(MON.NH.GT.1) THEN
        D1=D1+ABS(MON.FRAME.SIZE(1)*STMCH)/MON.NH       
      ENDIF  
c       write(*,*) 'stmch,F1 ',stmch,F1
      ETA=ABS(GETEFFMOS(MON))+2.*MON.HMOS
      
c      write(*,*) 'eta ',eta


C Colim. 1
      L2=SOL1.FRAME.DIST
      D2=SOL1.FRAME.SIZE(1)
      ksi=stpch/stmch-L2/F1
      if (ABS(L2+L1*ksi).GT.1.D-10) THEN
        C(1)=(D2+ABS(D1*ksi)+2*ETA*L2)/(L2+L1*ksi)
      ENDIF
      
      L2=SOL1.FRAME.DIST+SOL1.FRAME.SIZE(3)
      D2=SOL1.W2
      ksi=stpch/stmch-L2/F1
      if (ABS(L2+L1*ksi).GT.1.D-10.AND.G3.EQ.0) THEN
        C(2)=(D2+ABS(D1*ksi)+2*ETA*L2)/(L2+L1*ksi)
      ENDIF
      
c      write(*,*) 'col1 ',C(1),C(2)
      
C Guide B
      L2=SOL1.FRAME.DIST+GUIDE.FRAME.DIST
      D2=GUIDE.FRAME.SIZE(1)
      ksi=stpch/stmch-L2/F1
      if (ABS(L2+L1*ksi).GT.1.D-10.AND.G3.EQ.0) THEN
        C(3)=(D2+ABS(D1*ksi)+2*ETA*L2)/(L2+L1*ksi)
      ENDIF
      
      L2=SOL1.FRAME.DIST+GUIDE.FRAME.DIST+GUIDE.FRAME.SIZE(3)
      D2=GUIDE.W2
      ksi=stpch/stmch-L2/F1
      if (ABS(L2+L1*ksi).GT.1.D-10.AND.G3.EQ.0.AND.G4.EQ.0) THEN
        C(4)=(D2+ABS(D1*ksi)+2*ETA*L2)/(L2+L1*ksi)
      ENDIF
      
c      write(*,*) 'GDB ',C(3),C(4)
      
C Guide A
      L2=SOL1.FRAME.DIST+GUIDE.FRAME.DIST+GDEA.FRAME.DIST
      D2=GDEA.FRAME.SIZE(1)
      ksi=stpch/stmch-L2/F1
      if (ABS(L2+L1*ksi).GT.1.D-10.AND.G3.EQ.0.AND.G4.EQ.0) THEN
        C(5)=(D2+ABS(D1*ksi)+2*ETA*L2)/(L2+L1*ksi)
      ENDIF
      
      L2=SOL1.FRAME.DIST+GUIDE.FRAME.DIST+GDEA.FRAME.DIST+
     *   GDEA.FRAME.SIZE(3)
      D2=GDEA.W2
      ksi=stpch/stmch-L2/F1
      if (ABS(L2+L1*ksi).GT.1.D-10.AND.G3.EQ.0.AND.G4.EQ.0.
     *    AND.G5.EQ.0) THEN
        C(6)=(D2+ABS(D1*ksi)+2*ETA*L2)/(L2+L1*ksi)
      ENDIF
      
c      write(*,*) 'GDA ',C(5),C(6)
                       
C Source
      L2=SOL1.FRAME.DIST+GUIDE.FRAME.DIST+GDEA.FRAME.DIST+SOU.DIST
      D2=SOU.SIZE(1)
      ksi=stpch/stmch-L2/F1
      if (ABS(L2+L1*ksi).GT.1.D-10.AND.G3.EQ.0.AND.G4.EQ.0.
     *    AND.G5.EQ.0) THEN
        C(7)=(D2+ABS(D1*ksi)+2*ETA*L2)/(L2+L1*ksi)
      ENDIF
      
c      write(*,*) 'SRC ',C(7)
                       
     
      AH3=1.D30
      DO I=1,20
        AH3=MIN(AH3,ABS(C(I)))
      ENDDO

c      do i=1,20
c        if(ah3.eq.abs(c(i))) write(*,*) 'c: ', i,c(i) 
c      enddo

      AHMAX=MIN(AH1,AH3)
C// get max. beam width at the sample
      wmax=SAM.SIZE(1)
      
      L1=SOL2.FRAME.DIST
      D1=SOL2.FRAME.SIZE(1)  
      WMAX=MIN(WMAX,D1+L1*AHMAX)

      L1=SOL2.FRAME.DIST+SOL2.FRAME.SIZE(3)
      D1=SOL2.W2 
      WMAX=MIN(WMAX,D1+L1*AHMAX)

      L1=SOL2.FRAME.DIST+SOL2a.FRAME.DIST
      D1=SOL2a.FRAME.SIZE(1)   
      WMAX=MIN(WMAX,D1+L1*AHMAX)

      L1=SOL2.FRAME.DIST+SOL2a.FRAME.DIST+SOL2a.FRAME.SIZE(3)
      D1=SOL2a.W2   
      WMAX=MIN(WMAX,D1+L1*AHMAX)

      L1=SOL2.FRAME.DIST+SOL2a.FRAME.DIST+MON.FRAME.DIST
      D1=ABS(MON.FRAME.SIZE(1)*STMCH)+ABS(MON.FRAME.SIZE(3)*CTMCH) 
      WMAX=MIN(WMAX,D1+L1*AHMAX)

      IF(MON.NH.EQ.1.AND.ABS(F1-L1).GT.1.D-10) THEN
        AHMAX=MIN(AHMAX,(ABS(AH2*F1)+WMAX+2.D0*ETA*ABS(F1))/ABS(F1-L1)) 
      ENDIF 
c      WRITE(*,*) 'GAMMA ',(ABS(AH2*F1)+WMAX+2.D0*ETA*ABS(F1))/ABS(F1-L1)
      
c--------------------------------      
c Vertical, sample->source      
c--------------------------------      

      DO I=1,20
        A(I)=1E30
      ENDDO        
      DO I=1,30
        B(I)=1E30
      ENDDO        
      DO I=1,20
        C(I)=1E30
      ENDDO        

C Colim. 2
      G1=SOL2.GVT*4*PI/STP.KI

      L1=SOL2.FRAME.DIST
      D1=SAM.SIZE(2)+SOL2.FRAME.SIZE(2)
      IF (L1.GT.1e-10) A(1)=D1/L1
C----            
      L1=SOL2.FRAME.DIST+SOL2.FRAME.SIZE(3)
      D1=SAM.SIZE(2)+SOL2.H2
      IF (L1.GT.1e-10) A(2)=MAX(D1/L1,G1)
      
      L1=SOL2.FRAME.SIZE(3)
      D1=(SOL2.H2+SOL2.FRAME.SIZE(2))/SOL2.NLV
      IF (L1.GT.1e-10) A(3)=MAX(D1/L1,G1)
            
C Colim. 2A
      G2=SOL2a.GVT*4*PI/STP.KI
      H2=SOL2a.FRAME.SIZE(2)
      
      L1=SOL2a.FRAME.DIST+SOL2.FRAME.DIST
      D1=SAM.SIZE(2)+H2  
      IF (L1.GT.1e-10) A(4)=MAX(D1/L1,G1)
      
      L1=L1-SOL2.FRAME.DIST
      D1=SOL2.FRAME.SIZE(2)+H2  
      IF (L1.GT.1e-10) A(5)=MAX(D1/L1,G1)
      
      L1=L1-SOL2.FRAME.SIZE(3)
      D1=SOL2.H2+H2  
      IF (L1.GT.1e-10) A(6)=MAX(D1/L1,G1)
C----      
      H2=SOL2a.H2
      
      L1=SOL2.FRAME.DIST+SOL2a.FRAME.DIST+SOL2a.FRAME.SIZE(3)
      D1=SAM.SIZE(2)+H2
      IF (L1.GT.1e-10) A(7)=MAX(D1/L1,G1,G2)

      L1=L1-SOL2.FRAME.DIST
      D1=SOL2.FRAME.SIZE(2)+H2
      IF (L1.GT.1e-10) A(8)=MAX(D1/L1,G1,G2)

      L1=L1-SOL2.FRAME.SIZE(3)
      D1=SOL2.H2+H2
      IF (L1.GT.1e-10) A(9)=MAX(D1/L1,G1,G2)

      L1=SOL2a.FRAME.SIZE(3)
      D1=(SOL2a.H2+SOL2a.FRAME.SIZE(2))/SOL2a.NLV
      IF (L1.GT.1e-10) A(10)=MAX(D1/L1,G2)

C Monochromator
      H2=MON.FRAME.SIZE(2)
      
      L1=SOL2.FRAME.DIST+SOL2a.FRAME.DIST+MON.FRAME.DIST
      D1=SAM.SIZE(2)+H2  
      IF (L1.GT.1e-10) A(11)=MAX(D1/L1,G1,G2)

      L1=L1-SOL2.FRAME.DIST
      D1=SOL2.FRAME.SIZE(2)+H2  
      IF (L1.GT.1e-10) A(12)=MAX(D1/L1,G1,G2)

      L1=L1-SOL2.FRAME.SIZE(3)
      D1=SOL2.H2+H2
      IF (L1.GT.1e-10) A(13)=MAX(D1/L1,G1,G2)

      L1=MON.FRAME.DIST
      D1=SOL2a.FRAME.SIZE(2)+H2
      IF (L1.GT.1e-10) A(14)=MAX(D1/L1,G1,G2)

      L1=L1-SOL2a.FRAME.SIZE(3)
      D1=SOL2a.H2+H2
      IF (L1.GT.1e-10) A(15)=MAX(D1/L1,G1,G2)
      
      av1=1.D30
      DO I=1,20
        av1=MIN(av1,ABS(A(I)))
      ENDDO

c      do i=1,20
c        if(av1.eq.abs(a(i))) write(*,*) 'a: ', i,a(i) 
c      enddo

C// End of primary part (before monochromator)

C Colim. 1
      H2=SOL1.FRAME.SIZE(2)
      G3=SOL1.GVT*4*PI/STP.KI

      L1=SOL1.FRAME.DIST
      D1=MON.FRAME.SIZE(2)+H2  
      IF (L1.GT.1e-10) B(1)=D1/L1
C---------
      H2=SOL1.H2

      L1=SOL1.FRAME.DIST+SOL1.FRAME.SIZE(3)
      D1=MON.FRAME.SIZE(2)+H2  
      IF (L1.GT.1e-10) B(2)=MAX(D1/L1,G3)

      L1=SOL1.FRAME.SIZE(3)
      D1=(H2+SOL1.FRAME.SIZE(2))/SOL1.NLV
      IF (L1.GT.1e-10) B(3)=MAX(D1/L1,G3)

C Guide B
      H2=GUIDE.FRAME.SIZE(2)
      G4=GUIDE.GVT*4*PI/STP.KI

      L1=SOL1.FRAME.DIST+GUIDE.FRAME.DIST
      D1=MON.FRAME.SIZE(2)+H2  
      IF (L1.GT.1e-10) B(4)=MAX(D1/L1,G3)

      L1=GUIDE.FRAME.DIST
      D1=SOL1.FRAME.SIZE(2)+H2  
      IF (L1.GT.1e-10) B(5)=MAX(D1/L1,G3)

      L1=GUIDE.FRAME.DIST-SOL1.FRAME.SIZE(3)
      D1=SOL1.H2+H2  
      IF (L1.GT.1e-10) B(6)=MAX(D1/L1,G3)
C---------
      H2=GUIDE.H2

      L1=SOL1.FRAME.DIST+GUIDE.FRAME.DIST+GUIDE.FRAME.SIZE(3)
      D1=MON.FRAME.SIZE(2)+H2  
      IF (L1.GT.1e-10) B(7)=MAX(D1/L1,G3,G4)

      L1=GUIDE.FRAME.DIST+GUIDE.FRAME.SIZE(3)
      D1=SOL1.FRAME.SIZE(2)+H2  
      IF (L1.GT.1e-10) B(8)=MAX(D1/L1,G3,G4)

      L1=GUIDE.FRAME.DIST+GUIDE.FRAME.SIZE(3)-SOL1.FRAME.SIZE(3)
      D1=SOL1.H2+H2  
      IF (L1.GT.1e-10) B(9)=MAX(D1/L1,G3,G4)

      L1=GUIDE.FRAME.SIZE(3)
      D1=(GUIDE.FRAME.SIZE(2)+H2)/GUIDE.NLV
      IF (L1.GT.1e-10) B(10)=MAX(D1/L1,G4)

C Guide A
      H2=GDEA.FRAME.SIZE(2)
      G5=GDEA.GVT*4*PI/STP.KI

      L1=SOL1.FRAME.DIST+GUIDE.FRAME.DIST+GDEA.FRAME.DIST
      D1=MON.FRAME.SIZE(2)+H2  
      IF (L1.GT.1e-10) B(11)=MAX(D1/L1,G3,G4)

      L1=GUIDE.FRAME.DIST+GDEA.FRAME.DIST
      D1=SOL1.FRAME.SIZE(2)+H2  
      IF (L1.GT.1e-10) B(12)=MAX(D1/L1,G3,G4)

      L1=GUIDE.FRAME.DIST+GDEA.FRAME.DIST-SOL1.FRAME.SIZE(3)
      D1=SOL1.H2+H2  
      IF (L1.GT.1e-10) B(13)=MAX(D1/L1,G3,G4)

      L1=GDEA.FRAME.DIST
      D1=GUIDE.FRAME.SIZE(2)+H2  
      IF (L1.GT.1e-10) B(14)=MAX(D1/L1,G3,G4)

      L1=GDEA.FRAME.DIST-GUIDE.FRAME.SIZE(3)
      D1=GUIDE.H2+H2  
      IF (L1.GT.1e-10) B(15)=MAX(D1/L1,G3,G4)
C---------
      H2=GDEA.H2


      L1=SOL1.FRAME.DIST+GUIDE.FRAME.DIST+GDEA.FRAME.DIST+
     *   GDEA.FRAME.SIZE(3)
      D1=MON.FRAME.SIZE(2)+H2  
      IF (L1.GT.1e-10) B(16)=MAX(D1/L1,G3,G4,G5)

      L1=GUIDE.FRAME.DIST+GDEA.FRAME.DIST+GDEA.FRAME.SIZE(3)
      D1=SOL1.FRAME.SIZE(2)+H2  
      IF (L1.GT.1e-10) B(17)=MAX(D1/L1,G3,G4,G5)

      L1=GUIDE.FRAME.DIST+GDEA.FRAME.DIST+GDEA.FRAME.SIZE(3)-
     *   SOL1.FRAME.SIZE(3)
      D1=SOL1.H2+H2  
      IF (L1.GT.1e-10) B(18)=MAX(D1/L1,G3,G4,G5)

      L1=GDEA.FRAME.DIST+GDEA.FRAME.SIZE(3)
      D1=GUIDE.FRAME.SIZE(2)+H2  
      IF (L1.GT.1e-10) B(19)=MAX(D1/L1,G3,G4,G5)

      L1=GDEA.FRAME.DIST+GDEA.FRAME.SIZE(3)-GUIDE.FRAME.SIZE(3)
      D1=GUIDE.H2+H2  
      IF (L1.GT.1e-10) B(20)=MAX(D1/L1,G3,G4,G5)

      L1=GDEA.FRAME.SIZE(3)
      D1=(GDEA.FRAME.SIZE(2)+H2)/GDEA.NLV
      IF (L1.GT.1e-10) B(21)=MAX(D1/L1,G5)

C Source

      L1=SOL1.FRAME.DIST+GUIDE.FRAME.DIST+GDEA.FRAME.DIST+SOU.DIST
      D1=MON.FRAME.SIZE(2)+H2  
      IF (L1.GT.1e-10) B(22)=MAX(D1/L1,G3,G4,G5)

      L1=GUIDE.FRAME.DIST+GDEA.FRAME.DIST+SOU.DIST
      D1=SOL1.FRAME.SIZE(2)+H2  
      IF (L1.GT.1e-10) B(23)=MAX(D1/L1,G3,G4,G5)

      L1=GUIDE.FRAME.DIST+GDEA.FRAME.DIST+SOU.DIST-SOL1.FRAME.SIZE(3)
      D1=SOL1.H2+H2  
      IF (L1.GT.1e-10) B(24)=MAX(D1/L1,G3,G4,G5)

      L1=GDEA.FRAME.DIST+SOU.DIST
      D1=GUIDE.FRAME.SIZE(2)+H2  
      IF (L1.GT.1e-10) B(25)=MAX(D1/L1,G3,G4,G5)

      L1=GDEA.FRAME.DIST+SOU.DIST-GUIDE.FRAME.SIZE(3)
      D1=GUIDE.H2+H2  
      IF (L1.GT.1e-10) B(26)=MAX(D1/L1,G3,G4,G5)

      L1=SOU.DIST
      D1=GDEA.FRAME.SIZE(2)+H2  
      IF (L1.GT.1e-10) B(27)=MAX(D1/L1,G3,G4,G5)

      L1=SOU.DIST-GDEA.FRAME.SIZE(3)
      D1=GDEA.H2+H2  
      IF (L1.GT.1e-10) B(28)=MAX(D1/L1,G3,G4,G5)

      av2=1.D30
      DO I=1,30
        av2=MIN(av2,ABS(B(I)))
      ENDDO
      
c      do i=1,30
c        if(av2.eq.abs(b(i))) write(*,*) 'b: ', i,b(i) 
c      enddo

C// End of secondary part (after monochromator)


C// find max. divergence

      Z=0.D0
      IF (MON.RV.NE.0.D0.AND.MON.NV.GT.1.AND.
     *    ABS(COS(MON.CHI)).GT.1.D-3) THEN
        Z=1.D0
        F1=0.5/cos(MON.CHI)/sin(MON.THB)/MON.RV
      ELSE
        F1=1.D30
      ENDIF     
      L1=SOL2.FRAME.DIST+SOL2a.FRAME.DIST+MON.FRAME.DIST
      D1=SAM.SIZE(2)
      IF(MON.NV.GT.1) THEN
        D1=D1+MON.FRAME.SIZE(2)/MON.NV
      ENDIF  
      ETA=4.*MON.VMOS*cos(MON.CHI)*sin(MON.THB)

C Colim. 1
      L2=SOL1.FRAME.DIST
      D2=SOL1.FRAME.SIZE(2)
      ksi=1.D0-L2/F1
      if (ABS(L2+L1*ksi).GT.1.D-10) THEN
        C(1)=(D2+ABS(D1*ksi)+2*ETA*L2)/(L2+L1*ksi)
      ENDIF
      
      L2=SOL1.FRAME.DIST+SOL1.FRAME.SIZE(3)
      D2=SOL1.H2
      ksi=1.D0-L2/F1
      if (ABS(L2+L1*ksi).GT.1.D-10.AND.G3.EQ.0) THEN
        C(2)=(D2+ABS(D1*ksi)+2*ETA*L2)/(L2+L1*ksi)
      ENDIF
      
C Guide B
      L2=SOL1.FRAME.DIST+GUIDE.FRAME.DIST
      D2=GUIDE.FRAME.SIZE(2)
      ksi=1.D0-L2/F1
      if (ABS(L2+L1*ksi).GT.1.D-10.AND.G3.EQ.0) THEN
        C(3)=(D2+ABS(D1*ksi)+2*ETA*L2)/(L2+L1*ksi)
      ENDIF
      
      L2=SOL1.FRAME.DIST+GUIDE.FRAME.DIST+GUIDE.FRAME.SIZE(3)
      D2=GUIDE.H2
      ksi=1.D0-L2/F1
      if (ABS(L2+L1*ksi).GT.1.D-10.AND.G3.EQ.0.AND.G4.EQ.0) THEN
        C(4)=(D2+ABS(D1*ksi)+2*ETA*L2)/(L2+L1*ksi)
      ENDIF
      
C Guide A
      L2=SOL1.FRAME.DIST+GUIDE.FRAME.DIST+GDEA.FRAME.DIST
      D2=GDEA.FRAME.SIZE(2)
      ksi=1.D0-L2/F1
      if (ABS(L2+L1*ksi).GT.1.D-10.AND.G3.EQ.0.AND.G4.EQ.0) THEN
        C(5)=(D2+ABS(D1*ksi)+2*ETA*L2)/(L2+L1*ksi)
      ENDIF
      
      L2=SOL1.FRAME.DIST+GUIDE.FRAME.DIST+GDEA.FRAME.DIST+
     *   GDEA.FRAME.SIZE(3)
      D2=GDEA.H2
      ksi=1.D0-L2/F1
      if (ABS(L2+L1*ksi).GT.1.D-10.AND.G3.EQ.0.AND.G4.EQ.0.
     *    AND.G5.EQ.0) THEN
        C(6)=(D2+ABS(D1*ksi)+2*ETA*L2)/(L2+L1*ksi)
      ENDIF
                        
C Source
      L2=SOL1.FRAME.DIST+GUIDE.FRAME.DIST+GDEA.FRAME.DIST+SOU.DIST
      D2=SOU.SIZE(2)
      ksi=1.D0-L2/F1
      if (ABS(L2+L1*ksi).GT.1.D-10.AND.G3.EQ.0.AND.G4.EQ.0.
     *    AND.G5.EQ.0) THEN
        C(7)=(D2+ABS(D1*ksi)+2*ETA*L2)/(L2+L1*ksi)
      ENDIF
c      write(*,*) 'ksi: ',ksi,D1*ksi,L2+L1*ksi
      
      
      AV3=1.D30
      DO I=1,20
        AV3=MIN(AV3,ABS(C(I)))
      ENDDO
     
c      do i=1,30
c        if(av3.eq.abs(c(i))) write(*,*) 'c: ', i,c(i) 
c      enddo
     

      AVMAX=MIN(AV1,AV3)
C// get max. beam height at the sample
      HMAX=SAM.SIZE(2)
      
      L1=SOL2.FRAME.DIST
      D1=SOL2.FRAME.SIZE(2)  
      HMAX=MIN(HMAX,D1+L1*AV1)

      L1=SOL2.FRAME.DIST+SOL2.FRAME.SIZE(3)
      D1=SOL2.H2 
      HMAX=MIN(HMAX,D1+L1*AV1)

      L1=SOL2.FRAME.DIST+SOL2a.FRAME.DIST
      D1=SOL2a.FRAME.SIZE(2)   
      HMAX=MIN(HMAX,D1+L1*AV1)

      L1=SOL2.FRAME.DIST+SOL2a.FRAME.DIST+SOL2a.FRAME.SIZE(3)
      D1=SOL2a.H2   
      HMAX=MIN(HMAX,D1+L1*AV1)

      L1=SOL2.FRAME.DIST+SOL2a.FRAME.DIST+MON.FRAME.DIST
      D1=MON.FRAME.SIZE(2) 
      HMAX=MIN(HMAX,D1+L1*AV1)

      IF(MON.NV.EQ.1.AND.ABS(F1-L1).GT.1.D-10) THEN
        AVMAX=MIN(AVMAX,ABS((ABS(AV2*F1)+HMAX+ABS(ETA*F1))/(F1-L1))) 
      ENDIF 
                  
c      IF(MON.NV.GT.1) THEN
c         D1=MON.FRAME.SIZE(2)/MON.NV
c         L1=SOL2.FRAME.DIST+SOL2a.FRAME.DIST+MON.FRAME.DIST
c         AVMAX=AVMAX+ABS(D1/L1)
c      ENDIF   
      
c      write(*,*) 'AV: ',ABS((ABS(AV2*F1)+HMAX+ABS(ETA*F1))/(F1-L1))

c      DO I=1,20
c        IF (avmax.eq.ABS(A(I))) write(*,*) 'Hor. limit: ', I,A(I)
c      ENDDO

      
      a1=4*mon.hmos ! mosaicity
      a2=GETEFFMOS(MON) 
      a3=0.5*tan(mon.thb)*(AVMAX/2)**2 ! vertical divergence
      band=SQRT(a1**2+a2**2+a3**2)+ah2

      
c10    format('AHMAX, WMAX, AH1, AH2, AH3, BAND',6(1x,G10.4))
c20    format('AVMAX, HMAX, AV1, AV2, AV3',5(1x,G12.6))
c      write(*,*) 'APERTURE 1'      
c      write(*,10) AHMAX, WMAX, AH1, AH2, AH3, BAND
c      write(*,20) AVMAX, HMAX, AV1, AV2 , AV3
c      pause
      
      END
           
