Cf//////////////////////////////////////////////////////////////////////
C////                                                              //// 
C////  NEutron Scattering Simulation - v.1.0, (c) J.Saroun, 1996   ////
C////                                                              //// 
C//////////////////////////////////////////////////////////////////////
C////
C////  Subroutines for handling events & simple command interpreter
C////  
C////  * SUBROUTINE NESS_LOOP
C////  * SUBROUTINE READCOM(ICOMM,IOE)
C////  * SUBROUTINE NESS(ITASK)
C////  * LOGICAL FUNCTION SAFETY_POOL()
C////  * SUBROUTINE SWPOOL
C////  * SUBROUTINE MAXV_UPD(ITASK)
C////  * SUBROUTINE RANDFILL
C////  * SUBROUTINE RESINT(ICOM,VAL,KI,R,KF)
C////  * SUBROUTINE NESS_RUN(ICOM,NCNT,NEVENT)
C////  * SUBROUTINE VALID(ICOM,NCNT)      
C////  * SUBROUTINE ISAMPLE(ICOM,VAL)
C////  * BLOCK DATA
C////                        
C////  
C//////////////////////////////////////////////////////////////////////


C-------------------------------
      SUBROUTINE NESSEND
C     NESS destructor      
C-------------------------------
      implicit none
      CALL EVARRAY(-1,0)
      CALL NSTORE_FREE
      RETURN
      END
      
C------------------------------------------------------------
      SUBROUTINE NESS(ITASK,DNEV)
C
C ****  Main procedure for MC ray-tracing  ****
C    
C  ITASK=1 ... inelastic scattering, TAS resolution
C  ITASK=2 ... sample -> source
C  ITASK=3 ... source -> sample
C  ITASK=4 ... sample -> source + sample(powder) -> detector (no analyser)
C  ITASK=5 ... source -> sample + sample(powder) -> detector (no analyser)
C  ITASK=6 ... sample -> source + sample (Vanad) -> monitor(IMONIT)
C  ITASK=7 ... source -> monitor(IMONIT)
C------------------------------------------------------------
      IMPLICIT NONE
      
      
      INTEGER*4 ITASK,MAXEV
      PARAMETER(MAXEV=500000)      
      
      INCLUDE 'const.inc'
      INCLUDE 'inout.inc'
      INCLUDE 'structures.inc'
      INCLUDE 'ness_common.inc'
      INCLUDE 'randvars.inc'

      RECORD /STATI/ COV_QE       
      
      INTEGER*4 NEVENT,NCNT,NCTOT
      REAL*8 NTOT,NOUT
           
      COMMON /RESULT/ COV_QE
      REAL*8 E4(4),E16(CRND)
      LOGICAL*4 VERBOSE
      INTEGER*4 NEV
      COMMON /MCSETTING/ VERBOSE,NEV
      REAL T1,T2,T3
      REAL*8 VOLRESMC,RESMATCN(4,4),RESMATRL(4,4)
      REAL*8 BRAGCN(4),VANCN(4),BRAGRL(4),VANRL(4)
      COMMON /RESMATPAR/ VOLRESMC,RESMATCN,RESMATRL,BRAGCN,VANCN,
     *                   BRAGRL,VANRL

      RECORD /NEUTRON/ NEUI,NEUF,NEUI1,NEUF1
      COMMON /NEUIF/ NEUI,NEUF,NEUI1,NEUF1
      
      LOGICAL*4 TIMEOUT,CYCLE2
      INTEGER*4 I,J,IT2,IMESS,IUPD,ISWPOOL,MESS,ITASK1,NSUM,ISUM
      INTEGER*4 NEV1,NEV2,NEVENT1
      REAL*8 Z,Z1,VOL1,VOL2,SMON1,ZNEV,DNEV
      REAL*8 PSUM(5),PSUM1(5),SUM1,DSUM,DSUM1
      REAL*8 DCNT,DCNTF,DCNT1,DCNTF1,SCNT1,SCNTF1
      REAL*8 SUMA,CENTER,FWHM
      
      REAL*4 PAR(3),DPAR(3),CHI2SPC,TOL
      EXTERNAL CHI2SPC

      EQUIVALENCE(E16,E4)
      SAVE NCNT
      
c      write(*,*) ' NESS: ',ITASK,DNEV
      
1     format(' Incident intensity : ',G10.4,' +- ',G10.4,
     *       ', flux : ',G10.4,' +- ',G12.4,
     *      ' , <dEi> = ',G10.4,a5)
2     format(' Incident intensity : ',G10.4,' +- ',G10.4, 
     *       ' ,<dEi> = ',G10.4,a5)
3     FORMAT(' Wait please ... ')            
4     FORMAT(' Time expected: ',F10.1,' s ')           
5     FORMAT(' Timeout reached at ',F10.1,' s')      
6     FORMAT(' Number of events [x 1000] : ',$)
7     FORMAT(10(1X,E10.4)) 
8     FORMAT(' Time spent:  ',F10.1,' s ')
9     FORMAT(' Events: ',I8,' target, ',I8,' final, ',F12.0,' total')    
12    Format(' Safety pool hits: ',16(1X,I3))
13    format(' Monitor',I2,':  Intensity: ',G12.6,' +- ',G10.4)
14    format(' suma: ',G10.4,' +- ',G9.3,' fwhm: ',G10.4,' spread: ',
     * G10.4,' center:',G10.4)
15    format(' Vanad width: ',G10.4,'  shift: ',G10.4,' ',a5,
     *   ' Int: ',G10.4,' cm*sr*meV')
16    format(' Width: ',G10.4,' Int: ',G10.4)
17    format(' Powder peak width: ',G10.4,' fwhm: ',G10.4,
     * ' center:',G10.4,'  Int: ',G10.4)
18    format(' Gaussian peak fwhm: ',G10.4,' center: ',G10.4,
     *       '  Imax: ',G10.4)
19    format(' suma: ',G10.4,' fwhm: ',G10.4,' spread: ',
     * G10.4,' center:',G10.4)
20    format(' TAS RESOLUTION: '/,
     *       '    I(mon.)= ',G12.5,'     I(anal.)= ',G12.5,/,
     *       ' Cooper & Nathans  : ',/,
     *       '    Volume :',G12.5,/,
     *       '    Bragg: ',4(2x,G12.5),/,
     *       '    Vanad: ',4(2x,G12.5),/,
     *       ' Reciprocal lattice: ',/,
     *       '    Bragg: ',4(2x,G12.5),/,
     *       '    Vanad: ',4(2x,G12.5))
21    format(' TAS RESOLUTION: '/,
     *       '    I(tot.)= ',G12.5,/,
     *       ' Cooper & Nathans  : ',/,
     *       '    Volume : ',G12.5,/,
     *       '    Bragg: ',4(2x,G12.5),/,
     *       '    Vanad: ',4(2x,G12.5),/,
     *       ' Reciprocal lattice: ',/,
     *       '    Bragg: ',4(2x,G12.5),/,
     *       '    Vanad: ',4(2x,G12.5))
22    format('.',$)
 

C// Get required number of events (NEV)      
      IF (DNEV.LE.0) THEN              
        IF(DNEV.LT.0) THEN
           ZNEV=ABS(DNEV)
        ELSE
140       WRITE(*,6)
          READ(SINP,*,err=140) ZNEV
        ENDIF   
        VERBOSE=.true.
      ELSE
        ZNEV=DNEV
        VERBOSE=.false.
      ENDIF	
      NEV=INT(ZNEV*1000)
      NEV=MAX(NEV,100)
      IF(NEV.GT.MAXEV) THEN
      	 WRITE(*,*) 'Maximum number of events is ',MAXEV
         NEV=MAXEV
      ENDIF
      NEV1=NEV                  

C// reset hit counters
      SPCN=0      
      do i=1,rndlist.dim
          hit(i)=0
      end do
      
C// adjust report targets      
      IT2=500
      IMESS=1000
      IUPD=500
      ISWPOOL=MAX(5000,INT(NEV1/2))
      NOUT=1.D+4*NEV1
      IF(NEV1.GE.2*IUPD.AND.IOPT.EQ.1) THEN
        MESS=0
      ELSE
        MESS=1
      ENDIF       
      
C// reset event counters
      NEVENT=0
      NCNT=0
      NTOT=0.D+0  
      NCTOT=0

C// no sampling optimization in debug mode
      IF (IDBG.GE.2) THEN
         IUPD=NEV1+10
	 ISWPOOL=NEV1+10
	 NOUT=1.D+7*NEV1
      ENDIF
      
      
C// some tasks require 2-cycle process 
      CYCLE2=(.FALSE..OR.
     &  ITASK.EQ.8.OR.   ! TAS
     &  ITASK.EQ.9.OR.   ! PWD
     &  ITASK.EQ.10)     ! PWDS
      
c// don't switch the pool off for TAS resolution function simulations
      IF (ITASK.EQ.8.OR.ITASK.EQ.9) ISWPOOL=NEV1+10  
       
C// Allocate memory for monitor events (monitor counts) 
      CALL EVARRAY(0,1,NEV1)  ! (X,Y,E,time)
      CALL EVARRAY(0,0,NEV1)  ! (kx..kz,spin)
C// Special storage for some tasks: (r,k,s,p) for initial and final neutrons
      IF (ITASK.EQ.1.OR.    ! TAS
     &    ITASK.EQ.2.OR.    ! NFLUX
     &    CYCLE2)  THEN        
         CALL NSTORE_ALLOCATE(NEV1)
      ENDIF
      
      ITASK1=ITASK
      IF (CYCLE2) ITASK1=2  ! cycle 1 accumulates events at the sample        

C// Initialize TAS components for cycle 1
      CALL SPEC_INI(0,ITASK1)      
C// reset max. values of random variables
      CALL MAXV_UPD(0)            
      T1=SECNDS(0.0) ! timestamp 1
      TIMEOUT=.FALSE.
      
C----------------------- Begin cycle 1 ------------------------------ 
      IF (VERBOSE) WRITE(*,3) 
      DO WHILE ((NCNT.LT.NEV1).AND.(.NOT.TIMEOUT))
170      NTOT=NTOT+1.D+0 

C// show progress dots ....          
         Z=NTOT/50000.
         IF(Z-INT(Z).EQ.0) WRITE(*,22)  
         
           
c         Z=NTOT/50000.D0 
c        if (Z-INT(Z).EQ.0) then 
c         dbgref=(Z-INT(Z).EQ.0)
          dbgref=.false.
c         if (dbgref) then  
c           write(*,*) 'NESS ',NEVENT,NTOT,MON.FRAME.COUNT,SOU.COUNT
c           CALL GETSTATE(ITASK1,NEVENT)
c           WRITE(*,12) (HIT(I),I=1,RNDLIST.DIM)
c           pause  
c         endif


         TIMEOUT=(NTOT.GT.NOUT.OR.((NCTOT+1)*1D5.LT.NTOT))
C// Reset counters if NEVENT=0
         IF (NEVENT.EQ.0) THEN
              SCNT=0.
	      SCNTF=0.
              SCNT1=0.
	      SCNTF1=0.
              DCNT=0.
	      DCNTF=0.
              DCNT1=0.
	      DCNTF1=0.
              VOL1=1
              DO I=1,RNDLIST.DIM
                VOL1=VOL1*RNDLIST.LIMITS(I)
              END DO
              NSUM=0
              ISUM=0
              DO I=1,5
                PSUM(I)=0
                PSUM1(I)=0
              ENDDO  
              NEVENT1=0
              VOL2=0
              CALL SPEC_INI(1,ITASK1)
         ENDIF 
         
C// Copy counter values to the counters for the 1st part of simulation
C// (safety pool ON)
         IF (NCNT.LE.ISWPOOL) THEN
            NEV2=NEVENT
            SCNT1=SCNT
	    SCNTF1=SCNTF
            DCNT1=DCNT
	    DCNTF1=DCNTF
         ENDIF   

C// remember old counter values
         I=NCNT
         J=NEVENT
         Z=SCNT
         Z1=SCNTF

C// Trace neutron through the instrument
         CALL NESS_RUN(NCNT,NEVENT,ITASK1)
         IF (NEVENT.EQ.0.AND.(.NOT.TIMEOUT)) GOTO 170
C// increment counters         
         ISUM=ISUM+NCNT-I
         NEVENT1=NEVENT1+NEVENT-J
         NCTOT=NCTOT+NCNT-I
         DCNT=DCNT+SCNT-Z
         DCNTF=DCNTF+SCNTF-Z1

         IF(NCNT.EQ.IT2) T2=SECNDS(T1) ! timestamp 2

C/// When IUPD events were accumulated, covariance matrix is
C//  calculated and simulation restarts with new limits and covariances         
         IF((NCNT.EQ.IUPD).and.(MESS.LT.1)) THEN
            CALL COV_NEW
	    CALL MAXV_UPD(0)
            MESS=1
            NEVENT=0
            NCNT=0
            IF (VERBOSE) WRITE(*,12) (HIT(I),I=1,RNDLIST.DIM)
            DO I=1,RNDLIST.DIM
               HIT(I)=0
            END DO   
         ENDIF         
         
C// When IMESS events were accumulated, total time is estimated:
         IF((MESS.LT.2).AND.(NCNT.GE.IMESS)) THEN
            MESS=2
            T3=SECNDS(T1) 
            Z=T2+(T3-T2)*(NEV1-IMESS*1.)/IT2
            IF (VERBOSE) WRITE(*,4) Z
         ENDIF

C// After ISWPOOL events, safety pool is switched off.  
C// VOL1 and VOL2 are the sampling volumes before and after the switch 
         IF((NCNT.EQ.ISWPOOL).and.(MESS.LT.3)) THEN
            IF (VERBOSE) write(*,*) 'SWP: Initial volume: ',VOL1
            CALL MAXV_UPD(2)
            CALL SWPOOL
            VOL2=1
            DO I=1,RNDLIST.DIM
              VOL2=VOL2*RNDLIST.LIMITS(I)
            END DO              
            IF (VERBOSE) write(*,*) 'SWP: Final volume: ',VOL2
            MESS=3
         ENDIF         
         
C// Get partial sums for error estimation         
         IF (ISUM.EQ.INT(NEV1/5.D0).AND.NEVENT1.GT.0) THEN
           NSUM=NSUM+1
           PSUM(NSUM)=(VOL1*DCNT1+VOL2*(DCNT-DCNT1))/NEVENT1
           PSUM1(NSUM)=(VOL1*DCNTF1+VOL2*(DCNTF-DCNTF1))/NEVENT1
           ISUM=0
           DCNT=0.
	   DCNTF=0.
           DCNT1=0.
	   DCNTF1=0.
           NEVENT1=0
         ENDIF             
      END DO
      if (VERBOSE) write(SOUT,*)

C----------------------- End cycle 1------------------------------ 
      IF(NCNT.GE.ISWPOOL) CALL SWPOOL !  safety pool back ON

C// NSEED index is used to point to an incident neutron taken from KSTACK storage
C// This event is further processed in the cycle 2
      NSEED=0

      T3=SECNDS(T1) ! timestamp 3

C// timeout reached => print status and exit
      IF (TIMEOUT) THEN
           WRITE(SOUT,5) T3
           WRITE(SOUT,9) NCNT,NEVENT,NTOT
           CALL GETSTATE(ITASK1,NEVENT)
           WRITE(*,*)
           IINC=0
           DIINC=0
           I3AX=0
           DI3AX=0
           IPWD=0
           DIPWD=0
           RETURN
      ENDIF 

C// report status          
      IF (VERBOSE) THEN
        WRITE(SOUT,8) T3
	WRITE(SOUT,9) NCNT,NEVENT,NTOT
        WRITE(*,12) (HIT(I),I=1,RNDLIST.DIM)
        WRITE(*,*)
        CALL GETSTATE(ITASK1,NEVENT)
        WRITE(*,*)
      ENDIF

C// calculate norms
      SUM=(VOL1*SCNT1+VOL2*(SCNT-SCNT1))/NEVENT
      SUM1=(VOL1*SCNTF1+VOL2*(SCNTF-SCNTF1))/NEVENT
      SUM=SUM*1.D14/100 ! mm2-> cm2 
      SUM1=SUM1*1.D14/100 ! mm2-> cm2 
      DSUM=0
      DSUM1=0
      IF (NSUM.GT.1) THEN
        DO I=1,NSUM
          DSUM=DSUM+(PSUM(I)*1.D14/100-SUM)**2
          DSUM1=DSUM1+(PSUM1(I)*1.D14/100-SUM1)**2
        ENDDO
        DSUM=SQRT(DSUM/NSUM/(NSUM-1))
        DSUM1=SQRT(DSUM1/NSUM/(NSUM-1))
      ENDIF

C// Report results after cycle 1
C// powder peak parameters (command NFLUX 2)
      IF (ITASK1.EQ.4.OR.ITASK1.EQ.5) THEN 
          CALL GETPEAKPARAM(0,SUMA,CENTER,FWHM,SPREAD)
          IPWD=SUMA
          DIPWD=SUMA*DSUM/SUM
          WPWD=FWHM    
          SPWD=SPREAD
          CPWD=CENTER 
          IF (VERBOSE) WRITE(SOUT,14) SUMA,SUMA*DSUM/SUM,FWHM,SPREAD,
     &        CENTER
C// beam profile at the sample 
      ELSE IF (ITASK1.EQ.2.OR.ITASK1.EQ.3) THEN
          Z=0.D0
          IF (SCNT.GT.0) Z=R8LN2*SQRT(DEI/SCNT-(DEI0/SCNT)**2)
          IF (VERBOSE) THEN
	     WRITE(SOUT,1) SUM,DSUM,SUM1,DSUM1,Z,CUNIT      
	  ENDIF   
          IINC=SUM
          DIINC=DSUM
          EINC=Z
C// intensity at the monitor 
      ELSE IF (ITASK1.EQ.6.OR.ITASK1.EQ.7) THEN
          IF (VERBOSE) WRITE(SOUT,13) IMONIT,SUM,DSUM  
          IINC=SUM
          DIINC=DSUM   
C// beam profile at the detector in double-crystal setup 
      ELSE IF (ITASK1.EQ.11) THEN
          IF (VERBOSE) WRITE(SOUT,13) 99,SUM,DSUM 
          IINC=SUM
          DIINC=DSUM
          I3AX=SUM
          DI3AX=DSUM 
          EINC=0
      ENDIF    

C-------------------------Start cycle 2  ------------------------------

C// 2nd cycle for secondary spectrometer: TAS resolution function
      IF(ITASK.EQ.8.OR.ITASK.EQ.9) THEN    
         CALL SPEC_INI(0,ITASK)      
         CALL MAXV_UPD(0)
         NCNT=0
         NEVENT=0      
         NTOT=0.D0
         NOUT=100*NEV1
         DO WHILE ((NCNT.LT.NEV1).AND.(NTOT.LT.NOUT))
700        IF (NEVENT.EQ.0) THEN
              SCNT=0.
              VOL1=1
              DO I=1,RNDLIST.DIM
                VOL1=VOL1*ABS(RNDLIST.LIMITS(I))
              END DO
              CALL SPEC_INI(1,ITASK)
              DCNT=0.
              NSUM=0
              ISUM=0
              DO I=1,5
                PSUM(I)=0
              ENDDO  
              NEVENT1=0
              SMON1=0
              SMON=0
           ENDIF 
           NTOT=NTOT+1.D+0 
           I=NCNT
           J=NEVENT
           Z=SCNT
           Z1=SMON
           CALL NESS_RUN(NCNT,NEVENT,ITASK)
           IF (NEVENT.EQ.0) GOTO 700	 
           ISUM=ISUM+NCNT-I
           NEVENT1=NEVENT1+NEVENT-J
           SMON1=SMON1+SMON-Z1
           DCNT=DCNT+SCNT-Z
C//      Get parcial sums for error estimation         
           IF (ISUM.EQ.NINT(NEV1/5.D0).AND.SMON1.GT.0.D0) THEN
             NSUM=NSUM+1
             PSUM(NSUM)=(VOL1*DCNT)/SMON1
             ISUM=0
             DCNT=0.
             NEVENT1=0
             SMON1=0
           ENDIF
         ENDDO
         T3=SECNDS(T1)
         
c         SUM=(VOL1*SCNT)/NEVENT
         DSUM=0.D0
         SUM=0.D0
         if (SMON.GT.0) SUM=(VOL1*SCNT)/SMON
         IF (NSUM.GT.1.AND.SUM.GT.0.D0) THEN
           DO I=1,NSUM
             DSUM=DSUM+(PSUM(I)-SUM)**2
c             write(*,*) PSUM(I),SUM,(PSUM(I)-SUM)/SUM 
           ENDDO
           DSUM=SQRT(DSUM/NSUM/(NSUM-1))
         ENDIF
         IF (VERBOSE) THEN
           WRITE(SOUT,8) T3
	   WRITE(SOUT,9) NCNT,NEVENT,NTOT
           WRITE(*,12) (HIT(I),I=1,RNDLIST.DIM)
           WRITE(*,*)
           write(*,*) 'cycle 2 - final volume: ',VOL1
           CALL GETSTATE(ITASK,NEVENT)
           WRITE(*,*)
         ENDIF
      ENDIF

C// 2nd cycle for PWDS: multidetector scan
      IF(ITASK.EQ.10) THEN
         SPCN=SPCM
         CALL SCANMDET(SPCX,SPCY,SPCD,SPCM)
         CALL GETPEAKPARAM(3,IPWD,CPWD,FWHM,SPWD)
         DIPWD=DIINC/IINC*IPWD
         PAR(1)=IPWD
         PAR(2)=CPWD
         PAR(3)=SPWD
         DO I=1,3
          DPAR(I)=0.
         ENDDO
         TOL=0.01
         CALL LMOPT(CHI2SPC,PAR,3,TOL,DPAR,2)         
         T3=SECNDS(T1)
	 IF (VERBOSE) THEN
            WRITE(SOUT,8) T3
            WRITE(SOUT,17) SPWD,FWHM,CPWD,IPWD  
            WRITE(SOUT,18) PAR(3),PAR(2),PAR(1)  
         ELSE
            WRITE(SOUT,16) PAR(3),PAR(1)      
         ENDIF       
      ENDIF

C------ End of the 2nd cycle ---------------------------------------

C// ITASK=1,8 do the same thing in a different way:
C// ITASK=1 .. simulate TAS in one cycle
C// ITASK=8 .. split into 2 cycles: sample->source and sample->detector  

      IF (ITASK1.EQ.1.OR.ITASK.EQ.8) THEN              
        E3AX=0.D0
        IF (STAS.GT.0) E3AX=2.35482D0*SQRT(ABS(DEI/STAS-(DEI0/STAS)**2))
c        I3AX=(VOL1*SCNT)/NEVENT*HSQOV2M*2*STP.KF/10. 
        IF(ITASK1.EQ.1) THEN
          I3AX=SUM*HSQOV2M*2*STP.KF/10.
          DI3AX=DSUM*HSQOV2M*2*STP.KF/10. 
        ENDIF  
        IF(ITASK.EQ.8) THEN
          I3AX=IINC*SUM*HSQOV2M*2*STP.KF/10. 
          DI3AX=SQRT((IINC*DSUM)**2+(DIINC*SUM)**2)*HSQOV2M*2*STP.KF/10. 
        ENDIF  
        IF (STAS.GT.0) DE3AX=DEI0/STAS
        CALL GETPEAKPARAM(1,SUMA,CENTER,FWHM,SPREAD)
        CALL RESMAT
        WRITE(SOUT,19) I3AX,FWHM,SPREAD,CENTER  
	IF (VERBOSE) THEN
         IF(ITASK.EQ.8) THEN  
           WRITE(SOUT,20) IINC,I3AX,
     *                     VOLRESMC,
     *                     (BRAGCN(I),I=1,4),(VANCN(I),I=1,4),
     *                     (BRAGRL(I),I=1,4),(VANRL(I),I=1,4) 
         ELSE  
           WRITE(SOUT,21) I3AX,
     *                     VOLRESMC,
     *                     (BRAGCN(I),I=1,4),(VANCN(I),I=1,4),
     *                     (BRAGRL(I),I=1,4),(VANRL(I),I=1,4) 
         ENDIF
        ELSE
           WRITE(SOUT,16) E3AX,I3AX
        ENDIF       
      ENDIF
      
C// ITASK=9,10 do similar things:
C// ITASK=9  .. simulate powder curve using ki,kf events
C// ITASK=10 .. simulate powder curve by step-by-step scanning

      IF (ITASK.EQ.9) THEN              
         Z=0.D0
         IPWD=IINC*(VOL1*SCNT)/NEVENT/10. ! mm->cm
         DIPWD=IPWD*DIINC/IINC
         CALL GETPEAKPARAM(2,SUMA,CPWD,FWHM,SPWD)
         CALL THETA_SCAN(SPCX,SPCY,SPCD,65)
         PAR(1)=SPCY(32)
         PAR(2)=CPWD
         PAR(3)=SPWD
         DO I=1,3
          DPAR(I)=0.
         ENDDO
         TOL=0.01
	 IF (VERBOSE) THEN
            CALL LMOPT(CHI2SPC,PAR,3,TOL,DPAR,2)         
            WRITE(SOUT,17) SPWD,FWHM,CPWD,IPWD  
            WRITE(SOUT,18) PAR(3),PAR(2),PAR(1)  
         ELSE
            WRITE(SOUT,16) SPWD,IPWD    
         ENDIF       
      ENDIF

      IF (VERBOSE) write(SOUT,*)

c100   FORMAT(' NESS: ',3(2X,E12.5))      
      RETURN
      END 
         

C-------------------------------------------------------------------
      LOGICAL*4 FUNCTION SAFETY_POOL(LASTHIT)
C     Checks, if the value of any random variable X(I) is found
C     in the safety pool. If yes, corresponding limits are relaxed.
C   assignment of XRND to physical variables:
C   1-3  ..  K(i) vector
C   4-5  ..  R(1), R(2)
C   6    ..  not used
C   7    ..  vertical scattering angle
C   8    ..  horizontal scattering angle (for Vanad)
C-------------------------------------------------------------------
      implicit none
      INCLUDE 'const.inc'
      INCLUDE 'randvars.inc'
 
      REAL*8 Z
      LOGICAL*4 LOG1
      INTEGER*4 I,LASTHIT
      
      
5     format(A10,1x,I2,4(2x,F12.5))

      LOG1=.FALSE.
      LASTHIT=0
      DO 10 I=1,RNDLIST.DIM
      
      IF (RNDLIST.ACTIVE(I).GT.0) THEN
        Z=ABS(2*RNDLIST.POOL(I)*XNORM(I))-RNDLIST.LIMITS(I)   
        IF (Z.GT.0) THEN 
           LASTHIT=I       
           LOG1=.TRUE.
c       write(*,5) 'HIT: ',I,XNORM(I),XRND(I),RNDLIST.LIMITS(I)
           RNDLIST.LIMITS(I)=RNDLIST.LIMITS(I)*RNDLIST.POOL(I)
           HIT(I)=HIT(I)+1
c	   IF (I.EQ.3) THEN
c         write(*,5) 'HIT3: ',i,X(i),XRND(i),RNDLIST.LIMITS(i),TMEAN(i)
c	   endif
           IF(RNDLIST.LIMITS(7).GT.PI*2) THEN
              RNDLIST.LIMITS(7)=PI*2 
              RNDLIST.ACTIVE(7)=0
c	      write(*,*) 'WARNING: ',PI,RNDLIST.LIMITS(7)
           ENDIF             
        ENDIF
      ENDIF      
10    CONTINUE
      SAFETY_POOL=LOG1
      RETURN
      END        


C     --------------------------------------------------
      SUBROUTINE SWPOOL
C     switch safety pool off/on
C     --------------------------------------------------
      implicit none
      INCLUDE 'randvars.inc'
 
      INTEGER*4 MYPOOL(CRND)
      INTEGER IPOOL_OFF,I    
      REAL*8 MYLIM(CRND)      
      LOGICAL*4 VERBOSE
      INTEGER*4 NEV
      COMMON /MCSETTING/ VERBOSE,NEV
      SAVE IPOOL_OFF,MYLIM,MYPOOL
      DATA IPOOL_OFF/0/
     
c      write(*,*) 'ipool=',ipool_off
      
      IF(IPOOL_OFF.EQ.0) THEN
         IF (VERBOSE) WRITE(*,*) 'Safety pool OFF'
         DO 10 I=1,RNDLIST.DIM
           MYLIM(I)=RNDLIST.LIMITS(I)
           MYPOOL(I)=RNDLIST.ACTIVE(I)
           IF (MYPOOL(I).NE.0) THEN
             RNDLIST.LIMITS(I)=RNDLIST.LIMITS(I)/RNDLIST.POOL(I)
             RNDLIST.ACTIVE(I)=0
           ENDIF  
10       CONTINUE
c101   FORMAT('TLIM: ',16(1X,G10.4))      
c      write(*,101) (RNDLIST.LIMITS(J),J=1,RNDLIST.DIM)
         IPOOL_OFF=1
      ELSE
         IF (VERBOSE) WRITE(*,*) 'Safety pool ON'
         DO 20 I=1,RNDLIST.DIM
           RNDLIST.LIMITS(I)=MYLIM(I)
           RNDLIST.ACTIVE(I)=MYPOOL(I)           
20       CONTINUE
         IPOOL_OFF=0
      ENDIF
      
      RETURN
      END      
                               	                 
C-----------------------------------------------------------------------
      SUBROUTINE MAXV_UPD(ITASK)
C     ITASK=0 ... clears MAXV(I) array
C     ITASK=1 ... MAXV(I) is compared with X(I) and changed if necessary
C     ITASK=2 ... limits are changed according to MAXV(I)        
C-----------------------------------------------------------------------
      implicit none
      
      INCLUDE 'randvars.inc'
      integer*4 I,itask
      
      IF(ITASK.EQ.0) THEN
        DO  I=1,RNDLIST.DIM                 
         MAXV(I)=0.D0
        ENDDO       
      
      ELSE IF(ITASK.EQ.1) THEN
      
        DO  I=1,RNDLIST.DIM
          IF (RNDLIST.ACTIVE(I).gt.0) THEN              
            IF(ABS(XNORM(I)).GT.MAXV(I)) MAXV(I)=ABS(XNORM(I))
          ENDIF  
        ENDDO        
      
      ELSE IF(ITASK.EQ.2) THEN
      
        DO  I=1,RNDLIST.DIM
          IF (RNDLIST.ACTIVE(I).gt.0) THEN
           RNDLIST.LIMITS(I) = 2.*MAXV(I)*RNDLIST.POOL(I)*1.001
          ENDIF              
        ENDDO

      ENDIF
      RETURN
      END          
          
C     -------------------
      SUBROUTINE COV_CLR
C     -------------------
      implicit none
      INCLUDE 'randvars.inc'
      integer*4 I,J
       
      DO  10 I=1,CRND
         MVAL(I)=0
         DO 20 J=1,I
           COV(J,I)=0.D0
           COV(I,J)=0.D0
20       CONTINUE
10    CONTINUE
      NCOV=0
      SCOV=0.D0
      
      RETURN
      END   

C     -------------------------
      SUBROUTINE COV_UPD(X1,P)
C     -------------------------
      implicit none

      INCLUDE 'randvars.inc'
      integer*4 I,J
      REAL*8 X1(CRND),P
      
      DO  10 I=1,RNDLIST.DIM
        IF (RNDLIST.ACTIVE(I).gt.0) THEN
          MVAL(I)=MVAL(I)+X1(I)*1

          DO 20 J=1,I 
          IF (RNDLIST.ACTIVE(J).gt.0) THEN
            COV(I,J)=COV(I,J)+X1(I)*X1(J)*1
            COV(J,I)=COV(I,J)
          END IF 
20        CONTINUE   
        ENDIF
10    CONTINUE   
      NCOV=NCOV+1
      SCOV=SCOV+1   ! not weighted in this version             
      RETURN
      END

C     -------------------------
      SUBROUTINE COV_NEW
C     -------------------------
      implicit none

      INCLUDE 'randvars.inc'
      INTEGER*4 I,J,NROT
      REAL*8 AUX(CRND,CRND),AUX1(CRND,CRND),VLIM(CRND),Z
      LOGICAL*4 VERBOSE
      INTEGER*4 NEV
      COMMON /MCSETTING/ VERBOSE,NEV
      
5     format(a10,5(2x,E11.5))
104   FORMAT(' MAT: ',10(1X,G10.4))      
100   FORMAT(' COV: ',10(1X,G10.4))      
101   FORMAT(' LIM: ',10(1X,G10.4))      
102   FORMAT(' COV - Old volume: ',G12.6)      
103   FORMAT(' COV - New volume: ',G12.6)      

      IF (NCOV.GT.30) THEN
        DO 10 I=1,RNDLIST.DIM
10         IF (RNDLIST.ACTIVE(I).lt.1) CMAT(I,I)=1.D0
        
        DO  20 I=1,RNDLIST.DIM
        IF (RNDLIST.ACTIVE(I).gt.0) THEN
          TMEAN(I)=MVAL(I)/SCOV
          DO 21 J=1,RNDLIST.DIM
            if(RNDLIST.ACTIVE(J).gt.0) CMAT(I,J)=COV(I,J)/SCOV          
21        continue               
        ENDIF
20      CONTINUE
        DO i=1,RNDLIST.DIM
        DO j=1,RNDLIST.DIM
        IF ((RNDLIST.ACTIVE(I).gt.0).and.(RNDLIST.ACTIVE(j).gt.0)) THEN 
           CMAT(I,J)=CMAT(I,J)-TMEAN(I)*TMEAN(J)
        ENDIF
        ENDDO
        ENDDO   
C filter covariances
      DO I=1,RNDLIST.DIM
      DO J=1,RNDLIST.DIM
         IF (ABS(CMAT(I,J))/SQRT(CMAT(I,I)*CMAT(J,J)).LT.0.10) 
     *       CMAT(I,J)=0.D0 
      ENDDO 

      enddo 
c      do i=1,RNDLIST.DIM
c         write(*,104) (CMAT(i,j)/SQRT(CMAT(i,i)*CMAT(j,j)),
c     *    j=1,RNDLIST.DIM)       
c      enddo 
c      write(*,*) 


c      do i=1,5
c         write(*,100) (aux(i,j),j=1,5)       
c      enddo 
c      write(*,*) 

                             
      CALL JACOBI(CMAT,AUX,RNDLIST.DIM,CRND,VLIM,aux1,NROT)

c      CALL JACOBI(CMAT,AUX,RNDLIST.DIM,CRND,VLIM,aux1,NROT)
c      CALL MXM(1,RNDLIST.DIM,CRND,CMAT,AUX1,AUX)     
c      CALL MXM(-1,RNDLIST.DIM,CRND,AUX1,AUX,CMAT)     
c      write(*,*) 'Check JACOBI'
c      do i=1,RNDLIST.DIM
c         write(*,100) (CMAT(i,j),j=1,RNDLIST.DIM)       
c      enddo 
c      write(*,*) 'End'
 
      DO 80 I=1,CRND
      DO 80 J=1,CRND
         IF (I.NE.J) THEN
          TMAT(I,J)=0.D0
         ELSE
          TMAT(I,J)=1.D0
         ENDIF 
80    CONTINUE

      z=1  
      do i=1,RNDLIST.DIM
         z=z*RNDLIST.LIMITS(I)
      enddo
      IF (VERBOSE) write(*,102) z  

      DO I=1,RNDLIST.DIM
      IF (RNDLIST.ACTIVE(I).GT.0) THEN
        RNDLIST.LIMITS(I)=2*SQRT(6*ABS(VLIM(I)))
        DO J=1,RNDLIST.DIM
          IF (RNDLIST.ACTIVE(J).GT.0) THEN
             TMAT(I,J)=AUX1(J,I)
          ENDIF
        ENDDO
      ENDIF
      ENDDO 
       
       
      
c      do i=1,RNDLIST.DIM
c         write(*,100) (tmat(i,j),j=1,RNDLIST.DIM)       
c      enddo 
c      write(*,101) (RNDLIST.LIMITS(I),I=1,RNDLIST.DIM)       
c      write(*,*) 

      z=1  
      do i=1,RNDLIST.DIM
         z=z*RNDLIST.LIMITS(I)
      enddo
      IF (VERBOSE) write(*,103) z 

      ENDIF           
      RETURN
      END  
      
C----------------------------------------------------------
      SUBROUTINE RANDFILL
C     filles XNORM(I) by random numbers within specified limits	
C----------------------------------------------------------
      IMPLICIT NONE
      INCLUDE 'randvars.inc' 
      INTEGER*4 I
      REAL*4 RAN1
        
      DO  I=1,RNDLIST.DIM
         XNORM(I)=RNDLIST.LIMITS(I)*(RAN1()-0.5)
      END DO

      RETURN
      END
                 



C-------------------------------------------------------------------
      SUBROUTINE NESS_RUN(NCNT,NEVENT,ITASK)
C     trace one event, starting at the sample
C  ITASK=1 ... inelastic scattering, TAS resolution
C  ITASK=2 ... sample -> source
C  ITASK=4 ... sample -> source + sample(powder) -> detector (no analyser)
C  ITASK=6 ... sample -> source + sample (Vanad) -> monitor(IMONIT)
C-------------------------------------------------------------------
      implicit none

      INCLUDE 'const.inc'
      INCLUDE 'inout.inc'
      INCLUDE 'structures.inc'
      INCLUDE 'ness_common.inc'
      INCLUDE 'randvars.inc'
      INCLUDE 'sim_grf.inc'
	
      RECORD /NEUTRON/ NEUI,NEUF,NEUI1,NEUF1
      INTEGER*4 NEVENT,NCNT,ITASK,I,IX,IY,I1,I2,NS
      REAL*8 C1,C2,KI
      COMMON /NEUIF/ NEUI,NEUF,NEUI1,NEUF1
       LOGICAL*4 SPEC_GO,SAFETY_POOL   
      REAL*8 V3xV3       
      REAL*4 RAN1,DUM               

c      DBGREF=(NCNT.EQ.0)         

      IF(NEVENT.EQ.0) THEN
c1     format(a,1x,8(G12.6,2x))
c       write(*,1) 'NESS_RUN: ',(XRND(i),i=1,RNDLIST.DIM)
         SCNT=0.D0
	 SCNTF=0.D0
         DEI=0.D0
         DEI0=0.D0
         SUM=0.D0
         STAS=0.D0
         SMON=0.D0
         call COV_CLR
         IF (ITASK.EQ.4.OR.ITASK.EQ.5) THEN
           DO IX=1,MIMAX
           DO IY=1,MIMAX
              SVOL(IX,IY)=0.E0
           ENDDO
           ENDDO
         ENDIF
      ENDIF          
           
      NEVENT=NEVENT+1
      
      CALL RANDFILL
      CALL M16XV16(-1,RNDLIST.DIM,TMAT,XNORM,XRND)
      do i=1,RNDLIST.DIM
        XRND(i)=XRND(i)+TMEAN(I)
      enddo  
      

      IF (ITASK.EQ.8.OR.ITASK.EQ.9.OR.ITASK.EQ.10) THEN  ! get NEUI from events simulated before
        CALL NSTORE_N(I1,I2,NS)
        NSEED=NSEED+1
        IF (NSEED.GT.I1.OR.NSEED.LE.0) NSEED=1
        CALL NSTORE_READ1(NSEED,NEUI)
        KI=SQRT(V3XV3(NEUI.K,NEUI.K)) ! |k| for incident neutron
        IF (NORMMON.EQ.1) THEN 
          SMON=SMON+NEUI.P/KI    ! * monitor efficiency
        ELSE 
          SMON=SMON+NEUI.P
        ENDIF   
      ELSE 
        NEUI.R(1)=XRND(4)
        NEUI.R(2)=XRND(5)
        NEUI.R(3)=0.
c        DO I=1,3
c          NEUI.K(I)=XRND(I)
c        END DO
        IF(ABS(XRND(1)).GE.1.D0.OR.ABS(XRND(2)).GE.1.D0.OR.
     *    XRND(3).LE.1.D-2) THEN
c       write(*,*) 'NESS_RUN: ',(XRND(i),i=1,RNDLIST.DIM)
          RETURN
        ENDIF
        C1=SQRT(ABS(1-XRND(1)**2))
        C2=SQRT(ABS(1-XRND(2)**2))
        NEUI.K(1)=XRND(3)*XRND(1)*C2
        NEUI.K(2)=-XRND(3)*XRND(2)
        NEUI.K(3)=XRND(3)*C1*C2

        NEUI.P=1.D0/c1/c2
        NEUI.T=0
        DUM=RAN1()            
        NEUI.S=2*NINT(DUM)-1
      ENDIF
      
c      if (mod(nevent,1000).EQ.0) then  
c        CALL GETSTATE(ITASK,NEVENT)      
c      endif  
      
      IF(SPEC_GO(ITASK)) THEN
            CALL MAXV_UPD(1)              
	    IF (SAFETY_POOL(I)) THEN    
               CALL SPEC_INI(1,ITASK)
               NEVENT=0
               NCNT=0
               RETURN
            ENDIF
            NCNT=NCNT+1
            CALL VALID_EVENT(ITASK,NCNT)
      ENDIF    
       
      RETURN
      END         
      
C------------------------------------------------------------------------
      SUBROUTINE VALID_EVENT(ITASK,NCNT)
C  Store event information
C  ITASK=1 ... inelastic scattering, TAS resolution
C  ITASK=2 ... sample -> source
C  ITASK=3 ... source -> sample
C  ITASK=4 ... sample -> source + sample(powder) -> detector (no analyser and col4)
C  ITASK=5 ... source -> sample + sample(powder) -> detector (no analyser and col4)
C  ITASK=6 ... source -> monitor(IMONIT) (using Vanad sample))
C  ITASK=7 ...
C  ITASK=8 ...  sample -> detector, TAS (diffusee inelastic)
C  ITASK=9  ... sample -> detector, PD (without anal. and col4), diffuse elastic 
C  ITASK=10 ... sample -> detector, PD (without anal. and col4), powder smaple 
C  ITASK=11 ... source -> detector, TAS, bragg scattering
C------------------------------------------------------------------------
      implicit none
      INCLUDE 'const.inc'
      INCLUDE 'inout.inc'
      INCLUDE 'structures.inc'
      INCLUDE 'ness_common.inc'
      INCLUDE 'rescal.inc'
      INCLUDE 'randvars.inc'
      INCLUDE 'sim_grf.inc'
 	
      RECORD /NEUTRON/ NEUI,NEUF,NEUI1,NEUF1,NEU
      INTEGER*4 I,ITASK,IX,IY,NCNT
      REAL*8 E(4),KKI,Z,PP
      REAL*4 V3xV3
      COMMON /NEUIF/ NEUI,NEUF,NEUI1,NEUF1     
      
      
      IF (ITASK.GT.1.AND.ITASK.LE.3) NEU=NEUI
      IF ((ITASK.GE.4.AND.ITASK.LE.11).OR.ITASK.EQ.1) NEU=NEUF1
      IF (ITASK.EQ.1) THEN 
        PP=NEUI.P*NEUF.P
      ELSE
        PP=NEU.P
      ENDIF
      CALL COV_UPD(XRND,PP)
C// intensity and flux at the sample are calculated using SCNT sums
      IF (ITASK.EQ.8) PP=NEUI.P*NEUF.P
      SCNT=SCNT+PP
      IF (ABS(NEU.R(1)).LE.5.AND.ABS(NEU.R(2)).LE.5) THEN
	SCNTF=SCNTF+PP
      ENDIF   
      IF ((ITASK.GE.2.AND.ITASK.LE.7).OR.(ITASK.EQ.11)) THEN      
C beam profile is accumulated
         KKI=V3XV3(NEU.K,NEU.K)
         
         E(1)=NEU.R(1)               
         E(2)=NEU.R(2)
         E(3)=HSQOV2M*(KKI-STP.KI**2)
         E(4)=NEU.T/1000   ! in [ms]             
         DEI=DEI+NEU.P*E(3)**2
         DEI0=DEI0+E(3)*NEU.P
         CALL EVARRAY(1,1,NCNT,E,NEU.P) 
	 DO I=1,3
	       E(I)=NEU.K(I)
	 ENDDO
c//	 E(3)=E(3)-STP.KI
	 E(4)=NEU.S
         CALL EVARRAY(1,0,NCNT,E,NEU.P)
C Accumulate gauge volume
         IF(ITASK.EQ.4.OR.ITASK.EQ.5) THEN
           IX=(NEUF.R(1)/SAM.SIZE(1)+0.5)*MIMAX+1
           IY=(NEUF.R(3)/SAM.SIZE(3)+0.5)*MIMAX+1
           IF(IX.GT.0.AND.IX.LE.MIMAX.AND.IY.GT.0.AND.IY.LE.MIMAX) THEN
             SVOL(IX,IY)=SVOL(IX,IY)+NEUF.P
           ENDIF
         ENDIF   
      ENDIF
      
      IF (ITASK.EQ.2) THEN
        CALL NSTORE_WRITE1(NCNT,NEUI)      
      ELSE IF (ITASK.EQ.8) THEN  ! get width in E
        CALL NSTORE_WRITE2(NCNT,NSEED,NEUF)
        CALL NSTORE_GETQE(NCNT,E,PP,0.)
                               
        Z=E(4)
        STAS=STAS+PP
        DEI=DEI+PP*Z**2
        DEI0=DEI0+PP*Z      
      ELSE IF (ITASK.EQ.9) THEN  ! get width in |Q|
        CALL NSTORE_WRITE2(NCNT,NSEED,NEUF)
        CALL NSTORE_GETQE(NCNT,E,PP,0.)
        Z=SQRT((STP.Q+E(1))**2+E(2)**2+E(3)**2)-STP.Q
        STAS=STAS+PP
        DEI=DEI+PP*Z**2
        DEI0=DEI0+PP*Z
      ELSE IF (ITASK.EQ.1) THEN  ! get width in E
        CALL NSTORE_WRITE1(NCNT,NEUI)
        CALL NSTORE_WRITE2(NCNT,NCNT,NEUF)
        CALL NSTORE_GETQE(NCNT,E,PP,0.)
        Z=E(4)
        STAS=STAS+PP
        DEI=DEI+PP*Z**2
        DEI0=DEI0+PP*Z
      ENDIF
      END
           
           
C------------------------------------------------------------------
      SUBROUTINE SCANMDET(FX,FY,DFY,N)
C// scan by multidetector (powder)
C// uses incident neutrons previously stored in KSTACK
C------------------------------------------------------------------
      implicit none
      INCLUDE 'const.inc'
      INCLUDE 'inout.inc'
      INCLUDE 'structures.inc'
      INCLUDE 'ness_common.inc'
      INCLUDE 'rescal.inc'
      INCLUDE 'randvars.inc'
            
      INTEGER*4 I,J,K,N,I2,NEV1,IALLOC,NCNT,NEVENT,NEVENT0,J0
      REAL*4 FX(N),FY(N),DFY(N)
      REAL*8 dx,xmax,xmin,omega0,vol1,SUMP,DTH     
      REAL*8 NTOT,NOUT
      RECORD /NEUTRON/ NEUI,NEUF,NEUI1,NEUF1
      COMMON /NEUIF/ NEUI,NEUF,NEUI1,NEUF1

      DTH=RES_DAT(i_DA4)
      xmax=DTH*N/2.
      xmin=-xmax
      dx=DTH
      DO I=1,N
         FX(I)=xmin+(I-0.5D0)*dx
      ENDDO
      DO I=1,N
            FY(I)=0.
            DFY(I)=0.
      ENDDO  
      CALL NSTORE_N(NEV1,I2,IALLOC)
      IF (NEV1.GT.0) THEN
      
      NEV1=NEV1/5
      
C// Scan center
      NTOT=0.D0 
      NOUT=1000.*NEV1
      CALL MAXV_UPD(0)
      CALL SPEC_INI(0,4)      
      OMEGA0=SOL3.FRAME.AXI
      DO I=1,6
            RNDLIST.ACTIVE(I)=0
            RNDLIST.LIMITS(I)=1
      ENDDO
      
      TMAT(2,7)=0.
      J0=(N+1)/2
      SOL3.FRAME.AXI=OMEGA0+FX(J0)*minute
      CALL SLIT_INIT(SOL3.FRAME)
      NCNT=0
      NEVENT=0            
      DO WHILE ((NCNT.LT.NEV1).AND.(NTOT.LT.NOUT))
        NTOT=NTOT+1.D0 
        IF (NEVENT.EQ.0) THEN
           VOL1=1
           DO I=1,RNDLIST.DIM
             VOL1=VOL1*RNDLIST.LIMITS(I)
           END DO
           CALL SPEC_INI(1,4)
           SUMP=0
        ENDIF 
        CALL NESS_RUN(NCNT,NEVENT,10)
        SUMP=SUMP+NEUI.P	 
      ENDDO
      IF(NTOT.GE.NOUT) THEN
         WRITE(*,*) 'TIMEOUT',NEVENT,NCNT
         RETURN
      ENDIF
      NEVENT0=NEVENT
      FY(J0)=IINC/SUMP*(VOL1*SCNT)/10. ! mm->cm
      CALL MAXV_UPD(2)
10    FORMAT(I3,2(2x,G12.6))
      WRITE(*,10) J0,FX(J0),FY(J0) 

      SCNT=1.
      DO J=J0+1,N
      IF (SCNT.GT.0) THEN
         SOL3.FRAME.AXI=OMEGA0+FX(J)*minute
         CALL SLIT_INIT(SOL3.FRAME)
         NCNT=0
         NEVENT=0      
         DO WHILE (NEVENT.LT.NEVENT0)
           IF (NEVENT.EQ.0) THEN
              VOL1=1
              DO I=1,RNDLIST.DIM
                VOL1=VOL1*RNDLIST.LIMITS(I)
              END DO
              CALL SPEC_INI(1,4)
              SUMP=0
          ENDIF 
           CALL NESS_RUN(NCNT,NEVENT,10)
           SUMP=SUMP+NEUI.P	 
         ENDDO
         FY(J)=IINC/SUMP*(VOL1*SCNT)/10.  	 
         DFY(J)=FY(J)/SQRT(1.+NCNT)  	 
         WRITE(*,10)J,FX(J),FY(J)
      ELSE  ! skip rest if last step was FY=0
         FY(J)=0.  	 
         DFY(J)=0.  	          
      ENDIF
      ENDDO
      SCNT=1.
      DO K=1,J0-1
      J=J0-K
      IF (SCNT.GT.0) THEN
         SOL3.FRAME.AXI=OMEGA0+FX(J)*minute         
         CALL SLIT_INIT(SOL3.FRAME)
         NCNT=0
         NEVENT=0      
         DO WHILE (NEVENT.LT.NEVENT0)
           IF (NEVENT.EQ.0) THEN
              VOL1=1
              DO I=1,RNDLIST.DIM
                VOL1=VOL1*RNDLIST.LIMITS(I)
              END DO
              CALL SPEC_INI(1,5)
              SUMP=0
           ENDIF 
           CALL NESS_RUN(NCNT,NEVENT,10)
           SUMP=SUMP+NEUI.P	 
         ENDDO
         FY(J)=IINC/SUMP*(VOL1*SCNT)/10.  	 
         DFY(J)=FY(J)/SQRT(1.+NCNT)  	 
         WRITE(*,10)J,FX(J),FY(J)
      ELSE
         FY(J)=0.  	 
         DFY(J)=0.  	          
      ENDIF
      ENDDO
                    
      SOL3.FRAME.AXI=OMEGA0
      CALL SLIT_INIT(SOL3.FRAME)
      
      ENDIF
      
      END

C-------------------------------------------------------------------
      SUBROUTINE GETPEAKPARAM(IVAR,suma,center,fwhm,wspread)
C Get peak parameters
C IVAR=3  .. from anything accumulated in SPCX,Y arrays
C IVAR=2  .. from |Q| distribution (powder curve)
C IVAR=1  .. from energy distribution (Vanad scan)
C otherwise .. spatial profile (along X) at the monitor
C-------------------------------------------------------------------
      implicit none
      INCLUDE 'const.inc'
      INCLUDE 'inout.inc'
      INCLUDE 'structures.inc'
      INCLUDE 'ness_common.inc'
      
      REAL*8 E(4),P,S0,S1,S2,suma,center,fwhm,WSPREAD,Z,CONV
      INTEGER*4 I,NCNT,IVAR,I1,IALLOC 
      
      suma=0
      center=0
      wspread=0
      fwhm=0
      IF (IVAR.EQ.3.AND.SPCN.GT.0) THEN
          suma=0.
          S0=0
          S1=0
          S2=0
          DO I=1,SPCN
           Z=SPCX(I)
           S0=S0+SPCY(I)
           S1=S1+SPCY(I)*Z
           S2=S2+SPCY(I)*Z**2
           if(SPCY(I).GT.suma) suma=SPCY(I)
          ENDDO
          IF(S0.GT.0) then
            center=S1/S0
            wspread=R8LN2*SQRT(ABS(S2/S0-center**2))
            CALL GETFWHM(SPCX,SPCY,SPCN,fwhm)
          ENDIF  
      ELSE IF (IVAR.EQ.2) THEN
        CONV=180*60/PI/SQRT(ABS(STP.KI**2-(STP.Q/2.)**2))
        CALL NSTORE_N(I1,NCNT,IALLOC)       ! get number of events NCNT
        IF (NCNT.GT.0) THEN
          S0=0
          S1=0
          S2=0
          DO I=1,NCNT
           CALL NSTORE_GETQE(I,E,P,0.)
           Z=SQRT((STP.Q+E(1))**2+E(2)**2+E(3)**2)-STP.Q
           Z=Z*CONV
           S0=S0+P
           S1=S1+P*Z
           S2=S2+P*Z**2
          ENDDO
          IF(S0.GT.0) THEN
            SPCN=SPCM
            suma=IPWD
            center=S1/S0
            wspread=R8LN2*SQRT(ABS(S2/S0-center**2))
            CALL THETA_SCAN(SPCX,SPCY,SPCD,SPCM)
            CALL GETFWHM(SPCX,SPCY,SPCM,fwhm)
          endif  
        ENDIF   
      ELSE IF (IVAR.EQ.1) THEN
        CALL NSTORE_N(I1,NCNT,IALLOC)       ! get number of events NCNT
        IF (NCNT.GT.0) THEN
          S0=0
          S1=0
          S2=0
          DO I=1,NCNT
           CALL NSTORE_GETQE(I,E,P,0.)
           S0=S0+P
           S1=S1+P*E(4)
           S2=S2+P*E(4)**2
          ENDDO
          IF(S0.GT.0) THEN          
            SPCN=SPCM
            suma=I3AX*IINC
            center=S1/S0
            wspread=R8LN2*SQRT(ABS(S2/S0-center**2))
            CALL E_SCAN(SPCX,SPCY,SPCD,SPCM)
            CALL GETFWHM(SPCX,SPCY,SPCM,fwhm)
          endif  
        ENDIF   
      ELSE      
        CALL EVARRAY(3,1,NCNT,E,P)         ! get number of events NCNT
        IF (NCNT.GT.0) THEN
          S0=0
          S1=0
          S2=0
          DO I=1,NCNT
           CALL EVARRAY(2,1,I,E,P)
           S0=S0+P
           S1=S1+P*E(1)
           S2=S2+P*E(1)**2
          ENDDO
          IF(S0.GT.0) THEN          
            SPCN=SPCM
            suma=sum
            center=S1/S0
            wspread=R8LN2*SQRT(ABS(S2/S0-center**2))
            CALL PSD_ARRAY(SPCX,SPCY,SPCD,SPCM)
            CALL GETFWHM(SPCX,SPCY,SPCM,fwhm)
          endif  
        ENDIF
      
      ENDIF
      END
C-------------------------------------------------------------------
      SUBROUTINE GETFWHM(X,Y,N,fwhm)
C Calculate fwhm      
C-------------------------------------------------------------------
      implicit none

      INTEGER*4 N,I,IMAX,I1,I2    
      REAL*4 X(N),Y(N),z1,z2
      REAL*8 YMAX,X1,X2,fwhm
      
      YMAX=Y(1)
      IMAX=1
      DO I=1,N         
         IF(YMAX.LE.Y(I)) THEN
           IMAX=I
           YMAX=Y(I)
         ENDIF  
      ENDDO
      I1=1
      DO WHILE ((Y(I1).LT.YMAX/2.D0).AND.(I1.LT.N))
        I1=I1+1
      ENDDO
      I2=N
      DO WHILE ((Y(I2).LT.YMAX/2.D0).AND.(I2.GT.0))
        I2=I2-1
      ENDDO
      IF((I1.GT.1).AND.(I1.LT.N).AND.(I2.GT.1).AND.(I2.LT.N).AND.
     *   (I1.LE.I2)) then
         z1= Y(I1)-Y(I1-1)
         z2=Y(I2+1)-Y(I2)
         if (z1.ne.0.and.z2.ne.0) then
         X1=X(I1-1)+(YMAX/2.D0-Y(I1-1))/(Y(I1)-Y(I1-1))*(X(I1)-X(I1-1))
         X2=X(I2)+(YMAX/2.D0-Y(I2))/(Y(I2+1)-Y(I2))*(X(I2+1)-X(I2))
         fwhm=x2-x1
         else
         fwhm=0.
         endif
      ELSE
         fwhm=0
      ENDIF
      END
      
C----------------------------------------------------      
      SUBROUTINE PSD_ARRAY(FX,FY,DFY,N)
C get beam profile integrated along vertical coordinate
C----------------------------------------------------            
      implicit none 
      INCLUDE 'const.inc'
      INCLUDE 'inout.inc'
      INCLUDE 'structures.inc'
      INCLUDE 'ness_common.inc'
      INTEGER*4 I,J,N,NCNT
      REAL*4 FX(N),FY(N),DFY(N),Y0(129)
      REAL*8 XYET(4),P,dx,sum1
      REAL*8 xmax,xmin      
      
      CALL EVARRAY(3,1,NCNT,XYET,P)         ! get number of events NCNT
      
      IF (NCNT.GT.0) THEN
      
      xmax=DET.FRAME.SIZE(1)/2.0D0
      xmin=-xmax
      dx=(xmax-xmin)/N
      DO I=1,N
         FX(I)=xmin+(I-0.5D0)*dx
      ENDDO
      DO I=1,N
            Y0(I)=0.
            FY(I)=0.
      ENDDO  
      sum1=0.        
      DO  I=1,NCNT
	  CALL EVARRAY(2,1,I,XYET,P) 
          J=INT((XYET(1)-xmin)/dx)+1
          IF (J.GE.1.AND.J.LE.N) THEN
            FY(J)=FY(J)+P
            Y0(J)=Y0(J)+1.
            sum1=sum1+P
          ENDIF
      ENDDO
      DO I=1,N
        FY(I)=FY(I)*sum/sum1
        IF(FY(I).GT.0.) THEN           
           DFY(I)=FY(I)/SQRT(Y0(I)/2.)
        ELSE
           DFY(I)=0.
        ENDIF 
      ENDDO 
      ENDIF         
      END
      
      
C----------------------------------------------------      
      SUBROUTINE E_SCAN(FX,FY,DFY,N)
C get Vanad scan profile from Q,E events
C----------------------------------------------------            
      implicit none 
      INCLUDE 'const.inc'
      INCLUDE 'inout.inc'
      INCLUDE 'structures.inc'
      INCLUDE 'ness_common.inc'
      INCLUDE 'rescal.inc'
      
            
      INTEGER*4 I,J,N,NCNT,I1,IALLOC
      REAL*4 FX(N),FY(N),DFY(N),Y0(129)
      REAL*8 QE(4),P,dx,sum1
      REAL*8 xmax,xmin,DE      
      
      CALL NSTORE_N(I1,NCNT,IALLOC)

c      write(*,*) 'E-SCAN: ',NCNT,STAS,SMON,SCNT
c      write(*,*) 'E-SCAN: ',IINC,I3AX,N
      IF (NCNT.GT.0.AND.STAS.GT.0.AND.SCNT.GT.0) THEN
      DE=RES_DAT(i_DEN)
      xmax=DE*N/2.
      xmin=-xmax
      dx=DE
      DO I=1,N
         FX(I)=xmin+(I-0.5D0)*dx
      ENDDO
      DO I=1,N
            FY(I)=0.
            Y0(I)=0.
      ENDDO  
      sum1=0.        
      DO  I=1,NCNT
	  CALL NSTORE_GETQE(I,QE,P,0.)
c      write(*,*) (QE(J),J=1,4),P
c      pause
          J=INT((QE(4)-xmin)/dx)+1
          IF (J.GE.1.AND.J.LE.N) THEN
            FY(J)=FY(J)+P
            Y0(J)=Y0(J)+1.
            sum1=sum1+P
          ENDIF
      ENDDO
      DO I=1,N
        FY(I)=FY(I)*IINC*I3AX/sum1
        IF(FY(I).GT.0.) THEN           
           DFY(I)=FY(I)/SQRT(Y0(I)/2.)
        ELSE
           DFY(I)=0.
        ENDIF 
c      write(*,*) FX(I),FY(I),DFY(I)
      ENDDO 
      ENDIF         
      END
      
      
C----------------------------------------------------      
      SUBROUTINE THETA_SCAN(FX,FY,DFY,N)
C get powder peak profile from Q,E events
C----------------------------------------------------            
      implicit none 
      INCLUDE 'const.inc'
      INCLUDE 'inout.inc'
      INCLUDE 'structures.inc'
      INCLUDE 'ness_common.inc'
      INCLUDE 'rescal.inc'
      
            
      INTEGER*4 I,J,N,NCNT,I1,IALLOC
      REAL*4 FX(N),FY(N),DFY(N),Y0(129)
      REAL*8 QE(4),P,dx,sum1,conv,QQ
      REAL*8 xmax,xmin,DTH   
      
      CALL NSTORE_N(I1,NCNT,IALLOC)
      IF (NCNT.GT.0.AND.STAS.GT.0.AND.SCNT.GT.0) THEN
      
      DTH=RES_DAT(i_DA4)
      xmax=DTH*N/2.
      xmin=-xmax
      dx=DTH
      DO I=1,N
         FX(I)=xmin+(I-0.5D0)*dx
      ENDDO
      DO I=1,N
            FY(I)=0.
            Y0(I)=0.
      ENDDO  
      sum1=0.
      conv=1.D0/SQRT(STP.KI**2-(STP.Q/2.)**2)/minute  ! conversion factor dQ->2dThetaS      
      DO  I=1,NCNT
	  CALL NSTORE_GETQE(I,QE,P,0.)
          QQ=SQRT((QE(1)+STP.Q)**2+QE(2)**2+QE(3)**2)-STP.Q
          QQ=QQ*conv
c          write(*,*) QQ,P
c          pause
          J=INT((QQ-xmin)/dx)+1
          IF (J.GE.1.AND.J.LE.N) THEN
            FY(J)=FY(J)+P
            Y0(J)=Y0(J)+1.
            sum1=sum1+P
          ENDIF
      ENDDO
      DO I=1,N
        FY(I)=FY(I)*IPWD/sum1
        IF(FY(I).GT.0.) THEN           
           DFY(I)=FY(I)/SQRT(Y0(I)/2.)
        ELSE
           DFY(I)=0.
        ENDIF 
      ENDDO 
      ENDIF         
      END
                    
CxxxxxxxxxCxxxxxxxxxCxxxxxxxxxCxxxxxxxxxCxxxxxxxxxCxxxxxxxxxCxxxxxxxxxCx
C
C  ****  Benchmark  **** 
C
CxxxxxxxxxCxxxxxxxxxCxxxxxxxxxCxxxxxxxxxCxxxxxxxxxCxxxxxxxxxCxxxxxxxxxCx


C------------------------------------------------------------------------
      SUBROUTINE NESS_BENCH(NCNT)
C     measures transmission speed for crystal, colimator and powder sample
C------------------------------------------------------------------------
      implicit none

      INCLUDE 'const.inc'
      INCLUDE 'inout.inc'
      INCLUDE 'structures.inc'
      INCLUDE 'ness_common.inc'
      INCLUDE 'randvars.inc'
	
      RECORD /NEUTRON/ NEUI
      INTEGER*4 I,NC,what,NCNT
      REAL*4 SECNDS
      LOGICAL*4 BENCH_CR,BENCH_SOL2,BENCH_PWD  
      REAL*4 T1(3),T2(3)
      CHARACTER*15 WhatCH(3)   
      real*4 RAN1,DUM 
      REAL*8  C1,C2
      DATA WhatCH/'Crystal: ','Colimator 2: ','Powder sample: '/ 
            
1     format(a15,G12.6,' events/sec   (',G10.4,' sec)')


      DO what=1,3
      NC=0
      CALL RAN1SEED(100001)
      DO WHILE (NC.LE.NCNT)
        CALL RANDFILL
        CALL M16XV16(-1,RNDLIST.DIM,TMAT,XNORM,XRND)
        do i=1,RNDLIST.DIM
          XRND(i)=XRND(i)+TMEAN(I)
        enddo  
      
        NEUI.R(1)=XRND(4)
        NEUI.R(2)=XRND(5)
        NEUI.R(3)=0.
c        DO I=1,3
c          NEUI.K(I)=XRND(I)
c        END DO
        IF(ABS(XRND(1)).GE.1.D0.OR.ABS(XRND(2)).GE.1.D0) THEN
          RETURN
        ENDIF
        C1=SQRT(ABS(1-XRND(1)**2))
        C2=SQRT(ABS(1-XRND(2)**2))
        NEUI.K(1)=XRND(3)*XRND(1)*C2
        NEUI.K(2)=-XRND(3)*XRND(2)
        NEUI.K(3)=XRND(3)*C1*C2
        NEUI.P=1.D0/C1/C2
        NEUI.T=0
        DUM=RAN1()            
        NEUI.S=2*NINT(DUM)-1
        if((mon.mag*NEUI.S).lt.0) NEUI.P=0
	if(what.eq.1) then
           IF (BENCH_CR(0,NEUI)) NC=NC+1
	else if(what.eq.2) then
           IF (BENCH_SOL2(0,NEUI)) NC=NC+1
	else if(what.eq.3) then
           IF (BENCH_PWD(0,NEUI)) NC=NC+1
	endif 
      END DO 
      T1(what)=SECNDS(0.0)
      NC=0
      CALL RAN1SEED(100001)
      DO WHILE (NC.LE.NCNT)
        CALL RANDFILL
        CALL M16XV16(-1,RNDLIST.DIM,TMAT,XNORM,XRND)
        do i=1,RNDLIST.DIM
          XRND(i)=XRND(i)+TMEAN(I)
        enddo        
        NEUI.R(1)=XRND(4)
        NEUI.R(2)=XRND(5)
        NEUI.R(3)=0.
c        DO I=1,3
c          NEUI.K(I)=XRND(I)
c        END DO
        IF(ABS(XRND(1)).GE.1.D0.OR.ABS(XRND(2)).GE.1.D0) THEN
          RETURN
        ENDIF
        C1=SQRT(ABS(1-XRND(1)**2))
        C2=SQRT(ABS(1-XRND(2)**2))
        NEUI.K(1)=XRND(3)*XRND(1)*C2
        NEUI.K(2)=-XRND(3)*XRND(2)
        NEUI.K(3)=XRND(3)*C1*C2
        NEUI.P=1.D0/C1/C2
        NEUI.T=0
        DUM=RAN1()            
        NEUI.S=2*NINT(DUM)-1
        if((mon.mag*NEUI.S).lt.0) NEUI.P=0 
	if(what.eq.1) then
           IF (BENCH_CR(1,NEUI)) NC=NC+1
	else if(what.eq.2) then
           IF (BENCH_SOL2(1,NEUI)) NC=NC+1
	else if(what.eq.3) then
           IF (BENCH_PWD(1,NEUI)) NC=NC+1
	endif   
      END DO 
      T2(what)=SECNDS(0.0)
      write(SOUT,1) WhatCH(what),
     *      NCNT/(T2(what)-T1(what)),T2(what)-T1(what)
      enddo
            
      RETURN
      END         



C------------------------------------------------------------------------
      SUBROUTINE NESS_ROCK(ICR,NC,NTH,DTH,RTH,DIVH,DIVV)
C     measures rocking curve of the monochromator
C------------------------------------------------------------------------
      implicit none

      INCLUDE 'const.inc'
      INCLUDE 'inout.inc'
      INCLUDE 'structures.inc'
      INCLUDE 'ness_common.inc'
	
      RECORD /NEUTRON/ NEUI,NEU
      INTEGER*4 ICR,I,I1,I2,IMAX,NTH,NC,ISTEP,IEV,NC0
      REAL*8 Z1,Z2,fwhm,center,sprd,rmax,theta,theta0,sum1,sum2,DTH
      REAL*8 RTH(NTH),gon1,DIVH,DIVV
      LOGICAL*4 CRYST_GO2 
      REAL*8 ALFH,ALFV,SUMP,PP,KK !,DUM
      REAL*4 RAN1,KSI1,KSI2
      RECORD /CRYSTAL/ CR 
       
            
1     format('fwhm: ',E10.3,' [min]  , center: ',
     1        E10.3,' [min]   R0: ',E10.3)
2     format('fwhm: ',E10.3,' [steps], center: ',
     1        E10.3,' [steps]')

       
      IF (ICR.EQ.2) THEN
        KK=STP.KF
        CR=ANA
      ELSE
        KK=STP.KI
        CR=MON
      ENDIF  
      NC0=NC
      IF(CR.HMOS.LT.SEC.AND.CR.NB.EQ.1.AND.CR.NH.EQ.1) NC0=1
      theta0=CR.THB
      gon1=CR.FRAME.GON(1)
      DO ISTEP=1,NTH
        RTH(ISTEP)=0     
        theta=(-(NTH-1)/2.+ISTEP-1)*DTH
        CR.FRAME.GON(1)=gon1+theta
        CALL CRYST_INIT2(CR)     
        SUMP=0.
c        DUM=0.
        DO IEV=1,NC0
          NEUI.R(1)=2.*CR.DH
          NEUI.R(2)=2.*CR.DV
          NEUI.R(3)=2.*CR.DB+CR.FRAME.DIST
          PP=1.
          ALFH=0.
          ALFV=0.
          IF (DIVH.GT.0) THEN
            KSI1=RAN1()         
            ALFH=(2.0*KSI1-1.0)*DIVH
            PP=PP*(1.-ABS(ALFH/DIVH))            
          ENDIF 
          IF (DIVV.GT.0) THEN
            KSI2=RAN1()         
            ALFV=(2.0*KSI2-1.0)*DIVV
            PP=PP*(1.-ABS(ALFV/DIVV))
          ENDIF 
          NEUI.K(1)=KK*ALFH
          NEUI.K(2)=KK*ALFV
          NEUI.K(3)=KK
          Z1=SQRT(NEUI.K(1)**2+NEUI.K(2)**2+NEUI.K(3)**2)
          DO I=1,3
            NEUI.K(I)=NEUI.K(I)*KK/Z1
          ENDDO  
          NEUI.P=PP
          NEUI.T=0
c          DUM=DUM+ALFH*180*60/PI
c3            format(6(1x,G11.4))
c           write(*,3) ALFH*180*60/PI,ALFV*180*60/PI,PP,DUM/IEV,KSI1,KSI2
c          pause
          IF (CRYST_GO2(CR,NEUI,NEU)) THEN
            RTH(ISTEP)=RTH(ISTEP)+NEU.P
          ENDIF
          SUMP=SUMP+NEUI.P
        END DO 
        RTH(ISTEP)=RTH(ISTEP)/SUMP   
      END DO 
      RMAX=0
      SUM1=0
      SUM2=0   
      DO I=1,NTH
         IF (RTH(I).GT.RMAX) THEN
           RMAX=RTH(I)
           IMAX=I
         ENDIF  
         SUM1=SUM1+RTH(I)
         SUM2=SUM2+RTH(I)**2
      ENDDO 
      CENTER=SUM1/NTH
      sprd=2.35*SQRT(SUM2/NTH-CENTER**2)
      I1=2
      I2=NTH-1
      DO I=1,NTH
         IF(I1.EQ.2.AND.RTH(I).GT.RMAX/2.) I1=I-1
         IF(I2.EQ.NTH-1.AND.I.GT.IMAX.AND.RTH(I).LT.RMAX/2.) I2=I-1
      ENDDO      
      z1=I1+(RMAX/2.-RTH(I1))/(RTH(I1+1)-RTH(I1))
      z2=I2+(RMAX/2.-RTH(I2))/(RTH(I2+1)-RTH(I2))
      fwhm=Z2-Z1
      write(SOUT,1) fwhm*DTH*180*60/PI,center*DTH*180*60/PI,RMAX 
      write(SOUT,2) fwhm,center
      CR.THB=theta0
      CR.FRAME.GON(1)=GON1
      CALL CRYST_INIT2(CR)
      SPCN=NTH
      if (SPCN.GT.65) SPCN=65     
      do i=1,SPCN
          SPCX(i)=(-(NTH-1)/2.+I-1)*DTH*180*60/pi
          SPCY(i)=RTH(I)
          SPCD(i)=RTH(I)/SQRT(1.D0*(NC0+1))
      enddo      
            
      RETURN
      END         

C------------------------------------------------------------------------
      SUBROUTINE TEST_SYMMETRY(NC,NTH,DTH,DIVH,DIVV)
C     measures rocking curve of the monochromator
C------------------------------------------------------------------------
      implicit none

      INCLUDE 'const.inc'
      INCLUDE 'inout.inc'
      INCLUDE 'structures.inc'
      INCLUDE 'ness_common.inc'
	
      RECORD /NEUTRON/ NEUI,NEU,NEU1
      INTEGER*4 I,NTH,NC,ISTEP,IEV,NC0
      REAL*8 Z1,theta0,DTH
      REAL*8 gon1,DIVH,DIVV,dist0
      LOGICAL*4 CRYST_GO2 
      REAL*8 ALFH,ALFV,SUMP,PP,TIn,TOUT !,DUM
      REAL*4 RAN1,KSI1,KSI2
            
      NC0=10
      IF(MON.HMOS.LT.SEC.AND.MON.NB.EQ.1.AND.MON.NH.EQ.1) NC0=1
      theta0=MON.THB
      dist0=MON.FRAME.DIST
      MON.FRAME.DIST=0.
      gon1=MON.FRAME.GON(1)
      DO ISTEP=1,NTH
        SUMP=0.
c        DUM=0.
        DO IEV=1,NC0
          NEUI.R(1)=2.*MON.DH
          NEUI.R(2)=2.*MON.DV
          NEUI.R(3)=2.*MON.DB
          PP=1.
          ALFH=0.
          ALFV=0.
          IF (DIVH.GT.0) THEN
            KSI1=RAN1()         
            ALFH=(2.0*KSI1-1.0)*DIVH
            PP=PP*(1.-ABS(ALFH/DIVH))            
          ENDIF 
          IF (DIVV.GT.0) THEN
            KSI2=RAN1()         
            ALFV=(2.0*KSI2-1.0)*DIVV
            PP=PP*(1.-ABS(ALFV/DIVV))
          ENDIF 
          NEUI.K(1)=STP.KI*ALFH
          NEUI.K(2)=STP.KI*ALFV
          NEUI.K(3)=STP.KI
          Z1=SQRT(NEUI.K(1)**2+NEUI.K(2)**2+NEUI.K(3)**2)
          DO I=1,3
            NEUI.K(I)=NEUI.K(I)*STP.KI/Z1
          ENDDO  
          NEUI.P=PP
          NEUI.T=0
          MON.FRAME.GON(1)=gon1
          CALL CRYST_INIT2(MON)     
          IF (CRYST_GO2(MON,NEUI,NEU)) THEN
            NEU1.P=NEUI.P
            CALL SLIT_PRE1(MON.FRAME,NEUI.R,NEUI.K,NEU1.R,NEU1.K)
            call CR_BORDER(MON,NEU1.R,NEU1.K,TIN,TOUT)            
            DO I=1,3
              NEU1.R(I)=NEU1.R(I)+TIN*NEU1.K(I)
            END DO
            call wrtneu(NEU1)
            NEU1.P=NEU.P
            CALL SLIT_PRE1(MON.FRAME,NEU.R,NEU.K,NEU1.R,NEU1.K)
            call wrtneu(NEU1)
            DO I=1,3
              NEU.K(I)=-NEU.K(I)
            ENDDO
            NEU.P=1.
c            MON.FRAME.GON(1)=-gon1-2.*MON.CHI
c            CALL CRYST_INIT2(MON)     
            NEU1.P=NEU.P
            CALL SLIT_PRE1(MON.FRAME,NEU.R,NEU.K,NEU1.R,NEU1.K)
            call wrtneu(NEU1)
            DO I=1,10
              IF (CRYST_GO2(MON,NEU,NEUI)) THEN
                NEU1.P=NEUI.P
                CALL SLIT_PRE1(MON.FRAME,NEUI.R,NEUI.K,NEU1.R,NEU1.K)
                call wrtneu(NEU1)
              ELSE
                write(*,*) 'lost back'
              ENDIF
            ENDDO
            pause
          ELSE
            write(*,*) 'lost forth'
          ENDIF
        END DO 
      END DO 
      MON.THB=theta0
      MON.FRAME.GON(1)=GON1
      MON.FRAME.DIST=dist0
      CALL CRYST_INIT2(MON)
            
      END         
      
      REAL*4 FUNCTION OPTMC(PAR)
C***********************************************************************
C   returns value to be minimized when optimizing bending radii by M.C.
C   J.S. 5/7/2001
C***********************************************************************
      IMPLICIT NONE
      
      INCLUDE 'const.inc'
      INCLUDE 'inout.inc'
      INCLUDE 'structures.inc'
      INCLUDE 'ness_common.inc'
      INCLUDE 'trax.inc'
      INCLUDE 'rescal.inc'
      
      REAL*8 EPS
      PARAMETER(EPS=1.D-10)
      REAL*4 B(4),PAR(1),Z
      INTEGER*4 OPTPAR,OPTMERIT
      REAL*8 OPTEV
      COMMON /MCOPTIM/ OPTPAR,OPTMERIT,OPTEV
      INTEGER*4 I
      
      DO I=1,4
        B(I)=RES_DAT(i_ROMH+I-1)
      ENDDO
      DO I=1,4
        IF (OPTPAR.EQ.I) RES_DAT(i_ROMH+I-1)=PAR(1)
      ENDDO

c      CALL BEFORE  ! should call this in some cases, not for ROMH..ROAV
      CALL NESS_CONV(0)
      
c1     format(a,2(2x,I3),2(2x,G12.6),$)
c      write(*,1) 'OPTMC: ',OPTPAR,OPTMERIT,OPTEV,PAR(1)
      	
      Z=0.
      IF (OPTMERIT.EQ.1) THEN
        CALL NESS(2,OPTEV)
        IF (IINC.GE.EPS) Z=1.D8/IINC
      ELSE IF (OPTMERIT.EQ.2) THEN
        CALL NESS(2,OPTEV)
        IF (IINC.GE.EPS) Z=1.D8*EINC/IINC
      ELSE IF (OPTMERIT.EQ.3) THEN
        CALL NESS(2,OPTEV)
        IF (IINC.GE.EPS) Z=1.D8*EINC**2/IINC
      ELSE IF (OPTMERIT.EQ.4) THEN
        CALL NESS(9,OPTEV)
        IF (IPWD.GE.EPS) Z=1.D8*SPWD**2/IPWD
      ELSE IF (OPTMERIT.EQ.5) THEN
        CALL NESS(4,OPTEV)
        IF (IPWD.GE.EPS) Z=1.D8*SPWD**2/IPWD
      ELSE IF (OPTMERIT.EQ.6) THEN
        CALL NESS(8,OPTEV)
        IF (IINC*I3AX.GE.EPS) Z=1.D8*E3AX**2/(IINC*I3AX)
      ENDIF  
      OPTMC=Z
      DO I=1,4
        RES_DAT(i_ROMH+I-1)= B(I)
      ENDDO
c      write(*,*) Z
      END

C***********************************************************************
      REAL*4 FUNCTION CHI2SPC(PAR)
C   returns value to be minimized when fitting gaussian to the data in SPCX,Y,DY array.
C***********************************************************************
      IMPLICIT NONE
      
      INCLUDE 'const.inc'
      INCLUDE 'inout.inc'
      INCLUDE 'structures.inc'
      INCLUDE 'ness_common.inc'
      
      REAL*8 Z
      REAL*4 PAR(3),CHI
      INTEGER*4 I
     
      CHI=0
      PAR(3)=ABS(PAR(3))
      IF (ABS(PAR(3)).LT.1E-10) PAR(3)=1E-10
      DO I=1,SPCN
        IF(SPCD(I).NE.0) THEN
          Z=PAR(1)*EXP(-0.5*(SPCX(I)-PAR(2))**2/(PAR(3)/R8LN2)**2)
          CHI=CHI+((SPCY(I)-Z))**2
        ENDIF 
      ENDDO
      CHI2SPC=CHI

      END
