                  
C---------------------------------------------------------------
      LOGICAL FUNCTION TAS1_GO2()
C     trace primary TAS spectrometer from the source
C---------------------------------------------------------------
      implicit none

      INCLUDE 'const.inc'
      INCLUDE 'inout.inc'
      INCLUDE 'structures.inc'
      INCLUDE 'ness_common.inc'
	
      RECORD /NEUTRON/ NEUI,NEUF,NEUI1,NEUF1,NEU,NEU1
      LOGICAL BENDER_GO,CRYST_GO2,SOURCE_GO
      LOGICAL LOG ! ,SAM_BOARDER
c      REAL*8 T1,T2
      COMMON /NEUIF/ NEUI,NEUF,NEUI1,NEUF1

      LOG=.TRUE.
c      LOG=SAM_BOARDER(SAM,NEUI.R,NEUI.K,T1,T2)
      NEUI1=NEUI
c      LOG=(LOG.AND.NEUI1.P.GT.0) 
      IF(LOG) LOG=(LOG.AND.SOURCE_GO(SOU,NEUI1,NEU1))
      IF(LOG) LOG=(LOG.AND.BENDER_GO(GDEa,NEU1,NEU))
      IF(LOG) LOG=(LOG.AND.BENDER_GO(GUIDE,NEU,NEU1))
      IF(LOG) LOG=(LOG.AND.BENDER_GO(SOL1,NEU1,NEU))
      IF(LOG) LOG=(LOG.AND.CRYST_GO2(MON,NEU,NEU1))
      if (MON.NH.EQ.0) THEN
  	    NEUI=NEU1
  	    TAS1_GO2=LOG
  	    RETURN
      endif            
      IF(LOG) LOG=(LOG.AND.BENDER_GO(SOL2a,NEU1,NEU))
      IF(LOG) LOG=(LOG.AND.BENDER_GO(SOL2,NEU,NEUI))
      IF(FLIPM.EQ.1) NEUI.S=-NEUI.S 
      TAS1_GO2=LOG
      END  

C---------------------------------------------------------------
      LOGICAL FUNCTION FLUX_GO2()
C     simulate incident flux, start at the source
C---------------------------------------------------------------
      implicit none

      INCLUDE 'const.inc'
      INCLUDE 'inout.inc'
      INCLUDE 'structures.inc'
      INCLUDE 'ness_common.inc'
	
      RECORD /NEUTRON/ NEUI,NEUF,NEUI1,NEUF1,NEU
      LOGICAL SLIT_GO,TAS1_GO2
      LOGICAL LOG
      COMMON /NEUIF/ NEUI,NEUF,NEUI1,NEUF1
        
      LOG= TAS1_GO2() 
      if (MON.NH.EQ.0) THEN
  	    FLUX_GO2=LOG
  	    RETURN
      endif            
      NEU=NEUI
      IF(LOG) LOG=(LOG.AND.SLIT_GO(SAM,NEU,NEUI)) 
      FLUX_GO2=LOG
      END  

C---------------------------------------------------------------        
      LOGICAL FUNCTION DIFF_GO2()
C     trace from the source to the detector with pwd. sample
C---------------------------------------------------------------
      implicit none      

      INCLUDE 'const.inc'
      INCLUDE 'inout.inc'
      INCLUDE 'structures.inc'
      INCLUDE 'ness_common.inc'
	
      RECORD /NEUTRON/ NEUI,NEUF,NEUI1,NEUF1,NEU,NEU1 
      LOGICAL BENDER_GO,SLIT_GO,TAS1_GO2,PWD_GO
      LOGICAL LOG          
      COMMON /NEUIF/ NEUI,NEUF,NEUI1,NEUF1
      
      LOG=TAS1_GO2()
      IF(LOG) LOG=(LOG.AND.PWD_GO(SAM,NEUI,NEUF,STP.Q*STP.SS)) 
      NEU1=NEUF
      IF(FLIPA.EQ.1) NEU1.S=-NEU1.S 
      IF(LOG) LOG=(LOG.AND.BENDER_GO(SOL3,NEU1,NEU))
      IF(LOG) LOG=(LOG.AND.SLIT_GO(DET,NEU,NEUF1))      
      DIFF_GO2=LOG
      END

C---------------------------------------------------------------        
      LOGICAL FUNCTION MONIT_GO2()
C     trace from the source to the monitor at position IMONIT
C---------------------------------------------------------------
      implicit none      

      INCLUDE 'const.inc'
      INCLUDE 'inout.inc'
      INCLUDE 'structures.inc'
      INCLUDE 'ness_common.inc'
	
      RECORD /NEUTRON/ NEUI,NEUF,NEUI1,NEUF1,NEU,NEU1 
      LOGICAL BENDER_GO,SLIT_GO,CRYST_GO2,SOURCE_GO,VAN_GO,VAN_TRANS
      LOGICAL LOG 
      INTEGER*4 M   
      REAL*8 LL,K0
      INTEGER*4 I
      COMMON /NEUIF/ NEUI,NEUF,NEUI1,NEUF1

      LOG=.TRUE.
      NEUI1=NEUI
      LOG=(NEUI1.P.GT.0) 
      M=IMONIT
      IF(LOG) LOG=(LOG.AND.SOURCE_GO(SOU,NEUI1,NEU1))
      IF (M.EQ.0) GOTO 101      
      IF(LOG) LOG=(LOG.AND.BENDER_GO(GDEa,NEU1,NEU))
      IF (M.EQ.1) GOTO 100
      IF(LOG) LOG=(LOG.AND.BENDER_GO(GUIDE,NEU,NEU1))
      IF (M.EQ.2) GOTO 101
      IF(LOG) LOG=(LOG.AND.BENDER_GO(SOL1,NEU1,NEU))
      IF (M.EQ.3) GOTO 100
      IF (.NOT.LOG) GOTO 111    
      IF(LOG) LOG=(LOG.AND.CRYST_GO2(MON,NEU,NEU1))
      IF (M.EQ.4) GOTO 101
      IF(LOG) LOG=(LOG.AND.BENDER_GO(SOL2a,NEU1,NEU))
      IF (M.EQ.5) GOTO 100
      IF(LOG) LOG=(LOG.AND.BENDER_GO(SOL2,NEU,NEUI))
      IF (M.EQ.6) THEN
         NEU1=NEUI
         GOTO 101
      ENDIF   
      IF(FLIPM.EQ.1) NEUI.S=-NEUI.S 
      IF(M.EQ.7) THEN
        IF(LOG) LOG=(LOG.AND.VAN_TRANS(SAM,NEUI,NEUF)) 
        LL=(SOL3.FRAME.DIST-NEUF.R(3))
        DO i=1,2
          NEUF.R(I)=NEUF.R(I)+LL*NEUF.K(I)/NEUF.K(3)        
        ENDDO
        NEU=NEUF
        GOTO 100
      ENDIF  
      IF (.NOT.LOG) GOTO 111      
      IF(LOG) LOG=(LOG.AND.VAN_GO(SAM,NEUI,NEUF,STP.Q*STP.SS)) 
      NEU1=NEUF
      IF(FLIPA.EQ.1) NEU1.S=-NEU1.S 
      IF(LOG) LOG=(LOG.AND.BENDER_GO(SOL3,NEU1,NEU))
      IF (M.EQ.8) GOTO 100
      IF(LOG) LOG=(LOG.AND.CRYST_GO2(ANA,NEU,NEU1))
      IF (M.EQ.9) GOTO 101
      IF (LOG) LOG=(LOG.AND.BENDER_GO(SOL4,NEU1,NEU))
      IF (M.EQ.10) GOTO 100
      IF(LOG) LOG=(LOG.AND.SLIT_GO(DET,NEU,NEUF1))      
      MONIT_GO2=.TRUE.
      RETURN
      
100   NEUF1=NEU
      IF (NORMMON.NE.0) THEN ! calculate capture flux
        K0=SQRT(NEUF1.K(1)**2+NEUF1.K(2)**2+NEUF1.K(3)**2)
        NEUF1.P=NEUF1.P*2*PI/K0/1.8D0
      ENDIF
      MONIT_GO2=LOG
      RETURN      

101   NEUF1=NEU1
      IF (NORMMON.NE.0) THEN ! calculate capture flux
        K0=SQRT(NEUF1.K(1)**2+NEUF1.K(2)**2+NEUF1.K(3)**2)
        NEUF1.P=NEUF1.P*2*PI/K0/1.8D0
      ENDIF
      MONIT_GO2=LOG
      RETURN      

111   MONIT_GO2=.FALSE.
      END

C--------------------------------------------------------      
      SUBROUTINE WrtNEU(NEU)

      INCLUDE 'structures.inc'
	
      RECORD /NEUTRON/ NEU
      
1      format(7(1x,G10.4))
       write(*,1) (NEU.R(i),i=1,3),(NEU.K(i),i=1,3),NEU.P
      END


C--------------------------------------------------------      
      SUBROUTINE FORW_INI(ITASK)
C     Clears all necessary variables and, if ICLR<>1, 
C     initializes objects and limits of random variables
C--------------------------------------------------------
      implicit none

      INCLUDE 'const.inc'
      INCLUDE 'inout.inc'
      INCLUDE 'structures.inc'
      INCLUDE 'ness_common.inc'
      INCLUDE 'randvars.inc'
      INCLUDE 'source.inc'
	
      INTEGER*4 ITASK,NEV
      LOGICAL*4 VERBOSE
      COMMON /MCSETTING/ VERBOSE,NEV
      REAL*8 lzm,lms,Z0,Z1,Z2,W1,H1,ctm,stb,eps,eps1,stpch,B
      REAL*8 avmin,a1,a2,a3,a4,ahmin
      INTEGER*4 I,J
       
C///  revert primary spectrometer for the forward tracing:
C/// NESS_CONV and SPEC_INI must be allways called before !!

      Z1=SOU.DIST+SOL1.FRAME.DIST+GUIDE.FRAME.DIST+GDEa.FRAME.DIST
      Z2=MON.FRAME.DIST+SOL2.FRAME.DIST+SOL2a.FRAME.DIST

      
      SAM.DIST=SOL2.FRAME.DIST+SOL2.FRAME.SIZE(3)
      SOL2a.FRAME.DIST=Z2-SOL2.FRAME.DIST-
     1                 SOL2a.FRAME.DIST-SOL2a.FRAME.SIZE(3)

      SOL2.FRAME.DIST=Z2-SAM.DIST-SOL2a.FRAME.DIST
      W1=SOL2.FRAME.SIZE(1)  
      H1=SOL2.FRAME.SIZE(2)
      SOL2.FRAME.SIZE(1)=SOL2.W2
      SOL2.FRAME.SIZE(2)=SOL2.H2
      SOL2.W2=W1
      SOL2.H2=H1
      SOL2.FRAME.AXI=0
      IF (SOL2.TYP.LE.1) SOL2.CH=-SOL2.CH

      W1=SOL2a.FRAME.SIZE(1)
      H1=SOL2a.FRAME.SIZE(2)
      SOL2a.FRAME.SIZE(1)=SOL2a.W2
      SOL2a.FRAME.SIZE(2)=SOL2a.H2
      SOL2a.W2=W1
      SOL2a.H2=H1
      SOL2a.FRAME.AXI=-SOL1.FRAME.AXI
      IF (SOL2a.TYP.LE.1) SOL2a.CH=-SOL2a.CH
      
      MON.FRAME.DIST=SOL1.FRAME.DIST+SOL1.FRAME.SIZE(3)
      MON.FRAME.GON(1)=-MON.FRAME.GON(1) -2*MON.CHI      
                          
      GDEa.FRAME.DIST=Z1-SOL1.FRAME.DIST-GUIDE.FRAME.DIST-
     1                 GDEa.FRAME.DIST-GDEa.FRAME.SIZE(3)        
      W1=GDEa.FRAME.SIZE(1)  
      H1=GDEa.FRAME.SIZE(2)
      GDEa.FRAME.SIZE(1)=GDEa.W2
      GDEa.FRAME.SIZE(2)=GDEa.H2
      GDEa.W2=W1
      GDEa.H2=H1 
      IF (GDEa.TYP.LE.1) GDEa.CH=-GDEa.CH

      Z1=Z1-GDEa.FRAME.DIST
      GUIDE.FRAME.DIST=Z1-SOL1.FRAME.DIST-GUIDE.FRAME.DIST
     1                 -GUIDE.FRAME.SIZE(3)        
      W1=GUIDE.FRAME.SIZE(1)  
      H1=GUIDE.FRAME.SIZE(2)
      GUIDE.FRAME.SIZE(1)=GUIDE.W2
      GUIDE.FRAME.SIZE(2)=GUIDE.H2
      GUIDE.W2=W1
      GUIDE.H2=H1 
      IF (GUIDE.TYP.LE.1) GUIDE.CH=-GUIDE.CH

      Z1=Z1-GUIDE.FRAME.DIST
      SOL1.FRAME.DIST=Z1-SOL1.FRAME.DIST-SOL1.FRAME.SIZE(3)
      W1=SOL1.FRAME.SIZE(1)  
      H1=SOL1.FRAME.SIZE(2)
      SOL1.FRAME.SIZE(1)=SOL1.W2
      SOL1.FRAME.SIZE(2)=SOL1.H2
      SOL1.W2=W1
      SOL1.H2=H1
      SOL1.FRAME.AXI=0
      IF (SOL1.TYP.LE.1) SOL1.CH=-SOL1.CH
      
      SOU.DIST=0     
      
      CALL SLIT_INIT(SOU)
      CALL BENDER_INIT(GDEa)
      CALL BENDER_INIT(GUIDE)
      CALL BENDER_INIT(SOL1)
      CALL CRYST_INIT2(MON)
      CALL BENDER_INIT(SOL2a)
      CALL BENDER_INIT(SOL2)
      CALL SLIT_INIT(SAM)
                     
      lzm=sol1.frame.dist+mon.frame.dist+guide.frame.dist+
     1      gdea.frame.dist
      lms=sol2.frame.dist+sol2a.frame.dist+sam.dist
      ctm=sign(1,stp.sm)/tan(mon.thb)
      stb=sin(mon.thb)       
      eps1=1-2*mon.rv*abs(stb)*lms
         	 
C//// minimum vertical aperture:         
      avmin=1.D+35
      if (guide.frame.size(3).gt.0.AND.guide.frame.dist.GT.0) then
         a1=(sou.size(2)+guide.frame.size(2))/
     1      (guide.frame.dist+gdea.frame.dist)
         a2=(guide.h2+guide.frame.size(2))/guide.frame.size(3)/guide.nlv
         a3=guide.GVT*4*PI/STP.KI
         a4=abs((guide.frame.size(2)+mon.frame.size(2))/
     1       (lzm-guide.frame.dist-gdea.frame.dist))     
          avmin=MIN(avmin,a1,MAX(a2,a3),MAX(a3,a4))
      endif
      if (guide.GVT.eq.0.D+0.and.
     1      sol1.frame.size(3).gt.0.AND.sol1.frame.dist.GT.0) then
         a1=(sou.size(2)+sol1.frame.size(2))/
     1          (guide.frame.dist+sol1.frame.dist+gdea.frame.dist)
         a2=(sol1.h2+sol1.frame.size(2))/sol1.frame.size(3)/sol1.nlv
         a3=sol1.GVT*4*PI/STP.KI
         a4=abs((sol1.frame.size(2)+mon.frame.size(2))/
     1       (lzm-guide.frame.dist-sol1.frame.dist-gdea.frame.dist))     
         avmin=MIN(avmin,a1,MAX(a2,a3),MAX(a3,a4))
      endif
      if (sol1.GVT.eq.0.D+0.and.guide.GVT.eq.0.D+0) then	
         avmin=MIN(avmin,(sou.size(2)+mon.frame.size(2)*stb)/lzm)	
      endif  
	           
C//// minimum horizontal aperture:          
      ahmin=1.D+35
      if (guide.frame.size(3).gt.0.AND.guide.frame.dist.GT.0) then
         a1=(sou.size(1)+guide.frame.size(1))/
     1      (guide.frame.dist+gdea.frame.dist)
         a2=(guide.w2+guide.frame.size(1))/guide.frame.size(3)/guide.nlh
         a3=guide.GHLU*4*PI/STP.KI
         a4=abs((guide.frame.size(1)+mon.frame.size(1)*stb)/
     1       (lzm-guide.frame.dist-gdea.frame.dist))     
         ahmin=MIN(ahmin,a1,MAX(a2,a3),MAX(a3,a4))
      endif
      if (guide.GHLU.eq.0.D+0.and.
     1      sol1.frame.size(3).gt.0.AND.sol1.frame.dist.GT.0) then
         a1=(sou.size(1)+sol1.frame.size(1))/
     1       (sol1.frame.dist+guide.frame.dist+gdea.frame.dist)
         a2=(sol1.w2+sol1.frame.size(1))/sol1.frame.size(3)/sol1.nlh
         a3=sol1.GHLU*4*PI/STP.KI
         a4=abs((sol1.frame.size(1)+mon.frame.size(1)*stb)/
     1       (lzm-guide.frame.dist-sol1.frame.dist-gdea.frame.dist))     
         ahmin=MIN(ahmin,a1,MAX(a2,a3),MAX(a3,a4))
      endif
      if (sol1.GHLU.eq.0.D+0.and.guide.GHLU.eq.0.D+0) then	
	 ahmin=MIN(ahmin,(sou.size(1)+mon.frame.size(1)*stb)/lzm)
      endif  
                  
C// common constraints for simulation started at the source
         
      TMAT(5,2)=-eps1/(lzm*eps1+lms)
      TMAT(2,5)=0
      RNDLIST.LIMITS(2)=
     1   MIN(avmin,sam.size(2)/(lms+lzm)+abs(3*mon.vmos*stb)) 
      RNDLIST.LIMITS(5)=sou.size(2)

C!! New horizontal optimization - 28/1/2000  !!!

      stpch=sin(mon.thb+mon.chi)
      eps=stpch/mon.stmch
      B=eps-2*mon.rh*lms/mon.stmch	  
      RNDLIST.LIMITS(1)=abs(ahmin)*RNDLIST.POOL(1)
      TMAT(4,3)=-mon.rh*stp.ki/mon.stmch*ctm
      TMAT(1,3)=(1-lzm*mon.rh/mon.stmch)*ctm*stp.ki
      RNDLIST.LIMITS(3)=SQRT((4*mon.hmos)**2+(mon.rh*
     1  mon.frame.size(3)*mon.ctmch/mon.stmch)**2)*stp.ki*abs(ctm)
      RNDLIST.LIMITS(4)=SOU.SIZE(1)*RNDLIST.POOL(4)

C// Only primary beamline, without monochromator
      if (mon.nh.eq.0.OR.
     * (ITASK.EQ.7.AND.IMONIT.GE.0.AND.IMONIT.LT.4)) then
	  RNDLIST.LIMITS(1)=ahmin
	  RNDLIST.LIMITS(2)=avmin
	  RNDLIST.LIMITS(4)=sou.size(1)
	  RNDLIST.LIMITS(5)=sou.size(2)
	  RNDLIST.ACTIVE(3)=0
          if (FLXN.GT.0) then
               Z0=2*PI/FLXLAM(1)
               Z1=2*PI/FLXLAM(FLXN)
               TMEAN(3)=(Z1+Z0)/2
               RNDLIST.LIMITS(3)=ABS(Z1-Z0)
	       RNDLIST.ACTIVE(3)=1
          ELSE    
  	       RNDLIST.LIMITS(3)=0.01*stp.ki
          ENDIF  
          if (FLXH.GT.0) then
               RNDLIST.ACTIVE(1)=0
               RNDLIST.LIMITS(1)=FLXH*1.2                
          ENDIF
          if (FLXV.GT.0) then
               RNDLIST.ACTIVE(2)=0
               RNDLIST.LIMITS(2)=FLXV*1.2
          ENDIF
          DO  I=1,6
          DO  J=1,6
            IF (I.NE.J) THEN
                 TMAT(I,J)=0.          
            ELSE
                 TMAT(I,J)=1.          
            ENDIF 
	  ENDDO
	  ENDDO	     
      endif
         
C// if divergence limits for source were given in options:
      if (FLXH.GT.0) RNDLIST.LIMITS(1)=FLXH*1.2                
      if (FLXV.GT.0) RNDLIST.LIMITS(2)=FLXV*1.2

C// no constraints in debug mode
      IF (IDBG.GE.1) THEN
	 IF (FLXH.LE.0) RNDLIST.LIMITS(1)=AHMIN
	 IF (FLXV.LE.0) RNDLIST.LIMITS(2)=AVMIN
	 IF (FLXN.LE.0) RNDLIST.LIMITS(3)=0.05*STP.KI
	 RNDLIST.LIMITS(4)=SOU.SIZE(1)
	 RNDLIST.LIMITS(5)=SOU.SIZE(2)
      ENDIF   
                       
      IF (VERBOSE) WRITE(*,*) 'Forward tracing (source -> sample)'
      
      END
   
