

C--------------------------------------------------------
      LOGICAL*4 FUNCTION SPINMATCH(S,SPIN)
C// compares spin transfer with required value
C//// SPIN determines the combination of spin states required:
C//// -3  .... down --> down
C//// -1  .... down --> up
C////  0  .... all
C//// +1  .... up --> down
C//// +3  .... up --> up
C--------------------------------------------------------
      IMPLICIT NONE
      REAL*4 S,SPIN
      IF(SPIN.EQ.0) THEN
          SPINMATCH=.TRUE.
      ELSE
          SPINMATCH=(NINT(S).EQ.NINT(SPIN))
      ENDIF
      END

C---------------------------------------------------------------
      SUBROUTINE NSTORE
C Encapsulates procedures handling stack of neutron data
C Entries:
c      _READ1(INDEX,NEU)
c      _READ2(INDEX,I1,NEU)
c      _WRITE1(INDEX,NEU)
c      _WRITE2(INDEX,I1,NEU)
c      _N(I1,I2,IALLOC)
c      _ALLOCATE(INDEX)
c      _FREE
c      _GETQE(INDEX,QE,P,SP)
c      _SETQE(INDEX,QE,P)
C---------------------------------------------------------------
      IMPLICIT NONE
      INCLUDE 'const.inc'
      INCLUDE 'structures.inc'
      INCLUDE 'ness_common.inc'
      INCLUDE 'rescal.inc'

      INTEGER*4 ND,INDEX,I,J,IERR,NMAX,IMAX1,IMAX2,I1,I2,IALLOC
      PARAMETER(ND=1000000)
      RECORD /NEUTRON/ NEU
      REAL*8  QE(4),VQ(3),WQ(3),KF0,KI0,VKI(3),VKF(3),P
      REAL*4 XX,SP
      LOGICAL*4 SPINMATCH
C/ stores x,y,K(3),P,Spin  for incident neutron
      REAL, ALLOCATABLE :: STACK1(:,:) 
C/ store index of inc. neutron + z,K(3),P,Spin for scattered neutron
      REAL, ALLOCATABLE :: STACK2(:,:) 
      SAVE STACK1,STACK2,NMAX,IMAX1,IMAX2

      ENTRY NSTORE_READ1(INDEX,NEU)
C--------------------------------------------------------
C Entry to read data of incident neutron

      IF(INDEX.GT.NMAX) GOTO 103
      DO I=1,2
          NEU.R(I)=1.*STACK1(I,INDEX)
      ENDDO
      DO I=1,3
          NEU.K(I)=1.*STACK1(I+2,INDEX)
      ENDDO
      NEU.P=1.*STACK1(6,INDEX)
      NEU.S=1.*STACK1(7,INDEX)
      RETURN

      ENTRY NSTORE_WRITE1(INDEX,NEU)
C--------------------------------------------------------
C Entry to write data of incident neutron in STACK1(1:79)
C Stores R(2),K(3),PP,SPIN

      IERR=0
      IF(INDEX.GT.NMAX) GOTO 102
      DO I=1,2
          XX=NEU.R(I)
          STACK1(I,INDEX)=XX
      ENDDO
      DO I=1,3
          XX=NEU.K(I)
          STACK1(I+2,INDEX)=XX
      ENDDO
      XX=NEU.P
      STACK1(6,INDEX)=XX
      XX=NEU.S
      STACK1(7,INDEX)=XX
      IF(INDEX.GT.IMAX1) IMAX1=INDEX
      RETURN

      ENTRY NSTORE_WRITE2(INDEX,I1,NEU)
C--------------------------------------------------------
C Entry to write data of scattered neutron in STACK2(1:10)
C Stores I1,R(3),Q(3),E,PP,SPIN
C I1 is interpreted as an index to corresponding incident neutron in STACK1
      IERR=0
      IF(INDEX.GT.NMAX) GOTO 102
      IF(INDEX.GT.IMAX1) GOTO 105
      XX=1.*I1
      STACK2(1,INDEX)=XX
      DO I=1,3
          XX=NEU.R(I)
          STACK2(I+1,INDEX)=XX
      ENDDO
      DO I=1,3
        VKI(I)=STACK1(I+2,I1) 
        VKF(I)=NEU.K(I) 
      ENDDO 
      KF0=VKF(1)**2+VKF(2)**2+VKF(3)**2
      KI0=VKI(1)**2+VKI(2)**2+VKI(3)**2
C* subtract nominal values from k vectors
      VKF(1)=VKF(1)-STP.KF*SOMEGA
      VKF(3)=VKF(3)-STP.KF*COMEGA
      VKI(3)=VKI(3)-STP.KI
      DO I=1,3
        VQ(I)=VKF(I)-VKI(I)
      ENDDO
C*  transform to C&N coord.
      DO I=1,3
         WQ(I)=0
         DO J=1,3
            WQ(I)=WQ(I)+MLC(J,I)*VQ(J)
         ENDDO
      ENDDO
      
      DO I=1,3
          XX=WQ(I)
          STACK2(I+4,INDEX)=XX
      ENDDO
      XX=HSQOV2M*(KI0-KF0)-STP.E
      STACK2(8,INDEX)=XX
      XX=NEU.P*STACK1(6,I1)
      STACK2(9,INDEX)=XX
      XX=2*NINT(STACK1(7,I1))+NINT(NEU.S)
      STACK2(10,INDEX)=XX
      IF(INDEX.GT.IMAX2) IMAX2=INDEX
      RETURN

      ENTRY NSTORE_N(I1,I2,IALLOC)
C--------------------------------------------------------
C return number of allocated events
      I1=IMAX1
      I2=IMAX2
      IALLOC=NMAX
      RETURN

      ENTRY NSTORE_ALLOCATE(INDEX)
C--------------------------------------------------------
C Entry for memory allocation
      IERR=0
      IF(INDEX.LE.NMAX) THEN   ! no reallocation necessary
         RETURN
      ENDIF
      IF(INDEX.GT.ND) GOTO 104  ! max. event number exceeded
      IF (ALLOCATED(STACK1)) DEALLOCATE(STACK1,STAT=IERR)
      IF (IERR.NE.0) GOTO 98
      IF (ALLOCATED(STACK2)) DEALLOCATE(STACK2,STAT=IERR)
      IF (IERR.NE.0) GOTO 98
      NMAX=0
      IMAX1=0
      IMAX2=0
      ALLOCATE (STACK1(1:7,1:INDEX),STAT=IERR)
      ALLOCATE (STACK2(1:10,1:INDEX),STAT=IERR)
      IF (IERR.NE.0) GOTO 99
      NMAX=INDEX
      RETURN

      ENTRY NSTORE_FREE
C--------------------------------------------------------
C Entry for memory deallocation
      IERR=0
      IF (ALLOCATED(STACK1))DEALLOCATE (STACK1,STAT=IERR)
      IF (IERR.NE.0) GOTO 98
      IF (ALLOCATED(STACK2))DEALLOCATE (STACK2,STAT=IERR)
      IF (IERR.NE.0) GOTO 98
      NMAX=0
      IMAX1=0
      IMAX2=0
      RETURN

      ENTRY NSTORE_GETQE(INDEX,QE,P,SP)
C--------------------------------------------------------
C Entry to receive QE(4) vectors with appropriate weight
      IF(INDEX.GT.NMAX) GOTO 103
      IF (INDEX.LE.IMAX2.AND.SPINMATCH(STACK2(10,INDEX),SP)) THEN
         DO I=1,3
           QE(I)=STACK2(I+4,INDEX)
         ENDDO
         QE(4)=STACK2(8,INDEX)
      IF(INDEX.EQ.100) THEN      
      ENDIF
         P=STACK2(9,INDEX)
      ELSE
         P=0.
      ENDIF
      RETURN

      ENTRY NSTORE_SETQE(INDEX,QE,P)
C--------------------------------------------------------
C Entry for setting QE(4) vector with weight
      IF(INDEX.GT.NMAX) GOTO 102
      DO I=1,4
           STACK2(I+4,INDEX)=QE(I)
      ENDDO
      STACK2(9,INDEX)=P
      STACK2(10,INDEX)=0.
      RETURN

97    FORMAT('NSTORE: ',a)

98    WRITE(*,97)'Deallocating memory for event storage: ',
     *    'Error: ',IERR
      STOP

99    WRITE(*,97)'Allocating memory for event storage: ',
     *    'Error: ',IERR,' Amount: ',INDEX
      STOP

102   WRITE(*,97)'Error: Attempt to write to a nonallocated arrea ! '
     *  ,INDEX
      STOP

103   WRITE(*,97)'Attempt to read from a nonallocated arrea ! '
     *  ,INDEX
      STOP
104   WRITE(*,97) 'Max.',ND,' events can be stored'
      STOP

105   WRITE(*,97) 'Nonexistent incident neutron referenced: ',I1
      STOP

      END



C--------------------------------------------------------        
      SUBROUTINE EVARRAY(ICOM,IA,INDEX,X,VAL)
C     VMS version of the EVARRAY routine for HP-UX
C     which handles dynamically allocated arrays EVA(5,:)         
C///  ICOM=-1  deallocate
C///  ICOM=0   allocate
C///  ICOM=1   writes X(4),VAL to the INDEX's row of EVA
C///  ICOM=2   reads X(4),VAL from the INDEX's row of EVA
C///  ICOM=3   INDEX= max. allocated row of EVA
C--------------------------------------------------------
      IMPLICIT DOUBLE PRECISION (A-H,O-Z)
         PARAMETER(ND=500000)
      REAL EVA(5,ND),EVA1(5,ND)
      REAL*8  X(4)
      INTEGER*4 INDEX
      SAVE EVA,EVA1,IMAX,IMAX1
      
      IF(IA.EQ.0) THEN
      
      IF(ICOM.EQ.2) THEN
         IF (INDEX.LE.IMAX) THEN      
            do i=1,4
                     X(i)=EVA(i,INDEX)
               end do                
            VAL=EVA(5,INDEX)            
         ELSE
            pause 'Attempt to read from a nonallocated arrea !'
         ENDIF
         RETURN              
      ELSE IF(ICOM.EQ.1) THEN
         IF (INDEX.LE.IMAX) THEN
               do i=1,4      
               EVA(i,INDEX)=X(i)
               end do                
            EVA(5,INDEX)=VAL
         ELSE
            pause 'Attempt to write to a nonallocated arrea !'
         ENDIF
         RETURN           
      ELSE IF(ICOM.EQ.0) THEN
            IF(INDEX.GT.ND) THEN
               INDEX=ND
               IMAX=ND
               WRITE(*,*) 'Maximum number of events is ',ND
            ENDIF  
         IMAX=INDEX
      ELSE IF(ICOM.EQ.3) THEN
         INDEX=IMAX
         RETURN 
      ENDIF

      ELSE IF(IA.EQ.1) THEN
      
      IF(ICOM.EQ.2) THEN
         IF (INDEX.LE.IMAX1) THEN      
            do i=1,4
                     X(i)=EVA1(i,INDEX)
               end do                
            VAL=EVA1(5,INDEX)            
         ELSE
            pause 'Attempt to read from a nonallocated arrea !'
         ENDIF
         RETURN              
      ELSE IF(ICOM.EQ.1) THEN
         IF (INDEX.LE.IMAX1) THEN
               do i=1,4      
               EVA1(i,INDEX)=X(i)
               end do                
            EVA1(5,INDEX)=VAL
         ELSE
            pause 'Attempt to write to a nonallocated arrea !'
         ENDIF
         RETURN             
      ELSE IF(ICOM.EQ.0) THEN
            IF(INDEX.GT.ND) THEN
               INDEX=ND
               IMAX1=ND
               WRITE(*,*) 'Maximum number of events is ',ND
            ENDIF  
         IMAX1=INDEX
      ELSE IF(ICOM.EQ.3) THEN
         INDEX=IMAX1
         RETURN 
      ENDIF      

      ENDIF

      IF(ICOM.EQ.-1) THEN
         IMAX=0
         IMAX1=0
         RETURN
      ENDIF 

      RETURN
      END
      
