C//////////////////////////////////////////////////////////////////////
C////                                                              //// 
C////  NEutron Scattering Simulation - v.2.0, (c) J.Saroun, 2000   ////
C////                                                              //// 
C//////////////////////////////////////////////////////////////////////
C////
C////  Subroutines describing objects - SLIT, SOURCE, DETECTOR
C////  
C////                          
C//////////////////////////////////////////////////////////////////////


C	-------------------------------------------
      LOGICAL*4 FUNCTION INSIDE(OBJ,R)
C       Returns .TRUE. if R(3) is inside the OBJ	
C	-------------------------------------------	
      implicit none

      INCLUDE 'structures.inc'
      
      RECORD /SLIT/ OBJ
      REAL*8 R(3)
      LOGICAL*4 LOG1

      IF (OBJ.SHAPE.EQ.3) THEN                     ! rectangle
         LOG1=(
     1     (ABS(R(1)).LT.OBJ.SIZE(1)/2.).AND.
     2     (ABS(R(2)).LT.OBJ.SIZE(2)/2.).AND.
     3     (ABS(R(3)).LT.OBJ.SIZE(3)/2.))		

      ELSE IF (OBJ.SHAPE.EQ.2) THEN                ! disc
         LOG1=(
     1 	 (((R(1)*2./OBJ.SIZE(1))**2+
     2     (R(2)*2./OBJ.SIZE(2))**2).LT.1).AND.
     3     (ABS(R(3)).LT.OBJ.SIZE(3)/2.)) 
     

      ELSE IF (OBJ.SHAPE.EQ.1) THEN                ! cylinder
         LOG1=(
     1 	 (((R(1)*2./OBJ.SIZE(1))**2+
     2     (R(3)*2./OBJ.SIZE(3))**2).LT.1).AND.
     3     (ABS(R(2)).LT.OBJ.SIZE(2)/2.))      
                 

      ELSE IF (OBJ.SHAPE.EQ.0) THEN                ! ellipsoid
         LOG1=(
     1     ((R(1)*2./OBJ.SIZE(1))**2+
     2      (R(2)*2./OBJ.SIZE(2))**2+
     3      (R(3)*2./OBJ.SIZE(3))**2).LT.1)

      ELSE 
         LOG1=.FALSE.
      END IF
        
      INSIDE=LOG1
	
C shape = 0 ... ellipsoid
C         1 ... vertical cylinder (axis//y)
c         2 ... disc plate (axis//z)
c         3 ... rectangular     

      RETURN 
      END


	
C	-------------------------------
	SUBROUTINE SLIT_INIT(OBJ)
C	-------------------------------	
	implicit none

        INCLUDE 'structures.inc'
      
	
	RECORD /SLIT/ OBJ
	REAL*8 STA(3),POS(3),R(3,3),R0(3,3),R1(3,3),
     1         R2(3,3),R3(3,3)	
        INTEGER*4 I,J
        
C		
	POS(1)=0   ! position of the own axis vs. the preceding one
	POS(2)=0                     
	POS(3)=OBJ.DIST	

C/// POS = position of the object(=SLIT) vs. axis of the preceding object
C/// in axis coordinates. 	
	DO 10 I=1,3
	  POS(I)=OBJ.STA(I)+POS(I)  
          STA(I)=OBJ.STA(I)
10      CONTINUE
	OBJ.COUNT=0
	  	
C rot. matrix for AXI 
	DO 20 I=1,3
	DO 20 J=1,3
	 IF (I.EQ.J) THEN
	    R2(I,J)=1
	 ELSE
	    R2(I,J)=0   
	 ENDIF   
20      CONTINUE
        R2(1,1)=COS(OBJ.AXI)
        R2(3,3)=COS(OBJ.AXI)
        R2(1,3)=-SIN(OBJ.AXI)
        R2(3,1)=+SIN(OBJ.AXI)
        
C rot. matrix for AXV 
	DO 25 I=1,3
	DO 25 J=1,3
	 IF (I.EQ.J) THEN
	    R1(I,J)=1
	 ELSE
	    R1(I,J)=0   
	 ENDIF   
25      CONTINUE
        R1(2,2)=COS(OBJ.AXV)
        R1(3,3)=COS(OBJ.AXV)
        R1(2,3)=+SIN(OBJ.AXV)
        R1(3,2)=-SIN(OBJ.AXV)

C rotation matrix (R) for current axis with respect to the previous one        
        CALL M3XM3(1,R1,R2,R)    
        
        
C rot. matrix for GON(1)  around axis 2
	DO 30 I=1,3
	DO 30 J=1,3
	 IF (I.EQ.J) THEN
	    R1(I,J)=1
	 ELSE
	    R1(I,J)=0   
	 ENDIF   
30      CONTINUE
        R1(1,1)=COS(OBJ.GON(1))
        R1(3,3)=COS(OBJ.GON(1))
        R1(1,3)=-SIN(OBJ.GON(1))
        R1(3,1)=+SIN(OBJ.GON(1))
        
C rot. matrix for GON(2)  around axis 1 
	DO 40 I=1,3
	DO 40 J=1,3
	 IF (I.EQ.J) THEN
	    R2(I,J)=1
	 ELSE
	    R2(I,J)=0   
	 ENDIF   
40      CONTINUE
        R2(2,2)=COS(OBJ.GON(2))
        R2(3,3)=COS(OBJ.GON(2))
        R2(2,3)=+SIN(OBJ.GON(2))
        R2(3,2)=-SIN(OBJ.GON(2))        
        
C rot. matrix for GON(3)  around axis 2 again 
	DO 50 I=1,3
	DO 50 J=1,3
	 IF (I.EQ.J) THEN
	    R3(I,J)=1
	 ELSE
	    R3(I,J)=0   
	 ENDIF   
50      CONTINUE
        R3(1,1)=COS(OBJ.GON(3))
        R3(3,3)=COS(OBJ.GON(3))
        R3(1,3)=-SIN(OBJ.GON(3))
        R3(3,1)=+SIN(OBJ.GON(3))

C/// two transformaton matrices are created:
C/// object vs. axis coordinates (ROT1)
C/// object vs. axis of the preceding object (ROT)
    
        CALL M3XM3(1,R2,R1,R0)
        CALL M3XM3(1,R3,R0,OBJ.ROT1)
        CALL M3XM3(1,OBJ.ROT1,R,OBJ.ROT)        
        
	DO 60 I=1,3
	  OBJ.MAP(I)=.TRUE.
	  IF (1-ABS(OBJ.ROT(I,I)).LT.1.0D-8) OBJ.MAP(I)=0
	  OBJ.MAP1(I)=.TRUE.
	  IF (1-ABS(OBJ.ROT1(I,I)).LT.1.0D-8) OBJ.MAP1(I)=0
60      CONTINUE

C /// transform POS and STA to the object coordinates:
 
	CALL M3XV3(1,OBJ.MAP1,OBJ.ROT1,POS,OBJ.POS)  
	CALL M3XV3(1,OBJ.MAP1,OBJ.ROT1,STA,OBJ.STA)                     

	RETURN
	END

	
	
C	------------------------------------------
	LOGICAL*4 FUNCTION SLIT_GO(OBJ,NEUI,NEUF)
C	------------------------------------------	
	implicit none

        INCLUDE 'const.inc'
        INCLUDE 'structures.inc'

	RECORD /SLIT/ OBJ
	RECORD /NEUTRON/ NEUI,NEUF
	LOGICAL*4 LOG1,INSIDE
	REAL*8 v(3),K(3),R(3)
        INTEGER*4 I
        			
        LOG1=(NEUI.P.GT.0.D0)

C/// At the begining, NEUI.R,K is in the axis coordinates of the
C/// preceding object.	

C/// NEUI.K and NEUI.R must be transformed to the object coordinates
C/// (including rotation and linear shift specified by GON(3) and STA(3):
        
        CALL SLIT_PRE1(OBJ,NEUI.R,NEUI.K,V,K)

C/// move neutron to the centre of the OBJ:
	NEUF.T=NEUI.T-V(3)/HOVM/K(3)
	DO 10 I=1,2
10	R(I)=V(I)-V(3)/K(3)*K(I)
        R(3)=0.
    
	IF (INSIDE(OBJ,R)) THEN
	
C/// At the and, NEUF.K and NEUF.R must be in the axis coordinates 
C/// of the object (i.e. without rotation and shift by GON(3) and STA(3))
c             CALL SLIT_POST1(OBJ,R,K,NEUF.R,NEUF.K)
            DO I=1,3
               NEUF.R(I)=R(I)
               NEUF.K(I)=K(I)
            END DO    				     
	    NEUF.P=NEUI.P
	    NEUF.S=NEUI.S
	    OBJ.COUNT=OBJ.COUNT+1
	ELSE 
	    LOG1=.FALSE.
	    NEUF.P=0
	END IF
	SLIT_GO=LOG1
		
	RETURN
	END 

C //////////////////  End of definition - SLIT  ///////////////////



C	------------------------------------------
	SUBROUTINE SLIT_POST(OBJ,R0,K0,R,K)
C	------------------------------------------	
	IMPLICIT NONE

        INCLUDE 'structures.inc'
      
	RECORD /SLIT/ OBJ
	REAL*8 R0(3),K0(3),R(3),K(3),V(3)
	
	CALL V3AV3(1,R0,OBJ.STA,V)
        CALL M3XV3(-1,OBJ.MAP1,OBJ.ROT1,V,R)
        CALL M3XV3(-1,OBJ.MAP1,OBJ.ROT1,K0,K)

	
	RETURN
	END	

C	------------------------------------------
	SUBROUTINE SLIT_POST1(OBJ,R0,K0,R,K)
C	Simpler (and faster) version of SLIT_POST.
C       Use it if you are sure that STA=(0,0,0) and
C       ROT1(2,2)=1 (=> ROT(i,2)=0)
C	------------------------------------------	
	IMPLICIT NONE

        INCLUDE 'structures.inc'
      
	RECORD /SLIT/ OBJ
	REAL*8 R0(3),K0(3),R(3),K(3)
	
        R(1)=OBJ.ROT1(1,1)*R0(1)+OBJ.ROT1(3,1)*R0(3)
        R(2)=R0(2)
        R(3)=OBJ.ROT1(1,3)*R0(1)+OBJ.ROT1(3,3)*R0(3)
        K(1)=OBJ.ROT1(1,1)*K0(1)+OBJ.ROT1(3,1)*K0(3)
        K(2)=K0(2)
        K(3)=OBJ.ROT1(1,3)*K0(1)+OBJ.ROT1(3,3)*K0(3)        
	RETURN
	END	
C	------------------------------------------
	SUBROUTINE SLIT_PRE(OBJ,R0,K0,R,K)
C	------------------------------------------	
	IMPLICIT NONE

        INCLUDE 'structures.inc'
      
	RECORD /SLIT/ OBJ
	REAL*8 R0(3),K0(3),R(3),K(3),V(3)
	
	CALL M3XV3(1,OBJ.MAP,OBJ.ROT,R0,V)
	CALL M3XV3(1,OBJ.MAP,OBJ.ROT,K0,K)
	CALL V3AV3(-1,V,OBJ.POS,R)

	RETURN
	END

C	------------------------------------------
	SUBROUTINE SLIT_PRE1(OBJ,R0,K0,R,K)
C	Simpler (and faster) version of SLIT_PRE.
C       Use it if you are sure that POS(2)=0 and
C       ROT(2,2)=1 (=> ROT(i,2)=0)	
C	------------------------------------------	
	IMPLICIT NONE

        INCLUDE 'structures.inc'
      
	RECORD /SLIT/ OBJ
	REAL*8 R0(3),K0(3),R(3),K(3)
        
        R(1)=OBJ.ROT(1,1)*R0(1)+OBJ.ROT(1,3)*R0(3)
        R(2)=R0(2)
        R(3)=OBJ.ROT(3,1)*R0(1)+OBJ.ROT(3,3)*R0(3)
        K(1)=OBJ.ROT(1,1)*K0(1)+OBJ.ROT(1,3)*K0(3)
        K(2)=K0(2)
        K(3)=OBJ.ROT(3,1)*K0(1)+OBJ.ROT(3,3)*K0(3)      	
	R(1)=R(1)-OBJ.POS(1)
	R(3)=R(3)-OBJ.POS(3)
	
	RETURN
	END



C ////////////////// Definition of the SLIT object ///////////////////



C--------------------------------------------------
      LOGICAL*4 FUNCTION DETECT_GO(DET,NEUI,NEUF)
C just a rectangular detector area, or, 
C if DET.ALPHA>0 => ARRAY of cyllindrical detectors      
C--------------------------------------------------	
      implicit none

      INCLUDE 'const.inc'
      INCLUDE 'structures.inc'
      LOGICAL*4 LOG1, SLIT_GO,SAM_BOARDER 
      REAL*8 KK,R(3),V(3),K(3),T1,T2,LAM,Z
      REAL*8 P(0:64),KSI(0:64)
      REAL*4 RAN1,RN,RN1
      INTEGER*4 I,J
      RECORD /DETECTOR/ DET
      RECORD /NEUTRON/ NEUI,NEUF

      IF(DET.ALPHA.EQ.0) THEN
	 LOG1=SLIT_GO(DET.FRAME,NEUI,NEUF)
      ELSE 
         RN=RAN1()
         RN1=RAN1()
         CALL SLIT_PRE(DET.FRAME,NEUI.R,NEUI.K,V,K)    
         KK=SQRT(K(1)**2+K(2)**2+K(3)**2)
         LAM=2*PI/KK				     
         P(0)=0.D0
         KSI(0)=0.D0
         DO I=2,3
           R(I)=V(I)
         ENDDO               
         DO J=1,DET.ND
           R(1)=V(1)+(DET.FRAME.SIZE(1)+DET.SPACE)*
     &               (J-(DET.ND+1.D0)/2.D0)
           IF (SAM_BOARDER(DET.FRAME,R,K,T1,T2)) THEN
             KSI(J)=(T2-T1)*(RN+0.5)
             P(J)=P(J-1)+(1.D0-EXP(-DET.ALPHA*LAM*KSI(J)*KK)) 
           ELSE 
             P(J)=P(J-1)
             KSI(J)=0.
           ENDIF
         ENDDO
         IF (P(DET.ND).LT.1.E-10) GOTO 99            
         Z=P(DET.ND)*(RN1+0.5)
         J=0
         DO WHILE (P(J).LE.Z.AND.J.LT.DET.ND) 
           J=J+1
         ENDDO                     
         DO I=1,3
           R(I)=V(I)+(T1+KSI(J))*K(I)
         END DO  
         CALL SLIT_POST(DET.FRAME,R,K,NEUF.R,NEUF.K)
         NEUF.T=NEUI.T+(T1+KSI(J))/HOVM
         NEUF.P=NEUI.P*P(DET.ND)
         NEUF.S=NEUI.S
         LOG1=(NEUF.P.GT.0.D0)
         IF(LOG1) DET.FRAME.COUNT=DET.FRAME.COUNT+1
      ENDIF
      DETECT_GO=LOG1
      RETURN
        
99    DETECT_GO=.FALSE.       
      END
