C//////////////////////////////////////////////////////////////////////
C////                                                              //// 
C////  NEutron Scattering Simulation - v.2.0, (c) J.Saroun, 1997   ////
C////                                                              //// 
C//////////////////////////////////////////////////////////////////////
C////
C////  Subroutines describing objects - SAMPLES
C////  
C////                          
C//////////////////////////////////////////////////////////////////////

C	------------------------------------------
	LOGICAL*4 FUNCTION PWD_GO(PWD,NEUI,NEUF,Q)
C	------------------------------------------	
	implicit none

        INCLUDE 'const.inc'
        INCLUDE 'structures.inc'
        INCLUDE 'randvars.inc'

	RECORD /SLIT/ PWD
	RECORD /NEUTRON/ NEUI,NEUF
	LOGICAL*4 LOG1,MAP(3),SAM_BOARDER
	REAL*8 v(3),K(3),R(3),Q,X1(3),X2(3),RT1(3,3),RT2(3,3)
	REAL*8 kf,PP,t1,t2,dz,dz0,stb,ctb,s2tb,c2tb,dal,dfi,sinn,coss
	REAL*4 RAN1
        INTEGER*4 I
 	DATA MAP /.true.,.true.,.true./
        
        
	LOG1=.TRUE.
        PP=1
        CALL SLIT_PRE1(PWD,NEUI.R,NEUI.K,V,K)

        
C/// move neutron to the centre of the SLIT:
	NEUF.T=NEUI.T-V(3)/HOVM/K(3)
	DO 10 I=1,2
10	R(I)=V(I)-V(3)/K(3)*K(I)
        R(3)=0.
c        write(*,*) 'PWD: '
c	IF (INSIDE(PWD,R)) THEN
        IF (SAM_BOARDER(PWD,R,K,T1,T2)) THEN	   
c           DZ0=2*SQRT((PWD.SIZE(1)/2)**2-R(1)**2)
           kf=SQRT(K(1)**2+K(2)**2+K(3)**2)
	   DZ0=kf*(T2-T1)
           DZ=(RAN1()-0.5)*DZ0
	   PP=DZ0*0.01  ! suppose sigma=0.1 cm^-1
           R(3)=DZ
c        write(*,*) DZ0,DZ,T1,T2           
           NEUF.T=NEUF.T+DZ/HOVM/K(3)
           kf=SQRT(K(1)**2+K(2)**2+K(3)**2)
           stb=Q/2/kf
           if (abs(stb).ge.1) then
              NEUF.P=0
              PWD_GO=.FALSE.
              RETURN
           endif   
           ctb=SQRT(1-stb**2)
           s2tb=2*stb*ctb
           c2tb=SQRT(1-s2tb**2)
           if (stb**2.gt.0.5) c2tb=-c2tb
           dal=ATAN(k(1)/k(3))
           dfi=ATAN(k(2)/SQRT(k(1)**2+K(3)**2))
           call MK_ROT3(2,dal,RT1)
           call MK_ROT3(1,dfi,RT2)
           sinn=sin(XRND(7))
           coss=SQRT(1-sinn**2)
           IF(ABS(XRND(7)).GT.PI/2) COSS=-COSS
           X1(1)=kf*s2tb*coss
           X1(2)=kf*s2tb*sinn
           x1(3)=kf*c2tb
           call M3XV3(-1,map,RT1,X1,X2)
           call M3XV3(-1,map,RT2,X2,K)
            DO I=1,3
               NEUF.R(I)=R(I)
               NEUF.K(I)=K(I)
            END DO    				     
	    NEUF.P=NEUI.P*PP
	    NEUF.S=NEUI.S
	    PWD.COUNT=PWD.COUNT+1
	ELSE 
	    LOG1=.FALSE.
	    NEUF.P=0
	END IF

	PWD_GO=LOG1
		
	RETURN
	END 

C	-----------------------------------------------
	LOGICAL*4 FUNCTION SAM_BOARDER(SAM,R,K,T1,T2)
C       return cross-section times with sample borders in T1, T2
C	-----------------------------------------------	
        implicit none
        INCLUDE 'structures.inc'
	RECORD /SLIT/ SAM
        REAL*8 K(3),R(3),T1,T2,T3,T4,Z,A,B,C,DD        
        
c        write(*,*) SAM.SIZE(1),SAM.SIZE(2),SAM.SIZE(3)
        A=(k(1)*2/SAM.SIZE(1))**2+(k(3)*2/SAM.SIZE(3))**2
        B=2*(k(1)*R(1)*4/SAM.SIZE(1)**2+k(3)*R(3)*4/SAM.SIZE(3)**2)
        C=(r(1)*2/SAM.SIZE(1))**2+(r(3)*2/SAM.SIZE(3))**2-1.0
        DD=B**2-4*A*C
c        write(*,*)  'ABCD:',A,B,C,DD 
        IF(DD.GT.0) THEN
           T1=(-B-SQRT(DD))/2/A
           T2=(-B+SQRT(DD))/2/A
           IF(ABS(K(2)).GT.1E-10) THEN
             T3=(-SAM.SIZE(2)/2-R(2))/K(2)
             T4=(SAM.SIZE(2)/2-R(2))/K(2)
             IF(T4.LT.T3) THEN
               Z=T3
               T3=T4
               T4=Z
             ENDIF  
           ELSE
             T3=-1E31
             T4=1E31
           ENDIF
           IF (T1.LT.T3) T1=T3
           IF (T2.GT.T4) T2=T4
           IF(T1.LT.T2) THEN               
             SAM_BOARDER=.TRUE.
           ELSE
             SAM_BOARDER=.FALSE.
           ENDIF
        ELSE
c           A=SQRT(R(1)**2+R(3)**2)       
c           write(*,*) 'SAM_BORDER: det<=0 ',A,R(2)
           SAM_BOARDER=.FALSE.
        ENDIF
        END   
               
               
C	------------------------------------------
	LOGICAL*4 FUNCTION VAN_GO(VAN,NEUI,NEUF,Q)
C	------------------------------------------	
	implicit NONE

        INCLUDE 'const.inc'
        INCLUDE 'structures.inc'
        INCLUDE 'randvars.inc'

        REAL*8 SSCAT,SABS
c// scattering and absorption cross-section for k=2.664A-1
        PARAMETER (SSCAT=0.0362,SABS=0.0476)
c        PARAMETER (SSCAT=0.0362,SABS=0.)

	RECORD /SLIT/ VAN
	RECORD /NEUTRON/ NEUI,NEUF
	LOGICAL*4 LOG1,SAM_BOARDER
	REAL*8 V(3),K(3),R(3),Q,X1(3)
	REAL*8 KF,PP,P0,T1,T2,DELTA,stb,ctb,s2tb,c2tb,sinn,coss,ksi
        REAL*4 DT
	REAL*4 RAN1
        INTEGER*4 I
        			
	LOG1=.TRUE.
        PP=1
        CALL SLIT_PRE1(VAN,NEUI.R,NEUI.K,V,K)

C/// move neutron to the centre of the SLIT:
	NEUF.T=NEUI.T-V(3)/HOVM/K(3)
	DO 10 I=1,2
10	R(I)=V(I)-V(3)/K(3)*K(I)
        R(3)=0.
    
	IF (SAM_BOARDER(VAN,R,K,T1,T2)) THEN
C/// move neutron to the sample entry:
	   NEUF.T=NEUI.T+T1
	   DO I=1,3
	     R(I)=R(I)+K(I)*T1
           ENDDO
           DELTA=T2-T1       
           kf=SQRT(K(1)**2+K(2)**2+K(3)**2)
           ksi=RAN1()
           P0=1.-exp(-SSCAT*kf*DELTA) ! scattering probability
	   DT=-Log(1-ksi*P0)/SSCAT/kf
C/// move to the scattering point:
           NEUF.T=NEUF.T+DT
	   DO I=1,3
	     R(I)=R(I)+K(I)*DT
           ENDDO

           stb=Q/2/kf
           if (abs(stb).ge.1) then
              NEUF.P=0
              VAN_GO=.FALSE.
              RETURN
           endif   
           ctb=SQRT(1-stb**2)
           s2tb=sin(XRND(8)+2*ATAN(stb/ctb))
           c2tb=SQRT(1-s2tb**2)           
           if (stb**2.gt.0.5) c2tb=-c2tb
           sinn=sin(XRND(7))
           coss=SQRT(1-sinn**2)
           IF(ABS(XRND(7)).GT.PI/2) COSS=-COSS
           X1(1)=kf*s2tb*coss
           X1(2)=kf*sinn
           x1(3)=kf*c2tb*coss
           DO I=1,3
               NEUF.R(I)=R(I)
               NEUF.K(I)=X1(I)
           END DO
           IF (SAM_BOARDER(VAN,R,X1,T1,T2)) THEN   				     
              PP=EXP(-SABS*(DT+T2)*2.664)  ! absorption
              NEUF.P=NEUI.P*P0*PP/4/PI  ! convert Sigma to dSigma/dOmega
	      NEUF.S=NEUI.S
              LOG1=(NEUF.P.GT.0.D0)
	      IF(LOG1) VAN.COUNT=VAN.COUNT+1
           ENDIF   
	ELSE 
	    LOG1=.FALSE.
	    NEUF.P=0
	END IF

	VAN_GO=LOG1
	RETURN
	END 

C	---------------------------------------------
	LOGICAL*4 FUNCTION VAN_TRANS(VAN,NEUI,NEUF)
C	---------------------------------------------	
	implicit NONE

        INCLUDE 'const.inc'
        INCLUDE 'structures.inc'

        REAL*8 SSCAT,SABS
        PARAMETER (SSCAT=0.0362,SABS=0.0476)
c        PARAMETER (SSCAT=0.0362,SABS=0.)

	RECORD /NEUTRON/ NEUI,NEUF
	RECORD /SLIT/ VAN
	LOGICAL*4 SAM_BOARDER
	REAL*8 V(3),K(3)
	REAL*8 KF,T1,T2,EXP
        INTEGER*4 I
        			
        CALL SLIT_PRE1(VAN,NEUI.R,NEUI.K,V,K)

C/// move neutron to the centre of the SLIT:
	NEUF.T=NEUI.T-V(3)/HOVM/K(3)
	DO 10 I=1,2
	  NEUF.R(I)=V(I)-V(3)/K(3)*K(I)
10        NEUF.K(I)=K(I)
        NEUF.R(3)=0.
    
	IF (SAM_BOARDER(VAN,NEUF.R,K,T1,T2)) THEN
C/// transmission through the sample:
           kf=SQRT(K(1)**2+K(2)**2+K(3)**2)
           NEUF.P=NEUI.P*EXP(-(SABS+SSCAT)*kf*(T2-T1))
	   NEUF.S=NEUI.S
	ELSE 
	    NEUF.P=NEUI.P
	END IF
        VAN.COUNT=VAN.COUNT+1

	VAN_TRANS=.TRUE.
		
	RETURN
	END 
        
C	------------------------------------------
	LOGICAL*4 FUNCTION SAM_GO(VAN,NEUI,NEUF)
C  Spreads n. to all Q's and energies, to get resolution function R(Q,E)
C except: ISQOM>0 defines the scatterig function
C	------------------------------------------	
	implicit NONE

       INCLUDE 'const.inc'
       INCLUDE 'structures.inc'
       INCLUDE 'ness_common.inc'
       INCLUDE 'randvars.inc'
       INCLUDE 'inout.inc'
       INCLUDE 'rescal.inc'

	RECORD /SLIT/ VAN
	RECORD /NEUTRON/ NEUI,NEUF
	LOGICAL*4 LOG1,SAM_BOARDER,ESAM_GO
	REAL*8 V(3),K(3),R(3),X1(3)
	REAL*8 KF,PP,T1,T2,DELTA,s2tb,c2tb,sinn,coss,Z 
        REAL*4 DT
	REAL*4 RAN1
        INTEGER*4 I
        REAL*8 SQE_AMAG,SQE_AMAG1
        
        IF (EMODE.EQ.1) THEN
          SAM_GO= ESAM_GO(VAN,NEUI,NEUF)
          RETURN
        ENDIF			
        			
        PP=1
        CALL SLIT_PRE1(VAN,NEUI.R,NEUI.K,V,K)

C/// move neutron to the centre of the SLIT:
	NEUF.T=NEUI.T-V(3)/HOVM/K(3)
	DO 10 I=1,2
10	R(I)=V(I)-V(3)/K(3)*K(I)
        R(3)=0.
    
	IF (SAM_BOARDER(VAN,R,K,T1,T2)) THEN
C/// move neutron to the scattering point:
           DELTA=T2-T1       
	   DT=RAN1()*DELTA
	   NEUF.T=NEUI.T+T1+DT
	   DO I=1,3
	     R(I)=R(I)+K(I)*(T1+DT)
           ENDDO
           Z=XRND(8)+OMEGA
           s2tb=sin(Z)
           c2tb=SQRT(1-s2tb**2)           
           if (ABS(Z).gt.PI/2) c2tb=-c2tb
           sinn=sin(XRND(7))
           coss=SQRT(1-sinn**2)
           IF(ABS(XRND(7)).GT.PI/2) COSS=-COSS
           kf=STP.KF+XRND(9)
           X1(1)=kf*s2tb*coss
           X1(2)=kf*sinn
           X1(3)=kf*c2tb*coss
           DO I=1,3
               NEUF.R(I)=R(I)
               NEUF.K(I)=X1(I)
           END DO
c  multiply by local thickness * kf/ki 
           NEUF.P=NEUI.P*ABS(DELTA)*kf 
           NEUF.S=NEUI.S
	   IF (ISQOM.EQ.1) THEN                      ! magnon in antiferomag. 
              NEUF.P=NEUF.P*SQE_AMAG(NEUI.K,NEUF.K)
	   ELSE IF (ISQOM.EQ.3) THEN                      ! magnon in antiferomag. 
              NEUF.P=NEUF.P*SQE_AMAG1(NEUI.K,NEUF.K)
           ENDIF   
           LOG1=(NEUF.P.GT.0.D0)
	   IF(LOG1) VAN.COUNT=VAN.COUNT+1
	ELSE 
	    LOG1=.FALSE.
	    NEUF.P=0
	END IF

	SAM_GO=LOG1
	RETURN
	END 

C------------------------------------------
      LOGICAL*4 FUNCTION ESAM_GO(VAN,NEUI,NEUF)
C Spread n. to all Q's with zero energy transfer, to get elastic resol. function R(Q)        
C------------------------------------------	
      implicit NONE

      INCLUDE 'const.inc'
      INCLUDE 'structures.inc'
      INCLUDE 'ness_common.inc'
      INCLUDE 'randvars.inc'
      INCLUDE 'inout.inc'
      INCLUDE 'rescal.inc'

      REAL*8 SSCAT,SABS
c// scattering and absorption cross-section for k=2.664A-1
      PARAMETER (SSCAT=0.0362,SABS=0.0476)
c        RECORD /RANDFIELD/ RNDLIST
      RECORD /SLIT/ VAN
      RECORD /NEUTRON/ NEUI,NEUF
      LOGICAL*4 LOG1,SAM_BOARDER
      REAL*8 V(3),K(3),R(3),X1(3)
      REAL*8 KF,KI,PP,T1,T2,DELTA,s2tb,c2tb,sinn,coss,Z
      REAL*4 DT
      REAL*4 RAN1
      INTEGER*4 I
c1     format(a10,2x,8(G10.4,2x))       
c      DBGREF=.TRUE.
      
      PP=1
      CALL SLIT_PRE1(VAN,NEUI.R,NEUI.K,V,K)

C/// move neutron to the centre of the SLIT:
      NEUF.T=NEUI.T-V(3)/HOVM/K(3)
      DO 10 I=1,2
10    R(I)=V(I)-V(3)/K(3)*K(I)
      R(3)=0.
    
      IF (SAM_BOARDER(VAN,R,K,T1,T2)) THEN
c         if (DBGREF) write(*,1) VAN.NAME,R,K,T1,T2
C/// move neutron to the sample entry:
	 NEUF.T=NEUI.T+T1
	 DO I=1,3
	   R(I)=R(I)+K(I)*T1
         ENDDO
         DELTA=T2-T1       
	 DT=RAN1()*DELTA
C/// move to the scattering point:
         NEUF.T=NEUF.T+DT
	 DO I=1,3
	   R(I)=R(I)+K(I)*DT
         ENDDO          
         Z=XRND(8)+OMEGA
         s2tb=sin(Z)
         c2tb=SQRT(1-s2tb**2)           
         if (ABS(Z).gt.PI/2) c2tb=-c2tb
         sinn=sin(XRND(7))
         coss=SQRT(1-sinn**2)
         IF(ABS(XRND(7)).GT.PI/2) COSS=-COSS
         ki=SQRT(K(1)**2+K(2)**2+K(3)**2)
c//           kf=SQRT(ki**2-STP.E/HSQOV2M)
         kf=ki
         X1(1)=kf*s2tb*coss
         X1(2)=kf*sinn
         X1(3)=kf*c2tb*coss
         
c       if (DBGREF) write(*,1) VAN.NAME,XRND(7)/deg,XRND(8)/deg,
c     &   OMEGA/deg,X1
c       if (DBGREF) pause
         DO I=1,3
            NEUF.R(I)=R(I)
            NEUF.K(I)=X1(I)
         END DO
         NEUF.P=NEUI.P*ABS(DELTA)*kf ! multiply by local thickness*kf/ki
	 IF (ISQOM.EQ.2) THEN                 ! Vanadium
           NEUF.P=NEUF.P*SSCAT/(4.D0*PI)
           LOG1=SAM_BOARDER(VAN,R,NEUF.K,T1,T2)
           NEUF.P=NEUF.P*exp(-SABS*(DT+T2)*kf) ! absorption
           IF (RAN1().LE.0.666666) THEN  ! spin flip
             NEUF.S=-NEUI.S
           ELSE
             NEUF.S=NEUI.S
           ENDIF    
         ELSE
           NEUF.S=NEUI.S         
         ENDIF   
         LOG1=(NEUF.P.GT.0.D0)
	 IF(LOG1) VAN.COUNT=VAN.COUNT+1
      ELSE 
	 LOG1=.FALSE.
	 NEUF.P=0
      END IF

      ESAM_GO=LOG1
      RETURN
      END 
      
C--------------------------------------------------------------
      LOGICAL*4 FUNCTION BRAGG_GO(VAN,NEUI,NEUF)
C no sample, neutrons just scattered at nominal (Q,E) with P=1
C--------------------------------------------------------------	
      implicit NONE

      INCLUDE 'const.inc'
      INCLUDE 'structures.inc'
      INCLUDE 'ness_common.inc'
      INCLUDE 'randvars.inc'
      INCLUDE 'inout.inc'
      INCLUDE 'rescal.inc'

      RECORD /SLIT/ VAN
      RECORD /NEUTRON/ NEUI,NEUF
      LOGICAL*4 LOG1,SAM_BOARDER
      REAL*8 V(3),K(3),R(3) 
      REAL*8 PP,T1,T2,DELTA
      REAL*8 VQ(3),WQ(3)
      REAL*4 DT
      REAL*4 RAN1
      INTEGER*4 I,J
      
      PP=1
      CALL SLIT_PRE1(VAN,NEUI.R,NEUI.K,V,K)

C/// move neutron to the centre of the SLIT:
      NEUF.T=NEUI.T-V(3)/HOVM/K(3)
      DO 10 I=1,2
10    R(I)=V(I)-V(3)/K(3)*K(I)
      R(3)=0.
    
      IF (SAM_BOARDER(VAN,R,K,T1,T2)) THEN
C/// move neutron to the sample entry:
	 NEUF.T=NEUI.T+T1
	 DO I=1,3
	   R(I)=R(I)+K(I)*T1
         ENDDO
         DELTA=T2-T1       
	 DT=RAN1()*DELTA
C/// move to the scattering point:
         NEUF.T=NEUF.T+DT
	 DO I=1,3
	   R(I)=R(I)+K(I)*DT
         ENDDO          
C*  transform from C&N coord.
         DO I=2,3
            WQ(I)=0
         ENDDO
         WQ(1)=STP.Q
         DO I=1,3
           VQ(I)=0
           DO J=1,3
            VQ(I)=VQ(I)+MLC(I,J)*WQ(J)
           ENDDO
         ENDDO
c//           kf=SQRT(ki**2-STP.E/HSQOV2M)
         DO I=1,3
            NEUF.R(I)=R(I)
            NEUF.K(I)=K(I)+VQ(I)
         END DO
!         NEUF.P=NEUI.P*ABS(DELTA)*kf ! multiply by local thickness*kf/ki
         NEUF.P=NEUI.P
         NEUF.S=NEUI.S         
         LOG1=(NEUF.P.GT.0.D0)
	 IF(LOG1) VAN.COUNT=VAN.COUNT+1
      ELSE 
	 LOG1=.FALSE.
	 NEUF.P=0
      END IF

      BRAGG_GO=LOG1
      RETURN
      END 

C----------------------------------------------------------      
      REAL*8 FUNCTION SQE_AMAG(VKI,VKF)
C inelastic scattering cross-section 
C spin waves in antiferromagnetics
C----------------------------------------------------------      
      
      IMPLICIT NONE
      INCLUDE 'const.inc'
      INCLUDE 'structures.inc'
      INCLUDE 'ness_common.inc'
      INCLUDE 'inout.inc'
      INCLUDE 'rescal.inc'
      INCLUDE 'randvars.inc'
      
      REAL*8 bf
      PARAMETER(bf=11.609) !Bose factor conversion kT -> meV
     
      REAL*8 VKI(3),VKF(3) 
      
      REAL*8 KF0,KI0,VQ(3),WQ(3),TAU(3),VE
      REAL*8 r1,nw,Eq,z,wqs
      INTEGER*4 I,J 
      
      
      REAL*8 CS,EGAP,GAMMA,SIG,EPS,TEMP
      
      DATA CS,EGAP,GAMMA,SIG,EPS,TEMP /1.D-5,1.65,0.2,1000,0.6,1.6/
c      DATA ITMP/0/
                   
      KF0=VKF(1)**2+VKF(2)**2+VKF(3)**2
      KI0=VKI(1)**2+VKI(2)**2+VKI(3)**2
c* get Q in lab. coord.
      DO I=1,3
        VQ(I)=VKF(I)-VKI(I)
      ENDDO
C* subtract nominal values from k vectors
      VQ(3)=VQ(3)-STP.KF*COMEGA+STP.KI
      VQ(1)=VQ(1)-STP.KF*SOMEGA
C*  transform to C&N coord.
      DO I=1,3
         WQ(I)=0
         DO J=1,3
            WQ(I)=WQ(I)+MLC(J,I)*VQ(J)
         ENDDO
      ENDDO
C*  transform to r.l. coord.
      DO I=1,3
         VQ(I)=0
         DO J=1,3
            VQ(I)=VQ(I)+MRC(I,J)*WQ(J)
         ENDDO
      ENDDO
C*  get energy transfer      
      VE=HSQOV2M*(KI0-KF0)
c*  get TAU      
      DO I=1,3
         TAU(I)=NINT(QHKL(I))
      ENDDO
c*  get propagation vector
      DO I=1,3
         VQ(I)=VQ(I)+QHKL(I)-TAU(I)
      ENDDO   
               
C// bose factor
      z=exp(-ABS(VE)*bf/temp)
      nw=z/(1-z)
      if (VE.GT.0) nw=nw+1 
      
C// excitation energy      
      wqs=EGap**2*(1+SIG*(VQ(1)**2+VQ(2)**2+EPS*VQ(3)**2)) ! dispersion law
          
C// dynamic structure factor          
      Eq=wqs+Gamma**2
      Z=(VE**2-Eq)**2+(VE*Gamma)**2
      r1=VE*Gamma/((VE**2-Eq)**2+(VE*Gamma)**2)
      Z=CS*nw*r1            
      
      SQE_AMAG=Z
      END

      
C----------------------------------------------------------      
      REAL*8 FUNCTION SQE_AMAG1(VKI,VKF)
C inelastic scattering cross-section 
C dispersion with finite width and curvature along QH 
C----------------------------------------------------------      
      
      IMPLICIT NONE
      INCLUDE 'const.inc'
      INCLUDE 'structures.inc'
      INCLUDE 'ness_common.inc'
      INCLUDE 'inout.inc'
      INCLUDE 'rescal.inc'
      INCLUDE 'randvars.inc'
      
      REAL*8 bf
      PARAMETER(bf=11.609) !Bose factor conversion kT -> meV
     
      REAL*8 VKI(3),VKF(3) 
      
      REAL*8 KF0,KI0,VQ(3),WQ(3),TAU(3),VE
      REAL*8 r1,nw,Eq,z,wqs
      INTEGER*4 I,J 
      
      
      REAL*8 CS,EGAP,GAMMA,SIG,EPS,TEMP
      
      DATA CS,EGAP,GAMMA,SIG,EPS,TEMP /1.D-5,1.65,0.2,1000,0,1.6/
c      DATA ITMP/0/
                   
      KF0=VKF(1)**2+VKF(2)**2+VKF(3)**2
      KI0=VKI(1)**2+VKI(2)**2+VKI(3)**2
c* get Q in lab. coord.
      DO I=1,3
        VQ(I)=VKF(I)-VKI(I)
      ENDDO
C* subtract nominal values from k vectors
      VQ(3)=VQ(3)-STP.KF*COMEGA+STP.KI
      VQ(1)=VQ(1)-STP.KF*SOMEGA
C*  transform to C&N coord.
      DO I=1,3
         WQ(I)=0
         DO J=1,3
            WQ(I)=WQ(I)+MLC(J,I)*VQ(J)
         ENDDO
      ENDDO
C*  transform to r.l. coord.
      DO I=1,3
         VQ(I)=0
         DO J=1,3
            VQ(I)=VQ(I)+MRC(I,J)*WQ(J)
         ENDDO
      ENDDO
C*  get energy transfer      
      VE=HSQOV2M*(KI0-KF0)
c*  get TAU      
      DO I=1,3
         TAU(I)=NINT(QHKL(I))
      ENDDO
c*  get propagation vector
      DO I=1,3
         VQ(I)=VQ(I)+QHKL(I)-TAU(I)
      ENDDO   
               
C// bose factor
      z=exp(-ABS(VE)*bf/temp)
      nw=z/(1-z)
      if (VE.GT.0) nw=nw+1 
      
C// excitation energy      
      wqs=EGap**2*(1+SIG*(VQ(1)**2)) ! dispersion law
          
C// dynamic structure factor          
      Eq=wqs+Gamma**2
      Z=(VE**2-Eq)**2+(VE*Gamma)**2
      r1=VE*Gamma/((VE**2-Eq)**2+(VE*Gamma)**2)
      Z=CS*nw*r1            
      
      SQE_AMAG1=Z
      END

     
      
      
      
