C//////////////////////////////////////////////////////////////////////
C////                                                              //// 
C////  NEutron Scattering Simulation - v.2.0, (c) J.Saroun, 2000   ////
C////                                                              //// 
C//////////////////////////////////////////////////////////////////////
C////
C////  Subroutines describing objects - SOURCE
C////  
C////                          
C//////////////////////////////////////////////////////////////////////

C-------------------------------------------------
      LOGICAL*4 FUNCTION SOURCE_GO(OBJ,NEUI,NEUF)
C-------------------------------------------------	
      implicit none

      INCLUDE 'const.inc'
      INCLUDE 'structures.inc'
      INCLUDE 'source.inc'
        
      LOGICAL*4 LOG1, SLIT_GO
      REAL*8 K0,A,DFLUX
      RECORD /SLIT/ OBJ
      RECORD /NEUTRON/ NEUI,NEUF
1     FORMAT(a10,1x,I4,1x,7(G11.4))
	
      LOG1=SLIT_GO(OBJ,NEUI,NEUF)
      IF (LOG1) THEN
        K0=SQRT(NEUF.K(1)**2+NEUF.K(2)**2+NEUF.K(3)**2)
        NEUF.P=NEUF.P*DFLUX(NEUF.R,NEUF.K)
        IF (FLXH.GT.0) then
             A=ATAN(NEUF.K(1)/NEUF.K(3))
             IF (ABS(A).GT.FLXH/2.) NEUF.P=0 
        ENDIF     
        IF (NEUF.P.GT.0.AND.FLXV.GT.0) then
           A=ATAN(NEUF.K(2)/NEUF.K(3))
           IF (ABS(A).GT.FLXV/2.) NEUF.P=0 
        ENDIF     
        IF (LOG1.AND.(OBJ.SHAPE.EQ.1)) THEN
          NEUF.P=NEUF.P*PI/2*COS(NEUF.R(1)/OBJ.SIZE(1)*PI)
        ENDIF
        NEUF.P=NEUF.P*
     *      (1.D0+FLXA*(NEUF.R(1)-FLX0)+FLXB*(NEUF.R(1)-FLX0)**2)*
     *      (1.D0+FLYA*(NEUF.R(2)-FLY0)+FLYB*(NEUF.R(2)-FLY0)**2)
     
        LOG1=(NEUF.P.GT.0.D0)
	IF (NEUF.P.LE.0) THEN
          IF (LOG1) OBJ.COUNT=OBJ.COUNT-1
          LOG1=.FALSE.
        ENDIF
      ENDIF  
        
      if (dbgref) write(*,1) OBJ.NAME,OBJ.COUNT,NEUF.R,NEUF.K,NEUF.P
	
      SOURCE_GO=LOG1
      RETURN
      END
	
C---------------------------------------------------------
      REAL*8 FUNCTION DFLUX(R,K)
C     F0 is the integral neutron flux [1e14/s/cm^2] 
C NEW!!! Returns dPhi/dK/dOmega in [1e14/s/cm^2/ster*Ang]
C---------------------------------------------------------
      IMPLICIT NONE
      INCLUDE 'const.inc'
      INCLUDE 'source.inc'
      REAL*8 R(3),K(3)
      REAL*8 z,LAM,VKT,K0
      INTEGER*4 iz  
      REAL*8 RES,PH,PV,V(2),DI,DJ
      REAL*8 LINTERP2D
1     format(a,6(2x,G10.4))

      K0=SQRT(K(1)**2+K(2)**2+K(3)**2)
 
      IF (FLXN.GT.0) GOTO 10 ! read lookup table

C Maxwell
      VKT=3.370*SQRT(STEMP/273.15) 
      DFLUX=SFLUX*K0**3*EXP(-K0*K0/VKT/VKT)/2./PI/VKT**4
      RETURN
      
C Lookup table
C// FLXDIST = dPhi/dLambda in [1e12/s/cm^2/Ang]

10    LAM=2*PI/K0
      PH=1.D0
      PV=1.D0
      if (FLXLOG.GT.0) GOTO 20 ! logarithmic scale

C Linear scale
      z=(LAM-FLXLAM(1))/FLXDLAM               
      iz=INT(z)+1
      if(iz.LT.1.OR.iz.GE.FLXN) then 
         RES=0.D0               
      else         
         RES=(FLXDIST(iz)+(z-iz+1)*(FLXDIST(iz+1)-FLXDIST(iz)))  
      endif 
      goto 30
C Log scale
20    z=LOG(LAM/FLXLAM(1))/FLXDLAM  
      iz=INT(z)+1
      if(iz.LT.1.OR.iz.GE.FLXN) then 
         RES=0.D0               
      else         
         RES=(FLXDIST(iz)+(z-iz+1)*(FLXDIST(iz+1)-FLXDIST(iz)))  
      endif 
 
C search 2D-table
30    if (FLXHNX.GT.0) THEN
        V(1)=R(1)
        V(2)=K(1)/K0
        DI=2.D0*FLXHX/(FLXHNX-1)
        DJ=2.D0*FLXHA/(FLXHNA-1)
        PH=LINTERP2D(FLXHP,FLXHNX,FLXHNA,64,-FLXHX,-FLXHA,DI,DJ,V)
      ENDIF   
      if (FLXVNX.GT.0) THEN
        V(1)=R(2)
        V(2)=K(2)/K0
        DI=2.D0*FLXVX/(FLXVNX-1)
        DJ=2.D0*FLXVA/(FLXVNA-1)
        PV=LINTERP2D(FLXVP,FLXVNX,FLXVNA,64,-FLXVX,-FLXVA,DI,DJ,V)
      ENDIF 
c      write(*,1) 'DFLUX: ',R(1),K(1)/K0,R(2),K(2)/K0,LAM 
c      write(*,1) 'DFLUX: ',FLXHX,FLXHA,FLXVX,FLXVA 
c      write(*,1) 'DFLUX: ',RES,PH,PV 
c      pause
      DFLUX=SFLUX/(2.D0*k0**2)*0.01*RES*PH*PV
      END
