C//////////////////////////////////////////////////////////////////////
C////
C////  R E S T R A X   4.1
C////
C////  Subroutines from the RESCAL program
C////  + some transformation procedures
C////
C////  * SUBROUTINE RECLAT
C////  * FUNCTION   TRANS(A,I)
C////  * SUBROUTINE CONVRT(A,AZ)
C////  * SUBROUTINE TRANSMAT
C////  * SUBROUTINE QNORM(Q,QRLU,QANG)
C////  * SUBROUTINE TRNVCT
C////  
C//////////////////////////////////////////////////////////////////////

C****************************
        SUBROUTINE RECLAT
C****************************
C        11-05-78
C        25-06-79 UPDATED
C        OVERLAY #11
C        COMPUTATION OF THE TRANSFORMATION MATRIX B
C        AND ORIENTATION MATRIX S
C        REQUIRED: VECTOR A=UNIT CELL SIDES, VECTOR ALFA=CELL ANGLES
C        A1=VECTOR IN DIRECTION ACO, A2=VECTOR IN DIRECTION BCO
C        X=SUM(S(1,I)*Q(I)) AND Y=SUM(S(2,I)*Q(I)) ARE CARTESIAN
C        COORDINATES IN SCATTERING PLANE, TRANSFORMED FROM VECTOR
C        Q W.R.T. CRYSTAL LATTICE.  SUM(S(3,I)*Q(I)) SHOULD=0
C
C       S(i,j) transforms Q(hkl) in the r.l.u. into 
C       the orthogonal coordinates given by A(i),B(i) vectors 
C       defining the scattering plane
C
C       SD(i,j) is a matrix defined so that
C       Qhkl = SQRT((hkl)*SD*(hkl))   (in A^-1)
C
C***********************************************************************
      IMPLICIT NONE     
      INCLUDE 'const.inc'
      INCLUDE 'inout.inc'
      INCLUDE 'rescal.inc'
      REAL*8 EPS   
      PARAMETER(EPS=1.0D-8)
      REAL*8 S(3,3),SD(3,3),B(3),COSB(3)
      COMMON /S/S,SD,B,COSB
      INTEGER*4 IER
      COMMON /ERROR/IER
      REAL*8 AQ(3),ALFA(3),A1(3),A2(3)

      REAL*8 V1(3),V2(3),V3(3),U(3,3),COSA(3),SINA(3),SINB(3)
      REAL*8 A(3),BB(3,3),ZD,RD,CC,C1,C2,C3,SS
      INTEGER*4 I,J,K,L,M

      DO I=1,3
        AQ(I)=RES_DAT(i_AS+I-1)
        ALFA(I)=RES_DAT(i_AA+I-1)
        A1(I)=RES_DAT(i_AX+I-1)
        A2(I)=RES_DAT(i_BX+I-1)
      ENDDO
        ZD=2.D0*PI
        RD=2*PI/360.D0
        CC=0.
        DO 1 I=1,3
          A(I)=AQ(I)/ZD
          IF(ABS(A(I)).GT..00001) GOTO 6
          
c       write(*,*)I,A(I)   
          IER=1
          GO TO 100
6          COSA(I)=COS(ALFA(I)*RD)
          SINA(I)=SIN(ALFA(I)*RD)
    1          CC=CC+COSA(I)*COSA(I)
        CC=1.+2.*COSA(1)*COSA(2)*COSA(3)-CC
        IF(CC.LE.0.) GOTO 23
        CC=SQRT(CC)
        J=2
        K=3
        DO 2 I=1,3
        B(I)=SINA(I)/(A(I)*CC)            ! length of the r.l. axes
        COSB(I)=(COSA(J)*COSA(K)-COSA(I))/(SINA(J)*SINA(K))
        SINB(I)=SQRT(1.-COSB(I)*COSB(I))  ! angles btw. r.l. axes
        J=K
    2        K=I
    
    
        DO I=1,3   
           SD(I,I)=B(I)**2
        END DO
        SD(1,2)=(COSA(1)*COSA(2)-COSA(3))/AQ(1)/AQ(2)*(2*PI/CC)**2
        SD(1,3)=(COSA(1)*COSA(3)-COSA(2))/AQ(1)/AQ(3)*(2*PI/CC)**2
        SD(2,3)=(COSA(2)*COSA(3)-COSA(1))/AQ(2)/AQ(3)*(2*PI/CC)**2
        SD(2,1)=SD(1,2)
        SD(3,1)=SD(1,3)
        SD(3,2)=SD(2,3)    
    
    
        BB(1,1)=B(1)
        BB(2,1)=0.
        BB(3,1)=0.
        BB(1,2)=B(2)*COSB(3)
        BB(2,2)=B(2)*SINB(3)
        BB(3,2)=0.
        BB(1,3)=B(3)*COSB(2)
        BB(2,3)=-B(3)*SINB(2)*COSA(1)
        BB(3,3)=1/A(3)                    ! checked ... O.K.
C        GENERATION OF ORIENTATION MATRIX REC. LATTICE TO SCATTERING PLANE
        DO 3 I=1,3
        C1=0.
        C2=0.
        DO 4 J=1,3
        C1=C1+BB(I,J)*A1(J)
    4        C2=C2+BB(I,J)*A2(J)
        V1(I)=C1
    3        V2(I)=C2
        V3(1)=V1(2)*V2(3)-V1(3)*V2(2)
        V3(2)=V1(3)*V2(1)-V1(1)*V2(3)
        V3(3)=V1(1)*V2(2)-V1(2)*V2(1)
        V2(1)=V3(2)*V1(3)-V3(3)*V1(2)
        V2(2)=V3(3)*V1(1)-V3(1)*V1(3)
        V2(3)=V3(1)*V1(2)-V3(2)*V1(1)
        C1=(V1(1)*V1(1)+V1(2)*V1(2)+V1(3)*V1(3))
        C2=(V2(1)*V2(1)+V2(2)*V2(2)+V2(3)*V2(3))
        C3=V3(1)**2+V3(2)**2+V3(3)**2
        IF(ABS(C1)-EPS)14,14,15
   14        IER=5
        GOTO 100
   15        IF(ABS(C2)-EPS)16,16,17
   16        IER=6
        GOTO 100
   17        IF(ABS(C3)-EPS)18,18,19
   18        IER=7
        GOTO 100
   19        CONTINUE
        C1=SQRT(C1)
        C2=SQRT(C2)
        C3=SQRT(C3)
        DO 5 I=1,3
        U(1,I)=V1(I)/C1
        U(2,I)=V2(I)/C2
    5        U(3,I)=V3(I)/C3
        DO 7 K=1,3
        DO 7 M=1,3
        SS=0.
        DO 8 L=1,3
    8        SS=SS+U(K,L)*BB(L,M)
        S(K,M)=SS
    7        CONTINUE
  100        IF(IER)200,200,20
   20        GOTO(22,22,22,23,24,24,24),IER
   22        WRITE(sout,30)
        GOTO 200
   23        WRITE(sout,31)
        IER=1
        GOTO 200
   24        WRITE(sout,32)
  200        CONTINUE
        RETURN
   30        FORMAT(' RECLAT: Check Lattice Spacings (AS,BS,CS)'/)
   31        FORMAT(' RECLAT: Check Cell Angles (AA,BB,CC)'/)
   32        FORMAT(' RECLAT: Check Scattering Plane (AX....BZ)'/)
        END

        REAL*8 FUNCTION TRANS(A,I)
C***********************************************************************
C***********************************************************************
        IMPLICIT NONE
        INTEGER*4 I
        REAL*8 A(3)
        REAL*8 S(3,3),SD(3,3),B(3),COSB(3)
        COMMON /S/S,SD,B,COSB
        TRANS=S(I,1)*A(1)+S(I,2)*A(2)+S(I,3)*A(3)
        RETURN
        END

C--------------------------------------------------------------------
      SUBROUTINE TRANSMAT
C  creates transformation matrices for the four coordinate systems:     
C  R  ...  reciprocal lattice  
C  C  ...  Cooper & Nathans coordinates (C&N)
C  G  ...  C&N rotated so that X(1) // grad E(Q)
C  D  ...  G rotated so that X(4) // normal to the disp. surface    
C--------------------------------------------------------------------
      IMPLICIT NONE
      INCLUDE 'const.inc'
      INCLUDE 'inout.inc'
      INCLUDE 'rescal.inc'
      REAL*8 S(3,3),SD(3,3),B(3),COSB(3)
      COMMON /S/S,SD,B,COSB
      REAL*8 Q3(3),Z,XG,YG,ZG,XQ,YQ,GG,GG1,QQ,CO,SI,CO1,SI1
      REAL*8 GNR,GNA,ZRA,PHI,SI2,CO2,MGD(4,4)
      REAL*8 TRANS
      INTEGER*4 I,J
      
c         write(*,*) 'TRANSMAT: ',Q
      Z=SQRT(QHKL(1)**2+QHKL(2)**2+QHKL(3)**2)
      IF(Z.EQ.0) THEN 
        Q3(1)=1
        Q3(2)=0
        Q3(3)=0
      ELSE
        DO I=1,3
          Q3(I)=QHKL(I)
        ENDDO
      ENDIF            
      XG=TRANS(GRD,1)
      YG=TRANS(GRD,2)
      ZG=TRANS(GRD,3)
      XQ=TRANS(Q3,1)
      YQ=TRANS(Q3,2)                              
      GG=SQRT(XG**2+YG**2+ZG**2)
      GG1=SQRT(XG**2+YG**2)
      QQ=SQRT(XQ**2+YQ**2)
      
      CO=XQ/QQ
      SI=YQ/QQ
      DO 11 I=1,3
        MCR(1,I)=S(1,I)*CO+S(2,I)*SI
        MCR(2,I)=S(2,I)*CO-S(1,I)*SI
        MCR(3,I)=S(3,I)
        MCR(4,I)=0.
11        MCR(I,4)=0.
      MCR(4,4)=1.                           ! (MCR): r.l.u. --> C&N
                  

C///  Transformation from (grad(E)//x) to C&N
      SI1=ZG/GG
      CO1=SQRT(1-SI1**2)
      SI2=(XQ*YG-YQ*XG)/QQ/GG1
      CO2=(XG*XQ+YG*YQ)/QQ/GG1
 
      MCG(1,1)= CO1*CO2
      MCG(2,1)= CO1*SI2
      MCG(3,1)= +SI1     
      MCG(1,2)= -SI2
      MCG(2,2)= CO2
      MCG(3,2)=0 
      MCG(1,3)=-SI1*CO2 
      MCG(2,3)=-SI1*SI2 
      MCG(3,3)=CO1
      DO 10 I=1,3
        MCG(I,4)=0
        MCG(4,I)=0
10    CONTINUE
      MCG(4,4)=1                        ! (MCG): grad   -->  C&N
      
      DO 20 I=1,4
        DO 21 J=1,4
21        MGD(I,J)=0
        MGD(I,I)=1
20    CONTINUE

      CALL QNORM(GRD(1),GNR,GNA)
      ZRA=GNR/GNA      
      
      PHI=ATAN(RES_DAT(i_GMOD)*ZRA)              ! units of GMOD are Energy/r.l.u.!

      MGD(1,1)=COS(PHI)
      MGD(4,4)=COS(PHI)
      MGD(1,4)=-SIN(PHI)
      MGD(4,1)=SIN(PHI)                 ! (MGD): grad   <--  disp 
         
      CALL MXM(1,4,4,MCG,MGD,MCD)       ! (MCD): C&N    <--  disp     
      CALL INVERT(4,MCR,4,MRC,4)        ! (MRC): C&N    -->  r.l.u.
      CALL MXM(-1,4,4,MCD,MCR,MDR)      ! (MDR): r.l.u. -->  disp

      RETURN
      END


C--------------------------------------------
      SUBROUTINE QNORM(Q,QRLU,QANG)
C     returns norm of Qhkl in r.l.u and A^-1
C--------------------------------------------
      IMPLICIT NONE
      INCLUDE 'const.inc'
      INCLUDE 'inout.inc'
      INCLUDE 'rescal.inc'
      REAL*8 Q(3),QRLU,QANG
      REAL*8 S(3,3),SD(3,3),B(3),COSB(3)
      COMMON /S/S,SD,B,COSB
      REAL*8 V3(3),V3xV3,TRANS
      INTEGER*4 I    
      
      QRLU=SQRT(V3XV3(Q,Q)+2*Q(1)*Q(2)*COSB(3)+2*Q(2)*Q(3)*COSB(1)+
     1    2*Q(1)*Q(3)*COSB(2))                  ! norm of G(3) in r.l.u.
      
      DO I=1,3
        V3(I)=TRANS(Q,I)
      END DO  
      QANG= SQRT(V3(1)**2+V3(2)**2+V3(3)**2)   ! norm of G(3) in [A-1]
      
      RETURN
      END  
      
C
C***********************************************************************
      SUBROUTINE RESMAT
C    calculates resolution matrices their parameters from MC 
C***********************************************************************
      IMPLICIT NONE
      INCLUDE 'const.inc'
      INCLUDE 'inout.inc'
      INCLUDE 'rescal.inc'
      REAL*8 DETERM
      
      INTEGER*4 I,J,K,NCNT,ICNT,IALLOC
      REAL*8 PP, E(4),AUX(4,4),SUMA,Z1,Z2
      REAL*8 COV(4,4),COVRL(4,4),MEAN(4)
      REAL*8 VOLRESMC,RESMATCN(4,4),RESMATRL(4,4)
      REAL*8 BRAGCN(4),VANCN(4),BRAGRL(4),VANRL(4)
      COMMON /RESMATPAR/ VOLRESMC,RESMATCN,RESMATRL,BRAGCN,VANCN,
     *                   BRAGRL,VANRL

1     format(a,I,6(2x,G11.5))

      DO J=1,4
        DO K=1,4
          RESMATCN(J,K)=0.D0
          RESMATRL(J,K)=0.D0
          COV(J,K)=0.D0
        ENDDO
        BRAGCN(J)=0.D0  
        BRAGRL(J)=0.D0  
        VANCN(J)=0.D0  
        VANRL(J)=0.D0 
        MEAN(J)=0.D0
      ENDDO 
      NCNT=0
C// get number of accumulated (Q,E) events
      CALL NSTORE_N(I,NCNT,IALLOC)
c      write(*,*) NCNT,IALLOC
c      pause
      IF(NCNT.LT.3.OR.IALLOC.LT.NCNT) GOTO 99
      ICNT=0
      SUMA=0.D0
C// accumulate covariance matrix
      DO  I=1,NCNT
         CALL NSTORE_GETQE(I,E,PP,0.)
         DO J=1,4
           DO K=1,4
            COV(J,K)=COV(J,K)+E(J)*E(K)*PP
           ENDDO
           MEAN(J)=MEAN(J)+E(J)*PP
         ENDDO  
         SUMA=SUMA+PP
         ICNT=ICNT+1
      ENDDO 
      IF (SUMA.LE.0.OR.ICNT.LE.1) GOTO 99  
C// normalize covariance matrix
      DO J=1,4
         MEAN(J)=MEAN(J)/SUMA
         DO K=1,4
           COV(J,K)=COV(J,K)/SUMA
         ENDDO
      ENDDO   
C// subtract mean 
      DO J=1,4
         DO K=1,4
           COV(J,K)=COV(J,K)-MEAN(J)*MEAN(K)
         ENDDO
      ENDDO   
C// invert COV to get resolution matrix in C&N coord.
      CALL INVERT(4,COV,4,RESMATCN,4)
C// transform to reciprocal lattice coord.      
      CALL MXM(1,4,4,RESMATCN,MCR,AUX)
      CALL MXM(-1,4,4,MCR,AUX,RESMATRL) 
C// Bragg widths are calculated from diagonal elements of resol. mat.
      DO J=1,4
        Z1=ABS(RESMATCN(J,J))
        Z2=ABS(RESMATRL(J,J))
        if (Z1.GT.1.D-16) BRAGCN(J)=R8LN2/SQRT(Z1)
        if (Z2.GT.1.D-16) BRAGRL(J)=R8LN2/SQRT(Z2)
      ENDDO
C// Vanad widths are calculated from diagonal elements of covar. mat.
      CALL INVERT(4,RESMATRL,4,COVRL,4)
      DO J=1,4
        VANCN(J)=R8LN2*SQRT(ABS(COV(J,J)))
        VANRL(J)=R8LN2*SQRT(ABS(COVRL(J,J)))
      ENDDO
      VOLRESMC=SQRT(ABS(DETERM(COV,4,AUX)))*4*PI**2
      RETURN
      
99    CONTINUE
      
      END
      
