C//////////////////////////////////////////////////////////////////////
C////
C////  R E S T R A X   4.4
C////
C////  Conversion subroutines between RESCAL and TRAX parameters
C////   
C////  * SUBROUTINE RT_CONVRT
C////  * SUBROUTINE VIVF(VI,VF)
C////  
C//////////////////////////////////////////////////////////////////////

C----------------------------------------------------
      SUBROUTINE READ_SOU(LINE,NS,DIA,W,H,IER)
C Read parameters of a DETECTOR from the CFG file     
C-----------------------------------------------------------  
      IMPLICIT NONE
      INTEGER*4 NS,IER
      REAL*8 DIA,W,H
      CHARACTER*128 LINE
      
      IER=0
      READ(LINE,*,ERR=99) NS,DIA,W,H
      
      RETURN
      
99    IER=1      
      END      

C----------------------------------------------------
      SUBROUTINE READ_DET(LINE,ND,DIA,W,H,ANGLE,NSEG,SPACE,PHI,IER)
C Read parameters of a DETECTOR from the CFG file     
C-----------------------------------------------------------  
      IMPLICIT NONE
      
      INTEGER*4 ND,NSEG,IER
      REAL*8 DIA,W,H,ANGLE,SPACE,PHI
      CHARACTER*128 LINE
      
      IER=0
      READ(LINE,*,ERR=1) ND,DIA,W,H,ANGLE,NSEG,SPACE,PHI
      RETURN    
1     READ(LINE,*,ERR=99) ND,DIA,W,H
      ANGLE=0.D0
      NSEG=1
      SPACE=0.D0
      PHI=0.D0
      RETURN
      
99    IER=1      
      END      

C----------------------------------------------------
      SUBROUTINE READ_MONO(LINE,CHI,ANIZ,POIS,THICK,HEIGHT,WIDTH,
     *                     NH,NV,NB,IER)
C Read parameters of a CRYSTAL from the CFG file     
C-----------------------------------------------------------  
      IMPLICIT NONE
      
      REAL*8 CHI,ANIZ,POIS,THICK,HEIGHT,WIDTH
      INTEGER*4 NH,NV,NB,IER
      CHARACTER*128 LINE
      IER=0
      
      READ(LINE,*,ERR=1) CHI,ANIZ,POIS,THICK,HEIGHT,WIDTH,
     *                   NH,NV,NB
      RETURN    
1     READ(LINE,*,ERR=99) CHI,ANIZ,POIS,THICK,HEIGHT,WIDTH,
     *                   NH,NV
      NB=1
      RETURN
      
99    IER=1      
      END      

C-----------------------------------------------------------
      SUBROUTINE READ_COL(LINE,DIST,LENG,H1,H2,V1,V2,IC,IER)
C Read parameters of a GUIDE/COLLIMATOR from the CFG file
C IC .. collimator index     
C-----------------------------------------------------------  
      IMPLICIT NONE      
      INCLUDE 'collimators.inc'
      
      REAL*8 DIST,LENG,H1,H2,V1,V2
      INTEGER*4 IC,IER
      CHARACTER*128 LINE

10    FORMAT(a15,8(1x,G10.4))
      IER=0
C full format
      READ(LINE,*,ERR=1) CTYP(IC),DIST,LENG,H1,H2,V1,V2,ROH(IC),ROV(IC),
     &   GAMH(IC),GAMV(IC),REFH(IC),REFV(IC),NLAM(IC),VLAM(IC),
     &   DLAMH(IC),DLAMV(IC)
c      write(*,10) 'full format',IC,CTYP(IC),ROH(IC),ROV(IC) 
      
      IF (CTYP(IC).GT.4.OR.CTYP(IC).LT.-1) GOTO 1 ! -1 >= CTYP <= 4, else error      
      IF (LENG.LE.0) CTYP(IC)=-1      
      RETURN    
     
C old RESTRAX format, extended by NLAM, VLAM, DLAM  
1     READ(LINE,*,ERR=2) DIST,LENG,H1,H2,V1,V2,ROH(IC),GAMH(IC),
     &   GAMV(IC),REFH(IC),REFV(IC),NLAM(IC),VLAM(IC),DLAMH(IC)   
c      write(*,*) 'format 1!'
      CTYP(IC)=0
      DLAMV(IC)=DLAMH(IC)
      ROV(IC)=0
      IF (GAMH(IC).GT.0.OR.GAMV(IC).GT.0) CTYP(IC)=1
      IF (LENG.LE.0) CTYP(IC)=-1
      RETURN    
      
C old RESTRAX format, extended by NLAM,DLAM  
2     READ(LINE,*,ERR=3) DIST,LENG,H1,H2,V1,V2,ROH(IC),GAMH(IC),
     &                   GAMV(IC),REFH(IC),REFV(IC),NLAM(IC),DLAMH(IC)
c      write(*,*) 'format 2!'
      VLAM(IC)=0
      DLAMV(IC)=DLAMH(IC)
      ROV(IC)=0
      CTYP(IC)=0
      IF (GAMH(IC).GT.0.OR.GAMV(IC).GT.0) CTYP(IC)=1
      IF (LENG.LE.0) CTYP(IC)=-1
      RETURN   

C old RESTRAX format       
3     READ(LINE,*,ERR=99)  DIST,LENG,H1,H2,V1,V2,ROH(IC),GAMH(IC),
     &     GAMV(IC),REFH(IC),REFV(IC)
     
c      write(*,*) 'format 3!'
      NLAM(IC)=0
      VLAM(IC)=0
      DLAMH(IC)=0.0
      DLAMV(IC)=DLAMH(IC)
      ROV(IC)=0
      CTYP(IC)=0
      IF (GAMH(IC).GT.0.OR.GAMV(IC).GT.0) CTYP(IC)=1
      IF (LENG.LE.0) CTYP(IC)=-1
      RETURN      
99    IER=1      
      END      


C--------------------------------------------------------------
      SUBROUTINE READ_COL1(LINE,NF,DIST,LENG,H1,H2,V1,V2,IC,IER)
C Read parameters of a GUIDE/COLLIMATOR from the CFG file, with presence indicator     
C--------------------------------------------------------------  
      IMPLICIT NONE      
      
      REAL*8 DIST,LENG,H1,H2,V1,V2
      INTEGER*4 IC,NF,IS,IL,IER
      CHARACTER*128 LINE
      
      IER=0
      IS=1
      CALL FINDPAR(LINE,1,IS,IL)
      IF (IL.LE.0) GOTO 99
      READ(LINE(IS:IS+IL-1),*,ERR=99) NF
      CALL READ_COL(LINE(IS+IL:128),DIST,LENG,H1,H2,V1,V2,IC,IER)
      RETURN
      
99    IER=1      
      END      

C----------------------------------------------------------
      SUBROUTINE READCFG(FNAME)
C  Read configuration from FNAME (assume that exists)
C + some initial conversions  
C----------------------------------------------------------      
      IMPLICIT NONE

      INCLUDE 'const.inc'
      INCLUDE 'inout.inc'
      INCLUDE 'collimators.inc'
      INCLUDE 'rescal.inc'
      INCLUDE 'trax.inc'

      INTEGER*4 IU
      PARAMETER (IU=25)
      CHARACTER*(*) FNAME
 
      CHARACTER*128 LINE     
      DATA nhm,nha,nvm,nva /1,1,1,1/       
      INTEGER*4 IER,ILINE,I,IS,IL  
      
      
          

CxxxxxxxxxCxxxxxxxxxCxxxxxxxxxCxxxxxxxxxCxxxxxxxxxCxxxxxxxxxCxxxxxxxxx
100   FORMAT(A60)
101   FORMAT(a) 

      CALL BOUNDS(FNAME,IS,IL)
      OPEN(UNIT=IU,FILE=FNAME(IS:IS+IL-1),STATUS='OLD',ERR=999,
     *     IOSTAT=IER)
      
C ***  READ CFG FILE  ***
      ILINE=0  
C* Source
  3   READ(IU,*,END=997)
      READ(IU,100,END=997) CFGTITLE
      READ(IU,*,END=997)
      READ(IU,101,END=997) LINE
      CALL READ_SOU(LINE,NSOU,DIASOU,WSOU,HSOU,IER)
      IF (IER.NE.0) GOTO 997
      ILINE=ILINE+2  

C* Guide A
      READ(IU,*,END=997)
      READ(IU,101,END=997) LINE
      CALL  READ_COL(LINE,DGA,LGA,HGA1,HGA2,VGA1,VGA2,1,IER)
      IF (IER.NE.0) GOTO 997
      ILINE=ILINE+2  

C* Guide B
      READ(IU,*,END=997)
      READ(IU,101,END=997) LINE
      CALL  READ_COL1(LINE,NFG,DGUIDE,LGUIDE,HG1,HG2,VG1,VG2,2,IER)
      IF (IER.NE.0) GOTO 997
      ILINE=ILINE+2  
      IF (NFG.EQ.0) THEN ! ignore guides
         CTYP(2)=-1
         CTYP(1)=-1         
      ENDIF
C* Monochromator
      READ(IU,*,END=997)
      READ(IU,101,END=997) LINE      
      CALL  READ_MONO(LINE,HIMON,ANRM,POISSM,THMON,HMON,WMON,nhm,
     &      nvm,nbm,IER)
      IF (IER.NE.0) GOTO 997
      ILINE=ILINE+2  

C* Analyzer
      READ(IU,*,END=997)
      READ(IU,101,END=997) LINE
      CALL  READ_MONO(LINE,HIANA,ANRA,POISSA,THANA,HANA,WANA,nha,
     &      nva,nba,IER)
      IF (IER.NE.0) GOTO 997
      ILINE=ILINE+2  

C* Detector
      READ(IU,*,END=997)
      READ(IU,101,END=997) LINE
      CALL  READ_DET(LINE,NDET,DIADET,WDET,HDET,ADET,NSEGDET,SPACEDET,
     *      PHIDET,IER)
      IF(NSEGDET.GT.64) NSEGDET=64 
      IF (IER.NE.0) GOTO 997
      ILINE=ILINE+2  

C* Distances
      READ(IU,*,END=997)
      READ(IU,*,END=997,ERR=997) VL0,VL1,VL2,VL3
      ILINE=ILINE+2  
C* COL1
      READ(IU,*,END=997)
      READ(IU,101,END=997) LINE
      CALL  READ_COL(LINE,VLCANM,VLSM,HDM1,HDM2,VDM1,VDM2,3,IER)
      IF (IER.NE.0) GOTO 997
      ILINE=ILINE+2  

C* COL2 A
      READ(IU,*,END=997)
      READ(IU,101,END=997) LINE
      CALL  READ_COL(LINE,DIST2A,LEN2A,H2A1,H2A2,V2A1,V2A2,4,IER)
      IF (IER.NE.0) GOTO 997
      ILINE=ILINE+2  

C* COL2 B
      READ(IU,*,END=997)
      READ(IU,101,END=997) LINE
      CALL  READ_COL(LINE,VLCANS,VLMS,HDS1,HDS2,VDS1,VDS2,5,IER)
      IF (IER.NE.0) GOTO 997
      ILINE=ILINE+2  

C* COL3
      READ(IU,*,END=997)
      READ(IU,101,END=997) LINE
      CALL  READ_COL(LINE,VLCANA,VLSA,HDA1,HDA2,VDA1,VDA2,6,IER)
      IF (IER.NE.0) GOTO 997
      ILINE=ILINE+2  

C* COL4
      READ(IU,*,END=997)
      READ(IU,101,END=997) LINE
      CALL  READ_COL(LINE,VLCAND,VLAD,HDD1,HDD2,VDD1,VDD2,7,IER)
      IF (IER.NE.0) GOTO 997
      ILINE=ILINE+2  

C ***  END OF READ CFG FILE, go to interpretation  ***
      CLOSE(IU)
      GO TO 2     

C ***  ERROR while reading, show message and go to interpretation anyway ***      
997   WRITE(SOUT,*) 'ERROR after line ',ILINE,' in file '//FNAME
      WRITE(SOUT,*) LINE
      pause
      CLOSE(IU)

2     CONTINUE   
C some unit conversions
      DO I=1,NCO
         GAMH(I)=GAMH(I)*GammaNi
         GAMV(I)=GAMV(I)*GammaNi
         IF (CTYP(I).LE.1) THEN ! convert RO to [mm]
           ROH(I)=ROH(I)/1000.
           ROV(I)=ROV(I)/1000.
         ENDIF  
      ENDDO                             
      
      write(SOUT,*) 'Configuration updated from ',FNAME(IS:IS+IL-1)
      RETURN
         
        
999   WRITE(*,998) IER   
998   FORMAT('Fatal error: ',I5,' cannot open configuration file. ',/,
     * 'Check privileges or disk space !')
      STOP 
      END


C----------------------------------------------------------
      SUBROUTINE WRITEDEFCFG
C  Write default config. file to the current directory
C  Use the full format (new in since version 4.9.92)
C TYP=-1 no collimator
C TYP=0  standard collimator (course or soller)
C TYP=1  guide (or bender), can be curved (RO means curvature in [1/m] )
C TYP=2  parabolic guide, equal lengths of the lamellae (RO means focal distance in [cm] !)
C TYP=3  parabolic guide, optimized lengths of the lamellae 
C TYP=4  elliptic guide, wider window is the smaller ellipse axis
C
C extended detector format:
C =========================
C if eta>0, then assumes vertical tube(s)
C nseg = number of tubes 
C space = space between tubes [mm]
C phi = inclination angle [deg], phi=0 means tube is vertical
C detector efficiency: 1-EXP(-eta*lambda*pathlength)
C---------------------------------------------------------- 
      IMPLICIT NONE
      CHARACTER*16 C(13)
      CHARACTER*82 VALS(13),HEAD(13)
      INTEGER*4 I
C element names      
      DATA C/
     &  'title',
     &  'n-guide A',
     &  'n-guide B',
     &  'monochromator',
     &  'analyzer',
     &  'segments',
     &  'detector',
     &  'distances',
     &  '1st collimator',
     &  '2nd collimator A',
     &  '2nd collimator B',
     &  '3nd collimator',     
     &  '4th collimator'/
c some headers 
      
      VALS(1)='default setup (IN14 with PG and Soller)'
      VALS(2)='0   21.   6.   12.'
      VALS(3)='1  7.5  584.5  6.  6. 12. 12.  0.  0.  1.2  1.2  1  1'//
     1      '  1  1  0. 0.'
     
      VALS(4)='1  1  807.5  1050.  6.  6.  12.  12.  0.  0. 1.2  1.2'//
     1      '  1  1  1  1  0. 0.'
     
      VALS(5)='0.  1.  0.3  0.2  12.  15.  1  7  1'
      VALS(6)='0.  1.  0.3  1.0  12.  16.  1  5  1'
      VALS(7)='1   4.0   4.0  6.0  0.0  1  0.  0.'
      VALS(8)='22.5  270.  155.  64.'
      
      VALS(9)='0     1.     5.  10.  10.   15.   15.  0.  0.  0.  0.'// 
     1      '  0.  0. 1  1  0. 0.'
     
      VALS(10)='-1    2.     0.   6.   6    12.   12.  0.  0.  0.  0.'// 
     1      '  0.  0. 1  1  0. 0.'
     
      VALS(11)='0   100.    20.   4.   4.   12.   12   0.  0.  0.  0.'//  
     1      '  0.  0. 1  1  0. 0.'
     
      VALS(12)='0   113.    20.   4.   4.   12.   12.  0.  0.  0.  0.'// 
     1      '  0.  0. 1  1  0. 0.'
     
      VALS(13)='0    35.    20.   4.   4.   12.   12.  0.  0.  0.  0.'// 
     1      '  0.  0. 1  1  0. 0.'
     
      HEAD(1)='title (max.60 characters)'
      
      HEAD(2)='shape, dia, width, height' 
      HEAD(3)='typ, gap, len, H1, H2, V1, V2, roh, rov,'//
     1        ' mh, mv, refh, refv, nh, nv, dh, dv'

      HEAD(4)='use, typ, dist, len, H1, H2, V1, V2, roh, rov,'//
     1' mh, mv, refh, refv, nh, nv, dh, dv'

      HEAD(5)='chi, aniz., poiss., thick., height, length, nh, nv, nt'
     
      HEAD(6)=HEAD(5)
      HEAD(7)='shape, dia, width, height, eta, nseg, space, angle'
      HEAD(8)='sou-mono, mono-sample, sample-anal, anal-det'
      HEAD(9)='typ, dist, len, H1, H2, V1, V2, roh, rov,'//
     1' mh, mv, refh, refv, nh, nv, dh, dv'
      HEAD(10)=HEAD(3)
      HEAD(11)=HEAD(9)
      HEAD(12)=HEAD(9)
      HEAD(13)=HEAD(9)

1     FORMAT(a13,' (',a,')')
2     FORMAT(a)
      
      
      OPEN(UNIT=24,FILE='simres00.cfg',STATUS='UNKNOWN',ERR=10)
      DO I=1,13        
         write(24,1) C(I),HEAD(I)
         write(24,2) VALS(I)
      ENDDO
      CLOSE(24)
10    continue       
      END
      
C----------------------------------------------------------
      SUBROUTINE SETDEFRES
C  Sets the default rescal parameters and write to default.res file 
C  in the current directory
C----------------------------------------------------------
      IMPLICIT NONE
      INCLUDE 'inout.inc'
      INCLUDE 'rescal.inc'
      INTEGER*4 I
      
      DO I=1,MRES
        RES_DAT(I)=RES_DEF(I)
      ENDDO
      CALL WRITE_RESCAL(RESCAL_DEFNAME,I)
      END
      
      
      
      
