C//////////////////////////////////////////////////////////////////////
C////
C////  R E S T R A X   4.1
C////
C////  Graphics output subroutines (PGPlot library required)
C////
C////  
C//////////////////////////////////////////////////////////////////////

C-------------------------------------------------------------
      SUBROUTINE PLOT2D(PORT,A,NX,NY,NDX,NDY)
C   plots a gray-scale map of the array A to the viewport PORT      
C-------------------------------------------------------------
      IMPLICIT NONE
      INCLUDE 'sim_grf.inc'
      INTEGER*4 NX,NY,NDX,NDY
      REAL*4 A(NDX,NDY)
      REAL*4 AMAX,CX,DX,CY,DY,TR(6)
      INTEGER*4 I,J
      RECORD/VIEWSET/ PORT
      
      DX=(PORT.WX2-PORT.WX1)/NX
      CX=(PORT.WX2+PORT.WX1)/NX
      
      DY=(PORT.WY2-PORT.WY1)/NY
      CY=(PORT.WY2+PORT.WY1)/NY
      
      
      TR(1)=-0.5*DX+PORT.WX1
      TR(2)=DX
      TR(3)=0.
      TR(4)=-0.5*DY+PORT.WY1
      TR(5)=0.
      TR(6)=DY      
      AMAX=0.
      DO 20 I=1,NX
      DO 20 J=1,NY
          IF (A(I,J).GT.AMAX) AMAX=A(I,J)
20    CONTINUE      
      CALL PGVPORT(PORT.DX1,PORT.DX2,PORT.DY1,PORT.DY2)        
      CALL PGWINDOW(PORT.WX1,PORT.WX2,PORT.WY1,PORT.WY2)                  
      CALL PGGRAY(A,NDX,NDY,1,NX,1,NY,AMAX*1.1,0.,TR)
C      CALL PGBOX('ABCNST',0.0,0,'ABCNST',0.0,0)
      
      RETURN
      END      

C---------------------------------------------------------------
      SUBROUTINE PLOTFRAME(PORT,ICL,ILS,ZCH,IAX)
C  plots frame, axes and titles of the viewport PORT with given
C  collor index (ICL), line style (ILS) and character size (ZCH)
C  If IAX=0, axes at (0,0) are not plotted.      
C---------------------------------------------------------------
      IMPLICIT NONE
      INCLUDE 'sim_grf.inc'
      INTEGER*4 ICL,ILS,IAX
      REAL*4 ZCH
      RECORD/VIEWSET/ PORT
            
      CALL PGSCH(ZCH)
      CALL PGVPORT(PORT.DX1,PORT.DX2,PORT.DY1,PORT.DY2)        
      CALL PGWINDOW(PORT.WX1,PORT.WX2,PORT.WY1,PORT.WY2)            
      CALL PGSCI(ICL)
      CALL PGSLS(ILS)
      IF(IAX.EQ.0) THEN
         CALL PGBOX('BCNST',0.0,0,'BCNST',0.0,0)
      ELSE
         CALL PGBOX('ABCNST',0.0,0,'ABCNST',0.0,0)
      ENDIF           
      CALL PGLAB(PORT.XTIT,PORT.YTIT,PORT.HEAD)
      CALL PGSCH(1.0)

      RETURN
      END

C-------------------------------------------------
      SUBROUTINE INITGRF(IQ)
C  Initialization of the PGPlot graphics device.
C  IQ=0 ... output to the current device 
C  IQ=1 ... output to the PostScript file "out.ps"
C  IQ=2 ... prompts for another output device         
C-------------------------------------------------
      IMPLICIT NONE
      INCLUDE 'const.inc'
      INCLUDE 'inout.inc'
      CHARACTER*64 DST
      INTEGER PGBEGIN
      INTEGER*4 IQ,IDEVSTR  
         
C      IF(DST(1:5).NE.'/NULL') 
      DST=DEVSTR 
      IF(IQ.EQ.2) DST='?                   '
      IF(IQ.EQ.1) DST='"out.ps"/vps'
      IF(IQ.EQ.3) DST='/NULL'

201   IF (PGBEGIN(0,DST,1,1).NE.1) THEN
          write(6,*) 'graphics error (PGBEGIN)'
          DST='?                   '
          GOTO 201 
      END IF
      CALL PGPAGE(0.0,1.0)
      CALL PGSLW(2)
      IF(IQ.NE.1) CALL PGQINF('DEV/TYPE',DEVSTR,IDEVSTR)   
 
      RETURN
      END
      
C------------------------------------------------------------
      SUBROUTINE FILARRAY(PORT,IARR,AIMA,NIMX,NIMY,NM,TM)
C     Fills array AIMA by events stored in the array EVA
C     (handled by the subroutine EVARRAY).
C     If NM<>0, events are transformed by matrix TM. 
C     If NM<0,transposed matrix TM is used.
C     Range of the x,y coordinates is taken from the viewport 
C     parameters, stored in the record PORT.      
C------------------------------------------------------------
      IMPLICIT NONE
      INCLUDE 'sim_grf.inc'
      INTEGER*4 IARR,NIMX,NIMY,NM
      REAL*4 AIMA(NIMX,NIMY)
      REAL*8 IMX0,IMY0,DIMX,DIMY,EX,EY,Z,P
      REAL*8 TM(4,4),E(4),E1(4),F(4)
      RECORD /VIEWSET/ PORT
      INTEGER*4 I4,NCNT,ICNT,IX,IY,J,K,JX,JY      

1     format(a20,4(2x,E12.6))
                        
      DIMX=(PORT.WX2-PORT.WX1)/NIMX
      DIMY=(PORT.WY2-PORT.WY1)/NIMY
      IMX0=(PORT.WX2+PORT.WX1)/2
      IMY0=(PORT.WY2+PORT.WY1)/2
      
      IX=PORT.IX
      IY=PORT.IY
      DO 131 J=1,NIMX
      DO 131 K=1,NIMY
           AIMA(J,K)=0
131   CONTINUE

      CALL EVARRAY(3,IARR,NCNT,E,P)         ! get number of events NCNT
c      write(*,*) 'FILLARRAY : ',ncnt
      ICNT=0
      IF (NCNT.GT.0) THEN
      DO 132 I4=1,NCNT
         IF (NM.NE.0) THEN
            CALL EVARRAY(2,IARR,I4,E1,P) ! get event coor. E1(4) and P
            CALL MXV(NM,4,4,TM,E1,E)
         ELSE
            CALL EVARRAY(2,IARR,I4,E,P)
            IF(IARR.EQ.1)  CALL EVARRAY(2,0,I4,F,P) 
            Z=SQRT(F(1)**2+F(2)**2+F(3)**2)
         ENDIF 
         IF (IX.LE.4) THEN
            EX=E(IX)
         ELSE
            IF(IX.EQ.7) THEN
              EX=Z
            ELSE  
              EX=F(IX-4)/Z
            ENDIF  
         ENDIF              
         IF (IY.LE.4) THEN
            EY=E(IY)
         ELSE
            IF(IY.EQ.7) THEN
              EY=Z
            ELSE  
              EY=F(IY-4)/Z
            ENDIF  
         ENDIF
         IF(EX.GT.PORT.WX1.AND.EX.LT.PORT.WX2.AND.
     *      EY.GT.PORT.WY1.AND.EY.LT.PORT.WY2) THEN             
           JX=INT((EX-PORT.WX1)/DIMX)+1
           JY=INT((EY-PORT.WY1)/DIMY)+1
           AIMA(JX,JY)=AIMA(JX,JY)+P 
           ICNT=ICNT+1         
         ENDIF
c         write(*,*) I4,' ',Jx,' ',jy,' ',p
c         pause
         
132   CONTINUE 
      write(*,*) 'Integrated ',ICNT,' events'
      ENDIF

      RETURN
      END               

C------------------------------------------------------------
      SUBROUTINE FILLQHKL(PORT,AIMA,NIMX,NIMY)
C     Fills array AIMA by (Q,E) events 
C     (handled by the subroutine NSTORE_).
C     Range of the x,y coordinates is taken from the viewport 
C     parameters, stored in the record PORT.      
C------------------------------------------------------------
      IMPLICIT NONE
      INCLUDE 'sim_grf.inc'
      INTEGER*4 NIMX,NIMY
      REAL*4 AIMA(NIMX,NIMY)
      REAL*8 IMX0,IMY0,DIMX,DIMY
      REAL*8 E(4),E1(4),EX,EY,PP
      RECORD /VIEWSET/ PORT
      INTEGER*4 I4,NCNT,ICNT,I1,IALLOC,IX,IY,JX,JY,J,K
      REAL*8 MCR(4,4),MCG(4,4),MCD(4,4),MRC(4,4),MDR(4,4),MGD(4,4)     
      COMMON /TRANSM/ MCR,MCG,MCD,MRC,MDR,MGD

1     format(a20,4(2x,E12.6))
                        
      DIMX=(PORT.WX2-PORT.WX1)/NIMX
      DIMY=(PORT.WY2-PORT.WY1)/NIMY
      IMX0=(PORT.WX2+PORT.WX1)/2
      IMY0=(PORT.WY2+PORT.WY1)/2
      
      IX=PORT.IX
      IY=PORT.IY
      DO 131 J=1,NIMX
      DO 131 K=1,NIMY
           AIMA(J,K)=0
131   CONTINUE
      CALL NSTORE_N(I1,NCNT,IALLOC)
      ICNT=0
      IF (NCNT.GT.0) THEN
      DO 132 I4=1,NCNT
         CALL NSTORE_GETQE(I4,E1,PP,0.)
            CALL MXV(1,4,4,MRC,E1,E)
         EX=E(IX)
         EY=E(IY)
         IF(EX.GT.PORT.WX1.AND.EX.LT.PORT.WX2.AND.
     *      EY.GT.PORT.WY1.AND.EY.LT.PORT.WY2) THEN             
           JX=INT((EX-PORT.WX1)/DIMX)+1
           JY=INT((EY-PORT.WY1)/DIMY)+1
           AIMA(JX,JY)=AIMA(JX,JY)+PP 
c           write(*,*) JX,JY,PP, AIMA(JX,JY)
c           pause
           ICNT=ICNT+1    
          ENDIF
         
132   CONTINUE 
      write(*,*) 'Integrated ',ICNT,' events'
      ENDIF

      RETURN
      END               


C----------------------------------------------------------------------
      SUBROUTINE PLOTOUT(IC)
C     handles graphics output     
C----------------------------------------------------------------------
      IMPLICIT NONE
      INCLUDE 'const.inc'
      INCLUDE 'inout.inc'
      INTEGER*4 IC,ILAST,IDEV,ICOM
      CHARACTER*40 PRN_COMMAND
      SAVE ILAST                        
      CHARACTER*30 DST
      DATA ILAST/0/
      
      ICOM=0
      IDEV=0                                      ! output to DEVSTR
      IF((NOS.GE.2).AND.(RET(2).EQ.1.)) IDEV=1    ! print
      IF((NOS.GE.2).AND.(RET(2).EQ.0.)) IDEV=2    ! ask for new device
C      IF(IDEV.NE.1.AND.SOUT.NE.6) IDEV=3         ! NULL device
      
      
C///  Only Beam profile can be shown (X.99)
      ICOM=-2
      IF(NOS.GT.0.AND.RET(1).EQ.-3) ICOM=-3 ! Plot resolution function
      IF (IC.EQ.1) ICOM=-4
      IF (IC.EQ.2) ICOM=-5
      IF (IC.EQ.3) ICOM=-6
      IF (IC.EQ.4) ICOM=-7
      IF (IC.EQ.5) ICOM=-8
      IF (IDEV.EQ.1) ICOM=ILAST 

      
      DST=DEVSTR
      CALL INITGRF(IDEV)
c      write(*,*) ICOM,NOS,IC,IDEV,ILAST
      IF(ICOM.EQ.-2) THEN
          CALL DET_IMAGE
      ELSE IF(ICOM.EQ.-3) THEN
          CALL RES_IMAGE    
      ELSE IF(ICOM.EQ.-4) THEN
          CALL SVOL_IMAGE
      ELSE IF(ICOM.EQ.-5) THEN
          CALL LAMBDA_PROF
      ELSE IF(ICOM.EQ.-6) THEN
          CALL PEAK_PROF(0)
      ELSE IF(ICOM.EQ.-7) THEN
          CALL PEAK_PROF(1)
      ELSE IF(ICOM.EQ.-8) THEN
          CALL PEAK_PROF(2)
      ENDIF
      
      CALL PGEND           
      IF (IDEV.NE.1) ILAST=ICOM
               
      IF (IDEV.EQ.1) THEN
         CALL GETENV('PGPLOT_ILL_PRINT_CMD',PRN_COMMAND)
         CALL SYSTEM(PRN_COMMAND//'out.ps')
      ENDIF
      DEVSTR=DST

      RETURN
      END
                  
C************************************************************************
      SUBROUTINE PRINTOUT
C     Prints results
C************************************************************************      
      IMPLICIT NONE
      include 'const.inc'
      include 'inout.inc'
      
      NOS=2
      RET(2)=1.
      CALL PLOTOUT(0)
      
      END
      

C----------------------------------------      
      SUBROUTINE DET_IMAGE
C----------------------------------------            
      IMPLICIT NONE
      INCLUDE 'const.inc'
      INCLUDE 'inout.inc'
      INCLUDE 'sim_grf.inc'
      INCLUDE 'structures.inc'
      INCLUDE 'ness_common.inc'
 
      REAL*4 AIMA(MIMAX,MIMAX)
      RECORD /VIEWSET/ VPORT
      character*50 name(7)
      character*1 cnum
      character*50 comment
      integer*4 indx,IX,IY,i_IO,imin,imax,jmin,jmax,i,j
      real*8 xmin,xmax,ymin,ymax,sum1,z
      
      DATA indx /0/      
      DATA name/'X [mm]','Y [mm]','E [meV]','time [ms]','k(x)/k ',
     1   'k(y)/k ','k [A-1]'/
     
1     FORMAT(' (1) X '/' (2) Y'/' (3) E'/' (4) time'/' (5-7) k(x,y,z)')      
2     FORMAT(' type of the axes X,Y: ',$)
3     FORMAT(' range ',A20,' +- ',$)
4     FORMAT(1x,4(2x,E13.5))
5     FORMAT(1x,4(2x,a10,3x),' integral=',e12.6)
6     FORMAT(1x,3(2x,a10,3x),' integral=',e12.6)
7     format(2x,F10.3) 
8     format(I1) 
9     FORMAT(64(1x,G10.4))
10    format('Beam Profile ')
11    FORMAT(' comment: ',$)
12    format(a50)
13    format('scale (',G12.5,',',G12.5,',',G12.5,',',G12.5,')')
      name(3)='E '//CUNIT     
      write(SOUT,1)
      write(SOUT,2)
      read(SINP,*) IX,IY
      IF(SOUT.NE.6) WRITE(SOUT,*) IX,IY
      write(SOUT,3) name(IX)(1:20)
      read(SINP,*) xmax
      IF(SOUT.NE.6) WRITE(SOUT,7) xmax
      write(SOUT,3) name(IY)(1:20)
      read(SINP,*) ymax     
      IF(SOUT.NE.6) WRITE(SOUT,7) ymax
      write(*,*)

      WRITE(SOUT,11)
      read(SINP,12) comment
      
      xmin=-xmax
      ymin=-ymax
      
      VPORT.WX1=xmin
      VPORT.WX2=xmax
      VPORT.WY1=ymin
      VPORT.WY2=ymax
      
      IF(IX.EQ.7) THEN
        VPORT.WX1=VPORT.WX1+STP.KI
        VPORT.WX2=VPORT.WX2+STP.KI
      ELSE IF(IY.EQ.7) THEN
        VPORT.WY1=VPORT.WY1+STP.KI
        VPORT.WY2=VPORT.WY2+STP.KI
      ENDIF
      VPORT.DX1=0.15   
      VPORT.DX2=0.93
      VPORT.DY1=0.31
      VPORT.DY2=0.89
      VPORT.IX=IX
      VPORT.IY=IY
      
      VPORT.XTIT=name(IX)
      VPORT.YTIT=name(IY)
      WRITE(VPORT.HEAD,9)
      CALL PGSLW(3)
      CALL PLOTFRAME(VPORT,1,1,1.5,1)
      call FILARRAY(VPORT,1,AIMA,MIMAX,MIMAX,0)
      CALL PLOT2D(VPORT,AIMA,MIMAX,MIMAX,MIMAX,MIMAX)     
      CALL PLOTFRAME(VPORT,1,1,1.5,1)
      CALL PGSLW(2)
      CALL PGSCH(1.3)      
      CALL PGSCI(1) 
      CALL PGMTEXT('B',10.,-0.05,0.0,comment)
      CALL PGIDEN
      
      
      I_IO=2
      sum1=0.
      imin=MIMAX
      imax=1
      jmin=MIMAX
      jmax=1
      do i=1,MIMAX
      do j=1,MIMAX
         sum1=sum1+aima(i,j)
         if(aima(i,j).ne.0) then
            imin=min(imin,i)
            imax=max(imax,i)
            jmin=min(jmin,j)
            jmax=max(jmax,j)
          endif  
      enddo
      enddo
      if (sum1.eq.0) sum1=1 
      imax=min(imax+1,MIMAX)
      jmax=min(jmax+1,MIMAX) 
      imin=max(imin-1,1) 
      jmin=max(jmin-1,1)
      
      if(indx.lt.9) then
         indx=indx+1
      else
         indx=1
      endif      
      write(cnum,8) indx

      I_IO=2

      close(i_io)
       Open(Unit=i_IO,File='ness_2d.mat',err=999,Status='Unknown')
      write(i_io,*) 'projection ('//name(ix)(1:10)//','//name(iy)(1:10)
      write(i_io,13) xmin,xmax,ymin,ymax
      do i=1,MIMAX
        write(i_IO,9) (AIMA(i,j)*sum/sum1,j=1,MIMAX)
      enddo
      close(i_io)
       
      Open(Unit=i_IO,File='ness_2d_'//cnum//'.dat',err=999,
     1     Status='Unknown')
      write(i_io,5) name(ix)(1:10),name(iy)(1:10),'Events    ',
     1              'Intensity',sum
      do i=imin,imax
      do j=jmin,jmax
        write(i_IO,4) (i-0.5-MIMAX/2)*(xmax-xmin)/MIMAX,
     1                (j-0.5-MIMAX/2)*(ymax-ymin)/MIMAX,
     2                AIMA(i,j),AIMA(i,j)*sum/sum1
      enddo
      enddo
      close(i_io)

      
      Open(Unit=i_IO,File='ness_x_'//cnum//'.dat',err=999,
     1     Status='Unknown')

      write(i_io,6) name(ix)(1:10),'Events    ','Intensity ',sum
      do i=1,MIMAX
        z=0.
        do j=1,MIMAX
          z=z+AIMA(i,j)
        end do  
        write(i_IO,4) (i-0.5-MIMAX/2)*(xmax-xmin)/MIMAX,z,z*sum/sum1
      enddo
      close(i_io)      

      Open(Unit=i_IO,File='ness_y_'//cnum//'.dat',err=999,
     1     Status='Unknown')
      write(i_io,6) name(iy)(1:10),'Events    ','Intensity ',sum
      do i=1,MIMAX
        z=0.
        do j=1,MIMAX
          z=z+AIMA(j,i)
        end do  
        write(i_IO,4) (i-0.5-MIMAX/2)*(ymax-ymin)/MIMAX,z,z*sum/sum1
      enddo
      close(i_io)      
      
      return
      
999   write(*,*) 'Cannot open file as unit ',i_IO      
      return
      end

CXXXXXXXXXCXXXXXXXXXCXXXXXXXXXCXXXXXXXXXCXXXXXXXXXCXXXXXXXXXCXXXXXXXXXCX
C----------------------------------------      
      SUBROUTINE SVOL_IMAGE
C----------------------------------------            
      implicit none

      INCLUDE 'const.inc'
      INCLUDE 'inout.inc'
      INCLUDE 'sim_grf.inc'
      INCLUDE 'structures.inc'
      INCLUDE 'ness_common.inc'

      INTEGER*4 IMIN,IMAX,I,J,INDX,i_io,jmin,jmax
      REAL*4 xmax,xmin,ymax,ymin,sum1
      RECORD /VIEWSET/ VPORT
      character*1 cnum
      character*50 comment
      character*50 filename
      REAL*8 AREA,AREA1,MEAN(2),MAT(2,2),COV(2,2),ZMAX,XX,YY
      SAVE indx
      DATA indx /0/      
     
4     FORMAT(1x,4(2x,E13.5))
8     format(I1) 
9     format('Sample gauge area')
11    FORMAT(' comment: ',$)
12    format(a50)
13    format('Gauge area [mm^2]: ',F10.4,' spread: ',F10.4)
14    FORMAT(' data output: ',$)


      WRITE(SOUT,11)
      read(SINP,12) comment
      WRITE(SOUT,*)
      
      xmax=SAM.SIZE(1)/2.0
      ymax=SAM.SIZE(3)/2.0
      xmin=-xmax
      ymin=-ymax
      
      VPORT.WX1=xmin
      VPORT.WX2=xmax
      VPORT.WY1=ymin
      VPORT.WY2=ymax
      
      VPORT.DX1=0.15   
      VPORT.DX2=0.93
      VPORT.DY1=0.31
      VPORT.DY2=0.89
      VPORT.IX=1
      VPORT.IY=2
      
      VPORT.XTIT='X [mm]'
      VPORT.YTIT='Y [mm]'
      WRITE(VPORT.HEAD,9)
      CALL PGSLW(3)
      CALL PLOTFRAME(VPORT,1,1,1.5,1)
      CALL PLOT2D(VPORT,SVOL,MIMAX,MIMAX,MIMAX,MIMAX)     
      CALL PLOTFRAME(VPORT,1,1,1.5,1)
      CALL PGSLW(2)
      CALL PGSCH(1.3)      
      CALL PGSCI(1) 
      CALL PGMTEXT('B',10.,-0.05,0.0,comment)
      CALL PGIDEN
      
      
      I_IO=2
      sum1=0.
      imin=MIMAX
      imax=1
      jmin=MIMAX
      jmax=1
      ZMAX=0.
      do i=1,MIMAX
      do j=1,MIMAX
         sum1=sum1+SVOL(i,j)
         if(SVOL(i,j).ne.0) then
            imin=min(imin,i)
            imax=max(imax,i)
            jmin=min(jmin,j)
            jmax=max(jmax,j)
            IF(ZMAX.LT.SVOL(i,j)) ZMAX=SVOL(i,j)
        endif  
      enddo
      enddo
      AREA=0.
      do i=1,2
        mean(i)=0.
        do j=1,2
          mat(i,j)=0.
        enddo
      enddo
      do i=1,MIMAX
      do j=1,MIMAX
         AREA=AREA+SVOL(i,j)/ZMAX
         xx=(i-32-0.5)*(xmax-xmin)/MIMAX
         yy=(j-32-0.5)*(ymax-ymin)/MIMAX
         MAT(1,1)=MAT(1,1)+SVOL(i,j)*XX**2
         MAT(1,2)=MAT(1,2)+SVOL(i,j)*XX*YY
         MAT(2,1)=MAT(1,2)
         MAT(2,2)=MAT(2,2)+SVOL(i,j)*YY**2
         MEAN(1)=MEAN(1)+SVOL(i,j)*XX
         MEAN(2)=MEAN(2)+SVOL(i,j)*YY
      enddo
      enddo
      do i=1,2
        mean(i)=mean(i)/sum1
      enddo
      do i=1,2
        do j=1,2
          cov(i,j)=mat(i,j)/sum1-mean(i)*mean(j)
        enddo
      enddo
      AREA=AREA*(xmax-xmin)/MIMAX*(ymax-ymin)/MIMAX
      AREA1=2*PI*SQRT(cov(1,1)*cov(2,2)-cov(1,2)*cov(2,1))      
      write(SOUT,13) AREA,AREA1                 
      
      if (sum1.eq.0) sum1=1 
      imax=min(imax+1,MIMAX)
      jmax=min(jmax+1,MIMAX) 
      imin=max(imin-1,1) 
      jmin=max(jmin-1,1)
      
      if(indx.lt.9) then
         indx=indx+1
      else
         indx=1
      endif      
      write(cnum,8) indx

      WRITE(SOUT,14)
      read(SINP,12) filename

      IF(filename(1:1).EQ.' '.OR.filename(1:1).EQ.CHAR(0)) return ! dont save
      
      Open(Unit=i_IO,File=filename,err=999,Status='Unknown')
      write(i_io,*) 'X [mm]      Y [mm]       Intensity ',comment
      do i=imin,imax
        do j=jmin,jmax
           write(i_IO,4) (i-0.5-MIMAX/2)*(xmax-xmin)/MIMAX,
     1                (j-0.5-MIMAX/2)*(ymax-ymin)/MIMAX,
     2                SVOL(i,j)*MIMAX*MIMAX/sum1
        enddo
      enddo
      close(i_io)
      return
      
999   write(*,*) 'Cannot open file as unit ',i_IO      
      return
      end
      
C----------------------------------------      
      SUBROUTINE LAMBDA_PROF
C----------------------------------------            
      implicit none

      INCLUDE 'const.inc'
      INCLUDE 'inout.inc'
      INCLUDE 'sim_grf.inc'
      INCLUDE 'structures.inc'
      INCLUDE 'ness_common.inc'

      INTEGER*4 I,J,INDX,i_io,NCNT
      REAL*4 xmax,xmin,ymax,ymin,lam,Y0(64),Y1(64),Y2(64)
      RECORD /VIEWSET/ VPORT
      character*50 comment
      character*50 filename
      REAL*4 FX(64),FY(64),DFY(64),FY1(64),FY2(64)
      REAL*8 XYET(4),KS(4),P,dx,SUM0,sum1
      SAVE indx
      DATA indx /0/      
     
4     FORMAT(1x,4(2x,E13.5))
8     format(I1) 
9     format('Wavelength distribution')
11    FORMAT(' comment: ',$)
12    format(a50)
13    FORMAT(' data output: ',$)


      CALL EVARRAY(3,0,NCNT,XYET,P)         ! get number of events NCNT
      
      IF (NCNT.GT.0) THEN
      comment=' '
      WRITE(SOUT,11)
      read(SINP,12) comment
      
      xmax=SAM.SIZE(1)/2.0
      xmin=-xmax
      dx=(xmax-xmin)/64
      DO I=1,64
         FX(I)=xmin+(I-1+0.5)*dx
      ENDDO
      DO J=1,64
            Y0(J)=0.
            Y1(J)=0.
            Y2(J)=0.
      ENDDO  
      SUM0=0.
      sum1=0.        
      ymin=1.E+30
      ymax=-1.E+30
      DO  I=1,NCNT
          CALL EVARRAY(2,1,I,XYET,P) 
          CALL EVARRAY(2,0,I,KS,P)
          lam=2*PI*(1./SQRT(KS(1)**2+KS(2)**2+KS(3)**2)-
     *              1./STP.KI)
          IF(ymax.LE.lam) ymax=lam
          IF(ymin.GE.lam) ymin=lam
          J=INT((XYET(1)-xmin)/dx)+1
          IF (J.GE.1.AND.J.LE.64) THEN
            Y0(J)=Y0(J)+P
            Y1(J)=Y1(J)+P*lam
            sum1=sum1+P*lam
            SUM0=SUM0+P
            Y2(J)=Y2(J)+P*lam**2
          ENDIF
      ENDDO
      ymin=ymin-sum1/SUM0
      ymax=ymax-sum1/SUM0
      DO I=1,64
        IF (Y0(I).GT.0) THEN           
            FY(I)=Y1(I)/Y0(I)
            DFY(I)=Y2(I)/Y0(I)-FY(I)**2
            IF(DFY(I).LE.1E-8) THEN
               DFY(I)=0.
            ELSE
               DFY(I)=SQRT(DFY(I))
            ENDIF
            FY1(I)=FY(I)-DFY(I)
            FY2(I)=FY(I)+DFY(I)
        ELSE
             FY(I)=0.            
            DFY(I)=0.
            FY1(I)=0.
            FY2(I)=0.
        ENDIF           
      ENDDO          
      
      
      VPORT.WX1=xmin
      VPORT.WX2=xmax
      VPORT.WY1=ymin
      VPORT.WY2=ymax
      
      VPORT.DX1=0.15   
      VPORT.DX2=0.93
      VPORT.DY1=0.40
      VPORT.DY2=0.89
      VPORT.IX=1
      VPORT.IY=2
      
      VPORT.XTIT='X [mm]'
      VPORT.YTIT='\gD\gl [A]'
      WRITE(VPORT.HEAD,9)
      CALL PGSLW(3)
      CALL PLOTFRAME(VPORT,1,1,1.5,1)
      CALL PGSCI(4)
      CALL PGSLS(1)
      CALL PGSLW(2)
      CALL PGERRY(64,FX,FY1,FY2,0.0)
      CALL PGLINE(64,FX,FY)
      CALL PGPOINT(64,FX,FY,17)
      CALL PGSLW(2)
      CALL PGSCH(1.3)      
      CALL PGSCI(1) 
      CALL PGMTEXT('B',10.,-0.05,0.0,comment)
      CALL PGIDEN
      
      
      I_IO=2
      WRITE(SOUT,13)
      read(SINP,12) filename

      IF(filename(1:1).EQ.' '.OR.filename(1:1).EQ.CHAR(0)) return ! dont save
      
      Open(Unit=i_IO,File=filename,err=999,Status='Unknown')
      write(i_io,*) comment
      write(i_io,*) 'X [mm]      Lam [A]    dLam [A]   '
      do i=1,64
          write(i_IO,4) FX(I),FY(I),DFY(I) 
      enddo  
      close(i_io)

      ENDIF      

      return
      
999   write(*,*) 'Cannot open file as unit ',i_IO      
      return
      end

C-----------------------------------------------      
      SUBROUTINE PEAK_PROF(IVAR)
C IVAR=0 ... Spatial profile at the PSD      
C IVAR=1 ... Powder peak profile (on angular scale)   
C IVAR=2 ... peak profile accumulated in SPCX,Y,D arrays   
C------------------------------------------------------            
      implicit none

      INCLUDE 'const.inc'
      INCLUDE 'inout.inc'
      INCLUDE 'sim_grf.inc'
      INCLUDE 'structures.inc'
      INCLUDE 'ness_common.inc'
      
      INTEGER*4 MF
      PARAMETER (MF=65)

      INTEGER*4 I,INDX,i_io,IVAR,NF
      REAL*4 ymax
      RECORD /VIEWSET/ VPORT
      character*55 comment
      character*50 filename
      REAL*4 FX(MF),FY(MF),DFY(MF),FY1(MF),FY2(MF)
      REAL*8 suma,center,fwhm,wspread
      REAL*4 PAR(3),DPAR(3),CHI2SPC,TOL
      EXTERNAL CHI2SPC
      SAVE indx
      DATA indx /0/      
     
4     FORMAT(1x,4(2x,E13.5))
5     FORMAT('Integral: ',E13.5,' ',a50)
8     format(I1) 
9     format('Profile at the PSD')
10    format('Powder peak profile')
11    FORMAT(' comment: ',$)
12    format(a50)
13    FORMAT(' data output: ',$)
14    FORMAT('fwhm: ',G10.4,'spread: ',G10.4,'center: ',G10.4)

      comment=' ' 
      NF=MF
      if (IVAR.NE.2) THEN
        WRITE(SOUT,11)
        read(SINP,12) comment
      ENDIF
      IF (IVAR.EQ.0) THEN
        CALL PSD_ARRAY(FX,FY,DFY,NF)
      ELSE IF (IVAR.EQ.1) THEN  
        CALL THETA_SCAN(FX,FY,DFY,NF)
      ELSE IF (IVAR.EQ.2) THEN 
        NF=SPCN 
        DO I=1,SPCN
          FX(I)=SPCX(I)
          FY(I)=SPCY(I)
          DFY(I)=SPCD(I)         
        ENDDO
c        write(*,*) 'PEAK_PROF: ',SPCN,SPCY(SPCN/2)
        CALL GETPEAKPARAM(3,suma,center,fwhm,wspread)
        WRITE(comment,14) fwhm,wspread,center
      ENDIF
      ymax=0.
      DO I=1,NF
        FY1(I)=FY(I)-DFY(I)
        FY2(I)=FY(I)+DFY(I)
        IF(ymax.LE.FY(I)) ymax=FY(I)
      ENDDO          
      
      VPORT.WX1=FX(1)
      VPORT.WX2=FX(NF)
      VPORT.WY1=0.
      VPORT.WY2=ymax*1.1
      
      VPORT.DX1=0.15   
      VPORT.DX2=0.93
      VPORT.DY1=0.40
      VPORT.DY2=0.89
      VPORT.IX=1
      VPORT.IY=2
      
      IF (IVAR.EQ.0) THEN
        VPORT.XTIT='X [mm]'
        VPORT.YTIT='Intensity'
        WRITE(VPORT.HEAD,9)
      ELSE IF (IVAR.EQ.1) THEN  
        VPORT.XTIT='\gD\gf [min]'
        VPORT.YTIT='Intensity'
        WRITE(VPORT.HEAD,10)
      ELSE   
        VPORT.XTIT='X'
        VPORT.YTIT='Y'
        VPORT.HEAD='Peak profile'      
      ENDIF
      CALL PGSLW(3)
      CALL PLOTFRAME(VPORT,1,1,1.5,0)
      CALL PGSCI(3)
      CALL PGSLS(1)
      CALL PGSLW(2)
      CALL PGERRY(NF,FX,FY1,FY2,0.0)
      CALL PGLINE(NF,FX,FY)
      CALL PGPOINT(NF,FX,FY,17)
      IF (IVAR.EQ.2.AND.FWHM.GT.0) THEN
         PAR(1)=ymax
         PAR(2)=center
         PAR(3)=wspread
c         write(*,*) PAR(1),PAR(2),PAR(3)
         DO I=1,3
          DPAR(I)=0.
         ENDDO
         TOL=0.01
         CALL LMOPT(CHI2SPC,PAR,3,TOL,DPAR,2)
c         write(*,*) PAR(1),PAR(2),PAR(3)
         IF(ABS(PAR(3)).GT.1E-10) THEN
           DO I=1,NF
             FY1(I)=PAR(1)*EXP(-0.5*(FX(I)-PAR(2))**2/
     *       (PAR(3)/R8LN2)**2)
           ENDDO         
           CALL PGSCI(2)
           CALL PGLINE(NF,FX,FY1)
         ENDIF
      ENDIF
      CALL PGSLW(2)
      CALL PGSCH(1.3)      
      CALL PGSCI(1) 
      CALL PGMTEXT('B',10.,-0.05,0.0,comment)
      CALL PGIDEN
            
      I_IO=22
      filename=' '
      WRITE(SOUT,13)
      read(SINP,12) filename

      IF(filename(1:1).EQ.' '.OR.filename(1:1).EQ.CHAR(0)) then  ! generate automatic filename
        RETURN
      ELSE
        Open(Unit=i_IO,File=filename,err=999,Status='Unknown')
        write(i_io,5) IPWD,comment
        IF (IVAR.EQ.0) THEN
          write(i_io,*) 'X [mm]      I       dI    '
        ELSE IF (IVAR.EQ.1) THEN  
          write(i_io,*) 'd2Theta      I       dI    '
        ENDIF
        do i=1,NF
          write(i_IO,4) FX(I),FY(I),DFY(I) 
        enddo  
        close(i_io)
      ENDIF

      return
      
999   write(*,*) 'Cannot open file as unit ',i_IO      
      return
      end


C----------------------------------------      
      SUBROUTINE RES_IMAGE
C----------------------------------------            
      IMPLICIT NONE
      include 'const.inc'
      include 'inout.inc'
      INCLUDE 'sim_grf.inc'
      INCLUDE 'rescal.inc'
      
      REAL AIMA(MIMAX,MIMAX)
      RECORD /VIEWSET/ VPORT
      character*32 name(4),name1(4)
      character*50 leg1,leg2,comment
      integer*4 indx,i_IO,IX,IY,I,J
      REAL*4 xmax,xmin,ymax,ymin,sum,zmax
c      COMMON DUM1(30),Q(3),EN,D(3),DE,G(3),GMOD,DUM2(6)


      SAVE indx
      DATA indx /0/      
c      DATA name/'\gDQx [1/A]','\gDQy [1/A]','\gDQz [1/A]','\gDE [meV]'/
c      DATA name1/'Qx [1/A]','Qy [1/A]','Qz [1/A]','dE [meV]'/
c      DATA name/'\gDh ','\gDk ','\gDl ','\gDE [meV]'/
      DATA name/'(\gc 0 0)','(0 \gc 0)','(0 0 \gc)','\gDE [meV]'/
      DATA name1/'h ','k ','k ','dE [meV]'/

3     FORMAT(' range ',A20,' +- ',$)
4     FORMAT(1x,4(2x,E13.5))
5     FORMAT(1x,4(2x,a10,3x))
6     FORMAT(1x,3(2x,a15,3x))
7     format(2x,F10.3) 
8     format(I1)      
9     FORMAT(64(1x,G10.4))


c1     FORMAT(' (1) Qx '/' (2) Qy'/' (3) Qz'/' (4) E')      
1     FORMAT(' (1) h '/' (2) k'/' (3) l'/' (4) E')      
2     FORMAT(' which projection (X,Y): ',$)
11    FORMAT(' comment: ',$)
12    format(a50)
13    format('scale (',G12.5,',',G12.5,',',G12.5,',',G12.5,')')

            
80    write(SOUT,1)
      write(SOUT,2)
      read(SINP,*,err=80) IX,IY
      if (IX.LT.0.OR.IX.GT.4.OR.IY.LT.0.OR.IY.GT.4) then
        goto 80
      endif
      write(SOUT,3) name1(IX)(1:20)
      read(SINP,*) xmax
      IF(SOUT.NE.6) WRITE(SOUT,7) xmax
      write(SOUT,3) name1(IY)(1:20)
      read(SINP,*) ymax     
      IF(SOUT.NE.6) WRITE(SOUT,7) ymax
      comment=' '
      WRITE(SOUT,11)
      read(SINP,12) comment
      write(*,*)


101   format('\gD\gc [',F6.2,' ',F6.2,' ',F6.2,'] / r.l.u.')
102   format('Q\dhkl\u = [',F7.3,' ',F7.3,' ',F7.3,']') 
103   format('E = ',F7.2,' ',a3) 
104   format('QE = [',4(G12.5,1x),']') 
      WRITE(LEG1,102) QHKL
      WRITE(LEG2,103) RES_DAT(i_EN),CUNIT
      
c      CALL QNORM(G,GNR,GNA)
c      ZRA=GNR/GNA
c      DO 10 i=1,4
c      DO 10 j=1,4
c         MCN(i,j)=MCG(i,j)
c         if(j.eq.1) MCN(i,j)=MCN(i,j)*ZRA
c10    CONTINUE     
c      CALL FILARRAY(VPORT,0,AIMA,MIMAX,MIMAX,-1,MCN)

c      WRITE(VPORT.XTIT,101) G
      VPORT.HEAD='Projection of R(Q,E) [r.l.u]'
      xmin=-xmax
      ymin=-ymax
      
      VPORT.WX1=xmin
      VPORT.WX2=xmax
      VPORT.WY1=ymin
      VPORT.WY2=ymax
      
      VPORT.DX1=0.15   
      VPORT.DX2=0.93
      VPORT.DY1=0.31
      VPORT.DY2=0.89
      VPORT.IX=IX
      VPORT.IY=IY
      
      VPORT.XTIT=name(IX)
      VPORT.YTIT=name(IY)
      CALL PGSLW(2)
      CALL PGSCH(1.5)      
      CALL PLOTFRAME(VPORT,1,1,1.5,0)
      CALL FILLQHKL(VPORT,AIMA,MIMAX,MIMAX)
      sum=0.
      zmax=0
      do i=1,MIMAX
      do j=1,MIMAX
         sum=sum+aima(i,j)  
c         write(*,*) i,j,aima(i,j),sum
c         pause       
         if(aima(i,j).gt.zmax) zmax=aima(i,j)
      enddo
      enddo
c      write(*,*) 'Plot resol: ',sum,zmax
      if (sum.le.0) then
        return
      endif
      do i=1,MIMAX
      do j=1,MIMAX
         aima(i,j)=aima(i,j)/sum*MIMAX**2         
      enddo
      enddo
      CALL PLOT2D(VPORT,AIMA,MIMAX,MIMAX,MIMAX,MIMAX)     
      CALL PLOTFRAME(VPORT,1,1,1.5,0)
      CALL PGMTEXT('T',-1.5,0.025,0.0,LEG1(1:36)//' ; '//LEG2)
      CALL PGSLW(2)
      CALL PGSCH(1.3)      
      CALL PGSCI(1) 
      CALL PGMTEXT('B',10.,-0.05,0.0,comment)
      CALL PGIDEN
      
       
      I_IO=2
      close(i_io)
       Open(Unit=i_IO,File='ness_2d.mat',err=999,Status='Unknown')
      write(i_io,*)'projection ('//name1(ix)(1:10)//','//name1(iy)(1:10)
      write(i_io,13) xmin,xmax,ymin,ymax
      WRITE(i_IO,104) (RES_DAT(i_QH+i-1),i=1,4)
      do j=1,MIMAX
        write(i_IO,9) (AIMA(i,j),i=1,MIMAX)
      enddo
      close(i_io)
           
      return
      
999   write(*,*) 'Cannot open file as unit ',i_IO      
      return
      end

      
