C//////////////////////////////////////////////////////////////////////
C////
C////  R E S T R A X   4.1
C////
C////  Subroutines for simple matrix operations:
C////  
C////  
C//////////////////////////////////////////////////////////////////////


c------------------------------------------
      SUBROUTINE INVERT(N,A,NA,B,NB)
C     Inverts matrix A (A is not destroyed)
C------------------------------------------
      IMPLICIT NONE
      INTEGER*4 N,NA,NB,NMAX
      PARAMETER(NMAX=16)
      REAL*8 A(NA,NA),B(NB,NB),A1(NMAX,NMAX),WK(2*NMAX)
      INTEGER*4 I,J,IERR
1     FORMAT (16(1x,G10.4))      
      DO 5 I=1,N
      DO 5 J=1,N
5        A1(I,J)=A(I,J)                
      CALL KVERTD(A1,NMAX,N,WK,IERR)
      IF (IERR.NE.0) THEN
         DO I=1,N
           WRITE(*,1) (A(I,J),J=1,N)
         ENDDO
         STOP      
      ENDIF
      DO 10 I=1,N
      DO 10 J=1,N
10       B(I,J)=A1(I,J)      
      RETURN
      END
C


C--------------------------------------------------------------------    
      SUBROUTINE STAT_INP(ND,CV,X,P)
C     accumulates covariantes matrix of vector X wit probability P      
C--------------------------------------------------------------------      
      IMPLICIT NONE
      INTEGER*4 ND,N
      PARAMETER(N=16)
      REAL*8 P,X(N)
      STRUCTURE /STATI/
         REAL*8 SUM2(N,N),SUM1(N),SUMN,C(N,N),M(N),P
         INTEGER*4 NC
      END STRUCTURE   
      RECORD /STATI/ CV
      INTEGER*4 I,J
      
      CV.SUMN=CV.SUMN+P
      CV.NC=CV.NC+1
      DO 10 I=1,ND
         CV.SUM1(I)=CV.SUM1(I)+X(I)*P
         DO 10 J=1,ND
         CV.SUM2(I,J)=CV.SUM2(I,J)+X(I)*X(J)*P
10    CONTINUE
      RETURN
      END
      
C--------------------------------------    
      SUBROUTINE STAT_CLR(ND,CV)
C     cleares covariance matrix
C--------------------------------------
      IMPLICIT NONE
      INTEGER*4 ND,N
      PARAMETER(N=16)
      STRUCTURE /STATI/
         REAL*8 SUM2(N,N),SUM1(N),SUMN,C(N,N),M(N),P
         INTEGER*4 NC
      END STRUCTURE   
      RECORD /STATI/ CV
      INTEGER*4 I,J
            
c      write(*,*) 'STAT_CLEAR',ND,CV.NC
      CV.SUMN=0
      CV.NC=0
      DO 10 I=1,ND
         CV.SUM1(I)=0
         DO 10 J=1,ND
         CV.SUM2(I,J)=0
10    CONTINUE
      RETURN
      END         
         
      
C--------------------------------------    
      SUBROUTINE STAT_GET(ND,CV)
C     calculates covariance matrix      
C--------------------------------------      
      IMPLICIT NONE
      INTEGER*4 ND,N
      PARAMETER(N=16)
      STRUCTURE /STATI/
         REAL*8 SUM2(N,N),SUM1(N),SUMN,C(N,N),M(N),P
         INTEGER*4 NC
      END STRUCTURE   
      RECORD /STATI/ CV
      INTEGER*4 I,J
      
      IF((CV.NC.GT.0).AND.(CV.SUMN.GT.0)) THEN     
      CV.P=CV.SUMN/CV.NC
      DO 10 I=1,ND
         CV.M(I)=CV.SUM1(I)/CV.SUMN
         DO 10 J=1,ND
         CV.C(I,J)=CV.SUM2(I,J)/CV.SUMN
10    CONTINUE
      DO 20 I=1,ND
         DO 20 J=1,ND
         CV.C(I,J)=CV.C(I,J)-CV.M(I)*CV.M(J)
20    CONTINUE      
      ENDIF
      RETURN
      END 

C
C     ------------------------------
      SUBROUTINE M3XV3(IT,MAP,M,B,C)
C     ------------------------------
      IMPLICIT NONE
      INTEGER*4 IT,I,J
      LOGICAL MAP(3)
      REAL*8 M(3,3),B(3),C(3)
      DO 10 J=1,3
      IF (MAP(J)) THEN
         C(J)=0.
         IF (IT.GT.0) THEN
           DO 20 I=1,3
20         C(J)=C(J)+M(J,I)*B(I)
         ELSE
           DO 30 I=1,3
30         C(J)=C(J)+M(I,J)*B(I)
         ENDIF
      ELSE
         C(J)=B(J)
      ENDIF
10    CONTINUE      
      RETURN
      END            

C     ------------------------------
      SUBROUTINE MXV(IT,N,NP,A,B,C)
C     ------------------------------
      IMPLICIT NONE
      INTEGER*4 IT,N,NP,I,J
      REAL*8 A(NP,NP),B(NP),C(NP)
      DO 10 J=1,N
         C(J)=0.
         IF (IT.GT.0) THEN
           DO 20 I=1,N
20         C(J)=C(J)+A(J,I)*B(I)
         ELSE
           DO 30 I=1,N
30         C(J)=C(J)+A(I,J)*B(I)
         ENDIF
10    CONTINUE      
      RETURN
      END 
      
C     ------------------------------
      SUBROUTINE MXM(IT,N,NP,A,B,C)
C     ------------------------------
      IMPLICIT NONE
      INTEGER*4 IT,I,J,K,N,NP
      REAL*8 A(NP,NP),B(NP,NP),C(NP,NP)
      DO 10 J=1,N
      DO 10 K=1,N     
         C(J,K)=0.
         IF (IT.GT.0) THEN
           DO 20 I=1,N
20         C(J,K)=C(J,K)+A(J,I)*B(I,K)
         ELSE
           DO 30 I=1,N
30         C(J,K)=C(J,K)+A(I,J)*B(I,K)
         ENDIF
10    CONTINUE         
      RETURN
      END       

          
C     ------------------------------
      SUBROUTINE M3XM3(IT,A,B,C)
C     ------------------------------
      IMPLICIT NONE
      INTEGER*4 IT,I,J,K      
      REAL*8 A(3,3),B(3,3),C(3,3)
      DO 10 J=1,3
      DO 10 K=1,3     
         C(J,K)=0.
         IF (IT.GT.0) THEN
           DO 20 I=1,3
20         C(J,K)=C(J,K)+A(J,I)*B(I,K)
         ELSE
           DO 30 I=1,3
30         C(J,K)=C(J,K)+A(I,J)*B(I,K)
         ENDIF
10    CONTINUE         
      RETURN
      END       
        
C     ------------------------------
      SUBROUTINE V3AV3(IT,A,B,C)
C     ------------------------------
      IMPLICIT NONE
      INTEGER*4 IT,I     
      REAL*8 A(3),B(3),C(3)
 
      DO 10 I=1,3
10      C(I)=A(I)+IT*B(I)
      RETURN
      END 
      
C     ------------------------------
      REAL*8 FUNCTION ABSV3(A)
C     ------------------------------
      IMPLICIT NONE
      REAL*8 A(3),V3XV3
      ABSV3=SQRT(V3XV3(A,A))
      RETURN
      END       
      

         
C     ------------------------------
      REAL*8 FUNCTION V3XV3(A,B)
C     ------------------------------
      IMPLICIT NONE
      INTEGER*4 I
      REAL*8 A(3),B(3),Z
      Z=0
      DO 10 I=1,3
10      Z=Z+A(I)*B(I)
      V3XV3=Z
      RETURN
      END  
 
C     ------------------------------
      SUBROUTINE GENROT(IAX,PHI,AUX)
C     ------------------------------
      IMPLICIT NONE
      INTEGER*4 I,J,IAX
      REAL*8 PHI,CO,SI,AUX(3,3)
            
      SI=SIN(PHI)
      CO=SQRT(1-SI**2)               
      DO 20 I=1,3
      DO 20 J=1,3
      IF(I.EQ.J) THEN
         IF (I.EQ.IAX) THEN 
            AUX(I,J)=1.
         ELSE
            AUX(I,J)=CO
         ENDIF       
      ELSE
         IF((I.EQ.IAX).OR.(J.EQ.IAX)) THEN
           AUX(I,J)=0.
         ELSE IF (I.GT.J) THEN
           AUX(I,J)=SI
         ELSE
           AUX(I,J)=-SI
         ENDIF    
      ENDIF
20    CONTINUE
      RETURN
      END       

         
c**************************************************************
c
      REAL*8 FUNCTION DETERM(B,N,A)
C     COMPUTES THE DETERMINANT OF THE MATRIX B
      implicit none
      INTEGER*4 I,J,K,N1,N,I1,J1,K1,J2,K2
      real*8 A(N,N),B(N,N),X      
      DO 55 I=1,N 
      DO 55 J=1,N 
   55 A(I,J)=B(I,J) 
      N1=N-1
      DETERM=1. 
      DO 1 I=1,N1 
      J1=I
      K1=I
      DO 10 J2=I,N
      DO 10 K2=I,N
      IF(ABS(A(J1,K1)).GE.ABS(A(J2,K2)))GO TO 10
      J1=J2 
      K1=K2
10    CONTINUE
      IF(ABS(A(J1,K1)).GT.1.E-30)GO TO 11
      DETERM=0. 
      RETURN
11    CONTINUE
      IF(J1.EQ.I)GO TO 12 
      DO 5 K=I,N
      X=A(I,K)
      A(I,K)=A(J1,K)
5     A(J1,K)=-X
12    IF(K1.EQ.I)GO TO 13 
      DO 6 J=1,N
      X=A(J,I)
      A(J,I)=A(J,K1)
6     A(J,K1)=-X
13    I1=I+1
      DO 30 J=I1,N 
      IF(A(J,I).EQ.0.)GO TO 30
      X=A(J,I)/A(I,I) 
      DO 7 K=I,N
7     A(J,K)=A(J,K)-X*A(I,K)
30    CONTINUE
1     DETERM=DETERM*A(I,I)
      DETERM=DETERM*A(N,N)
      RETURN
      END 
C                  
C
C
        SUBROUTINE DIAG(A,ADA,B)
C***********************************************************************
C   diagonalizes real*4 matrix A(4,4), B(4,4) is corresponding rotation matrix
C***********************************************************************
        IMPLICIT NONE
        INTEGER*4 I,J,K,L,N,ND,KK,KI,KJ,JR,KL,NDK,NDI,NDJ,JTES,NDN,II
        INTEGER*4 IJ,JI,JJ,JK,IK,ITES
        REAL*4 A(16),ADA(16),B(16),ARMAX(16),JRMAX(16)
        REAL*4 E,Y,X,T,TY,TSQ,C,S,CSQ,AMAX,AII,AJJ,AIJ
        DATA N,ND,E/4,4,1.E-24/
        NDN=ND*N
        DO 1 K=1,NDN
        ADA(K)=A(K)
        B(K)=0.
    1        CONTINUE
        DO 2 K=1,N
        KK=K*(ND+1)-ND
        ARMAX(K)=0.
        B(KK)=1.
        DO 3 L=K,N
        IF(L-K)4,3,4
    4        KL=K+ND*(L-1)
        Y=ABS(ADA(KL))
        IF(ARMAX(K)-Y)5,3,3
    5        ARMAX(K)=Y
        JRMAX(K)=L
    3        CONTINUE
    2        CONTINUE
   11        AMAX=0.
        DO 6 K=1,N
        Y=ABS(ARMAX(K))
        IF(AMAX-Y)7,6,6
    7        AMAX=Y
        I=K
    6        CONTINUE
        J=JRMAX(I)
        IF(E-AMAX)8,9,9
    8        NDI=ND*(I-1)
        NDJ=ND*(J-1)
        II=I+NDI
        JJ=J+NDJ
        IJ=I+NDJ
        JI=J+NDI
        AII=ADA(II)
        AJJ=ADA(JJ)
        AIJ=ADA(IJ)
        Y=2.*AIJ
        X=AII-AJJ
        T=SIGN(1.E0,X)*Y/(ABS(X)+SQRT(X**2+Y**2))
        TSQ=T**2
        C=1./SQRT(ABS(1.+TSQ))
        TY=T*Y
        S=T*C
        CSQ=C**2
        ADA(II)=CSQ*(AII+TY+AJJ*TSQ)
        ADA(JJ)=CSQ*(AJJ-TY+AII*TSQ)
        ADA(IJ)=0.
        ADA(JI)=0.
        DO 10 K=1,N
        JTES=(K-I)*(K-J)
        NDK=ND*(K-1)
        KI=K+NDI
        KJ=K+NDJ
        IF(JTES)13,12,13
   13        JK=J+NDK
        IK=I+NDK
        ADA(KI)=C*ADA(IK)+S*ADA(JK)
        ADA(KJ)=-S*ADA(IK)+C*ADA(JK)
        ADA(JK)=ADA(KJ)
        ADA(IK)=ADA(KI)
   12        X=B(KI)
        B(KI)=C*X+S*B(KJ)
        B(KJ)=-S*X+C*B(KJ)
   10        CONTINUE
        ARMAX(I)=0.
        DO 14 K=1,N
        IF(K-I)15,14,15
   15        IK=I+ND*(K-1)
        Y=ABS(ADA(IK))
        IF(ARMAX(I)-Y)16,14,14
   16        ARMAX(I)=Y
        JRMAX(I)=K
   14        CONTINUE
        ARMAX(J)=0.
        DO 17 K=1,N
        IF(K-J)18,17,18
   18        JK=J+ND*(K-1)
        Y=ABS(ADA(JK))
        IF(ARMAX(J)-Y)19,17,17
   19        ARMAX(J)=Y
        JRMAX(J)=K
   17        CONTINUE
        DO 20 K=1,N
        ITES=(K-I)*(K-J)
        KI=K+NDI
        KJ=K+NDJ
        IF(ITES)21,20,21
   21        X=ABS(ADA(KI))
        Y=ABS(ADA(KJ))
        JR=J
        IF(X-Y)22,22,23
   23        Y=X
        JR=I
   22        IF(ARMAX(K)-Y)24,20,20
   24        ARMAX(K)=Y
        JRMAX(K)=JR

   20        CONTINUE
        GOTO 11
9        CONTINUE
        RETURN
        END

C-----------------------------------------------------------------    
      SUBROUTINE LINFIT(X,Y,N,DX,DY,DZ,ND,AMPL,BACK,CHISQ)
C     Linear fit of the function (X,Y,N) to the data (DX,DY,DZ,ND)
C in REAL*4 !!
C----------------------------------------------------------------- 
      IMPLICIT NONE
      INTEGER*4 I,K,N,ND,KK
      REAL*4 AMPL,BACK,CHISQ
      REAL*4 X(N),Y(N),DX(ND),DY(ND),DZ(ND)
      REAL*4 C1,C2,C3,C4,C5,C6,Z,YY,W,DDX,ZMIN
      
      C1=0
      C2=0
      C3=0
      C4=0
      C5=0
      C6=0
      KK=0
      zmin=0
      DO i=1,N 
         if(abs(Y(i)).gt.zmin) zmin=abs(Y(i))
      enddo
      zmin=abs(zmin/10.)   
      DO I=1,ND
        DDX=X(2)-X(1)
        Z=(DX(I)-X(1))/DDX
        IF(Z.GE.0) THEN
           K=INT(Z)+1
        ELSE
           K=INT(Z)
        ENDIF      
        IF((K.GT.0).AND.(K.LT.N)) THEN      
           KK=KK+1
           YY=Y(K)+(Y(K+1)-Y(K))*(Z+1-K)  ! linear interpolation  
C           SIG2=DZ(I)**2
C           IF(SIG2.EQ.0) SIG2=1.
C           W=1/SIG2

            IF (abs(YY).LE.zmin) THEN 
               W=SQRT(ZMIN) 
            ELSE
               W=SQRT(abs(YY))   ! weighted by SQRT(Y) (for RESTRAX only)
            ENDIF 
           C1=C1+DY(I)*W
           C2=C2+YY*W
           C3=C3+W
           C4=C4+DY(I)*YY*W
           C5=C5+YY*YY*W
           C6=C6+DY(I)*DY(I)*W
        ENDIF            
      END DO
      IF(KK.GT.0) THEN
         IF((C2*C2-C3*C5).EQ.0) THEN
            AMPL=0
            BACK=0
            CHISQ=C6
         ELSE         
            AMPL= (C1*C2-C3*C4)/(C2*C2-C3*C5)
            BACK=(C4*C2-C5*C1)/(C2*C2-C3*C5)
            CHISQ=(AMPL**2)*C5+(BACK**2)*C3+C6+2*AMPL*BACK*C2-2*AMPL*C4-
     1         2*BACK*C1
            CHISQ=CHISQ/KK/C3
         ENDIF   
      ELSE
         WRITE(*,*) 'Cannot fit data ! '
         AMPL=0.
         BACK=0.
      ENDIF
      RETURN
      END
                  
C------------------------------------------------           
      REAL*4 FUNCTION LINTERP4(X,Y,N,Z)
C linear interpolation on equidistant data      
C in REAL*4 !!
C------------------------------------------------      
      IMPLICIT NONE
      
      INTEGER*4 I0,N
      REAL*4 Z0,X(N),Y(N),Z,DX
      
      IF (Z.LE.X(1)) THEN
         LINTERP4=Y(1)
         RETURN
      ELSE IF (Z.GE.X(N)) THEN         
         LINTERP4=Y(N)
         RETURN
      ELSE
         DX=(X(N)-X(1))/(N-1)
         Z0=(Z-X(1))/DX
         I0=INT(Z0)+1
         LINTERP4=Y(I0)+(Y(I0+1)-Y(I0))*(Z0-I0+1)         
         RETURN
      ENDIF        
      END 

C------------------------------------------------           
      REAL*8 FUNCTION LINTERP8(X,Y,N,Z)
C linear interpolation on equidistant data      
C in REAL*8!!
C------------------------------------------------      
      IMPLICIT NONE
      
      INTEGER*4 I0,N
      REAL*8 Z0,X(N),Y(N),Z,DX
      
      IF (Z.LE.X(1)) THEN
         LINTERP8=Y(1)
         RETURN
      ELSE IF (Z.GE.X(N)) THEN         
         LINTERP8=Y(N)
         RETURN
      ELSE
         DX=(X(N)-X(1))/(N-1)
         Z0=(Z-X(1))/DX
         I0=INT(Z0)+1
         LINTERP8=Y(I0)+(Y(I0+1)-Y(I0))*(Z0-I0+1)         
         RETURN
      ENDIF        
      END 

C------------------------------------------------           
      REAL*8 FUNCTION LINTERP(Y,N,X0,DX,Z)
C linear interpolation on equidistant data      
C x=X0+i*DX, i=1..N
C extrapolation=0
C------------------------------------------------      
      IMPLICIT NONE
      
      REAL*8 Y(N),X0,DX,Z
      INTEGER*4 N
      REAL*8 Z0
      INTEGER*4 I0
      
c      write(*,*)  '1D: ',X0,Z,X0+(N-1)*DX 
      IF (Z.LE.X0.OR.Z.GE.X0+(N-1)*DX) THEN
         LINTERP=0.D0
         RETURN
      ELSE
         Z0=(Z-X0)/DX
         I0=INT(Z0)+1
c       write(*,*) '1D: ', Z0,I0,Y(I0)+(Y(I0+1)-Y(I0))*(Z0-I0+1)
         LINTERP=Y(I0)+(Y(I0+1)-Y(I0))*(Z0-I0+1)         
         RETURN
      ENDIF        
      END 

C-----------------------------------------------------           
      REAL*8 FUNCTION LINTERP2D(Y,NI,NJ,ND,ZI,ZJ,DI,DJ,Z)
C linear interpolation on equidistant data in 2D 
C x=ZI+i*DI, i=1..NI
C y=ZJ+j*DJ, j=1..NJ
C-----------------------------------------------------      
      IMPLICIT NONE
      
      INTEGER*4 NI,NJ,ND
      REAL*8 Y(ND,NJ),ZI,ZJ,DI,DJ,Z(2)            
      REAL*8 JJ,YY1,YY2
      INTEGER*4 J0
      REAL*8 LINTERP
      
c      write(*,*)  '2D: ',ZJ,Z(2),ZJ+(NJ-1)*DJ 

      IF (Z(2).LE.ZJ.OR.Z(2).GE.ZJ+(NJ-1)*DJ) THEN
         LINTERP2D=0.D0
         RETURN
      ELSE
         JJ=(Z(2)-ZJ)/DJ
         J0=INT(JJ)+1
         YY1=LINTERP(Y(1,J0),NI,ZI,DI,Z(1))
         YY2=LINTERP(Y(1,J0+1),NI,ZI,DI,Z(1))        
         LINTERP2D=YY1+(YY2-YY1)*(JJ-J0+1)         
c       write(*,*) '2D: ', JJ,J0,YY1,YY2
         RETURN
      ENDIF        

      END 
      
C------------------------------------------------           
      REAL*4 FUNCTION QINTERP4(X,Y,N,Z)
C quadratic interpolation (X monotonous)      
C in REAL*4 !!
C------------------------------------------------      
      IMPLICIT NONE
     
      INTEGER*4 I0,N,I
      REAL*4 X(N),Y(N),Z,A(3,3),B(3),C(3)
      
      IF (Z.LE.X(1)) THEN
         QINTERP4=Y(1)
         RETURN
      ELSE IF (Z.GE.X(N)) THEN         
         QINTERP4=Y(N)
         RETURN
      ELSE
        I0=1
        DO WHILE(X(I0).LT.Z)
          I0=I0+1
        ENDDO
        IF(I0.GT.N-1) I0=N-1
        IF(I0.LT.2) I0=2
        IF((X(I0).EQ.X(I0-1)).OR.(X(I0).EQ.X(I0+1))) THEN
           IF(X(I0-1).EQ.X(I0+1)) THEN
              QINTERP4=Y(I0)
           ELSE
              C(1)=(Y(I0+1)-Y(I0-1))/(X(I0+1)-X(I0-1))
              QINTERP4=Y(I0-1)+C(1)*(Z-X(I0-1))
           ENDIF
           RETURN
        ENDIF      
        DO I=1,3
          A(I,1)=X(I+I0-2)**2
          A(I,2)=X(I+I0-2)
          A(I,3)=1
          B(I)=Y(I+I0-2)
        ENDDO
        CALL GAUSS(A,B,C,3)        
        QINTERP4=C(1)*Z**2+C(2)*Z+C(3)
      ENDIF                
      END
      
      
      
      
C------------------------------------------------      
      SUBROUTINE GAUSS(A,B,C,N)
C// solve linear equations by Gauss elimination  
C in REAL*4 !!
C------------------------------------------------    
      IMPLICIT NONE
      INTEGER*4 MAX
      PARAMETER(MAX=16)
      INTEGER*4 N,I,J,K
      REAL*4 A(N,N),C(N),B(N),AUX(MAX,MAX+1),V(MAX+1),M,sum
      
      DO I=1,N
      DO J=1,N
        AUX(I,J)=A(I,J)
      ENDDO
      ENDDO
      
      DO I=1,N
        AUX(I,N+1)=B(I)
      ENDDO
      
      DO K=1,N-1
        I=K
        DO WHILE(AUX(I,K).EQ.0)
          I=I+1
          IF (I.GT.N) GOTO 10
        ENDDO  
        DO J=1,N+1
          V(j)=AUX(i,j)
          AUX(i,j)=AUX(k,j)
          AUX(k,j)=V(j)
        ENDDO
        DO I=k+1,N
          M=AUX(I,K)/AUX(k,k)
          do j=k,N+1
            AUX(i,j)=AUX(i,j)-m*AUX(k,j)
          enddo
        enddo
      enddo
      if (AUX(N,N).EQ.0) GOTO 10
      C(N)=AUX(N,N+1)/AUX(N,N)
      do k=1,n-1
        sum=0
        do j=n-k+1,n
          sum=sum+AUX(n-k,j)*C(j)
        enddo  
        C(n-k)=(AUX(n-k,n+1)-sum)/AUX(n-k,n-k) 
      enddo
      RETURN              
10    write(*,*) 'Matrix not invertible'
      DO I=1,N
        C(I)=0
      ENDDO   
      pause
      return
  
      end            
      
c--------------------------------------------      
      REAL*8 FUNCTION ROT3(I,J,K,ALFA)
c--------------------------------------------            
      IMPLICIT NONE
      
      INTEGER*4 I,J,K
      REAL*8 ALFA
      
      IF((I.EQ.J).OR.(I.EQ.K)) THEN
        IF(J.EQ.K) THEN
          ROT3=1
        ELSE
          ROT3=0
        ENDIF
      ELSE IF (J.EQ.K) THEN
        ROT3=COS(alfa)
      ELSE
        IF(J.LT.K) THEN
           ROT3=-sin(alfa)
        ELSE
           ROT3=sin(alfa)
        ENDIF
      ENDIF
      END                 
      

c--------------------------------------------      
      SUBROUTINE MK_ROT3(I,ALFA,RT)
c--------------------------------------------            
      IMPLICIT NONE
      
      INTEGER*4 I,J,K      
      REAL*8 ALFA,RT(3,3),ROT3
      
      DO J=1,3
      DO K=1,3
         RT(J,K)=ROT3(I,J,K,ALFA)
      ENDDO
      ENDDO
      END   
      
      

C------------------------------------------
      SUBROUTINE JACOBI(AA,A,N,NP,D,V,NROT)
C  Diagonalize matrix AA, 
C returns the diagonalized matrix, V 
C and the transformation matrix, A
C  V=A^T*AA*A
C  (Numerical Recipes)
C------------------------------------------
      implicit none
      integer*4 NMAX,N,NP,NROT
      PARAMETER(NMAX=100)
      real*8 A(NP,NP),D(NP),V(NP,NP),B(NMAX),Z(NMAX),AA(NP,NP)
      integer*4 IQ,IP,I,J
      REAL*8 SM,G,S,C,T,TAU,H,TRESH,THETA
      
      DO 12 IP=1,N
         DO 11 IQ=1,N
            V(IP,IQ)=0
            A(IP,IQ)=AA(IP,IQ)
11       CONTINUE 
         V(IP,IP)=1 
12    CONTINUE          
      DO 13 IP=1,N
        B(IP)=A(IP,IP)
        D(IP)=B(IP)
        Z(IP)=0
13    CONTINUE
      NROT=0
      DO 24 I=1,50
        SM=0.
        DO 15 IP=1,N-1
          DO 14 IQ=IP+1,N
            SM=SM+ABS(A(IP,IQ))
14        CONTINUE                  
15      CONTINUE 
        IF(SM.EQ.0) GOTO 99
        IF(I.LT.4) THEN
           TRESH=0.2*SM/N**2
        ELSE
           TRESH=0.
        ENDIF
        DO 22 IP=1,N-1
          DO 21 IQ=IP+1,N
            G=100.*ABS(A(IP,IQ))
            IF((I.GT.4).AND.(ABS(D(IP))+G.EQ.ABS(D(IP)))
     1       .AND.(ABS(D(IQ))+G.EQ.ABS(D(IQ)))) THEN
               A(IP,IQ)=0
            ELSE IF (ABS(A(IP,IQ)).GT.TRESH) THEN
               H=D(IQ)-D(IP)
               IF (ABS(H)+G.EQ.ABS(H)) THEN
                  T=A(IP,IQ)/H
               ELSE
                  THETA=0.5*H/A(IP,IQ)
                  T=1./(ABS(THETA)+SQRT(1.+THETA**2))
                  IF(THETA.LT.0.) T=-T
               ENDIF
               C=1./SQRT(1+T**2)
               S=C*T
               TAU=S/(1.+C)
               H=T*A(IP,IQ)
               Z(IP)=Z(IP)-H
               Z(IQ)=Z(IQ)+H
               D(IP)=D(IP)-H
               D(IQ)=D(IQ)+H
               A(IP,IQ)=0.
               DO 16 J=1,IP-1
                  G=A(J,IP)
                  H=A(J,IQ)
                  A(J,IP)=G-S*(H+G*TAU)
                  A(J,IQ)=H+S*(G-H*TAU)
16             CONTINUE
               DO 17 J=IP+1,IQ-1
                  G=A(IP,J)
                  H=A(J,IQ)
                  A(IP,J)=G-S*(H+G*TAU)
                  A(J,IQ)=H+S*(G-H*TAU)
17             CONTINUE
               DO 18 J=IQ+1,N
                  G=A(IP,J)
                  H=A(IQ,J)
                  A(IP,J)=G-S*(H+G*TAU)
                  A(IQ,J)=H+S*(G-H*TAU)
18             CONTINUE
               DO 19 J=1,N
                  G=V(J,IP)
                  H=V(J,IQ)
                  V(J,IP)=G-S*(H+G*TAU)
                  V(J,IQ)=H+S*(G-H*TAU)
19             CONTINUE
               NROT=NROT+1
            ENDIF
21        CONTINUE
22      CONTINUE                
        DO 23 IP=1,N
           B(IP)=B(IP)+Z(IP)
           D(IP)=B(IP)
           Z(IP)=0.
23      CONTINUE 
24    CONTINUE
      PAUSE '50 ITERATION SHOULD NEVER HAPPEN'
      RETURN
99    CONTINUE

      RETURN      
      END            
      
              
       
C------------------------------------------------
      SUBROUTINE KVERTD(V,LV,N,W,IERR)
C invert matrix, from http://www.netlib.org/napack
C rewritten from KVERT to real*8 by J.S.
C added IRES .. result indicator
C------------------------------------------------
C      ________________________________________________________
C     |                                                        |
C     |     INVERT A GENERAL MATRIX WITH COMPLETE PIVOTING     |
C     |                                                        |
C     |    INPUT:                                              |
C     |         V     --ARRAY CONTAINING MATRIX                |
C     |         LV    --LEADING (ROW) DIMENSION OF ARRAY V     |
C     |         N     --DIMENSION OF MATRIX STORED IN ARRAY V  |
C     |         W     --WORK ARRAY WITH AT LEAST 2N ELEMENTS   |
C     |    OUTPUT:                                             |
C     |         V     --INVERSE                                |
C     |    BUILTIN FUNCTIONS: ABS                              |
C     |________________________________________________________|
C
      IMPLICIT NONE
      INTEGER*4 LV,N,H,I,J,K,L,M,O,P,Q,IERR
      REAL*8 V(LV,1),W(1),S,T
      
      IF ( N .EQ. 1 ) GOTO 120
      O = N + 1
      L = 0
      M = 1
10    IF ( L .EQ. N ) GOTO 90
      K = L
      L = M
      M = M + 1
C     ---------------------------------------
C     |*** FIND PIVOT AND START ROW SWAP ***|
C     ---------------------------------------
      P = L
      Q = L
      S = ABS(V(L,L))
      DO 20 H = L,N
           DO 20 I = L,N
                T = ABS(V(I,H))
                IF ( T .LE. S ) GOTO 20
                P = I
                Q = H
                S = T
20    CONTINUE
      W(N+L) = P
      W(O-L) = Q
      DO 30 I = 1,N
           T = V(I,L)
           V(I,L) = V(I,Q)
30         V(I,Q) = T
      S = V(P,L)
      V(P,L) = V(L,L)
      IF ( S .EQ. 0. ) GOTO 130
C     -----------------------------
C     |*** COMPUTE MULTIPLIERS ***|
C     -----------------------------
      V(L,L) = -1.
      S = 1./S
      DO 40 I = 1,N
40         V(I,L) = -S*V(I,L)
      J = L
50    J = J + 1
      IF ( J .GT. N ) J = 1
      IF ( J .EQ. L ) GOTO 10
      T = V(P,J)
      V(P,J) = V(L,J)
      V(L,J) = T
      IF ( T .EQ. 0. ) GOTO 50
C     ------------------------------
C     |*** ELIMINATE BY COLUMNS ***|
C     ------------------------------
      IF ( K .EQ. 0 ) GOTO 70
      DO 60 I = 1,K
60         V(I,J) = V(I,J) + T*V(I,L)
70    V(L,J) = S*T
      IF ( M .GT. N ) GOTO 50
      DO 80 I = M,N
80         V(I,J) = V(I,J) + T*V(I,L)
      GOTO 50
C     -----------------------
C     |*** PIVOT COLUMNS ***|
C     -----------------------
90    L = W(K+N)
      DO 100 I = 1,N
           T = V(I,L)
           V(I,L) = V(I,K)
100        V(I,K) = T
      K = K - 1
      IF ( K .GT. 0 ) GOTO 90
C     --------------------
C     |*** PIVOT ROWS ***|
C     --------------------
      DO 110 J = 1,N
           DO 110 I = 2,N
                P = W(I)
                H = O - I
                T = V(P,J)
                V(P,J) = V(H,J)
                V(H,J) = T
C OK
110   IERR=0 
      RETURN
      
C OK, scalar only 
120   IF ( V(1,1) .EQ. 0. ) GOTO 130
      V(1,1) = 1./V(1,1)
      IERR=0
      RETURN
C No inverse      
130   WRITE(6,*) 'MATRIX HAS NO INVERSE'
      IERR=1
      END
     


                                      
                           
