C//////////////////////////////////////////////////////////////////////
C////
C////  R E S T R A X   4.4
C////
C////  Subroutines for optimization
C////
C//////////////////////////////////////////////////////////////////////
          

C**************************************************************
      SUBROUTINE GETDERIV1(A,DELTA,FUNCTN,DER1,DER2)
C     1st and 2nd derivative for 1 parameter
C**************************************************************
      IMPLICIT NONE

      REAL*8 AJ,Y1,Y2,Y0,DER1,DER2
      REAL*4 A(1),DELTA
      REAL*4 FUNCTN
      external functn
      DER1=0
      DER2=0
c      write(*,*) 'GETDERIV1 ',DELTA
      IF(DELTA.NE.0) THEN
         AJ = A(1)
10       A(1) = AJ+DELTA
c         write(*,*) 'GETDERIV1  before' 
         Y1 = functn(A(1))
c         write(*,*) 'GETDERIV1 after'
         A(1) = AJ-DELTA
         Y2 = functn(A(1))
         IF(ABS((Y1-Y2)/(Y1+Y2)).GT.0.4) THEN
            DELTA=DELTA/2.
            write(*,*) DELTA,Y1,Y2,ABS((Y1-Y2)/(Y1+Y2))
            GOTO 10
         ENDIF
         A(1) = AJ            
         Y0 = functn(A(1))
         DER1=(Y1-Y2)/2/DELTA
         DER2=(Y1+Y2-2*Y0)/DELTA/DELTA
      ENDIF           
      END
C
C**************************************************************
      REAL*8 FUNCTION GETDERIV(IDER,J,K,A,DELTAA,N,FUNCTN)
C
C**************************************************************
      IMPLICIT NONE

      INTEGER*4 IDER,J,K,N
      REAL*8 AJ,AK,Y1,Y2,Y0,W1,W2,DELTA,DELTB
      REAL*4 A(N),DELTAA(N)
      REAL*4 FUNCTN
      external functn

      IF (IDER.EQ.0) THEN
        GETDERIV=functn(A)
      ELSE IF (IDER.EQ.1) THEN
        IF(DELTAA(J).NE.0) THEN
          AJ = A(J)
10        DELTA = DELTAA(J)
          A(J) = AJ+DELTA
          Y1 = functn(A)
          A(J) = AJ-DELTA
          Y2 = functn(A)
          IF(ABS((Y1-Y2)/(Y1+Y2)).GT.0.4) THEN
            DELTAA(J)=DELTAA(J)/2.
            GOTO 10
          ENDIF
          GETDERIV=(Y1-Y2)/2/DELTA
          A(J)=AJ          
        ELSE
          GETDERIV=0      
        ENDIF
      ELSE IF (IDER.EQ.2) THEN
        IF(DELTAA(J).NE.0.AND.DELTAA(K).NE.0) THEN
         AJ = A(J)
         AK = A(K)
         DELTA = DELTAA(J)
         DELTB = DELTAA(K)
         IF (J.EQ.K) THEN
           A(J) = AJ+DELTA
           Y1 = functn(A)
           A(J) = AJ-DELTA
           Y2 = functn(A)
           A(J) = AJ            
           Y0 = functn(A)
           GETDERIV=(Y1+Y2-2*Y0)/DELTA/DELTA
         ELSE
           A(K) = AK+DELTB
           A(J) = AJ+DELTA
           Y1 = functn(A)
           A(J) = AJ-DELTA
           Y2 = functn(A)
           W1=(Y1-Y2)/2/DELTA
           A(K) = AK-DELTB
           A(J) = AJ+DELTA
           Y1 = functn(A)
           A(J) = AJ-DELTA
           Y2 = functn(A)
           W2=(Y1-Y2)/2/DELTA
           GETDERIV=(W1-W2)/2/DELTB
         ENDIF
         A(K) = AK
         A(J) = AJ
        ELSE
         GETDERIV=0
        ENDIF 
      ENDIF     
      

      RETURN
      END


C
C------------------------------------------------------------
      SUBROUTINE LMOPT(FUNCTN,A,NP,TOL,INCA,ISIL)
C  find minimum of FUNCTN function by Levenberg-Marquardt algorithm
C  A(i)    ...  parameters
C  INAC(i) ...  minimum increments for numerical derivatives of A
C  TOL     ... tolerance indicator
C  ISIL    ... silence level (no output for ISIL>1)
C------------------------------------------------------------
      IMPLICIT NONE
      
      INTEGER*4 M,NP,ISIL
      PARAMETER (M=16)
      REAL*4 A(NP),TOL,INCA(NP)
      
      INTEGER*4 MAXIT,J,K,INS(M),IT,IERR
      REAL*8 ARRAY(M,M),ALPHA(M,M),AN(M,M),BETA(M)            
      REAL*4 B(M),DELTAA(M),CHISQR,CHISQ1,FLAMDA
      REAL*8 GETDERIV
      REAL*4 FUNCTN
      COMMON /ERROR/IERR
      external functn

1     format(/,a10,': ',I3,2x,8(G10.4,2x),2x)
c       write(*,*) ISIL
c       pause
      IF (M.LT.NP) GOTO 999
      IERR=0
      MAXIT=20  ! do no more than 20 iterations
      IT=0

C/// set increments
      DO J=1,NP
        DELTAA(J)=ABS(A(J)*TOL)
        IF(DELTAA(J).LT.INCA(J)) DELTAA(J)=INCA(J)
      ENDDO  
      FLAMDA=0.1
c      write(*,1) 'Delta',(DELTAA(J),J=1,NP),NP
c      pause       
      
C/// get initial CHISQR
      CHISQR = FUNCTN(A(1))  
      
C/// start iterations      
41    CHISQ1=CHISQR

      
      if (isil.lt.1)  write(*,1) 'IT,CHI,PAR',IT,CHISQR,(A(J),J=1,NP)      

C/// get derivatives: 
      IF(NP.EQ.1) THEN       
        CALL GETDERIV1(A(1),DELTAA(1),FUNCTN,BETA(1),ALPHA(1,1))
      ELSE
        DO J=1,NP
            BETA(J)=GETDERIV(1,J,J,A,DELTAA,NP,FUNCTN)
        END DO
        DO J=1,NP
            DO K=1,J
              ALPHA(J,K)=GETDERIV(2,J,K,A,DELTAA,NP,FUNCTN)
            END DO
        END DO
      ENDIF  
c      write(*,1) 'dF/dRo',(BETA(J),J=1,NP),(DELTAA(J),J=1,NP)       
c      pause       

C/// symetrize ALPHA
      DO J=1,NP
        DO K=1,J
          ALPHA(K,J) = ALPHA(J,K)
        END DO
      END DO

C/// check zeros on digonal
      DO  J=1,NP
          INS(J) = 0
          IF(ABS(ALPHA(J,J)).LT.1.E-19) INS(J)=1
      END DO

C/// create Hessian matrix
71    DO J=1,NP
        DO K=1,NP
          IF((INS(J)+INS(K)).EQ.0) THEN
            AN(J,K)=SQRT(ABS(ALPHA(J,J))*ABS(ALPHA(K,K)))
            ARRAY(J,K) = ALPHA(J,K)/AN(J,K)
          ELSE
            AN(J,K)=1.
            ARRAY(J,K) = 0.D0
          ENDIF
        END DO 
        ARRAY(J,J) = 1.D0+FLAMDA
      END DO
      
      
c      write(*,*)       
c        WRITE(*,1) 'BETA: ',CHISQR,FLAMDA,(BETA(K),K=1,NP)
c      DO J=1,NP
c        WRITE(*,1) 'ALPHA: ',(ALPHA(J,K),K=1,NP)
c      ENDDO  
c       DO J=1,NP
c         WRITE(*,1) 'ARRAY: ',(ARRAY(J,K),K=1,NP)
c       ENDDO  
c      write(*,*)
      
C// invert ARRAY
      CALL INVERT(NP,ARRAY,M,ARRAY,M)
c      write(*,*) 'INVERT OK'

C// calculate new values
      DO J=1,NP
        B(J) = 0.D0
        DO K=1,NP
          IF((INS(J)+INS(K)).EQ.0) THEN
            B(J) = B(J)-BETA(K)*ARRAY(J,K)/AN(J,K)
          ENDIF
        END DO 
      END DO
      
      DO J=1,NP
         B(J) = B(J)+A(J)
      END DO

C// get new CHISQR            
      CHISQR = FUNCTN(B(1))  

C// check stop conditions
      IF(CHISQR.LT.1E-20) GOTO 110 ! exact match ... speed-up linear fit
      IF ((CHISQ1-CHISQR).LE.0.D0) THEN 
        FLAMDA = 5.*FLAMDA
        IF(FLAMDA.LE.1000.) THEN ! try again with larger FLAMBDA
           GOTO 71
        ELSE
           GOTO 111 ! exit if FLAMBDA is too large
        ENDIF      
      ENDIF

C//  accept new values and continue 
110   DO J=1,NP
         A(J) = B(J)
      END DO
      FLAMDA = FLAMDA/5.
      IT=IT+1

      IF (CHISQR.LT.1E-20) GOTO 111  ! exit on exact match
      IF (ABS(ABS(CHISQ1/CHISQR)-1.).LT.0.001) GOTO 111 ! exit on < 1/1000 change
      IF (IT.GE.MAXIT) GOTO 112  ! exit on maximum iteration number

      GOTO 41

111   continue
      if (isil.lt.1)  write(*,1) 'IT,CHI,PAR',IT,CHISQR,(A(J),J=1,NP)      
      RETURN
112   if (isil.lt.2) then
        write(*,*) 'LMOPT: iteration > ',MAXIT,', fit not finished'
      endif 
      RETURN
999   if (isil.lt.2) then      
        write(*,*) 'ERROR in LMOPT: max. dimension ',M,'<',NP 
      endif
      END



