C//////////////////////////////////////////////////////////////////////
C////
C////  R E S T R A X   4.1
C////
C////  Some subroutines for I/O operations:
C////
C////  
C//////////////////////////////////////////////////////////////////////


C--------------------------------------------------
      SUBROUTINE CHECKRESFILE(FNAME,IRES,FRES,ISIL)
C Test existence of a file for input in RESTRAX
C return:
C IRES=1 ... current directory
C IRES=2 ... RESPATH/NAME     
C IRES=3 ... CFGPATH/NAME     
C IRES=-1 ... not found   
C FRES ... resulting filename (incl. path), does not check length !
C ISIL ... silence level
C--------------------------------------------------      
      IMPLICIT NONE    
      INCLUDE 'const.inc'
      INCLUDE 'inout.inc'
      INTEGER*4 IRES,IS,IL,IS1,IL1,ISIL,IS2,IL2
      LOGICAL*4 LOG1
      CHARACTER*(*) FNAME
      CHARACTER*128 FN,FFN,CFN,FRES

      IRES=-1      
      CALL BOUNDS(FNAME,IS,IL)
      CALL BOUNDS(RESPATH,IS1,IL1)
      CALL BOUNDS(CFGPATH,IS2,IL2)
      FN=FNAME(IS:IS+IL-1)
      FFN=RESPATH(IS1:IS1+IL1-1)//FNAME(IS:IS+IL-1)
      CFN=CFGPATH(IS2:IS2+IL2-1)//FNAME(IS:IS+IL-1)
      IS1=1
      IL1=IL+IL1
      IS2=1
      IL2=IL+IL2
      
C// Try the current directory first
      INQUIRE(FILE=FN,EXIST=LOG1)
      IF(LOG1) THEN 
         IRES=1
         FRES=FN
         RETURN
      ENDIF
C// Otherwise try RESPATH directory
c      write(*,*) FFN
      INQUIRE(FILE=FFN,EXIST=LOG1)
      IF(LOG1) THEN 
         IRES=2
         FRES=FFN
         RETURN
      ENDIF
C// Otherwise try CFGPATH directory
c      write(*,*) CFN
      INQUIRE(FILE=CFN,EXIST=LOG1)
      IF(LOG1) THEN 
         IRES=3
         FRES=CFN
         RETURN
      ENDIF
       
      IF(ISIL.LT.2) 
     *  WRITE(SMES,*) 'Cannot find file for input: ',FN(IS:IS+IL-1)
      RETURN  
      END
      

C--------------------------------------------------
      SUBROUTINE OPENRESFILE(FNAME,IUNIT,IRES,ISIL)
C Open file for input in RESTRAX
C returns IRES>0 if open, otherwise IRES<0
C--------------------------------------------------      
      IMPLICIT NONE    
      INTEGER*4 IUNIT,IRES,ISIL,IERR
      CHARACTER*(*) FNAME
      CHARACTER*128 FN

      CALL CHECKRESFILE(FNAME,IRES,FN,ISIL)
      IF (IRES.GT.0) THEN
c       write(*,*) IRES,FN(1:60)
         OPEN(UNIT=IUNIT,FILE=FN,STATUS='OLD',ERR=10,IOSTAT=IERR)
      ENDIF
      RETURN
10    IRES=-IERR      
      END
      
C-------------------------------------------
      SUBROUTINE READ_RESCAL(NAME,IRES)
C Read RESCAL parameters from a *.res file
C IRES>0  ... read OK (=value returned by OPENRESFILE)
C IRES=-1 ... cannot open RESCAL file
C IRES<=-2 ... error while reading file
C-------------------------------------------      
      IMPLICIT NONE    
      INCLUDE 'const.inc'
      INCLUDE 'inout.inc'
      INCLUDE 'rescal.inc'
      INTEGER*4 IU,IRES
      PARAMETER(IU=24)
      CHARACTER*60 NAME,LINE,FN
      INTEGER*4 I,IERR,IS,IL,L
      REAL*8 DAT(MRES),VER
102   FORMAT('Error ',I5,' in RESCAL file, line=',I5)
1     FORMAT(a)

      IERR=0
      IS=1
      L=LEN(NAME)
      CALL FINDPAR(NAME,1,IS,IL)
      FN=NAME(IS:IS+IL-1)
      
      IF (IL.LE.4.OR.FN(IL-3:IL).NE.'.res') THEN ! requires *.res file extension
        IF (L.GE.IL+4) THEN
          FN=NAME(IS:IS+IL-1)//'.res' ! append the extension if possible
          IL=IL+4
        ELSE
          write(smes,*) 'Can''t append .res extension'
          IRES=-1     
          RETURN
        ENDIF
      ENDIF
C make a copy of RESCAL parameters
      DO I=1,MRES
         DAT(I)=RES_DAT(I) 
      ENDDO
C open file        
      CALL OPENRESFILE(FN(1:IL),IU,IRES,0)
      IF(IRES.LE.0) GOTO 90
      READ(IU,1,ERR=98,END=97,IOSTAT=IERR) LINE
      CALL READ_R8('version',LINE,VER,IERR)
      IF(IERR.EQ.0.AND.VER.GE.4.77) THEN    ! new version  
         DO I=1,RES_NVAR
            READ(IU,*,ERR=98,END=97,IOSTAT=IERR) RES_DAT(I)
         ENDDO 
      ELSE   ! old version, skip da3,da4  
         READ(LINE,*,ERR=98,END=97,IOSTAT=IERR)  RES_DAT(1)
         DO I=2,i_DA3-1
	    READ(IU,*,ERR=98,END=97,IOSTAT=IERR) RES_DAT(I)
         ENDDO 
         RES_DAT(i_DA3)=0.
         RES_DAT(i_DA4)=0.
         DO I=i_DA4+1,RES_NVAR
	    READ(IU,*,ERR=98,END=97,IOSTAT=IERR) RES_DAT(I)
         ENDDO 
      ENDIF                  
97    CLOSE(UNIT=IU)
      RESCAL_NAME=FN(1:IL)
      RETURN
      
98    IRES=-IERR
      CLOSE(UNIT=IU)
      write(smes,102) IERR,I
90    DO I=1,MRES
         RES_DAT(I)=DAT(I) 
      ENDDO   
      END

       
C-----------------------------------------------------------------------
      SUBROUTINE WRITE_RESCAL(SARG,IRES)
C Write RESCAL parameters to a *.res file
C IRES=0 ... not saved
C IRES=1 ... saved
C-----------------------------------------------------------------------
      IMPLICIT NONE
      INCLUDE 'const.inc'
      INCLUDE 'rescal.inc'
      INCLUDE 'inout.inc'
      INTEGER*4 IU
      PARAMETER(IU=24)
      
      CHARACTER*(*) SARG
      CHARACTER*60 NAME
      CHARACTER*2  UPCASE,CH2
      INTEGER*4 I,L,TRUELEN,IRES
1     FORMAT(' Save to file : ',$)
2     FORMAT(a)
3     FORMAT(' Parameters saved in "',a40)
4     FORMAT(' Cannot save parameters in "',a40)

      IRES=0
      L=TRUELEN(SARG)
      CH2=UPCASE(SARG(1:2))
      IF(L.EQ.0.AND.RESCAL_NAME.NE.' ') THEN	
           NAME=RESCAL_NAME
      ELSE IF((L.EQ.0.AND.RESCAL_NAME.EQ.' ')
     *        .OR.(L.EQ.2.AND.CH2.EQ.'AS')) THEN
	   write(smes,1)
           read(sinp,2) NAME
      ELSE
           NAME=SARG
      ENDIF
        
      L=TRUELEN(NAME)
      IF (L.LE.0) THEN
         RETURN
      ENDIF 
      
      L=TRUELEN(NAME)
      OPEN(UNIT=IU,FILE=NAME(1:L),STATUS='UNKNOWN',ERR=99)
      WRITE(IU,2) 'version=4.77'
      DO  I=1,RES_NVAR
         WRITE(IU,*) RES_DAT(I)
      ENDDO   
      CLOSE(UNIT=IU)
      IRES=1
      write(smes,3) NAME(1:L)
      RESCAL_NAME=NAME
      RETURN
99    write(smes,4) NAME(1:L)
      END
       

C---------------------------------------------------------------------------------
      SUBROUTINE OPENFILE(SARG,IRES)
C Procedure for loading an ILL data file or RESCAL parameters into "mf_cur" data set
C 1) Try loading RESCAL file (*.res) (ires=1 on success)
C 2) Try ILL data file (ires=2 on success)
C ires=0 if failed
C Added fo debug:  
c filename "create" causes just creating spectrum data (with zero intensities), ires=3      
C---------------------------------------------------------------------------------
      IMPLICIT NONE
      INCLUDE 'const.inc'
      INCLUDE 'inout.inc'
      INCLUDE 'rescal.inc'
      
      CHARACTER*(*) SARG
      CHARACTER*60 NAME,TMPNAME
      INTEGER*4 I,IERR,IS,IL,IRES
      REAL*8 DAT(MRES)
      
1     FORMAT(' Name of a parameter or data file: ',$)
11    FORMAT(' Name of a parameter or data file [',a,'] : ',$)
2     FORMAT(60A)
201   FORMAT(' RESCAL paramaters loaded: ',a)
202   FORMAT(' Can''t open RESCAL file ',a,', trying data file ...')
203   FORMAT(' Can''t read RESCAL file ',a,', trying data file ...')
101   FORMAT('Error ',I4,': File ',a,' doesn''t exist !')
102   FORMAT('Error ',I4,': Can''t read data in ',a,' ! ')
103   FORMAT('Error ',I4,': Can''t read data, header accepted ! ')
      
      IRES=0

C store default filename in TMPNAME
      IF (RESCAL_NAME.NE.' ') THEN 
         TMPNAME=RESCAL_NAME
      ELSE
         TMPNAME=' '
      ENDIF   
      
C Get filename from dialog or from the argument SARG 
      CALL BOUNDS(TMPNAME,IS,IL)
      IF (SARG.EQ.' ') THEN
        IF (IL.LE.0) THEN
          write(smes,1)
          read(sinp,2) NAME
        ELSE ! offer a default filename
          write(sout,11) TMPNAME(IS:IS+IL-1)
          read(sinp,2) NAME 
          IF (NAME.EQ.' ')  NAME=TMPNAME(IS:IS+IL-1)
        ENDIF  
      ELSE
        NAME=SARG
      ENDIF

C debug test
      IF (NAME.EQ.' ') RETURN

C try first to read RESCAL file *.res
      CALL READ_RESCAL(NAME,IRES)
      CALL BOUNDS(NAME,IS,IL)
      IF (IRES.GT.0) THEN
        IRES=1
        write(smes,201) NAME(IS:IS+IL-1)
        RETURN
      ELSE IF (IRES.EQ.-1) THEN
        IRES=0
        WRITE(smes,202) NAME(IS:IS+IL-1)
      ELSE
        IRES=0
        WRITE(smes,203) NAME(IS:IS+IL-1)
      ENDIF
      
C make a copy of RESCAL parameters
      DO I=1,MRES
         DAT(I)=RES_DAT(I) 
      ENDDO   
        
C// try first to read parameters from data file
      call ReadDatFile(DATPATH,NAME,ierr)  !  try ILL data format   
      CALL BOUNDS(NAME,IS,IL)
      if(ierr.eq.0) THEN               !  data file, complete
         RESCAL_NAME=DATNAME//'.res'
         IRES=2
      else if (ierr.EQ.2) then               !  only header, no data values
         IF (SILENT.LT.2) write(smes,103) ierr
         RESCAL_NAME=DATNAME//'.res'
         IRES=1
      else                              !  another problem with data file
         IF (SILENT.LT.2) THEN         
           IF (IERR.EQ.29) THEN
             write(smes,101) ierr,NAME(IS:IS+IL-1)
           ELSE 
             write(smes,102) ierr,NAME(IS:IS+IL-1) 
           ENDIF 
         ENDIF
         GOTO 90         
      endif
         
      RETURN
      
C on error: restore RESCAL parameters and exit     
90    DO I=1,MRES
         RES_DAT(I)=DAT(I) 
      ENDDO   
      RETURN
     
      END


C-------------------------------------------------------------------------------------------------
      SUBROUTINE ReadDatFile(NameDir,NameFile,ierr)
C Subroutine for reading parameters from data files. ILL UNIX format is accepted. 
C Simplified from RESTRAX for SIMRES: only data header is evaluated 
C---------------------------------------------------------------------------------------------
      implicit none 

      INCLUDE 'const.inc'
      INCLUDE 'inout.inc'
      INCLUDE 'rescal.inc'

      INTEGER*4 i_IO,IS,IL,ilines
      Parameter(i_IO=23)
      character*1 cun,cdl
      character*(*) NameFile,NameDir
      character*128 PathName
      character*256 CLine,CMDLINE,TITLELINE
      INTEGER*4 ierr,nuse,i,ios,l,id,lf,iif
      INTEGER*4 idata,ip,ip1,ld
      REAL*8 ValPar(RES_NVAR)
      LOGICAL*4 UsePar(RES_NVAR),lun
      CHARACTER*6 S,ResPar(RES_NVAR)
      INTEGER*4 IDBG  
      DATA IDBG/0/ ! for debug purposes - set IDBG>0 to see debug messages


201   FORMAT(' trying ILL data format on ',a,' ... ',$)
202   FORMAT('     ',a,a)
203   FORMAT('     ',a,I6)
204   FORMAT(I3,2x,10(G10.4,1x))
205   FORMAT(a,2x,10(G10.4,1x))
206   FORMAT(a,2x,10(a,1x))
                  
C///  ****   READ DATA HEADER   **** 

C//  define variables identificators, equal to the RES_NAM(i) array:      
      DO I=1,RES_NVAR
         S=RES_NAM(I)//'='
         CALL STRCOMPACT(S,IS,IL)
         ResPar(I)=S(IS:IS+IL-1)         
      ENDDO      

C// UsePar(i) serves to identify actually read parameters
C// lun = true if energy unit has been found
C// nuse is the number of identified parameters      
      nuse=0
      ierr=1
      do i=1,RES_NVAR
        UsePar(i)=.false.
      end do
      lun=.false.
      idata=0
      ilines=0

1     format(a129)
2     format(a5)
c 3     format(3(2x,F12.3))
      
C// Find correct datafile name:
      Call SpecFileName(NameFile,1)
      CALL BOUNDS(NameDir,id,ld)
      CALL BOUNDS(NameFile,iif,lf)
            

      DATNAME=NameFile(iif:iif+lf-1)   ! set global variable to the new name   

      PathName=NameDir(id:id+ld-1)//NameFile(iif:iif+lf-1) 
      ld=ld+lf
      write(smes,201) NameFile(iif:iif+lf-1) ! trying this
      Open(Unit=i_IO,File=PathName(id:id+ld-1),
     *     Status='old',IOSTAT=ios,err=999)
      ierr=ios
     

C-----------------------------------------------------------------------------
C  *****   Try to read file HEADER *****   
C///  repeat searching cycle until:
C///  (a) the start of data section is reached ('DATA_' string is found),
C///  (b) the end of file is reached.
C----------------------------------------------------------------------------

      do 100 while ((ios.eq.0).AND.(idata.eq.0))
         read(i_IO,1,iostat=ios,err=100,end=110) CLine
         ilines=ilines+1
         call SpaceDel(CLine)      
         idata=index(CLine,'DATA_')
         CALL BOUNDS(CLine,is,il)
         is=index(CLine,'TITLE:')
         if (is.gt.0) TITLELINE= CLine(is+6:il)
         is=index(CLine,'COMND:')
         if (is.gt.0) CMDLINE= CLine(is+6:il)
           
C///  search for unit name:
         ip=index(CLine,'UN')                    ! energy units
         if((ip.ne.0).and.(.not.lun)) then
           cdl=cline(ip-1:ip-1)
           if(cdl.eq.' ') then          ! ' ' delimiter must precede 
              ip1=index(CLine(ip:),'=')
              if(ip1.ne.0) then                   
                read(CLine(ip+ip1:),2,iostat=ios) cun
                if(ios.eq.0) then
                  lun=.true.
                else
                  ios=0
                endif   
              endif
           endif                 
         endif
           
C///  search for QH,QK,QL,EN,DQH,DQK,DQL,DE in old format ('HKLE ' ident.) :           
                     
        ip=index(CLine,'HKLE ')              
        if((ip.ne.0).and.(.not.UsePar(i_QH))) then              
           read(CLine(ip+5:),*,iostat=ios) (ValPar(i),i=i_QH,i_DEN)
           if(ios.eq.0) then
             do i=i_QH,i_DEN
                UsePar(i)=.true.
             end do
             nuse=nuse+8
           else
             ios=0  
           endif            
        endif
           
C///  search for other parameters identified by ResPar(i) strings                   
                                         
        do i=1,RES_NVAR                          
          if(.not.UsePar(i)) then                
             L=index(ResPar(i),'=')-1
             ip=index(CLine,ResPar(i)(1:L))
             if(ip.ne.0) then
               cdl=' '
               if (ip.gt.1) cdl=cline(ip-1:ip-1)
               if(cdl.eq.' ') then   ! space must precede the identifier                                    
                 ip1=index(CLine(ip:),'=')             
                 if(ip1.ne.0) then   ! search for the value after =
                   read(CLine(ip+ip1:),*,iostat=ios) ValPar(i)                
                   if(ios.eq.0) then                 
                     UsePar(i)=.true.
                     nuse=nuse+1 
          if (idbg.gt.0) write(*,205) ResPar(i),ValPar(i)    ! for debug               
                   else
                     ios=0
                   endif
                 endif
               endif  
             endif
           endif  
        end do                                
100   continue

      if (nuse.gt.0) ierr=2 ! something from the header was read
      Close(i_IO)
      
110   IF((IOS.NE.0).OR.(IDATA.EQ.0)) THEN
        if (ierr.eq.2) then  ! no data, but header was read
          goto 180
        else
          GOTO 199
        endif
      ENDIF  

C// convert energy to meV if needed
180   if (lun) then
         if (UsePar(i_EN)) ValPar(i_EN)=ValPar(i_EN)/EUNI
         if (UsePar(i_DEN)) ValPar(i_DEN)=ValPar(i_DEN)/EUNI
         if (UsePar(i_GMOD)) ValPar(i_GMOD)=ValPar(i_GMOD)/EUNI
         call UNITS('m')
      endif

      DO i=1,RES_NVAR          
         IF (UsePar(I)) RES_DAT(I)=ValPar(I)
      ENDDO         

c      CALL RECLAT          !   compute reciprocal lattice parameters and matrices
c      CALL SCATTRIANGLE    !   compute and check KI,KF,Q and tras. matrix Lab -> CN

C/// set defaults if necessary
C-------------------------------------------------------------
299   CONTINUE
C set gradient of the dispersion surface
      IF(.NOT.(UsePar(i_GH).AND.UsePar(i_GK).AND.UsePar(i_GL))) THEN
        IF (ABS(RES_DAT(i_DQH))+ABS(RES_DAT(i_DQK))+
     *    ABS(RES_DAT(i_DQL)).GT.0) THEN ! scan is in Qhkl
          RES_DAT(i_GH)=RES_DAT(i_DQH)
          RES_DAT(i_GK)=RES_DAT(i_DQK)
          RES_DAT(i_GL)=RES_DAT(i_DQL)
        ELSE
          RES_DAT(i_GH)=RES_DAT(i_AX) ! scan Qhkl=const.
          RES_DAT(i_GK)=RES_DAT(i_AY)
          RES_DAT(i_GL)=RES_DAT(i_AZ)
        ENDIF
      ENDIF              

C set sample size
      IF(RES_DAT(i_SDI).LE.1.D-6) RES_DAT(i_SDI)=1.D0
      IF(RES_DAT(i_SHI).LE.1.D-6) RES_DAT(i_SHI)=1.D0
                
C set horizontal crystal curvature for perfect crystals
      IF(ABS(RES_DAT(i_ROMH)).LE.1.D-6.AND.RES_DAT(i_ETAM).LE.sec) THEN
         RES_DAT(i_ROMH)=1.D-1
      ENDIF     
      IF(ABS(RES_DAT(i_ROAH)).LE.1.D-6.AND.RES_DAT(i_ETAA).LE.sec) THEN
         RES_DAT(i_ROAH)=1.D-1
      ENDIF     

C/// print out information about data and ask for energy units if necessary
      if (SILENT.LE.1) THEN
        CALL BOUNDS(TITLELINE,is,il)
        write(sout,202) 'TITLE     : ',TITLELINE(is:is+il-1)
        CALL BOUNDS(CMDLINE,is,il)
        write(sout,202) 'COMMAND   : ',CMDLINE(is:is+il-1)           
        write(sout,202) 'FILE      : ',PathName(id:id+ld-1)
      endif  

      RETURN

999   if (SILENT.LE.2) write(sout,*) 'failed'      
      return

199   ierr=1
      Close(i_IO)   ! No spectrum read
      if (SILENT.LE.2) write(sout,*) 'not a regular data file'      
      return
           
      end    
      
C------------------------------------------------------------------     
      SUBROUTINE SpaceDel(CLine)
C     writes spaces instead of other delimiters (, ; TAB NULL)      
C------------------------------------------------------------------                 
      IMPLICIT NONE
      
      INTEGER*4 ip,ip1,L
      
      character*(*) CLine
      
      L=LEN(CLine)
      
      ip1=1
      ip=1
      DO 10 while (ip1.ne.0)
        ip1=index(CLine(ip:),';')
	if (ip1.eq.0) ip1=index(CLine(ip:),',')
	if (ip1.eq.0) ip1=index(CLine(ip:),'	')
	if (ip1.eq.0) ip1=index(CLine(ip:),CHAR(0))	
        if(ip1.ne.0) then
           CLine(ip1+ip-1:ip1+ip-1)=' '
           ip=ip+ip1
        endif
10    continue

      return
      end
                  
      
C------------------------------------------------------------------      
      SUBROUTINE SpecFileName(NameFile,ICOM)
C if NameFile  is an integer, convert it to ILL data filename   
C------------------------------------------------------------------                
      IMPLICIT NONE
      
      INTEGER*4 i,n,ICOM,ios
      INTEGER*4 IS,IL
      character*(*) NameFile 
      character*128 cstr,nfile
1     format(I5)
3     format(I7)

      CALL BOUNDS(NameFile,IS,IL)
      
      if(IL.ge.1) then
         nfile=NameFile(IS:IS+IL-1)//' '         
         read(nfile,*,iostat=ios) n         
         if((ios.eq.0).and.(n.gt.0).and.(n.lt.100000))  then  ! name is a positive integer
            if(ICOM.EQ.0) THEN                ! ILL name - old VMS format
               write(cstr,1,iostat=ios) n
               if(n.lt.10) then
                  NameFile='sv000'//cstr(5:5)//'.scn '     
               else  if(n.lt.100)  then
                  NameFile='sv00'//cstr(4:5)//'.scn '
               else  if(n.lt.1000)  then
                  NameFile='sv0'//cstr(3:5)//'.scn '
               else  
                  NameFile='sv'//cstr(2:5)//'.scn '
               endif
            else if(ICOM.EQ.1) THEN           ! ILL name - Unix
               write(cstr,3,iostat=ios) n
               do i=1,7
                  if(cstr(i:i).eq.' ') cstr(i:i)='0'
               end do
               NameFile=cstr(2:7)//' '
            endif                  
         endif
      endif        
      return
      end     

      
           
      
