C***************************************************************
      SUBROUTINE RESTRAX_HANDLE(SCOMM)
C  A wrapper to CMD_HANDLE for DLL export  
C***************************************************************
      IMPLICIT NONE      
      INCLUDE 'linp.inc'
      CHARACTER*(*) SCOMM
2     FORMAT(a,$)

      INTEGER*4 L      
      L=LEN(SCOMM)      
      CALL CMD_HANDLE(SCOMM(1:L))
      WRITE(linp_out,2) linp_p(1:linp_np)//'> ' 

      
      END

C***************************************************************
      SUBROUTINE CMD_HANDLE(SCOMM)
C  Main command handler for RESTRAX  
C  call CMD_HANDLE(' ') as the first command of RESTRAX and then 
C  any time you need to reset default menu
C***************************************************************
      IMPLICIT NONE      
      
      INCLUDE 'const.inc'
      INCLUDE 'inout.inc'
      INCLUDE 'rescal.inc'
      INCLUDE 'linp.inc'
c      INCLUDE 'restrax.inc'
      
      CHARACTER*(*) SCOMM
      INTEGER*4 ICOM,NPAR,L,I,IRES,IERR
      CHARACTER*128 LINE,LINPEXECSTR
      LOGICAL*4 CHECKPARAM
      INTEGER*4 INITIALIZED,TRUELEN
      DATA INITIALIZED /0/  
      DATA  NEEDBEFORE/.TRUE./   

2     FORMAT(a5,' = ',G12.6)
            
100   FORMAT(1X,70('-'))
200   FORMAT(1X,'RESTRAX Error: ',I4,/,1x,A)

      L=TRUELEN(SCOMM)
C first call => initialize RESTRAX
      IF (INITIALIZED.EQ.0) THEN        
        CALL RESINIT 
        INITIALIZED=1
      ENDIF  

C ignore comments and empty lines
      IF (L.LE.0.OR.SCOMM(1:1).EQ.'#') RETURN  
      
C send commands to linp
      IF (SCOMM(1:L).EQ.'SETLINP') THEN
        CALL LINPSET(RES_NVAR+RES_NCMD,'SimRes',RES_NAM,RES_HLP)
        CALL LINPSETIO(SINP,SOUT,SMES)
        RETURN
      ENDIF

      RES_NMSG=0
      RETSTR=' '
      LINE=' '      
      
C// process command string through LINP
      LINE=LINPEXECSTR(SCOMM(1:L),ICOM,NPAR)
      IF (ICOM.LT.0) RETURN  ! command not recognised

C// get numeric arguments       
      CALL GETLINPARG(LINE,RET,40,NOS) 

C// get the whole line as a string argument      
      IF (NPAR.GT.0) RETSTR=LINE

C// process input parameters
      IF (ICOM.GT.0.AND.ICOM.LE.RES_NVAR) THEN          
          IF (NOS.GT.RES_NVAR-ICOM+1) NOS=RES_NVAR-ICOM+1  
          IF (NOS.GT.0) THEN
            DO I=1,NOS
               RES_DAT(ICOM+I-1)=RET(I)
               RET(I)=ICOM+I-1
            ENDDO
            CALL LIST
            NOS=0
            NEEDBEFORE=.TRUE.
          ELSE
            WRITE(SOUT,2) RES_NAM(ICOM),RES_DAT(ICOM) 
          ENDIF
          RETURN 
      ENDIF           
           
C// do initialization if needed
      IF (NEEDBEFORE) THEN
          CALL BEFORE(IERR)
          NEEDBEFORE=(IERR.NE.0)
          IF (NEEDBEFORE) RETURN
      ENDIF  
   
C// process I/O commands
      IF (LINE(1:4).EQ.'LIST') THEN
          CALL LIST
      ELSE IF (RES_NAM(ICOM).EQ.'SAVE') THEN
          CALL WRITE_RESCAL(RETSTR,IRES)
      ELSE IF (RES_NAM(ICOM).EQ.'PATH') THEN
          CALL SETPATH(RETSTR)
      ELSE IF (RES_NAM(ICOM).EQ.'FILE') THEN
          CALL OPENFILE(RETSTR,IRES)
          NEEDBEFORE=(IRES.GT.0)
      ELSE IF (RES_NAM(ICOM).EQ.'BAT') THEN
          CALL REINP(RETSTR)    
          CALL LINPSETIO(SINP,SOUT,SMES)
      ELSE IF (RES_NAM(ICOM).EQ.'CFG') THEN
          CALL SETCFG(RETSTR)        
      ELSE IF (RES_NAM(ICOM).EQ.'CRYST') THEN
          CALL SET_3AX(8)
          NEEDBEFORE=.TRUE.
      ELSE IF (RES_NAM(ICOM).EQ.'GRFDE') THEN
          CALL SET_DEVICE(RETSTR) 
      ELSE IF (RES_NAM(ICOM).EQ.'PLOT') THEN
          CALL PLOTOUT(0)
      ELSE IF (RES_NAM(ICOM).EQ.'PRINT') THEN
          CALL PRINTOUT
      ELSE IF (RES_NAM(ICOM).EQ.'SETUP') THEN
          CALL TYPECFG
      ELSE IF (RES_NAM(ICOM).EQ.'SVOL') THEN
          CALL PLOTOUT(1)
      ELSE IF (RES_NAM(ICOM).EQ.'LPROF') THEN
          CALL PLOTOUT(2)         
      ELSE IF (RES_NAM(ICOM).EQ.'DPROF') THEN
          CALL PLOTOUT(3)
      ELSE IF (RES_NAM(ICOM).EQ.'TPROF') THEN
          CALL PLOTOUT(4)     
      ELSE IF (RES_NAM(ICOM).EQ.'MPROF') THEN
            CALL PLOTOUT(5)    
      ELSE IF (RES_NAM(ICOM).EQ.'SHELL') THEN
          CALL DOSHELL(RETSTR)
      ELSE IF (LINE(1:4).EQ.'LIST') THEN
          CALL LIST
      ELSE IF (RES_NAM(ICOM).EQ.'EXIT'.
     *           OR.LINE(1:4).EQ.'QUIT') THEN
             GOEND=1           
      ELSE IF (RES_NAM(ICOM).EQ.'EXFF') THEN
             GOEND=1           
C// process execution commands
      ELSE IF (ICOM.GT.RES_NVAR) THEN   !  other commands are treated outside
        IF (CHECKPARAM()) THEN
           CALL CMD_PROCESS(ICOM)
        ENDIF
        write(sout,100)
        IF (RES_NMSG.NE.0) WRITE(smes,200) RES_NMSG,RES_MSG
      ENDIF 
      
      IF (GOEND.NE.0) THEN
         INITIALIZED=0
         CALL RESEND
      ENDIF   

      END      

C***************************************************************
      SUBROUTINE CMD_PROCESS(ICMD)
C  Process RESTRAX  execution commands
C***************************************************************
      IMPLICIT NONE      
      INCLUDE 'const.inc'
      INCLUDE 'inout.inc'
      INCLUDE 'rescal.inc'
      INTEGER*4 ICMD
c      LOGICAL*4 CMDFILTER
      
!        write(*,*) 'Process ',ICMD
c      IF (.NOT.CMDFILTER(ICMD)) RETURN  ! filter for commands       
c      CALL MAKEMC(RES_NAM(ICMD))        ! call Monte Carlo if necessary (call IFNESS)
                          

      IF (RES_NAM(ICMD).EQ.'RO')  CALL GETRO(SOUT-1)
      IF (RES_NAM(ICMD).EQ.'MRO') CALL GETROOPTMC(SOUT-1)
      IF (RES_NAM(ICMD).EQ.'MONO') CALL SET_3AX(2)
      IF (RES_NAM(ICMD).EQ.'ANAL') CALL SET_3AX(21)
      IF (RES_NAM(ICMD).EQ.'THETA') CALL SET_3AX(3) 
      IF (RES_NAM(ICMD).EQ.'POLAR') CALL SET_3AX(7)
      IF (RES_NAM(ICMD).EQ.'FLIP') CALL SET_3AX(4) 
      IF (RES_NAM(ICMD).EQ.'MAG')  CALL SET_3AX(5) 
      IF (RES_NAM(ICMD).EQ.'SPIN') CALL SET_3AX(6) 
      IF (RES_NAM(ICMD).EQ.'FLX')  CALL SETVAR(1)
      IF (RES_NAM(ICMD).EQ.'TEMP') CALL SETVAR(2)
      IF (RES_NAM(ICMD).EQ.'SRCX') CALL SET_3AX(10)    
      IF (RES_NAM(ICMD).EQ.'SRCY') CALL SET_3AX(11)    
      IF (RES_NAM(ICMD).EQ.'OSC')  CALL SET_3AX(9)   
      IF (RES_NAM(ICMD).EQ.'SPOS')  CALL SET_3AX(1)
      IF (RES_NAM(ICMD).EQ.'EMOD')  CALL SET_3AX(13)
      IF (RES_NAM(ICMD).EQ.'AMOD')  CALL SET_3AX(12)
      IF (RES_NAM(ICMD).EQ.'FLUX')  CALL SAM_FLUX(1)
      IF (RES_NAM(ICMD).EQ.'NFLUX') CALL SAM_FLUX(0) 
      IF (RES_NAM(ICMD).EQ.'MONIT') CALL SAM_FLUX(2)
      IF (RES_NAM(ICMD).EQ.'ROCK')  CALL ROCK(1)
      IF (RES_NAM(ICMD).EQ.'AROCK') CALL ROCK(2)
      IF (RES_NAM(ICMD).EQ.'PWD')  CALL SAM_FLUX(4)
      IF (RES_NAM(ICMD).EQ.'PWDS') CALL SAM_FLUX(5)
      IF (RES_NAM(ICMD).EQ.'TAS')  CALL SAM_FLUX(3)
      IF (RES_NAM(ICMD).EQ.'BENCH') CALL BENCH
      IF (RES_NAM(ICMD).EQ.'SCHI') CALL SCAN_CHI(0)
      IF (RES_NAM(ICMD).EQ.'SCAN') CALL SCAN_THETA
      
C Setup might have changed => update TRAX and compare with previous configuration  
      IF ((RES_NAM(ICMD).EQ.'RO').OR.
     &     (RES_NAM(ICMD).EQ.'MRO').OR.
     &     (RES_NAM(ICMD).EQ.'OPTAS'))  NEEDBEFORE=.TRUE. 
      END
