C///////////////////////////////////////////////////////////////////////////
C////                                                                  
C////  strings.f - v.1.2, (c) J.Saroun, 1999-2001                      
C////                                                                
C////  String handling subroutines for RESTRAX                         
C////                                                              
C///////////////////////////////////////////////////////////////////////////
C////
C//// 
C////  CALL FINDPAR(LINE,IPAR,ISTART,ILEN)
C////   .... find possition of the IPAR-th parameter on the LINE
C//// 
C////  + other useful routines for handling strings
C////
C///////////////////////////////////////////////////////////////////////////

C     -----------------------------------------------------------------
      SUBROUTINE READ_R8(NAME, LINE, RESULT, IERR)
C     Read REAL*8 number from the LINE identified by NAME
C     suppose format "NAME=number " or "NAME number "
C     -----------------------------------------------------------------

      IMPLICIT NONE
      CHARACTER*(*) LINE,NAME
      INTEGER*4 L,ISTART,ILEN,I,INAME,LNAME,IERR
      REAL*8 Z,RESULT
      
      IERR=0
      CALL BOUNDS(NAME,INAME,LNAME)
      L=LEN(LINE)
      i=INDEX(LINE,NAME(INAME:INAME+LNAME-1))
C// identifier NAME found
      IF(i.GT.0) THEN   
        i=i+LNAME  ! i=first character after NAME
        ISTART=1
        CALL FINDPAR(LINE(i:L-i+1),1,ISTART,ILEN) ! find next substring
        ISTART=ISTART+i-1
C// skip the '=' character
        IF(ILEN.GE.1.AND.LINE(ISTART:ISTART).EQ.'=') ISTART=ISTART+1
C// try to read number from the rest of the line
        READ(LINE(ISTART:L),*,ERR=99) Z 
        RESULT=Z            
      ELSE
        IERR=-1 ! NAME not found
      ENDIF
      
      RETURN
99    IERR=-2   ! cannot read value
      END      
      
C     -----------------------------------------------------------------
      SUBROUTINE READ_I4(NAME,LINE,RESULT,IERR)
C     Read INTEGER*4 number from the LINE identified by NAME
C     suppose format "NAME=number " or "NAME number "
C     -----------------------------------------------------------------

      IMPLICIT NONE
      CHARACTER*(*) LINE,NAME
      INTEGER*4 L,ISTART,ILEN,I,INAME,LNAME,IERR
      INTEGER*4 Z,RESULT

      IERR=0      
      CALL BOUNDS(NAME,INAME,LNAME)
      L=LEN(LINE)
      i=INDEX(LINE,NAME(INAME:INAME+LNAME-1))
C// identifier NAME found
      IF(i.GT.0) THEN   
        i=i+LNAME  ! NAME ends before the i-th character
        ISTART=1
        CALL FINDPAR(LINE(i:L-i+1),1,ISTART,ILEN) ! find next substring
        ISTART=ISTART+i-1
C// skip the '=' character
        IF(ILEN.GE.1.AND.LINE(ISTART:ISTART).EQ.'=') ISTART=ISTART+1
C// try to read number from the rest of the line
        READ(LINE(ISTART:L),*,ERR=99) Z 
        RESULT=Z            
      ELSE
        IERR=-1 ! NAME not found
      ENDIF
      RETURN
99    IERR=-2   ! cannot read value
      END      
      
C     -----------------------------------------------------------------
      SUBROUTINE READ_STR(NAME,LINE,RESULT,IERR)
C     Read STRING from the LINE identified by NAME
C     suppose format "NAME=string"
C     -----------------------------------------------------------------

      IMPLICIT NONE
      CHARACTER*(*) LINE,NAME
      INTEGER*4 L,ISTART,ILEN,I,INAME,LNAME,IERR,LR
      CHARACTER*(*) RESULT
            
      IERR=0      
      CALL BOUNDS(NAME,INAME,LNAME)
      L=LEN(LINE)
      LR=LEN(RESULT)
      i=INDEX(LINE,NAME(INAME:INAME+LNAME-1)//'=')
      if (i.gt.1.AND.NAME(1:1).NE.'=') i=0  ! space delimiter must precede the name
c      write(*,*) I,L,' ',NAME
C// identifier NAME found
      IF(i.GT.0) THEN   
        i=i+LNAME+1  ! NAME= ends before the i-th character
c        write(*,*) i,' >'//LINE(i:L-i+1)
        ISTART=1
        CALL FINDPAR(LINE(i:L-i+1),1,ISTART,ILEN) ! find next substring
        IF (ILEN.GT.LR) ILEN=LR
        IF(ILEN.GT.0.AND.LINE(i+ISTART-1:i+ISTART-1).NE.' ') THEN
C// result is all after the delimiter (=)
          ISTART=ISTART+i-1
          RESULT=LINE(ISTART:ISTART+ILEN-1) 
        ELSE
          RESULT=' '        
        ENDIF                
      ELSE
        IERR=-1 ! NAME not found
      ENDIF
      
      END      

C     -----------------------------------------------------------------
      SUBROUTINE FINDPAR(LINE,IPAR,ISTART,ILEN)
C     Finds IPAR-th parameter found on LINE, starting from 
C     ISTART-th character 
C     returns starting position in ISTART and length in ILEN 
C     -----------------------------------------------------------------
      IMPLICIT NONE
      CHARACTER*(*) LINE
      INTEGER*4 L,i1,i2,IPAR,ISTART,ILEN,K      

1     FORMAT(A)

      ILEN=0
      
      L=LEN(LINE)
      i1=ISTART
      i2=0
      DO K=1,IPAR
        if (i1.lt.1) i1=1
        DO WHILE (i1.le.L.AND.LINE(i1:i1).EQ.' ')
         i1=i1+1
        END DO
        IF ((i1.eq.L.AND.LINE(i1:i1).EQ.' ').OR.(i1.GT.L)) THEN
          ISTART=0
          ILEN=0
          RETURN
        ENDIF    
        i2=i1
        DO WHILE (i2.le.L.AND.LINE(i2:i2).NE.' ')
         i2=i2+1
        END DO
        IF (K.LT.IPAR) I1=I2
      ENDDO  
      ILEN=I2-I1
      ISTART=I1
      END
      
C     ---------------------------------------------------
      CHARACTER*(*) FUNCTION STRIP(line)
C     removes initial and terminal spaces
C     ---------------------------------------------------
      IMPLICIT NONE
      CHARACTER*(*) line
      INTEGER*4 L,I
      L=LEN(line)
      IF (L.EQ.0) THEN
         STRIP=' '
         RETURN
      ENDIF   
      DO WHILE (line(L:L).EQ.' '.AND.L.GT.0)
         L=L-1
      ENDDO
      I=1
      DO WHILE (line(I:I).EQ.' '.AND.I.LT.L)
         I=I+1
      ENDDO
      IF (I.GT.L) THEN
         STRIP=' '
      ELSE
         STRIP=line(I:L) 
      ENDIF 
      END  

C     ---------------------------------------------------
      CHARACTER*(*) FUNCTION CONCAT(str1,str2)
C     connects 2 strings without spaces in between
C     ---------------------------------------------------
      IMPLICIT NONE
      CHARACTER*(*) str1,str2
      INTEGER*4 I1,I2,J1,J2
      CALL BOUNDS(str1,I1,J1)
      CALL BOUNDS(str2,I2,J2)
      CONCAT=str1(I1:I1+J1-1)//str2(I2:I2+J2-1)
      END
      
 
C     ---------------------------------------------------
      SUBROUTINE BOUNDS(line,ISTART,ILEN)
C     get position of string by stripping off the surrounding spaces
C     ---------------------------------------------------
      IMPLICIT NONE
      CHARACTER*(*) line
      INTEGER*4 L,I,ISTART,ILEN
      L=LEN(line)
      ISTART=1
      IF (L.EQ.0) THEN
         ILEN=0
         RETURN
      ENDIF   
      DO WHILE (line(L:L).EQ.' '.AND.L.GT.0)
         L=L-1
      ENDDO
      I=1
      DO WHILE (line(I:I).EQ.' '.AND.I.LT.L)
         I=I+1
      ENDDO
      IF (I.GT.L) THEN
         ILEN=0
      ELSE
         ISTART=I
         ILEN=L-I+1
      ENDIF 
      END  
     
c     ---------------------------------------------------
      SUBROUTINE STRCOMPACT(line,ISTART,ILEN)
C     remove multiplied spaces, return start (ISTART) and length (ILEN) of the resulting string
C     NOTE: line is modified !
C     ---------------------------------------------------
      IMPLICIT NONE
      CHARACTER*(*) line
      INTEGER*4 L,I,J,ISTART,ILEN
      L=LEN(line)
      I=1
      DO WHILE (I.LT.L)
        IF (LINE(I:I+1).EQ.'  ') THEN
           DO J=I+1,L-1 
             LINE(J:J)=LINE(J+1:J+1)
           ENDDO
           LINE(L:L)=' '
           L=L-1  
        ELSE
           I=I+1
        ENDIF
      ENDDO
      CALL BOUNDS(line,ISTART,ILEN)
      
      END  

C     -------------------------------------------------------------------
      INTEGER*4 FUNCTION TRUELEN(line)
C     return true length of the string 
C     (without trailing spaces or NULL characters)
C     -------------------------------------------------------------------
      IMPLICIT NONE
      CHARACTER*(*) line
      INTEGER*4 L
      TRUELEN=0
      L=LEN(line)
      IF (L.EQ.0) THEN
         TRUELEN=0
         RETURN
      ENDIF   
      DO WHILE (L.GT.0. AND.(line(L:L).EQ.' '.OR.line(L:L).EQ.char(0)))
         L=L-1
      ENDDO
      TRUELEN=L
      END 

C     ---------------------------------------------------
      SUBROUTINE WRITELINE(LINE,IU)
C     writes string without surrounding spaces 
C     ---------------------------------------------------
      IMPLICIT NONE
      CHARACTER*(*) LINE
      INTEGER*4 L,IS,IU
      CALL BOUNDS(LINE,IS,L)
1     FORMAT(a)
      WRITE(IU,1) LINE(IS:IS+L-1)
      END 
      

C     ---------------------------------------------------
      CHARACTER*(*) FUNCTION UPCASE(LINE)
C     converts LINE to uppercase     
C     ---------------------------------------------------
      IMPLICIT NONE
      CHARACTER*(*) LINE
      INTEGER*4 L,I
      L=LEN(LINE)
      DO i=1,L
         IF((LINE(i:i).GE.'a').AND.(LINE(i:i).LE.'z')) THEN
            UPCASE(i:i)=CHAR(ICHAR(LINE(i:i))-32)
         ELSE
            UPCASE(i:i)=LINE(i:i)   
         ENDIF  
      ENDDO 
      END

C     ---------------------------------------------------
      SUBROUTINE MKUPCASE(LINE)
C     converts LINE to uppercase     
C     ---------------------------------------------------
      IMPLICIT NONE
      CHARACTER*(*) LINE
      INTEGER*4 L,I
      L=LEN(LINE)
      DO i=1,L
         IF((LINE(i:i).GE.'a').AND.(LINE(i:i).LE.'z')) THEN
            LINE(i:i)=CHAR(ICHAR(LINE(i:i))-32)
         ENDIF  
      ENDDO 
      END


C     ---------------------------------------------------
      LOGICAL*4 FUNCTION IsNumber(LINE) 
c     true if LINE is a number 
C     ---------------------------------------------------
      IMPLICIT NONE
      CHARACTER*(*) LINE
      INTEGER*4 L
      REAL*8 RNUM
      L=LEN(LINE)
      IF (L.LE.0.OR.(INDEX('tTfF',LINE(1:1)).GT.0)) GOTO 10
      READ(LINE(1:L),*,err=10)  RNUM
      IsNumber=.TRUE.
      return
10    IsNumber=.FALSE.      
      END
      
C     ---------------------------------------------------
      LOGICAL*4 FUNCTION IsInteger(LINE) 
c     true if LINE is an integer 
C     ---------------------------------------------------
      IMPLICIT NONE
      CHARACTER*(*) LINE
      INTEGER*4 L
      INTEGER*4 INUM
      L=LEN(LINE)
      IF (L.LE.0.OR.(INDEX('tTfF',LINE(1:1)).GT.0)) GOTO 10
      READ(LINE(1:L),*,err=10)  INUM
      IsInteger=.TRUE.
      return
10    IsInteger=.FALSE.
      END
      

C---------------------------------------------------
      SUBROUTINE GETLINPARG(LINE,RET,N,NOS) 
C Get numerical arguments from the line and store them in RET
C---------------------------------------------------
      IMPLICIT NONE
      CHARACTER*(*) LINE
      INTEGER*4 NOS,N,IERR,IS,L,I
      REAL*8 RET(N)
      LOGICAL*4 IsNumber
      
      NOS=0
      DO I=1,N
         RET(I)=0
      ENDDO   
      IERR=0
      IS=1
      DO WHILE (IERR.EQ.0.AND.IS.LT.LEN(LINE))   ! read parameters
         CALL FINDPAR(LINE,1,IS,L)
         IF (L.GT.0) THEN
            IF (IsNumber(LINE(IS:IS+L-1))) THEN
              READ(LINE(IS:IS+L-1),*,IOSTAT=IERR,ERR=100) RET(NOS+1)
              NOS=NOS+1 
              IS=IS+L 
            ELSE
              IERR=1 
            ENDIF  
         ELSE
            IERR=1
         ENDIF
100      CONTINUE
      ENDDO
      END


